// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesRequest
type DescribeAffectedEntitiesInput struct {
	_ struct{} `type:"structure"`

	// Values to narrow the results returned. At least one event ARN is required.
	//
	// Filter is a required field
	Filter *EntityFilter `locationName:"filter" type:"structure" required:"true"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAffectedEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAffectedEntitiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAffectedEntitiesInput"}

	if s.Filter == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filter"))
	}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Locale", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesResponse
type DescribeAffectedEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// The entities that match the filter criteria.
	Entities []AffectedEntity `locationName:"entities" type:"list"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAffectedEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAffectedEntities = "DescribeAffectedEntities"

// DescribeAffectedEntitiesRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Returns a list of entities that have been affected by the specified events,
// based on the specified filter criteria. Entities can refer to individual
// customer resources, groups of customer resources, or any other construct,
// depending on the AWS service. Events that have impact beyond that of the
// affected entities, or where the extent of impact is unknown, include at least
// one entity indicating this.
//
// At least one event ARN is required. Results are sorted by the lastUpdatedTime
// of the entity, starting with the most recent.
//
//    // Example sending a request using DescribeAffectedEntitiesRequest.
//    req := client.DescribeAffectedEntitiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntities
func (c *Client) DescribeAffectedEntitiesRequest(input *DescribeAffectedEntitiesInput) DescribeAffectedEntitiesRequest {
	op := &aws.Operation{
		Name:       opDescribeAffectedEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAffectedEntitiesInput{}
	}

	req := c.newRequest(op, input, &DescribeAffectedEntitiesOutput{})
	return DescribeAffectedEntitiesRequest{Request: req, Input: input, Copy: c.DescribeAffectedEntitiesRequest}
}

// DescribeAffectedEntitiesRequest is the request type for the
// DescribeAffectedEntities API operation.
type DescribeAffectedEntitiesRequest struct {
	*aws.Request
	Input *DescribeAffectedEntitiesInput
	Copy  func(*DescribeAffectedEntitiesInput) DescribeAffectedEntitiesRequest
}

// Send marshals and sends the DescribeAffectedEntities API request.
func (r DescribeAffectedEntitiesRequest) Send(ctx context.Context) (*DescribeAffectedEntitiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAffectedEntitiesResponse{
		DescribeAffectedEntitiesOutput: r.Request.Data.(*DescribeAffectedEntitiesOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeAffectedEntitiesRequestPaginator returns a paginator for DescribeAffectedEntities.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeAffectedEntitiesRequest(input)
//   p := health.NewDescribeAffectedEntitiesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeAffectedEntitiesPaginator(req DescribeAffectedEntitiesRequest) DescribeAffectedEntitiesPaginator {
	return DescribeAffectedEntitiesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeAffectedEntitiesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeAffectedEntitiesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeAffectedEntitiesPaginator struct {
	aws.Pager
}

func (p *DescribeAffectedEntitiesPaginator) CurrentPage() *DescribeAffectedEntitiesOutput {
	return p.Pager.CurrentPage().(*DescribeAffectedEntitiesOutput)
}

// DescribeAffectedEntitiesResponse is the response type for the
// DescribeAffectedEntities API operation.
type DescribeAffectedEntitiesResponse struct {
	*DescribeAffectedEntitiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAffectedEntities request.
func (r *DescribeAffectedEntitiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
