// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResourceRequest
type ListLicenseSpecificationsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return in a single call. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`

	// ARN of an AMI or Amazon EC2 instance that has an associated license configuration.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListLicenseSpecificationsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLicenseSpecificationsForResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLicenseSpecificationsForResourceInput"}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResourceResponse
type ListLicenseSpecificationsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// License configurations associated with a resource.
	LicenseSpecifications []LicenseSpecification `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLicenseSpecificationsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLicenseSpecificationsForResource = "ListLicenseSpecificationsForResource"

// ListLicenseSpecificationsForResourceRequest returns a request value for making API operation for
// AWS License Manager.
//
// Returns the license configuration for a resource.
//
//    // Example sending a request using ListLicenseSpecificationsForResourceRequest.
//    req := client.ListLicenseSpecificationsForResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource
func (c *Client) ListLicenseSpecificationsForResourceRequest(input *ListLicenseSpecificationsForResourceInput) ListLicenseSpecificationsForResourceRequest {
	op := &aws.Operation{
		Name:       opListLicenseSpecificationsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLicenseSpecificationsForResourceInput{}
	}

	req := c.newRequest(op, input, &ListLicenseSpecificationsForResourceOutput{})
	return ListLicenseSpecificationsForResourceRequest{Request: req, Input: input, Copy: c.ListLicenseSpecificationsForResourceRequest}
}

// ListLicenseSpecificationsForResourceRequest is the request type for the
// ListLicenseSpecificationsForResource API operation.
type ListLicenseSpecificationsForResourceRequest struct {
	*aws.Request
	Input *ListLicenseSpecificationsForResourceInput
	Copy  func(*ListLicenseSpecificationsForResourceInput) ListLicenseSpecificationsForResourceRequest
}

// Send marshals and sends the ListLicenseSpecificationsForResource API request.
func (r ListLicenseSpecificationsForResourceRequest) Send(ctx context.Context) (*ListLicenseSpecificationsForResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLicenseSpecificationsForResourceResponse{
		ListLicenseSpecificationsForResourceOutput: r.Request.Data.(*ListLicenseSpecificationsForResourceOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListLicenseSpecificationsForResourceResponse is the response type for the
// ListLicenseSpecificationsForResource API operation.
type ListLicenseSpecificationsForResourceResponse struct {
	*ListLicenseSpecificationsForResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLicenseSpecificationsForResource request.
func (r *ListLicenseSpecificationsForResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
