// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastoredata

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-data-2017-09-01/DeleteObjectRequest
type DeleteObjectInput struct {
	_ struct{} `type:"structure"`

	// The path (including the file name) where the object is stored in the container.
	// Format: <folder name>/<folder name>/<file name>
	//
	// Path is a required field
	Path *string `location:"uri" locationName:"Path" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteObjectInput"}

	if s.Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-data-2017-09-01/DeleteObjectResponse
type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest returns a request value for making API operation for
// AWS Elemental MediaStore Data Plane.
//
// Deletes an object at the specified path.
//
//    // Example sending a request using DeleteObjectRequest.
//    req := client.DeleteObjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-data-2017-09-01/DeleteObject
func (c *Client) DeleteObjectRequest(input *DeleteObjectInput) DeleteObjectRequest {
	op := &aws.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Path+}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	req := c.newRequest(op, input, &DeleteObjectOutput{})
	return DeleteObjectRequest{Request: req, Input: input, Copy: c.DeleteObjectRequest}
}

// DeleteObjectRequest is the request type for the
// DeleteObject API operation.
type DeleteObjectRequest struct {
	*aws.Request
	Input *DeleteObjectInput
	Copy  func(*DeleteObjectInput) DeleteObjectRequest
}

// Send marshals and sends the DeleteObject API request.
func (r DeleteObjectRequest) Send(ctx context.Context) (*DeleteObjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteObjectResponse{
		DeleteObjectOutput: r.Request.Data.(*DeleteObjectOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteObjectResponse is the response type for the
// DeleteObject API operation.
type DeleteObjectResponse struct {
	*DeleteObjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteObject request.
func (r *DeleteObjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
