// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediatailor

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The configuration for using a content delivery network (CDN), like Amazon
// CloudFront, for content and ad segment management.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CdnConfiguration
type CdnConfiguration struct {
	_ struct{} `type:"structure"`

	// A non-default content delivery network (CDN) to serve ad segments. By default,
	// AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings
	// as its CDN for ad segments. To set up an alternate CDN, create a rule in
	// your CDN for the following origin: ads.mediatailor.<region>.amazonaws.com.
	// Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental
	// MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
	AdSegmentUrlPrefix *string `type:"string"`

	// A content delivery network (CDN) to cache content segments, so that content
	// requests don’t always have to go to the origin server. First, create a
	// rule in your CDN for the content segment origin server. Then specify the
	// rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor
	// serves a manifest, it reports your CDN as the source for content segments.
	ContentSegmentUrlPrefix *string `type:"string"`
}

// String returns the string representation
func (s CdnConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CdnConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdSegmentUrlPrefix != nil {
		v := *s.AdSegmentUrlPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AdSegmentUrlPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContentSegmentUrlPrefix != nil {
		v := *s.ContentSegmentUrlPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentSegmentUrlPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The configuration for DASH content.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DashConfiguration
type DashConfiguration struct {
	_ struct{} `type:"structure"`

	// The URL generated by MediaTailor to initiate a playback session. The session
	// uses server-side reporting. This setting is ignored in PUT operations.
	ManifestEndpointPrefix *string `type:"string"`

	// The setting that controls whether MediaTailor includes the Location tag in
	// DASH manifests. MediaTailor populates the Location tag with the URL for manifest
	// update requests, to be used by players that don't support sticky redirects.
	// Disable this if you have CDN routing rules set up for accessing MediaTailor
	// manifests, and you are either using client-side reporting or your players
	// support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT.
	// The EMT_DEFAULT setting enables the inclusion of the tag and is the default
	// value.
	MpdLocation *string `type:"string"`

	// The setting that controls whether MediaTailor handles manifests from the
	// origin server as multi-period manifests or single-period manifests. If your
	// origin server produces single-period manifests, set this to SINGLE_PERIOD.
	// The default setting is MULTI_PERIOD. For multi-period manifests, omit this
	// setting or set it to MULTI_PERIOD.
	OriginManifestType OriginManifestType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DashConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ManifestEndpointPrefix != nil {
		v := *s.ManifestEndpointPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ManifestEndpointPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MpdLocation != nil {
		v := *s.MpdLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MpdLocation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OriginManifestType) > 0 {
		v := s.OriginManifestType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginManifestType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The configuration for DASH PUT operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DashConfigurationForPut
type DashConfigurationForPut struct {
	_ struct{} `type:"structure"`

	// The setting that controls whether MediaTailor includes the Location tag in
	// DASH manifests. MediaTailor populates the Location tag with the URL for manifest
	// update requests, to be used by players that don't support sticky redirects.
	// Disable this if you have CDN routing rules set up for accessing MediaTailor
	// manifests, and you are either using client-side reporting or your players
	// support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT.
	// The EMT_DEFAULT setting enables the inclusion of the tag and is the default
	// value.
	MpdLocation *string `type:"string"`

	// The setting that controls whether MediaTailor handles manifests from the
	// origin server as multi-period manifests or single-period manifests. If your
	// origin server produces single-period manifests, set this to SINGLE_PERIOD.
	// The default setting is MULTI_PERIOD. For multi-period manifests, omit this
	// setting or set it to MULTI_PERIOD.
	OriginManifestType OriginManifestType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DashConfigurationForPut) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashConfigurationForPut) MarshalFields(e protocol.FieldEncoder) error {
	if s.MpdLocation != nil {
		v := *s.MpdLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MpdLocation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OriginManifestType) > 0 {
		v := s.OriginManifestType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginManifestType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The configuration for HLS content.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/HlsConfiguration
type HlsConfiguration struct {
	_ struct{} `type:"structure"`

	// The URL that is used to initiate a playback session for devices that support
	// Apple HLS. The session uses server-side reporting.
	ManifestEndpointPrefix *string `type:"string"`
}

// String returns the string representation
func (s HlsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ManifestEndpointPrefix != nil {
		v := *s.ManifestEndpointPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ManifestEndpointPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PlaybackConfiguration
type PlaybackConfiguration struct {
	_ struct{} `type:"structure"`

	AdDecisionServerUrl *string `type:"string"`

	// The configuration for using a content delivery network (CDN), like Amazon
	// CloudFront, for content and ad segment management.
	CdnConfiguration *CdnConfiguration `type:"structure"`

	// The configuration for DASH content.
	DashConfiguration *DashConfiguration `type:"structure"`

	// The configuration for HLS content.
	HlsConfiguration *HlsConfiguration `type:"structure"`

	Name *string `type:"string"`

	PlaybackConfigurationArn *string `type:"string"`

	PlaybackEndpointPrefix *string `type:"string"`

	SessionInitializationEndpointPrefix *string `type:"string"`

	SlateAdUrl *string `type:"string"`

	Tags map[string]string `locationName:"tags" type:"map"`

	TranscodeProfileName *string `type:"string"`

	VideoContentSourceUrl *string `type:"string"`
}

// String returns the string representation
func (s PlaybackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PlaybackConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdDecisionServerUrl != nil {
		v := *s.AdDecisionServerUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AdDecisionServerUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CdnConfiguration != nil {
		v := s.CdnConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CdnConfiguration", v, metadata)
	}
	if s.DashConfiguration != nil {
		v := s.DashConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DashConfiguration", v, metadata)
	}
	if s.HlsConfiguration != nil {
		v := s.HlsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HlsConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PlaybackConfigurationArn != nil {
		v := *s.PlaybackConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PlaybackConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PlaybackEndpointPrefix != nil {
		v := *s.PlaybackEndpointPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PlaybackEndpointPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SessionInitializationEndpointPrefix != nil {
		v := *s.SessionInitializationEndpointPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SessionInitializationEndpointPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SlateAdUrl != nil {
		v := *s.SlateAdUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SlateAdUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TranscodeProfileName != nil {
		v := *s.TranscodeProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TranscodeProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VideoContentSourceUrl != nil {
		v := *s.VideoContentSourceUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VideoContentSourceUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
