// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroupMessage
type DeleteDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group to delete.
	//
	// You can't delete the default DB security group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	//    * Must not be "Default"
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSecurityGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDBSecurityGroupInput"}

	if s.DBSecurityGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroupOutput
type DeleteDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDBSecurityGroup = "DeleteDBSecurityGroup"

// DeleteDBSecurityGroupRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Deletes a DB security group.
//
// The specified DB security group must not be associated with any DB instances.
//
//    // Example sending a request using DeleteDBSecurityGroupRequest.
//    req := client.DeleteDBSecurityGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup
func (c *Client) DeleteDBSecurityGroupRequest(input *DeleteDBSecurityGroupInput) DeleteDBSecurityGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSecurityGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteDBSecurityGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteDBSecurityGroupRequest{Request: req, Input: input, Copy: c.DeleteDBSecurityGroupRequest}
}

// DeleteDBSecurityGroupRequest is the request type for the
// DeleteDBSecurityGroup API operation.
type DeleteDBSecurityGroupRequest struct {
	*aws.Request
	Input *DeleteDBSecurityGroupInput
	Copy  func(*DeleteDBSecurityGroupInput) DeleteDBSecurityGroupRequest
}

// Send marshals and sends the DeleteDBSecurityGroup API request.
func (r DeleteDBSecurityGroupRequest) Send(ctx context.Context) (*DeleteDBSecurityGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDBSecurityGroupResponse{
		DeleteDBSecurityGroupOutput: r.Request.Data.(*DeleteDBSecurityGroupOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDBSecurityGroupResponse is the response type for the
// DeleteDBSecurityGroup API operation.
type DeleteDBSecurityGroupResponse struct {
	*DeleteDBSecurityGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDBSecurityGroup request.
func (r *DeleteDBSecurityGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
