// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshotMessage
type DeleteClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster the snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints: Must be the name of valid cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// The unique identifier of the manual snapshot to be deleted.
	//
	// Constraints: Must be the name of an existing snapshot that is in the available,
	// failed, or cancelled state.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClusterSnapshotInput"}

	if s.SnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshotResult
type DeleteClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteClusterSnapshot = "DeleteClusterSnapshot"

// DeleteClusterSnapshotRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Deletes the specified manual snapshot. The snapshot must be in the available
// state, with no other users authorized to access the snapshot.
//
// Unlike automated snapshots, manual snapshots are retained even after you
// delete your cluster. Amazon Redshift does not delete your manual snapshots.
// You must delete manual snapshot explicitly to avoid getting charged. If other
// accounts are authorized to access the snapshot, you must revoke all of the
// authorizations before you can delete the snapshot.
//
//    // Example sending a request using DeleteClusterSnapshotRequest.
//    req := client.DeleteClusterSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot
func (c *Client) DeleteClusterSnapshotRequest(input *DeleteClusterSnapshotInput) DeleteClusterSnapshotRequest {
	op := &aws.Operation{
		Name:       opDeleteClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSnapshotInput{}
	}

	req := c.newRequest(op, input, &DeleteClusterSnapshotOutput{})
	return DeleteClusterSnapshotRequest{Request: req, Input: input, Copy: c.DeleteClusterSnapshotRequest}
}

// DeleteClusterSnapshotRequest is the request type for the
// DeleteClusterSnapshot API operation.
type DeleteClusterSnapshotRequest struct {
	*aws.Request
	Input *DeleteClusterSnapshotInput
	Copy  func(*DeleteClusterSnapshotInput) DeleteClusterSnapshotRequest
}

// Send marshals and sends the DeleteClusterSnapshot API request.
func (r DeleteClusterSnapshotRequest) Send(ctx context.Context) (*DeleteClusterSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteClusterSnapshotResponse{
		DeleteClusterSnapshotOutput: r.Request.Data.(*DeleteClusterSnapshotOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteClusterSnapshotResponse is the response type for the
// DeleteClusterSnapshot API operation.
type DeleteClusterSnapshotResponse struct {
	*DeleteClusterSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteClusterSnapshot request.
func (r *DeleteClusterSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
