// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParametersMessage
type DescribeClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameters request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a cluster parameter group for which to return details.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// The parameter types to return. Specify user to show parameters that are different
	// form the default. Similarly, specify engine-default to show parameters that
	// are the same as the default parameter group.
	//
	// Default: All parameter types returned.
	//
	// Valid Values: user | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterParametersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeClusterParametersInput"}

	if s.ParameterGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output from the DescribeClusterParameters action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroupDetails
type DescribeClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of Parameter instances. Each instance lists the parameters of one
	// cluster parameter group.
	Parameters []Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClusterParameters = "DescribeClusterParameters"

// DescribeClusterParametersRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns a detailed list of parameters contained within the specified Amazon
// Redshift parameter group. For each parameter the response includes information
// such as parameter name, description, data type, value, whether the parameter
// value is modifiable, and so on.
//
// You can specify source filter to retrieve parameters of only specific type.
// For example, to retrieve parameters that were modified by a user action such
// as from ModifyClusterParameterGroup, you can specify source equal to user.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using DescribeClusterParametersRequest.
//    req := client.DescribeClusterParametersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters
func (c *Client) DescribeClusterParametersRequest(input *DescribeClusterParametersInput) DescribeClusterParametersRequest {
	op := &aws.Operation{
		Name:       opDescribeClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParametersInput{}
	}

	req := c.newRequest(op, input, &DescribeClusterParametersOutput{})
	return DescribeClusterParametersRequest{Request: req, Input: input, Copy: c.DescribeClusterParametersRequest}
}

// DescribeClusterParametersRequest is the request type for the
// DescribeClusterParameters API operation.
type DescribeClusterParametersRequest struct {
	*aws.Request
	Input *DescribeClusterParametersInput
	Copy  func(*DescribeClusterParametersInput) DescribeClusterParametersRequest
}

// Send marshals and sends the DescribeClusterParameters API request.
func (r DescribeClusterParametersRequest) Send(ctx context.Context) (*DescribeClusterParametersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClusterParametersResponse{
		DescribeClusterParametersOutput: r.Request.Data.(*DescribeClusterParametersOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeClusterParametersRequestPaginator returns a paginator for DescribeClusterParameters.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeClusterParametersRequest(input)
//   p := redshift.NewDescribeClusterParametersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeClusterParametersPaginator(req DescribeClusterParametersRequest) DescribeClusterParametersPaginator {
	return DescribeClusterParametersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeClusterParametersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeClusterParametersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeClusterParametersPaginator struct {
	aws.Pager
}

func (p *DescribeClusterParametersPaginator) CurrentPage() *DescribeClusterParametersOutput {
	return p.Pager.CurrentPage().(*DescribeClusterParametersOutput)
}

// DescribeClusterParametersResponse is the response type for the
// DescribeClusterParameters API operation.
type DescribeClusterParametersResponse struct {
	*DescribeClusterParametersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClusterParameters request.
func (r *DescribeClusterParametersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
