// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopyMessage
type DisableSnapshotCopyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the source cluster that you want to disable copying
	// of snapshots to a destination region.
	//
	// Constraints: Must be the valid name of an existing cluster that has cross-region
	// snapshot copy enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableSnapshotCopyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableSnapshotCopyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableSnapshotCopyInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopyResult
type DisableSnapshotCopyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DisableSnapshotCopyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableSnapshotCopy = "DisableSnapshotCopy"

// DisableSnapshotCopyRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Disables the automatic copying of snapshots from one region to another region
// for a specified cluster.
//
// If your cluster and its snapshots are encrypted using a customer master key
// (CMK) from AWS KMS, use DeleteSnapshotCopyGrant to delete the grant that
// grants Amazon Redshift permission to the CMK in the destination region.
//
//    // Example sending a request using DisableSnapshotCopyRequest.
//    req := client.DisableSnapshotCopyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy
func (c *Client) DisableSnapshotCopyRequest(input *DisableSnapshotCopyInput) DisableSnapshotCopyRequest {
	op := &aws.Operation{
		Name:       opDisableSnapshotCopy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSnapshotCopyInput{}
	}

	req := c.newRequest(op, input, &DisableSnapshotCopyOutput{})
	return DisableSnapshotCopyRequest{Request: req, Input: input, Copy: c.DisableSnapshotCopyRequest}
}

// DisableSnapshotCopyRequest is the request type for the
// DisableSnapshotCopy API operation.
type DisableSnapshotCopyRequest struct {
	*aws.Request
	Input *DisableSnapshotCopyInput
	Copy  func(*DisableSnapshotCopyInput) DisableSnapshotCopyRequest
}

// Send marshals and sends the DisableSnapshotCopy API request.
func (r DisableSnapshotCopyRequest) Send(ctx context.Context) (*DisableSnapshotCopyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableSnapshotCopyResponse{
		DisableSnapshotCopyOutput: r.Request.Data.(*DisableSnapshotCopyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableSnapshotCopyResponse is the response type for the
// DisableSnapshotCopy API operation.
type DisableSnapshotCopyResponse struct {
	*DisableSnapshotCopyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableSnapshotCopy request.
func (r *DisableSnapshotCopyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
