// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateCollectionInput struct {
	_ struct{} `type:"structure"`

	// ID for the collection that you are creating.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCollectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCollectionInput"}

	if s.CollectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CollectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateCollectionOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the collection. You can use this to manage
	// permissions on your resources.
	CollectionArn *string `type:"string"`

	// Version number of the face detection model associated with the collection
	// you are creating.
	FaceModelVersion *string `type:"string"`

	// HTTP status code indicating the result of the operation.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCollection = "CreateCollection"

// CreateCollectionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Creates a collection in an AWS Region. You can add faces to the collection
// using the IndexFaces operation.
//
// For example, you might create collections, one for each of your application
// users. A user can then index faces using the IndexFaces operation and persist
// results in a specific collection. Then, a user can search the collection
// for faces in the user-specific container.
//
// When you create a collection, it is associated with the latest version of
// the face model version.
//
// Collection names are case-sensitive.
//
// This operation requires permissions to perform the rekognition:CreateCollection
// action.
//
//    // Example sending a request using CreateCollectionRequest.
//    req := client.CreateCollectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateCollectionRequest(input *CreateCollectionInput) CreateCollectionRequest {
	op := &aws.Operation{
		Name:       opCreateCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCollectionInput{}
	}

	req := c.newRequest(op, input, &CreateCollectionOutput{})
	return CreateCollectionRequest{Request: req, Input: input, Copy: c.CreateCollectionRequest}
}

// CreateCollectionRequest is the request type for the
// CreateCollection API operation.
type CreateCollectionRequest struct {
	*aws.Request
	Input *CreateCollectionInput
	Copy  func(*CreateCollectionInput) CreateCollectionRequest
}

// Send marshals and sends the CreateCollection API request.
func (r CreateCollectionRequest) Send(ctx context.Context) (*CreateCollectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCollectionResponse{
		CreateCollectionOutput: r.Request.Data.(*CreateCollectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCollectionResponse is the response type for the
// CreateCollection API operation.
type CreateCollectionResponse struct {
	*CreateCollectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCollection request.
func (r *CreateCollectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
