// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroups

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQueryInput
type GetGroupQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupQueryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupQueryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGroupQueryInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGroupQueryInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQueryOutput
type GetGroupQueryOutput struct {
	_ struct{} `type:"structure"`

	// The resource query associated with the specified group.
	GroupQuery *GroupQuery `type:"structure"`
}

// String returns the string representation
func (s GetGroupQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGroupQueryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupQuery != nil {
		v := s.GroupQuery

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GroupQuery", v, metadata)
	}
	return nil
}

const opGetGroupQuery = "GetGroupQuery"

// GetGroupQueryRequest returns a request value for making API operation for
// AWS Resource Groups.
//
// Returns the resource query associated with the specified resource group.
//
//    // Example sending a request using GetGroupQueryRequest.
//    req := client.GetGroupQueryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQuery
func (c *Client) GetGroupQueryRequest(input *GetGroupQueryInput) GetGroupQueryRequest {
	op := &aws.Operation{
		Name:       opGetGroupQuery,
		HTTPMethod: "GET",
		HTTPPath:   "/groups/{GroupName}/query",
	}

	if input == nil {
		input = &GetGroupQueryInput{}
	}

	req := c.newRequest(op, input, &GetGroupQueryOutput{})
	return GetGroupQueryRequest{Request: req, Input: input, Copy: c.GetGroupQueryRequest}
}

// GetGroupQueryRequest is the request type for the
// GetGroupQuery API operation.
type GetGroupQueryRequest struct {
	*aws.Request
	Input *GetGroupQueryInput
	Copy  func(*GetGroupQueryInput) GetGroupQueryRequest
}

// Send marshals and sends the GetGroupQuery API request.
func (r GetGroupQueryRequest) Send(ctx context.Context) (*GetGroupQueryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGroupQueryResponse{
		GetGroupQueryOutput: r.Request.Data.(*GetGroupQueryOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGroupQueryResponse is the response type for the
// GetGroupQuery API operation.
type GetGroupQueryResponse struct {
	*GetGroupQueryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGroupQuery request.
func (r *GetGroupQueryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
