// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package secretsmanager

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecretRequest
type CreateSecretInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If you include SecretString or SecretBinary, then an initial version
	// is created as part of the secret, and this parameter specifies a unique identifier
	// for the new version.
	//
	// If you use the AWS CLI or one of the AWS SDK to call this operation, then
	// you can leave this parameter empty. The CLI or SDK generates a random UUID
	// for you and includes it as the value for this parameter in the request. If
	// you don't use the SDK and instead generate a raw HTTP request to the Secrets
	// Manager service endpoint, then you must generate a ClientRequestToken yourself
	// for the new version and include that value in the request.
	//
	// This value helps ensure idempotency. Secrets Manager uses this value to prevent
	// the accidental creation of duplicate versions if there are failures and retries
	// during a rotation. We recommend that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness of your versions within the specified secret.
	//
	//    * If the ClientRequestToken value isn't already associated with a version
	//    of the secret then a new version of the secret is created.
	//
	//    * If a version with this value already exists and that version's SecretString
	//    and SecretBinary values are the same as those in the request, then the
	//    request is ignored (the operation is idempotent).
	//
	//    * If a version with this value already exists and that version's SecretString
	//    and SecretBinary values are different from those in the request then the
	//    request fails because you cannot modify an existing version. Instead,
	//    use PutSecretValue to create a new version.
	//
	// This value becomes the VersionId of the new version.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// (Optional) Specifies a user-provided description of the secret.
	Description *string `type:"string"`

	// (Optional) Specifies the ARN, Key ID, or alias of the AWS KMS customer master
	// key (CMK) to be used to encrypt the SecretString or SecretBinary values in
	// the versions stored in this secret.
	//
	// You can specify any of the supported ways to identify a AWS KMS key ID. If
	// you need to reference a CMK in a different account, you can use only the
	// key ARN or the alias ARN.
	//
	// If you don't specify this value, then Secrets Manager defaults to using the
	// AWS account's default CMK (the one named aws/secretsmanager). If a AWS KMS
	// CMK with that name doesn't yet exist, then Secrets Manager creates it for
	// you automatically the first time it needs to encrypt a version's SecretString
	// or SecretBinary fields.
	//
	// You can use the account's default CMK to encrypt and decrypt only if you
	// call this operation using credentials from the same account that owns the
	// secret. If the secret is in a different account, then you must create a custom
	// CMK and specify the ARN in this field.
	KmsKeyId *string `type:"string"`

	// Specifies the friendly name of the new secret.
	//
	// The secret name must be ASCII letters, digits, or the following characters
	// : /_+=.@-
	//
	// Don't end your secret name with a hyphen followed by six characters. If you
	// do so, you risk confusion and unexpected results when searching for a secret
	// by partial ARN. This is because Secrets Manager automatically adds a hyphen
	// and six random characters at the end of the ARN.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// (Optional) Specifies binary data that you want to encrypt and store in the
	// new version of the secret. To use this parameter in the command-line tools,
	// we recommend that you store your binary data in a file and then use the appropriate
	// technique for your tool to pass the contents of the file as a parameter.
	//
	// Either SecretString or SecretBinary must have a value, but not both. They
	// cannot both be empty.
	//
	// This parameter is not available using the Secrets Manager console. It can
	// be accessed only by using the AWS CLI or one of the AWS SDKs.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `type:"blob"`

	// (Optional) Specifies text data that you want to encrypt and store in this
	// new version of the secret.
	//
	// Either SecretString or SecretBinary must have a value, but not both. They
	// cannot both be empty.
	//
	// If you create a secret by using the Secrets Manager console then Secrets
	// Manager puts the protected secret text in only the SecretString parameter.
	// The Secrets Manager console stores the information as a JSON structure of
	// key/value pairs that the Lambda rotation function knows how to parse.
	//
	// For storing multiple values, we recommend that you use a JSON text string
	// argument and specify key/value pairs. For information on how to format a
	// JSON parameter for the various command line tool environments, see Using
	// JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the AWS CLI User Guide. For example:
	//
	// [{"username":"bob"},{"password":"abc123xyz456"}]
	//
	// If your command-line tool or SDK requires quotation marks around the parameter,
	// you should use single quotes to avoid confusion with the double quotes required
	// in the JSON text.
	SecretString *string `type:"string"`

	// (Optional) Specifies a list of user-defined tags that are attached to the
	// secret. Each tag is a "Key" and "Value" pair of strings. This operation only
	// appends tags to the existing list of tags. To remove tags, you must use UntagResource.
	//
	//    * Secrets Manager tag key names are case sensitive. A tag with the key
	//    "ABC" is a different tag from one with key "abc".
	//
	//    * If you check tags in IAM policy Condition elements as part of your security
	//    strategy, then adding or removing a tag can change permissions. If the
	//    successful completion of this operation would result in you losing your
	//    permissions for this secret, then this operation is blocked and returns
	//    an Access Denied error.
	//
	// This parameter requires a JSON text string argument. For information on how
	// to format a JSON parameter for the various command line tool environments,
	// see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the AWS CLI User Guide. For example:
	//
	// [{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]
	//
	// If your command-line tool or SDK requires quotation marks around the parameter,
	// you should use single quotes to avoid confusion with the double quotes required
	// in the JSON text.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per secret—50
	//
	//    * Maximum key length—127 Unicode characters in UTF-8
	//
	//    * Maximum value length—255 Unicode characters in UTF-8
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use the aws: prefix in your tag names or values because it is
	//    reserved for AWS use. You can't edit or delete tag names or values with
	//    this prefix. Tags with this prefix do not count against your tags per
	//    secret limit.
	//
	//    * If your tagging schema will be used across multiple services and resources,
	//    remember that other services might have restrictions on allowed characters.
	//    Generally allowed characters are: letters, spaces, and numbers representable
	//    in UTF-8, plus the following special characters: + - = . _ : / @.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecretInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSecretInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 32))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecretResponse
type CreateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret that you just created.
	//
	// Secrets Manager automatically adds several random characters to the name
	// at the end of the ARN when you initially create a secret. This affects only
	// the ARN and not the actual friendly name. This ensures that if you create
	// a new secret with the same name as an old secret that you previously deleted,
	// then users with access to the old secret don't automatically get access to
	// the new secret because the ARNs are different.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret that you just created.
	Name *string `min:"1" type:"string"`

	// The unique identifier that's associated with the version of the secret you
	// just created.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation
func (s CreateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSecret = "CreateSecret"

// CreateSecretRequest returns a request value for making API operation for
// AWS Secrets Manager.
//
// Creates a new secret. A secret in Secrets Manager consists of both the protected
// secret data and the important information needed to manage the secret.
//
// Secrets Manager stores the encrypted secret data in one of a collection of
// "versions" associated with the secret. Each version contains a copy of the
// encrypted secret data. Each version is associated with one or more "staging
// labels" that identify where the version is in the rotation cycle. The SecretVersionsToStages
// field of the secret contains the mapping of staging labels to the active
// versions of the secret. Versions without a staging label are considered deprecated
// and are not included in the list.
//
// You provide the secret data to be encrypted by putting text in either the
// SecretString parameter or binary data in the SecretBinary parameter, but
// not both. If you include SecretString or SecretBinary then Secrets Manager
// also creates an initial secret version and automatically attaches the staging
// label AWSCURRENT to the new version.
//
//    * If you call an operation that needs to encrypt or decrypt the SecretString
//    or SecretBinary for a secret in the same account as the calling user and
//    that secret doesn't specify a AWS KMS encryption key, Secrets Manager
//    uses the account's default AWS managed customer master key (CMK) with
//    the alias aws/secretsmanager. If this key doesn't already exist in your
//    account then Secrets Manager creates it for you automatically. All users
//    and roles in the same AWS account automatically have access to use the
//    default CMK. Note that if an Secrets Manager API call results in AWS having
//    to create the account's AWS-managed CMK, it can result in a one-time significant
//    delay in returning the result.
//
//    * If the secret is in a different AWS account from the credentials calling
//    an API that requires encryption or decryption of the secret value then
//    you must create and use a custom AWS KMS CMK because you can't access
//    the default CMK for the account using credentials from a different AWS
//    account. Store the ARN of the CMK in the secret when you create the secret
//    or when you update it by including it in the KMSKeyId. If you call an
//    API that must encrypt or decrypt SecretString or SecretBinary using credentials
//    from a different account then the AWS KMS key policy must grant cross-account
//    access to that other account's user or role for both the kms:GenerateDataKey
//    and kms:Decrypt operations.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:CreateSecret
//
//    * kms:GenerateDataKey - needed only if you use a customer-managed AWS
//    KMS key to encrypt the secret. You do not need this permission to use
//    the account's default AWS managed CMK for Secrets Manager.
//
//    * kms:Decrypt - needed only if you use a customer-managed AWS KMS key
//    to encrypt the secret. You do not need this permission to use the account's
//    default AWS managed CMK for Secrets Manager.
//
//    * secretsmanager:TagResource - needed only if you include the Tags parameter.
//
// Related operations
//
//    * To delete a secret, use DeleteSecret.
//
//    * To modify an existing secret, use UpdateSecret.
//
//    * To create a new version of a secret, use PutSecretValue.
//
//    * To retrieve the encrypted secure string and secure binary values, use
//    GetSecretValue.
//
//    * To retrieve all other details for a secret, use DescribeSecret. This
//    does not include the encrypted secure string and secure binary values.
//
//    * To retrieve the list of secret versions associated with the current
//    secret, use DescribeSecret and examine the SecretVersionsToStages response
//    value.
//
//    // Example sending a request using CreateSecretRequest.
//    req := client.CreateSecretRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecret
func (c *Client) CreateSecretRequest(input *CreateSecretInput) CreateSecretRequest {
	op := &aws.Operation{
		Name:       opCreateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecretInput{}
	}

	req := c.newRequest(op, input, &CreateSecretOutput{})
	return CreateSecretRequest{Request: req, Input: input, Copy: c.CreateSecretRequest}
}

// CreateSecretRequest is the request type for the
// CreateSecret API operation.
type CreateSecretRequest struct {
	*aws.Request
	Input *CreateSecretInput
	Copy  func(*CreateSecretInput) CreateSecretRequest
}

// Send marshals and sends the CreateSecret API request.
func (r CreateSecretRequest) Send(ctx context.Context) (*CreateSecretResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSecretResponse{
		CreateSecretOutput: r.Request.Data.(*CreateSecretOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSecretResponse is the response type for the
// CreateSecret API operation.
type CreateSecretResponse struct {
	*CreateSecretOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSecret request.
func (r *CreateSecretResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
