// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The access level to use to filter results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AccessLevelFilter
type AccessLevelFilter struct {
	_ struct{} `type:"structure"`

	// The access level.
	//
	//    * Account - Filter results based on the account.
	//
	//    * Role - Filter results based on the federated role of the specified user.
	//
	//    * User - Filter results based on the specified user.
	Key AccessLevelFilterKey `type:"string" enum:"true"`

	// The user to which the access level applies. The only supported value is Self.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AccessLevelFilter) String() string {
	return awsutil.Prettify(s)
}

// Information about a budget.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BudgetDetail
type BudgetDetail struct {
	_ struct{} `type:"structure"`

	// Name of the associated budget.
	BudgetName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BudgetDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about a CloudWatch dashboard.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CloudWatchDashboard
type CloudWatchDashboard struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch dashboard.
	Name *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchDashboard) String() string {
	return awsutil.Prettify(s)
}

// Information about a constraint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ConstraintDetail
type ConstraintDetail struct {
	_ struct{} `type:"structure"`

	// The identifier of the constraint.
	ConstraintId *string `min:"1" type:"string"`

	// The description of the constraint.
	Description *string `type:"string"`

	// The owner of the constraint.
	Owner *string `type:"string"`

	// The type of constraint.
	//
	//    * LAUNCH
	//
	//    * NOTIFICATION
	//
	//    * STACKSET
	//
	//    * TEMPLATE
	Type *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConstraintDetail) String() string {
	return awsutil.Prettify(s)
}

// Summary information about a constraint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ConstraintSummary
type ConstraintSummary struct {
	_ struct{} `type:"structure"`

	// The description of the constraint.
	Description *string `type:"string"`

	// The type of constraint.
	//
	//    * LAUNCH
	//
	//    * NOTIFICATION
	//
	//    * STACKSET
	//
	//    * TEMPLATE
	Type *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConstraintSummary) String() string {
	return awsutil.Prettify(s)
}

// An object containing information about the error, along with identifying
// information about the self-service action and its associations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/FailedServiceActionAssociation
type FailedServiceActionAssociation struct {
	_ struct{} `type:"structure"`

	// The error code. Valid values are listed below.
	ErrorCode ServiceActionAssociationErrorCode `type:"string" enum:"true"`

	// A text description of the error.
	ErrorMessage *string `min:"1" type:"string"`

	// The product identifier. For example, prod-abcdzk7xy33qa.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// The self-service action identifier. For example, act-fs7abcd89wxyz.
	ServiceActionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FailedServiceActionAssociation) String() string {
	return awsutil.Prettify(s)
}

// Summary information about a product path for a user.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/LaunchPathSummary
type LaunchPathSummary struct {
	_ struct{} `type:"structure"`

	// The constraints on the portfolio-product relationship.
	ConstraintSummaries []ConstraintSummary `type:"list"`

	// The identifier of the product path.
	Id *string `min:"1" type:"string"`

	// The name of the portfolio to which the user was assigned.
	Name *string `type:"string"`

	// The tags associated with this product path.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s LaunchPathSummary) String() string {
	return awsutil.Prettify(s)
}

// The search filter to use when listing history records.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistorySearchFilter
type ListRecordHistorySearchFilter struct {
	_ struct{} `type:"structure"`

	// The filter key.
	//
	//    * product - Filter results based on the specified product identifier.
	//
	//    * provisionedproduct - Filter results based on the provisioned product
	//    identifier.
	Key *string `type:"string"`

	// The filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ListRecordHistorySearchFilter) String() string {
	return awsutil.Prettify(s)
}

// Filters to use when listing TagOptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptionsFilters
type ListTagOptionsFilters struct {
	_ struct{} `type:"structure"`

	// The active state.
	Active *bool `type:"boolean"`

	// The TagOption key.
	Key *string `min:"1" type:"string"`

	// The TagOption value.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTagOptionsFilters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagOptionsFilters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTagOptionsFilters"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the organization node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/OrganizationNode
type OrganizationNode struct {
	_ struct{} `type:"structure"`

	// The organization node type.
	Type OrganizationNodeType `type:"string" enum:"true"`

	// The identifier of the organization node.
	Value *string `type:"string"`
}

// String returns the string representation
func (s OrganizationNode) String() string {
	return awsutil.Prettify(s)
}

// The constraints that the administrator has put on the parameter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ParameterConstraints
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// The values that the administrator has allowed for the parameter.
	AllowedValues []string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// Information about a portfolio.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/PortfolioDetail
type PortfolioDetail struct {
	_ struct{} `type:"structure"`

	// The ARN assigned to the portfolio.
	ARN *string `min:"1" type:"string"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the portfolio.
	Description *string `type:"string"`

	// The name to use for display purposes.
	DisplayName *string `min:"1" type:"string"`

	// The portfolio identifier.
	Id *string `min:"1" type:"string"`

	// The name of the portfolio provider.
	ProviderName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PortfolioDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about a principal.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/Principal
type Principal struct {
	_ struct{} `type:"structure"`

	// The ARN of the principal (IAM user, role, or group).
	PrincipalARN *string `min:"1" type:"string"`

	// The principal type. The supported value is IAM.
	PrincipalType PrincipalType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// A single product view aggregation value/count pair, containing metadata about
// each product to which the calling user has access.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProductViewAggregationValue
type ProductViewAggregationValue struct {
	_ struct{} `type:"structure"`

	// An approximate count of the products that match the value.
	ApproximateCount *int64 `type:"integer"`

	// The value of the product view aggregation.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ProductViewAggregationValue) String() string {
	return awsutil.Prettify(s)
}

// Information about a product view.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProductViewDetail
type ProductViewDetail struct {
	_ struct{} `type:"structure"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ARN of the product.
	ProductARN *string `min:"1" type:"string"`

	// Summary information about the product view.
	ProductViewSummary *ProductViewSummary `type:"structure"`

	// The status of the product.
	//
	//    * AVAILABLE - The product is ready for use.
	//
	//    * CREATING - Product creation has started; the product is not ready for
	//    use.
	//
	//    * FAILED - An action failed.
	Status Status `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProductViewDetail) String() string {
	return awsutil.Prettify(s)
}

// Summary information about a product view.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProductViewSummary
type ProductViewSummary struct {
	_ struct{} `type:"structure"`

	// The distributor of the product. Contact the product administrator for the
	// significance of this value.
	Distributor *string `type:"string"`

	// Indicates whether the product has a default path. If the product does not
	// have a default path, call ListLaunchPaths to disambiguate between paths.
	// Otherwise, ListLaunchPaths is not required, and the output of ProductViewSummary
	// can be used directly with DescribeProvisioningParameters.
	HasDefaultPath *bool `type:"boolean"`

	// The product view identifier.
	Id *string `min:"1" type:"string"`

	// The name of the product.
	Name *string `type:"string"`

	// The owner of the product. Contact the product administrator for the significance
	// of this value.
	Owner *string `type:"string"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`

	// Short description of the product.
	ShortDescription *string `type:"string"`

	// The description of the support for this Product.
	SupportDescription *string `type:"string"`

	// The email contact information to obtain support for this Product.
	SupportEmail *string `type:"string"`

	// The URL information to obtain support for this Product.
	SupportUrl *string `type:"string"`

	// The product type. Contact the product administrator for the significance
	// of this value. If this value is MARKETPLACE, the product was created by AWS
	// Marketplace.
	Type ProductType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProductViewSummary) String() string {
	return awsutil.Prettify(s)
}

// Information about a provisioned product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionedProductAttribute
type ProvisionedProductAttribute struct {
	_ struct{} `type:"structure"`

	// The ARN of the provisioned product.
	Arn *string `min:"1" type:"string"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the provisioned product.
	Id *string `min:"1" type:"string"`

	// A unique identifier that you provide to ensure idempotency. If multiple requests
	// differ only by the idempotency token, the same response is returned for each
	// repeated request.
	IdempotencyToken *string `min:"1" type:"string"`

	// The record identifier of the last request performed on this provisioned product.
	LastRecordId *string `min:"1" type:"string"`

	// The user-friendly name of the provisioned product.
	Name *string `min:"1" type:"string"`

	// The assigned identifier for the resource, such as an EC2 instance ID or an
	// S3 bucket name.
	PhysicalId *string `type:"string"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the provisioning artifact.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// The current status of the provisioned product.
	//
	//    * AVAILABLE - Stable state, ready to perform any operation. The most recent
	//    operation succeeded and completed.
	//
	//    * UNDER_CHANGE - Transitive state. Operations performed might not have
	//    valid results. Wait for an AVAILABLE status before performing operations.
	//
	//    * TAINTED - Stable state, ready to perform any operation. The stack has
	//    completed the requested operation but is not exactly what was requested.
	//    For example, a request to update to a new version failed and the stack
	//    rolled back to the current version.
	//
	//    * ERROR - An unexpected error occurred. The provisioned product exists
	//    but the stack is not running. For example, CloudFormation received a parameter
	//    value that was not valid and could not launch the stack.
	//
	//    * PLAN_IN_PROGRESS - Transitive state. The plan operations were performed
	//    to provision a new product, but resources have not yet been created. After
	//    reviewing the list of resources to be created, execute the plan. Wait
	//    for an AVAILABLE status before performing operations.
	Status ProvisionedProductStatus `type:"string" enum:"true"`

	// The current status message of the provisioned product.
	StatusMessage *string `type:"string"`

	// One or more tags.
	Tags []Tag `type:"list"`

	// The type of provisioned product. The supported values are CFN_STACK and CFN_STACKSET.
	Type *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM user.
	UserArn *string `type:"string"`

	// The ARN of the IAM user in the session. This ARN might contain a session
	// ID.
	UserArnSession *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedProductAttribute) String() string {
	return awsutil.Prettify(s)
}

// Information about a provisioned product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionedProductDetail
type ProvisionedProductDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the provisioned product.
	Arn *string `min:"1" type:"string"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the provisioned product.
	Id *string `type:"string"`

	// A unique identifier that you provide to ensure idempotency. If multiple requests
	// differ only by the idempotency token, the same response is returned for each
	// repeated request.
	IdempotencyToken *string `min:"1" type:"string"`

	// The record identifier of the last request performed on this provisioned product.
	LastRecordId *string `type:"string"`

	// The user-friendly name of the provisioned product.
	Name *string `min:"1" type:"string"`

	// The product identifier. For example, prod-abcdzk7xy33qa.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// The current status of the provisioned product.
	//
	//    * AVAILABLE - Stable state, ready to perform any operation. The most recent
	//    operation succeeded and completed.
	//
	//    * UNDER_CHANGE - Transitive state. Operations performed might not have
	//    valid results. Wait for an AVAILABLE status before performing operations.
	//
	//    * TAINTED - Stable state, ready to perform any operation. The stack has
	//    completed the requested operation but is not exactly what was requested.
	//    For example, a request to update to a new version failed and the stack
	//    rolled back to the current version.
	//
	//    * ERROR - An unexpected error occurred. The provisioned product exists
	//    but the stack is not running. For example, CloudFormation received a parameter
	//    value that was not valid and could not launch the stack.
	//
	//    * PLAN_IN_PROGRESS - Transitive state. The plan operations were performed
	//    to provision a new product, but resources have not yet been created. After
	//    reviewing the list of resources to be created, execute the plan. Wait
	//    for an AVAILABLE status before performing operations.
	Status ProvisionedProductStatus `type:"string" enum:"true"`

	// The current status message of the provisioned product.
	StatusMessage *string `type:"string"`

	// The type of provisioned product. The supported values are CFN_STACK and CFN_STACKSET.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedProductDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about a plan.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionedProductPlanDetails
type ProvisionedProductPlanDetails struct {
	_ struct{} `type:"structure"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
	// events.
	NotificationArns []string `type:"list"`

	// The path identifier of the product. This value is optional if the product
	// has a default path, and required if the product has more than one path. To
	// list the paths for a product, use ListLaunchPaths.
	PathId *string `min:"1" type:"string"`

	// The plan identifier.
	PlanId *string `min:"1" type:"string"`

	// The name of the plan.
	PlanName *string `type:"string"`

	// The plan type.
	PlanType ProvisionedProductPlanType `type:"string" enum:"true"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`

	// The product identifier.
	ProvisionProductId *string `min:"1" type:"string"`

	// The user-friendly name of the provisioned product.
	ProvisionProductName *string `min:"1" type:"string"`

	// The identifier of the provisioning artifact.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// Parameters specified by the administrator that are required for provisioning
	// the product.
	ProvisioningParameters []UpdateProvisioningParameter `type:"list"`

	// The status.
	Status ProvisionedProductPlanStatus `type:"string" enum:"true"`

	// The status message.
	StatusMessage *string `type:"string"`

	// One or more tags.
	Tags []Tag `type:"list"`

	// The time when the plan was last updated.
	UpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ProvisionedProductPlanDetails) String() string {
	return awsutil.Prettify(s)
}

// Summary information about a plan.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionedProductPlanSummary
type ProvisionedProductPlanSummary struct {
	_ struct{} `type:"structure"`

	// The plan identifier.
	PlanId *string `min:"1" type:"string"`

	// The name of the plan.
	PlanName *string `type:"string"`

	// The plan type.
	PlanType ProvisionedProductPlanType `type:"string" enum:"true"`

	// The product identifier.
	ProvisionProductId *string `min:"1" type:"string"`

	// The user-friendly name of the provisioned product.
	ProvisionProductName *string `min:"1" type:"string"`

	// The identifier of the provisioning artifact.
	ProvisioningArtifactId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ProvisionedProductPlanSummary) String() string {
	return awsutil.Prettify(s)
}

// Information about a provisioning artifact. A provisioning artifact is also
// known as a product version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifact
type ProvisioningArtifact struct {
	_ struct{} `type:"structure"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the provisioning artifact.
	Description *string `type:"string"`

	// The identifier of the provisioning artifact.
	Id *string `min:"1" type:"string"`

	// The name of the provisioning artifact.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningArtifact) String() string {
	return awsutil.Prettify(s)
}

// Information about a provisioning artifact (also known as a version) for a
// product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactDetail
type ProvisioningArtifactDetail struct {
	_ struct{} `type:"structure"`

	// Indicates whether the product version is active.
	Active *bool `type:"boolean"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the provisioning artifact.
	Description *string `type:"string"`

	// The identifier of the provisioning artifact.
	Id *string `min:"1" type:"string"`

	// The name of the provisioning artifact.
	Name *string `type:"string"`

	// The type of provisioning artifact.
	//
	//    * CLOUD_FORMATION_TEMPLATE - AWS CloudFormation template
	//
	//    * MARKETPLACE_AMI - AWS Marketplace AMI
	//
	//    * MARKETPLACE_CAR - AWS Marketplace Clusters and AWS Resources
	Type ProvisioningArtifactType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProvisioningArtifactDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about a parameter used to provision a product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactParameter
type ProvisioningArtifactParameter struct {
	_ struct{} `type:"structure"`

	// The default value.
	DefaultValue *string `type:"string"`

	// The description of the parameter.
	Description *string `type:"string"`

	// If this value is true, the value for this parameter is obfuscated from view
	// when the parameter is retrieved. This parameter is used to hide sensitive
	// information.
	IsNoEcho *bool `type:"boolean"`

	// Constraints that the administrator has put on a parameter.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The parameter key.
	ParameterKey *string `min:"1" type:"string"`

	// The parameter type.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningArtifactParameter) String() string {
	return awsutil.Prettify(s)
}

// The user-defined preferences that will be applied during product provisioning,
// unless overridden by ProvisioningPreferences or UpdateProvisioningPreferences.
//
// For more information on maximum concurrent accounts and failure tolerance,
// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options)
// in the AWS CloudFormation User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactPreferences
type ProvisioningArtifactPreferences struct {
	_ struct{} `type:"structure"`

	// One or more AWS accounts where stack instances are deployed from the stack
	// set. These accounts can be scoped in ProvisioningPreferences$StackSetAccounts
	// and UpdateProvisioningPreferences$StackSetAccounts.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	StackSetAccounts []string `type:"list"`

	// One or more AWS Regions where stack instances are deployed from the stack
	// set. These regions can be scoped in ProvisioningPreferences$StackSetRegions
	// and UpdateProvisioningPreferences$StackSetRegions.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	StackSetRegions []string `type:"list"`
}

// String returns the string representation
func (s ProvisioningArtifactPreferences) String() string {
	return awsutil.Prettify(s)
}

// Information about a provisioning artifact (also known as a version) for a
// product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactProperties
type ProvisioningArtifactProperties struct {
	_ struct{} `type:"structure"`

	// The description of the provisioning artifact, including how it differs from
	// the previous provisioning artifact.
	Description *string `type:"string"`

	// If set to true, AWS Service Catalog stops validating the specified provisioning
	// artifact even if it is invalid.
	DisableTemplateValidation *bool `type:"boolean"`

	// The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON
	// format as follows:
	//
	// "LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."
	//
	// Info is a required field
	Info map[string]string `min:"1" type:"map" required:"true"`

	// The name of the provisioning artifact (for example, v1 v2beta). No spaces
	// are allowed.
	Name *string `type:"string"`

	// The type of provisioning artifact.
	//
	//    * CLOUD_FORMATION_TEMPLATE - AWS CloudFormation template
	//
	//    * MARKETPLACE_AMI - AWS Marketplace AMI
	//
	//    * MARKETPLACE_CAR - AWS Marketplace Clusters and AWS Resources
	Type ProvisioningArtifactType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProvisioningArtifactProperties) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisioningArtifactProperties) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProvisioningArtifactProperties"}

	if s.Info == nil {
		invalidParams.Add(aws.NewErrParamRequired("Info"))
	}
	if s.Info != nil && len(s.Info) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Info", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Summary information about a provisioning artifact (also known as a version)
// for a product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactSummary
type ProvisioningArtifactSummary struct {
	_ struct{} `type:"structure"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the provisioning artifact.
	Description *string `type:"string"`

	// The identifier of the provisioning artifact.
	Id *string `min:"1" type:"string"`

	// The name of the provisioning artifact.
	Name *string `type:"string"`

	// The metadata for the provisioning artifact. This is used with AWS Marketplace
	// products.
	ProvisioningArtifactMetadata map[string]string `min:"1" type:"map"`
}

// String returns the string representation
func (s ProvisioningArtifactSummary) String() string {
	return awsutil.Prettify(s)
}

// An object that contains summary information about a product view and a provisioning
// artifact.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactView
type ProvisioningArtifactView struct {
	_ struct{} `type:"structure"`

	// Summary information about a product view.
	ProductViewSummary *ProductViewSummary `type:"structure"`

	// Information about a provisioning artifact. A provisioning artifact is also
	// known as a product version.
	ProvisioningArtifact *ProvisioningArtifact `type:"structure"`
}

// String returns the string representation
func (s ProvisioningArtifactView) String() string {
	return awsutil.Prettify(s)
}

// Information about a parameter used to provision a product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningParameter
type ProvisioningParameter struct {
	_ struct{} `type:"structure"`

	// The parameter key.
	Key *string `min:"1" type:"string"`

	// The parameter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisioningParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProvisioningParameter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The user-defined preferences that will be applied when updating a provisioned
// product. Not all preferences are applicable to all provisioned product types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningPreferences
type ProvisioningPreferences struct {
	_ struct{} `type:"structure"`

	// One or more AWS accounts that will have access to the provisioned product.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// The AWS accounts specified should be within the list of accounts in the STACKSET
	// constraint. To get the list of accounts in the STACKSET constraint, use the
	// DescribeProvisioningParameters operation.
	//
	// If no values are specified, the default value is all accounts from the STACKSET
	// constraint.
	StackSetAccounts []string `type:"list"`

	// The number of accounts, per region, for which this operation can fail before
	// AWS Service Catalog stops the operation in that region. If the operation
	// is stopped in a region, AWS Service Catalog doesn't attempt the operation
	// in any subsequent regions.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetFailureToleranceCount or StackSetFailureTolerancePercentage,
	// but not both.
	//
	// The default value is 0 if no value is specified.
	StackSetFailureToleranceCount *int64 `type:"integer"`

	// The percentage of accounts, per region, for which this stack operation can
	// fail before AWS Service Catalog stops the operation in that region. If the
	// operation is stopped in a region, AWS Service Catalog doesn't attempt the
	// operation in any subsequent regions.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS Service Catalog rounds down to the next whole number.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetFailureToleranceCount or StackSetFailureTolerancePercentage,
	// but not both.
	StackSetFailureTolerancePercentage *int64 `type:"integer"`

	// The maximum number of accounts in which to perform this operation at one
	// time. This is dependent on the value of StackSetFailureToleranceCount. StackSetMaxConcurrentCount
	// is at most one more than the StackSetFailureToleranceCount.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetMaxConcurrentCount or StackSetMaxConcurrentPercentage,
	// but not both.
	StackSetMaxConcurrencyCount *int64 `min:"1" type:"integer"`

	// The maximum percentage of accounts in which to perform this operation at
	// one time.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS Service Catalog rounds down to the next whole number. This is true except
	// in cases where rounding down would result is zero. In this case, AWS Service
	// Catalog sets the number as 1 instead.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetMaxConcurrentCount or StackSetMaxConcurrentPercentage,
	// but not both.
	StackSetMaxConcurrencyPercentage *int64 `min:"1" type:"integer"`

	// One or more AWS Regions where the provisioned product will be available.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// The specified regions should be within the list of regions from the STACKSET
	// constraint. To get the list of regions in the STACKSET constraint, use the
	// DescribeProvisioningParameters operation.
	//
	// If no values are specified, the default value is all regions from the STACKSET
	// constraint.
	StackSetRegions []string `type:"list"`
}

// String returns the string representation
func (s ProvisioningPreferences) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisioningPreferences) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProvisioningPreferences"}
	if s.StackSetMaxConcurrencyCount != nil && *s.StackSetMaxConcurrencyCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("StackSetMaxConcurrencyCount", 1))
	}
	if s.StackSetMaxConcurrencyPercentage != nil && *s.StackSetMaxConcurrencyPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("StackSetMaxConcurrencyPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a request operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordDetail
type RecordDetail struct {
	_ struct{} `type:"structure"`

	// The UTC time stamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The path identifier.
	PathId *string `min:"1" type:"string"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the provisioned product.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The user-friendly name of the provisioned product.
	ProvisionedProductName *string `min:"1" type:"string"`

	// The type of provisioned product. The supported values are CFN_STACK and CFN_STACKSET.
	ProvisionedProductType *string `type:"string"`

	// The identifier of the provisioning artifact.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// The errors that occurred.
	RecordErrors []RecordError `type:"list"`

	// The identifier of the record.
	RecordId *string `min:"1" type:"string"`

	// One or more tags.
	RecordTags []RecordTag `type:"list"`

	// The record type.
	//
	//    * PROVISION_PRODUCT
	//
	//    * UPDATE_PROVISIONED_PRODUCT
	//
	//    * TERMINATE_PROVISIONED_PRODUCT
	RecordType *string `type:"string"`

	// The status of the provisioned product.
	//
	//    * CREATED - The request was created but the operation has not started.
	//
	//    * IN_PROGRESS - The requested operation is in progress.
	//
	//    * IN_PROGRESS_IN_ERROR - The provisioned product is under change but the
	//    requested operation failed and some remediation is occurring. For example,
	//    a rollback.
	//
	//    * SUCCEEDED - The requested operation has successfully completed.
	//
	//    * FAILED - The requested operation has unsuccessfully completed. Investigate
	//    using the error messages returned.
	Status RecordStatus `type:"string" enum:"true"`

	// The time when the record was last updated.
	UpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s RecordDetail) String() string {
	return awsutil.Prettify(s)
}

// The error code and description resulting from an operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordError
type RecordError struct {
	_ struct{} `type:"structure"`

	// The numeric value of the error.
	Code *string `type:"string"`

	// The description of the error.
	Description *string `type:"string"`
}

// String returns the string representation
func (s RecordError) String() string {
	return awsutil.Prettify(s)
}

// The output for the product created as the result of a request. For example,
// the output for a CloudFormation-backed product that creates an S3 bucket
// would include the S3 bucket URL.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordOutput
type RecordOutput struct {
	_ struct{} `type:"structure"`

	// The description of the output.
	Description *string `type:"string"`

	// The output key.
	OutputKey *string `type:"string"`

	// The output value.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s RecordOutput) String() string {
	return awsutil.Prettify(s)
}

// Information about a tag, which is a key-value pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordTag
type RecordTag struct {
	_ struct{} `type:"structure"`

	// The key for this tag.
	Key *string `min:"1" type:"string"`

	// The value for this tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RecordTag) String() string {
	return awsutil.Prettify(s)
}

// Information about a resource change that will occur when a plan is executed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ResourceChange
type ResourceChange struct {
	_ struct{} `type:"structure"`

	// The change action.
	Action ChangeAction `type:"string" enum:"true"`

	// Information about the resource changes.
	Details []ResourceChangeDetail `type:"list"`

	// The ID of the resource, as defined in the CloudFormation template.
	LogicalResourceId *string `type:"string"`

	// The ID of the resource, if it was already created.
	PhysicalResourceId *string `type:"string"`

	// If the change type is Modify, indicates whether the existing resource is
	// deleted and replaced with a new one.
	Replacement Replacement `type:"string" enum:"true"`

	// The type of resource.
	ResourceType *string `min:"1" type:"string"`

	// The change scope.
	Scope []ResourceAttribute `type:"list"`
}

// String returns the string representation
func (s ResourceChange) String() string {
	return awsutil.Prettify(s)
}

// Information about a change to a resource attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ResourceChangeDetail
type ResourceChangeDetail struct {
	_ struct{} `type:"structure"`

	// The ID of the entity that caused the change.
	CausingEntity *string `type:"string"`

	// For static evaluations, the value of the resource attribute will change and
	// the new value is known. For dynamic evaluations, the value might change,
	// and any new value will be determined when the plan is updated.
	Evaluation EvaluationType `type:"string" enum:"true"`

	// Information about the resource attribute to be modified.
	Target *ResourceTargetDefinition `type:"structure"`
}

// String returns the string representation
func (s ResourceChangeDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ResourceDetail
type ResourceDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	ARN *string `type:"string"`

	// The creation time of the resource.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the resource.
	Description *string `type:"string"`

	// The identifier of the resource.
	Id *string `type:"string"`

	// The name of the resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about a change to a resource attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ResourceTargetDefinition
type ResourceTargetDefinition struct {
	_ struct{} `type:"structure"`

	// The attribute to be changed.
	Attribute ResourceAttribute `type:"string" enum:"true"`

	// If the attribute is Properties, the value is the name of the property. Otherwise,
	// the value is null.
	Name *string `type:"string"`

	// If the attribute is Properties, indicates whether a change to this property
	// causes the resource to be re-created.
	RequiresRecreation RequiresRecreation `type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceTargetDefinition) String() string {
	return awsutil.Prettify(s)
}

// A self-service action association consisting of the Action ID, the Product
// ID, and the Provisioning Artifact ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ServiceActionAssociation
type ServiceActionAssociation struct {
	_ struct{} `type:"structure"`

	// The product identifier. For example, prod-abcdzk7xy33qa.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`

	// The self-service action identifier. For example, act-fs7abcd89wxyz.
	//
	// ServiceActionId is a required field
	ServiceActionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceActionAssociation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceActionAssociation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceActionAssociation"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if s.ServiceActionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceActionId"))
	}
	if s.ServiceActionId != nil && len(*s.ServiceActionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceActionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object containing detailed information about the self-service action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ServiceActionDetail
type ServiceActionDetail struct {
	_ struct{} `type:"structure"`

	// A map that defines the self-service action.
	Definition map[string]string `min:"1" type:"map"`

	// Summary information about the self-service action.
	ServiceActionSummary *ServiceActionSummary `type:"structure"`
}

// String returns the string representation
func (s ServiceActionDetail) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about the self-service action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ServiceActionSummary
type ServiceActionSummary struct {
	_ struct{} `type:"structure"`

	// The self-service action definition type. For example, SSM_AUTOMATION.
	DefinitionType ServiceActionDefinitionType `type:"string" enum:"true"`

	// The self-service action description.
	Description *string `type:"string"`

	// The self-service action identifier.
	Id *string `min:"1" type:"string"`

	// The self-service action name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ServiceActionSummary) String() string {
	return awsutil.Prettify(s)
}

// Information about the portfolio share operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ShareDetails
type ShareDetails struct {
	_ struct{} `type:"structure"`

	// List of errors.
	ShareErrors []ShareError `type:"list"`

	// List of accounts for whom the operation succeeded.
	SuccessfulShares []string `type:"list"`
}

// String returns the string representation
func (s ShareDetails) String() string {
	return awsutil.Prettify(s)
}

// Errors that occurred during the portfolio share operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ShareError
type ShareError struct {
	_ struct{} `type:"structure"`

	// List of accounts impacted by the error.
	Accounts []string `type:"list"`

	// Error type that happened when processing the operation.
	Error *string `type:"string"`

	// Information about the error.
	Message *string `type:"string"`
}

// String returns the string representation
func (s ShareError) String() string {
	return awsutil.Prettify(s)
}

// Information about a tag. A tag is a key-value pair. Tags are propagated to
// the resources created when provisioning a product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for this key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a TagOption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TagOptionDetail
type TagOptionDetail struct {
	_ struct{} `type:"structure"`

	// The TagOption active state.
	Active *bool `type:"boolean"`

	// The TagOption identifier.
	Id *string `min:"1" type:"string"`

	// The TagOption key.
	Key *string `min:"1" type:"string"`

	// The TagOption value.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TagOptionDetail) String() string {
	return awsutil.Prettify(s)
}

// Summary information about a TagOption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TagOptionSummary
type TagOptionSummary struct {
	_ struct{} `type:"structure"`

	// The TagOption key.
	Key *string `min:"1" type:"string"`

	// The TagOption value.
	Values []string `type:"list"`
}

// String returns the string representation
func (s TagOptionSummary) String() string {
	return awsutil.Prettify(s)
}

// The parameter key-value pair used to update a provisioned product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningParameter
type UpdateProvisioningParameter struct {
	_ struct{} `type:"structure"`

	// The parameter key.
	Key *string `min:"1" type:"string"`

	// If set to true, Value is ignored and the previous parameter value is kept.
	UsePreviousValue *bool `type:"boolean"`

	// The parameter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s UpdateProvisioningParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisioningParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateProvisioningParameter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The user-defined preferences that will be applied when updating a provisioned
// product. Not all preferences are applicable to all provisioned product types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningPreferences
type UpdateProvisioningPreferences struct {
	_ struct{} `type:"structure"`

	// One or more AWS accounts that will have access to the provisioned product.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// The AWS accounts specified should be within the list of accounts in the STACKSET
	// constraint. To get the list of accounts in the STACKSET constraint, use the
	// DescribeProvisioningParameters operation.
	//
	// If no values are specified, the default value is all accounts from the STACKSET
	// constraint.
	StackSetAccounts []string `type:"list"`

	// The number of accounts, per region, for which this operation can fail before
	// AWS Service Catalog stops the operation in that region. If the operation
	// is stopped in a region, AWS Service Catalog doesn't attempt the operation
	// in any subsequent regions.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetFailureToleranceCount or StackSetFailureTolerancePercentage,
	// but not both.
	//
	// The default value is 0 if no value is specified.
	StackSetFailureToleranceCount *int64 `type:"integer"`

	// The percentage of accounts, per region, for which this stack operation can
	// fail before AWS Service Catalog stops the operation in that region. If the
	// operation is stopped in a region, AWS Service Catalog doesn't attempt the
	// operation in any subsequent regions.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS Service Catalog rounds down to the next whole number.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetFailureToleranceCount or StackSetFailureTolerancePercentage,
	// but not both.
	StackSetFailureTolerancePercentage *int64 `type:"integer"`

	// The maximum number of accounts in which to perform this operation at one
	// time. This is dependent on the value of StackSetFailureToleranceCount. StackSetMaxConcurrentCount
	// is at most one more than the StackSetFailureToleranceCount.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetMaxConcurrentCount or StackSetMaxConcurrentPercentage,
	// but not both.
	StackSetMaxConcurrencyCount *int64 `min:"1" type:"integer"`

	// The maximum percentage of accounts in which to perform this operation at
	// one time.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS Service Catalog rounds down to the next whole number. This is true except
	// in cases where rounding down would result is zero. In this case, AWS Service
	// Catalog sets the number as 1 instead.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// Conditional: You must specify either StackSetMaxConcurrentCount or StackSetMaxConcurrentPercentage,
	// but not both.
	StackSetMaxConcurrencyPercentage *int64 `min:"1" type:"integer"`

	// Determines what action AWS Service Catalog performs to a stack set or a stack
	// instance represented by the provisioned product. The default value is UPDATE
	// if nothing is specified.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// CREATE
	//
	// Creates a new stack instance in the stack set represented by the provisioned
	// product. In this case, only new stack instances are created based on accounts
	// and regions; if new ProductId or ProvisioningArtifactID are passed, they
	// will be ignored.
	//
	// UPDATE
	//
	// Updates the stack set represented by the provisioned product and also its
	// stack instances.
	//
	// DELETE
	//
	// Deletes a stack instance in the stack set represented by the provisioned
	// product.
	StackSetOperationType StackSetOperationType `type:"string" enum:"true"`

	// One or more AWS Regions where the provisioned product will be available.
	//
	// Applicable only to a CFN_STACKSET provisioned product type.
	//
	// The specified regions should be within the list of regions from the STACKSET
	// constraint. To get the list of regions in the STACKSET constraint, use the
	// DescribeProvisioningParameters operation.
	//
	// If no values are specified, the default value is all regions from the STACKSET
	// constraint.
	StackSetRegions []string `type:"list"`
}

// String returns the string representation
func (s UpdateProvisioningPreferences) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisioningPreferences) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateProvisioningPreferences"}
	if s.StackSetMaxConcurrencyCount != nil && *s.StackSetMaxConcurrencyCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("StackSetMaxConcurrencyCount", 1))
	}
	if s.StackSetMaxConcurrencyPercentage != nil && *s.StackSetMaxConcurrencyPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("StackSetMaxConcurrencyPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Additional information provided by the administrator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UsageInstruction
type UsageInstruction struct {
	_ struct{} `type:"structure"`

	// The usage instruction type for the value.
	Type *string `type:"string"`

	// The usage instruction value for this type.
	Value *string `type:"string"`
}

// String returns the string representation
func (s UsageInstruction) String() string {
	return awsutil.Prettify(s)
}
