// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroupsRequest
type DescribeIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of one or more IP access control groups.
	GroupIds []string `type:"list"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIpGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeIpGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroupsResult
type DescribeIpGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`

	// Information about the IP access control groups.
	Result []WorkspacesIpGroup `type:"list"`
}

// String returns the string representation
func (s DescribeIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeIpGroups = "DescribeIpGroups"

// DescribeIpGroupsRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Describes one or more of your IP access control groups.
//
//    // Example sending a request using DescribeIpGroupsRequest.
//    req := client.DescribeIpGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *Client) DescribeIpGroupsRequest(input *DescribeIpGroupsInput) DescribeIpGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIpGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeIpGroupsOutput{})
	return DescribeIpGroupsRequest{Request: req, Input: input, Copy: c.DescribeIpGroupsRequest}
}

// DescribeIpGroupsRequest is the request type for the
// DescribeIpGroups API operation.
type DescribeIpGroupsRequest struct {
	*aws.Request
	Input *DescribeIpGroupsInput
	Copy  func(*DescribeIpGroupsInput) DescribeIpGroupsRequest
}

// Send marshals and sends the DescribeIpGroups API request.
func (r DescribeIpGroupsRequest) Send(ctx context.Context) (*DescribeIpGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeIpGroupsResponse{
		DescribeIpGroupsOutput: r.Request.Data.(*DescribeIpGroupsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeIpGroupsResponse is the response type for the
// DescribeIpGroups API operation.
type DescribeIpGroupsResponse struct {
	*DescribeIpGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeIpGroups request.
func (r *DescribeIpGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
