// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationautoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicyRequest
type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The policy type. This parameter is required if you are creating a scaling
	// policy.
	//
	// For information on which services do not support StepScaling or TargetTrackingScaling,
	// see the information about Limits in Step Scaling Policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
	// and Target Tracking Scaling Policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
	// in the Application Auto Scaling User Guide.
	PolicyType PolicyType `type:"string" enum:"true"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension ScalableDimension `type:"string" required:"true" enum:"true"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace ServiceNamespace `type:"string" required:"true" enum:"true"`

	// A step scaling policy.
	//
	// This parameter is required if you are creating a policy and the policy type
	// is StepScaling.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration `type:"structure"`

	// A target tracking scaling policy. Includes support for predefined or customized
	// metrics.
	//
	// This parameter is required if you are creating a policy and the policy type
	// is TargetTrackingScaling.
	TargetTrackingScalingPolicyConfiguration *TargetTrackingScalingPolicyConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutScalingPolicyInput"}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if len(s.ScalableDimension) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ScalableDimension"))
	}
	if len(s.ServiceNamespace) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ServiceNamespace"))
	}
	if s.StepScalingPolicyConfiguration != nil {
		if err := s.StepScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StepScalingPolicyConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.TargetTrackingScalingPolicyConfiguration != nil {
		if err := s.TargetTrackingScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingScalingPolicyConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicyResponse
type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms created for the target tracking scaling policy.
	Alarms []Alarm `type:"list"`

	// The Amazon Resource Name (ARN) of the resulting scaling policy.
	//
	// PolicyARN is a required field
	PolicyARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest returns a request value for making API operation for
// Application Auto Scaling.
//
// Creates or updates a policy for an Application Auto Scaling scalable target.
//
// Each scalable target is identified by a service namespace, resource ID, and
// scalable dimension. A scaling policy applies to the scalable target identified
// by those three attributes. You cannot create a scaling policy until you have
// registered the resource as a scalable target using RegisterScalableTarget.
//
// To update a policy, specify its policy name and the parameters that you want
// to change. Any parameters that you don't specify are not changed by this
// update request.
//
// You can view the scaling policies for a service namespace using DescribeScalingPolicies.
// If you are no longer using a scaling policy, you can delete it using DeleteScalingPolicy.
//
// Multiple scaling policies can be in force at the same time for the same scalable
// target. You can have one or more target tracking scaling policies, one or
// more step scaling policies, or both. However, there is a chance that multiple
// policies could conflict, instructing the scalable target to scale out or
// in at the same time. Application Auto Scaling gives precedence to the policy
// that provides the largest capacity for both scale in and scale out. For example,
// if one policy increases capacity by 3, another policy increases capacity
// by 200 percent, and the current capacity is 10, Application Auto Scaling
// uses the policy with the highest calculated capacity (200% of 10 = 20) and
// scales out to 30.
//
// Learn more about how to work with scaling policies in the Application Auto
// Scaling User Guide (https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
//
//    // Example sending a request using PutScalingPolicyRequest.
//    req := client.PutScalingPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicy
func (c *Client) PutScalingPolicyRequest(input *PutScalingPolicyInput) PutScalingPolicyRequest {
	op := &aws.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	req := c.newRequest(op, input, &PutScalingPolicyOutput{})
	return PutScalingPolicyRequest{Request: req, Input: input, Copy: c.PutScalingPolicyRequest}
}

// PutScalingPolicyRequest is the request type for the
// PutScalingPolicy API operation.
type PutScalingPolicyRequest struct {
	*aws.Request
	Input *PutScalingPolicyInput
	Copy  func(*PutScalingPolicyInput) PutScalingPolicyRequest
}

// Send marshals and sends the PutScalingPolicy API request.
func (r PutScalingPolicyRequest) Send(ctx context.Context) (*PutScalingPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutScalingPolicyResponse{
		PutScalingPolicyOutput: r.Request.Data.(*PutScalingPolicyOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutScalingPolicyResponse is the response type for the
// PutScalingPolicy API operation.
type PutScalingPolicyResponse struct {
	*PutScalingPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutScalingPolicy request.
func (r *PutScalingPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
