// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilderRequest
type StartImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The version of the AppStream 2.0 agent to use for this image builder. To
	// use the latest version of the AppStream 2.0 agent, specify [LATEST].
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImageBuilderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartImageBuilderInput"}
	if s.AppstreamAgentVersion != nil && len(*s.AppstreamAgentVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppstreamAgentVersion", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilderResult
type StartImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s StartImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartImageBuilder = "StartImageBuilder"

// StartImageBuilderRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Starts the specified image builder.
//
//    // Example sending a request using StartImageBuilderRequest.
//    req := client.StartImageBuilderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder
func (c *Client) StartImageBuilderRequest(input *StartImageBuilderInput) StartImageBuilderRequest {
	op := &aws.Operation{
		Name:       opStartImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartImageBuilderInput{}
	}

	req := c.newRequest(op, input, &StartImageBuilderOutput{})
	return StartImageBuilderRequest{Request: req, Input: input, Copy: c.StartImageBuilderRequest}
}

// StartImageBuilderRequest is the request type for the
// StartImageBuilder API operation.
type StartImageBuilderRequest struct {
	*aws.Request
	Input *StartImageBuilderInput
	Copy  func(*StartImageBuilderInput) StartImageBuilderRequest
}

// Send marshals and sends the StartImageBuilder API request.
func (r StartImageBuilderRequest) Send(ctx context.Context) (*StartImageBuilderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartImageBuilderResponse{
		StartImageBuilderOutput: r.Request.Data.(*StartImageBuilderOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartImageBuilderResponse is the response type for the
// StartImageBuilder API operation.
type StartImageBuilderResponse struct {
	*StartImageBuilderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartImageBuilder request.
func (r *StartImageBuilderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
