// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfigurationRequest
type DeleteEventsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEventsConfigurationInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.BotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteEventsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BotId != nil {
		v := *s.BotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "botId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfigurationOutput
type DeleteEventsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteEventsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteEventsConfiguration = "DeleteEventsConfiguration"

// DeleteEventsConfigurationRequest returns a request value for making API operation for
// Amazon Chime.
//
// Deletes the events configuration that allows a bot to receive outgoing events.
//
//    // Example sending a request using DeleteEventsConfigurationRequest.
//    req := client.DeleteEventsConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfiguration
func (c *Client) DeleteEventsConfigurationRequest(input *DeleteEventsConfigurationInput) DeleteEventsConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteEventsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &DeleteEventsConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteEventsConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteEventsConfigurationRequest{Request: req, Input: input, Copy: c.DeleteEventsConfigurationRequest}
}

// DeleteEventsConfigurationRequest is the request type for the
// DeleteEventsConfiguration API operation.
type DeleteEventsConfigurationRequest struct {
	*aws.Request
	Input *DeleteEventsConfigurationInput
	Copy  func(*DeleteEventsConfigurationInput) DeleteEventsConfigurationRequest
}

// Send marshals and sends the DeleteEventsConfiguration API request.
func (r DeleteEventsConfigurationRequest) Send(ctx context.Context) (*DeleteEventsConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEventsConfigurationResponse{
		DeleteEventsConfigurationOutput: r.Request.Data.(*DeleteEventsConfigurationOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEventsConfigurationResponse is the response type for the
// DeleteEventsConfiguration API operation.
type DeleteEventsConfigurationResponse struct {
	*DeleteEventsConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEventsConfiguration request.
func (r *DeleteEventsConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
