// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembersRequest
type ListTeamMembersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of team members you want returned in a response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project for which you want to list team members.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTeamMembersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTeamMembersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTeamMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.ProjectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembersResult
type ListTeamMembersOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of team member objects for the project.
	//
	// TeamMembers is a required field
	TeamMembers []TeamMember `locationName:"teamMembers" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTeamMembersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTeamMembers = "ListTeamMembers"

// ListTeamMembersRequest returns a request value for making API operation for
// AWS CodeStar.
//
// Lists all team members associated with a project.
//
//    // Example sending a request using ListTeamMembersRequest.
//    req := client.ListTeamMembersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembers
func (c *Client) ListTeamMembersRequest(input *ListTeamMembersInput) ListTeamMembersRequest {
	op := &aws.Operation{
		Name:       opListTeamMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTeamMembersInput{}
	}

	req := c.newRequest(op, input, &ListTeamMembersOutput{})
	return ListTeamMembersRequest{Request: req, Input: input, Copy: c.ListTeamMembersRequest}
}

// ListTeamMembersRequest is the request type for the
// ListTeamMembers API operation.
type ListTeamMembersRequest struct {
	*aws.Request
	Input *ListTeamMembersInput
	Copy  func(*ListTeamMembersInput) ListTeamMembersRequest
}

// Send marshals and sends the ListTeamMembers API request.
func (r ListTeamMembersRequest) Send(ctx context.Context) (*ListTeamMembersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTeamMembersResponse{
		ListTeamMembersOutput: r.Request.Data.(*ListTeamMembersOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListTeamMembersResponse is the response type for the
// ListTeamMembers API operation.
type ListTeamMembersResponse struct {
	*ListTeamMembersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTeamMembers request.
func (r *ListTeamMembersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
