// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the request to forget the device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDeviceRequest
type ForgetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token for the forgotten device request.
	AccessToken *string `type:"string"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForgetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgetDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ForgetDeviceInput"}

	if s.DeviceKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDeviceOutput
type ForgetDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ForgetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

const opForgetDevice = "ForgetDevice"

// ForgetDeviceRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Forgets the specified device.
//
//    // Example sending a request using ForgetDeviceRequest.
//    req := client.ForgetDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice
func (c *Client) ForgetDeviceRequest(input *ForgetDeviceInput) ForgetDeviceRequest {
	op := &aws.Operation{
		Name:       opForgetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgetDeviceInput{}
	}

	req := c.newRequest(op, input, &ForgetDeviceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ForgetDeviceRequest{Request: req, Input: input, Copy: c.ForgetDeviceRequest}
}

// ForgetDeviceRequest is the request type for the
// ForgetDevice API operation.
type ForgetDeviceRequest struct {
	*aws.Request
	Input *ForgetDeviceInput
	Copy  func(*ForgetDeviceInput) ForgetDeviceRequest
}

// Send marshals and sends the ForgetDevice API request.
func (r ForgetDeviceRequest) Send(ctx context.Context) (*ForgetDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ForgetDeviceResponse{
		ForgetDeviceOutput: r.Request.Data.(*ForgetDeviceOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ForgetDeviceResponse is the response type for the
// ForgetDevice API operation.
type ForgetDeviceResponse struct {
	*ForgetDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ForgetDevice request.
func (r *ForgetDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
