// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJobRequest
type StopDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopDominantLanguageDetectionJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJobResponse
type StopDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopDominantLanguageDetectionJob operation.
	JobStatus JobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StopDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopDominantLanguageDetectionJob = "StopDominantLanguageDetectionJob"

// StopDominantLanguageDetectionJobRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Stops a dominant language detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
//    // Example sending a request using StopDominantLanguageDetectionJobRequest.
//    req := client.StopDominantLanguageDetectionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob
func (c *Client) StopDominantLanguageDetectionJobRequest(input *StopDominantLanguageDetectionJobInput) StopDominantLanguageDetectionJobRequest {
	op := &aws.Operation{
		Name:       opStopDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDominantLanguageDetectionJobInput{}
	}

	req := c.newRequest(op, input, &StopDominantLanguageDetectionJobOutput{})
	return StopDominantLanguageDetectionJobRequest{Request: req, Input: input, Copy: c.StopDominantLanguageDetectionJobRequest}
}

// StopDominantLanguageDetectionJobRequest is the request type for the
// StopDominantLanguageDetectionJob API operation.
type StopDominantLanguageDetectionJobRequest struct {
	*aws.Request
	Input *StopDominantLanguageDetectionJobInput
	Copy  func(*StopDominantLanguageDetectionJobInput) StopDominantLanguageDetectionJobRequest
}

// Send marshals and sends the StopDominantLanguageDetectionJob API request.
func (r StopDominantLanguageDetectionJobRequest) Send(ctx context.Context) (*StopDominantLanguageDetectionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopDominantLanguageDetectionJobResponse{
		StopDominantLanguageDetectionJobOutput: r.Request.Data.(*StopDominantLanguageDetectionJobOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopDominantLanguageDetectionJobResponse is the response type for the
// StopDominantLanguageDetectionJob API operation.
type StopDominantLanguageDetectionJobResponse struct {
	*StopDominantLanguageDetectionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopDominantLanguageDetectionJob request.
func (r *StopDominantLanguageDetectionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
