// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurationsRequest
type PutRemediationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A list of remediation configuration objects.
	//
	// RemediationConfigurations is a required field
	RemediationConfigurations []RemediationConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s PutRemediationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRemediationConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRemediationConfigurationsInput"}

	if s.RemediationConfigurations == nil {
		invalidParams.Add(aws.NewErrParamRequired("RemediationConfigurations"))
	}
	if s.RemediationConfigurations != nil {
		for i, v := range s.RemediationConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RemediationConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurationsResponse
type PutRemediationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of failed remediation batch objects.
	FailedBatches []FailedRemediationBatch `type:"list"`
}

// String returns the string representation
func (s PutRemediationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutRemediationConfigurations = "PutRemediationConfigurations"

// PutRemediationConfigurationsRequest returns a request value for making API operation for
// AWS Config.
//
// Adds or updates the remediation configuration with a specific AWS Config
// rule with the selected target or action. The API creates the RemediationConfiguration
// object for the AWS Config rule. The AWS Config rule must already exist for
// you to add a remediation configuration. The target (SSM document) must exist
// and have permissions to use the target.
//
//    // Example sending a request using PutRemediationConfigurationsRequest.
//    req := client.PutRemediationConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations
func (c *Client) PutRemediationConfigurationsRequest(input *PutRemediationConfigurationsInput) PutRemediationConfigurationsRequest {
	op := &aws.Operation{
		Name:       opPutRemediationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRemediationConfigurationsInput{}
	}

	req := c.newRequest(op, input, &PutRemediationConfigurationsOutput{})
	return PutRemediationConfigurationsRequest{Request: req, Input: input, Copy: c.PutRemediationConfigurationsRequest}
}

// PutRemediationConfigurationsRequest is the request type for the
// PutRemediationConfigurations API operation.
type PutRemediationConfigurationsRequest struct {
	*aws.Request
	Input *PutRemediationConfigurationsInput
	Copy  func(*PutRemediationConfigurationsInput) PutRemediationConfigurationsRequest
}

// Send marshals and sends the PutRemediationConfigurations API request.
func (r PutRemediationConfigurationsRequest) Send(ctx context.Context) (*PutRemediationConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutRemediationConfigurationsResponse{
		PutRemediationConfigurationsOutput: r.Request.Data.(*PutRemediationConfigurationsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutRemediationConfigurationsResponse is the response type for the
// PutRemediationConfigurations API operation.
type PutRemediationConfigurationsResponse struct {
	*PutRemediationConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutRemediationConfigurations request.
func (r *PutRemediationConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
