// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpointMessage
type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database.
	DatabaseName *string `type:"string"`

	// The settings in JSON format for the DMS transfer type of source endpoint.
	//
	// Possible attributes include the following:
	//
	//    * serviceAccessRoleArn - The IAM role that has permission to access the
	//    Amazon S3 bucket.
	//
	//    * bucketName - The name of the S3 bucket to use.
	//
	//    * compressionType - An optional parameter to use GZIP to compress the
	//    target files. To use GZIP, set this value to NONE (the default). To keep
	//    the files uncompressed, don't use this value.
	//
	// Shorthand syntax for these attributes is as follows: ServiceAccessRoleArn=string,BucketName=string,CompressionType=string
	//
	// JSON syntax for these attributes is as follows: { "ServiceAccessRoleArn":
	// "string", "BucketName": "string", "CompressionType": "none"|"gzip" }
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// Settings in JSON format for the target Amazon DynamoDB endpoint. For more
	// information about the available settings, see Using Object Mapping to Migrate
	// Data to DynamoDB (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html)
	// in the AWS Database Migration Service User Guide.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// Settings in JSON format for the target Elasticsearch endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// Elasticsearch as a Target for AWS DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration)
	// in the AWS Database Migration User Guide.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	//
	// EndpointIdentifier is a required field
	EndpointIdentifier *string `type:"string" required:"true"`

	// The type of endpoint.
	//
	// EndpointType is a required field
	EndpointType ReplicationEndpointTypeValue `type:"string" required:"true" enum:"true"`

	// The type of engine for the endpoint. Valid values, depending on the EndPointType
	// value, include mysql, oracle, postgres, mariadb, aurora, aurora-postgresql,
	// redshift, s3, db2, azuredb, sybase, dynamodb, mongodb, and sqlserver.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional attributes associated with the connection.
	ExtraConnectionAttributes *string `type:"string"`

	// Settings in JSON format for the target Amazon Kinesis Data Streams endpoint.
	// For more information about the available settings, see Using Object Mapping
	// to Migrate Data to a Kinesis Data Stream (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping)
	// in the AWS Database Migration User Guide.
	KinesisSettings *KinesisSettings `type:"structure"`

	// The AWS KMS key identifier to use to encrypt the connection parameters. If
	// you don't specify a value for the KmsKeyId parameter, then AWS DMS uses your
	// default encryption key. AWS KMS creates the default encryption key for your
	// AWS account. Your AWS account has a different default encryption key for
	// each AWS Region.
	KmsKeyId *string `type:"string"`

	// Settings in JSON format for the source MongoDB endpoint. For more information
	// about the available settings, see the configuration properties section in
	// Using MongoDB as a Target for AWS Database Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html)
	// in the AWS Database Migration Service User Guide.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// The password to be used to log in to the endpoint database.
	Password *string `type:"string"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	RedshiftSettings *RedshiftSettings `type:"structure"`

	// Settings in JSON format for the target Amazon S3 endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// Amazon S3 as a Target for AWS DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring)
	// in the AWS Database Migration Service User Guide.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server where the endpoint database resides.
	ServerName *string `type:"string"`

	// The Amazon Resource Name (ARN) for the service access role that you want
	// to use to create the endpoint.
	ServiceAccessRoleArn *string `type:"string"`

	// The Secure Sockets Layer (SSL) mode to use for the SSL connection. The SSL
	// mode can be one of four values: none, require, verify-ca, verify-full. The
	// default value is none.
	SslMode DmsSslModeValue `type:"string" enum:"true"`

	// Tags to be added to the endpoint.
	Tags []Tag `type:"list"`

	// The user name to be used to log in to the endpoint database.
	Username *string `type:"string"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEndpointInput"}

	if s.EndpointIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointIdentifier"))
	}
	if len(s.EndpointType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EndpointType"))
	}

	if s.EngineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EngineName"))
	}
	if s.DynamoDbSettings != nil {
		if err := s.DynamoDbSettings.Validate(); err != nil {
			invalidParams.AddNested("DynamoDbSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.ElasticsearchSettings != nil {
		if err := s.ElasticsearchSettings.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpointResponse
type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was created.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Creates an endpoint using the provided settings.
//
//    // Example sending a request using CreateEndpointRequest.
//    req := client.CreateEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint
func (c *Client) CreateEndpointRequest(input *CreateEndpointInput) CreateEndpointRequest {
	op := &aws.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	req := c.newRequest(op, input, &CreateEndpointOutput{})
	return CreateEndpointRequest{Request: req, Input: input, Copy: c.CreateEndpointRequest}
}

// CreateEndpointRequest is the request type for the
// CreateEndpoint API operation.
type CreateEndpointRequest struct {
	*aws.Request
	Input *CreateEndpointInput
	Copy  func(*CreateEndpointInput) CreateEndpointRequest
}

// Send marshals and sends the CreateEndpoint API request.
func (r CreateEndpointRequest) Send(ctx context.Context) (*CreateEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEndpointResponse{
		CreateEndpointOutput: r.Request.Data.(*CreateEndpointOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEndpointResponse is the response type for the
// CreateEndpoint API operation.
type CreateEndpointResponse struct {
	*CreateEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEndpoint request.
func (r *CreateEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
