// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewaysRequest
type DescribeDirectConnectGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous call to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewaysResult
type DescribeDirectConnectGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The Direct Connect gateways.
	DirectConnectGateways []DirectConnectGateway `locationName:"directConnectGateways" type:"list"`

	// The token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDirectConnectGateways = "DescribeDirectConnectGateways"

// DescribeDirectConnectGatewaysRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Lists all your Direct Connect gateways or only the specified Direct Connect
// gateway. Deleted Direct Connect gateways are not returned.
//
//    // Example sending a request using DescribeDirectConnectGatewaysRequest.
//    req := client.DescribeDirectConnectGatewaysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways
func (c *Client) DescribeDirectConnectGatewaysRequest(input *DescribeDirectConnectGatewaysInput) DescribeDirectConnectGatewaysRequest {
	op := &aws.Operation{
		Name:       opDescribeDirectConnectGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewaysInput{}
	}

	req := c.newRequest(op, input, &DescribeDirectConnectGatewaysOutput{})
	return DescribeDirectConnectGatewaysRequest{Request: req, Input: input, Copy: c.DescribeDirectConnectGatewaysRequest}
}

// DescribeDirectConnectGatewaysRequest is the request type for the
// DescribeDirectConnectGateways API operation.
type DescribeDirectConnectGatewaysRequest struct {
	*aws.Request
	Input *DescribeDirectConnectGatewaysInput
	Copy  func(*DescribeDirectConnectGatewaysInput) DescribeDirectConnectGatewaysRequest
}

// Send marshals and sends the DescribeDirectConnectGateways API request.
func (r DescribeDirectConnectGatewaysRequest) Send(ctx context.Context) (*DescribeDirectConnectGatewaysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDirectConnectGatewaysResponse{
		DescribeDirectConnectGatewaysOutput: r.Request.Data.(*DescribeDirectConnectGatewaysOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDirectConnectGatewaysResponse is the response type for the
// DescribeDirectConnectGateways API operation.
type DescribeDirectConnectGatewaysResponse struct {
	*DescribeDirectConnectGatewaysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDirectConnectGateways request.
func (r *DescribeDirectConnectGatewaysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
