// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTableRequest
type DeleteRouteTableInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the route table.
	//
	// RouteTableId is a required field
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRouteTableInput"}

	if s.RouteTableId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTableOutput
type DeleteRouteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRouteTable = "DeleteRouteTable"

// DeleteRouteTableRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified route table. You must disassociate the route table
// from any subnets before you can delete it. You can't delete the main route
// table.
//
//    // Example sending a request using DeleteRouteTableRequest.
//    req := client.DeleteRouteTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable
func (c *Client) DeleteRouteTableRequest(input *DeleteRouteTableInput) DeleteRouteTableRequest {
	op := &aws.Operation{
		Name:       opDeleteRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteTableInput{}
	}

	req := c.newRequest(op, input, &DeleteRouteTableOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteRouteTableRequest{Request: req, Input: input, Copy: c.DeleteRouteTableRequest}
}

// DeleteRouteTableRequest is the request type for the
// DeleteRouteTable API operation.
type DeleteRouteTableRequest struct {
	*aws.Request
	Input *DeleteRouteTableInput
	Copy  func(*DeleteRouteTableInput) DeleteRouteTableRequest
}

// Send marshals and sends the DeleteRouteTable API request.
func (r DeleteRouteTableRequest) Send(ctx context.Context) (*DeleteRouteTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRouteTableResponse{
		DeleteRouteTableOutput: r.Request.Data.(*DeleteRouteTableOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRouteTableResponse is the response type for the
// DeleteRouteTable API operation.
type DeleteRouteTableResponse struct {
	*DeleteRouteTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRouteTable request.
func (r *DeleteRouteTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
