// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes an account attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttribute
type AccountAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the account attribute.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The values for the account attribute.
	AttributeValues []AccountAttributeValue `locationName:"attributeValueSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s AccountAttribute) String() string {
	return awsutil.Prettify(s)
}

// Describes a value of an account attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttributeValue
type AccountAttributeValue struct {
	_ struct{} `type:"structure"`

	// The value of the attribute.
	AttributeValue *string `locationName:"attributeValue" type:"string"`
}

// String returns the string representation
func (s AccountAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Describes a running instance in a Spot Fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ActiveInstance
type ActiveInstance struct {
	_ struct{} `type:"structure"`

	// The health status of the instance. If the status of either the instance status
	// check or the system status check is impaired, the health status of the instance
	// is unhealthy. Otherwise, the health status is healthy.
	InstanceHealth InstanceHealthStatus `locationName:"instanceHealth" type:"string" enum:"true"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The ID of the Spot Instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`
}

// String returns the string representation
func (s ActiveInstance) String() string {
	return awsutil.Prettify(s)
}

// Describes an Elastic IP address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Address
type Address struct {
	_ struct{} `type:"structure"`

	// The ID representing the allocation of the address for use with EC2-VPC.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The ID representing the association of the address with an instance in a
	// VPC.
	AssociationId *string `locationName:"associationId" type:"string"`

	// Indicates whether this Elastic IP address is for use with instances in EC2-Classic
	// (standard) or instances in a VPC (vpc).
	Domain DomainType `locationName:"domain" type:"string" enum:"true"`

	// The ID of the instance that the address is associated with (if any).
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the AWS account that owns the network interface.
	NetworkInterfaceOwnerId *string `locationName:"networkInterfaceOwnerId" type:"string"`

	// The private IP address associated with the Elastic IP address.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// The ID of an address pool.
	PublicIpv4Pool *string `locationName:"publicIpv4Pool" type:"string"`

	// Any tags assigned to the Elastic IP address.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// Describes a principal.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllowedPrincipal
type AllowedPrincipal struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the principal.
	Principal *string `locationName:"principal" type:"string"`

	// The type of principal.
	PrincipalType PrincipalType `locationName:"principalType" type:"string" enum:"true"`
}

// String returns the string representation
func (s AllowedPrincipal) String() string {
	return awsutil.Prettify(s)
}

// Describes a target network that is associated with a Client VPN endpoint.
// A target network is a subnet in a VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociatedTargetNetwork
type AssociatedTargetNetwork struct {
	_ struct{} `type:"structure"`

	// The ID of the subnet.
	NetworkId *string `locationName:"networkId" type:"string"`

	// The target network type.
	NetworkType AssociatedNetworkType `locationName:"networkType" type:"string" enum:"true"`
}

// String returns the string representation
func (s AssociatedTargetNetwork) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a target network association.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociationStatus
type AssociationStatus struct {
	_ struct{} `type:"structure"`

	// The state of the target network association.
	Code AssociationStatusCode `locationName:"code" type:"string" enum:"true"`

	// A message about the status of the target network association, if applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AssociationStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a value for a resource attribute that is a Boolean value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeBooleanValue
type AttributeBooleanValue struct {
	_ struct{} `type:"structure"`

	// The attribute value. The valid values are true or false.
	Value *bool `locationName:"value" type:"boolean"`
}

// String returns the string representation
func (s AttributeBooleanValue) String() string {
	return awsutil.Prettify(s)
}

// Describes a value for a resource attribute that is a String.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeValue
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// The attribute value. The value is case-sensitive.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Information about an authorization rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizationRule
type AuthorizationRule struct {
	_ struct{} `type:"structure"`

	// Indicates whether the authorization rule grants access to all clients.
	AccessAll *bool `locationName:"accessAll" type:"boolean"`

	// The ID of the Client VPN endpoint with which the authorization rule is associated.
	ClientVpnEndpointId *string `locationName:"clientVpnEndpointId" type:"string"`

	// A brief description of the authorization rule.
	Description *string `locationName:"description" type:"string"`

	// The IPv4 address range, in CIDR notation, of the network to which the authorization
	// rule applies.
	DestinationCidr *string `locationName:"destinationCidr" type:"string"`

	// The ID of the Active Directory group to which the authorization rule grants
	// access.
	GroupId *string `locationName:"groupId" type:"string"`

	// The current state of the authorization rule.
	Status *VpnAuthorizationRuleStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s AuthorizationRule) String() string {
	return awsutil.Prettify(s)
}

// Describes an Availability Zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// Any messages about the Availability Zone.
	Messages []AvailabilityZoneMessage `locationName:"messageSet" locationNameList:"item" type:"list"`

	// The name of the Region.
	RegionName *string `locationName:"regionName" type:"string"`

	// The state of the Availability Zone.
	State AvailabilityZoneState `locationName:"zoneState" type:"string" enum:"true"`

	// The ID of the Availability Zone.
	ZoneId *string `locationName:"zoneId" type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `locationName:"zoneName" type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// Describes a message about an Availability Zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZoneMessage
type AvailabilityZoneMessage struct {
	_ struct{} `type:"structure"`

	// The message about the Availability Zone.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AvailabilityZoneMessage) String() string {
	return awsutil.Prettify(s)
}

// The capacity information for instances launched onto the Dedicated Host.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailableCapacity
type AvailableCapacity struct {
	_ struct{} `type:"structure"`

	// The total number of instances supported by the Dedicated Host.
	AvailableInstanceCapacity []InstanceCapacity `locationName:"availableInstanceCapacity" locationNameList:"item" type:"list"`

	// The number of vCPUs available on the Dedicated Host.
	AvailableVCpus *int64 `locationName:"availableVCpus" type:"integer"`
}

// String returns the string representation
func (s AvailableCapacity) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlobAttributeValue
type BlobAttributeValue struct {
	_ struct{} `type:"structure"`

	// Value is automatically base64 encoded/decoded by the SDK.
	Value []byte `locationName:"value" type:"blob"`
}

// String returns the string representation
func (s BlobAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlockDeviceMapping
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name (for example, /dev/sdh or xvdh).
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *EbsBlockDevice `locationName:"ebs" type:"structure"`

	// Suppresses the specified device included in the block device mapping of the
	// AMI.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// The virtual device name (ephemeralN). Instance store volumes are numbered
	// starting from 0. An instance type with 2 available instance store volumes
	// can specify mappings for ephemeral0 and ephemeral1. The number of available
	// instance store volumes depends on the instance type. After you connect to
	// the instance, you must mount the volume.
	//
	// NVMe instance store volumes are automatically enumerated and assigned a device
	// name. Including them in your block device mapping has no effect.
	//
	// Constraints: For M3 instances, you must specify instance store volumes in
	// the block device mapping for the instance. When you launch an M3 instance,
	// we ignore any instance store volumes specified in the block device mapping
	// for the AMI.
	VirtualName *string `locationName:"virtualName" type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Describes a bundle task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTask
type BundleTask struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle task.
	BundleId *string `locationName:"bundleId" type:"string"`

	// If the task fails, a description of the error.
	BundleTaskError *BundleTaskError `locationName:"error" type:"structure"`

	// The ID of the instance associated with this bundle task.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The level of task completion, as a percent (for example, 20%).
	Progress *string `locationName:"progress" type:"string"`

	// The time this task started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The state of the task.
	State BundleTaskState `locationName:"state" type:"string" enum:"true"`

	// The Amazon S3 storage locations.
	Storage *Storage `locationName:"storage" type:"structure"`

	// The time of the most recent update for the task.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s BundleTask) String() string {
	return awsutil.Prettify(s)
}

// Describes an error for BundleInstance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTaskError
type BundleTaskError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BundleTaskError) String() string {
	return awsutil.Prettify(s)
}

// Information about an address range that is provisioned for use with your
// AWS resources through bring your own IP addresses (BYOIP).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ByoipCidr
type ByoipCidr struct {
	_ struct{} `type:"structure"`

	// The public IPv4 address range, in CIDR notation.
	Cidr *string `locationName:"cidr" type:"string"`

	// The description of the address range.
	Description *string `locationName:"description" type:"string"`

	// The state of the address pool.
	State ByoipCidrState `locationName:"state" type:"string" enum:"true"`

	// Upon success, contains the ID of the address pool. Otherwise, contains an
	// error message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s ByoipCidr) String() string {
	return awsutil.Prettify(s)
}

// Describes a Spot Fleet error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsError
type CancelSpotFleetRequestsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code CancelBatchErrorCode `locationName:"code" type:"string" enum:"true"`

	// The description for the error code.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsError) String() string {
	return awsutil.Prettify(s)
}

// Describes a Spot Fleet request that was not successfully canceled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsErrorItem
type CancelSpotFleetRequestsErrorItem struct {
	_ struct{} `type:"structure"`

	// The error.
	Error *CancelSpotFleetRequestsError `locationName:"error" type:"structure"`

	// The ID of the Spot Fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsErrorItem) String() string {
	return awsutil.Prettify(s)
}

// Describes a Spot Fleet request that was successfully canceled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsSuccessItem
type CancelSpotFleetRequestsSuccessItem struct {
	_ struct{} `type:"structure"`

	// The current state of the Spot Fleet request.
	CurrentSpotFleetRequestState BatchState `locationName:"currentSpotFleetRequestState" type:"string" enum:"true"`

	// The previous state of the Spot Fleet request.
	PreviousSpotFleetRequestState BatchState `locationName:"previousSpotFleetRequestState" type:"string" enum:"true"`

	// The ID of the Spot Fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsSuccessItem) String() string {
	return awsutil.Prettify(s)
}

// Describes a request to cancel a Spot Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelledSpotInstanceRequest
type CancelledSpotInstanceRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the Spot Instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`

	// The state of the Spot Instance request.
	State CancelSpotInstanceRequestState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s CancelledSpotInstanceRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a Capacity Reservation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservation
type CapacityReservation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the capacity is reserved.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The remaining capacity. Indicates the number of instances that can be launched
	// in the Capacity Reservation.
	AvailableInstanceCount *int64 `locationName:"availableInstanceCount" type:"integer"`

	// The ID of the Capacity Reservation.
	CapacityReservationId *string `locationName:"capacityReservationId" type:"string"`

	// The date and time at which the Capacity Reservation was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the Capacity Reservation supports EBS-optimized instances.
	// This optimization provides dedicated throughput to Amazon EBS and an optimized
	// configuration stack to provide optimal I/O performance. This optimization
	// isn't available with all instance types. Additional usage charges apply when
	// using an EBS- optimized instance.
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The date and time at which the Capacity Reservation expires. When a Capacity
	// Reservation expires, the reserved capacity is released and you can no longer
	// launch instances into it. The Capacity Reservation's state changes to expired
	// when it reaches its end date and time.
	EndDate *time.Time `locationName:"endDate" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the way in which the Capacity Reservation ends. A Capacity Reservation
	// can have one of the following end types:
	//
	//    * unlimited - The Capacity Reservation remains active until you explicitly
	//    cancel it.
	//
	//    * limited - The Capacity Reservation expires automatically at a specified
	//    date and time.
	EndDateType EndDateType `locationName:"endDateType" type:"string" enum:"true"`

	// Indicates whether the Capacity Reservation supports instances with temporary,
	// block-level storage.
	EphemeralStorage *bool `locationName:"ephemeralStorage" type:"boolean"`

	// Indicates the type of instance launches that the Capacity Reservation accepts.
	// The options include:
	//
	//    * open - The Capacity Reservation accepts all instances that have matching
	//    attributes (instance type, platform, and Availability Zone). Instances
	//    that have matching attributes launch into the Capacity Reservation automatically
	//    without specifying any additional parameters.
	//
	//    * targeted - The Capacity Reservation only accepts instances that have
	//    matching attributes (instance type, platform, and Availability Zone),
	//    and explicitly target the Capacity Reservation. This ensures that only
	//    permitted instances can use the reserved capacity.
	InstanceMatchCriteria InstanceMatchCriteria `locationName:"instanceMatchCriteria" type:"string" enum:"true"`

	// The type of operating system for which the Capacity Reservation reserves
	// capacity.
	InstancePlatform CapacityReservationInstancePlatform `locationName:"instancePlatform" type:"string" enum:"true"`

	// The type of instance for which the Capacity Reservation reserves capacity.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The current state of the Capacity Reservation. A Capacity Reservation can
	// be in one of the following states:
	//
	//    * active - The Capacity Reservation is active and the capacity is available
	//    for your use.
	//
	//    * cancelled - The Capacity Reservation expired automatically at the date
	//    and time specified in your request. The reserved capacity is no longer
	//    available for your use.
	//
	//    * expired - The Capacity Reservation was manually cancelled. The reserved
	//    capacity is no longer available for your use.
	//
	//    * pending - The Capacity Reservation request was successful but the capacity
	//    provisioning is still pending.
	//
	//    * failed - The Capacity Reservation request has failed. A request might
	//    fail due to invalid request parameters, capacity constraints, or instance
	//    limit constraints. Failed requests are retained for 60 minutes.
	State CapacityReservationState `locationName:"state" type:"string" enum:"true"`

	// Any tags assigned to the Capacity Reservation.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// Indicates the tenancy of the Capacity Reservation. A Capacity Reservation
	// can have one of the following tenancy settings:
	//
	//    * default - The Capacity Reservation is created on hardware that is shared
	//    with other AWS accounts.
	//
	//    * dedicated - The Capacity Reservation is created on single-tenant hardware
	//    that is dedicated to a single AWS account.
	Tenancy CapacityReservationTenancy `locationName:"tenancy" type:"string" enum:"true"`

	// The number of instances for which the Capacity Reservation reserves capacity.
	TotalInstanceCount *int64 `locationName:"totalInstanceCount" type:"integer"`
}

// String returns the string representation
func (s CapacityReservation) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance's Capacity Reservation targeting option. You can specify
// only one parameter at a time. If you specify CapacityReservationPreference
// and CapacityReservationTarget, the request fails.
//
// Use the CapacityReservationPreference parameter to configure the instance
// to run as an On-Demand Instance or to run in any open Capacity Reservation
// that has matching attributes (instance type, platform, Availability Zone).
// Use the CapacityReservationTarget parameter to explicitly target a specific
// Capacity Reservation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationSpecification
type CapacityReservationSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates the instance's Capacity Reservation preferences. Possible preferences
	// include:
	//
	//    * open - The instance can run in any open Capacity Reservation that has
	//    matching attributes (instance type, platform, Availability Zone).
	//
	//    * none - The instance avoids running in a Capacity Reservation even if
	//    one is available. The instance runs as an On-Demand Instance.
	CapacityReservationPreference CapacityReservationPreference `type:"string" enum:"true"`

	// Information about the target Capacity Reservation.
	CapacityReservationTarget *CapacityReservationTarget `type:"structure"`
}

// String returns the string representation
func (s CapacityReservationSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes the instance's Capacity Reservation targeting preferences. The
// action returns the capacityReservationPreference response element if the
// instance is configured to run in On-Demand capacity, or if it is configured
// in run in any open Capacity Reservation that has matching attributes (instance
// type, platform, Availability Zone). The action returns the capacityReservationTarget
// response element if the instance explicily targets a specific Capacity Reservation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationSpecificationResponse
type CapacityReservationSpecificationResponse struct {
	_ struct{} `type:"structure"`

	// Describes the instance's Capacity Reservation preferences. Possible preferences
	// include:
	//
	//    * open - The instance can run in any open Capacity Reservation that has
	//    matching attributes (instance type, platform, Availability Zone).
	//
	//    * none - The instance avoids running in a Capacity Reservation even if
	//    one is available. The instance runs in On-Demand capacity.
	CapacityReservationPreference CapacityReservationPreference `locationName:"capacityReservationPreference" type:"string" enum:"true"`

	// Information about the targeted Capacity Reservation.
	CapacityReservationTarget *CapacityReservationTargetResponse `locationName:"capacityReservationTarget" type:"structure"`
}

// String returns the string representation
func (s CapacityReservationSpecificationResponse) String() string {
	return awsutil.Prettify(s)
}

// Describes a target Capacity Reservation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationTarget
type CapacityReservationTarget struct {
	_ struct{} `type:"structure"`

	// The ID of the Capacity Reservation.
	CapacityReservationId *string `type:"string"`
}

// String returns the string representation
func (s CapacityReservationTarget) String() string {
	return awsutil.Prettify(s)
}

// Describes a target Capacity Reservation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationTargetResponse
type CapacityReservationTargetResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the Capacity Reservation.
	CapacityReservationId *string `locationName:"capacityReservationId" type:"string"`
}

// String returns the string representation
func (s CapacityReservationTargetResponse) String() string {
	return awsutil.Prettify(s)
}

// Information about the client certificate used for authentication.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CertificateAuthentication
type CertificateAuthentication struct {
	_ struct{} `type:"structure"`

	// The ARN of the client certificate.
	ClientRootCertificateChain *string `locationName:"clientRootCertificateChain" type:"string"`
}

// String returns the string representation
func (s CertificateAuthentication) String() string {
	return awsutil.Prettify(s)
}

// Information about the client certificate to be used for authentication.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CertificateAuthenticationRequest
type CertificateAuthenticationRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the client certificate. The certificate must be signed by a certificate
	// authority (CA) and it must be provisioned in AWS Certificate Manager (ACM).
	ClientRootCertificateChainArn *string `type:"string"`
}

// String returns the string representation
func (s CertificateAuthenticationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a client certificate revocation list.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientCertificateRevocationListStatus
type CertificateRevocationListStatus struct {
	_ struct{} `type:"structure"`

	// The state of the client certificate revocation list.
	Code CertificateRevocationListStatusCode `locationName:"code" type:"string" enum:"true"`

	// A message about the status of the client certificate revocation list, if
	// applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CertificateRevocationListStatus) String() string {
	return awsutil.Prettify(s)
}

// Provides authorization for Amazon to bring a specific IP address range to
// a specific AWS account using bring your own IP addresses (BYOIP). For more
// information, see Prepare to Bring Your Address Range to Your AWS Account
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip)
// in the Amazon Elastic Compute Cloud User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CidrAuthorizationContext
type CidrAuthorizationContext struct {
	_ struct{} `type:"structure"`

	// The plain-text authorization message for the prefix and account.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The signed authorization message for the prefix and account.
	//
	// Signature is a required field
	Signature *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CidrAuthorizationContext) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CidrAuthorizationContext) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CidrAuthorizationContext"}

	if s.Message == nil {
		invalidParams.Add(aws.NewErrParamRequired("Message"))
	}

	if s.Signature == nil {
		invalidParams.Add(aws.NewErrParamRequired("Signature"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an IPv4 CIDR block.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CidrBlock
type CidrBlock struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR block.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`
}

// String returns the string representation
func (s CidrBlock) String() string {
	return awsutil.Prettify(s)
}

// Describes the ClassicLink DNS support status of a VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkDnsSupport
type ClassicLinkDnsSupport struct {
	_ struct{} `type:"structure"`

	// Indicates whether ClassicLink DNS support is enabled for the VPC.
	ClassicLinkDnsSupported *bool `locationName:"classicLinkDnsSupported" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s ClassicLinkDnsSupport) String() string {
	return awsutil.Prettify(s)
}

// Describes a linked EC2-Classic instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkInstance
type ClassicLinkInstance struct {
	_ struct{} `type:"structure"`

	// A list of security groups.
	Groups []GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Any tags assigned to the instance.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s ClassicLinkInstance) String() string {
	return awsutil.Prettify(s)
}

// Describes a Classic Load Balancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLoadBalancer
type ClassicLoadBalancer struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ClassicLoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet
// registers the running Spot Instances with these Classic Load Balancers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLoadBalancersConfig
type ClassicLoadBalancersConfig struct {
	_ struct{} `type:"structure"`

	// One or more Classic Load Balancers.
	ClassicLoadBalancers []ClassicLoadBalancer `locationName:"classicLoadBalancers" locationNameList:"item" min:"1" type:"list"`
}

// String returns the string representation
func (s ClassicLoadBalancersConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClassicLoadBalancersConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ClassicLoadBalancersConfig"}
	if s.ClassicLoadBalancers != nil && len(s.ClassicLoadBalancers) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClassicLoadBalancers", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the client connection logging options for the Client VPN endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionLogOptions
type ConnectionLogOptions struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch Logs log group.
	CloudwatchLogGroup *string `type:"string"`

	// The name of the CloudWatch Logs log stream to which the connection data is
	// published.
	CloudwatchLogStream *string `type:"string"`

	// Indicates whether connection logging is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ConnectionLogOptions) String() string {
	return awsutil.Prettify(s)
}

// Information about the client connection logging options for a Client VPN
// endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionLogResponseOptions
type ConnectionLogResponseOptions struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon CloudWatch Logs log group to which connection logging
	// data is published.
	CloudwatchLogGroup *string `type:"string"`

	// The name of the Amazon CloudWatch Logs log stream to which connection logging
	// data is published.
	CloudwatchLogStream *string `type:"string"`

	// Indicates whether client connection logging is enabled for the Client VPN
	// endpoint.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ConnectionLogResponseOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes a connection notification for a VPC endpoint or VPC endpoint service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionNotification
type ConnectionNotification struct {
	_ struct{} `type:"structure"`

	// The events for the notification. Valid values are Accept, Connect, Delete,
	// and Reject.
	ConnectionEvents []string `locationName:"connectionEvents" locationNameList:"item" type:"list"`

	// The ARN of the SNS topic for the notification.
	ConnectionNotificationArn *string `locationName:"connectionNotificationArn" type:"string"`

	// The ID of the notification.
	ConnectionNotificationId *string `locationName:"connectionNotificationId" type:"string"`

	// The state of the notification.
	ConnectionNotificationState ConnectionNotificationState `locationName:"connectionNotificationState" type:"string" enum:"true"`

	// The type of notification.
	ConnectionNotificationType ConnectionNotificationType `locationName:"connectionNotificationType" type:"string" enum:"true"`

	// The ID of the endpoint service.
	ServiceId *string `locationName:"serviceId" type:"string"`

	// The ID of the VPC endpoint.
	VpcEndpointId *string `locationName:"vpcEndpointId" type:"string"`
}

// String returns the string representation
func (s ConnectionNotification) String() string {
	return awsutil.Prettify(s)
}

// Describes a conversion task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConversionTask
type ConversionTask struct {
	_ struct{} `type:"structure"`

	// The ID of the conversion task.
	ConversionTaskId *string `locationName:"conversionTaskId" type:"string"`

	// The time when the task expires. If the upload isn't complete before the expiration
	// time, we automatically cancel the task.
	ExpirationTime *string `locationName:"expirationTime" type:"string"`

	// If the task is for importing an instance, this contains information about
	// the import instance task.
	ImportInstance *ImportInstanceTaskDetails `locationName:"importInstance" type:"structure"`

	// If the task is for importing a volume, this contains information about the
	// import volume task.
	ImportVolume *ImportVolumeTaskDetails `locationName:"importVolume" type:"structure"`

	// The state of the conversion task.
	State ConversionTaskState `locationName:"state" type:"string" enum:"true"`

	// The status message related to the conversion task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Any tags assigned to the task.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ConversionTask) String() string {
	return awsutil.Prettify(s)
}

// The CPU options for the instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuOptions
type CpuOptions struct {
	_ struct{} `type:"structure"`

	// The number of CPU cores for the instance.
	CoreCount *int64 `locationName:"coreCount" type:"integer"`

	// The number of threads per CPU core.
	ThreadsPerCore *int64 `locationName:"threadsPerCore" type:"integer"`
}

// String returns the string representation
func (s CpuOptions) String() string {
	return awsutil.Prettify(s)
}

// The CPU options for the instance. Both the core count and threads per core
// must be specified in the request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuOptionsRequest
type CpuOptionsRequest struct {
	_ struct{} `type:"structure"`

	// The number of CPU cores for the instance.
	CoreCount *int64 `type:"integer"`

	// The number of threads per CPU core. To disable Intel Hyper-Threading Technology
	// for the instance, specify a value of 1. Otherwise, specify the default value
	// of 2.
	ThreadsPerCore *int64 `type:"integer"`
}

// String returns the string representation
func (s CpuOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the instances that could not be launched by the fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetError
type CreateFleetError struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the instance could not be launched. For
	// more information about error codes, see Error Codes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The error message that describes why the instance could not be launched.
	// For more information about error messages, see ee Error Codes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The launch templates and overrides that were used for launching the instances.
	// Any parameters that you specify in the Overrides override the same parameters
	// in the launch template.
	LaunchTemplateAndOverrides *LaunchTemplateAndOverridesResponse `locationName:"launchTemplateAndOverrides" type:"structure"`

	// Indicates if the instance that could not be launched was a Spot Instance
	// or On-Demand Instance.
	Lifecycle InstanceLifecycle `locationName:"lifecycle" type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateFleetError) String() string {
	return awsutil.Prettify(s)
}

// Describes the instances that were launched by the fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetInstance
type CreateFleetInstance struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances.
	InstanceIds []string `locationName:"instanceIds" locationNameList:"item" type:"list"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The launch templates and overrides that were used for launching the instances.
	// Any parameters that you specify in the Overrides override the same parameters
	// in the launch template.
	LaunchTemplateAndOverrides *LaunchTemplateAndOverridesResponse `locationName:"launchTemplateAndOverrides" type:"structure"`

	// Indicates if the instance that was launched is a Spot Instance or On-Demand
	// Instance.
	Lifecycle InstanceLifecycle `locationName:"lifecycle" type:"string" enum:"true"`

	// The value is Windows for Windows instances; otherwise blank.
	Platform PlatformValues `locationName:"platform" type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateFleetInstance) String() string {
	return awsutil.Prettify(s)
}

// Describes the options for a VPC attachment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachmentRequestOptions
type CreateTransitGatewayVpcAttachmentRequestOptions struct {
	_ struct{} `type:"structure"`

	// Enable or disable DNS support. The default is enable.
	DnsSupport DnsSupportValue `type:"string" enum:"true"`

	// Enable or disable IPv6 support. The default is enable.
	Ipv6Support Ipv6SupportValue `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateTransitGatewayVpcAttachmentRequestOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes the user or group to be added or removed from the list of create
// volume permissions for a volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermission
type CreateVolumePermission struct {
	_ struct{} `type:"structure"`

	// The group to be added or removed. The possible value is all.
	Group PermissionGroup `locationName:"group" type:"string" enum:"true"`

	// The AWS account ID to be added or removed.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s CreateVolumePermission) String() string {
	return awsutil.Prettify(s)
}

// Describes modifications to the list of create volume permissions for a volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermissionModifications
type CreateVolumePermissionModifications struct {
	_ struct{} `type:"structure"`

	// Adds the specified AWS account ID or group to the list.
	Add []CreateVolumePermission `locationNameList:"item" type:"list"`

	// Removes the specified AWS account ID or group from the list.
	Remove []CreateVolumePermission `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateVolumePermissionModifications) String() string {
	return awsutil.Prettify(s)
}

// Describes the credit option for CPU usage of a T2 or T3 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreditSpecification
type CreditSpecification struct {
	_ struct{} `type:"structure"`

	// The credit option for CPU usage of a T2 or T3 instance. Valid values are
	// standard and unlimited.
	CpuCredits *string `locationName:"cpuCredits" type:"string"`
}

// String returns the string representation
func (s CreditSpecification) String() string {
	return awsutil.Prettify(s)
}

// The credit option for CPU usage of a T2 or T3 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreditSpecificationRequest
type CreditSpecificationRequest struct {
	_ struct{} `type:"structure"`

	// The credit option for CPU usage of a T2 or T3 instance. Valid values are
	// standard and unlimited.
	//
	// CpuCredits is a required field
	CpuCredits *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreditSpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreditSpecificationRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreditSpecificationRequest"}

	if s.CpuCredits == nil {
		invalidParams.Add(aws.NewErrParamRequired("CpuCredits"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a customer gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CustomerGateway
type CustomerGateway struct {
	_ struct{} `type:"structure"`

	// The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
	// (ASN).
	BgpAsn *string `locationName:"bgpAsn" type:"string"`

	// The ID of the customer gateway.
	CustomerGatewayId *string `locationName:"customerGatewayId" type:"string"`

	// The Internet-routable IP address of the customer gateway's outside interface.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The current state of the customer gateway (pending | available | deleting
	// | deleted).
	State *string `locationName:"state" type:"string"`

	// Any tags assigned to the customer gateway.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of VPN connection the customer gateway supports (ipsec.1).
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s CustomerGateway) String() string {
	return awsutil.Prettify(s)
}

// Describes the client-specific data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientData
type Data struct {
	_ struct{} `type:"structure"`

	// A user-defined comment about the disk upload.
	Comment *string `type:"string"`

	// The time that the disk upload ends.
	UploadEnd *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The size of the uploaded disk image, in GiB.
	UploadSize *float64 `type:"double"`

	// The time that the disk upload starts.
	UploadStart *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Data) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 Fleet error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetError
type DeleteFleetError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code DeleteFleetErrorCode `locationName:"code" type:"string" enum:"true"`

	// The description for the error code.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DeleteFleetError) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 Fleet that was not successfully deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetErrorItem
type DeleteFleetErrorItem struct {
	_ struct{} `type:"structure"`

	// The error.
	Error *DeleteFleetError `locationName:"error" type:"structure"`

	// The ID of the EC2 Fleet.
	FleetId *string `locationName:"fleetId" type:"string"`
}

// String returns the string representation
func (s DeleteFleetErrorItem) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 Fleet that was successfully deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetSuccessItem
type DeleteFleetSuccessItem struct {
	_ struct{} `type:"structure"`

	// The current state of the EC2 Fleet.
	CurrentFleetState FleetStateCode `locationName:"currentFleetState" type:"string" enum:"true"`

	// The ID of the EC2 Fleet.
	FleetId *string `locationName:"fleetId" type:"string"`

	// The previous state of the EC2 Fleet.
	PreviousFleetState FleetStateCode `locationName:"previousFleetState" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteFleetSuccessItem) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template version that could not be deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResponseErrorItem
type DeleteLaunchTemplateVersionsResponseErrorItem struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `locationName:"launchTemplateName" type:"string"`

	// Information about the error.
	ResponseError *ResponseError `locationName:"responseError" type:"structure"`

	// The version number of the launch template.
	VersionNumber *int64 `locationName:"versionNumber" type:"long"`
}

// String returns the string representation
func (s DeleteLaunchTemplateVersionsResponseErrorItem) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template version that was successfully deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResponseSuccessItem
type DeleteLaunchTemplateVersionsResponseSuccessItem struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `locationName:"launchTemplateName" type:"string"`

	// The version number of the launch template.
	VersionNumber *int64 `locationName:"versionNumber" type:"long"`
}

// String returns the string representation
func (s DeleteLaunchTemplateVersionsResponseSuccessItem) String() string {
	return awsutil.Prettify(s)
}

// Describes the instances that could not be launched by the fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetError
type DescribeFleetError struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the instance could not be launched. For
	// more information about error codes, see Error Codes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The error message that describes why the instance could not be launched.
	// For more information about error messages, see ee Error Codes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The launch templates and overrides that were used for launching the instances.
	// Any parameters that you specify in the Overrides override the same parameters
	// in the launch template.
	LaunchTemplateAndOverrides *LaunchTemplateAndOverridesResponse `locationName:"launchTemplateAndOverrides" type:"structure"`

	// Indicates if the instance that could not be launched was a Spot Instance
	// or On-Demand Instance.
	Lifecycle InstanceLifecycle `locationName:"lifecycle" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeFleetError) String() string {
	return awsutil.Prettify(s)
}

// Describes the instances that were launched by the fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetsInstances
type DescribeFleetsInstances struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances.
	InstanceIds []string `locationName:"instanceIds" locationNameList:"item" type:"list"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The launch templates and overrides that were used for launching the instances.
	// Any parameters that you specify in the Overrides override the same parameters
	// in the launch template.
	LaunchTemplateAndOverrides *LaunchTemplateAndOverridesResponse `locationName:"launchTemplateAndOverrides" type:"structure"`

	// Indicates if the instance that was launched is a Spot Instance or On-Demand
	// Instance.
	Lifecycle InstanceLifecycle `locationName:"lifecycle" type:"string" enum:"true"`

	// The value is Windows for Windows instances; otherwise blank.
	Platform PlatformValues `locationName:"platform" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeFleetsInstances) String() string {
	return awsutil.Prettify(s)
}

// Describes a DHCP configuration option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DhcpConfiguration
type DhcpConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of a DHCP option.
	Key *string `locationName:"key" type:"string"`

	// One or more values for the DHCP option.
	Values []AttributeValue `locationName:"valueSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DhcpConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a set of DHCP options.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DhcpOptions
type DhcpOptions struct {
	_ struct{} `type:"structure"`

	// One or more DHCP options in the set.
	DhcpConfigurations []DhcpConfiguration `locationName:"dhcpConfigurationSet" locationNameList:"item" type:"list"`

	// The ID of the set of DHCP options.
	DhcpOptionsId *string `locationName:"dhcpOptionsId" type:"string"`

	// The ID of the AWS account that owns the DHCP options set.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Any tags assigned to the DHCP options set.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DhcpOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes an Active Directory.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DirectoryServiceAuthentication
type DirectoryServiceAuthentication struct {
	_ struct{} `type:"structure"`

	// The ID of the Active Directory used for authentication.
	DirectoryId *string `locationName:"directoryId" type:"string"`
}

// String returns the string representation
func (s DirectoryServiceAuthentication) String() string {
	return awsutil.Prettify(s)
}

// Describes the Active Directory to be used for client authentication.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DirectoryServiceAuthenticationRequest
type DirectoryServiceAuthenticationRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the Active Directory to be used for authentication.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryServiceAuthenticationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a disk image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImage
type DiskImage struct {
	_ struct{} `type:"structure"`

	// A description of the disk image.
	Description *string `type:"string"`

	// Information about the disk image.
	Image *DiskImageDetail `type:"structure"`

	// Information about the volume.
	Volume *VolumeDetail `type:"structure"`
}

// String returns the string representation
func (s DiskImage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiskImage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DiskImage"}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(aws.ErrInvalidParams))
		}
	}
	if s.Volume != nil {
		if err := s.Volume.Validate(); err != nil {
			invalidParams.AddNested("Volume", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a disk image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImageDescription
type DiskImageDescription struct {
	_ struct{} `type:"structure"`

	// The checksum computed for the disk image.
	Checksum *string `locationName:"checksum" type:"string"`

	// The disk image format.
	Format DiskImageFormat `locationName:"format" type:"string" enum:"true"`

	// A presigned URL for the import manifest stored in Amazon S3. For information
	// about creating a presigned URL for an Amazon S3 object, read the "Query String
	// Request Authentication Alternative" section of the Authenticating REST Requests
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html)
	// topic in the Amazon Simple Storage Service Developer Guide.
	//
	// For information about the import manifest referenced by this API action,
	// see VM Import Manifest (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
	ImportManifestUrl *string `locationName:"importManifestUrl" type:"string"`

	// The size of the disk image, in GiB.
	Size *int64 `locationName:"size" type:"long"`
}

// String returns the string representation
func (s DiskImageDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes a disk image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImageDetail
type DiskImageDetail struct {
	_ struct{} `type:"structure"`

	// The size of the disk image, in GiB.
	//
	// Bytes is a required field
	Bytes *int64 `locationName:"bytes" type:"long" required:"true"`

	// The disk image format.
	//
	// Format is a required field
	Format DiskImageFormat `locationName:"format" type:"string" required:"true" enum:"true"`

	// A presigned URL for the import manifest stored in Amazon S3 and presented
	// here as an Amazon S3 presigned URL. For information about creating a presigned
	// URL for an Amazon S3 object, read the "Query String Request Authentication
	// Alternative" section of the Authenticating REST Requests (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html)
	// topic in the Amazon Simple Storage Service Developer Guide.
	//
	// For information about the import manifest referenced by this API action,
	// see VM Import Manifest (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
	//
	// ImportManifestUrl is a required field
	ImportManifestUrl *string `locationName:"importManifestUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s DiskImageDetail) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiskImageDetail) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DiskImageDetail"}

	if s.Bytes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bytes"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if s.ImportManifestUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImportManifestUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a disk image volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImageVolumeDescription
type DiskImageVolumeDescription struct {
	_ struct{} `type:"structure"`

	// The volume identifier.
	Id *string `locationName:"id" type:"string"`

	// The size of the volume, in GiB.
	Size *int64 `locationName:"size" type:"long"`
}

// String returns the string representation
func (s DiskImageVolumeDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes a DNS entry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DnsEntry
type DnsEntry struct {
	_ struct{} `type:"structure"`

	// The DNS name.
	DnsName *string `locationName:"dnsName" type:"string"`

	// The ID of the private hosted zone.
	HostedZoneId *string `locationName:"hostedZoneId" type:"string"`
}

// String returns the string representation
func (s DnsEntry) String() string {
	return awsutil.Prettify(s)
}

// Information about the DNS server to be used.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DnsServersOptionsModifyStructure
type DnsServersOptionsModifyStructure struct {
	_ struct{} `type:"structure"`

	// The IPv4 address range, in CIDR notation, of the DNS servers to be used.
	// You can specify up to two DNS servers. Ensure that the DNS servers can be
	// reached by the clients. The specified values overwrite the existing values.
	CustomDnsServers []string `locationNameList:"item" type:"list"`

	// Indicates whether DNS servers should be used. Specify False to delete the
	// existing DNS servers.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s DnsServersOptionsModifyStructure) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device for an EBS volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EbsBlockDevice
type EbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// Indicates whether the encryption state of an EBS volume is changed while
	// being restored from a backing snapshot. The default effect of setting the
	// Encrypted parameter to true through the console, API, or CLI depends on the
	// volume's origin (new or from a snapshot), starting encryption state, ownership,
	// and whether account-level encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/account-level-encryption.html)
	// is enabled. Each default case can be overridden by specifying a customer
	// master key (CMK) with the KmsKeyId parameter in addition to setting Encrypted
	// to true. For a complete list of possible encryption cases, see Amazon EBS
	// Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// In no case can you remove encryption from an encrypted volume.
	//
	// Encrypted volumes can only be attached to instances that support Amazon EBS
	// encryption. For more information, see Supported Instance Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For io1 volumes, this represents the number of IOPS that are provisioned
	// for the volume. For gp2 volumes, this represents the baseline performance
	// of the volume and the rate at which the volume accumulates I/O credits for
	// bursting. For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Constraints: Range is 100-16,000 IOPS for gp2 volumes and 100 to 64,000IOPS
	// for io1 volumes in most Regions. Maximum io1 IOPS of 64,000 is guaranteed
	// only on Nitro-based instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances).
	// Other instance families guarantee performance up to 32,000 IOPS. For more
	// information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Condition: This parameter is required for requests to create io1 volumes;
	// it is not used in requests to create gp2, st1, sc1, or standard volumes.
	Iops *int64 `locationName:"iops" type:"integer"`

	// Identifier (key ID, key alias, ID ARN, or alias ARN) for a user-managed CMK
	// under which the EBS volume is encrypted.
	//
	// This parameter is only supported on BlockDeviceMapping objects called by
	// RunInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html),
	// RequestSpotFleet (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html),
	// and RequestSpotInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html).
	KmsKeyId *string `type:"string"`

	// The ID of the snapshot.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// The size of the volume, in GiB.
	//
	// Default: If you're creating the volume from a snapshot and don't specify
	// a volume size, the default is the snapshot size.
	//
	// Constraints: 1-16384 for General Purpose SSD (gp2), 4-16384 for Provisioned
	// IOPS SSD (io1), 500-16384 for Throughput Optimized HDD (st1), 500-16384 for
	// Cold HDD (sc1), and 1-1024 for Magnetic (standard) volumes. If you specify
	// a snapshot, the volume size must be equal to or larger than the snapshot
	// size.
	VolumeSize *int64 `locationName:"volumeSize" type:"integer"`

	// The volume type. If you set the type to io1, you must also set the Iops property.
	//
	// Default: standard
	VolumeType VolumeType `locationName:"volumeType" type:"string" enum:"true"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// Describes a parameter used to set up an EBS volume in a block device mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EbsInstanceBlockDevice
type EbsInstanceBlockDevice struct {
	_ struct{} `type:"structure"`

	// The time stamp when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The attachment state.
	Status AttachmentStatus `locationName:"status" type:"string" enum:"true"`

	// The ID of the EBS volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s EbsInstanceBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// Describes information used to set up an EBS volume specified in a block device
// mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EbsInstanceBlockDeviceSpecification
type EbsInstanceBlockDeviceSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The ID of the EBS volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s EbsInstanceBlockDeviceSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes an egress-only internet gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EgressOnlyInternetGateway
type EgressOnlyInternetGateway struct {
	_ struct{} `type:"structure"`

	// Information about the attachment of the egress-only internet gateway.
	Attachments []InternetGatewayAttachment `locationName:"attachmentSet" locationNameList:"item" type:"list"`

	// The ID of the egress-only internet gateway.
	EgressOnlyInternetGatewayId *string `locationName:"egressOnlyInternetGatewayId" type:"string"`
}

// String returns the string representation
func (s EgressOnlyInternetGateway) String() string {
	return awsutil.Prettify(s)
}

// Describes the association between an instance and an Elastic Graphics accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ElasticGpuAssociation
type ElasticGpuAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the association.
	ElasticGpuAssociationId *string `locationName:"elasticGpuAssociationId" type:"string"`

	// The state of the association between the instance and the Elastic Graphics
	// accelerator.
	ElasticGpuAssociationState *string `locationName:"elasticGpuAssociationState" type:"string"`

	// The time the Elastic Graphics accelerator was associated with the instance.
	ElasticGpuAssociationTime *string `locationName:"elasticGpuAssociationTime" type:"string"`

	// The ID of the Elastic Graphics accelerator.
	ElasticGpuId *string `locationName:"elasticGpuId" type:"string"`
}

// String returns the string representation
func (s ElasticGpuAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of an Elastic Graphics accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ElasticGpuHealth
type ElasticGpuHealth struct {
	_ struct{} `type:"structure"`

	// The health status.
	Status ElasticGpuStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ElasticGpuHealth) String() string {
	return awsutil.Prettify(s)
}

// A specification for an Elastic Graphics accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ElasticGpuSpecification
type ElasticGpuSpecification struct {
	_ struct{} `type:"structure"`

	// The type of Elastic Graphics accelerator.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticGpuSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticGpuSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ElasticGpuSpecification"}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an elastic GPU.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ElasticGpuSpecificationResponse
type ElasticGpuSpecificationResponse struct {
	_ struct{} `type:"structure"`

	// The elastic GPU type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s ElasticGpuSpecificationResponse) String() string {
	return awsutil.Prettify(s)
}

// Describes an Elastic Graphics accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ElasticGpus
type ElasticGpus struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in the which the Elastic Graphics accelerator resides.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The status of the Elastic Graphics accelerator.
	ElasticGpuHealth *ElasticGpuHealth `locationName:"elasticGpuHealth" type:"structure"`

	// The ID of the Elastic Graphics accelerator.
	ElasticGpuId *string `locationName:"elasticGpuId" type:"string"`

	// The state of the Elastic Graphics accelerator.
	ElasticGpuState ElasticGpuState `locationName:"elasticGpuState" type:"string" enum:"true"`

	// The type of Elastic Graphics accelerator.
	ElasticGpuType *string `locationName:"elasticGpuType" type:"string"`

	// The ID of the instance to which the Elastic Graphics accelerator is attached.
	InstanceId *string `locationName:"instanceId" type:"string"`
}

// String returns the string representation
func (s ElasticGpus) String() string {
	return awsutil.Prettify(s)
}

// Describes an elastic inference accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ElasticInferenceAccelerator
type ElasticInferenceAccelerator struct {
	_ struct{} `type:"structure"`

	// The type of elastic inference accelerator. The possible values are eia1.small,
	// eia1.medium, and eia1.large.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticInferenceAccelerator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticInferenceAccelerator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ElasticInferenceAccelerator"}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the association between an instance and an elastic inference accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ElasticInferenceAcceleratorAssociation
type ElasticInferenceAcceleratorAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the elastic inference accelerator.
	ElasticInferenceAcceleratorArn *string `locationName:"elasticInferenceAcceleratorArn" type:"string"`

	// The ID of the association.
	ElasticInferenceAcceleratorAssociationId *string `locationName:"elasticInferenceAcceleratorAssociationId" type:"string"`

	// The state of the elastic inference accelerator.
	ElasticInferenceAcceleratorAssociationState *string `locationName:"elasticInferenceAcceleratorAssociationState" type:"string"`

	// The time at which the elastic inference accelerator is associated with an
	// instance.
	ElasticInferenceAcceleratorAssociationTime *time.Time `locationName:"elasticInferenceAcceleratorAssociationTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ElasticInferenceAcceleratorAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 Fleet or Spot Fleet event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EventInformation
type EventInformation struct {
	_ struct{} `type:"structure"`

	// The description of the event.
	EventDescription *string `locationName:"eventDescription" type:"string"`

	// The event.
	//
	// The following are the error events:
	//
	//    * iamFleetRoleInvalid - The EC2 Fleet or Spot Fleet did not have the required
	//    permissions either to launch or terminate an instance.
	//
	//    * spotFleetRequestConfigurationInvalid - The configuration is not valid.
	//    For more information, see the description of the event.
	//
	//    * spotInstanceCountLimitExceeded - You've reached the limit on the number
	//    of Spot Instances that you can launch.
	//
	// The following are the fleetRequestChange events:
	//
	//    * active - The EC2 Fleet or Spot Fleet request has been validated and
	//    Amazon EC2 is attempting to maintain the target number of running Spot
	//    Instances.
	//
	//    * cancelled - The EC2 Fleet or Spot Fleet request is canceled and has
	//    no running Spot Instances. The EC2 Fleet or Spot Fleet will be deleted
	//    two days after its instances were terminated.
	//
	//    * cancelled_running - The EC2 Fleet or Spot Fleet request is canceled
	//    and does not launch additional Spot Instances. Existing Spot Instances
	//    continue to run until they are interrupted or terminated.
	//
	//    * cancelled_terminating - The EC2 Fleet or Spot Fleet request is canceled
	//    and its Spot Instances are terminating.
	//
	//    * expired - The EC2 Fleet or Spot Fleet request has expired. A subsequent
	//    event indicates that the instances were terminated, if the request was
	//    created with TerminateInstancesWithExpiration set.
	//
	//    * modify_in_progress - A request to modify the EC2 Fleet or Spot Fleet
	//    request was accepted and is in progress.
	//
	//    * modify_successful - The EC2 Fleet or Spot Fleet request was modified.
	//
	//    * price_update - The price for a launch configuration was adjusted because
	//    it was too high. This change is permanent.
	//
	//    * submitted - The EC2 Fleet or Spot Fleet request is being evaluated and
	//    Amazon EC2 is preparing to launch the target number of Spot Instances.
	//
	// The following are the instanceChange events:
	//
	//    * launched - A request was fulfilled and a new instance was launched.
	//
	//    * terminated - An instance was terminated by the user.
	//
	// The following are the Information events:
	//
	//    * launchSpecTemporarilyBlacklisted - The configuration is not valid and
	//    several attempts to launch instances have failed. For more information,
	//    see the description of the event.
	//
	//    * launchSpecUnusable - The price in a launch specification is not valid
	//    because it is below the Spot price or the Spot price is above the On-Demand
	//    price.
	//
	//    * fleetProgressHalted - The price in every launch specification is not
	//    valid. A launch specification might become valid if the Spot price changes.
	EventSubType *string `locationName:"eventSubType" type:"string"`

	// The ID of the instance. This information is available only for instanceChange
	// events.
	InstanceId *string `locationName:"instanceId" type:"string"`
}

// String returns the string representation
func (s EventInformation) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance export task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ExportTask
type ExportTask struct {
	_ struct{} `type:"structure"`

	// A description of the resource being exported.
	Description *string `locationName:"description" type:"string"`

	// The ID of the export task.
	ExportTaskId *string `locationName:"exportTaskId" type:"string"`

	// Information about the export task.
	ExportToS3Task *ExportToS3Task `locationName:"exportToS3" type:"structure"`

	// Information about the instance to export.
	InstanceExportDetails *InstanceExportDetails `locationName:"instanceExport" type:"structure"`

	// The state of the export task.
	State ExportTaskState `locationName:"state" type:"string" enum:"true"`

	// The status message related to the export task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s ExportTask) String() string {
	return awsutil.Prettify(s)
}

// Describes the format and location for an instance export task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ExportToS3Task
type ExportToS3Task struct {
	_ struct{} `type:"structure"`

	// The container format used to combine disk images with metadata (such as OVF).
	// If absent, only the disk image is exported.
	ContainerFormat ContainerFormat `locationName:"containerFormat" type:"string" enum:"true"`

	// The format for the exported image.
	DiskImageFormat DiskImageFormat `locationName:"diskImageFormat" type:"string" enum:"true"`

	// The S3 bucket for the destination image. The destination bucket must exist
	// and grant WRITE and READ_ACP permissions to the AWS account vm-import-export@amazon.com.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The encryption key for your S3 bucket.
	S3Key *string `locationName:"s3Key" type:"string"`
}

// String returns the string representation
func (s ExportToS3Task) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance export task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ExportToS3TaskSpecification
type ExportToS3TaskSpecification struct {
	_ struct{} `type:"structure"`

	// The container format used to combine disk images with metadata (such as OVF).
	// If absent, only the disk image is exported.
	ContainerFormat ContainerFormat `locationName:"containerFormat" type:"string" enum:"true"`

	// The format for the exported image.
	DiskImageFormat DiskImageFormat `locationName:"diskImageFormat" type:"string" enum:"true"`

	// The S3 bucket for the destination image. The destination bucket must exist
	// and grant WRITE and READ_ACP permissions to the AWS account vm-import-export@amazon.com.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The image is written to a single object in the S3 bucket at the S3 key s3prefix
	// + exportTaskId + '.' + diskImageFormat.
	S3Prefix *string `locationName:"s3Prefix" type:"string"`
}

// String returns the string representation
func (s ExportToS3TaskSpecification) String() string {
	return awsutil.Prettify(s)
}

// A filter name and value pair that is used to return a more specific list
// of results from a describe operation. Filters can be used to match a set
// of resources by specific criteria, such as tags, attributes, or IDs. The
// filters supported by a describe operation are documented with the describe
// operation. For example:
//
//    * DescribeAvailabilityZones
//
//    * DescribeImages
//
//    * DescribeInstances
//
//    * DescribeKeyPairs
//
//    * DescribeSecurityGroups
//
//    * DescribeSnapshots
//
//    * DescribeSubnets
//
//    * DescribeTags
//
//    * DescribeVolumes
//
//    * DescribeVpcs
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	Name *string `type:"string"`

	// The filter values. Filter values are case-sensitive.
	Values []string `locationName:"Value" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 Fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FleetData
type FleetData struct {
	_ struct{} `type:"structure"`

	// The progress of the EC2 Fleet. If there is an error, the status is error.
	// After all requests are placed, the status is pending_fulfillment. If the
	// size of the EC2 Fleet is equal to or greater than its target capacity, the
	// status is fulfilled. If the size of the EC2 Fleet is decreased, the status
	// is pending_termination while instances are terminating.
	ActivityStatus FleetActivityStatus `locationName:"activityStatus" type:"string" enum:"true"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see Ensuring Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	//
	// Constraints: Maximum 64 ASCII characters
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The creation date and time of the EC2 Fleet.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about the instances that could not be launched by the fleet.
	// Valid only when Type is set to instant.
	Errors []DescribeFleetError `locationName:"errorSet" locationNameList:"item" type:"list"`

	// Indicates whether running instances should be terminated if the target capacity
	// of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
	ExcessCapacityTerminationPolicy FleetExcessCapacityTerminationPolicy `locationName:"excessCapacityTerminationPolicy" type:"string" enum:"true"`

	// The ID of the EC2 Fleet.
	FleetId *string `locationName:"fleetId" type:"string"`

	// The state of the EC2 Fleet.
	FleetState FleetStateCode `locationName:"fleetState" type:"string" enum:"true"`

	// The number of units fulfilled by this request compared to the set target
	// capacity.
	FulfilledCapacity *float64 `locationName:"fulfilledCapacity" type:"double"`

	// The number of units fulfilled by this request compared to the set target
	// On-Demand capacity.
	FulfilledOnDemandCapacity *float64 `locationName:"fulfilledOnDemandCapacity" type:"double"`

	// Information about the instances that were launched by the fleet. Valid only
	// when Type is set to instant.
	Instances []DescribeFleetsInstances `locationName:"fleetInstanceSet" locationNameList:"item" type:"list"`

	// The launch template and overrides.
	LaunchTemplateConfigs []FleetLaunchTemplateConfig `locationName:"launchTemplateConfigs" locationNameList:"item" type:"list"`

	// The allocation strategy of On-Demand Instances in an EC2 Fleet.
	OnDemandOptions *OnDemandOptions `locationName:"onDemandOptions" type:"structure"`

	// Indicates whether EC2 Fleet should replace unhealthy instances.
	ReplaceUnhealthyInstances *bool `locationName:"replaceUnhealthyInstances" type:"boolean"`

	// The configuration of Spot Instances in an EC2 Fleet.
	SpotOptions *SpotOptions `locationName:"spotOptions" type:"structure"`

	// The tags for an EC2 Fleet resource.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The number of units to request. You can choose to set the target capacity
	// in terms of instances or a performance characteristic that is important to
	// your application workload, such as vCPUs, memory, or I/O. If the request
	// type is maintain, you can specify a target capacity of 0 and add capacity
	// later.
	TargetCapacitySpecification *TargetCapacitySpecification `locationName:"targetCapacitySpecification" type:"structure"`

	// Indicates whether running instances should be terminated when the EC2 Fleet
	// expires.
	TerminateInstancesWithExpiration *bool `locationName:"terminateInstancesWithExpiration" type:"boolean"`

	// The type of request. Indicates whether the EC2 Fleet only requests the target
	// capacity, or also attempts to maintain it. If you request a certain target
	// capacity, EC2 Fleet only places the required requests; it does not attempt
	// to replenish instances if capacity is diminished, and does not submit requests
	// in alternative capacity pools if capacity is unavailable. To maintain a certain
	// target capacity, EC2 Fleet places the required requests to meet this target
	// capacity. It also automatically replenishes any interrupted Spot Instances.
	// Default: maintain.
	Type FleetType `locationName:"type" type:"string" enum:"true"`

	// The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// The default is to start fulfilling the request immediately.
	ValidFrom *time.Time `locationName:"validFrom" type:"timestamp" timestampFormat:"iso8601"`

	// The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// At this point, no new instance requests are placed or able to fulfill the
	// request. The default end date is 7 days from the current date.
	ValidUntil *time.Time `locationName:"validUntil" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s FleetData) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template and overrides.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FleetLaunchTemplateConfig
type FleetLaunchTemplateConfig struct {
	_ struct{} `type:"structure"`

	// The launch template.
	LaunchTemplateSpecification *FleetLaunchTemplateSpecification `locationName:"launchTemplateSpecification" type:"structure"`

	// Any parameters that you specify override the same parameters in the launch
	// template.
	Overrides []FleetLaunchTemplateOverrides `locationName:"overrides" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s FleetLaunchTemplateConfig) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template and overrides.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FleetLaunchTemplateConfigRequest
type FleetLaunchTemplateConfigRequest struct {
	_ struct{} `type:"structure"`

	// The launch template to use. You must specify either the launch template ID
	// or launch template name in the request.
	LaunchTemplateSpecification *FleetLaunchTemplateSpecificationRequest `type:"structure"`

	// Any parameters that you specify override the same parameters in the launch
	// template.
	Overrides []FleetLaunchTemplateOverridesRequest `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s FleetLaunchTemplateConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FleetLaunchTemplateConfigRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FleetLaunchTemplateConfigRequest"}
	if s.LaunchTemplateSpecification != nil {
		if err := s.LaunchTemplateSpecification.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplateSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes overrides for a launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FleetLaunchTemplateOverrides
type FleetLaunchTemplateOverrides struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to launch the instances.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	MaxPrice *string `locationName:"maxPrice" type:"string"`

	// The location where the instance launched, if applicable.
	Placement *PlacementResponse `locationName:"placement" type:"structure"`

	// The priority for the launch template override. If AllocationStrategy is set
	// to prioritized, EC2 Fleet uses priority to determine which launch template
	// override to use first in fulfilling On-Demand capacity. The highest priority
	// is launched first. Valid values are whole numbers starting at 0. The lower
	// the number, the higher the priority. If no number is set, the override has
	// the lowest priority.
	Priority *float64 `locationName:"priority" type:"double"`

	// The ID of the subnet in which to launch the instances.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The number of units provided by the specified instance type.
	WeightedCapacity *float64 `locationName:"weightedCapacity" type:"double"`
}

// String returns the string representation
func (s FleetLaunchTemplateOverrides) String() string {
	return awsutil.Prettify(s)
}

// Describes overrides for a launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FleetLaunchTemplateOverridesRequest
type FleetLaunchTemplateOverridesRequest struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to launch the instances.
	AvailabilityZone *string `type:"string"`

	// The instance type.
	InstanceType InstanceType `type:"string" enum:"true"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	MaxPrice *string `type:"string"`

	// The location where the instance launched, if applicable.
	Placement *Placement `type:"structure"`

	// The priority for the launch template override. If AllocationStrategy is set
	// to prioritized, EC2 Fleet uses priority to determine which launch template
	// override to use first in fulfilling On-Demand capacity. The highest priority
	// is launched first. Valid values are whole numbers starting at 0. The lower
	// the number, the higher the priority. If no number is set, the launch template
	// override has the lowest priority.
	Priority *float64 `type:"double"`

	// The ID of the subnet in which to launch the instances.
	SubnetId *string `type:"string"`

	// The number of units provided by the specified instance type.
	WeightedCapacity *float64 `type:"double"`
}

// String returns the string representation
func (s FleetLaunchTemplateOverridesRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FleetLaunchTemplateSpecification
type FleetLaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template. You must specify either a template ID or a
	// template name.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template. You must specify either a template name
	// or a template ID.
	LaunchTemplateName *string `locationName:"launchTemplateName" min:"3" type:"string"`

	// The version number of the launch template. You must specify a version number.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s FleetLaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FleetLaunchTemplateSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FleetLaunchTemplateSpecification"}
	if s.LaunchTemplateName != nil && len(*s.LaunchTemplateName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchTemplateName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The launch template to use. You must specify either the launch template ID
// or launch template name in the request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FleetLaunchTemplateSpecificationRequest
type FleetLaunchTemplateSpecificationRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	LaunchTemplateId *string `type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `min:"3" type:"string"`

	// The version number of the launch template.
	Version *string `type:"string"`
}

// String returns the string representation
func (s FleetLaunchTemplateSpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FleetLaunchTemplateSpecificationRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FleetLaunchTemplateSpecificationRequest"}
	if s.LaunchTemplateName != nil && len(*s.LaunchTemplateName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchTemplateName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a flow log.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FlowLog
type FlowLog struct {
	_ struct{} `type:"structure"`

	// The date and time the flow log was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about the error that occurred. Rate limited indicates that CloudWatch
	// Logs throttling has been applied for one or more network interfaces, or that
	// you've reached the limit on the number of log groups that you can create.
	// Access error indicates that the IAM role associated with the flow log does
	// not have sufficient permissions to publish to CloudWatch Logs. Unknown error
	// indicates an internal error.
	DeliverLogsErrorMessage *string `locationName:"deliverLogsErrorMessage" type:"string"`

	// The ARN of the IAM role that posts logs to CloudWatch Logs.
	DeliverLogsPermissionArn *string `locationName:"deliverLogsPermissionArn" type:"string"`

	// The status of the logs delivery (SUCCESS | FAILED).
	DeliverLogsStatus *string `locationName:"deliverLogsStatus" type:"string"`

	// The flow log ID.
	FlowLogId *string `locationName:"flowLogId" type:"string"`

	// The status of the flow log (ACTIVE).
	FlowLogStatus *string `locationName:"flowLogStatus" type:"string"`

	// Specifies the destination to which the flow log data is published. Flow log
	// data can be published to an CloudWatch Logs log group or an Amazon S3 bucket.
	// If the flow log publishes to CloudWatch Logs, this element indicates the
	// Amazon Resource Name (ARN) of the CloudWatch Logs log group to which the
	// data is published. If the flow log publishes to Amazon S3, this element indicates
	// the ARN of the Amazon S3 bucket to which the data is published.
	LogDestination *string `locationName:"logDestination" type:"string"`

	// Specifies the type of destination to which the flow log data is published.
	// Flow log data can be published to CloudWatch Logs or Amazon S3.
	LogDestinationType LogDestinationType `locationName:"logDestinationType" type:"string" enum:"true"`

	// The name of the flow log group.
	LogGroupName *string `locationName:"logGroupName" type:"string"`

	// The ID of the resource on which the flow log was created.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of traffic captured for the flow log.
	TrafficType TrafficType `locationName:"trafficType" type:"string" enum:"true"`
}

// String returns the string representation
func (s FlowLog) String() string {
	return awsutil.Prettify(s)
}

// Describes an Amazon FPGA image (AFI).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FpgaImage
type FpgaImage struct {
	_ struct{} `type:"structure"`

	// The date and time the AFI was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether data retention support is enabled for the AFI.
	DataRetentionSupport *bool `locationName:"dataRetentionSupport" type:"boolean"`

	// The description of the AFI.
	Description *string `locationName:"description" type:"string"`

	// The global FPGA image identifier (AGFI ID).
	FpgaImageGlobalId *string `locationName:"fpgaImageGlobalId" type:"string"`

	// The FPGA image identifier (AFI ID).
	FpgaImageId *string `locationName:"fpgaImageId" type:"string"`

	// The name of the AFI.
	Name *string `locationName:"name" type:"string"`

	// The alias of the AFI owner. Possible values include self, amazon, and aws-marketplace.
	OwnerAlias *string `locationName:"ownerAlias" type:"string"`

	// The AWS account ID of the AFI owner.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Information about the PCI bus.
	PciId *PciId `locationName:"pciId" type:"structure"`

	// The product codes for the AFI.
	ProductCodes []ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// Indicates whether the AFI is public.
	Public *bool `locationName:"public" type:"boolean"`

	// The version of the AWS Shell that was used to create the bitstream.
	ShellVersion *string `locationName:"shellVersion" type:"string"`

	// Information about the state of the AFI.
	State *FpgaImageState `locationName:"state" type:"structure"`

	// Any tags assigned to the AFI.
	Tags []Tag `locationName:"tags" locationNameList:"item" type:"list"`

	// The time of the most recent update to the AFI.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s FpgaImage) String() string {
	return awsutil.Prettify(s)
}

// Describes an Amazon FPGA image (AFI) attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FpgaImageAttribute
type FpgaImageAttribute struct {
	_ struct{} `type:"structure"`

	// The description of the AFI.
	Description *string `locationName:"description" type:"string"`

	// The ID of the AFI.
	FpgaImageId *string `locationName:"fpgaImageId" type:"string"`

	// The load permissions.
	LoadPermissions []LoadPermission `locationName:"loadPermissions" locationNameList:"item" type:"list"`

	// The name of the AFI.
	Name *string `locationName:"name" type:"string"`

	// The product codes.
	ProductCodes []ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s FpgaImageAttribute) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of the bitstream generation process for an Amazon FPGA
// image (AFI).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FpgaImageState
type FpgaImageState struct {
	_ struct{} `type:"structure"`

	// The state. The following are the possible values:
	//
	//    * pending - AFI bitstream generation is in progress.
	//
	//    * available - The AFI is available for use.
	//
	//    * failed - AFI bitstream generation failed.
	//
	//    * unavailable - The AFI is no longer available for use.
	Code FpgaImageStateCode `locationName:"code" type:"string" enum:"true"`

	// If the state is failed, this is the error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s FpgaImageState) String() string {
	return awsutil.Prettify(s)
}

// Describes a security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GroupIdentifier
type GroupIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s GroupIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether your instance is configured for hibernation. This parameter
// is valid only if the instance meets the hibernation prerequisites (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites).
// Hibernation is currently supported only for Amazon Linux. For more information,
// see Hibernate Your Instance (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html)
// in the Amazon Elastic Compute Cloud User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HibernationOptions
type HibernationOptions struct {
	_ struct{} `type:"structure"`

	// If this parameter is set to true, your instance is enabled for hibernation;
	// otherwise, it is not enabled for hibernation.
	Configured *bool `locationName:"configured" type:"boolean"`
}

// String returns the string representation
func (s HibernationOptions) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether your instance is configured for hibernation. This parameter
// is valid only if the instance meets the hibernation prerequisites (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites).
// Hibernation is currently supported only for Amazon Linux. For more information,
// see Hibernate Your Instance (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html)
// in the Amazon Elastic Compute Cloud User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HibernationOptionsRequest
type HibernationOptionsRequest struct {
	_ struct{} `type:"structure"`

	// If you set this parameter to true, your instance is enabled for hibernation.
	//
	// Default: false
	Configured *bool `type:"boolean"`
}

// String returns the string representation
func (s HibernationOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes an event in the history of the Spot Fleet request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HistoryRecord
type HistoryRecord struct {
	_ struct{} `type:"structure"`

	// Information about the event.
	EventInformation *EventInformation `locationName:"eventInformation" type:"structure"`

	// The event type.
	//
	//    * error - An error with the Spot Fleet request.
	//
	//    * fleetRequestChange - A change in the status or configuration of the
	//    Spot Fleet request.
	//
	//    * instanceChange - An instance was launched or terminated.
	//
	//    * Information - An informational event.
	EventType EventType `locationName:"eventType" type:"string" enum:"true"`

	// The date and time of the event, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s HistoryRecord) String() string {
	return awsutil.Prettify(s)
}

// Describes an event in the history of an EC2 Fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HistoryRecordEntry
type HistoryRecordEntry struct {
	_ struct{} `type:"structure"`

	// Information about the event.
	EventInformation *EventInformation `locationName:"eventInformation" type:"structure"`

	// The event type.
	EventType FleetEventType `locationName:"eventType" type:"string" enum:"true"`

	// The date and time of the event, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s HistoryRecordEntry) String() string {
	return awsutil.Prettify(s)
}

// Describes the properties of the Dedicated Host.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Host
type Host struct {
	_ struct{} `type:"structure"`

	// The time that the Dedicated Host was allocated.
	AllocationTime *time.Time `locationName:"allocationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Whether auto-placement is on or off.
	AutoPlacement AutoPlacement `locationName:"autoPlacement" type:"string" enum:"true"`

	// The Availability Zone of the Dedicated Host.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of new instances that can be launched onto the Dedicated Host.
	AvailableCapacity *AvailableCapacity `locationName:"availableCapacity" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure idempotency
	// of the request. For more information, see How to Ensure Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The ID of the Dedicated Host.
	HostId *string `locationName:"hostId" type:"string"`

	// The hardware specifications of the Dedicated Host.
	HostProperties *HostProperties `locationName:"hostProperties" type:"structure"`

	// The reservation ID of the Dedicated Host. This returns a null response if
	// the Dedicated Host doesn't have an associated reservation.
	HostReservationId *string `locationName:"hostReservationId" type:"string"`

	// The IDs and instance type that are currently running on the Dedicated Host.
	Instances []HostInstance `locationName:"instances" locationNameList:"item" type:"list"`

	// The time that the Dedicated Host was released.
	ReleaseTime *time.Time `locationName:"releaseTime" type:"timestamp" timestampFormat:"iso8601"`

	// The Dedicated Host's state.
	State AllocationState `locationName:"state" type:"string" enum:"true"`

	// Any tags assigned to the Dedicated Host.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s Host) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance running on a Dedicated Host.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HostInstance
type HostInstance struct {
	_ struct{} `type:"structure"`

	// the IDs of instances that are running on the Dedicated Host.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance type size (for example, m3.medium) of the running instance.
	InstanceType *string `locationName:"instanceType" type:"string"`
}

// String returns the string representation
func (s HostInstance) String() string {
	return awsutil.Prettify(s)
}

// Details about the Dedicated Host Reservation offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HostOffering
type HostOffering struct {
	_ struct{} `type:"structure"`

	// The currency of the offering.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`

	// The duration of the offering (in seconds).
	Duration *int64 `locationName:"duration" type:"integer"`

	// The hourly price of the offering.
	HourlyPrice *string `locationName:"hourlyPrice" type:"string"`

	// The instance family of the offering.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The available payment option.
	PaymentOption PaymentOption `locationName:"paymentOption" type:"string" enum:"true"`

	// The upfront price of the offering. Does not apply to No Upfront offerings.
	UpfrontPrice *string `locationName:"upfrontPrice" type:"string"`
}

// String returns the string representation
func (s HostOffering) String() string {
	return awsutil.Prettify(s)
}

// Describes properties of a Dedicated Host.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HostProperties
type HostProperties struct {
	_ struct{} `type:"structure"`

	// The number of cores on the Dedicated Host.
	Cores *int64 `locationName:"cores" type:"integer"`

	// The instance type size that the Dedicated Host supports (for example, m3.medium).
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The number of sockets on the Dedicated Host.
	Sockets *int64 `locationName:"sockets" type:"integer"`

	// The number of vCPUs on the Dedicated Host.
	TotalVCpus *int64 `locationName:"totalVCpus" type:"integer"`
}

// String returns the string representation
func (s HostProperties) String() string {
	return awsutil.Prettify(s)
}

// Details about the Dedicated Host Reservation and associated Dedicated Hosts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/HostReservation
type HostReservation struct {
	_ struct{} `type:"structure"`

	// The number of Dedicated Hosts the reservation is associated with.
	Count *int64 `locationName:"count" type:"integer"`

	// The currency in which the upfrontPrice and hourlyPrice amounts are specified.
	// At this time, the only supported currency is USD.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`

	// The length of the reservation's term, specified in seconds. Can be 31536000
	// (1 year) | 94608000 (3 years).
	Duration *int64 `locationName:"duration" type:"integer"`

	// The date and time that the reservation ends.
	End *time.Time `locationName:"end" type:"timestamp" timestampFormat:"iso8601"`

	// The IDs of the Dedicated Hosts associated with the reservation.
	HostIdSet []string `locationName:"hostIdSet" locationNameList:"item" type:"list"`

	// The ID of the reservation that specifies the associated Dedicated Hosts.
	HostReservationId *string `locationName:"hostReservationId" type:"string"`

	// The hourly price of the reservation.
	HourlyPrice *string `locationName:"hourlyPrice" type:"string"`

	// The instance family of the Dedicated Host Reservation. The instance family
	// on the Dedicated Host must be the same in order for it to benefit from the
	// reservation.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The ID of the reservation. This remains the same regardless of which Dedicated
	// Hosts are associated with it.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The payment option selected for this reservation.
	PaymentOption PaymentOption `locationName:"paymentOption" type:"string" enum:"true"`

	// The date and time that the reservation started.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`

	// The state of the reservation.
	State ReservationState `locationName:"state" type:"string" enum:"true"`

	// Any tags assigned to the Dedicated Host Reservation.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The upfront price of the reservation.
	UpfrontPrice *string `locationName:"upfrontPrice" type:"string"`
}

// String returns the string representation
func (s HostReservation) String() string {
	return awsutil.Prettify(s)
}

// Describes an IAM instance profile.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IamInstanceProfile
type IamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the instance profile.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// Describes an association between an IAM instance profile and an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IamInstanceProfileAssociation
type IamInstanceProfileAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfile `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The state of the association.
	State IamInstanceProfileAssociationState `locationName:"state" type:"string" enum:"true"`

	// The time the IAM instance profile was associated with the instance.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s IamInstanceProfileAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes an IAM instance profile.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IamInstanceProfileSpecification
type IamInstanceProfileSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the instance profile.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfileSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes the ICMP type and code.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IcmpTypeCode
type IcmpTypeCode struct {
	_ struct{} `type:"structure"`

	// The ICMP code. A value of -1 means all codes for the specified ICMP type.
	Code *int64 `locationName:"code" type:"integer"`

	// The ICMP type. A value of -1 means all types.
	Type *int64 `locationName:"type" type:"integer"`
}

// String returns the string representation
func (s IcmpTypeCode) String() string {
	return awsutil.Prettify(s)
}

// Describes the ID format for a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IdFormat
type IdFormat struct {
	_ struct{} `type:"structure"`

	// The date in UTC at which you are permanently switched over to using longer
	// IDs. If a deadline is not yet available for this resource type, this field
	// is not returned.
	Deadline *time.Time `locationName:"deadline" type:"timestamp" timestampFormat:"iso8601"`

	// The type of resource.
	Resource *string `locationName:"resource" type:"string"`

	// Indicates whether longer IDs (17-character IDs) are enabled for the resource.
	UseLongIds *bool `locationName:"useLongIds" type:"boolean"`
}

// String returns the string representation
func (s IdFormat) String() string {
	return awsutil.Prettify(s)
}

// Describes an image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Image
type Image struct {
	_ struct{} `type:"structure"`

	// The architecture of the image.
	Architecture ArchitectureValues `locationName:"architecture" type:"string" enum:"true"`

	// Any block device mapping entries.
	BlockDeviceMappings []BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// The date and time the image was created.
	CreationDate *string `locationName:"creationDate" type:"string"`

	// The description of the AMI that was provided during image creation.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether enhanced networking with ENA is enabled.
	EnaSupport *bool `locationName:"enaSupport" type:"boolean"`

	// The hypervisor type of the image.
	Hypervisor HypervisorType `locationName:"hypervisor" type:"string" enum:"true"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The location of the AMI.
	ImageLocation *string `locationName:"imageLocation" type:"string"`

	// The AWS account alias (for example, amazon, self) or the AWS account ID of
	// the AMI owner.
	ImageOwnerAlias *string `locationName:"imageOwnerAlias" type:"string"`

	// The type of image.
	ImageType ImageTypeValues `locationName:"imageType" type:"string" enum:"true"`

	// The kernel associated with the image, if any. Only applicable for machine
	// images.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the AMI that was provided during image creation.
	Name *string `locationName:"name" type:"string"`

	// The AWS account ID of the image owner.
	OwnerId *string `locationName:"imageOwnerId" type:"string"`

	// The value is Windows for Windows AMIs; otherwise blank.
	Platform PlatformValues `locationName:"platform" type:"string" enum:"true"`

	// Any product codes associated with the AMI.
	ProductCodes []ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// Indicates whether the image has public launch permissions. The value is true
	// if this image has public launch permissions or false if it has only implicit
	// and explicit launch permissions.
	Public *bool `locationName:"isPublic" type:"boolean"`

	// The RAM disk associated with the image, if any. Only applicable for machine
	// images.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// The device name of the root device volume (for example, /dev/sda1).
	RootDeviceName *string `locationName:"rootDeviceName" type:"string"`

	// The type of root device used by the AMI. The AMI can use an EBS volume or
	// an instance store volume.
	RootDeviceType DeviceType `locationName:"rootDeviceType" type:"string" enum:"true"`

	// Specifies whether enhanced networking with the Intel 82599 Virtual Function
	// interface is enabled.
	SriovNetSupport *string `locationName:"sriovNetSupport" type:"string"`

	// The current state of the AMI. If the state is available, the image is successfully
	// registered and can be used to launch an instance.
	State ImageState `locationName:"imageState" type:"string" enum:"true"`

	// The reason for the state change.
	StateReason *StateReason `locationName:"stateReason" type:"structure"`

	// Any tags assigned to the image.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of virtualization of the AMI.
	VirtualizationType VirtualizationType `locationName:"virtualizationType" type:"string" enum:"true"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// Describes the disk container object for an import image task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImageDiskContainer
type ImageDiskContainer struct {
	_ struct{} `type:"structure"`

	// The description of the disk image.
	Description *string `type:"string"`

	// The block device mapping for the disk.
	DeviceName *string `type:"string"`

	// The format of the disk image being imported.
	//
	// Valid values: VHD | VMDK | OVA
	Format *string `type:"string"`

	// The ID of the EBS snapshot to be used for importing the snapshot.
	SnapshotId *string `type:"string"`

	// The URL to the Amazon S3-based disk image being imported. The URL can either
	// be a https URL (https://..) or an Amazon S3 URL (s3://..)
	Url *string `type:"string"`

	// The S3 bucket for the disk image.
	UserBucket *UserBucket `type:"structure"`
}

// String returns the string representation
func (s ImageDiskContainer) String() string {
	return awsutil.Prettify(s)
}

// Describes an import image task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportImageTask
type ImportImageTask struct {
	_ struct{} `type:"structure"`

	// The architecture of the virtual machine.
	//
	// Valid values: i386 | x86_64
	Architecture *string `locationName:"architecture" type:"string"`

	// A description of the import task.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the image is encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The target hypervisor for the import task.
	//
	// Valid values: xen
	Hypervisor *string `locationName:"hypervisor" type:"string"`

	// The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the import image task.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// The identifier for the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) that was used to create the encrypted image.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The license type of the virtual machine.
	LicenseType *string `locationName:"licenseType" type:"string"`

	// The description string for the import image task.
	Platform *string `locationName:"platform" type:"string"`

	// The percentage of progress of the import image task.
	Progress *string `locationName:"progress" type:"string"`

	// Information about the snapshots.
	SnapshotDetails []SnapshotDetail `locationName:"snapshotDetailSet" locationNameList:"item" type:"list"`

	// A brief status for the import image task.
	Status *string `locationName:"status" type:"string"`

	// A descriptive status message for the import image task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s ImportImageTask) String() string {
	return awsutil.Prettify(s)
}

// Describes the launch specification for VM import.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportInstanceLaunchSpecification
type ImportInstanceLaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `locationName:"additionalInfo" type:"string"`

	// The architecture of the instance.
	Architecture ArchitectureValues `locationName:"architecture" type:"string" enum:"true"`

	// The security group IDs.
	GroupIds []string `locationName:"GroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The security group names.
	GroupNames []string `locationName:"GroupName" locationNameList:"SecurityGroup" type:"list"`

	// Indicates whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	InstanceInitiatedShutdownBehavior ShutdownBehavior `locationName:"instanceInitiatedShutdownBehavior" type:"string" enum:"true"`

	// The instance type. For more information about the instance types that you
	// can import, see Instance Types (https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-instance-types)
	// in the VM Import/Export User Guide.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// Indicates whether monitoring is enabled.
	Monitoring *bool `locationName:"monitoring" type:"boolean"`

	// The placement information for the instance.
	Placement *Placement `locationName:"placement" type:"structure"`

	// [EC2-VPC] An available IP address from the IP address range of the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// [EC2-VPC] The ID of the subnet in which to launch the instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The Base64-encoded user data to make available to the instance.
	UserData *UserData `locationName:"userData" type:"structure"`
}

// String returns the string representation
func (s ImportInstanceLaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes an import instance task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportInstanceTaskDetails
type ImportInstanceTaskDetails struct {
	_ struct{} `type:"structure"`

	// A description of the task.
	Description *string `locationName:"description" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance operating system.
	Platform PlatformValues `locationName:"platform" type:"string" enum:"true"`

	// The volumes.
	Volumes []ImportInstanceVolumeDetailItem `locationName:"volumes" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ImportInstanceTaskDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes an import volume task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportInstanceVolumeDetailItem
type ImportInstanceVolumeDetailItem struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the resulting instance will reside.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of bytes converted so far.
	BytesConverted *int64 `locationName:"bytesConverted" type:"long"`

	// A description of the task.
	Description *string `locationName:"description" type:"string"`

	// The image.
	Image *DiskImageDescription `locationName:"image" type:"structure"`

	// The status of the import of this particular disk image.
	Status *string `locationName:"status" type:"string"`

	// The status information or errors related to the disk image.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The volume.
	Volume *DiskImageVolumeDescription `locationName:"volume" type:"structure"`
}

// String returns the string representation
func (s ImportInstanceVolumeDetailItem) String() string {
	return awsutil.Prettify(s)
}

// Describes an import snapshot task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportSnapshotTask
type ImportSnapshotTask struct {
	_ struct{} `type:"structure"`

	// A description of the import snapshot task.
	Description *string `locationName:"description" type:"string"`

	// The ID of the import snapshot task.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// Describes an import snapshot task.
	SnapshotTaskDetail *SnapshotTaskDetail `locationName:"snapshotTaskDetail" type:"structure"`
}

// String returns the string representation
func (s ImportSnapshotTask) String() string {
	return awsutil.Prettify(s)
}

// Describes an import volume task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportVolumeTaskDetails
type ImportVolumeTaskDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the resulting volume will reside.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of bytes converted so far.
	BytesConverted *int64 `locationName:"bytesConverted" type:"long"`

	// The description you provided when starting the import volume task.
	Description *string `locationName:"description" type:"string"`

	// The image.
	Image *DiskImageDescription `locationName:"image" type:"structure"`

	// The volume.
	Volume *DiskImageVolumeDescription `locationName:"volume" type:"structure"`
}

// String returns the string representation
func (s ImportVolumeTaskDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// The AMI launch index, which can be used to find this instance in the launch
	// group.
	AmiLaunchIndex *int64 `locationName:"amiLaunchIndex" type:"integer"`

	// The architecture of the image.
	Architecture ArchitectureValues `locationName:"architecture" type:"string" enum:"true"`

	// Any block device mapping entries for the instance.
	BlockDeviceMappings []InstanceBlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// The ID of the Capacity Reservation.
	CapacityReservationId *string `locationName:"capacityReservationId" type:"string"`

	// Information about the Capacity Reservation targeting option.
	CapacityReservationSpecification *CapacityReservationSpecificationResponse `locationName:"capacityReservationSpecification" type:"structure"`

	// The idempotency token you provided when you launched the instance, if applicable.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The CPU options for the instance.
	CpuOptions *CpuOptions `locationName:"cpuOptions" type:"structure"`

	// Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The Elastic GPU associated with the instance.
	ElasticGpuAssociations []ElasticGpuAssociation `locationName:"elasticGpuAssociationSet" locationNameList:"item" type:"list"`

	// The elastic inference accelerator associated with the instance.
	ElasticInferenceAcceleratorAssociations []ElasticInferenceAcceleratorAssociation `locationName:"elasticInferenceAcceleratorAssociationSet" locationNameList:"item" type:"list"`

	// Specifies whether enhanced networking with ENA is enabled.
	EnaSupport *bool `locationName:"enaSupport" type:"boolean"`

	// Indicates whether the instance is enabled for hibernation.
	HibernationOptions *HibernationOptions `locationName:"hibernationOptions" type:"structure"`

	// The hypervisor type of the instance.
	Hypervisor HypervisorType `locationName:"hypervisor" type:"string" enum:"true"`

	// The IAM instance profile associated with the instance, if applicable.
	IamInstanceProfile *IamInstanceProfile `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI used to launch the instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Indicates whether this is a Spot Instance or a Scheduled Instance.
	InstanceLifecycle InstanceLifecycleType `locationName:"instanceLifecycle" type:"string" enum:"true"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The kernel associated with this instance, if applicable.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair, if this instance was launched with an associated
	// key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// The time the instance was launched.
	LaunchTime *time.Time `locationName:"launchTime" type:"timestamp" timestampFormat:"iso8601"`

	// The license configurations.
	Licenses []LicenseConfiguration `locationName:"licenseSet" locationNameList:"item" type:"list"`

	// The monitoring for the instance.
	Monitoring *Monitoring `locationName:"monitoring" type:"structure"`

	// [EC2-VPC] The network interfaces for the instance.
	NetworkInterfaces []InstanceNetworkInterface `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`

	// The location where the instance launched, if applicable.
	Placement *Placement `locationName:"placement" type:"structure"`

	// The value is Windows for Windows instances; otherwise blank.
	Platform PlatformValues `locationName:"platform" type:"string" enum:"true"`

	// (IPv4 only) The private DNS hostname name assigned to the instance. This
	// DNS hostname can only be used inside the Amazon EC2 network. This name is
	// not available until the instance enters the running state.
	//
	// [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private
	// DNS hostnames if you've enabled DNS resolution and DNS hostnames in your
	// VPC. If you are not using the Amazon-provided DNS server in your VPC, your
	// custom domain name servers must resolve the hostname as appropriate.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IPv4 address assigned to the instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The product codes attached to this instance, if applicable.
	ProductCodes []ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// (IPv4 only) The public DNS name assigned to the instance. This name is not
	// available until the instance enters the running state. For EC2-VPC, this
	// name is only available if you've enabled DNS hostnames for your VPC.
	PublicDnsName *string `locationName:"dnsName" type:"string"`

	// The public IPv4 address assigned to the instance, if applicable.
	PublicIpAddress *string `locationName:"ipAddress" type:"string"`

	// The RAM disk associated with this instance, if applicable.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// The device name of the root device volume (for example, /dev/sda1).
	RootDeviceName *string `locationName:"rootDeviceName" type:"string"`

	// The root device type used by the AMI. The AMI can use an EBS volume or an
	// instance store volume.
	RootDeviceType DeviceType `locationName:"rootDeviceType" type:"string" enum:"true"`

	// The security groups for the instance.
	SecurityGroups []GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// Specifies whether to enable an instance launched in a VPC to perform NAT.
	// This controls whether source/destination checking is enabled on the instance.
	// A value of true means that checking is enabled, and false means that checking
	// is disabled. The value must be false for the instance to perform NAT. For
	// more information, see NAT Instances (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SourceDestCheck *bool `locationName:"sourceDestCheck" type:"boolean"`

	// If the request is a Spot Instance request, the ID of the request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`

	// Specifies whether enhanced networking with the Intel 82599 Virtual Function
	// interface is enabled.
	SriovNetSupport *string `locationName:"sriovNetSupport" type:"string"`

	// The current state of the instance.
	State *InstanceState `locationName:"instanceState" type:"structure"`

	// The reason for the most recent state transition.
	StateReason *StateReason `locationName:"stateReason" type:"structure"`

	// The reason for the most recent state transition. This might be an empty string.
	StateTransitionReason *string `locationName:"reason" type:"string"`

	// [EC2-VPC] The ID of the subnet in which the instance is running.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// Any tags assigned to the instance.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The virtualization type of the instance.
	VirtualizationType VirtualizationType `locationName:"virtualizationType" type:"string" enum:"true"`

	// [EC2-VPC] The ID of the VPC in which the instance is running.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceBlockDeviceMapping
type InstanceBlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name (for example, /dev/sdh or xvdh).
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *EbsInstanceBlockDevice `locationName:"ebs" type:"structure"`
}

// String returns the string representation
func (s InstanceBlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping entry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceBlockDeviceMappingSpecification
type InstanceBlockDeviceMappingSpecification struct {
	_ struct{} `type:"structure"`

	// The device name (for example, /dev/sdh or xvdh).
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *EbsInstanceBlockDeviceSpecification `locationName:"ebs" type:"structure"`

	// suppress the specified device included in the block device mapping.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// The virtual device name.
	VirtualName *string `locationName:"virtualName" type:"string"`
}

// String returns the string representation
func (s InstanceBlockDeviceMappingSpecification) String() string {
	return awsutil.Prettify(s)
}

// Information about the instance type that the Dedicated Host supports.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceCapacity
type InstanceCapacity struct {
	_ struct{} `type:"structure"`

	// The number of instances that can still be launched onto the Dedicated Host.
	AvailableCapacity *int64 `locationName:"availableCapacity" type:"integer"`

	// The instance type size supported by the Dedicated Host.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The total number of instances that can be launched onto the Dedicated Host.
	TotalCapacity *int64 `locationName:"totalCapacity" type:"integer"`
}

// String returns the string representation
func (s InstanceCapacity) String() string {
	return awsutil.Prettify(s)
}

// Describes a Reserved Instance listing state.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceCount
type InstanceCount struct {
	_ struct{} `type:"structure"`

	// The number of listed Reserved Instances in the state specified by the state.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The states of the listed Reserved Instances.
	State ListingState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceCount) String() string {
	return awsutil.Prettify(s)
}

// Describes the credit option for CPU usage of a T2 or T3 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceCreditSpecification
type InstanceCreditSpecification struct {
	_ struct{} `type:"structure"`

	// The credit option for CPU usage of the instance. Valid values are standard
	// and unlimited.
	CpuCredits *string `locationName:"cpuCredits" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`
}

// String returns the string representation
func (s InstanceCreditSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes the credit option for CPU usage of a T2 or T3 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceCreditSpecificationRequest
type InstanceCreditSpecificationRequest struct {
	_ struct{} `type:"structure"`

	// The credit option for CPU usage of the instance. Valid values are standard
	// and unlimited.
	CpuCredits *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s InstanceCreditSpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance to export.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceExportDetails
type InstanceExportDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the resource being exported.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The target virtualization environment.
	TargetEnvironment ExportEnvironment `locationName:"targetEnvironment" type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceExportDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv6 address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceIpv6Address
type InstanceIpv6Address struct {
	_ struct{} `type:"structure"`

	// The IPv6 address.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`
}

// String returns the string representation
func (s InstanceIpv6Address) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv6 address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceIpv6AddressRequest
type InstanceIpv6AddressRequest struct {
	_ struct{} `type:"structure"`

	// The IPv6 address.
	Ipv6Address *string `type:"string"`
}

// String returns the string representation
func (s InstanceIpv6AddressRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the market (purchasing) option for the instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceMarketOptionsRequest
type InstanceMarketOptionsRequest struct {
	_ struct{} `type:"structure"`

	// The market type.
	MarketType MarketType `type:"string" enum:"true"`

	// The options for Spot Instances.
	SpotOptions *SpotMarketOptions `type:"structure"`
}

// String returns the string representation
func (s InstanceMarketOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the monitoring of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceMonitoring
type InstanceMonitoring struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The monitoring for the instance.
	Monitoring *Monitoring `locationName:"monitoring" type:"structure"`
}

// String returns the string representation
func (s InstanceMonitoring) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceNetworkInterface
type InstanceNetworkInterface struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IPv4 associated with the network
	// interface.
	Association *InstanceNetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// The network interface attachment.
	Attachment *InstanceNetworkInterfaceAttachment `locationName:"attachment" type:"structure"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// One or more security groups.
	Groups []GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// Describes the type of network interface.
	//
	// Valid values: interface | efa
	InterfaceType *string `locationName:"interfaceType" type:"string"`

	// One or more IPv6 addresses associated with the network interface.
	Ipv6Addresses []InstanceIpv6Address `locationName:"ipv6AddressesSet" locationNameList:"item" type:"list"`

	// The MAC address.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the AWS account that created the network interface.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The private DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// One or more private IPv4 addresses associated with the network interface.
	PrivateIpAddresses []InstancePrivateIpAddress `locationName:"privateIpAddressesSet" locationNameList:"item" type:"list"`

	// Indicates whether to validate network traffic to or from this network interface.
	SourceDestCheck *bool `locationName:"sourceDestCheck" type:"boolean"`

	// The status of the network interface.
	Status NetworkInterfaceStatus `locationName:"status" type:"string" enum:"true"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s InstanceNetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// Describes association information for an Elastic IP address (IPv4).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceNetworkInterfaceAssociation
type InstanceNetworkInterfaceAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the owner of the Elastic IP address.
	IpOwnerId *string `locationName:"ipOwnerId" type:"string"`

	// The public DNS name.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// The public IP address or Elastic IP address bound to the network interface.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s InstanceNetworkInterfaceAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface attachment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceNetworkInterfaceAttachment
type InstanceNetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The time stamp when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The index of the device on the instance for the network interface attachment.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer"`

	// The attachment state.
	Status AttachmentStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceNetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceNetworkInterfaceSpecification
type InstanceNetworkInterfaceSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether to assign a public IPv4 address to an instance you launch
	// in a VPC. The public IP address can only be assigned to a network interface
	// for eth0, and can only be assigned to a new network interface, not an existing
	// one. You cannot specify more than one network interface in the request. If
	// launching into a default subnet, the default value is true.
	AssociatePublicIpAddress *bool `locationName:"associatePublicIpAddress" type:"boolean"`

	// If set to true, the interface is deleted when the instance is terminated.
	// You can specify true only if creating a new network interface when launching
	// an instance.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The description of the network interface. Applies only if creating a network
	// interface when launching an instance.
	Description *string `locationName:"description" type:"string"`

	// The position of the network interface in the attachment order. A primary
	// network interface has a device index of 0.
	//
	// If you specify a network interface when launching an instance, you must specify
	// the device index.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer"`

	// The IDs of the security groups for the network interface. Applies only if
	// creating a network interface when launching an instance.
	Groups []string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The type of network interface. To create an Elastic Fabric Adapter (EFA),
	// specify efa. For more information, see Elastic Fabric Adapter (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// If you are not creating an EFA, specify interface or omit this parameter.
	//
	// Valide values: interface | efa
	InterfaceType *string `type:"string"`

	// A number of IPv6 addresses to assign to the network interface. Amazon EC2
	// chooses the IPv6 addresses from the range of the subnet. You cannot specify
	// this option and the option to assign specific IPv6 addresses in the same
	// request. You can specify this option if you've specified a minimum number
	// of instances to launch.
	Ipv6AddressCount *int64 `locationName:"ipv6AddressCount" type:"integer"`

	// One or more IPv6 addresses to assign to the network interface. You cannot
	// specify this option and the option to assign a number of IPv6 addresses in
	// the same request. You cannot specify this option if you've specified a minimum
	// number of instances to launch.
	Ipv6Addresses []InstanceIpv6Address `locationName:"ipv6AddressesSet" queryName:"Ipv6Addresses" locationNameList:"item" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The private IPv4 address of the network interface. Applies only if creating
	// a network interface when launching an instance. You cannot specify this option
	// if you're launching more than one instance in a RunInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html)
	// request.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// One or more private IPv4 addresses to assign to the network interface. Only
	// one private IPv4 address can be designated as primary. You cannot specify
	// this option if you're launching more than one instance in a RunInstances
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html)
	// request.
	PrivateIpAddresses []PrivateIpAddressSpecification `locationName:"privateIpAddressesSet" queryName:"PrivateIpAddresses" locationNameList:"item" type:"list"`

	// The number of secondary private IPv4 addresses. You can't specify this option
	// and specify more than one private IP address using the private IP addresses
	// option. You cannot specify this option if you're launching more than one
	// instance in a RunInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html)
	// request.
	SecondaryPrivateIpAddressCount *int64 `locationName:"secondaryPrivateIpAddressCount" type:"integer"`

	// The ID of the subnet associated with the network string. Applies only if
	// creating a network interface when launching an instance.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s InstanceNetworkInterfaceSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes a private IPv4 address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstancePrivateIpAddress
type InstancePrivateIpAddress struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IP address for the network interface.
	Association *InstanceNetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// Indicates whether this IPv4 address is the primary private IP address of
	// the network interface.
	Primary *bool `locationName:"primary" type:"boolean"`

	// The private IPv4 DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IPv4 address of the network interface.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s InstancePrivateIpAddress) String() string {
	return awsutil.Prettify(s)
}

// Describes the current state of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceState
type InstanceState struct {
	_ struct{} `type:"structure"`

	// The state of the instance as a 16-bit unsigned integer.
	//
	// The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal
	// values between 256 and 65,535. These numerical values are used for internal
	// purposes and should be ignored.
	//
	// The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal
	// values between 0 and 255.
	//
	// The valid values for instance-state-code will all be in the range of the
	// low byte and they are:
	//
	//    * 0 : pending
	//
	//    * 16 : running
	//
	//    * 32 : shutting-down
	//
	//    * 48 : terminated
	//
	//    * 64 : stopping
	//
	//    * 80 : stopped
	//
	// You can ignore the high byte value by zeroing out all of the bits above 2^8
	// or 256 in decimal.
	Code *int64 `locationName:"code" type:"integer"`

	// The current state of the instance.
	Name InstanceStateName `locationName:"name" type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceState) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance state change.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceStateChange
type InstanceStateChange struct {
	_ struct{} `type:"structure"`

	// The current state of the instance.
	CurrentState *InstanceState `locationName:"currentState" type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The previous state of the instance.
	PreviousState *InstanceState `locationName:"previousState" type:"structure"`
}

// String returns the string representation
func (s InstanceStateChange) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceStatus
type InstanceStatus struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// Any scheduled events associated with the instance.
	Events []InstanceStatusEvent `locationName:"eventsSet" locationNameList:"item" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The intended state of the instance. DescribeInstanceStatus requires that
	// an instance be in the running state.
	InstanceState *InstanceState `locationName:"instanceState" type:"structure"`

	// Reports impaired functionality that stems from issues internal to the instance,
	// such as impaired reachability.
	InstanceStatus *InstanceStatusSummary `locationName:"instanceStatus" type:"structure"`

	// Reports impaired functionality that stems from issues related to the systems
	// that support an instance, such as hardware failures and network connectivity
	// problems.
	SystemStatus *InstanceStatusSummary `locationName:"systemStatus" type:"structure"`
}

// String returns the string representation
func (s InstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes the instance status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceStatusDetails
type InstanceStatusDetails struct {
	_ struct{} `type:"structure"`

	// The time when a status check failed. For an instance that was launched and
	// impaired, this is the time when the instance was launched.
	ImpairedSince *time.Time `locationName:"impairedSince" type:"timestamp" timestampFormat:"iso8601"`

	// The type of instance status.
	Name StatusName `locationName:"name" type:"string" enum:"true"`

	// The status.
	Status StatusType `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes a scheduled event for an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceStatusEvent
type InstanceStatusEvent struct {
	_ struct{} `type:"structure"`

	// The event code.
	Code EventCode `locationName:"code" type:"string" enum:"true"`

	// A description of the event.
	//
	// After a scheduled event is completed, it can still be described for up to
	// a week. If the event has been completed, this description starts with the
	// following text: [Completed].
	Description *string `locationName:"description" type:"string"`

	// The ID of the event.
	InstanceEventId *string `locationName:"instanceEventId" type:"string"`

	// The latest scheduled end time for the event.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The earliest scheduled start time for the event.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The deadline for starting the event.
	NotBeforeDeadline *time.Time `locationName:"notBeforeDeadline" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s InstanceStatusEvent) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceStatusSummary
type InstanceStatusSummary struct {
	_ struct{} `type:"structure"`

	// The system instance health or application instance health.
	Details []InstanceStatusDetails `locationName:"details" locationNameList:"item" type:"list"`

	// The status.
	Status SummaryStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceStatusSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes an internet gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InternetGateway
type InternetGateway struct {
	_ struct{} `type:"structure"`

	// Any VPCs attached to the internet gateway.
	Attachments []InternetGatewayAttachment `locationName:"attachmentSet" locationNameList:"item" type:"list"`

	// The ID of the internet gateway.
	InternetGatewayId *string `locationName:"internetGatewayId" type:"string"`

	// The ID of the AWS account that owns the internet gateway.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Any tags assigned to the internet gateway.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s InternetGateway) String() string {
	return awsutil.Prettify(s)
}

// Describes the attachment of a VPC to an internet gateway or an egress-only
// internet gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InternetGatewayAttachment
type InternetGatewayAttachment struct {
	_ struct{} `type:"structure"`

	// The current state of the attachment. For an internet gateway, the state is
	// available when attached to a VPC; otherwise, this value is not returned.
	State AttachmentStatus `locationName:"state" type:"string" enum:"true"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s InternetGatewayAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes a set of permissions for a security group rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IpPermission
type IpPermission struct {
	_ struct{} `type:"structure"`

	// The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number. A value of -1 indicates all ICMP/ICMPv6 types. If you specify
	// all ICMP/ICMPv6 types, you must specify all codes.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number (see Protocol Numbers
	// (http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
	//
	// [VPC only] Use -1 to specify all protocols. When authorizing security group
	// rules, specifying -1 or a protocol number other than tcp, udp, icmp, or icmpv6
	// allows traffic on all ports, regardless of any port range you specify. For
	// tcp, udp, and icmp, you must specify a port range. For icmpv6, the port range
	// is optional; if you omit the port range, traffic for all types and codes
	// is allowed.
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// The IPv4 ranges.
	IpRanges []IpRange `locationName:"ipRanges" locationNameList:"item" type:"list"`

	// [VPC only] The IPv6 ranges.
	Ipv6Ranges []Ipv6Range `locationName:"ipv6Ranges" locationNameList:"item" type:"list"`

	// [VPC only] The prefix list IDs for an AWS service. With outbound rules, this
	// is the AWS service to access through a VPC endpoint from instances associated
	// with the security group.
	PrefixListIds []PrefixListId `locationName:"prefixListIds" locationNameList:"item" type:"list"`

	// The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort *int64 `locationName:"toPort" type:"integer"`

	// The security group and AWS account ID pairs.
	UserIdGroupPairs []UserIdGroupPair `locationName:"groups" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s IpPermission) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv4 range.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IpRange
type IpRange struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR range. You can either specify a CIDR range or a source security
	// group, not both. To specify a single IPv4 address, use the /32 prefix length.
	CidrIp *string `locationName:"cidrIp" type:"string"`

	// A description for the security group rule that references this IPv4 address
	// range.
	//
	// Constraints: Up to 255 characters in length. Allowed characters are a-z,
	// A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s IpRange) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv6 CIDR block.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Ipv6CidrBlock
type Ipv6CidrBlock struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR block.
	Ipv6CidrBlock *string `locationName:"ipv6CidrBlock" type:"string"`
}

// String returns the string representation
func (s Ipv6CidrBlock) String() string {
	return awsutil.Prettify(s)
}

// [EC2-VPC only] Describes an IPv6 range.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Ipv6Range
type Ipv6Range struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR range. You can either specify a CIDR range or a source security
	// group, not both. To specify a single IPv6 address, use the /128 prefix length.
	CidrIpv6 *string `locationName:"cidrIpv6" type:"string"`

	// A description for the security group rule that references this IPv6 address
	// range.
	//
	// Constraints: Up to 255 characters in length. Allowed characters are a-z,
	// A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s Ipv6Range) String() string {
	return awsutil.Prettify(s)
}

// Describes a key pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/KeyPairInfo
type KeyPairInfo struct {
	_ struct{} `type:"structure"`

	// If you used CreateKeyPair to create the key pair, this is the SHA-1 digest
	// of the DER encoded private key. If you used ImportKeyPair to provide AWS
	// the public key, this is the MD5 public key fingerprint as specified in section
	// 4 of RFC4716.
	KeyFingerprint *string `locationName:"keyFingerprint" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`
}

// String returns the string representation
func (s KeyPairInfo) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch permission.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchPermission
type LaunchPermission struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group PermissionGroup `locationName:"group" type:"string" enum:"true"`

	// The AWS account ID.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s LaunchPermission) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch permission modification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchPermissionModifications
type LaunchPermissionModifications struct {
	_ struct{} `type:"structure"`

	// The AWS account ID to add to the list of launch permissions for the AMI.
	Add []LaunchPermission `locationNameList:"item" type:"list"`

	// The AWS account ID to remove from the list of launch permissions for the
	// AMI.
	Remove []LaunchPermission `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s LaunchPermissionModifications) String() string {
	return awsutil.Prettify(s)
}

// Describes the launch specification for an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchSpecification
type LaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Deprecated.
	AddressingType *string `locationName:"addressingType" type:"string"`

	// One or more block device mapping entries.
	BlockDeviceMappings []BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// Indicates whether the instance is optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	//
	// Default: false
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The ID of the kernel.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// Describes the monitoring of an instance.
	Monitoring *RunInstancesMonitoringEnabled `locationName:"monitoring" type:"structure"`

	// One or more network interfaces. If you specify a network interface, you must
	// specify subnet IDs and security group IDs using the network interface.
	NetworkInterfaces []InstanceNetworkInterfaceSpecification `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`

	// The placement information for the instance.
	Placement *SpotPlacement `locationName:"placement" type:"structure"`

	// The ID of the RAM disk.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// One or more security groups. When requesting instances in a VPC, you must
	// specify the IDs of the security groups. When requesting instances in EC2-Classic,
	// you can specify the names or the IDs of the security groups.
	SecurityGroups []GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the subnet in which to launch the instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The Base64-encoded user data for the instance.
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s LaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplate
type LaunchTemplate struct {
	_ struct{} `type:"structure"`

	// The time launch template was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// The principal that created the launch template.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The version number of the default version of the launch template.
	DefaultVersionNumber *int64 `locationName:"defaultVersionNumber" type:"long"`

	// The version number of the latest version of the launch template.
	LatestVersionNumber *int64 `locationName:"latestVersionNumber" type:"long"`

	// The ID of the launch template.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `locationName:"launchTemplateName" min:"3" type:"string"`

	// The tags for the launch template.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s LaunchTemplate) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template and overrides.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateAndOverridesResponse
type LaunchTemplateAndOverridesResponse struct {
	_ struct{} `type:"structure"`

	// The launch template.
	LaunchTemplateSpecification *FleetLaunchTemplateSpecification `locationName:"launchTemplateSpecification" type:"structure"`

	// Any parameters that you specify override the same parameters in the launch
	// template.
	Overrides *FleetLaunchTemplateOverrides `locationName:"overrides" type:"structure"`
}

// String returns the string representation
func (s LaunchTemplateAndOverridesResponse) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateBlockDeviceMapping
type LaunchTemplateBlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Information about the block device for an EBS volume.
	Ebs *LaunchTemplateEbsBlockDevice `locationName:"ebs" type:"structure"`

	// Suppresses the specified device included in the block device mapping of the
	// AMI.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// The virtual device name (ephemeralN).
	VirtualName *string `locationName:"virtualName" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateBlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateBlockDeviceMappingRequest
type LaunchTemplateBlockDeviceMappingRequest struct {
	_ struct{} `type:"structure"`

	// The device name (for example, /dev/sdh or xvdh).
	DeviceName *string `type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *LaunchTemplateEbsBlockDeviceRequest `type:"structure"`

	// Suppresses the specified device included in the block device mapping of the
	// AMI.
	NoDevice *string `type:"string"`

	// The virtual device name (ephemeralN). Instance store volumes are numbered
	// starting from 0. An instance type with 2 available instance store volumes
	// can specify mappings for ephemeral0 and ephemeral1. The number of available
	// instance store volumes depends on the instance type. After you connect to
	// the instance, you must mount the volume.
	VirtualName *string `type:"string"`
}

// String returns the string representation
func (s LaunchTemplateBlockDeviceMappingRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance's Capacity Reservation targeting option. You can specify
// only one option at a time. Use the CapacityReservationPreference parameter
// to configure the instance to run in On-Demand capacity or to run in any open
// Capacity Reservation that has matching attributes (instance type, platform,
// Availability Zone). Use the CapacityReservationTarget parameter to explicitly
// target a specific Capacity Reservation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateCapacityReservationSpecificationRequest
type LaunchTemplateCapacityReservationSpecificationRequest struct {
	_ struct{} `type:"structure"`

	// Indicates the instance's Capacity Reservation preferences. Possible preferences
	// include:
	//
	//    * open - The instance can run in any open Capacity Reservation that has
	//    matching attributes (instance type, platform, Availability Zone).
	//
	//    * none - The instance avoids running in a Capacity Reservation even if
	//    one is available. The instance runs in On-Demand capacity.
	CapacityReservationPreference CapacityReservationPreference `type:"string" enum:"true"`

	// Information about the target Capacity Reservation.
	CapacityReservationTarget *CapacityReservationTarget `type:"structure"`
}

// String returns the string representation
func (s LaunchTemplateCapacityReservationSpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// Information about the Capacity Reservation targeting option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateCapacityReservationSpecificationResponse
type LaunchTemplateCapacityReservationSpecificationResponse struct {
	_ struct{} `type:"structure"`

	// Indicates the instance's Capacity Reservation preferences. Possible preferences
	// include:
	//
	//    * open - The instance can run in any open Capacity Reservation that has
	//    matching attributes (instance type, platform, Availability Zone).
	//
	//    * none - The instance avoids running in a Capacity Reservation even if
	//    one is available. The instance runs in On-Demand capacity.
	CapacityReservationPreference CapacityReservationPreference `locationName:"capacityReservationPreference" type:"string" enum:"true"`

	// Information about the target Capacity Reservation.
	CapacityReservationTarget *CapacityReservationTargetResponse `locationName:"capacityReservationTarget" type:"structure"`
}

// String returns the string representation
func (s LaunchTemplateCapacityReservationSpecificationResponse) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template and overrides.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateConfig
type LaunchTemplateConfig struct {
	_ struct{} `type:"structure"`

	// The launch template.
	LaunchTemplateSpecification *FleetLaunchTemplateSpecification `locationName:"launchTemplateSpecification" type:"structure"`

	// Any parameters that you specify override the same parameters in the launch
	// template.
	Overrides []LaunchTemplateOverrides `locationName:"overrides" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s LaunchTemplateConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplateConfig"}
	if s.LaunchTemplateSpecification != nil {
		if err := s.LaunchTemplateSpecification.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplateSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The CPU options for the instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateCpuOptions
type LaunchTemplateCpuOptions struct {
	_ struct{} `type:"structure"`

	// The number of CPU cores for the instance.
	CoreCount *int64 `locationName:"coreCount" type:"integer"`

	// The number of threads per CPU core.
	ThreadsPerCore *int64 `locationName:"threadsPerCore" type:"integer"`
}

// String returns the string representation
func (s LaunchTemplateCpuOptions) String() string {
	return awsutil.Prettify(s)
}

// The CPU options for the instance. Both the core count and threads per core
// must be specified in the request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateCpuOptionsRequest
type LaunchTemplateCpuOptionsRequest struct {
	_ struct{} `type:"structure"`

	// The number of CPU cores for the instance.
	CoreCount *int64 `type:"integer"`

	// The number of threads per CPU core. To disable Intel Hyper-Threading Technology
	// for the instance, specify a value of 1. Otherwise, specify the default value
	// of 2.
	ThreadsPerCore *int64 `type:"integer"`
}

// String returns the string representation
func (s LaunchTemplateCpuOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device for an EBS volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateEbsBlockDevice
type LaunchTemplateEbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// Indicates whether the EBS volume is encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	Iops *int64 `locationName:"iops" type:"integer"`

	// The ARN of the AWS Key Management Service (AWS KMS) CMK used for encryption.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The ID of the snapshot.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// The size of the volume, in GiB.
	VolumeSize *int64 `locationName:"volumeSize" type:"integer"`

	// The volume type.
	VolumeType VolumeType `locationName:"volumeType" type:"string" enum:"true"`
}

// String returns the string representation
func (s LaunchTemplateEbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// The parameters for a block device for an EBS volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateEbsBlockDeviceRequest
type LaunchTemplateEbsBlockDeviceRequest struct {
	_ struct{} `type:"structure"`

	// Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool `type:"boolean"`

	// Indicates whether the EBS volume is encrypted. Encrypted volumes can only
	// be attached to instances that support Amazon EBS encryption. If you are creating
	// a volume from a snapshot, you can't specify an encryption value.
	Encrypted *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For io1, this represents the number of IOPS that are provisioned for the
	// volume. For gp2, this represents the baseline performance of the volume and
	// the rate at which the volume accumulates I/O credits for bursting. For more
	// information about General Purpose SSD baseline performance, I/O credits,
	// and bursting, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Condition: This parameter is required for requests to create io1 volumes;
	// it is not used in requests to create gp2, st1, sc1, or standard volumes.
	Iops *int64 `type:"integer"`

	// The ARN of the AWS Key Management Service (AWS KMS) CMK used for encryption.
	KmsKeyId *string `type:"string"`

	// The ID of the snapshot.
	SnapshotId *string `type:"string"`

	// The size of the volume, in GiB.
	//
	// Default: If you're creating the volume from a snapshot and don't specify
	// a volume size, the default is the snapshot size.
	VolumeSize *int64 `type:"integer"`

	// The volume type.
	VolumeType VolumeType `type:"string" enum:"true"`
}

// String returns the string representation
func (s LaunchTemplateEbsBlockDeviceRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes an elastic inference accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateElasticInferenceAccelerator
type LaunchTemplateElasticInferenceAccelerator struct {
	_ struct{} `type:"structure"`

	// The type of elastic inference accelerator. The possible values are eia1.medium,
	// eia1.large, and eia1.xlarge.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LaunchTemplateElasticInferenceAccelerator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateElasticInferenceAccelerator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplateElasticInferenceAccelerator"}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an elastic inference accelerator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateElasticInferenceAcceleratorResponse
type LaunchTemplateElasticInferenceAcceleratorResponse struct {
	_ struct{} `type:"structure"`

	// The type of elastic inference accelerator. The possible values are eia1.medium,
	// eia1.large, and eia1.xlarge.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateElasticInferenceAcceleratorResponse) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether an instance is configured for hibernation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateHibernationOptions
type LaunchTemplateHibernationOptions struct {
	_ struct{} `type:"structure"`

	// If this parameter is set to true, the instance is enabled for hibernation;
	// otherwise, it is not enabled for hibernation.
	Configured *bool `locationName:"configured" type:"boolean"`
}

// String returns the string representation
func (s LaunchTemplateHibernationOptions) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether the instance is configured for hibernation. This parameter
// is valid only if the instance meets the hibernation prerequisites (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites).
// Hibernation is currently supported only for Amazon Linux.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateHibernationOptionsRequest
type LaunchTemplateHibernationOptionsRequest struct {
	_ struct{} `type:"structure"`

	// If you set this parameter to true, the instance is enabled for hibernation.
	//
	// Default: false
	Configured *bool `type:"boolean"`
}

// String returns the string representation
func (s LaunchTemplateHibernationOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes an IAM instance profile.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateIamInstanceProfileSpecification
type LaunchTemplateIamInstanceProfileSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the instance profile.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateIamInstanceProfileSpecification) String() string {
	return awsutil.Prettify(s)
}

// An IAM instance profile.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateIamInstanceProfileSpecificationRequest
type LaunchTemplateIamInstanceProfileSpecificationRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `type:"string"`

	// The name of the instance profile.
	Name *string `type:"string"`
}

// String returns the string representation
func (s LaunchTemplateIamInstanceProfileSpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// The market (purchasing) option for the instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateInstanceMarketOptions
type LaunchTemplateInstanceMarketOptions struct {
	_ struct{} `type:"structure"`

	// The market type.
	MarketType MarketType `locationName:"marketType" type:"string" enum:"true"`

	// The options for Spot Instances.
	SpotOptions *LaunchTemplateSpotMarketOptions `locationName:"spotOptions" type:"structure"`
}

// String returns the string representation
func (s LaunchTemplateInstanceMarketOptions) String() string {
	return awsutil.Prettify(s)
}

// The market (purchasing) option for the instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateInstanceMarketOptionsRequest
type LaunchTemplateInstanceMarketOptionsRequest struct {
	_ struct{} `type:"structure"`

	// The market type.
	MarketType MarketType `type:"string" enum:"true"`

	// The options for Spot Instances.
	SpotOptions *LaunchTemplateSpotMarketOptionsRequest `type:"structure"`
}

// String returns the string representation
func (s LaunchTemplateInstanceMarketOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateInstanceNetworkInterfaceSpecification
type LaunchTemplateInstanceNetworkInterfaceSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether to associate a public IPv4 address with eth0 for a new
	// network interface.
	AssociatePublicIpAddress *bool `locationName:"associatePublicIpAddress" type:"boolean"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// A description for the network interface.
	Description *string `locationName:"description" type:"string"`

	// The device index for the network interface attachment.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer"`

	// The IDs of one or more security groups.
	Groups []string `locationName:"groupSet" locationNameList:"groupId" type:"list"`

	// The type of network interface.
	InterfaceType *string `locationName:"interfaceType" type:"string"`

	// The number of IPv6 addresses for the network interface.
	Ipv6AddressCount *int64 `locationName:"ipv6AddressCount" type:"integer"`

	// The IPv6 addresses for the network interface.
	Ipv6Addresses []InstanceIpv6Address `locationName:"ipv6AddressesSet" locationNameList:"item" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The primary private IPv4 address of the network interface.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// One or more private IPv4 addresses.
	PrivateIpAddresses []PrivateIpAddressSpecification `locationName:"privateIpAddressesSet" locationNameList:"item" type:"list"`

	// The number of secondary private IPv4 addresses for the network interface.
	SecondaryPrivateIpAddressCount *int64 `locationName:"secondaryPrivateIpAddressCount" type:"integer"`

	// The ID of the subnet for the network interface.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateInstanceNetworkInterfaceSpecification) String() string {
	return awsutil.Prettify(s)
}

// The parameters for a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
type LaunchTemplateInstanceNetworkInterfaceSpecificationRequest struct {
	_ struct{} `type:"structure"`

	// Associates a public IPv4 address with eth0 for a new network interface.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// A description for the network interface.
	Description *string `type:"string"`

	// The device index for the network interface attachment.
	DeviceIndex *int64 `type:"integer"`

	// The IDs of one or more security groups.
	Groups []string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The type of networking interface.
	InterfaceType *string `type:"string"`

	// The number of IPv6 addresses to assign to a network interface. Amazon EC2
	// automatically selects the IPv6 addresses from the subnet range. You can't
	// use this option if specifying specific IPv6 addresses.
	Ipv6AddressCount *int64 `type:"integer"`

	// One or more specific IPv6 addresses from the IPv6 CIDR block range of your
	// subnet. You can't use this option if you're specifying a number of IPv6 addresses.
	Ipv6Addresses []InstanceIpv6AddressRequest `locationNameList:"InstanceIpv6Address" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The primary private IPv4 address of the network interface.
	PrivateIpAddress *string `type:"string"`

	// One or more private IPv4 addresses.
	PrivateIpAddresses []PrivateIpAddressSpecification `locationNameList:"item" type:"list"`

	// The number of secondary private IPv4 addresses to assign to a network interface.
	SecondaryPrivateIpAddressCount *int64 `type:"integer"`

	// The ID of the subnet for the network interface.
	SubnetId *string `type:"string"`
}

// String returns the string representation
func (s LaunchTemplateInstanceNetworkInterfaceSpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a license configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateLicenseConfiguration
type LaunchTemplateLicenseConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `locationName:"licenseConfigurationArn" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateLicenseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a license configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateLicenseConfigurationRequest
type LaunchTemplateLicenseConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `type:"string"`
}

// String returns the string representation
func (s LaunchTemplateLicenseConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes overrides for a launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateOverrides
type LaunchTemplateOverrides struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to launch the instances.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The priority for the launch template override. If OnDemandAllocationStrategy
	// is set to prioritized, Spot Fleet uses priority to determine which launch
	// template override to use first in fulfilling On-Demand capacity. The highest
	// priority is launched first. Valid values are whole numbers starting at 0.
	// The lower the number, the higher the priority. If no number is set, the launch
	// template override has the lowest priority.
	Priority *float64 `locationName:"priority" type:"double"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The ID of the subnet in which to launch the instances.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The number of units provided by the specified instance type.
	WeightedCapacity *float64 `locationName:"weightedCapacity" type:"double"`
}

// String returns the string representation
func (s LaunchTemplateOverrides) String() string {
	return awsutil.Prettify(s)
}

// Describes the placement of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplatePlacement
type LaunchTemplatePlacement struct {
	_ struct{} `type:"structure"`

	// The affinity setting for the instance on the Dedicated Host.
	Affinity *string `locationName:"affinity" type:"string"`

	// The Availability Zone of the instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The name of the placement group for the instance.
	GroupName *string `locationName:"groupName" type:"string"`

	// The ID of the Dedicated Host for the instance.
	HostId *string `locationName:"hostId" type:"string"`

	// Reserved for future use.
	SpreadDomain *string `locationName:"spreadDomain" type:"string"`

	// The tenancy of the instance (if the instance is running in a VPC). An instance
	// with a tenancy of dedicated runs on single-tenant hardware.
	Tenancy Tenancy `locationName:"tenancy" type:"string" enum:"true"`
}

// String returns the string representation
func (s LaunchTemplatePlacement) String() string {
	return awsutil.Prettify(s)
}

// Describes the placement of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplatePlacementRequest
type LaunchTemplatePlacementRequest struct {
	_ struct{} `type:"structure"`

	// The affinity setting for an instance on a Dedicated Host.
	Affinity *string `type:"string"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `type:"string"`

	// The name of the placement group for the instance.
	GroupName *string `type:"string"`

	// The ID of the Dedicated Host for the instance.
	HostId *string `type:"string"`

	// Reserved for future use.
	SpreadDomain *string `type:"string"`

	// The tenancy of the instance (if the instance is running in a VPC). An instance
	// with a tenancy of dedicated runs on single-tenant hardware.
	Tenancy Tenancy `type:"string" enum:"true"`
}

// String returns the string representation
func (s LaunchTemplatePlacementRequest) String() string {
	return awsutil.Prettify(s)
}

// The launch template to use. You must specify either the launch template ID
// or launch template name in the request, but not both.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateSpecification
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	LaunchTemplateId *string `type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `type:"string"`

	// The version number of the launch template.
	//
	// Default: The default version for the launch template.
	Version *string `type:"string"`
}

// String returns the string representation
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// The options for Spot Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateSpotMarketOptions
type LaunchTemplateSpotMarketOptions struct {
	_ struct{} `type:"structure"`

	// The required duration for the Spot Instances (also known as Spot blocks),
	// in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300,
	// or 360).
	BlockDurationMinutes *int64 `locationName:"blockDurationMinutes" type:"integer"`

	// The behavior when a Spot Instance is interrupted.
	InstanceInterruptionBehavior InstanceInterruptionBehavior `locationName:"instanceInterruptionBehavior" type:"string" enum:"true"`

	// The maximum hourly price you're willing to pay for the Spot Instances.
	MaxPrice *string `locationName:"maxPrice" type:"string"`

	// The Spot Instance request type.
	SpotInstanceType SpotInstanceType `locationName:"spotInstanceType" type:"string" enum:"true"`

	// The end date of the request. For a one-time request, the request remains
	// active until all instances launch, the request is canceled, or this date
	// is reached. If the request is persistent, it remains active until it is canceled
	// or this date and time is reached.
	ValidUntil *time.Time `locationName:"validUntil" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s LaunchTemplateSpotMarketOptions) String() string {
	return awsutil.Prettify(s)
}

// The options for Spot Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateSpotMarketOptionsRequest
type LaunchTemplateSpotMarketOptionsRequest struct {
	_ struct{} `type:"structure"`

	// The required duration for the Spot Instances (also known as Spot blocks),
	// in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300,
	// or 360).
	BlockDurationMinutes *int64 `type:"integer"`

	// The behavior when a Spot Instance is interrupted. The default is terminate.
	InstanceInterruptionBehavior InstanceInterruptionBehavior `type:"string" enum:"true"`

	// The maximum hourly price you're willing to pay for the Spot Instances.
	MaxPrice *string `type:"string"`

	// The Spot Instance request type.
	SpotInstanceType SpotInstanceType `type:"string" enum:"true"`

	// The end date of the request. For a one-time request, the request remains
	// active until all instances launch, the request is canceled, or this date
	// is reached. If the request is persistent, it remains active until it is canceled
	// or this date and time is reached. The default end date is 7 days from the
	// current date.
	ValidUntil *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s LaunchTemplateSpotMarketOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// The tag specification for the launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateTagSpecification
type LaunchTemplateTagSpecification struct {
	_ struct{} `type:"structure"`

	// The type of resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The tags for the resource.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s LaunchTemplateTagSpecification) String() string {
	return awsutil.Prettify(s)
}

// The tags specification for the launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateTagSpecificationRequest
type LaunchTemplateTagSpecificationRequest struct {
	_ struct{} `type:"structure"`

	// The type of resource to tag. Currently, the resource types that support tagging
	// on creation are instance and volume. To tag a resource after it has been
	// created, see CreateTags (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
	ResourceType ResourceType `type:"string" enum:"true"`

	// The tags to apply to the resource.
	Tags []Tag `locationName:"Tag" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s LaunchTemplateTagSpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateVersion
type LaunchTemplateVersion struct {
	_ struct{} `type:"structure"`

	// The time the version was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// The principal that created the version.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// Indicates whether the version is the default version.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// Information about the launch template.
	LaunchTemplateData *ResponseLaunchTemplateData `locationName:"launchTemplateData" type:"structure"`

	// The ID of the launch template.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `locationName:"launchTemplateName" min:"3" type:"string"`

	// The description for the version.
	VersionDescription *string `locationName:"versionDescription" type:"string"`

	// The version number.
	VersionNumber *int64 `locationName:"versionNumber" type:"long"`
}

// String returns the string representation
func (s LaunchTemplateVersion) String() string {
	return awsutil.Prettify(s)
}

// Describes the monitoring for the instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplatesMonitoring
type LaunchTemplatesMonitoring struct {
	_ struct{} `type:"structure"`

	// Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring
	// is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation
func (s LaunchTemplatesMonitoring) String() string {
	return awsutil.Prettify(s)
}

// Describes the monitoring for the instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplatesMonitoringRequest
type LaunchTemplatesMonitoringRequest struct {
	_ struct{} `type:"structure"`

	// Specify true to enable detailed monitoring. Otherwise, basic monitoring is
	// enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s LaunchTemplatesMonitoringRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a license configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LicenseConfiguration
type LicenseConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `locationName:"licenseConfigurationArn" type:"string"`
}

// String returns the string representation
func (s LicenseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a license configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LicenseConfigurationRequest
type LicenseConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `type:"string"`
}

// String returns the string representation
func (s LicenseConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the Classic Load Balancers and target groups to attach to a Spot
// Fleet request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LoadBalancersConfig
type LoadBalancersConfig struct {
	_ struct{} `type:"structure"`

	// The Classic Load Balancers.
	ClassicLoadBalancersConfig *ClassicLoadBalancersConfig `locationName:"classicLoadBalancersConfig" type:"structure"`

	// The target groups.
	TargetGroupsConfig *TargetGroupsConfig `locationName:"targetGroupsConfig" type:"structure"`
}

// String returns the string representation
func (s LoadBalancersConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoadBalancersConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoadBalancersConfig"}
	if s.ClassicLoadBalancersConfig != nil {
		if err := s.ClassicLoadBalancersConfig.Validate(); err != nil {
			invalidParams.AddNested("ClassicLoadBalancersConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.TargetGroupsConfig != nil {
		if err := s.TargetGroupsConfig.Validate(); err != nil {
			invalidParams.AddNested("TargetGroupsConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a load permission.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LoadPermission
type LoadPermission struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group PermissionGroup `locationName:"group" type:"string" enum:"true"`

	// The AWS account ID.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s LoadPermission) String() string {
	return awsutil.Prettify(s)
}

// Describes modifications to the load permissions of an Amazon FPGA image (AFI).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LoadPermissionModifications
type LoadPermissionModifications struct {
	_ struct{} `type:"structure"`

	// The load permissions to add.
	Add []LoadPermissionRequest `locationNameList:"item" type:"list"`

	// The load permissions to remove.
	Remove []LoadPermissionRequest `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s LoadPermissionModifications) String() string {
	return awsutil.Prettify(s)
}

// Describes a load permission.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LoadPermissionRequest
type LoadPermissionRequest struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group PermissionGroup `type:"string" enum:"true"`

	// The AWS account ID.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s LoadPermissionRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the options for a VPC attachment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyTransitGatewayVpcAttachmentRequestOptions
type ModifyTransitGatewayVpcAttachmentRequestOptions struct {
	_ struct{} `type:"structure"`

	// Enable or disable DNS support. The default is enable.
	DnsSupport DnsSupportValue `type:"string" enum:"true"`

	// Enable or disable IPv6 support. The default is enable.
	Ipv6Support Ipv6SupportValue `type:"string" enum:"true"`
}

// String returns the string representation
func (s ModifyTransitGatewayVpcAttachmentRequestOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes the monitoring of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Monitoring
type Monitoring struct {
	_ struct{} `type:"structure"`

	// Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring
	// is enabled.
	State MonitoringState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s Monitoring) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a moving Elastic IP address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/MovingAddressStatus
type MovingAddressStatus struct {
	_ struct{} `type:"structure"`

	// The status of the Elastic IP address that's being moved to the EC2-VPC platform,
	// or restored to the EC2-Classic platform.
	MoveStatus MoveStatus `locationName:"moveStatus" type:"string" enum:"true"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s MovingAddressStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a NAT gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NatGateway
type NatGateway struct {
	_ struct{} `type:"structure"`

	// The date and time the NAT gateway was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// The date and time the NAT gateway was deleted, if applicable.
	DeleteTime *time.Time `locationName:"deleteTime" type:"timestamp" timestampFormat:"iso8601"`

	// If the NAT gateway could not be created, specifies the error code for the
	// failure. (InsufficientFreeAddressesInSubnet | Gateway.NotAttached | InvalidAllocationID.NotFound
	// | Resource.AlreadyAssociated | InternalError | InvalidSubnetID.NotFound)
	FailureCode *string `locationName:"failureCode" type:"string"`

	// If the NAT gateway could not be created, specifies the error message for
	// the failure, that corresponds to the error code.
	//
	//    * For InsufficientFreeAddressesInSubnet: "Subnet has insufficient free
	//    addresses to create this NAT gateway"
	//
	//    * For Gateway.NotAttached: "Network vpc-xxxxxxxx has no Internet gateway
	//    attached"
	//
	//    * For InvalidAllocationID.NotFound: "Elastic IP address eipalloc-xxxxxxxx
	//    could not be associated with this NAT gateway"
	//
	//    * For Resource.AlreadyAssociated: "Elastic IP address eipalloc-xxxxxxxx
	//    is already associated"
	//
	//    * For InternalError: "Network interface eni-xxxxxxxx, created and used
	//    internally by this NAT gateway is in an invalid state. Please try again."
	//
	//    * For InvalidSubnetID.NotFound: "The specified subnet subnet-xxxxxxxx
	//    does not exist or could not be found."
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// Information about the IP addresses and network interface associated with
	// the NAT gateway.
	NatGatewayAddresses []NatGatewayAddress `locationName:"natGatewayAddressSet" locationNameList:"item" type:"list"`

	// The ID of the NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// Reserved. If you need to sustain traffic greater than the documented limits
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html),
	// contact us through the Support Center (https://console.aws.amazon.com/support/home?).
	ProvisionedBandwidth *ProvisionedBandwidth `locationName:"provisionedBandwidth" type:"structure"`

	// The state of the NAT gateway.
	//
	//    * pending: The NAT gateway is being created and is not ready to process
	//    traffic.
	//
	//    * failed: The NAT gateway could not be created. Check the failureCode
	//    and failureMessage fields for the reason.
	//
	//    * available: The NAT gateway is able to process traffic. This status remains
	//    until you delete the NAT gateway, and does not indicate the health of
	//    the NAT gateway.
	//
	//    * deleting: The NAT gateway is in the process of being terminated and
	//    may still be processing traffic.
	//
	//    * deleted: The NAT gateway has been terminated and is no longer processing
	//    traffic.
	State NatGatewayState `locationName:"state" type:"string" enum:"true"`

	// The ID of the subnet in which the NAT gateway is located.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The tags for the NAT gateway.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC in which the NAT gateway is located.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NatGateway) String() string {
	return awsutil.Prettify(s)
}

// Describes the IP addresses and network interface associated with a NAT gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NatGatewayAddress
type NatGatewayAddress struct {
	_ struct{} `type:"structure"`

	// The allocation ID of the Elastic IP address that's associated with the NAT
	// gateway.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The ID of the network interface associated with the NAT gateway.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The private IP address associated with the Elastic IP address.
	PrivateIp *string `locationName:"privateIp" type:"string"`

	// The Elastic IP address associated with the NAT gateway.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s NatGatewayAddress) String() string {
	return awsutil.Prettify(s)
}

// Describes a network ACL.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkAcl
type NetworkAcl struct {
	_ struct{} `type:"structure"`

	// Any associations between the network ACL and one or more subnets
	Associations []NetworkAclAssociation `locationName:"associationSet" locationNameList:"item" type:"list"`

	// One or more entries (rules) in the network ACL.
	Entries []NetworkAclEntry `locationName:"entrySet" locationNameList:"item" type:"list"`

	// Indicates whether this is the default network ACL for the VPC.
	IsDefault *bool `locationName:"default" type:"boolean"`

	// The ID of the network ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string"`

	// The ID of the AWS account that owns the network ACL.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Any tags assigned to the network ACL.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC for the network ACL.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkAcl) String() string {
	return awsutil.Prettify(s)
}

// Describes an association between a network ACL and a subnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkAclAssociation
type NetworkAclAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the association between a network ACL and a subnet.
	NetworkAclAssociationId *string `locationName:"networkAclAssociationId" type:"string"`

	// The ID of the network ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s NetworkAclAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes an entry in a network ACL.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkAclEntry
type NetworkAclEntry struct {
	_ struct{} `type:"structure"`

	// The IPv4 network range to allow or deny, in CIDR notation.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Indicates whether the rule is an egress rule (applied to traffic leaving
	// the subnet).
	Egress *bool `locationName:"egress" type:"boolean"`

	// ICMP protocol: The ICMP type and code.
	IcmpTypeCode *IcmpTypeCode `locationName:"icmpTypeCode" type:"structure"`

	// The IPv6 network range to allow or deny, in CIDR notation.
	Ipv6CidrBlock *string `locationName:"ipv6CidrBlock" type:"string"`

	// TCP or UDP protocols: The range of ports the rule applies to.
	PortRange *PortRange `locationName:"portRange" type:"structure"`

	// The protocol number. A value of "-1" means all protocols.
	Protocol *string `locationName:"protocol" type:"string"`

	// Indicates whether to allow or deny the traffic that matches the rule.
	RuleAction RuleAction `locationName:"ruleAction" type:"string" enum:"true"`

	// The rule number for the entry. ACL entries are processed in ascending order
	// by rule number.
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer"`
}

// String returns the string representation
func (s NetworkAclEntry) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterface
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IP address (IPv4) associated with
	// the network interface.
	Association *NetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// The network interface attachment.
	Attachment *NetworkInterfaceAttachment `locationName:"attachment" type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// A description.
	Description *string `locationName:"description" type:"string"`

	// Any security groups for the network interface.
	Groups []GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The type of network interface.
	InterfaceType NetworkInterfaceType `locationName:"interfaceType" type:"string" enum:"true"`

	// The IPv6 addresses associated with the network interface.
	Ipv6Addresses []NetworkInterfaceIpv6Address `locationName:"ipv6AddressesSet" locationNameList:"item" type:"list"`

	// The MAC address.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The AWS account ID of the owner of the network interface.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The private DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The private IPv4 addresses associated with the network interface.
	PrivateIpAddresses []NetworkInterfacePrivateIpAddress `locationName:"privateIpAddressesSet" locationNameList:"item" type:"list"`

	// The ID of the entity that launched the instance on your behalf (for example,
	// AWS Management Console or Auto Scaling).
	RequesterId *string `locationName:"requesterId" type:"string"`

	// Indicates whether the network interface is being managed by AWS.
	RequesterManaged *bool `locationName:"requesterManaged" type:"boolean"`

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool `locationName:"sourceDestCheck" type:"boolean"`

	// The status of the network interface.
	Status NetworkInterfaceStatus `locationName:"status" type:"string" enum:"true"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// Any tags assigned to the network interface.
	TagSet []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// Describes association information for an Elastic IP address (IPv4 only).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterfaceAssociation
type NetworkInterfaceAssociation struct {
	_ struct{} `type:"structure"`

	// The allocation ID.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The association ID.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The ID of the Elastic IP address owner.
	IpOwnerId *string `locationName:"ipOwnerId" type:"string"`

	// The public DNS name.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// The address of the Elastic IP address bound to the network interface.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s NetworkInterfaceAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface attachment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterfaceAttachment
type NetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The timestamp indicating when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The AWS account ID of the owner of the instance.
	InstanceOwnerId *string `locationName:"instanceOwnerId" type:"string"`

	// The attachment state.
	Status AttachmentStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s NetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes an attachment change.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterfaceAttachmentChanges
type NetworkInterfaceAttachmentChanges struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`
}

// String returns the string representation
func (s NetworkInterfaceAttachmentChanges) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv6 address associated with a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterfaceIpv6Address
type NetworkInterfaceIpv6Address struct {
	_ struct{} `type:"structure"`

	// The IPv6 address.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`
}

// String returns the string representation
func (s NetworkInterfaceIpv6Address) String() string {
	return awsutil.Prettify(s)
}

// Describes a permission for a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterfacePermission
type NetworkInterfacePermission struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The AWS service.
	AwsService *string `locationName:"awsService" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the network interface permission.
	NetworkInterfacePermissionId *string `locationName:"networkInterfacePermissionId" type:"string"`

	// The type of permission.
	Permission InterfacePermissionType `locationName:"permission" type:"string" enum:"true"`

	// Information about the state of the permission.
	PermissionState *NetworkInterfacePermissionState `locationName:"permissionState" type:"structure"`
}

// String returns the string representation
func (s NetworkInterfacePermission) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a network interface permission.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterfacePermissionState
type NetworkInterfacePermissionState struct {
	_ struct{} `type:"structure"`

	// The state of the permission.
	State NetworkInterfacePermissionStateCode `locationName:"state" type:"string" enum:"true"`

	// A status message, if applicable.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s NetworkInterfacePermissionState) String() string {
	return awsutil.Prettify(s)
}

// Describes the private IPv4 address of a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NetworkInterfacePrivateIpAddress
type NetworkInterfacePrivateIpAddress struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IP address (IPv4) associated with
	// the network interface.
	Association *NetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// Indicates whether this IPv4 address is the primary private IPv4 address of
	// the network interface.
	Primary *bool `locationName:"primary" type:"boolean"`

	// The private DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IPv4 address.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s NetworkInterfacePrivateIpAddress) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/NewDhcpConfiguration
type NewDhcpConfiguration struct {
	_ struct{} `type:"structure"`

	Key *string `locationName:"key" type:"string"`

	Values []string `locationName:"Value" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s NewDhcpConfiguration) String() string {
	return awsutil.Prettify(s)
}

// The allocation strategy of On-Demand Instances in an EC2 Fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/OnDemandOptions
type OnDemandOptions struct {
	_ struct{} `type:"structure"`

	// The order of the launch template overrides to use in fulfilling On-Demand
	// capacity. If you specify lowest-price, EC2 Fleet uses price to determine
	// the order, launching the lowest price first. If you specify prioritized,
	// EC2 Fleet uses the priority that you assigned to each launch template override,
	// launching the highest priority first. If you do not specify a value, EC2
	// Fleet defaults to lowest-price.
	AllocationStrategy FleetOnDemandAllocationStrategy `locationName:"allocationStrategy" type:"string" enum:"true"`

	// The minimum target capacity for On-Demand Instances in the fleet. If the
	// minimum target capacity is not reached, the fleet launches no instances.
	MinTargetCapacity *int64 `locationName:"minTargetCapacity" type:"integer"`

	// Indicates that the fleet launches all On-Demand Instances into a single Availability
	// Zone.
	SingleAvailabilityZone *bool `locationName:"singleAvailabilityZone" type:"boolean"`

	// Indicates that the fleet uses a single instance type to launch all On-Demand
	// Instances in the fleet.
	SingleInstanceType *bool `locationName:"singleInstanceType" type:"boolean"`
}

// String returns the string representation
func (s OnDemandOptions) String() string {
	return awsutil.Prettify(s)
}

// The allocation strategy of On-Demand Instances in an EC2 Fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/OnDemandOptionsRequest
type OnDemandOptionsRequest struct {
	_ struct{} `type:"structure"`

	// The order of the launch template overrides to use in fulfilling On-Demand
	// capacity. If you specify lowest-price, EC2 Fleet uses price to determine
	// the order, launching the lowest price first. If you specify prioritized,
	// EC2 Fleet uses the priority that you assigned to each launch template override,
	// launching the highest priority first. If you do not specify a value, EC2
	// Fleet defaults to lowest-price.
	AllocationStrategy FleetOnDemandAllocationStrategy `type:"string" enum:"true"`

	// The minimum target capacity for On-Demand Instances in the fleet. If the
	// minimum target capacity is not reached, the fleet launches no instances.
	MinTargetCapacity *int64 `type:"integer"`

	// Indicates that the fleet launches all On-Demand Instances into a single Availability
	// Zone.
	SingleAvailabilityZone *bool `type:"boolean"`

	// Indicates that the fleet uses a single instance type to launch all On-Demand
	// Instances in the fleet.
	SingleInstanceType *bool `type:"boolean"`
}

// String returns the string representation
func (s OnDemandOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the data that identifies an Amazon FPGA image (AFI) on the PCI
// bus.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PciId
type PciId struct {
	_ struct{} `type:"structure"`

	// The ID of the device.
	DeviceId *string `type:"string"`

	// The ID of the subsystem.
	SubsystemId *string `type:"string"`

	// The ID of the vendor for the subsystem.
	SubsystemVendorId *string `type:"string"`

	// The ID of the vendor.
	VendorId *string `type:"string"`
}

// String returns the string representation
func (s PciId) String() string {
	return awsutil.Prettify(s)
}

// Describes the VPC peering connection options.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PeeringConnectionOptions
type PeeringConnectionOptions struct {
	_ struct{} `type:"structure"`

	// If true, the public DNS hostnames of instances in the specified VPC resolve
	// to private IP addresses when queried from instances in the peer VPC.
	AllowDnsResolutionFromRemoteVpc *bool `locationName:"allowDnsResolutionFromRemoteVpc" type:"boolean"`

	// If true, enables outbound communication from an EC2-Classic instance that's
	// linked to a local VPC using ClassicLink to instances in a peer VPC.
	AllowEgressFromLocalClassicLinkToRemoteVpc *bool `locationName:"allowEgressFromLocalClassicLinkToRemoteVpc" type:"boolean"`

	// If true, enables outbound communication from instances in a local VPC to
	// an EC2-Classic instance that's linked to a peer VPC using ClassicLink.
	AllowEgressFromLocalVpcToRemoteClassicLink *bool `locationName:"allowEgressFromLocalVpcToRemoteClassicLink" type:"boolean"`
}

// String returns the string representation
func (s PeeringConnectionOptions) String() string {
	return awsutil.Prettify(s)
}

// The VPC peering connection options.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PeeringConnectionOptionsRequest
type PeeringConnectionOptionsRequest struct {
	_ struct{} `type:"structure"`

	// If true, enables a local VPC to resolve public DNS hostnames to private IP
	// addresses when queried from instances in the peer VPC.
	AllowDnsResolutionFromRemoteVpc *bool `type:"boolean"`

	// If true, enables outbound communication from an EC2-Classic instance that's
	// linked to a local VPC using ClassicLink to instances in a peer VPC.
	AllowEgressFromLocalClassicLinkToRemoteVpc *bool `type:"boolean"`

	// If true, enables outbound communication from instances in a local VPC to
	// an EC2-Classic instance that's linked to a peer VPC using ClassicLink.
	AllowEgressFromLocalVpcToRemoteClassicLink *bool `type:"boolean"`
}

// String returns the string representation
func (s PeeringConnectionOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the placement of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Placement
type Placement struct {
	_ struct{} `type:"structure"`

	// The affinity setting for the instance on the Dedicated Host. This parameter
	// is not supported for the ImportInstance command.
	Affinity *string `locationName:"affinity" type:"string"`

	// The Availability Zone of the instance.
	//
	// If not specified, an Availability Zone will be automatically chosen for you
	// based on the load balancing criteria for the Region.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The name of the placement group the instance is in.
	GroupName *string `locationName:"groupName" type:"string"`

	// The ID of the Dedicated Host on which the instance resides. This parameter
	// is not supported for the ImportInstance command.
	HostId *string `locationName:"hostId" type:"string"`

	// The number of the partition the instance is in. Valid only if the placement
	// group strategy is set to partition.
	PartitionNumber *int64 `locationName:"partitionNumber" type:"integer"`

	// Reserved for future use.
	SpreadDomain *string `locationName:"spreadDomain" type:"string"`

	// The tenancy of the instance (if the instance is running in a VPC). An instance
	// with a tenancy of dedicated runs on single-tenant hardware. The host tenancy
	// is not supported for the ImportInstance command.
	Tenancy Tenancy `locationName:"tenancy" type:"string" enum:"true"`
}

// String returns the string representation
func (s Placement) String() string {
	return awsutil.Prettify(s)
}

// Describes a placement group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PlacementGroup
type PlacementGroup struct {
	_ struct{} `type:"structure"`

	// The name of the placement group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The number of partitions. Valid only if strategy is set to partition.
	PartitionCount *int64 `locationName:"partitionCount" type:"integer"`

	// The state of the placement group.
	State PlacementGroupState `locationName:"state" type:"string" enum:"true"`

	// The placement strategy.
	Strategy PlacementStrategy `locationName:"strategy" type:"string" enum:"true"`
}

// String returns the string representation
func (s PlacementGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes the placement of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PlacementResponse
type PlacementResponse struct {
	_ struct{} `type:"structure"`

	// The name of the placement group the instance is in.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s PlacementResponse) String() string {
	return awsutil.Prettify(s)
}

// Describes a range of ports.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PortRange
type PortRange struct {
	_ struct{} `type:"structure"`

	// The first port in the range.
	From *int64 `locationName:"from" type:"integer"`

	// The last port in the range.
	To *int64 `locationName:"to" type:"integer"`
}

// String returns the string representation
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// Describes prefixes for AWS services.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PrefixList
type PrefixList struct {
	_ struct{} `type:"structure"`

	// The IP address range of the AWS service.
	Cidrs []string `locationName:"cidrSet" locationNameList:"item" type:"list"`

	// The ID of the prefix.
	PrefixListId *string `locationName:"prefixListId" type:"string"`

	// The name of the prefix.
	PrefixListName *string `locationName:"prefixListName" type:"string"`
}

// String returns the string representation
func (s PrefixList) String() string {
	return awsutil.Prettify(s)
}

// Describes a prefix list ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PrefixListId
type PrefixListId struct {
	_ struct{} `type:"structure"`

	// A description for the security group rule that references this prefix list
	// ID.
	//
	// Constraints: Up to 255 characters in length. Allowed characters are a-z,
	// A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*
	Description *string `locationName:"description" type:"string"`

	// The ID of the prefix.
	PrefixListId *string `locationName:"prefixListId" type:"string"`
}

// String returns the string representation
func (s PrefixListId) String() string {
	return awsutil.Prettify(s)
}

// Describes the price for a Reserved Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PriceSchedule
type PriceSchedule struct {
	_ struct{} `type:"structure"`

	// The current price schedule, as determined by the term remaining for the Reserved
	// Instance in the listing.
	//
	// A specific price schedule is always in effect, but only one price schedule
	// can be active at any time. Take, for example, a Reserved Instance listing
	// that has five months remaining in its term. When you specify price schedules
	// for five months and two months, this means that schedule 1, covering the
	// first three months of the remaining term, will be active during months 5,
	// 4, and 3. Then schedule 2, covering the last two months of the term, will
	// be active for months 2 and 1.
	Active *bool `locationName:"active" type:"boolean"`

	// The currency for transacting the Reserved Instance resale. At this time,
	// the only supported currency is USD.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`

	// The fixed price for the term.
	Price *float64 `locationName:"price" type:"double"`

	// The number of months remaining in the reservation. For example, 2 is the
	// second to the last month before the capacity reservation expires.
	Term *int64 `locationName:"term" type:"long"`
}

// String returns the string representation
func (s PriceSchedule) String() string {
	return awsutil.Prettify(s)
}

// Describes the price for a Reserved Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PriceScheduleSpecification
type PriceScheduleSpecification struct {
	_ struct{} `type:"structure"`

	// The currency for transacting the Reserved Instance resale. At this time,
	// the only supported currency is USD.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`

	// The fixed price for the term.
	Price *float64 `locationName:"price" type:"double"`

	// The number of months remaining in the reservation. For example, 2 is the
	// second to the last month before the capacity reservation expires.
	Term *int64 `locationName:"term" type:"long"`
}

// String returns the string representation
func (s PriceScheduleSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes a Reserved Instance offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PricingDetail
type PricingDetail struct {
	_ struct{} `type:"structure"`

	// The number of reservations available for the price.
	Count *int64 `locationName:"count" type:"integer"`

	// The price per instance.
	Price *float64 `locationName:"price" type:"double"`
}

// String returns the string representation
func (s PricingDetail) String() string {
	return awsutil.Prettify(s)
}

// PrincipalIdFormat description
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PrincipalIdFormat
type PrincipalIdFormat struct {
	_ struct{} `type:"structure"`

	// PrincipalIdFormatARN description
	Arn *string `locationName:"arn" type:"string"`

	// PrincipalIdFormatStatuses description
	Statuses []IdFormat `locationName:"statusSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s PrincipalIdFormat) String() string {
	return awsutil.Prettify(s)
}

// Describes a secondary private IPv4 address for a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PrivateIpAddressSpecification
type PrivateIpAddressSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether the private IPv4 address is the primary private IPv4 address.
	// Only one IPv4 address can be designated as primary.
	Primary *bool `locationName:"primary" type:"boolean"`

	// The private IPv4 addresses.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s PrivateIpAddressSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes a product code.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ProductCode
type ProductCode struct {
	_ struct{} `type:"structure"`

	// The product code.
	ProductCodeId *string `locationName:"productCode" type:"string"`

	// The type of product code.
	ProductCodeType ProductCodeValues `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ProductCode) String() string {
	return awsutil.Prettify(s)
}

// Describes a virtual private gateway propagating route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PropagatingVgw
type PropagatingVgw struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway.
	GatewayId *string `locationName:"gatewayId" type:"string"`
}

// String returns the string representation
func (s PropagatingVgw) String() string {
	return awsutil.Prettify(s)
}

// Reserved. If you need to sustain traffic greater than the documented limits
// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html),
// contact us through the Support Center (https://console.aws.amazon.com/support/home?).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ProvisionedBandwidth
type ProvisionedBandwidth struct {
	_ struct{} `type:"structure"`

	// Reserved. If you need to sustain traffic greater than the documented limits
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html),
	// contact us through the Support Center (https://console.aws.amazon.com/support/home?).
	ProvisionTime *time.Time `locationName:"provisionTime" type:"timestamp" timestampFormat:"iso8601"`

	// Reserved. If you need to sustain traffic greater than the documented limits
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html),
	// contact us through the Support Center (https://console.aws.amazon.com/support/home?).
	Provisioned *string `locationName:"provisioned" type:"string"`

	// Reserved. If you need to sustain traffic greater than the documented limits
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html),
	// contact us through the Support Center (https://console.aws.amazon.com/support/home?).
	RequestTime *time.Time `locationName:"requestTime" type:"timestamp" timestampFormat:"iso8601"`

	// Reserved. If you need to sustain traffic greater than the documented limits
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html),
	// contact us through the Support Center (https://console.aws.amazon.com/support/home?).
	Requested *string `locationName:"requested" type:"string"`

	// Reserved. If you need to sustain traffic greater than the documented limits
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html),
	// contact us through the Support Center (https://console.aws.amazon.com/support/home?).
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s ProvisionedBandwidth) String() string {
	return awsutil.Prettify(s)
}

// Describes an address pool.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PublicIpv4Pool
type PublicIpv4Pool struct {
	_ struct{} `type:"structure"`

	// A description of the address pool.
	Description *string `locationName:"description" type:"string"`

	// The address ranges.
	PoolAddressRanges []PublicIpv4PoolRange `locationName:"poolAddressRangeSet" locationNameList:"item" type:"list"`

	// The ID of the IPv4 address pool.
	PoolId *string `locationName:"poolId" type:"string"`

	// The total number of addresses.
	TotalAddressCount *int64 `locationName:"totalAddressCount" type:"integer"`

	// The total number of available addresses.
	TotalAvailableAddressCount *int64 `locationName:"totalAvailableAddressCount" type:"integer"`
}

// String returns the string representation
func (s PublicIpv4Pool) String() string {
	return awsutil.Prettify(s)
}

// Describes an address range of an IPv4 address pool.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PublicIpv4PoolRange
type PublicIpv4PoolRange struct {
	_ struct{} `type:"structure"`

	// The number of addresses in the range.
	AddressCount *int64 `locationName:"addressCount" type:"integer"`

	// The number of available addresses in the range.
	AvailableAddressCount *int64 `locationName:"availableAddressCount" type:"integer"`

	// The first IP address in the range.
	FirstAddress *string `locationName:"firstAddress" type:"string"`

	// The last IP address in the range.
	LastAddress *string `locationName:"lastAddress" type:"string"`
}

// String returns the string representation
func (s PublicIpv4PoolRange) String() string {
	return awsutil.Prettify(s)
}

// Describes the result of the purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Purchase
type Purchase struct {
	_ struct{} `type:"structure"`

	// The currency in which the UpfrontPrice and HourlyPrice amounts are specified.
	// At this time, the only supported currency is USD.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`

	// The duration of the reservation's term in seconds.
	Duration *int64 `locationName:"duration" type:"integer"`

	// The IDs of the Dedicated Hosts associated with the reservation.
	HostIdSet []string `locationName:"hostIdSet" locationNameList:"item" type:"list"`

	// The ID of the reservation.
	HostReservationId *string `locationName:"hostReservationId" type:"string"`

	// The hourly price of the reservation per hour.
	HourlyPrice *string `locationName:"hourlyPrice" type:"string"`

	// The instance family on the Dedicated Host that the reservation can be associated
	// with.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The payment option for the reservation.
	PaymentOption PaymentOption `locationName:"paymentOption" type:"string" enum:"true"`

	// The upfront price of the reservation.
	UpfrontPrice *string `locationName:"upfrontPrice" type:"string"`
}

// String returns the string representation
func (s Purchase) String() string {
	return awsutil.Prettify(s)
}

// Describes a request to purchase Scheduled Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseRequest
type PurchaseRequest struct {
	_ struct{} `type:"structure"`

	// The number of instances.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `type:"integer" required:"true"`

	// The purchase token.
	//
	// PurchaseToken is a required field
	PurchaseToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PurchaseRequest"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}

	if s.PurchaseToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("PurchaseToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a recurring charge.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RecurringCharge
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount of the recurring charge.
	Amount *float64 `locationName:"amount" type:"double"`

	// The frequency of the recurring charge.
	Frequency RecurringChargeFrequency `locationName:"frequency" type:"string" enum:"true"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// Describes a Region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Region
type Region struct {
	_ struct{} `type:"structure"`

	// The Region service endpoint.
	Endpoint *string `locationName:"regionEndpoint" type:"string"`

	// The name of the Region.
	RegionName *string `locationName:"regionName" type:"string"`
}

// String returns the string representation
func (s Region) String() string {
	return awsutil.Prettify(s)
}

// The information to include in the launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestLaunchTemplateData
type RequestLaunchTemplateData struct {
	_ struct{} `type:"structure"`

	// The block device mapping.
	//
	// Supplying both a snapshot ID and an encryption value as arguments for block-device
	// mapping results in an error. This is because only blank volumes can be encrypted
	// on start, and these are not created from a snapshot. If a snapshot is the
	// basis for the volume, it contains data by definition and its encryption status
	// cannot be changed using this action.
	BlockDeviceMappings []LaunchTemplateBlockDeviceMappingRequest `locationName:"BlockDeviceMapping" locationNameList:"BlockDeviceMapping" type:"list"`

	// The Capacity Reservation targeting option. If you do not specify this parameter,
	// the instance's Capacity Reservation preference defaults to open, which enables
	// it to run in any open Capacity Reservation that has matching attributes (instance
	// type, platform, Availability Zone).
	CapacityReservationSpecification *LaunchTemplateCapacityReservationSpecificationRequest `type:"structure"`

	// The CPU options for the instance. For more information, see Optimizing CPU
	// Options (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	CpuOptions *LaunchTemplateCpuOptionsRequest `type:"structure"`

	// The credit option for CPU usage of the instance. Valid for T2 or T3 instances
	// only.
	CreditSpecification *CreditSpecificationRequest `type:"structure"`

	// If you set this parameter to true, you can't terminate the instance using
	// the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute
	// after launch, use ModifyInstanceAttribute (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html).
	// Alternatively, if you set InstanceInitiatedShutdownBehavior to terminate,
	// you can terminate the instance by running the shutdown command from the instance.
	DisableApiTermination *bool `type:"boolean"`

	// Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal Amazon EBS I/O performance. This optimization isn't
	// available with all instance types. Additional usage charges apply when using
	// an EBS-optimized instance.
	EbsOptimized *bool `type:"boolean"`

	// An elastic GPU to associate with the instance.
	ElasticGpuSpecifications []ElasticGpuSpecification `locationName:"ElasticGpuSpecification" locationNameList:"ElasticGpuSpecification" type:"list"`

	// The elastic inference accelerator for the instance.
	ElasticInferenceAccelerators []LaunchTemplateElasticInferenceAccelerator `locationName:"ElasticInferenceAccelerator" locationNameList:"item" type:"list"`

	// Indicates whether an instance is enabled for hibernation. This parameter
	// is valid only if the instance meets the hibernation prerequisites (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites).
	// Hibernation is currently supported only for Amazon Linux. For more information,
	// see Hibernate Your Instance (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	HibernationOptions *LaunchTemplateHibernationOptionsRequest `type:"structure"`

	// The IAM instance profile.
	IamInstanceProfile *LaunchTemplateIamInstanceProfileSpecificationRequest `type:"structure"`

	// The ID of the AMI.
	ImageId *string `type:"string"`

	// Indicates whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	//
	// Default: stop
	InstanceInitiatedShutdownBehavior ShutdownBehavior `type:"string" enum:"true"`

	// The market (purchasing) option for the instances.
	InstanceMarketOptions *LaunchTemplateInstanceMarketOptionsRequest `type:"structure"`

	// The instance type. For more information, see Instance Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType InstanceType `type:"string" enum:"true"`

	// The ID of the kernel.
	//
	// We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
	// information, see User Provided Kernels (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	KernelId *string `type:"string"`

	// The name of the key pair. You can create a key pair using CreateKeyPair (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html)
	// or ImportKeyPair (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html).
	//
	// If you do not specify a key pair, you can't connect to the instance unless
	// you choose an AMI that is configured to allow users another way to log in.
	KeyName *string `type:"string"`

	// The license configurations.
	LicenseSpecifications []LaunchTemplateLicenseConfigurationRequest `locationName:"LicenseSpecification" locationNameList:"item" type:"list"`

	// The monitoring for the instance.
	Monitoring *LaunchTemplatesMonitoringRequest `type:"structure"`

	// One or more network interfaces. If you specify a network interface, you must
	// specify any security groups as part of the network interface.
	NetworkInterfaces []LaunchTemplateInstanceNetworkInterfaceSpecificationRequest `locationName:"NetworkInterface" locationNameList:"InstanceNetworkInterfaceSpecification" type:"list"`

	// The placement for the instance.
	Placement *LaunchTemplatePlacementRequest `type:"structure"`

	// The ID of the RAM disk.
	//
	// We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
	// information, see User Provided Kernels (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	RamDiskId *string `type:"string"`

	// One or more security group IDs. You can create a security group using CreateSecurityGroup
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html).
	// You cannot specify both a security group ID and security name in the same
	// request.
	SecurityGroupIds []string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// [EC2-Classic, default VPC] One or more security group names. For a nondefault
	// VPC, you must use security group IDs instead. You cannot specify both a security
	// group ID and security name in the same request.
	SecurityGroups []string `locationName:"SecurityGroup" locationNameList:"SecurityGroup" type:"list"`

	// The tags to apply to the resources during launch. You can only tag instances
	// and volumes on launch. The specified tags are applied to all instances or
	// volumes that are created during launch. To tag a resource after it has been
	// created, see CreateTags (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
	TagSpecifications []LaunchTemplateTagSpecificationRequest `locationName:"TagSpecification" locationNameList:"LaunchTemplateTagSpecificationRequest" type:"list"`

	// The Base64-encoded user data to make available to the instance. For more
	// information, see Running Commands on Your Linux Instance at Launch (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html)
	// (Linux) and Adding User Data (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data)
	// (Windows).
	UserData *string `type:"string"`
}

// String returns the string representation
func (s RequestLaunchTemplateData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestLaunchTemplateData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestLaunchTemplateData"}
	if s.CreditSpecification != nil {
		if err := s.CreditSpecification.Validate(); err != nil {
			invalidParams.AddNested("CreditSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.ElasticGpuSpecifications != nil {
		for i, v := range s.ElasticGpuSpecifications {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ElasticGpuSpecifications", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ElasticInferenceAccelerators != nil {
		for i, v := range s.ElasticInferenceAccelerators {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ElasticInferenceAccelerators", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the launch specification for an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotLaunchSpecification
type RequestSpotLaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Deprecated.
	AddressingType *string `locationName:"addressingType" type:"string"`

	// One or more block device mapping entries. You can't specify both a snapshot
	// ID and an encryption value. This is because only blank volumes can be encrypted
	// on creation. If a snapshot is the basis for a volume, it is not blank and
	// its encryption status is used for the volume encryption status.
	BlockDeviceMappings []BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// Indicates whether the instance is optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	//
	// Default: false
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The ID of the kernel.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// Indicates whether basic or detailed monitoring is enabled for the instance.
	//
	// Default: Disabled
	Monitoring *RunInstancesMonitoringEnabled `locationName:"monitoring" type:"structure"`

	// One or more network interfaces. If you specify a network interface, you must
	// specify subnet IDs and security group IDs using the network interface.
	NetworkInterfaces []InstanceNetworkInterfaceSpecification `locationName:"NetworkInterface" locationNameList:"item" type:"list"`

	// The placement information for the instance.
	Placement *SpotPlacement `locationName:"placement" type:"structure"`

	// The ID of the RAM disk.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// One or more security group IDs.
	SecurityGroupIds []string `locationName:"SecurityGroupId" locationNameList:"item" type:"list"`

	// One or more security groups. When requesting instances in a VPC, you must
	// specify the IDs of the security groups. When requesting instances in EC2-Classic,
	// you can specify the names or the IDs of the security groups.
	SecurityGroups []string `locationName:"SecurityGroup" locationNameList:"item" type:"list"`

	// The ID of the subnet in which to launch the instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The Base64-encoded user data for the instance. User data is limited to 16
	// KB.
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s RequestSpotLaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestSpotLaunchSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestSpotLaunchSpecification"}
	if s.Monitoring != nil {
		if err := s.Monitoring.Validate(); err != nil {
			invalidParams.AddNested("Monitoring", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a reservation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Reservation
type Reservation struct {
	_ struct{} `type:"structure"`

	// [EC2-Classic only] The security groups.
	Groups []GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The instances.
	Instances []Instance `locationName:"instancesSet" locationNameList:"item" type:"list"`

	// The ID of the AWS account that owns the reservation.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The ID of the requester that launched the instances on your behalf (for example,
	// AWS Management Console or Auto Scaling).
	RequesterId *string `locationName:"requesterId" type:"string"`

	// The ID of the reservation.
	ReservationId *string `locationName:"reservationId" type:"string"`
}

// String returns the string representation
func (s Reservation) String() string {
	return awsutil.Prettify(s)
}

// The cost associated with the Reserved Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservationValue
type ReservationValue struct {
	_ struct{} `type:"structure"`

	// The hourly rate of the reservation.
	HourlyPrice *string `locationName:"hourlyPrice" type:"string"`

	// The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice
	// * number of hours remaining).
	RemainingTotalValue *string `locationName:"remainingTotalValue" type:"string"`

	// The remaining upfront cost of the reservation.
	RemainingUpfrontValue *string `locationName:"remainingUpfrontValue" type:"string"`
}

// String returns the string representation
func (s ReservationValue) String() string {
	return awsutil.Prettify(s)
}

// Describes the limit price of a Reserved Instance offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstanceLimitPrice
type ReservedInstanceLimitPrice struct {
	_ struct{} `type:"structure"`

	// Used for Reserved Instance Marketplace offerings. Specifies the limit price
	// on the total order (instanceCount * price).
	Amount *float64 `locationName:"amount" type:"double"`

	// The currency in which the limitPrice amount is specified. At this time, the
	// only supported currency is USD.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`
}

// String returns the string representation
func (s ReservedInstanceLimitPrice) String() string {
	return awsutil.Prettify(s)
}

// The total value of the Convertible Reserved Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstanceReservationValue
type ReservedInstanceReservationValue struct {
	_ struct{} `type:"structure"`

	// The total value of the Convertible Reserved Instance that you are exchanging.
	ReservationValue *ReservationValue `locationName:"reservationValue" type:"structure"`

	// The ID of the Convertible Reserved Instance that you are exchanging.
	ReservedInstanceId *string `locationName:"reservedInstanceId" type:"string"`
}

// String returns the string representation
func (s ReservedInstanceReservationValue) String() string {
	return awsutil.Prettify(s)
}

// Describes a Reserved Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstances
type ReservedInstances struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the Reserved Instance can be used.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The currency of the Reserved Instance. It's specified using ISO 4217 standard
	// currency codes. At this time, the only supported currency is USD.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`

	// The duration of the Reserved Instance, in seconds.
	Duration *int64 `locationName:"duration" type:"long"`

	// The time when the Reserved Instance expires.
	End *time.Time `locationName:"end" type:"timestamp" timestampFormat:"iso8601"`

	// The purchase price of the Reserved Instance.
	FixedPrice *float64 `locationName:"fixedPrice" type:"float"`

	// The number of reservations purchased.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The tenancy of the instance.
	InstanceTenancy Tenancy `locationName:"instanceTenancy" type:"string" enum:"true"`

	// The instance type on which the Reserved Instance can be used.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The offering class of the Reserved Instance.
	OfferingClass OfferingClassType `locationName:"offeringClass" type:"string" enum:"true"`

	// The Reserved Instance offering type.
	OfferingType OfferingTypeValues `locationName:"offeringType" type:"string" enum:"true"`

	// The Reserved Instance product platform description.
	ProductDescription RIProductDescription `locationName:"productDescription" type:"string" enum:"true"`

	// The recurring charge tag assigned to the resource.
	RecurringCharges []RecurringCharge `locationName:"recurringCharges" locationNameList:"item" type:"list"`

	// The ID of the Reserved Instance.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// The scope of the Reserved Instance.
	Scope Scope `locationName:"scope" type:"string" enum:"true"`

	// The date and time the Reserved Instance started.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`

	// The state of the Reserved Instance purchase.
	State ReservedInstanceState `locationName:"state" type:"string" enum:"true"`

	// Any tags assigned to the resource.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The usage price of the Reserved Instance, per hour.
	UsagePrice *float64 `locationName:"usagePrice" type:"float"`
}

// String returns the string representation
func (s ReservedInstances) String() string {
	return awsutil.Prettify(s)
}

// Describes the configuration settings for the modified Reserved Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstancesConfiguration
type ReservedInstancesConfiguration struct {
	_ struct{} `type:"structure"`

	// The Availability Zone for the modified Reserved Instances.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of modified Reserved Instances.
	//
	// This is a required field for a request.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The instance type for the modified Reserved Instances.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The network platform of the modified Reserved Instances, which is either
	// EC2-Classic or EC2-VPC.
	Platform *string `locationName:"platform" type:"string"`

	// Whether the Reserved Instance is applied to instances in a Region or instances
	// in a specific Availability Zone.
	Scope Scope `locationName:"scope" type:"string" enum:"true"`
}

// String returns the string representation
func (s ReservedInstancesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes the ID of a Reserved Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstancesId
type ReservedInstancesId struct {
	_ struct{} `type:"structure"`

	// The ID of the Reserved Instance.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`
}

// String returns the string representation
func (s ReservedInstancesId) String() string {
	return awsutil.Prettify(s)
}

// Describes a Reserved Instance listing.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstancesListing
type ReservedInstancesListing struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive key supplied by the client to ensure that the request
	// is idempotent. For more information, see Ensuring Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The time the listing was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"iso8601"`

	// The number of instances in this state.
	InstanceCounts []InstanceCount `locationName:"instanceCounts" locationNameList:"item" type:"list"`

	// The price of the Reserved Instance listing.
	PriceSchedules []PriceSchedule `locationName:"priceSchedules" locationNameList:"item" type:"list"`

	// The ID of the Reserved Instance.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// The ID of the Reserved Instance listing.
	ReservedInstancesListingId *string `locationName:"reservedInstancesListingId" type:"string"`

	// The status of the Reserved Instance listing.
	Status ListingStatus `locationName:"status" type:"string" enum:"true"`

	// The reason for the current status of the Reserved Instance listing. The response
	// can be blank.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Any tags assigned to the resource.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The last modified timestamp of the listing.
	UpdateDate *time.Time `locationName:"updateDate" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ReservedInstancesListing) String() string {
	return awsutil.Prettify(s)
}

// Describes a Reserved Instance modification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstancesModification
type ReservedInstancesModification struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive key supplied by the client to ensure that the request
	// is idempotent. For more information, see Ensuring Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The time when the modification request was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"iso8601"`

	// The time for the modification to become effective.
	EffectiveDate *time.Time `locationName:"effectiveDate" type:"timestamp" timestampFormat:"iso8601"`

	// Contains target configurations along with their corresponding new Reserved
	// Instance IDs.
	ModificationResults []ReservedInstancesModificationResult `locationName:"modificationResultSet" locationNameList:"item" type:"list"`

	// The IDs of one or more Reserved Instances.
	ReservedInstancesIds []ReservedInstancesId `locationName:"reservedInstancesSet" locationNameList:"item" type:"list"`

	// A unique ID for the Reserved Instance modification.
	ReservedInstancesModificationId *string `locationName:"reservedInstancesModificationId" type:"string"`

	// The status of the Reserved Instances modification request.
	Status *string `locationName:"status" type:"string"`

	// The reason for the status.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The time when the modification request was last updated.
	UpdateDate *time.Time `locationName:"updateDate" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ReservedInstancesModification) String() string {
	return awsutil.Prettify(s)
}

// Describes the modification request/s.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstancesModificationResult
type ReservedInstancesModificationResult struct {
	_ struct{} `type:"structure"`

	// The ID for the Reserved Instances that were created as part of the modification
	// request. This field is only available when the modification is fulfilled.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// The target Reserved Instances configurations supplied as part of the modification
	// request.
	TargetConfiguration *ReservedInstancesConfiguration `locationName:"targetConfiguration" type:"structure"`
}

// String returns the string representation
func (s ReservedInstancesModificationResult) String() string {
	return awsutil.Prettify(s)
}

// Describes a Reserved Instance offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstancesOffering
type ReservedInstancesOffering struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the Reserved Instance can be used.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The currency of the Reserved Instance offering you are purchasing. It's specified
	// using ISO 4217 standard currency codes. At this time, the only supported
	// currency is USD.
	CurrencyCode CurrencyCodeValues `locationName:"currencyCode" type:"string" enum:"true"`

	// The duration of the Reserved Instance, in seconds.
	Duration *int64 `locationName:"duration" type:"long"`

	// The purchase price of the Reserved Instance.
	FixedPrice *float64 `locationName:"fixedPrice" type:"float"`

	// The tenancy of the instance.
	InstanceTenancy Tenancy `locationName:"instanceTenancy" type:"string" enum:"true"`

	// The instance type on which the Reserved Instance can be used.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// Indicates whether the offering is available through the Reserved Instance
	// Marketplace (resale) or AWS. If it's a Reserved Instance Marketplace offering,
	// this is true.
	Marketplace *bool `locationName:"marketplace" type:"boolean"`

	// If convertible it can be exchanged for Reserved Instances of the same or
	// higher monetary value, with different configurations. If standard, it is
	// not possible to perform an exchange.
	OfferingClass OfferingClassType `locationName:"offeringClass" type:"string" enum:"true"`

	// The Reserved Instance offering type.
	OfferingType OfferingTypeValues `locationName:"offeringType" type:"string" enum:"true"`

	// The pricing details of the Reserved Instance offering.
	PricingDetails []PricingDetail `locationName:"pricingDetailsSet" locationNameList:"item" type:"list"`

	// The Reserved Instance product platform description.
	ProductDescription RIProductDescription `locationName:"productDescription" type:"string" enum:"true"`

	// The recurring charge tag assigned to the resource.
	RecurringCharges []RecurringCharge `locationName:"recurringCharges" locationNameList:"item" type:"list"`

	// The ID of the Reserved Instance offering. This is the offering ID used in
	// GetReservedInstancesExchangeQuote to confirm that an exchange can be made.
	ReservedInstancesOfferingId *string `locationName:"reservedInstancesOfferingId" type:"string"`

	// Whether the Reserved Instance is applied to instances in a Region or an Availability
	// Zone.
	Scope Scope `locationName:"scope" type:"string" enum:"true"`

	// The usage price of the Reserved Instance, per hour.
	UsagePrice *float64 `locationName:"usagePrice" type:"float"`
}

// String returns the string representation
func (s ReservedInstancesOffering) String() string {
	return awsutil.Prettify(s)
}

// Describes the error that's returned when you cannot delete a launch template
// version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResponseError
type ResponseError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code LaunchTemplateErrorCode `locationName:"code" type:"string" enum:"true"`

	// The error message, if applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResponseError) String() string {
	return awsutil.Prettify(s)
}

// The information for a launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResponseLaunchTemplateData
type ResponseLaunchTemplateData struct {
	_ struct{} `type:"structure"`

	// The block device mappings.
	BlockDeviceMappings []LaunchTemplateBlockDeviceMapping `locationName:"blockDeviceMappingSet" locationNameList:"item" type:"list"`

	// Information about the Capacity Reservation targeting option.
	CapacityReservationSpecification *LaunchTemplateCapacityReservationSpecificationResponse `locationName:"capacityReservationSpecification" type:"structure"`

	// The CPU options for the instance. For more information, see Optimizing CPU
	// Options (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	CpuOptions *LaunchTemplateCpuOptions `locationName:"cpuOptions" type:"structure"`

	// The credit option for CPU usage of the instance.
	CreditSpecification *CreditSpecification `locationName:"creditSpecification" type:"structure"`

	// If set to true, indicates that the instance cannot be terminated using the
	// Amazon EC2 console, command line tool, or API.
	DisableApiTermination *bool `locationName:"disableApiTermination" type:"boolean"`

	// Indicates whether the instance is optimized for Amazon EBS I/O.
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The elastic GPU specification.
	ElasticGpuSpecifications []ElasticGpuSpecificationResponse `locationName:"elasticGpuSpecificationSet" locationNameList:"item" type:"list"`

	// The elastic inference accelerator for the instance.
	ElasticInferenceAccelerators []LaunchTemplateElasticInferenceAcceleratorResponse `locationName:"elasticInferenceAcceleratorSet" locationNameList:"item" type:"list"`

	// Indicates whether an instance is configured for hibernation. For more information,
	// see Hibernate Your Instance (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	HibernationOptions *LaunchTemplateHibernationOptions `locationName:"hibernationOptions" type:"structure"`

	// The IAM instance profile.
	IamInstanceProfile *LaunchTemplateIamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI that was used to launch the instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// Indicates whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	InstanceInitiatedShutdownBehavior ShutdownBehavior `locationName:"instanceInitiatedShutdownBehavior" type:"string" enum:"true"`

	// The market (purchasing) option for the instances.
	InstanceMarketOptions *LaunchTemplateInstanceMarketOptions `locationName:"instanceMarketOptions" type:"structure"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The ID of the kernel, if applicable.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// The license configurations.
	LicenseSpecifications []LaunchTemplateLicenseConfiguration `locationName:"licenseSet" locationNameList:"item" type:"list"`

	// The monitoring for the instance.
	Monitoring *LaunchTemplatesMonitoring `locationName:"monitoring" type:"structure"`

	// The network interfaces.
	NetworkInterfaces []LaunchTemplateInstanceNetworkInterfaceSpecification `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`

	// The placement of the instance.
	Placement *LaunchTemplatePlacement `locationName:"placement" type:"structure"`

	// The ID of the RAM disk, if applicable.
	RamDiskId *string `locationName:"ramDiskId" type:"string"`

	// The security group IDs.
	SecurityGroupIds []string `locationName:"securityGroupIdSet" locationNameList:"item" type:"list"`

	// The security group names.
	SecurityGroups []string `locationName:"securityGroupSet" locationNameList:"item" type:"list"`

	// The tags.
	TagSpecifications []LaunchTemplateTagSpecification `locationName:"tagSpecificationSet" locationNameList:"item" type:"list"`

	// The user data for the instance.
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s ResponseLaunchTemplateData) String() string {
	return awsutil.Prettify(s)
}

// Describes a route in a route table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Route
type Route struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR block used for the destination match.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// The IPv6 CIDR block used for the destination match.
	DestinationIpv6CidrBlock *string `locationName:"destinationIpv6CidrBlock" type:"string"`

	// The prefix of the AWS service.
	DestinationPrefixListId *string `locationName:"destinationPrefixListId" type:"string"`

	// The ID of the egress-only internet gateway.
	EgressOnlyInternetGatewayId *string `locationName:"egressOnlyInternetGatewayId" type:"string"`

	// The ID of a gateway attached to your VPC.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of a NAT instance in your VPC.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The AWS account ID of the owner of the instance.
	InstanceOwnerId *string `locationName:"instanceOwnerId" type:"string"`

	// The ID of a NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// Describes how the route was created.
	//
	//    * CreateRouteTable - The route was automatically created when the route
	//    table was created.
	//
	//    * CreateRoute - The route was manually added to the route table.
	//
	//    * EnableVgwRoutePropagation - The route was propagated by route propagation.
	Origin RouteOrigin `locationName:"origin" type:"string" enum:"true"`

	// The state of the route. The blackhole state indicates that the route's target
	// isn't available (for example, the specified gateway isn't attached to the
	// VPC, or the specified NAT instance has been terminated).
	State RouteState `locationName:"state" type:"string" enum:"true"`

	// The ID of a transit gateway.
	TransitGatewayId *string `locationName:"transitGatewayId" type:"string"`

	// The ID of a VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s Route) String() string {
	return awsutil.Prettify(s)
}

// Describes a route table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RouteTable
type RouteTable struct {
	_ struct{} `type:"structure"`

	// The associations between the route table and one or more subnets.
	Associations []RouteTableAssociation `locationName:"associationSet" locationNameList:"item" type:"list"`

	// The ID of the AWS account that owns the route table.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Any virtual private gateway (VGW) propagating routes.
	PropagatingVgws []PropagatingVgw `locationName:"propagatingVgwSet" locationNameList:"item" type:"list"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string"`

	// The routes in the route table.
	Routes []Route `locationName:"routeSet" locationNameList:"item" type:"list"`

	// Any tags assigned to the route table.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s RouteTable) String() string {
	return awsutil.Prettify(s)
}

// Describes an association between a route table and a subnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RouteTableAssociation
type RouteTableAssociation struct {
	_ struct{} `type:"structure"`

	// Indicates whether this is the main route table.
	Main *bool `locationName:"main" type:"boolean"`

	// The ID of the association between a route table and a subnet.
	RouteTableAssociationId *string `locationName:"routeTableAssociationId" type:"string"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string"`

	// The ID of the subnet. A subnet ID is not returned for an implicit association.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s RouteTableAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes the monitoring of an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RunInstancesMonitoringEnabled
type RunInstancesMonitoringEnabled struct {
	_ struct{} `type:"structure"`

	// Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring
	// is enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s RunInstancesMonitoringEnabled) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunInstancesMonitoringEnabled) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RunInstancesMonitoringEnabled"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the storage parameters for S3 and S3 buckets for an instance store-backed
// AMI.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/S3Storage
type S3Storage struct {
	_ struct{} `type:"structure"`

	// The access key ID of the owner of the bucket. Before you specify a value
	// for your access key ID, review and follow the guidance in Best Practices
	// for Managing AWS Access Keys (https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html).
	AWSAccessKeyId *string `type:"string"`

	// The bucket in which to store the AMI. You can specify a bucket that you already
	// own or a new bucket that Amazon EC2 creates on your behalf. If you specify
	// a bucket that belongs to someone else, Amazon EC2 returns an error.
	Bucket *string `locationName:"bucket" type:"string"`

	// The beginning of the file name of the AMI.
	Prefix *string `locationName:"prefix" type:"string"`

	// An Amazon S3 upload policy that gives Amazon EC2 permission to upload items
	// into Amazon S3 on your behalf.
	//
	// UploadPolicy is automatically base64 encoded/decoded by the SDK.
	UploadPolicy []byte `locationName:"uploadPolicy" type:"blob"`

	// The signature of the JSON document.
	UploadPolicySignature *string `locationName:"uploadPolicySignature" type:"string"`
}

// String returns the string representation
func (s S3Storage) String() string {
	return awsutil.Prettify(s)
}

// Describes a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstance
type ScheduledInstance struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The date when the Scheduled Instance was purchased.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"iso8601"`

	// The hourly price for a single instance.
	HourlyPrice *string `locationName:"hourlyPrice" type:"string"`

	// The number of instances.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The network platform (EC2-Classic or EC2-VPC).
	NetworkPlatform *string `locationName:"networkPlatform" type:"string"`

	// The time for the next schedule to start.
	NextSlotStartTime *time.Time `locationName:"nextSlotStartTime" type:"timestamp" timestampFormat:"iso8601"`

	// The platform (Linux/UNIX or Windows).
	Platform *string `locationName:"platform" type:"string"`

	// The time that the previous schedule ended or will end.
	PreviousSlotEndTime *time.Time `locationName:"previousSlotEndTime" type:"timestamp" timestampFormat:"iso8601"`

	// The schedule recurrence.
	Recurrence *ScheduledInstanceRecurrence `locationName:"recurrence" type:"structure"`

	// The Scheduled Instance ID.
	ScheduledInstanceId *string `locationName:"scheduledInstanceId" type:"string"`

	// The number of hours in the schedule.
	SlotDurationInHours *int64 `locationName:"slotDurationInHours" type:"integer"`

	// The end date for the Scheduled Instance.
	TermEndDate *time.Time `locationName:"termEndDate" type:"timestamp" timestampFormat:"iso8601"`

	// The start date for the Scheduled Instance.
	TermStartDate *time.Time `locationName:"termStartDate" type:"timestamp" timestampFormat:"iso8601"`

	// The total number of hours for a single instance for the entire term.
	TotalScheduledInstanceHours *int64 `locationName:"totalScheduledInstanceHours" type:"integer"`
}

// String returns the string representation
func (s ScheduledInstance) String() string {
	return awsutil.Prettify(s)
}

// Describes a schedule that is available for your Scheduled Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstanceAvailability
type ScheduledInstanceAvailability struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of available instances.
	AvailableInstanceCount *int64 `locationName:"availableInstanceCount" type:"integer"`

	// The time period for the first schedule to start.
	FirstSlotStartTime *time.Time `locationName:"firstSlotStartTime" type:"timestamp" timestampFormat:"iso8601"`

	// The hourly price for a single instance.
	HourlyPrice *string `locationName:"hourlyPrice" type:"string"`

	// The instance type. You can specify one of the C3, C4, M4, or R3 instance
	// types.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The maximum term. The only possible value is 365 days.
	MaxTermDurationInDays *int64 `locationName:"maxTermDurationInDays" type:"integer"`

	// The minimum term. The only possible value is 365 days.
	MinTermDurationInDays *int64 `locationName:"minTermDurationInDays" type:"integer"`

	// The network platform (EC2-Classic or EC2-VPC).
	NetworkPlatform *string `locationName:"networkPlatform" type:"string"`

	// The platform (Linux/UNIX or Windows).
	Platform *string `locationName:"platform" type:"string"`

	// The purchase token. This token expires in two hours.
	PurchaseToken *string `locationName:"purchaseToken" type:"string"`

	// The schedule recurrence.
	Recurrence *ScheduledInstanceRecurrence `locationName:"recurrence" type:"structure"`

	// The number of hours in the schedule.
	SlotDurationInHours *int64 `locationName:"slotDurationInHours" type:"integer"`

	// The total number of hours for a single instance for the entire term.
	TotalScheduledInstanceHours *int64 `locationName:"totalScheduledInstanceHours" type:"integer"`
}

// String returns the string representation
func (s ScheduledInstanceAvailability) String() string {
	return awsutil.Prettify(s)
}

// Describes the recurring schedule for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstanceRecurrence
type ScheduledInstanceRecurrence struct {
	_ struct{} `type:"structure"`

	// The frequency (Daily, Weekly, or Monthly).
	Frequency *string `locationName:"frequency" type:"string"`

	// The interval quantity. The interval unit depends on the value of frequency.
	// For example, every 2 weeks or every 2 months.
	Interval *int64 `locationName:"interval" type:"integer"`

	// The days. For a monthly schedule, this is one or more days of the month (1-31).
	// For a weekly schedule, this is one or more days of the week (1-7, where 1
	// is Sunday).
	OccurrenceDaySet []int64 `locationName:"occurrenceDaySet" locationNameList:"item" type:"list"`

	// Indicates whether the occurrence is relative to the end of the specified
	// week or month.
	OccurrenceRelativeToEnd *bool `locationName:"occurrenceRelativeToEnd" type:"boolean"`

	// The unit for occurrenceDaySet (DayOfWeek or DayOfMonth).
	OccurrenceUnit *string `locationName:"occurrenceUnit" type:"string"`
}

// String returns the string representation
func (s ScheduledInstanceRecurrence) String() string {
	return awsutil.Prettify(s)
}

// Describes the recurring schedule for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstanceRecurrenceRequest
type ScheduledInstanceRecurrenceRequest struct {
	_ struct{} `type:"structure"`

	// The frequency (Daily, Weekly, or Monthly).
	Frequency *string `type:"string"`

	// The interval quantity. The interval unit depends on the value of Frequency.
	// For example, every 2 weeks or every 2 months.
	Interval *int64 `type:"integer"`

	// The days. For a monthly schedule, this is one or more days of the month (1-31).
	// For a weekly schedule, this is one or more days of the week (1-7, where 1
	// is Sunday). You can't specify this value with a daily schedule. If the occurrence
	// is relative to the end of the month, you can specify only a single day.
	OccurrenceDays []int64 `locationName:"OccurrenceDay" locationNameList:"OccurenceDay" type:"list"`

	// Indicates whether the occurrence is relative to the end of the specified
	// week or month. You can't specify this value with a daily schedule.
	OccurrenceRelativeToEnd *bool `type:"boolean"`

	// The unit for OccurrenceDays (DayOfWeek or DayOfMonth). This value is required
	// for a monthly schedule. You can't specify DayOfWeek with a weekly schedule.
	// You can't specify this value with a daily schedule.
	OccurrenceUnit *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstanceRecurrenceRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesBlockDeviceMapping
type ScheduledInstancesBlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name (for example, /dev/sdh or xvdh).
	DeviceName *string `type:"string"`

	// Parameters used to set up EBS volumes automatically when the instance is
	// launched.
	Ebs *ScheduledInstancesEbs `type:"structure"`

	// Suppresses the specified device included in the block device mapping of the
	// AMI.
	NoDevice *string `type:"string"`

	// The virtual device name (ephemeralN). Instance store volumes are numbered
	// starting from 0. An instance type with two available instance store volumes
	// can specify mappings for ephemeral0 and ephemeral1. The number of available
	// instance store volumes depends on the instance type. After you connect to
	// the instance, you must mount the volume.
	//
	// Constraints: For M3 instances, you must specify instance store volumes in
	// the block device mapping for the instance. When you launch an M3 instance,
	// we ignore any instance store volumes specified in the block device mapping
	// for the AMI.
	VirtualName *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesBlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Describes an EBS volume for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesEbs
type ScheduledInstancesEbs struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `type:"boolean"`

	// Indicates whether the volume is encrypted. You can attached encrypted volumes
	// only to instances that support them.
	Encrypted *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For io1 volumes, this represents the number of IOPS that are provisioned
	// for the volume. For gp2 volumes, this represents the baseline performance
	// of the volume and the rate at which the volume accumulates I/O credits for
	// bursting. For more information about gp2 baseline performance, I/O credits,
	// and bursting, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Constraint: Range is 100-20000 IOPS for io1 volumes and 100-10000 IOPS for
	// gp2 volumes.
	//
	// Condition: This parameter is required for requests to create io1volumes;
	// it is not used in requests to create gp2, st1, sc1, or standard volumes.
	Iops *int64 `type:"integer"`

	// The ID of the snapshot.
	SnapshotId *string `type:"string"`

	// The size of the volume, in GiB.
	//
	// Default: If you're creating the volume from a snapshot and don't specify
	// a volume size, the default is the snapshot size.
	VolumeSize *int64 `type:"integer"`

	// The volume type. gp2 for General Purpose SSD, io1 for Provisioned IOPS SSD,
	// Throughput Optimized HDD for st1, Cold HDD for sc1, or standard for Magnetic.
	//
	// Default: standard
	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesEbs) String() string {
	return awsutil.Prettify(s)
}

// Describes an IAM instance profile for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesIamInstanceProfile
type ScheduledInstancesIamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN).
	Arn *string `type:"string"`

	// The name.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesIamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv6 address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesIpv6Address
type ScheduledInstancesIpv6Address struct {
	_ struct{} `type:"structure"`

	// The IPv6 address.
	Ipv6Address *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesIpv6Address) String() string {
	return awsutil.Prettify(s)
}

// Describes the launch specification for a Scheduled Instance.
//
// If you are launching the Scheduled Instance in EC2-VPC, you must specify
// the ID of the subnet. You can specify the subnet using either SubnetId or
// NetworkInterface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesLaunchSpecification
type ScheduledInstancesLaunchSpecification struct {
	_ struct{} `type:"structure"`

	// The block device mapping entries.
	BlockDeviceMappings []ScheduledInstancesBlockDeviceMapping `locationName:"BlockDeviceMapping" locationNameList:"BlockDeviceMapping" type:"list"`

	// Indicates whether the instances are optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS-optimized
	// instance.
	//
	// Default: false
	EbsOptimized *bool `type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *ScheduledInstancesIamInstanceProfile `type:"structure"`

	// The ID of the Amazon Machine Image (AMI).
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// The instance type.
	InstanceType *string `type:"string"`

	// The ID of the kernel.
	KernelId *string `type:"string"`

	// The name of the key pair.
	KeyName *string `type:"string"`

	// Enable or disable monitoring for the instances.
	Monitoring *ScheduledInstancesMonitoring `type:"structure"`

	// The network interfaces.
	NetworkInterfaces []ScheduledInstancesNetworkInterface `locationName:"NetworkInterface" locationNameList:"NetworkInterface" type:"list"`

	// The placement information.
	Placement *ScheduledInstancesPlacement `type:"structure"`

	// The ID of the RAM disk.
	RamdiskId *string `type:"string"`

	// The IDs of the security groups.
	SecurityGroupIds []string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The ID of the subnet in which to launch the instances.
	SubnetId *string `type:"string"`

	// The base64-encoded MIME user data.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesLaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledInstancesLaunchSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduledInstancesLaunchSpecification"}

	if s.ImageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes whether monitoring is enabled for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesMonitoring
type ScheduledInstancesMonitoring struct {
	_ struct{} `type:"structure"`

	// Indicates whether monitoring is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ScheduledInstancesMonitoring) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesNetworkInterface
type ScheduledInstancesNetworkInterface struct {
	_ struct{} `type:"structure"`

	// Indicates whether to assign a public IPv4 address to instances launched in
	// a VPC. The public IPv4 address can only be assigned to a network interface
	// for eth0, and can only be assigned to a new network interface, not an existing
	// one. You cannot specify more than one network interface in the request. If
	// launching into a default subnet, the default value is true.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// Indicates whether to delete the interface when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The description.
	Description *string `type:"string"`

	// The index of the device for the network interface attachment.
	DeviceIndex *int64 `type:"integer"`

	// The IDs of the security groups.
	Groups []string `locationName:"Group" locationNameList:"SecurityGroupId" type:"list"`

	// The number of IPv6 addresses to assign to the network interface. The IPv6
	// addresses are automatically selected from the subnet range.
	Ipv6AddressCount *int64 `type:"integer"`

	// The specific IPv6 addresses from the subnet range.
	Ipv6Addresses []ScheduledInstancesIpv6Address `locationName:"Ipv6Address" locationNameList:"Ipv6Address" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string `type:"string"`

	// The private IPv4 addresses.
	PrivateIpAddressConfigs []ScheduledInstancesPrivateIpAddressConfig `locationName:"PrivateIpAddressConfig" locationNameList:"PrivateIpAddressConfigSet" type:"list"`

	// The number of secondary private IPv4 addresses.
	SecondaryPrivateIpAddressCount *int64 `type:"integer"`

	// The ID of the subnet.
	SubnetId *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesNetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// Describes the placement for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesPlacement
type ScheduledInstancesPlacement struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `type:"string"`

	// The name of the placement group.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesPlacement) String() string {
	return awsutil.Prettify(s)
}

// Describes a private IPv4 address for a Scheduled Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ScheduledInstancesPrivateIpAddressConfig
type ScheduledInstancesPrivateIpAddressConfig struct {
	_ struct{} `type:"structure"`

	// Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary
	// IPv4 address.
	Primary *bool `type:"boolean"`

	// The IPv4 address.
	PrivateIpAddress *string `type:"string"`
}

// String returns the string representation
func (s ScheduledInstancesPrivateIpAddressConfig) String() string {
	return awsutil.Prettify(s)
}

// Describes a security group
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SecurityGroup
type SecurityGroup struct {
	_ struct{} `type:"structure"`

	// A description of the security group.
	Description *string `locationName:"groupDescription" type:"string"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The inbound rules associated with the security group.
	IpPermissions []IpPermission `locationName:"ipPermissions" locationNameList:"item" type:"list"`

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []IpPermission `locationName:"ipPermissionsEgress" locationNameList:"item" type:"list"`

	// The AWS account ID of the owner of the security group.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Any tags assigned to the security group.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes a security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SecurityGroupIdentifier
type SecurityGroupIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s SecurityGroupIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC with a security group that references your security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SecurityGroupReference
type SecurityGroupReference struct {
	_ struct{} `type:"structure"`

	// The ID of your security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The ID of the VPC with the referencing security group.
	ReferencingVpcId *string `locationName:"referencingVpcId" type:"string"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s SecurityGroupReference) String() string {
	return awsutil.Prettify(s)
}

// Describes a service configuration for a VPC endpoint service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ServiceConfiguration
type ServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether requests from other AWS accounts to create an endpoint
	// to the service must first be accepted.
	AcceptanceRequired *bool `locationName:"acceptanceRequired" type:"boolean"`

	// In the Availability Zones in which the service is available.
	AvailabilityZones []string `locationName:"availabilityZoneSet" locationNameList:"item" type:"list"`

	// The DNS names for the service.
	BaseEndpointDnsNames []string `locationName:"baseEndpointDnsNameSet" locationNameList:"item" type:"list"`

	// Indicates whether the service manages it's VPC endpoints. Management of the
	// service VPC endpoints using the VPC endpoint API is restricted.
	ManagesVpcEndpoints *bool `locationName:"managesVpcEndpoints" type:"boolean"`

	// The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
	NetworkLoadBalancerArns []string `locationName:"networkLoadBalancerArnSet" locationNameList:"item" type:"list"`

	// The private DNS name for the service.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The ID of the service.
	ServiceId *string `locationName:"serviceId" type:"string"`

	// The name of the service.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The service state.
	ServiceState ServiceState `locationName:"serviceState" type:"string" enum:"true"`

	// The type of service.
	ServiceType []ServiceTypeDetail `locationName:"serviceType" locationNameList:"item" type:"list"`

	// Any tags assigned to the service.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC endpoint service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ServiceDetail
type ServiceDetail struct {
	_ struct{} `type:"structure"`

	// Indicates whether VPC endpoint connection requests to the service must be
	// accepted by the service owner.
	AcceptanceRequired *bool `locationName:"acceptanceRequired" type:"boolean"`

	// The Availability Zones in which the service is available.
	AvailabilityZones []string `locationName:"availabilityZoneSet" locationNameList:"item" type:"list"`

	// The DNS names for the service.
	BaseEndpointDnsNames []string `locationName:"baseEndpointDnsNameSet" locationNameList:"item" type:"list"`

	// Indicates whether the service manages it's VPC endpoints. Management of the
	// service VPC endpoints using the VPC endpoint API is restricted.
	ManagesVpcEndpoints *bool `locationName:"managesVpcEndpoints" type:"boolean"`

	// The AWS account ID of the service owner.
	Owner *string `locationName:"owner" type:"string"`

	// The private DNS name for the service.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The ID of the endpoint service.
	ServiceId *string `locationName:"serviceId" type:"string"`

	// The Amazon Resource Name (ARN) of the service.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The type of service.
	ServiceType []ServiceTypeDetail `locationName:"serviceType" locationNameList:"item" type:"list"`

	// Any tags assigned to the service.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// Indicates whether the service supports endpoint policies.
	VpcEndpointPolicySupported *bool `locationName:"vpcEndpointPolicySupported" type:"boolean"`
}

// String returns the string representation
func (s ServiceDetail) String() string {
	return awsutil.Prettify(s)
}

// Describes the type of service for a VPC endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ServiceTypeDetail
type ServiceTypeDetail struct {
	_ struct{} `type:"structure"`

	// The type of service.
	ServiceType ServiceType `locationName:"serviceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ServiceTypeDetail) String() string {
	return awsutil.Prettify(s)
}

// Describes the time period for a Scheduled Instance to start its first schedule.
// The time period must span less than one day.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SlotDateTimeRangeRequest
type SlotDateTimeRangeRequest struct {
	_ struct{} `type:"structure"`

	// The earliest date and time, in UTC, for the Scheduled Instance to start.
	//
	// EarliestTime is a required field
	EarliestTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The latest date and time, in UTC, for the Scheduled Instance to start. This
	// value must be later than or equal to the earliest date and at most three
	// months in the future.
	//
	// LatestTime is a required field
	LatestTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s SlotDateTimeRangeRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SlotDateTimeRangeRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SlotDateTimeRangeRequest"}

	if s.EarliestTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EarliestTime"))
	}

	if s.LatestTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("LatestTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the time period for a Scheduled Instance to start its first schedule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SlotStartTimeRangeRequest
type SlotStartTimeRangeRequest struct {
	_ struct{} `type:"structure"`

	// The earliest date and time, in UTC, for the Scheduled Instance to start.
	EarliestTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The latest date and time, in UTC, for the Scheduled Instance to start.
	LatestTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SlotStartTimeRangeRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Snapshot
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The data encryption key identifier for the snapshot. This value is a unique
	// identifier that corresponds to the data encryption key that was used to encrypt
	// the original volume or snapshot copy. Because data encryption keys are inherited
	// by volumes created from snapshots, and vice versa, if snapshots share the
	// same data encryption key identifier, then they belong to the same volume/snapshot
	// lineage. This parameter is only returned by the DescribeSnapshots API operation.
	DataEncryptionKeyId *string `locationName:"dataEncryptionKeyId" type:"string"`

	// The description for the snapshot.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the snapshot is encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The full ARN of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) that was used to protect the volume encryption key for the parent
	// volume.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// Value from an Amazon-maintained list (amazon | self | all | aws-marketplace
	// | microsoft) of snapshot owners. Not to be confused with the user-configured
	// AWS account alias, which is set from the IAM console.
	OwnerAlias *string `locationName:"ownerAlias" type:"string"`

	// The AWS account ID of the EBS snapshot owner.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The progress of the snapshot, as a percentage.
	Progress *string `locationName:"progress" type:"string"`

	// The ID of the snapshot. Each snapshot receives a unique identifier when it
	// is created.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// The time stamp when the snapshot was initiated.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The snapshot state.
	State SnapshotState `locationName:"status" type:"string" enum:"true"`

	// Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy
	// operation fails (for example, if the proper AWS Key Management Service (AWS
	// KMS) permissions are not obtained) this field displays error state details
	// to help you diagnose why the error occurred. This parameter is only returned
	// by the DescribeSnapshots API operation.
	StateMessage *string `locationName:"statusMessage" type:"string"`

	// Any tags assigned to the snapshot.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the volume that was used to create the snapshot. Snapshots created
	// by the CopySnapshot action have an arbitrary volume ID that should not be
	// used for any purpose.
	VolumeId *string `locationName:"volumeId" type:"string"`

	// The size of the volume, in GiB.
	VolumeSize *int64 `locationName:"volumeSize" type:"integer"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// Describes the snapshot created from the imported disk.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SnapshotDetail
type SnapshotDetail struct {
	_ struct{} `type:"structure"`

	// A description for the snapshot.
	Description *string `locationName:"description" type:"string"`

	// The block device mapping for the snapshot.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The size of the disk in the snapshot, in GiB.
	DiskImageSize *float64 `locationName:"diskImageSize" type:"double"`

	// The format of the disk image from which the snapshot is created.
	Format *string `locationName:"format" type:"string"`

	// The percentage of progress for the task.
	Progress *string `locationName:"progress" type:"string"`

	// The snapshot ID of the disk being imported.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// A brief status of the snapshot creation.
	Status *string `locationName:"status" type:"string"`

	// A detailed status message for the snapshot creation.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The URL used to access the disk image.
	Url *string `locationName:"url" type:"string"`

	// The S3 bucket for the disk image.
	UserBucket *UserBucketDetails `locationName:"userBucket" type:"structure"`
}

// String returns the string representation
func (s SnapshotDetail) String() string {
	return awsutil.Prettify(s)
}

// The disk container object for the import snapshot request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SnapshotDiskContainer
type SnapshotDiskContainer struct {
	_ struct{} `type:"structure"`

	// The description of the disk image being imported.
	Description *string `type:"string"`

	// The format of the disk image being imported.
	//
	// Valid values: VHD | VMDK
	Format *string `type:"string"`

	// The URL to the Amazon S3-based disk image being imported. It can either be
	// a https URL (https://..) or an Amazon S3 URL (s3://..).
	Url *string `type:"string"`

	// The S3 bucket for the disk image.
	UserBucket *UserBucket `type:"structure"`
}

// String returns the string representation
func (s SnapshotDiskContainer) String() string {
	return awsutil.Prettify(s)
}

// Details about the import snapshot task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SnapshotTaskDetail
type SnapshotTaskDetail struct {
	_ struct{} `type:"structure"`

	// The description of the snapshot.
	Description *string `locationName:"description" type:"string"`

	// The size of the disk in the snapshot, in GiB.
	DiskImageSize *float64 `locationName:"diskImageSize" type:"double"`

	// Indicates whether the snapshot is encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The format of the disk image from which the snapshot is created.
	Format *string `locationName:"format" type:"string"`

	// The identifier for the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) that was used to create the encrypted snapshot.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The percentage of completion for the import snapshot task.
	Progress *string `locationName:"progress" type:"string"`

	// The snapshot ID of the disk being imported.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// A brief status for the import snapshot task.
	Status *string `locationName:"status" type:"string"`

	// A detailed status message for the import snapshot task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The URL of the disk image from which the snapshot is created.
	Url *string `locationName:"url" type:"string"`

	// The S3 bucket for the disk image.
	UserBucket *UserBucketDetails `locationName:"userBucket" type:"structure"`
}

// String returns the string representation
func (s SnapshotTaskDetail) String() string {
	return awsutil.Prettify(s)
}

// Describes the data feed for a Spot Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotDatafeedSubscription
type SpotDatafeedSubscription struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the Spot Instance data feed is located.
	Bucket *string `locationName:"bucket" type:"string"`

	// The fault codes for the Spot Instance request, if any.
	Fault *SpotInstanceStateFault `locationName:"fault" type:"structure"`

	// The AWS account ID of the account.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The prefix that is prepended to data feed files.
	Prefix *string `locationName:"prefix" type:"string"`

	// The state of the Spot Instance data feed subscription.
	State DatafeedSubscriptionState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s SpotDatafeedSubscription) String() string {
	return awsutil.Prettify(s)
}

// Describes the launch specification for one or more Spot Instances. If you
// include On-Demand capacity in your fleet request, you can't use SpotFleetLaunchSpecification;
// you must use LaunchTemplateConfig (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotFleetLaunchSpecification
type SpotFleetLaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Deprecated.
	AddressingType *string `locationName:"addressingType" type:"string"`

	// One or more block devices that are mapped to the Spot instances. You can't
	// specify both a snapshot ID and an encryption value. This is because only
	// blank volumes can be encrypted on creation. If a snapshot is the basis for
	// a volume, it is not blank and its encryption status is used for the volume
	// encryption status.
	BlockDeviceMappings []BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// Indicates whether the instances are optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	//
	// Default: false
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// The ID of the kernel.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// Enable or disable monitoring for the instances.
	Monitoring *SpotFleetMonitoring `locationName:"monitoring" type:"structure"`

	// One or more network interfaces. If you specify a network interface, you must
	// specify subnet IDs and security group IDs using the network interface.
	NetworkInterfaces []InstanceNetworkInterfaceSpecification `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`

	// The placement information.
	Placement *SpotPlacement `locationName:"placement" type:"structure"`

	// The ID of the RAM disk. Some kernels require additional drivers at launch.
	// Check the kernel requirements for information about whether you need to specify
	// a RAM disk. To find kernel requirements, refer to the AWS Resource Center
	// and search for the kernel ID.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// One or more security groups. When requesting instances in a VPC, you must
	// specify the IDs of the security groups. When requesting instances in EC2-Classic,
	// you can specify the names or the IDs of the security groups.
	SecurityGroups []GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	// If this value is not specified, the default is the Spot price specified for
	// the fleet. To determine the Spot price per unit hour, divide the Spot price
	// by the value of WeightedCapacity.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The ID of the subnet in which to launch the instances. To specify multiple
	// subnets, separate them using commas; for example, "subnet-a61dafcf, subnet-65ea5f08".
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The tags to apply during creation.
	TagSpecifications []SpotFleetTagSpecification `locationName:"tagSpecificationSet" locationNameList:"item" type:"list"`

	// The Base64-encoded user data that instances use when starting up.
	UserData *string `locationName:"userData" type:"string"`

	// The number of units provided by the specified instance type. These are the
	// same units that you chose to set the target capacity in terms of instances,
	// or a performance characteristic such as vCPUs, memory, or I/O.
	//
	// If the target capacity divided by this value is not a whole number, Amazon
	// EC2 rounds the number of instances to the next whole number. If this value
	// is not specified, the default is 1.
	WeightedCapacity *float64 `locationName:"weightedCapacity" type:"double"`
}

// String returns the string representation
func (s SpotFleetLaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes whether monitoring is enabled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotFleetMonitoring
type SpotFleetMonitoring struct {
	_ struct{} `type:"structure"`

	// Enables monitoring for the instance.
	//
	// Default: false
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation
func (s SpotFleetMonitoring) String() string {
	return awsutil.Prettify(s)
}

// Describes a Spot Fleet request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotFleetRequestConfig
type SpotFleetRequestConfig struct {
	_ struct{} `type:"structure"`

	// The progress of the Spot Fleet request. If there is an error, the status
	// is error. After all requests are placed, the status is pending_fulfillment.
	// If the size of the fleet is equal to or greater than its target capacity,
	// the status is fulfilled. If the size of the fleet is decreased, the status
	// is pending_termination while Spot Instances are terminating.
	ActivityStatus ActivityStatus `locationName:"activityStatus" type:"string" enum:"true"`

	// The creation date and time of the request.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// The configuration of the Spot Fleet request.
	SpotFleetRequestConfig *SpotFleetRequestConfigData `locationName:"spotFleetRequestConfig" type:"structure"`

	// The ID of the Spot Fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string"`

	// The state of the Spot Fleet request.
	SpotFleetRequestState BatchState `locationName:"spotFleetRequestState" type:"string" enum:"true"`
}

// String returns the string representation
func (s SpotFleetRequestConfig) String() string {
	return awsutil.Prettify(s)
}

// Describes the configuration of a Spot Fleet request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotFleetRequestConfigData
type SpotFleetRequestConfigData struct {
	_ struct{} `type:"structure"`

	// Indicates how to allocate the target capacity across the Spot pools specified
	// by the Spot Fleet request. The default is lowestPrice.
	AllocationStrategy AllocationStrategy `locationName:"allocationStrategy" type:"string" enum:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of your listings. This helps to avoid duplicate listings. For more information,
	// see Ensuring Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether running Spot Instances should be terminated if you decrease
	// the target capacity of the Spot Fleet request below the current size of the
	// Spot Fleet.
	ExcessCapacityTerminationPolicy ExcessCapacityTerminationPolicy `locationName:"excessCapacityTerminationPolicy" type:"string" enum:"true"`

	// The number of units fulfilled by this request compared to the set target
	// capacity. You cannot set this value.
	FulfilledCapacity *float64 `locationName:"fulfilledCapacity" type:"double"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that grants the Spot Fleet the permission to request, launch, terminate,
	// and tag instances on your behalf. For more information, see Spot Fleet Prerequisites
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites)
	// in the Amazon EC2 User Guide for Linux Instances. Spot Fleet can terminate
	// Spot Instances on your behalf when you cancel its Spot Fleet request using
	// CancelSpotFleetRequests or when the Spot Fleet request expires, if you set
	// TerminateInstancesWithExpiration.
	//
	// IamFleetRole is a required field
	IamFleetRole *string `locationName:"iamFleetRole" type:"string" required:"true"`

	// The behavior when a Spot Instance is interrupted. The default is terminate.
	InstanceInterruptionBehavior InstanceInterruptionBehavior `locationName:"instanceInterruptionBehavior" type:"string" enum:"true"`

	// The number of Spot pools across which to allocate your target Spot capacity.
	// Valid only when Spot AllocationStrategy is set to lowest-price. Spot Fleet
	// selects the cheapest Spot pools and evenly allocates your target Spot capacity
	// across the number of Spot pools that you specify.
	InstancePoolsToUseCount *int64 `locationName:"instancePoolsToUseCount" type:"integer"`

	// The launch specifications for the Spot Fleet request. If you specify LaunchSpecifications,
	// you can't specify LaunchTemplateConfigs. If you include On-Demand capacity
	// in your request, you must use LaunchTemplateConfigs.
	LaunchSpecifications []SpotFleetLaunchSpecification `locationName:"launchSpecifications" locationNameList:"item" type:"list"`

	// The launch template and overrides. If you specify LaunchTemplateConfigs,
	// you can't specify LaunchSpecifications. If you include On-Demand capacity
	// in your request, you must use LaunchTemplateConfigs.
	LaunchTemplateConfigs []LaunchTemplateConfig `locationName:"launchTemplateConfigs" locationNameList:"item" type:"list"`

	// One or more Classic Load Balancers and target groups to attach to the Spot
	// Fleet request. Spot Fleet registers the running Spot Instances with the specified
	// Classic Load Balancers and target groups.
	//
	// With Network Load Balancers, Spot Fleet cannot register instances that have
	// the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1,
	// HS1, M1, M2, M3, and T1.
	LoadBalancersConfig *LoadBalancersConfig `locationName:"loadBalancersConfig" type:"structure"`

	// The order of the launch template overrides to use in fulfilling On-Demand
	// capacity. If you specify lowestPrice, Spot Fleet uses price to determine
	// the order, launching the lowest price first. If you specify prioritized,
	// Spot Fleet uses the priority that you assign to each Spot Fleet launch template
	// override, launching the highest priority first. If you do not specify a value,
	// Spot Fleet defaults to lowestPrice.
	OnDemandAllocationStrategy OnDemandAllocationStrategy `locationName:"onDemandAllocationStrategy" type:"string" enum:"true"`

	// The number of On-Demand units fulfilled by this request compared to the set
	// target On-Demand capacity.
	OnDemandFulfilledCapacity *float64 `locationName:"onDemandFulfilledCapacity" type:"double"`

	// The number of On-Demand units to request. You can choose to set the target
	// capacity in terms of instances or a performance characteristic that is important
	// to your application workload, such as vCPUs, memory, or I/O. If the request
	// type is maintain, you can specify a target capacity of 0 and add capacity
	// later.
	OnDemandTargetCapacity *int64 `locationName:"onDemandTargetCapacity" type:"integer"`

	// Indicates whether Spot Fleet should replace unhealthy instances.
	ReplaceUnhealthyInstances *bool `locationName:"replaceUnhealthyInstances" type:"boolean"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	// The default is the On-Demand price.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The number of units to request for the Spot Fleet. You can choose to set
	// the target capacity in terms of instances or a performance characteristic
	// that is important to your application workload, such as vCPUs, memory, or
	// I/O. If the request type is maintain, you can specify a target capacity of
	// 0 and add capacity later.
	//
	// TargetCapacity is a required field
	TargetCapacity *int64 `locationName:"targetCapacity" type:"integer" required:"true"`

	// Indicates whether running Spot Instances are terminated when the Spot Fleet
	// request expires.
	TerminateInstancesWithExpiration *bool `locationName:"terminateInstancesWithExpiration" type:"boolean"`

	// The type of request. Indicates whether the Spot Fleet only requests the target
	// capacity or also attempts to maintain it. When this value is request, the
	// Spot Fleet only places the required requests. It does not attempt to replenish
	// Spot Instances if capacity is diminished, nor does it submit requests in
	// alternative Spot pools if capacity is not available. When this value is maintain,
	// the Spot Fleet maintains the target capacity. The Spot Fleet places the required
	// requests to meet capacity and automatically replenishes any interrupted instances.
	// Default: maintain. instant is listed but is not used by Spot Fleet.
	Type FleetType `locationName:"type" type:"string" enum:"true"`

	// The start date and time of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ).
	// By default, Amazon EC2 starts fulfilling the request immediately.
	ValidFrom *time.Time `locationName:"validFrom" type:"timestamp" timestampFormat:"iso8601"`

	// The end date and time of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ).
	// After the end date and time, no new Spot Instance requests are placed or
	// able to fulfill the request. If no value is specified, the Spot Fleet request
	// remains until you cancel it.
	ValidUntil *time.Time `locationName:"validUntil" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotFleetRequestConfigData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpotFleetRequestConfigData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SpotFleetRequestConfigData"}

	if s.IamFleetRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamFleetRole"))
	}

	if s.TargetCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetCapacity"))
	}
	if s.LaunchTemplateConfigs != nil {
		for i, v := range s.LaunchTemplateConfigs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LaunchTemplateConfigs", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.LoadBalancersConfig != nil {
		if err := s.LoadBalancersConfig.Validate(); err != nil {
			invalidParams.AddNested("LoadBalancersConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The tags for a Spot Fleet resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotFleetTagSpecification
type SpotFleetTagSpecification struct {
	_ struct{} `type:"structure"`

	// The type of resource. Currently, the only resource type that is supported
	// is instance.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The tags.
	Tags []Tag `locationName:"tag" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s SpotFleetTagSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes a Spot Instance request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotInstanceRequest
type SpotInstanceRequest struct {
	_ struct{} `type:"structure"`

	// If you specified a duration and your Spot Instance request was fulfilled,
	// this is the fixed hourly price in effect for the Spot Instance while it runs.
	ActualBlockHourlyPrice *string `locationName:"actualBlockHourlyPrice" type:"string"`

	// The Availability Zone group. If you specify the same Availability Zone group
	// for all Spot Instance requests, all Spot Instances are launched in the same
	// Availability Zone.
	AvailabilityZoneGroup *string `locationName:"availabilityZoneGroup" type:"string"`

	// The duration for the Spot Instance, in minutes.
	BlockDurationMinutes *int64 `locationName:"blockDurationMinutes" type:"integer"`

	// The date and time when the Spot Instance request was created, in UTC format
	// (for example, YYYY-MM-DDTHH:MM:SSZ).
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// The fault codes for the Spot Instance request, if any.
	Fault *SpotInstanceStateFault `locationName:"fault" type:"structure"`

	// The instance ID, if an instance has been launched to fulfill the Spot Instance
	// request.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The behavior when a Spot Instance is interrupted.
	InstanceInterruptionBehavior InstanceInterruptionBehavior `locationName:"instanceInterruptionBehavior" type:"string" enum:"true"`

	// The instance launch group. Launch groups are Spot Instances that launch together
	// and terminate together.
	LaunchGroup *string `locationName:"launchGroup" type:"string"`

	// Additional information for launching instances.
	LaunchSpecification *LaunchSpecification `locationName:"launchSpecification" type:"structure"`

	// The Availability Zone in which the request is launched.
	LaunchedAvailabilityZone *string `locationName:"launchedAvailabilityZone" type:"string"`

	// The product description associated with the Spot Instance.
	ProductDescription RIProductDescription `locationName:"productDescription" type:"string" enum:"true"`

	// The ID of the Spot Instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`

	// The maximum price per hour that you are willing to pay for a Spot Instance.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The state of the Spot Instance request. Spot status information helps track
	// your Spot Instance requests. For more information, see Spot Status (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	State SpotInstanceState `locationName:"state" type:"string" enum:"true"`

	// The status code and status message describing the Spot Instance request.
	Status *SpotInstanceStatus `locationName:"status" type:"structure"`

	// Any tags assigned to the resource.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The Spot Instance request type.
	Type SpotInstanceType `locationName:"type" type:"string" enum:"true"`

	// The start date of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// The request becomes active at this date and time.
	ValidFrom *time.Time `locationName:"validFrom" type:"timestamp" timestampFormat:"iso8601"`

	// The end date of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// If this is a one-time request, it remains active until all instances launch,
	// the request is canceled, or this date is reached. If the request is persistent,
	// it remains active until it is canceled or this date is reached. The default
	// end date is 7 days from the current date.
	ValidUntil *time.Time `locationName:"validUntil" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotInstanceRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a Spot Instance state change.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotInstanceStateFault
type SpotInstanceStateFault struct {
	_ struct{} `type:"structure"`

	// The reason code for the Spot Instance state change.
	Code *string `locationName:"code" type:"string"`

	// The message for the Spot Instance state change.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SpotInstanceStateFault) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a Spot Instance request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotInstanceStatus
type SpotInstanceStatus struct {
	_ struct{} `type:"structure"`

	// The status code. For a list of status codes, see Spot Status Codes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand)
	// in the Amazon EC2 User Guide for Linux Instances.
	Code *string `locationName:"code" type:"string"`

	// The description for the status code.
	Message *string `locationName:"message" type:"string"`

	// The date and time of the most recent status update, in UTC format (for example,
	// YYYY-MM-DDTHH:MM:SSZ).
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotInstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// The options for Spot Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotMarketOptions
type SpotMarketOptions struct {
	_ struct{} `type:"structure"`

	// The required duration for the Spot Instances (also known as Spot blocks),
	// in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300,
	// or 360).
	BlockDurationMinutes *int64 `type:"integer"`

	// The behavior when a Spot Instance is interrupted. The default is terminate.
	InstanceInterruptionBehavior InstanceInterruptionBehavior `type:"string" enum:"true"`

	// The maximum hourly price you're willing to pay for the Spot Instances. The
	// default is the On-Demand price.
	MaxPrice *string `type:"string"`

	// The Spot Instance request type. For RunInstances, persistent Spot Instance
	// requests are only supported when InstanceInterruptionBehavior is set to either
	// hibernate or stop.
	SpotInstanceType SpotInstanceType `type:"string" enum:"true"`

	// The end date of the request. For a one-time request, the request remains
	// active until all instances launch, the request is canceled, or this date
	// is reached. If the request is persistent, it remains active until it is canceled
	// or this date and time is reached. The default end date is 7 days from the
	// current date.
	ValidUntil *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotMarketOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes the configuration of Spot Instances in an EC2 Fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotOptions
type SpotOptions struct {
	_ struct{} `type:"structure"`

	// Indicates how to allocate the target capacity across the Spot pools specified
	// by the Spot Fleet request. The default is lowest-price.
	AllocationStrategy SpotAllocationStrategy `locationName:"allocationStrategy" type:"string" enum:"true"`

	// The behavior when a Spot Instance is interrupted. The default is terminate.
	InstanceInterruptionBehavior SpotInstanceInterruptionBehavior `locationName:"instanceInterruptionBehavior" type:"string" enum:"true"`

	// The number of Spot pools across which to allocate your target Spot capacity.
	// Valid only when AllocationStrategy is set to lowestPrice. EC2 Fleet selects
	// the cheapest Spot pools and evenly allocates your target Spot capacity across
	// the number of Spot pools that you specify.
	InstancePoolsToUseCount *int64 `locationName:"instancePoolsToUseCount" type:"integer"`

	// The minimum target capacity for Spot Instances in the fleet. If the minimum
	// target capacity is not reached, the fleet launches no instances.
	MinTargetCapacity *int64 `locationName:"minTargetCapacity" type:"integer"`

	// Indicates that the fleet launches all Spot Instances into a single Availability
	// Zone.
	SingleAvailabilityZone *bool `locationName:"singleAvailabilityZone" type:"boolean"`

	// Indicates that the fleet uses a single instance type to launch all Spot Instances
	// in the fleet.
	SingleInstanceType *bool `locationName:"singleInstanceType" type:"boolean"`
}

// String returns the string representation
func (s SpotOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes the configuration of Spot Instances in an EC2 Fleet request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotOptionsRequest
type SpotOptionsRequest struct {
	_ struct{} `type:"structure"`

	// Indicates how to allocate the target capacity across the Spot pools specified
	// by the Spot Fleet request. The default is lowestPrice.
	AllocationStrategy SpotAllocationStrategy `type:"string" enum:"true"`

	// The behavior when a Spot Instance is interrupted. The default is terminate.
	InstanceInterruptionBehavior SpotInstanceInterruptionBehavior `type:"string" enum:"true"`

	// The number of Spot pools across which to allocate your target Spot capacity.
	// Valid only when Spot AllocationStrategy is set to lowest-price. EC2 Fleet
	// selects the cheapest Spot pools and evenly allocates your target Spot capacity
	// across the number of Spot pools that you specify.
	InstancePoolsToUseCount *int64 `type:"integer"`

	// The minimum target capacity for Spot Instances in the fleet. If the minimum
	// target capacity is not reached, the fleet launches no instances.
	MinTargetCapacity *int64 `type:"integer"`

	// Indicates that the fleet launches all Spot Instances into a single Availability
	// Zone.
	SingleAvailabilityZone *bool `type:"boolean"`

	// Indicates that the fleet uses a single instance type to launch all Spot Instances
	// in the fleet.
	SingleInstanceType *bool `type:"boolean"`
}

// String returns the string representation
func (s SpotOptionsRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes Spot Instance placement.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotPlacement
type SpotPlacement struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	//
	// [Spot Fleet only] To specify multiple Availability Zones, separate them using
	// commas; for example, "us-west-2a, us-west-2b".
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The name of the placement group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The tenancy of the instance (if the instance is running in a VPC). An instance
	// with a tenancy of dedicated runs on single-tenant hardware. The host tenancy
	// is not supported for Spot Instances.
	Tenancy Tenancy `locationName:"tenancy" type:"string" enum:"true"`
}

// String returns the string representation
func (s SpotPlacement) String() string {
	return awsutil.Prettify(s)
}

// Describes the maximum price per hour that you are willing to pay for a Spot
// Instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SpotPrice
type SpotPrice struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The instance type.
	InstanceType InstanceType `locationName:"instanceType" type:"string" enum:"true"`

	// A general description of the AMI.
	ProductDescription RIProductDescription `locationName:"productDescription" type:"string" enum:"true"`

	// The maximum price per hour that you are willing to pay for a Spot Instance.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The date and time the request was created, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotPrice) String() string {
	return awsutil.Prettify(s)
}

// Describes a stale rule in a security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StaleIpPermission
type StaleIpPermission struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP type
	// number. A value of -1 indicates all ICMP types.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The IP protocol name (for tcp, udp, and icmp) or number (see Protocol Numbers)
	// (http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// The IP ranges. Not applicable for stale security group rules.
	IpRanges []string `locationName:"ipRanges" locationNameList:"item" type:"list"`

	// The prefix list IDs for an AWS service. Not applicable for stale security
	// group rules.
	PrefixListIds []string `locationName:"prefixListIds" locationNameList:"item" type:"list"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP type
	// number. A value of -1 indicates all ICMP types.
	ToPort *int64 `locationName:"toPort" type:"integer"`

	// The security group pairs. Returns the ID of the referenced security group
	// and VPC, and the ID and status of the VPC peering connection.
	UserIdGroupPairs []UserIdGroupPair `locationName:"groups" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s StaleIpPermission) String() string {
	return awsutil.Prettify(s)
}

// Describes a stale security group (a security group that contains stale rules).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StaleSecurityGroup
type StaleSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The description of the security group.
	Description *string `locationName:"description" type:"string"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group.
	GroupName *string `locationName:"groupName" type:"string"`

	// Information about the stale inbound rules in the security group.
	StaleIpPermissions []StaleIpPermission `locationName:"staleIpPermissions" locationNameList:"item" type:"list"`

	// Information about the stale outbound rules in the security group.
	StaleIpPermissionsEgress []StaleIpPermission `locationName:"staleIpPermissionsEgress" locationNameList:"item" type:"list"`

	// The ID of the VPC for the security group.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s StaleSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes a state change.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StateReason
type StateReason struct {
	_ struct{} `type:"structure"`

	// The reason code for the state change.
	Code *string `locationName:"code" type:"string"`

	// The message for the state change.
	//
	//    * Server.InsufficientInstanceCapacity: There was insufficient capacity
	//    available to satisfy the launch request.
	//
	//    * Server.InternalError: An internal error caused the instance to terminate
	//    during launch.
	//
	//    * Server.ScheduledStop: The instance was stopped due to a scheduled retirement.
	//
	//    * Server.SpotInstanceShutdown: The instance was stopped because the number
	//    of Spot requests with a maximum price equal to or higher than the Spot
	//    price exceeded available capacity or because of an increase in the Spot
	//    price.
	//
	//    * Server.SpotInstanceTermination: The instance was terminated because
	//    the number of Spot requests with a maximum price equal to or higher than
	//    the Spot price exceeded available capacity or because of an increase in
	//    the Spot price.
	//
	//    * Client.InstanceInitiatedShutdown: The instance was shut down using the
	//    shutdown -h command from the instance.
	//
	//    * Client.InstanceTerminated: The instance was terminated or rebooted during
	//    AMI creation.
	//
	//    * Client.InternalError: A client error caused the instance to terminate
	//    during launch.
	//
	//    * Client.InvalidSnapshot.NotFound: The specified snapshot was not found.
	//
	//    * Client.UserInitiatedHibernate: Hibernation was initiated on the instance.
	//
	//    * Client.UserInitiatedShutdown: The instance was shut down using the Amazon
	//    EC2 API.
	//
	//    * Client.VolumeLimitExceeded: The limit on the number of EBS volumes or
	//    total storage was exceeded. Decrease usage or request an increase in your
	//    account limits.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s StateReason) String() string {
	return awsutil.Prettify(s)
}

// Describes the storage location for an instance store-backed AMI.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Storage
type Storage struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 storage location.
	S3 *S3Storage `type:"structure"`
}

// String returns the string representation
func (s Storage) String() string {
	return awsutil.Prettify(s)
}

// Describes a storage location in Amazon S3.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StorageLocation
type StorageLocation struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	Bucket *string `type:"string"`

	// The key.
	Key *string `type:"string"`
}

// String returns the string representation
func (s StorageLocation) String() string {
	return awsutil.Prettify(s)
}

// Describes a subnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Subnet
type Subnet struct {
	_ struct{} `type:"structure"`

	// Indicates whether a network interface created in this subnet (including a
	// network interface created by RunInstances) receives an IPv6 address.
	AssignIpv6AddressOnCreation *bool `locationName:"assignIpv6AddressOnCreation" type:"boolean"`

	// The Availability Zone of the subnet.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The AZ ID of the subnet.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of unused private IPv4 addresses in the subnet. The IPv4 addresses
	// for any stopped instances are considered unavailable.
	AvailableIpAddressCount *int64 `locationName:"availableIpAddressCount" type:"integer"`

	// The IPv4 CIDR block assigned to the subnet.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Indicates whether this is the default subnet for the Availability Zone.
	DefaultForAz *bool `locationName:"defaultForAz" type:"boolean"`

	// Information about the IPv6 CIDR blocks associated with the subnet.
	Ipv6CidrBlockAssociationSet []SubnetIpv6CidrBlockAssociation `locationName:"ipv6CidrBlockAssociationSet" locationNameList:"item" type:"list"`

	// Indicates whether instances launched in this subnet receive a public IPv4
	// address.
	MapPublicIpOnLaunch *bool `locationName:"mapPublicIpOnLaunch" type:"boolean"`

	// The ID of the AWS account that owns the subnet.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The current state of the subnet.
	State SubnetState `locationName:"state" type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the subnet.
	SubnetArn *string `locationName:"subnetArn" type:"string"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// Any tags assigned to the subnet.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC the subnet is in.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a CIDR block.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SubnetCidrBlockState
type SubnetCidrBlockState struct {
	_ struct{} `type:"structure"`

	// The state of a CIDR block.
	State SubnetCidrBlockStateCode `locationName:"state" type:"string" enum:"true"`

	// A message about the status of the CIDR block, if applicable.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s SubnetCidrBlockState) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv6 CIDR block associated with a subnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SubnetIpv6CidrBlockAssociation
type SubnetIpv6CidrBlockAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID for the CIDR block.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The IPv6 CIDR block.
	Ipv6CidrBlock *string `locationName:"ipv6CidrBlock" type:"string"`

	// Information about the state of the CIDR block.
	Ipv6CidrBlockState *SubnetCidrBlockState `locationName:"ipv6CidrBlockState" type:"structure"`
}

// String returns the string representation
func (s SubnetIpv6CidrBlockAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes the T2 or T3 instance whose credit option for CPU usage was successfully
// modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SuccessfulInstanceCreditSpecificationItem
type SuccessfulInstanceCreditSpecificationItem struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`
}

// String returns the string representation
func (s SuccessfulInstanceCreditSpecificationItem) String() string {
	return awsutil.Prettify(s)
}

// Describes a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode
	// characters. May not begin with aws:.
	Key *string `locationName:"key" type:"string"`

	// The value of the tag.
	//
	// Constraints: Tag values are case-sensitive and accept a maximum of 255 Unicode
	// characters.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Describes a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TagDescription
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `locationName:"key" type:"string"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The tag value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// The tags to apply to a resource when the resource is being created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TagSpecification
type TagSpecification struct {
	_ struct{} `type:"structure"`

	// The type of resource to tag. Currently, the resource types that support tagging
	// on creation are fleet, dedicated-host, instance, snapshot, and volume. To
	// tag a resource after it has been created, see CreateTags.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The tags to apply to the resource.
	Tags []Tag `locationName:"Tag" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s TagSpecification) String() string {
	return awsutil.Prettify(s)
}

// The number of units to request. You can choose to set the target capacity
// in terms of instances or a performance characteristic that is important to
// your application workload, such as vCPUs, memory, or I/O. If the request
// type is maintain, you can specify a target capacity of 0 and add capacity
// later.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetCapacitySpecification
type TargetCapacitySpecification struct {
	_ struct{} `type:"structure"`

	// The default TotalTargetCapacity, which is either Spot or On-Demand.
	DefaultTargetCapacityType DefaultTargetCapacityType `locationName:"defaultTargetCapacityType" type:"string" enum:"true"`

	// The number of On-Demand units to request.
	OnDemandTargetCapacity *int64 `locationName:"onDemandTargetCapacity" type:"integer"`

	// The maximum number of Spot units to launch.
	SpotTargetCapacity *int64 `locationName:"spotTargetCapacity" type:"integer"`

	// The number of units to request, filled using DefaultTargetCapacityType.
	TotalTargetCapacity *int64 `locationName:"totalTargetCapacity" type:"integer"`
}

// String returns the string representation
func (s TargetCapacitySpecification) String() string {
	return awsutil.Prettify(s)
}

// The number of units to request. You can choose to set the target capacity
// in terms of instances or a performance characteristic that is important to
// your application workload, such as vCPUs, memory, or I/O. If the request
// type is maintain, you can specify a target capacity of 0 and add capacity
// later.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetCapacitySpecificationRequest
type TargetCapacitySpecificationRequest struct {
	_ struct{} `type:"structure"`

	// The default TotalTargetCapacity, which is either Spot or On-Demand.
	DefaultTargetCapacityType DefaultTargetCapacityType `type:"string" enum:"true"`

	// The number of On-Demand units to request.
	OnDemandTargetCapacity *int64 `type:"integer"`

	// The number of Spot units to request.
	SpotTargetCapacity *int64 `type:"integer"`

	// The number of units to request, filled using DefaultTargetCapacityType.
	//
	// TotalTargetCapacity is a required field
	TotalTargetCapacity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TargetCapacitySpecificationRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetCapacitySpecificationRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetCapacitySpecificationRequest"}

	if s.TotalTargetCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("TotalTargetCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the Convertible Reserved Instance offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetConfiguration
type TargetConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of instances the Convertible Reserved Instance offering can be
	// applied to. This parameter is reserved and cannot be specified in a request
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The ID of the Convertible Reserved Instance offering.
	OfferingId *string `locationName:"offeringId" type:"string"`
}

// String returns the string representation
func (s TargetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Details about the target configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetConfigurationRequest
type TargetConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The number of instances the Covertible Reserved Instance offering can be
	// applied to. This parameter is reserved and cannot be specified in a request
	InstanceCount *int64 `type:"integer"`

	// The Convertible Reserved Instance offering ID.
	//
	// OfferingId is a required field
	OfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TargetConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetConfigurationRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetConfigurationRequest"}

	if s.OfferingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a load balancer target group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetGroup
type TargetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	Arn *string `locationName:"arn" type:"string"`
}

// String returns the string representation
func (s TargetGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes the target groups to attach to a Spot Fleet. Spot Fleet registers
// the running Spot Instances with these target groups.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetGroupsConfig
type TargetGroupsConfig struct {
	_ struct{} `type:"structure"`

	// One or more target groups.
	TargetGroups []TargetGroup `locationName:"targetGroups" locationNameList:"item" min:"1" type:"list"`
}

// String returns the string representation
func (s TargetGroupsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGroupsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetGroupsConfig"}
	if s.TargetGroups != nil && len(s.TargetGroups) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetGroups", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a target network associated with a Client VPN endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetNetwork
type TargetNetwork struct {
	_ struct{} `type:"structure"`

	// The ID of the association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The ID of the Client VPN endpoint with which the target network is associated.
	ClientVpnEndpointId *string `locationName:"clientVpnEndpointId" type:"string"`

	// The IDs of the security groups applied to the target network association.
	SecurityGroups []string `locationName:"securityGroups" locationNameList:"item" type:"list"`

	// The current state of the target network association.
	Status *AssociationStatus `locationName:"status" type:"structure"`

	// The ID of the subnet specified as the target network.
	TargetNetworkId *string `locationName:"targetNetworkId" type:"string"`

	// The ID of the VPC in which the target network (subnet) is located.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s TargetNetwork) String() string {
	return awsutil.Prettify(s)
}

// The total value of the new Convertible Reserved Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TargetReservationValue
type TargetReservationValue struct {
	_ struct{} `type:"structure"`

	// The total value of the Convertible Reserved Instances that make up the exchange.
	// This is the sum of the list value, remaining upfront price, and additional
	// upfront cost of the exchange.
	ReservationValue *ReservationValue `locationName:"reservationValue" type:"structure"`

	// The configuration of the Convertible Reserved Instances that make up the
	// exchange.
	TargetConfiguration *TargetConfiguration `locationName:"targetConfiguration" type:"structure"`
}

// String returns the string representation
func (s TargetReservationValue) String() string {
	return awsutil.Prettify(s)
}

// Information about a terminated Client VPN endpoint client connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TerminateConnectionStatus
type TerminateConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The ID of the client connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// A message about the status of the client connection, if applicable.
	CurrentStatus *VpnConnectionStatus `locationName:"currentStatus" type:"structure"`

	// The state of the client connection.
	PreviousStatus *VpnConnectionStatus `locationName:"previousStatus" type:"structure"`
}

// String returns the string representation
func (s TerminateConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a transit gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGateway
type TransitGateway struct {
	_ struct{} `type:"structure"`

	// The creation time.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the transit gateway.
	Description *string `locationName:"description" type:"string"`

	// The transit gateway options.
	Options *TransitGatewayOptions `locationName:"options" type:"structure"`

	// The ID of the AWS account ID that owns the transit gateway.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The state of the transit gateway.
	State TransitGatewayState `locationName:"state" type:"string" enum:"true"`

	// The tags for the transit gateway.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The Amazon Resource Name (ARN) of the transit gateway.
	TransitGatewayArn *string `locationName:"transitGatewayArn" type:"string"`

	// The ID of the transit gateway.
	TransitGatewayId *string `locationName:"transitGatewayId" type:"string"`
}

// String returns the string representation
func (s TransitGateway) String() string {
	return awsutil.Prettify(s)
}

// Describes an association between a resource attachment and a transit gateway
// route table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayAssociation
type TransitGatewayAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type.
	ResourceType TransitGatewayAttachmentResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The state of the association.
	State TransitGatewayAssociationState `locationName:"state" type:"string" enum:"true"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `locationName:"transitGatewayAttachmentId" type:"string"`

	// The ID of the transit gateway route table.
	TransitGatewayRouteTableId *string `locationName:"transitGatewayRouteTableId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes an attachment between a resource and a transit gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayAttachment
type TransitGatewayAttachment struct {
	_ struct{} `type:"structure"`

	// The association.
	Association *TransitGatewayAttachmentAssociation `locationName:"association" type:"structure"`

	// The creation time.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The ID of the AWS account that owns the resource.
	ResourceOwnerId *string `locationName:"resourceOwnerId" type:"string"`

	// The resource type.
	ResourceType TransitGatewayAttachmentResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The attachment state.
	State TransitGatewayAttachmentState `locationName:"state" type:"string" enum:"true"`

	// The tags for the attachment.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `locationName:"transitGatewayAttachmentId" type:"string"`

	// The ID of the transit gateway.
	TransitGatewayId *string `locationName:"transitGatewayId" type:"string"`

	// The ID of the AWS account that owns the transit gateway.
	TransitGatewayOwnerId *string `locationName:"transitGatewayOwnerId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes an association.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayAttachmentAssociation
type TransitGatewayAttachmentAssociation struct {
	_ struct{} `type:"structure"`

	// The state of the association.
	State TransitGatewayAssociationState `locationName:"state" type:"string" enum:"true"`

	// The ID of the route table for the transit gateway.
	TransitGatewayRouteTableId *string `locationName:"transitGatewayRouteTableId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayAttachmentAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes a propagation route table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayAttachmentPropagation
type TransitGatewayAttachmentPropagation struct {
	_ struct{} `type:"structure"`

	// The state of the propagation route table.
	State TransitGatewayPropagationState `locationName:"state" type:"string" enum:"true"`

	// The ID of the propagation route table.
	TransitGatewayRouteTableId *string `locationName:"transitGatewayRouteTableId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayAttachmentPropagation) String() string {
	return awsutil.Prettify(s)
}

// Describes the options for a transit gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayOptions
type TransitGatewayOptions struct {
	_ struct{} `type:"structure"`

	// A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
	// The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294
	// for 32-bit ASNs.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The ID of the default association route table.
	AssociationDefaultRouteTableId *string `locationName:"associationDefaultRouteTableId" type:"string"`

	// Indicates whether attachment requests are automatically accepted.
	AutoAcceptSharedAttachments AutoAcceptSharedAttachmentsValue `locationName:"autoAcceptSharedAttachments" type:"string" enum:"true"`

	// Indicates whether resource attachments are automatically associated with
	// the default association route table.
	DefaultRouteTableAssociation DefaultRouteTableAssociationValue `locationName:"defaultRouteTableAssociation" type:"string" enum:"true"`

	// Indicates whether resource attachments automatically propagate routes to
	// the default propagation route table.
	DefaultRouteTablePropagation DefaultRouteTablePropagationValue `locationName:"defaultRouteTablePropagation" type:"string" enum:"true"`

	// Indicates whether DNS support is enabled.
	DnsSupport DnsSupportValue `locationName:"dnsSupport" type:"string" enum:"true"`

	// The ID of the default propagation route table.
	PropagationDefaultRouteTableId *string `locationName:"propagationDefaultRouteTableId" type:"string"`

	// Indicates whether Equal Cost Multipath Protocol support is enabled.
	VpnEcmpSupport VpnEcmpSupportValue `locationName:"vpnEcmpSupport" type:"string" enum:"true"`
}

// String returns the string representation
func (s TransitGatewayOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes route propagation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayPropagation
type TransitGatewayPropagation struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type.
	ResourceType TransitGatewayAttachmentResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The state.
	State TransitGatewayPropagationState `locationName:"state" type:"string" enum:"true"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `locationName:"transitGatewayAttachmentId" type:"string"`

	// The ID of the transit gateway route table.
	TransitGatewayRouteTableId *string `locationName:"transitGatewayRouteTableId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayPropagation) String() string {
	return awsutil.Prettify(s)
}

// Describes the options for a transit gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRequestOptions
type TransitGatewayRequestOptions struct {
	_ struct{} `type:"structure"`

	// A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
	// The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294
	// for 32-bit ASNs.
	AmazonSideAsn *int64 `type:"long"`

	// Enable or disable automatic acceptance of attachment requests. The default
	// is disable.
	AutoAcceptSharedAttachments AutoAcceptSharedAttachmentsValue `type:"string" enum:"true"`

	// Enable or disable automatic association with the default association route
	// table. The default is enable.
	DefaultRouteTableAssociation DefaultRouteTableAssociationValue `type:"string" enum:"true"`

	// Enable or disable automatic propagation of routes to the default propagation
	// route table. The default is enable.
	DefaultRouteTablePropagation DefaultRouteTablePropagationValue `type:"string" enum:"true"`

	// Enable or disable DNS support.
	DnsSupport DnsSupportValue `type:"string" enum:"true"`

	// Enable or disable Equal Cost Multipath Protocol support.
	VpnEcmpSupport VpnEcmpSupportValue `type:"string" enum:"true"`
}

// String returns the string representation
func (s TransitGatewayRequestOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes a route for a transit gateway route table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRoute
type TransitGatewayRoute struct {
	_ struct{} `type:"structure"`

	// The CIDR block used for destination matches.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// The state of the route.
	State TransitGatewayRouteState `locationName:"state" type:"string" enum:"true"`

	// The attachments.
	TransitGatewayAttachments []TransitGatewayRouteAttachment `locationName:"transitGatewayAttachments" locationNameList:"item" type:"list"`

	// The route type.
	Type TransitGatewayRouteType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s TransitGatewayRoute) String() string {
	return awsutil.Prettify(s)
}

// Describes a route attachment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRouteAttachment
type TransitGatewayRouteAttachment struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type.
	ResourceType TransitGatewayAttachmentResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `locationName:"transitGatewayAttachmentId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayRouteAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes a transit gateway route table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRouteTable
type TransitGatewayRouteTable struct {
	_ struct{} `type:"structure"`

	// The creation time.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether this is the default association route table for the transit
	// gateway.
	DefaultAssociationRouteTable *bool `locationName:"defaultAssociationRouteTable" type:"boolean"`

	// Indicates whether this is the default propagation route table for the transit
	// gateway.
	DefaultPropagationRouteTable *bool `locationName:"defaultPropagationRouteTable" type:"boolean"`

	// The state of the transit gateway route table.
	State TransitGatewayRouteTableState `locationName:"state" type:"string" enum:"true"`

	// Any tags assigned to the route table.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the transit gateway.
	TransitGatewayId *string `locationName:"transitGatewayId" type:"string"`

	// The ID of the transit gateway route table.
	TransitGatewayRouteTableId *string `locationName:"transitGatewayRouteTableId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayRouteTable) String() string {
	return awsutil.Prettify(s)
}

// Describes an association between a route table and a resource attachment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRouteTableAssociation
type TransitGatewayRouteTableAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type.
	ResourceType TransitGatewayAttachmentResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The state of the association.
	State TransitGatewayAssociationState `locationName:"state" type:"string" enum:"true"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `locationName:"transitGatewayAttachmentId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayRouteTableAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes a route table propagation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRouteTablePropagation
type TransitGatewayRouteTablePropagation struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of resource.
	ResourceType TransitGatewayAttachmentResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// The state of the resource.
	State TransitGatewayPropagationState `locationName:"state" type:"string" enum:"true"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `locationName:"transitGatewayAttachmentId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayRouteTablePropagation) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC attachment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayVpcAttachment
type TransitGatewayVpcAttachment struct {
	_ struct{} `type:"structure"`

	// The creation time.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The VPC attachment options.
	Options *TransitGatewayVpcAttachmentOptions `locationName:"options" type:"structure"`

	// The state of the VPC attachment.
	State TransitGatewayAttachmentState `locationName:"state" type:"string" enum:"true"`

	// The IDs of the subnets.
	SubnetIds []string `locationName:"subnetIds" locationNameList:"item" type:"list"`

	// The tags for the VPC attachment.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `locationName:"transitGatewayAttachmentId" type:"string"`

	// The ID of the transit gateway.
	TransitGatewayId *string `locationName:"transitGatewayId" type:"string"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`

	// The ID of the AWS account that owns the VPC.
	VpcOwnerId *string `locationName:"vpcOwnerId" type:"string"`
}

// String returns the string representation
func (s TransitGatewayVpcAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes the VPC attachment options.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayVpcAttachmentOptions
type TransitGatewayVpcAttachmentOptions struct {
	_ struct{} `type:"structure"`

	// Indicates whether DNS support is enabled.
	DnsSupport DnsSupportValue `locationName:"dnsSupport" type:"string" enum:"true"`

	// Indicates whether IPv6 support is enabled.
	Ipv6Support Ipv6SupportValue `locationName:"ipv6Support" type:"string" enum:"true"`
}

// String returns the string representation
func (s TransitGatewayVpcAttachmentOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes the T2 or T3 instance whose credit option for CPU usage was not
// modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnsuccessfulInstanceCreditSpecificationItem
type UnsuccessfulInstanceCreditSpecificationItem struct {
	_ struct{} `type:"structure"`

	// The applicable error for the T2 or T3 instance whose credit option for CPU
	// usage was not modified.
	Error *UnsuccessfulInstanceCreditSpecificationItemError `locationName:"error" type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`
}

// String returns the string representation
func (s UnsuccessfulInstanceCreditSpecificationItem) String() string {
	return awsutil.Prettify(s)
}

// Information about the error for the T2 or T3 instance whose credit option
// for CPU usage was not modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnsuccessfulInstanceCreditSpecificationItemError
type UnsuccessfulInstanceCreditSpecificationItemError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code UnsuccessfulInstanceCreditSpecificationErrorCode `locationName:"code" type:"string" enum:"true"`

	// The applicable error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnsuccessfulInstanceCreditSpecificationItemError) String() string {
	return awsutil.Prettify(s)
}

// Information about items that were not successfully processed in a batch call.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnsuccessfulItem
type UnsuccessfulItem struct {
	_ struct{} `type:"structure"`

	// Information about the error.
	Error *UnsuccessfulItemError `locationName:"error" type:"structure"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`
}

// String returns the string representation
func (s UnsuccessfulItem) String() string {
	return awsutil.Prettify(s)
}

// Information about the error that occurred. For more information about errors,
// see Error Codes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnsuccessfulItemError
type UnsuccessfulItemError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string"`

	// The error message accompanying the error code.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnsuccessfulItemError) String() string {
	return awsutil.Prettify(s)
}

// Describes the S3 bucket for the disk image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UserBucket
type UserBucket struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the disk image is located.
	S3Bucket *string `type:"string"`

	// The file name of the disk image.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s UserBucket) String() string {
	return awsutil.Prettify(s)
}

// Describes the S3 bucket for the disk image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UserBucketDetails
type UserBucketDetails struct {
	_ struct{} `type:"structure"`

	// The S3 bucket from which the disk image was created.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The file name of the disk image.
	S3Key *string `locationName:"s3Key" type:"string"`
}

// String returns the string representation
func (s UserBucketDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes the user data for an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UserData
type UserData struct {
	_ struct{} `type:"structure"`

	// The user data. If you are using an AWS SDK or command line tool, Base64-encoding
	// is performed for you, and you can load the text from a file. Otherwise, you
	// must provide Base64-encoded text.
	Data *string `locationName:"data" type:"string"`
}

// String returns the string representation
func (s UserData) String() string {
	return awsutil.Prettify(s)
}

// Describes a security group and AWS account ID pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UserIdGroupPair
type UserIdGroupPair struct {
	_ struct{} `type:"structure"`

	// A description for the security group rule that references this user ID group
	// pair.
	//
	// Constraints: Up to 255 characters in length. Allowed characters are a-z,
	// A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*
	Description *string `locationName:"description" type:"string"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group. In a request, use this parameter for a security
	// group in EC2-Classic or a default VPC only. For a security group in a nondefault
	// VPC, use the security group ID.
	//
	// For a referenced security group in another VPC, this value is not returned
	// if the referenced security group is deleted.
	GroupName *string `locationName:"groupName" type:"string"`

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string `locationName:"peeringStatus" type:"string"`

	// The ID of an AWS account.
	//
	// For a referenced security group in another VPC, the account ID of the referenced
	// security group is returned in the response. If the referenced security group
	// is deleted, this value is not returned.
	//
	// [EC2-Classic] Required when adding or removing rules that reference a security
	// group in another AWS account.
	UserId *string `locationName:"userId" type:"string"`

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string `locationName:"vpcId" type:"string"`

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s UserIdGroupPair) String() string {
	return awsutil.Prettify(s)
}

// Describes telemetry for a VPN tunnel.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VgwTelemetry
type VgwTelemetry struct {
	_ struct{} `type:"structure"`

	// The number of accepted routes.
	AcceptedRouteCount *int64 `locationName:"acceptedRouteCount" type:"integer"`

	// The date and time of the last change in status.
	LastStatusChange *time.Time `locationName:"lastStatusChange" type:"timestamp" timestampFormat:"iso8601"`

	// The Internet-routable IP address of the virtual private gateway's outside
	// interface.
	OutsideIpAddress *string `locationName:"outsideIpAddress" type:"string"`

	// The status of the VPN tunnel.
	Status TelemetryStatus `locationName:"status" type:"string" enum:"true"`

	// If an error occurs, a description of the error.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s VgwTelemetry) String() string {
	return awsutil.Prettify(s)
}

// Describes a volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Volume
type Volume struct {
	_ struct{} `type:"structure"`

	// Information about the volume attachments.
	Attachments []VolumeAttachment `locationName:"attachmentSet" locationNameList:"item" type:"list"`

	// The Availability Zone for the volume.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The time stamp when volume creation was initiated.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the volume will be encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For Provisioned IOPS SSD volumes, this represents the number of IOPS that
	// are provisioned for the volume. For General Purpose SSD volumes, this represents
	// the baseline performance of the volume and the rate at which the volume accumulates
	// I/O credits for bursting. For more information, see Amazon EBS Volume Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Constraints: Range is 100-16,000 IOPS for gp2 volumes and 100 to 64,000IOPS
	// for io1 volumes, in most Regions. The maximum IOPS for io1 of 64,000 is guaranteed
	// only on Nitro-based instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances).
	// Other instance families guarantee performance up to 32,000 IOPS.
	//
	// Condition: This parameter is required for requests to create io1 volumes;
	// it is not used in requests to create gp2, st1, sc1, or standard volumes.
	Iops *int64 `locationName:"iops" type:"integer"`

	// The full ARN of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) that was used to protect the volume encryption key for the volume.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The size of the volume, in GiBs.
	Size *int64 `locationName:"size" type:"integer"`

	// The snapshot from which the volume was created, if applicable.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// The volume state.
	State VolumeState `locationName:"status" type:"string" enum:"true"`

	// Any tags assigned to the volume.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the volume.
	VolumeId *string `locationName:"volumeId" type:"string"`

	// The volume type. This can be gp2 for General Purpose SSD, io1 for Provisioned
	// IOPS SSD, st1 for Throughput Optimized HDD, sc1 for Cold HDD, or standard
	// for Magnetic volumes.
	VolumeType VolumeType `locationName:"volumeType" type:"string" enum:"true"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// Describes volume attachment details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeAttachment
type VolumeAttachment struct {
	_ struct{} `type:"structure"`

	// The time stamp when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The device name.
	Device *string `locationName:"device" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The attachment state of the volume.
	State VolumeAttachmentState `locationName:"status" type:"string" enum:"true"`

	// The ID of the volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s VolumeAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes an EBS volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeDetail
type VolumeDetail struct {
	_ struct{} `type:"structure"`

	// The size of the volume, in GiB.
	//
	// Size is a required field
	Size *int64 `locationName:"size" type:"long" required:"true"`
}

// String returns the string representation
func (s VolumeDetail) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeDetail) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VolumeDetail"}

	if s.Size == nil {
		invalidParams.Add(aws.NewErrParamRequired("Size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the modification status of an EBS volume.
//
// If the volume has never been modified, some element values will be null.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeModification
type VolumeModification struct {
	_ struct{} `type:"structure"`

	// The modification completion or failure time.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// The current modification state. The modification state is null for unmodified
	// volumes.
	ModificationState VolumeModificationState `locationName:"modificationState" type:"string" enum:"true"`

	// The original IOPS rate of the volume.
	OriginalIops *int64 `locationName:"originalIops" type:"integer"`

	// The original size of the volume.
	OriginalSize *int64 `locationName:"originalSize" type:"integer"`

	// The original EBS volume type of the volume.
	OriginalVolumeType VolumeType `locationName:"originalVolumeType" type:"string" enum:"true"`

	// The modification progress, from 0 to 100 percent complete.
	Progress *int64 `locationName:"progress" type:"long"`

	// The modification start time.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// A status message about the modification progress or failure.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The target IOPS rate of the volume.
	TargetIops *int64 `locationName:"targetIops" type:"integer"`

	// The target size of the volume, in GiB.
	TargetSize *int64 `locationName:"targetSize" type:"integer"`

	// The target EBS volume type of the volume.
	TargetVolumeType VolumeType `locationName:"targetVolumeType" type:"string" enum:"true"`

	// The ID of the volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s VolumeModification) String() string {
	return awsutil.Prettify(s)
}

// Describes a volume status operation code.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeStatusAction
type VolumeStatusAction struct {
	_ struct{} `type:"structure"`

	// The code identifying the operation, for example, enable-volume-io.
	Code *string `locationName:"code" type:"string"`

	// A description of the operation.
	Description *string `locationName:"description" type:"string"`

	// The ID of the event associated with this operation.
	EventId *string `locationName:"eventId" type:"string"`

	// The event type associated with this operation.
	EventType *string `locationName:"eventType" type:"string"`
}

// String returns the string representation
func (s VolumeStatusAction) String() string {
	return awsutil.Prettify(s)
}

// Describes a volume status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeStatusDetails
type VolumeStatusDetails struct {
	_ struct{} `type:"structure"`

	// The name of the volume status.
	Name VolumeStatusName `locationName:"name" type:"string" enum:"true"`

	// The intended status of the volume status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s VolumeStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes a volume status event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeStatusEvent
type VolumeStatusEvent struct {
	_ struct{} `type:"structure"`

	// A description of the event.
	Description *string `locationName:"description" type:"string"`

	// The ID of this event.
	EventId *string `locationName:"eventId" type:"string"`

	// The type of this event.
	EventType *string `locationName:"eventType" type:"string"`

	// The latest end time of the event.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The earliest start time of the event.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s VolumeStatusEvent) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeStatusInfo
type VolumeStatusInfo struct {
	_ struct{} `type:"structure"`

	// The details of the volume status.
	Details []VolumeStatusDetails `locationName:"details" locationNameList:"item" type:"list"`

	// The status of the volume.
	Status VolumeStatusInfoStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s VolumeStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// Describes the volume status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VolumeStatusItem
type VolumeStatusItem struct {
	_ struct{} `type:"structure"`

	// The details of the operation.
	Actions []VolumeStatusAction `locationName:"actionsSet" locationNameList:"item" type:"list"`

	// The Availability Zone of the volume.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// A list of events associated with the volume.
	Events []VolumeStatusEvent `locationName:"eventsSet" locationNameList:"item" type:"list"`

	// The volume ID.
	VolumeId *string `locationName:"volumeId" type:"string"`

	// The volume status.
	VolumeStatus *VolumeStatusInfo `locationName:"volumeStatus" type:"structure"`
}

// String returns the string representation
func (s VolumeStatusItem) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Vpc
type Vpc struct {
	_ struct{} `type:"structure"`

	// The primary IPv4 CIDR block for the VPC.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Information about the IPv4 CIDR blocks associated with the VPC.
	CidrBlockAssociationSet []VpcCidrBlockAssociation `locationName:"cidrBlockAssociationSet" locationNameList:"item" type:"list"`

	// The ID of the set of DHCP options you've associated with the VPC (or default
	// if the default options are associated with the VPC).
	DhcpOptionsId *string `locationName:"dhcpOptionsId" type:"string"`

	// The allowed tenancy of instances launched into the VPC.
	InstanceTenancy Tenancy `locationName:"instanceTenancy" type:"string" enum:"true"`

	// Information about the IPv6 CIDR blocks associated with the VPC.
	Ipv6CidrBlockAssociationSet []VpcIpv6CidrBlockAssociation `locationName:"ipv6CidrBlockAssociationSet" locationNameList:"item" type:"list"`

	// Indicates whether the VPC is the default VPC.
	IsDefault *bool `locationName:"isDefault" type:"boolean"`

	// The ID of the AWS account that owns the VPC.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The current state of the VPC.
	State VpcState `locationName:"state" type:"string" enum:"true"`

	// Any tags assigned to the VPC.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s Vpc) String() string {
	return awsutil.Prettify(s)
}

// Describes an attachment between a virtual private gateway and a VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcAttachment
type VpcAttachment struct {
	_ struct{} `type:"structure"`

	// The current state of the attachment.
	State AttachmentStatus `locationName:"state" type:"string" enum:"true"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcAttachment) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv4 CIDR block associated with a VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcCidrBlockAssociation
type VpcCidrBlockAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID for the IPv4 CIDR block.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The IPv4 CIDR block.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Information about the state of the CIDR block.
	CidrBlockState *VpcCidrBlockState `locationName:"cidrBlockState" type:"structure"`
}

// String returns the string representation
func (s VpcCidrBlockAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a CIDR block.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcCidrBlockState
type VpcCidrBlockState struct {
	_ struct{} `type:"structure"`

	// The state of the CIDR block.
	State VpcCidrBlockStateCode `locationName:"state" type:"string" enum:"true"`

	// A message about the status of the CIDR block, if applicable.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s VpcCidrBlockState) String() string {
	return awsutil.Prettify(s)
}

// Describes whether a VPC is enabled for ClassicLink.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcClassicLink
type VpcClassicLink struct {
	_ struct{} `type:"structure"`

	// Indicates whether the VPC is enabled for ClassicLink.
	ClassicLinkEnabled *bool `locationName:"classicLinkEnabled" type:"boolean"`

	// Any tags assigned to the VPC.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcClassicLink) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcEndpoint
type VpcEndpoint struct {
	_ struct{} `type:"structure"`

	// The date and time the VPC endpoint was created.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp" timestampFormat:"iso8601"`

	// (Interface endpoint) The DNS entries for the endpoint.
	DnsEntries []DnsEntry `locationName:"dnsEntrySet" locationNameList:"item" type:"list"`

	// (Interface endpoint) Information about the security groups associated with
	// the network interface.
	Groups []SecurityGroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// (Interface endpoint) One or more network interfaces for the endpoint.
	NetworkInterfaceIds []string `locationName:"networkInterfaceIdSet" locationNameList:"item" type:"list"`

	// The policy document associated with the endpoint, if applicable.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// (Interface endpoint) Indicates whether the VPC is associated with a private
	// hosted zone.
	PrivateDnsEnabled *bool `locationName:"privateDnsEnabled" type:"boolean"`

	// Indicates whether the VPC endpoint is being managed by its service.
	RequesterManaged *bool `locationName:"requesterManaged" type:"boolean"`

	// (Gateway endpoint) One or more route tables associated with the endpoint.
	RouteTableIds []string `locationName:"routeTableIdSet" locationNameList:"item" type:"list"`

	// The name of the service to which the endpoint is associated.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The state of the VPC endpoint.
	State State `locationName:"state" type:"string" enum:"true"`

	// (Interface endpoint) One or more subnets in which the endpoint is located.
	SubnetIds []string `locationName:"subnetIdSet" locationNameList:"item" type:"list"`

	// Any tags assigned to the VPC endpoint.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC endpoint.
	VpcEndpointId *string `locationName:"vpcEndpointId" type:"string"`

	// The type of endpoint.
	VpcEndpointType VpcEndpointType `locationName:"vpcEndpointType" type:"string" enum:"true"`

	// The ID of the VPC to which the endpoint is associated.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC endpoint connection to a service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcEndpointConnection
type VpcEndpointConnection struct {
	_ struct{} `type:"structure"`

	// The date and time the VPC endpoint was created.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the service to which the endpoint is connected.
	ServiceId *string `locationName:"serviceId" type:"string"`

	// The ID of the VPC endpoint.
	VpcEndpointId *string `locationName:"vpcEndpointId" type:"string"`

	// The AWS account ID of the owner of the VPC endpoint.
	VpcEndpointOwner *string `locationName:"vpcEndpointOwner" type:"string"`

	// The state of the VPC endpoint.
	VpcEndpointState State `locationName:"vpcEndpointState" type:"string" enum:"true"`
}

// String returns the string representation
func (s VpcEndpointConnection) String() string {
	return awsutil.Prettify(s)
}

// Describes an IPv6 CIDR block associated with a VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcIpv6CidrBlockAssociation
type VpcIpv6CidrBlockAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID for the IPv6 CIDR block.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The IPv6 CIDR block.
	Ipv6CidrBlock *string `locationName:"ipv6CidrBlock" type:"string"`

	// Information about the state of the CIDR block.
	Ipv6CidrBlockState *VpcCidrBlockState `locationName:"ipv6CidrBlockState" type:"structure"`
}

// String returns the string representation
func (s VpcIpv6CidrBlockAssociation) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC peering connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcPeeringConnection
type VpcPeeringConnection struct {
	_ struct{} `type:"structure"`

	// Information about the accepter VPC. CIDR block information is only returned
	// when describing an active VPC peering connection.
	AccepterVpcInfo *VpcPeeringConnectionVpcInfo `locationName:"accepterVpcInfo" type:"structure"`

	// The time that an unaccepted VPC peering connection will expire.
	ExpirationTime *time.Time `locationName:"expirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about the requester VPC. CIDR block information is only returned
	// when describing an active VPC peering connection.
	RequesterVpcInfo *VpcPeeringConnectionVpcInfo `locationName:"requesterVpcInfo" type:"structure"`

	// The status of the VPC peering connection.
	Status *VpcPeeringConnectionStateReason `locationName:"status" type:"structure"`

	// Any tags assigned to the resource.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnection) String() string {
	return awsutil.Prettify(s)
}

// Describes the VPC peering connection options.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcPeeringConnectionOptionsDescription
type VpcPeeringConnectionOptionsDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether a local VPC can resolve public DNS hostnames to private
	// IP addresses when queried from instances in a peer VPC.
	AllowDnsResolutionFromRemoteVpc *bool `locationName:"allowDnsResolutionFromRemoteVpc" type:"boolean"`

	// Indicates whether a local ClassicLink connection can communicate with the
	// peer VPC over the VPC peering connection.
	AllowEgressFromLocalClassicLinkToRemoteVpc *bool `locationName:"allowEgressFromLocalClassicLinkToRemoteVpc" type:"boolean"`

	// Indicates whether a local VPC can communicate with a ClassicLink connection
	// in the peer VPC over the VPC peering connection.
	AllowEgressFromLocalVpcToRemoteClassicLink *bool `locationName:"allowEgressFromLocalVpcToRemoteClassicLink" type:"boolean"`
}

// String returns the string representation
func (s VpcPeeringConnectionOptionsDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a VPC peering connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcPeeringConnectionStateReason
type VpcPeeringConnectionStateReason struct {
	_ struct{} `type:"structure"`

	// The status of the VPC peering connection.
	Code VpcPeeringConnectionStateReasonCode `locationName:"code" type:"string" enum:"true"`

	// A message that provides more information about the status, if applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnectionStateReason) String() string {
	return awsutil.Prettify(s)
}

// Describes a VPC in a VPC peering connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpcPeeringConnectionVpcInfo
type VpcPeeringConnectionVpcInfo struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR block for the VPC.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Information about the IPv4 CIDR blocks for the VPC.
	CidrBlockSet []CidrBlock `locationName:"cidrBlockSet" locationNameList:"item" type:"list"`

	// The IPv6 CIDR block for the VPC.
	Ipv6CidrBlockSet []Ipv6CidrBlock `locationName:"ipv6CidrBlockSet" locationNameList:"item" type:"list"`

	// The AWS account ID of the VPC owner.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Information about the VPC peering connection options for the accepter or
	// requester VPC.
	PeeringOptions *VpcPeeringConnectionOptionsDescription `locationName:"peeringOptions" type:"structure"`

	// The Region in which the VPC is located.
	Region *string `locationName:"region" type:"string"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnectionVpcInfo) String() string {
	return awsutil.Prettify(s)
}

// Describes the authentication methods used by a Client VPN endpoint. Client
// VPN supports Active Directory and mutual authentication. For more information,
// see Authentication (https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication)
// in the AWS Client VPN Administrator Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthentication
type VpnAuthentication struct {
	_ struct{} `type:"structure"`

	// Information about the Active Directory, if applicable.
	ActiveDirectory *DirectoryServiceAuthentication `locationName:"activeDirectory" type:"structure"`

	// Information about the authentication certificates, if applicable.
	MutualAuthentication *CertificateAuthentication `locationName:"mutualAuthentication" type:"structure"`

	// The authentication type used.
	Type VpnAuthenticationType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s VpnAuthentication) String() string {
	return awsutil.Prettify(s)
}

// Describes the authentication method to be used by a Client VPN endpoint.
// Client VPN supports Active Directory and mutual authentication. For more
// information, see Authentication (https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication)
// in the AWS Client VPN Administrator Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthenticationRequest
type VpnAuthenticationRequest struct {
	_ struct{} `type:"structure"`

	// Information about the Active Directory to be used, if applicable. You must
	// provide this information if Type is directory-service-authentication.
	ActiveDirectory *DirectoryServiceAuthenticationRequest `type:"structure"`

	// Information about the authentication certificates to be used, if applicable.
	// You must provide this information if Type is certificate-authentication.
	MutualAuthentication *CertificateAuthenticationRequest `type:"structure"`

	// The type of client authentication to be used. Specify certificate-authentication
	// to use certificate-based authentication, or directory-service-authentication
	// to use Active Directory authentication.
	Type VpnAuthenticationType `type:"string" enum:"true"`
}

// String returns the string representation
func (s VpnAuthenticationRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of an authorization rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthorizationRuleStatus
type VpnAuthorizationRuleStatus struct {
	_ struct{} `type:"structure"`

	// The state of the authorization rule.
	Code VpnAuthorizationRuleStatusCode `locationName:"code" type:"string" enum:"true"`

	// A message about the status of the authorization rule, if applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s VpnAuthorizationRuleStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a client connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnConnection
type VpnConnection struct {
	_ struct{} `type:"structure"`

	// The IP address of the client.
	ClientIp *string `locationName:"clientIp" type:"string"`

	// The ID of the Client VPN endpoint to which the client is connected.
	ClientVpnEndpointId *string `locationName:"clientVpnEndpointId" type:"string"`

	// The common name associated with the client. This is either the name of the
	// client certificate, or the Active Directory user name.
	CommonName *string `locationName:"commonName" type:"string"`

	// The date and time the client connection was terminated.
	ConnectionEndTime *string `locationName:"connectionEndTime" type:"string"`

	// The date and time the client connection was established.
	ConnectionEstablishedTime *string `locationName:"connectionEstablishedTime" type:"string"`

	// The ID of the client connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The number of bytes received by the client.
	EgressBytes *string `locationName:"egressBytes" type:"string"`

	// The number of packets received by the client.
	EgressPackets *string `locationName:"egressPackets" type:"string"`

	// The number of bytes sent by the client.
	IngressBytes *string `locationName:"ingressBytes" type:"string"`

	// The number of packets sent by the client.
	IngressPackets *string `locationName:"ingressPackets" type:"string"`

	// The current state of the client connection.
	Status *VpnConnectionStatus `locationName:"status" type:"structure"`

	// The current date and time.
	Timestamp *string `locationName:"timestamp" type:"string"`

	// The username of the client who established the client connection. This information
	// is only provided if Active Directory client authentication is used.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s VpnConnection) String() string {
	return awsutil.Prettify(s)
}

// Describes VPN connection options.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpnConnectionOptions
type VpnConnectionOptions struct {
	_ struct{} `type:"structure"`

	// Indicates whether the VPN connection uses static routes only. Static routes
	// must be used for devices that don't support BGP.
	StaticRoutesOnly *bool `locationName:"staticRoutesOnly" type:"boolean"`
}

// String returns the string representation
func (s VpnConnectionOptions) String() string {
	return awsutil.Prettify(s)
}

// Describes VPN connection options.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpnConnectionOptionsSpecification
type VpnConnectionOptionsSpecification struct {
	_ struct{} `type:"structure"`

	// Indicate whether the VPN connection uses static routes only. If you are creating
	// a VPN connection for a device that does not support BGP, you must specify
	// true. Use CreateVpnConnectionRoute to create a static route.
	//
	// Default: false
	StaticRoutesOnly *bool `locationName:"staticRoutesOnly" type:"boolean"`

	// The tunnel options for the VPN connection.
	TunnelOptions []VpnTunnelOptionsSpecification `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s VpnConnectionOptionsSpecification) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of a client connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnConnectionStatus
type VpnConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The state of the client connection.
	Code VpnConnectionStatusCode `locationName:"code" type:"string" enum:"true"`

	// A message about the status of the client connection, if applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s VpnConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a Client VPN endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpoint
type VpnEndpoint struct {
	_ struct{} `type:"structure"`

	// Information about the associated target networks. A target network is a subnet
	// in a VPC.
	AssociatedTargetNetworks []AssociatedTargetNetwork `locationName:"associatedTargetNetwork" locationNameList:"item" deprecated:"true" type:"list"`

	// Information about the authentication method used by the Client VPN endpoint.
	AuthenticationOptions []VpnAuthentication `locationName:"authenticationOptions" locationNameList:"item" type:"list"`

	// The IPv4 address range, in CIDR notation, from which client IP addresses
	// are assigned.
	ClientCidrBlock *string `locationName:"clientCidrBlock" type:"string"`

	// The ID of the Client VPN endpoint.
	ClientVpnEndpointId *string `locationName:"clientVpnEndpointId" type:"string"`

	// Information about the client connection logging options for the Client VPN
	// endpoint.
	ConnectionLogOptions *ConnectionLogResponseOptions `locationName:"connectionLogOptions" type:"structure"`

	// The date and time the Client VPN endpoint was created.
	CreationTime *string `locationName:"creationTime" type:"string"`

	// The date and time the Client VPN endpoint was deleted, if applicable.
	DeletionTime *string `locationName:"deletionTime" type:"string"`

	// A brief description of the endpoint.
	Description *string `locationName:"description" type:"string"`

	// The DNS name to be used by clients when connecting to the Client VPN endpoint.
	DnsName *string `locationName:"dnsName" type:"string"`

	// Information about the DNS servers to be used for DNS resolution.
	DnsServers []string `locationName:"dnsServer" locationNameList:"item" type:"list"`

	// The ARN of the server certificate.
	ServerCertificateArn *string `locationName:"serverCertificateArn" type:"string"`

	// Indicates whether VPN split tunneling is supported.
	SplitTunnel *bool `locationName:"splitTunnel" type:"boolean"`

	// The current state of the Client VPN endpoint.
	Status *VpnEndpointStatus `locationName:"status" type:"structure"`

	// Any tags assigned to the Client VPN endpoint.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The transport protocol used by the Client VPN endpoint.
	TransportProtocol TransportProtocol `locationName:"transportProtocol" type:"string" enum:"true"`

	// The protocol used by the VPN session.
	VpnProtocol VpnProtocol `locationName:"vpnProtocol" type:"string" enum:"true"`
}

// String returns the string representation
func (s VpnEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a Client VPN endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpointStatus
type VpnEndpointStatus struct {
	_ struct{} `type:"structure"`

	// The state of the Client VPN endpoint. Possible states include:
	//
	//    * pending-associate - The Client VPN endpoint has been created but no
	//    target networks have been associated. The Client VPN endpoint cannot accept
	//    connections.
	//
	//    * available - The Client VPN endpoint has been created and a target network
	//    has been associated. The Client VPN endpoint can accept connections.
	//
	//    * deleting - The Client VPN endpoint is being deleted. The Client VPN
	//    endpoint cannot accept connections.
	//
	//    * deleted - The Client VPN endpoint has been deleted. The Client VPN endpoint
	//    cannot accept connections.
	Code VpnEndpointStatusCode `locationName:"code" type:"string" enum:"true"`

	// A message about the status of the Client VPN endpoint.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s VpnEndpointStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a virtual private gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpnGateway
type VpnGateway struct {
	_ struct{} `type:"structure"`

	// The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The Availability Zone where the virtual private gateway was created, if applicable.
	// This field may be empty or not returned.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The current state of the virtual private gateway.
	State VpnState `locationName:"state" type:"string" enum:"true"`

	// Any tags assigned to the virtual private gateway.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of VPN connection the virtual private gateway supports.
	Type GatewayType `locationName:"type" type:"string" enum:"true"`

	// Any VPCs attached to the virtual private gateway.
	VpcAttachments []VpcAttachment `locationName:"attachments" locationNameList:"item" type:"list"`

	// The ID of the virtual private gateway.
	VpnGatewayId *string `locationName:"vpnGatewayId" type:"string"`
}

// String returns the string representation
func (s VpnGateway) String() string {
	return awsutil.Prettify(s)
}

// Information about a Client VPN endpoint route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnRoute
type VpnRoute struct {
	_ struct{} `type:"structure"`

	// The ID of the Client VPN endpoint with which the route is associated.
	ClientVpnEndpointId *string `locationName:"clientVpnEndpointId" type:"string"`

	// A brief description of the route.
	Description *string `locationName:"description" type:"string"`

	// The IPv4 address range, in CIDR notation, of the route destination.
	DestinationCidr *string `locationName:"destinationCidr" type:"string"`

	// Indicates how the route was associated with the Client VPN endpoint. associate
	// indicates that the route was automatically added when the target network
	// was associated with the Client VPN endpoint. add-route indicates that the
	// route was manually added using the CreateClientVpnRoute action.
	Origin *string `locationName:"origin" type:"string"`

	// The current state of the route.
	Status *VpnRouteStatus `locationName:"status" type:"structure"`

	// The ID of the subnet through which traffic is routed.
	TargetSubnet *string `locationName:"targetSubnet" type:"string"`

	// The route type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s VpnRoute) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a Client VPN endpoint route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnRouteStatus
type VpnRouteStatus struct {
	_ struct{} `type:"structure"`

	// The state of the Client VPN endpoint route.
	Code VpnRouteStatusCode `locationName:"code" type:"string" enum:"true"`

	// A message about the status of the Client VPN endpoint route, if applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s VpnRouteStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a static route for a VPN connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpnStaticRoute
type VpnStaticRoute struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer data center.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// Indicates how the routes were provided.
	Source VpnStaticRouteSource `locationName:"source" type:"string" enum:"true"`

	// The current state of the static route.
	State VpnState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s VpnStaticRoute) String() string {
	return awsutil.Prettify(s)
}

// The tunnel options for a VPN connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/VpnTunnelOptionsSpecification
type VpnTunnelOptionsSpecification struct {
	_ struct{} `type:"structure"`

	// The pre-shared key (PSK) to establish initial authentication between the
	// virtual private gateway and customer gateway.
	//
	// Constraints: Allowed characters are alphanumeric characters and ._. Must
	// be between 8 and 64 characters in length and cannot start with zero (0).
	PreSharedKey *string `type:"string"`

	// The range of inside IP addresses for the tunnel. Any specified CIDR blocks
	// must be unique across all VPN connections that use the same virtual private
	// gateway.
	//
	// Constraints: A size /30 CIDR block from the 169.254.0.0/16 range. The following
	// CIDR blocks are reserved and cannot be used:
	//
	//    * 169.254.0.0/30
	//
	//    * 169.254.1.0/30
	//
	//    * 169.254.2.0/30
	//
	//    * 169.254.3.0/30
	//
	//    * 169.254.4.0/30
	//
	//    * 169.254.5.0/30
	//
	//    * 169.254.169.252/30
	TunnelInsideCidr *string `type:"string"`
}

// String returns the string representation
func (s VpnTunnelOptionsSpecification) String() string {
	return awsutil.Prettify(s)
}
