// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ec2iface provides an interface to enable mocking the Amazon Elastic Compute Cloud service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ec2iface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/ec2"
)

// ClientAPI provides an interface to enable mocking the
// ec2.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon EC2.
//    func myFunc(svc ec2iface.ClientAPI) bool {
//        // Make svc.AcceptReservedInstancesExchangeQuote request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := ec2.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        ec2iface.ClientPI
//    }
//    func (m *mockClientClient) AcceptReservedInstancesExchangeQuote(input *ec2.AcceptReservedInstancesExchangeQuoteInput) (*ec2.AcceptReservedInstancesExchangeQuoteOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AcceptReservedInstancesExchangeQuoteRequest(*ec2.AcceptReservedInstancesExchangeQuoteInput) ec2.AcceptReservedInstancesExchangeQuoteRequest

	AcceptTransitGatewayVpcAttachmentRequest(*ec2.AcceptTransitGatewayVpcAttachmentInput) ec2.AcceptTransitGatewayVpcAttachmentRequest

	AcceptVpcEndpointConnectionsRequest(*ec2.AcceptVpcEndpointConnectionsInput) ec2.AcceptVpcEndpointConnectionsRequest

	AcceptVpcPeeringConnectionRequest(*ec2.AcceptVpcPeeringConnectionInput) ec2.AcceptVpcPeeringConnectionRequest

	AdvertiseByoipCidrRequest(*ec2.AdvertiseByoipCidrInput) ec2.AdvertiseByoipCidrRequest

	AllocateAddressRequest(*ec2.AllocateAddressInput) ec2.AllocateAddressRequest

	AllocateHostsRequest(*ec2.AllocateHostsInput) ec2.AllocateHostsRequest

	ApplySecurityGroupsToClientVpnTargetNetworkRequest(*ec2.ApplySecurityGroupsToClientVpnTargetNetworkInput) ec2.ApplySecurityGroupsToClientVpnTargetNetworkRequest

	AssignIpv6AddressesRequest(*ec2.AssignIpv6AddressesInput) ec2.AssignIpv6AddressesRequest

	AssignPrivateIpAddressesRequest(*ec2.AssignPrivateIpAddressesInput) ec2.AssignPrivateIpAddressesRequest

	AssociateAddressRequest(*ec2.AssociateAddressInput) ec2.AssociateAddressRequest

	AssociateClientVpnTargetNetworkRequest(*ec2.AssociateClientVpnTargetNetworkInput) ec2.AssociateClientVpnTargetNetworkRequest

	AssociateDhcpOptionsRequest(*ec2.AssociateDhcpOptionsInput) ec2.AssociateDhcpOptionsRequest

	AssociateIamInstanceProfileRequest(*ec2.AssociateIamInstanceProfileInput) ec2.AssociateIamInstanceProfileRequest

	AssociateRouteTableRequest(*ec2.AssociateRouteTableInput) ec2.AssociateRouteTableRequest

	AssociateSubnetCidrBlockRequest(*ec2.AssociateSubnetCidrBlockInput) ec2.AssociateSubnetCidrBlockRequest

	AssociateTransitGatewayRouteTableRequest(*ec2.AssociateTransitGatewayRouteTableInput) ec2.AssociateTransitGatewayRouteTableRequest

	AssociateVpcCidrBlockRequest(*ec2.AssociateVpcCidrBlockInput) ec2.AssociateVpcCidrBlockRequest

	AttachClassicLinkVpcRequest(*ec2.AttachClassicLinkVpcInput) ec2.AttachClassicLinkVpcRequest

	AttachInternetGatewayRequest(*ec2.AttachInternetGatewayInput) ec2.AttachInternetGatewayRequest

	AttachNetworkInterfaceRequest(*ec2.AttachNetworkInterfaceInput) ec2.AttachNetworkInterfaceRequest

	AttachVolumeRequest(*ec2.AttachVolumeInput) ec2.AttachVolumeRequest

	AttachVpnGatewayRequest(*ec2.AttachVpnGatewayInput) ec2.AttachVpnGatewayRequest

	AuthorizeClientVpnIngressRequest(*ec2.AuthorizeClientVpnIngressInput) ec2.AuthorizeClientVpnIngressRequest

	AuthorizeSecurityGroupEgressRequest(*ec2.AuthorizeSecurityGroupEgressInput) ec2.AuthorizeSecurityGroupEgressRequest

	AuthorizeSecurityGroupIngressRequest(*ec2.AuthorizeSecurityGroupIngressInput) ec2.AuthorizeSecurityGroupIngressRequest

	BundleInstanceRequest(*ec2.BundleInstanceInput) ec2.BundleInstanceRequest

	CancelBundleTaskRequest(*ec2.CancelBundleTaskInput) ec2.CancelBundleTaskRequest

	CancelCapacityReservationRequest(*ec2.CancelCapacityReservationInput) ec2.CancelCapacityReservationRequest

	CancelConversionTaskRequest(*ec2.CancelConversionTaskInput) ec2.CancelConversionTaskRequest

	CancelExportTaskRequest(*ec2.CancelExportTaskInput) ec2.CancelExportTaskRequest

	CancelImportTaskRequest(*ec2.CancelImportTaskInput) ec2.CancelImportTaskRequest

	CancelReservedInstancesListingRequest(*ec2.CancelReservedInstancesListingInput) ec2.CancelReservedInstancesListingRequest

	CancelSpotFleetRequestsRequest(*ec2.CancelSpotFleetRequestsInput) ec2.CancelSpotFleetRequestsRequest

	CancelSpotInstanceRequestsRequest(*ec2.CancelSpotInstanceRequestsInput) ec2.CancelSpotInstanceRequestsRequest

	ConfirmProductInstanceRequest(*ec2.ConfirmProductInstanceInput) ec2.ConfirmProductInstanceRequest

	CopyFpgaImageRequest(*ec2.CopyFpgaImageInput) ec2.CopyFpgaImageRequest

	CopyImageRequest(*ec2.CopyImageInput) ec2.CopyImageRequest

	CopySnapshotRequest(*ec2.CopySnapshotInput) ec2.CopySnapshotRequest

	CreateCapacityReservationRequest(*ec2.CreateCapacityReservationInput) ec2.CreateCapacityReservationRequest

	CreateClientVpnEndpointRequest(*ec2.CreateClientVpnEndpointInput) ec2.CreateClientVpnEndpointRequest

	CreateClientVpnRouteRequest(*ec2.CreateClientVpnRouteInput) ec2.CreateClientVpnRouteRequest

	CreateCustomerGatewayRequest(*ec2.CreateCustomerGatewayInput) ec2.CreateCustomerGatewayRequest

	CreateDefaultSubnetRequest(*ec2.CreateDefaultSubnetInput) ec2.CreateDefaultSubnetRequest

	CreateDefaultVpcRequest(*ec2.CreateDefaultVpcInput) ec2.CreateDefaultVpcRequest

	CreateDhcpOptionsRequest(*ec2.CreateDhcpOptionsInput) ec2.CreateDhcpOptionsRequest

	CreateEgressOnlyInternetGatewayRequest(*ec2.CreateEgressOnlyInternetGatewayInput) ec2.CreateEgressOnlyInternetGatewayRequest

	CreateFleetRequest(*ec2.CreateFleetInput) ec2.CreateFleetRequest

	CreateFlowLogsRequest(*ec2.CreateFlowLogsInput) ec2.CreateFlowLogsRequest

	CreateFpgaImageRequest(*ec2.CreateFpgaImageInput) ec2.CreateFpgaImageRequest

	CreateImageRequest(*ec2.CreateImageInput) ec2.CreateImageRequest

	CreateInstanceExportTaskRequest(*ec2.CreateInstanceExportTaskInput) ec2.CreateInstanceExportTaskRequest

	CreateInternetGatewayRequest(*ec2.CreateInternetGatewayInput) ec2.CreateInternetGatewayRequest

	CreateKeyPairRequest(*ec2.CreateKeyPairInput) ec2.CreateKeyPairRequest

	CreateLaunchTemplateRequest(*ec2.CreateLaunchTemplateInput) ec2.CreateLaunchTemplateRequest

	CreateLaunchTemplateVersionRequest(*ec2.CreateLaunchTemplateVersionInput) ec2.CreateLaunchTemplateVersionRequest

	CreateNatGatewayRequest(*ec2.CreateNatGatewayInput) ec2.CreateNatGatewayRequest

	CreateNetworkAclRequest(*ec2.CreateNetworkAclInput) ec2.CreateNetworkAclRequest

	CreateNetworkAclEntryRequest(*ec2.CreateNetworkAclEntryInput) ec2.CreateNetworkAclEntryRequest

	CreateNetworkInterfaceRequest(*ec2.CreateNetworkInterfaceInput) ec2.CreateNetworkInterfaceRequest

	CreateNetworkInterfacePermissionRequest(*ec2.CreateNetworkInterfacePermissionInput) ec2.CreateNetworkInterfacePermissionRequest

	CreatePlacementGroupRequest(*ec2.CreatePlacementGroupInput) ec2.CreatePlacementGroupRequest

	CreateReservedInstancesListingRequest(*ec2.CreateReservedInstancesListingInput) ec2.CreateReservedInstancesListingRequest

	CreateRouteRequest(*ec2.CreateRouteInput) ec2.CreateRouteRequest

	CreateRouteTableRequest(*ec2.CreateRouteTableInput) ec2.CreateRouteTableRequest

	CreateSecurityGroupRequest(*ec2.CreateSecurityGroupInput) ec2.CreateSecurityGroupRequest

	CreateSnapshotRequest(*ec2.CreateSnapshotInput) ec2.CreateSnapshotRequest

	CreateSpotDatafeedSubscriptionRequest(*ec2.CreateSpotDatafeedSubscriptionInput) ec2.CreateSpotDatafeedSubscriptionRequest

	CreateSubnetRequest(*ec2.CreateSubnetInput) ec2.CreateSubnetRequest

	CreateTagsRequest(*ec2.CreateTagsInput) ec2.CreateTagsRequest

	CreateTransitGatewayRequest(*ec2.CreateTransitGatewayInput) ec2.CreateTransitGatewayRequest

	CreateTransitGatewayRouteRequest(*ec2.CreateTransitGatewayRouteInput) ec2.CreateTransitGatewayRouteRequest

	CreateTransitGatewayRouteTableRequest(*ec2.CreateTransitGatewayRouteTableInput) ec2.CreateTransitGatewayRouteTableRequest

	CreateTransitGatewayVpcAttachmentRequest(*ec2.CreateTransitGatewayVpcAttachmentInput) ec2.CreateTransitGatewayVpcAttachmentRequest

	CreateVolumeRequest(*ec2.CreateVolumeInput) ec2.CreateVolumeRequest

	CreateVpcRequest(*ec2.CreateVpcInput) ec2.CreateVpcRequest

	CreateVpcEndpointRequest(*ec2.CreateVpcEndpointInput) ec2.CreateVpcEndpointRequest

	CreateVpcEndpointConnectionNotificationRequest(*ec2.CreateVpcEndpointConnectionNotificationInput) ec2.CreateVpcEndpointConnectionNotificationRequest

	CreateVpcEndpointServiceConfigurationRequest(*ec2.CreateVpcEndpointServiceConfigurationInput) ec2.CreateVpcEndpointServiceConfigurationRequest

	CreateVpcPeeringConnectionRequest(*ec2.CreateVpcPeeringConnectionInput) ec2.CreateVpcPeeringConnectionRequest

	CreateVpnConnectionRequest(*ec2.CreateVpnConnectionInput) ec2.CreateVpnConnectionRequest

	CreateVpnConnectionRouteRequest(*ec2.CreateVpnConnectionRouteInput) ec2.CreateVpnConnectionRouteRequest

	CreateVpnGatewayRequest(*ec2.CreateVpnGatewayInput) ec2.CreateVpnGatewayRequest

	DeleteClientVpnEndpointRequest(*ec2.DeleteClientVpnEndpointInput) ec2.DeleteClientVpnEndpointRequest

	DeleteClientVpnRouteRequest(*ec2.DeleteClientVpnRouteInput) ec2.DeleteClientVpnRouteRequest

	DeleteCustomerGatewayRequest(*ec2.DeleteCustomerGatewayInput) ec2.DeleteCustomerGatewayRequest

	DeleteDhcpOptionsRequest(*ec2.DeleteDhcpOptionsInput) ec2.DeleteDhcpOptionsRequest

	DeleteEgressOnlyInternetGatewayRequest(*ec2.DeleteEgressOnlyInternetGatewayInput) ec2.DeleteEgressOnlyInternetGatewayRequest

	DeleteFleetsRequest(*ec2.DeleteFleetsInput) ec2.DeleteFleetsRequest

	DeleteFlowLogsRequest(*ec2.DeleteFlowLogsInput) ec2.DeleteFlowLogsRequest

	DeleteFpgaImageRequest(*ec2.DeleteFpgaImageInput) ec2.DeleteFpgaImageRequest

	DeleteInternetGatewayRequest(*ec2.DeleteInternetGatewayInput) ec2.DeleteInternetGatewayRequest

	DeleteKeyPairRequest(*ec2.DeleteKeyPairInput) ec2.DeleteKeyPairRequest

	DeleteLaunchTemplateRequest(*ec2.DeleteLaunchTemplateInput) ec2.DeleteLaunchTemplateRequest

	DeleteLaunchTemplateVersionsRequest(*ec2.DeleteLaunchTemplateVersionsInput) ec2.DeleteLaunchTemplateVersionsRequest

	DeleteNatGatewayRequest(*ec2.DeleteNatGatewayInput) ec2.DeleteNatGatewayRequest

	DeleteNetworkAclRequest(*ec2.DeleteNetworkAclInput) ec2.DeleteNetworkAclRequest

	DeleteNetworkAclEntryRequest(*ec2.DeleteNetworkAclEntryInput) ec2.DeleteNetworkAclEntryRequest

	DeleteNetworkInterfaceRequest(*ec2.DeleteNetworkInterfaceInput) ec2.DeleteNetworkInterfaceRequest

	DeleteNetworkInterfacePermissionRequest(*ec2.DeleteNetworkInterfacePermissionInput) ec2.DeleteNetworkInterfacePermissionRequest

	DeletePlacementGroupRequest(*ec2.DeletePlacementGroupInput) ec2.DeletePlacementGroupRequest

	DeleteRouteRequest(*ec2.DeleteRouteInput) ec2.DeleteRouteRequest

	DeleteRouteTableRequest(*ec2.DeleteRouteTableInput) ec2.DeleteRouteTableRequest

	DeleteSecurityGroupRequest(*ec2.DeleteSecurityGroupInput) ec2.DeleteSecurityGroupRequest

	DeleteSnapshotRequest(*ec2.DeleteSnapshotInput) ec2.DeleteSnapshotRequest

	DeleteSpotDatafeedSubscriptionRequest(*ec2.DeleteSpotDatafeedSubscriptionInput) ec2.DeleteSpotDatafeedSubscriptionRequest

	DeleteSubnetRequest(*ec2.DeleteSubnetInput) ec2.DeleteSubnetRequest

	DeleteTagsRequest(*ec2.DeleteTagsInput) ec2.DeleteTagsRequest

	DeleteTransitGatewayRequest(*ec2.DeleteTransitGatewayInput) ec2.DeleteTransitGatewayRequest

	DeleteTransitGatewayRouteRequest(*ec2.DeleteTransitGatewayRouteInput) ec2.DeleteTransitGatewayRouteRequest

	DeleteTransitGatewayRouteTableRequest(*ec2.DeleteTransitGatewayRouteTableInput) ec2.DeleteTransitGatewayRouteTableRequest

	DeleteTransitGatewayVpcAttachmentRequest(*ec2.DeleteTransitGatewayVpcAttachmentInput) ec2.DeleteTransitGatewayVpcAttachmentRequest

	DeleteVolumeRequest(*ec2.DeleteVolumeInput) ec2.DeleteVolumeRequest

	DeleteVpcRequest(*ec2.DeleteVpcInput) ec2.DeleteVpcRequest

	DeleteVpcEndpointConnectionNotificationsRequest(*ec2.DeleteVpcEndpointConnectionNotificationsInput) ec2.DeleteVpcEndpointConnectionNotificationsRequest

	DeleteVpcEndpointServiceConfigurationsRequest(*ec2.DeleteVpcEndpointServiceConfigurationsInput) ec2.DeleteVpcEndpointServiceConfigurationsRequest

	DeleteVpcEndpointsRequest(*ec2.DeleteVpcEndpointsInput) ec2.DeleteVpcEndpointsRequest

	DeleteVpcPeeringConnectionRequest(*ec2.DeleteVpcPeeringConnectionInput) ec2.DeleteVpcPeeringConnectionRequest

	DeleteVpnConnectionRequest(*ec2.DeleteVpnConnectionInput) ec2.DeleteVpnConnectionRequest

	DeleteVpnConnectionRouteRequest(*ec2.DeleteVpnConnectionRouteInput) ec2.DeleteVpnConnectionRouteRequest

	DeleteVpnGatewayRequest(*ec2.DeleteVpnGatewayInput) ec2.DeleteVpnGatewayRequest

	DeprovisionByoipCidrRequest(*ec2.DeprovisionByoipCidrInput) ec2.DeprovisionByoipCidrRequest

	DeregisterImageRequest(*ec2.DeregisterImageInput) ec2.DeregisterImageRequest

	DescribeAccountAttributesRequest(*ec2.DescribeAccountAttributesInput) ec2.DescribeAccountAttributesRequest

	DescribeAddressesRequest(*ec2.DescribeAddressesInput) ec2.DescribeAddressesRequest

	DescribeAggregateIdFormatRequest(*ec2.DescribeAggregateIdFormatInput) ec2.DescribeAggregateIdFormatRequest

	DescribeAvailabilityZonesRequest(*ec2.DescribeAvailabilityZonesInput) ec2.DescribeAvailabilityZonesRequest

	DescribeBundleTasksRequest(*ec2.DescribeBundleTasksInput) ec2.DescribeBundleTasksRequest

	DescribeByoipCidrsRequest(*ec2.DescribeByoipCidrsInput) ec2.DescribeByoipCidrsRequest

	DescribeCapacityReservationsRequest(*ec2.DescribeCapacityReservationsInput) ec2.DescribeCapacityReservationsRequest

	DescribeClassicLinkInstancesRequest(*ec2.DescribeClassicLinkInstancesInput) ec2.DescribeClassicLinkInstancesRequest

	DescribeClientVpnAuthorizationRulesRequest(*ec2.DescribeClientVpnAuthorizationRulesInput) ec2.DescribeClientVpnAuthorizationRulesRequest

	DescribeClientVpnConnectionsRequest(*ec2.DescribeClientVpnConnectionsInput) ec2.DescribeClientVpnConnectionsRequest

	DescribeClientVpnEndpointsRequest(*ec2.DescribeClientVpnEndpointsInput) ec2.DescribeClientVpnEndpointsRequest

	DescribeClientVpnRoutesRequest(*ec2.DescribeClientVpnRoutesInput) ec2.DescribeClientVpnRoutesRequest

	DescribeClientVpnTargetNetworksRequest(*ec2.DescribeClientVpnTargetNetworksInput) ec2.DescribeClientVpnTargetNetworksRequest

	DescribeConversionTasksRequest(*ec2.DescribeConversionTasksInput) ec2.DescribeConversionTasksRequest

	DescribeCustomerGatewaysRequest(*ec2.DescribeCustomerGatewaysInput) ec2.DescribeCustomerGatewaysRequest

	DescribeDhcpOptionsRequest(*ec2.DescribeDhcpOptionsInput) ec2.DescribeDhcpOptionsRequest

	DescribeEgressOnlyInternetGatewaysRequest(*ec2.DescribeEgressOnlyInternetGatewaysInput) ec2.DescribeEgressOnlyInternetGatewaysRequest

	DescribeElasticGpusRequest(*ec2.DescribeElasticGpusInput) ec2.DescribeElasticGpusRequest

	DescribeExportTasksRequest(*ec2.DescribeExportTasksInput) ec2.DescribeExportTasksRequest

	DescribeFleetHistoryRequest(*ec2.DescribeFleetHistoryInput) ec2.DescribeFleetHistoryRequest

	DescribeFleetInstancesRequest(*ec2.DescribeFleetInstancesInput) ec2.DescribeFleetInstancesRequest

	DescribeFleetsRequest(*ec2.DescribeFleetsInput) ec2.DescribeFleetsRequest

	DescribeFlowLogsRequest(*ec2.DescribeFlowLogsInput) ec2.DescribeFlowLogsRequest

	DescribeFpgaImageAttributeRequest(*ec2.DescribeFpgaImageAttributeInput) ec2.DescribeFpgaImageAttributeRequest

	DescribeFpgaImagesRequest(*ec2.DescribeFpgaImagesInput) ec2.DescribeFpgaImagesRequest

	DescribeHostReservationOfferingsRequest(*ec2.DescribeHostReservationOfferingsInput) ec2.DescribeHostReservationOfferingsRequest

	DescribeHostReservationsRequest(*ec2.DescribeHostReservationsInput) ec2.DescribeHostReservationsRequest

	DescribeHostsRequest(*ec2.DescribeHostsInput) ec2.DescribeHostsRequest

	DescribeIamInstanceProfileAssociationsRequest(*ec2.DescribeIamInstanceProfileAssociationsInput) ec2.DescribeIamInstanceProfileAssociationsRequest

	DescribeIdFormatRequest(*ec2.DescribeIdFormatInput) ec2.DescribeIdFormatRequest

	DescribeIdentityIdFormatRequest(*ec2.DescribeIdentityIdFormatInput) ec2.DescribeIdentityIdFormatRequest

	DescribeImageAttributeRequest(*ec2.DescribeImageAttributeInput) ec2.DescribeImageAttributeRequest

	DescribeImagesRequest(*ec2.DescribeImagesInput) ec2.DescribeImagesRequest

	DescribeImportImageTasksRequest(*ec2.DescribeImportImageTasksInput) ec2.DescribeImportImageTasksRequest

	DescribeImportSnapshotTasksRequest(*ec2.DescribeImportSnapshotTasksInput) ec2.DescribeImportSnapshotTasksRequest

	DescribeInstanceAttributeRequest(*ec2.DescribeInstanceAttributeInput) ec2.DescribeInstanceAttributeRequest

	DescribeInstanceCreditSpecificationsRequest(*ec2.DescribeInstanceCreditSpecificationsInput) ec2.DescribeInstanceCreditSpecificationsRequest

	DescribeInstanceStatusRequest(*ec2.DescribeInstanceStatusInput) ec2.DescribeInstanceStatusRequest

	DescribeInstancesRequest(*ec2.DescribeInstancesInput) ec2.DescribeInstancesRequest

	DescribeInternetGatewaysRequest(*ec2.DescribeInternetGatewaysInput) ec2.DescribeInternetGatewaysRequest

	DescribeKeyPairsRequest(*ec2.DescribeKeyPairsInput) ec2.DescribeKeyPairsRequest

	DescribeLaunchTemplateVersionsRequest(*ec2.DescribeLaunchTemplateVersionsInput) ec2.DescribeLaunchTemplateVersionsRequest

	DescribeLaunchTemplatesRequest(*ec2.DescribeLaunchTemplatesInput) ec2.DescribeLaunchTemplatesRequest

	DescribeMovingAddressesRequest(*ec2.DescribeMovingAddressesInput) ec2.DescribeMovingAddressesRequest

	DescribeNatGatewaysRequest(*ec2.DescribeNatGatewaysInput) ec2.DescribeNatGatewaysRequest

	DescribeNetworkAclsRequest(*ec2.DescribeNetworkAclsInput) ec2.DescribeNetworkAclsRequest

	DescribeNetworkInterfaceAttributeRequest(*ec2.DescribeNetworkInterfaceAttributeInput) ec2.DescribeNetworkInterfaceAttributeRequest

	DescribeNetworkInterfacePermissionsRequest(*ec2.DescribeNetworkInterfacePermissionsInput) ec2.DescribeNetworkInterfacePermissionsRequest

	DescribeNetworkInterfacesRequest(*ec2.DescribeNetworkInterfacesInput) ec2.DescribeNetworkInterfacesRequest

	DescribePlacementGroupsRequest(*ec2.DescribePlacementGroupsInput) ec2.DescribePlacementGroupsRequest

	DescribePrefixListsRequest(*ec2.DescribePrefixListsInput) ec2.DescribePrefixListsRequest

	DescribePrincipalIdFormatRequest(*ec2.DescribePrincipalIdFormatInput) ec2.DescribePrincipalIdFormatRequest

	DescribePublicIpv4PoolsRequest(*ec2.DescribePublicIpv4PoolsInput) ec2.DescribePublicIpv4PoolsRequest

	DescribeRegionsRequest(*ec2.DescribeRegionsInput) ec2.DescribeRegionsRequest

	DescribeReservedInstancesRequest(*ec2.DescribeReservedInstancesInput) ec2.DescribeReservedInstancesRequest

	DescribeReservedInstancesListingsRequest(*ec2.DescribeReservedInstancesListingsInput) ec2.DescribeReservedInstancesListingsRequest

	DescribeReservedInstancesModificationsRequest(*ec2.DescribeReservedInstancesModificationsInput) ec2.DescribeReservedInstancesModificationsRequest

	DescribeReservedInstancesOfferingsRequest(*ec2.DescribeReservedInstancesOfferingsInput) ec2.DescribeReservedInstancesOfferingsRequest

	DescribeRouteTablesRequest(*ec2.DescribeRouteTablesInput) ec2.DescribeRouteTablesRequest

	DescribeScheduledInstanceAvailabilityRequest(*ec2.DescribeScheduledInstanceAvailabilityInput) ec2.DescribeScheduledInstanceAvailabilityRequest

	DescribeScheduledInstancesRequest(*ec2.DescribeScheduledInstancesInput) ec2.DescribeScheduledInstancesRequest

	DescribeSecurityGroupReferencesRequest(*ec2.DescribeSecurityGroupReferencesInput) ec2.DescribeSecurityGroupReferencesRequest

	DescribeSecurityGroupsRequest(*ec2.DescribeSecurityGroupsInput) ec2.DescribeSecurityGroupsRequest

	DescribeSnapshotAttributeRequest(*ec2.DescribeSnapshotAttributeInput) ec2.DescribeSnapshotAttributeRequest

	DescribeSnapshotsRequest(*ec2.DescribeSnapshotsInput) ec2.DescribeSnapshotsRequest

	DescribeSpotDatafeedSubscriptionRequest(*ec2.DescribeSpotDatafeedSubscriptionInput) ec2.DescribeSpotDatafeedSubscriptionRequest

	DescribeSpotFleetInstancesRequest(*ec2.DescribeSpotFleetInstancesInput) ec2.DescribeSpotFleetInstancesRequest

	DescribeSpotFleetRequestHistoryRequest(*ec2.DescribeSpotFleetRequestHistoryInput) ec2.DescribeSpotFleetRequestHistoryRequest

	DescribeSpotFleetRequestsRequest(*ec2.DescribeSpotFleetRequestsInput) ec2.DescribeSpotFleetRequestsRequest

	DescribeSpotInstanceRequestsRequest(*ec2.DescribeSpotInstanceRequestsInput) ec2.DescribeSpotInstanceRequestsRequest

	DescribeSpotPriceHistoryRequest(*ec2.DescribeSpotPriceHistoryInput) ec2.DescribeSpotPriceHistoryRequest

	DescribeStaleSecurityGroupsRequest(*ec2.DescribeStaleSecurityGroupsInput) ec2.DescribeStaleSecurityGroupsRequest

	DescribeSubnetsRequest(*ec2.DescribeSubnetsInput) ec2.DescribeSubnetsRequest

	DescribeTagsRequest(*ec2.DescribeTagsInput) ec2.DescribeTagsRequest

	DescribeTransitGatewayAttachmentsRequest(*ec2.DescribeTransitGatewayAttachmentsInput) ec2.DescribeTransitGatewayAttachmentsRequest

	DescribeTransitGatewayRouteTablesRequest(*ec2.DescribeTransitGatewayRouteTablesInput) ec2.DescribeTransitGatewayRouteTablesRequest

	DescribeTransitGatewayVpcAttachmentsRequest(*ec2.DescribeTransitGatewayVpcAttachmentsInput) ec2.DescribeTransitGatewayVpcAttachmentsRequest

	DescribeTransitGatewaysRequest(*ec2.DescribeTransitGatewaysInput) ec2.DescribeTransitGatewaysRequest

	DescribeVolumeAttributeRequest(*ec2.DescribeVolumeAttributeInput) ec2.DescribeVolumeAttributeRequest

	DescribeVolumeStatusRequest(*ec2.DescribeVolumeStatusInput) ec2.DescribeVolumeStatusRequest

	DescribeVolumesRequest(*ec2.DescribeVolumesInput) ec2.DescribeVolumesRequest

	DescribeVolumesModificationsRequest(*ec2.DescribeVolumesModificationsInput) ec2.DescribeVolumesModificationsRequest

	DescribeVpcAttributeRequest(*ec2.DescribeVpcAttributeInput) ec2.DescribeVpcAttributeRequest

	DescribeVpcClassicLinkRequest(*ec2.DescribeVpcClassicLinkInput) ec2.DescribeVpcClassicLinkRequest

	DescribeVpcClassicLinkDnsSupportRequest(*ec2.DescribeVpcClassicLinkDnsSupportInput) ec2.DescribeVpcClassicLinkDnsSupportRequest

	DescribeVpcEndpointConnectionNotificationsRequest(*ec2.DescribeVpcEndpointConnectionNotificationsInput) ec2.DescribeVpcEndpointConnectionNotificationsRequest

	DescribeVpcEndpointConnectionsRequest(*ec2.DescribeVpcEndpointConnectionsInput) ec2.DescribeVpcEndpointConnectionsRequest

	DescribeVpcEndpointServiceConfigurationsRequest(*ec2.DescribeVpcEndpointServiceConfigurationsInput) ec2.DescribeVpcEndpointServiceConfigurationsRequest

	DescribeVpcEndpointServicePermissionsRequest(*ec2.DescribeVpcEndpointServicePermissionsInput) ec2.DescribeVpcEndpointServicePermissionsRequest

	DescribeVpcEndpointServicesRequest(*ec2.DescribeVpcEndpointServicesInput) ec2.DescribeVpcEndpointServicesRequest

	DescribeVpcEndpointsRequest(*ec2.DescribeVpcEndpointsInput) ec2.DescribeVpcEndpointsRequest

	DescribeVpcPeeringConnectionsRequest(*ec2.DescribeVpcPeeringConnectionsInput) ec2.DescribeVpcPeeringConnectionsRequest

	DescribeVpcsRequest(*ec2.DescribeVpcsInput) ec2.DescribeVpcsRequest

	DescribeVpnConnectionsRequest(*ec2.DescribeVpnConnectionsInput) ec2.DescribeVpnConnectionsRequest

	DescribeVpnGatewaysRequest(*ec2.DescribeVpnGatewaysInput) ec2.DescribeVpnGatewaysRequest

	DetachClassicLinkVpcRequest(*ec2.DetachClassicLinkVpcInput) ec2.DetachClassicLinkVpcRequest

	DetachInternetGatewayRequest(*ec2.DetachInternetGatewayInput) ec2.DetachInternetGatewayRequest

	DetachNetworkInterfaceRequest(*ec2.DetachNetworkInterfaceInput) ec2.DetachNetworkInterfaceRequest

	DetachVolumeRequest(*ec2.DetachVolumeInput) ec2.DetachVolumeRequest

	DetachVpnGatewayRequest(*ec2.DetachVpnGatewayInput) ec2.DetachVpnGatewayRequest

	DisableEbsEncryptionByDefaultRequest(*ec2.DisableEbsEncryptionByDefaultInput) ec2.DisableEbsEncryptionByDefaultRequest

	DisableTransitGatewayRouteTablePropagationRequest(*ec2.DisableTransitGatewayRouteTablePropagationInput) ec2.DisableTransitGatewayRouteTablePropagationRequest

	DisableVgwRoutePropagationRequest(*ec2.DisableVgwRoutePropagationInput) ec2.DisableVgwRoutePropagationRequest

	DisableVpcClassicLinkRequest(*ec2.DisableVpcClassicLinkInput) ec2.DisableVpcClassicLinkRequest

	DisableVpcClassicLinkDnsSupportRequest(*ec2.DisableVpcClassicLinkDnsSupportInput) ec2.DisableVpcClassicLinkDnsSupportRequest

	DisassociateAddressRequest(*ec2.DisassociateAddressInput) ec2.DisassociateAddressRequest

	DisassociateClientVpnTargetNetworkRequest(*ec2.DisassociateClientVpnTargetNetworkInput) ec2.DisassociateClientVpnTargetNetworkRequest

	DisassociateIamInstanceProfileRequest(*ec2.DisassociateIamInstanceProfileInput) ec2.DisassociateIamInstanceProfileRequest

	DisassociateRouteTableRequest(*ec2.DisassociateRouteTableInput) ec2.DisassociateRouteTableRequest

	DisassociateSubnetCidrBlockRequest(*ec2.DisassociateSubnetCidrBlockInput) ec2.DisassociateSubnetCidrBlockRequest

	DisassociateTransitGatewayRouteTableRequest(*ec2.DisassociateTransitGatewayRouteTableInput) ec2.DisassociateTransitGatewayRouteTableRequest

	DisassociateVpcCidrBlockRequest(*ec2.DisassociateVpcCidrBlockInput) ec2.DisassociateVpcCidrBlockRequest

	EnableEbsEncryptionByDefaultRequest(*ec2.EnableEbsEncryptionByDefaultInput) ec2.EnableEbsEncryptionByDefaultRequest

	EnableTransitGatewayRouteTablePropagationRequest(*ec2.EnableTransitGatewayRouteTablePropagationInput) ec2.EnableTransitGatewayRouteTablePropagationRequest

	EnableVgwRoutePropagationRequest(*ec2.EnableVgwRoutePropagationInput) ec2.EnableVgwRoutePropagationRequest

	EnableVolumeIORequest(*ec2.EnableVolumeIOInput) ec2.EnableVolumeIORequest

	EnableVpcClassicLinkRequest(*ec2.EnableVpcClassicLinkInput) ec2.EnableVpcClassicLinkRequest

	EnableVpcClassicLinkDnsSupportRequest(*ec2.EnableVpcClassicLinkDnsSupportInput) ec2.EnableVpcClassicLinkDnsSupportRequest

	ExportClientVpnClientCertificateRevocationListRequest(*ec2.ExportClientVpnClientCertificateRevocationListInput) ec2.ExportClientVpnClientCertificateRevocationListRequest

	ExportClientVpnClientConfigurationRequest(*ec2.ExportClientVpnClientConfigurationInput) ec2.ExportClientVpnClientConfigurationRequest

	ExportTransitGatewayRoutesRequest(*ec2.ExportTransitGatewayRoutesInput) ec2.ExportTransitGatewayRoutesRequest

	GetConsoleOutputRequest(*ec2.GetConsoleOutputInput) ec2.GetConsoleOutputRequest

	GetConsoleScreenshotRequest(*ec2.GetConsoleScreenshotInput) ec2.GetConsoleScreenshotRequest

	GetEbsDefaultKmsKeyIdRequest(*ec2.GetEbsDefaultKmsKeyIdInput) ec2.GetEbsDefaultKmsKeyIdRequest

	GetEbsEncryptionByDefaultRequest(*ec2.GetEbsEncryptionByDefaultInput) ec2.GetEbsEncryptionByDefaultRequest

	GetHostReservationPurchasePreviewRequest(*ec2.GetHostReservationPurchasePreviewInput) ec2.GetHostReservationPurchasePreviewRequest

	GetLaunchTemplateDataRequest(*ec2.GetLaunchTemplateDataInput) ec2.GetLaunchTemplateDataRequest

	GetPasswordDataRequest(*ec2.GetPasswordDataInput) ec2.GetPasswordDataRequest

	GetReservedInstancesExchangeQuoteRequest(*ec2.GetReservedInstancesExchangeQuoteInput) ec2.GetReservedInstancesExchangeQuoteRequest

	GetTransitGatewayAttachmentPropagationsRequest(*ec2.GetTransitGatewayAttachmentPropagationsInput) ec2.GetTransitGatewayAttachmentPropagationsRequest

	GetTransitGatewayRouteTableAssociationsRequest(*ec2.GetTransitGatewayRouteTableAssociationsInput) ec2.GetTransitGatewayRouteTableAssociationsRequest

	GetTransitGatewayRouteTablePropagationsRequest(*ec2.GetTransitGatewayRouteTablePropagationsInput) ec2.GetTransitGatewayRouteTablePropagationsRequest

	ImportClientVpnClientCertificateRevocationListRequest(*ec2.ImportClientVpnClientCertificateRevocationListInput) ec2.ImportClientVpnClientCertificateRevocationListRequest

	ImportImageRequest(*ec2.ImportImageInput) ec2.ImportImageRequest

	ImportInstanceRequest(*ec2.ImportInstanceInput) ec2.ImportInstanceRequest

	ImportKeyPairRequest(*ec2.ImportKeyPairInput) ec2.ImportKeyPairRequest

	ImportSnapshotRequest(*ec2.ImportSnapshotInput) ec2.ImportSnapshotRequest

	ImportVolumeRequest(*ec2.ImportVolumeInput) ec2.ImportVolumeRequest

	ModifyCapacityReservationRequest(*ec2.ModifyCapacityReservationInput) ec2.ModifyCapacityReservationRequest

	ModifyClientVpnEndpointRequest(*ec2.ModifyClientVpnEndpointInput) ec2.ModifyClientVpnEndpointRequest

	ModifyEbsDefaultKmsKeyIdRequest(*ec2.ModifyEbsDefaultKmsKeyIdInput) ec2.ModifyEbsDefaultKmsKeyIdRequest

	ModifyFleetRequest(*ec2.ModifyFleetInput) ec2.ModifyFleetRequest

	ModifyFpgaImageAttributeRequest(*ec2.ModifyFpgaImageAttributeInput) ec2.ModifyFpgaImageAttributeRequest

	ModifyHostsRequest(*ec2.ModifyHostsInput) ec2.ModifyHostsRequest

	ModifyIdFormatRequest(*ec2.ModifyIdFormatInput) ec2.ModifyIdFormatRequest

	ModifyIdentityIdFormatRequest(*ec2.ModifyIdentityIdFormatInput) ec2.ModifyIdentityIdFormatRequest

	ModifyImageAttributeRequest(*ec2.ModifyImageAttributeInput) ec2.ModifyImageAttributeRequest

	ModifyInstanceAttributeRequest(*ec2.ModifyInstanceAttributeInput) ec2.ModifyInstanceAttributeRequest

	ModifyInstanceCapacityReservationAttributesRequest(*ec2.ModifyInstanceCapacityReservationAttributesInput) ec2.ModifyInstanceCapacityReservationAttributesRequest

	ModifyInstanceCreditSpecificationRequest(*ec2.ModifyInstanceCreditSpecificationInput) ec2.ModifyInstanceCreditSpecificationRequest

	ModifyInstanceEventStartTimeRequest(*ec2.ModifyInstanceEventStartTimeInput) ec2.ModifyInstanceEventStartTimeRequest

	ModifyInstancePlacementRequest(*ec2.ModifyInstancePlacementInput) ec2.ModifyInstancePlacementRequest

	ModifyLaunchTemplateRequest(*ec2.ModifyLaunchTemplateInput) ec2.ModifyLaunchTemplateRequest

	ModifyNetworkInterfaceAttributeRequest(*ec2.ModifyNetworkInterfaceAttributeInput) ec2.ModifyNetworkInterfaceAttributeRequest

	ModifyReservedInstancesRequest(*ec2.ModifyReservedInstancesInput) ec2.ModifyReservedInstancesRequest

	ModifySnapshotAttributeRequest(*ec2.ModifySnapshotAttributeInput) ec2.ModifySnapshotAttributeRequest

	ModifySpotFleetRequestRequest(*ec2.ModifySpotFleetRequestInput) ec2.ModifySpotFleetRequestRequest

	ModifySubnetAttributeRequest(*ec2.ModifySubnetAttributeInput) ec2.ModifySubnetAttributeRequest

	ModifyTransitGatewayVpcAttachmentRequest(*ec2.ModifyTransitGatewayVpcAttachmentInput) ec2.ModifyTransitGatewayVpcAttachmentRequest

	ModifyVolumeRequest(*ec2.ModifyVolumeInput) ec2.ModifyVolumeRequest

	ModifyVolumeAttributeRequest(*ec2.ModifyVolumeAttributeInput) ec2.ModifyVolumeAttributeRequest

	ModifyVpcAttributeRequest(*ec2.ModifyVpcAttributeInput) ec2.ModifyVpcAttributeRequest

	ModifyVpcEndpointRequest(*ec2.ModifyVpcEndpointInput) ec2.ModifyVpcEndpointRequest

	ModifyVpcEndpointConnectionNotificationRequest(*ec2.ModifyVpcEndpointConnectionNotificationInput) ec2.ModifyVpcEndpointConnectionNotificationRequest

	ModifyVpcEndpointServiceConfigurationRequest(*ec2.ModifyVpcEndpointServiceConfigurationInput) ec2.ModifyVpcEndpointServiceConfigurationRequest

	ModifyVpcEndpointServicePermissionsRequest(*ec2.ModifyVpcEndpointServicePermissionsInput) ec2.ModifyVpcEndpointServicePermissionsRequest

	ModifyVpcPeeringConnectionOptionsRequest(*ec2.ModifyVpcPeeringConnectionOptionsInput) ec2.ModifyVpcPeeringConnectionOptionsRequest

	ModifyVpcTenancyRequest(*ec2.ModifyVpcTenancyInput) ec2.ModifyVpcTenancyRequest

	ModifyVpnConnectionRequest(*ec2.ModifyVpnConnectionInput) ec2.ModifyVpnConnectionRequest

	MonitorInstancesRequest(*ec2.MonitorInstancesInput) ec2.MonitorInstancesRequest

	MoveAddressToVpcRequest(*ec2.MoveAddressToVpcInput) ec2.MoveAddressToVpcRequest

	ProvisionByoipCidrRequest(*ec2.ProvisionByoipCidrInput) ec2.ProvisionByoipCidrRequest

	PurchaseHostReservationRequest(*ec2.PurchaseHostReservationInput) ec2.PurchaseHostReservationRequest

	PurchaseReservedInstancesOfferingRequest(*ec2.PurchaseReservedInstancesOfferingInput) ec2.PurchaseReservedInstancesOfferingRequest

	PurchaseScheduledInstancesRequest(*ec2.PurchaseScheduledInstancesInput) ec2.PurchaseScheduledInstancesRequest

	RebootInstancesRequest(*ec2.RebootInstancesInput) ec2.RebootInstancesRequest

	RegisterImageRequest(*ec2.RegisterImageInput) ec2.RegisterImageRequest

	RejectTransitGatewayVpcAttachmentRequest(*ec2.RejectTransitGatewayVpcAttachmentInput) ec2.RejectTransitGatewayVpcAttachmentRequest

	RejectVpcEndpointConnectionsRequest(*ec2.RejectVpcEndpointConnectionsInput) ec2.RejectVpcEndpointConnectionsRequest

	RejectVpcPeeringConnectionRequest(*ec2.RejectVpcPeeringConnectionInput) ec2.RejectVpcPeeringConnectionRequest

	ReleaseAddressRequest(*ec2.ReleaseAddressInput) ec2.ReleaseAddressRequest

	ReleaseHostsRequest(*ec2.ReleaseHostsInput) ec2.ReleaseHostsRequest

	ReplaceIamInstanceProfileAssociationRequest(*ec2.ReplaceIamInstanceProfileAssociationInput) ec2.ReplaceIamInstanceProfileAssociationRequest

	ReplaceNetworkAclAssociationRequest(*ec2.ReplaceNetworkAclAssociationInput) ec2.ReplaceNetworkAclAssociationRequest

	ReplaceNetworkAclEntryRequest(*ec2.ReplaceNetworkAclEntryInput) ec2.ReplaceNetworkAclEntryRequest

	ReplaceRouteRequest(*ec2.ReplaceRouteInput) ec2.ReplaceRouteRequest

	ReplaceRouteTableAssociationRequest(*ec2.ReplaceRouteTableAssociationInput) ec2.ReplaceRouteTableAssociationRequest

	ReplaceTransitGatewayRouteRequest(*ec2.ReplaceTransitGatewayRouteInput) ec2.ReplaceTransitGatewayRouteRequest

	ReportInstanceStatusRequest(*ec2.ReportInstanceStatusInput) ec2.ReportInstanceStatusRequest

	RequestSpotFleetRequest(*ec2.RequestSpotFleetInput) ec2.RequestSpotFleetRequest

	RequestSpotInstancesRequest(*ec2.RequestSpotInstancesInput) ec2.RequestSpotInstancesRequest

	ResetEbsDefaultKmsKeyIdRequest(*ec2.ResetEbsDefaultKmsKeyIdInput) ec2.ResetEbsDefaultKmsKeyIdRequest

	ResetFpgaImageAttributeRequest(*ec2.ResetFpgaImageAttributeInput) ec2.ResetFpgaImageAttributeRequest

	ResetImageAttributeRequest(*ec2.ResetImageAttributeInput) ec2.ResetImageAttributeRequest

	ResetInstanceAttributeRequest(*ec2.ResetInstanceAttributeInput) ec2.ResetInstanceAttributeRequest

	ResetNetworkInterfaceAttributeRequest(*ec2.ResetNetworkInterfaceAttributeInput) ec2.ResetNetworkInterfaceAttributeRequest

	ResetSnapshotAttributeRequest(*ec2.ResetSnapshotAttributeInput) ec2.ResetSnapshotAttributeRequest

	RestoreAddressToClassicRequest(*ec2.RestoreAddressToClassicInput) ec2.RestoreAddressToClassicRequest

	RevokeClientVpnIngressRequest(*ec2.RevokeClientVpnIngressInput) ec2.RevokeClientVpnIngressRequest

	RevokeSecurityGroupEgressRequest(*ec2.RevokeSecurityGroupEgressInput) ec2.RevokeSecurityGroupEgressRequest

	RevokeSecurityGroupIngressRequest(*ec2.RevokeSecurityGroupIngressInput) ec2.RevokeSecurityGroupIngressRequest

	RunInstancesRequest(*ec2.RunInstancesInput) ec2.RunInstancesRequest

	RunScheduledInstancesRequest(*ec2.RunScheduledInstancesInput) ec2.RunScheduledInstancesRequest

	SearchTransitGatewayRoutesRequest(*ec2.SearchTransitGatewayRoutesInput) ec2.SearchTransitGatewayRoutesRequest

	StartInstancesRequest(*ec2.StartInstancesInput) ec2.StartInstancesRequest

	StopInstancesRequest(*ec2.StopInstancesInput) ec2.StopInstancesRequest

	TerminateClientVpnConnectionsRequest(*ec2.TerminateClientVpnConnectionsInput) ec2.TerminateClientVpnConnectionsRequest

	TerminateInstancesRequest(*ec2.TerminateInstancesInput) ec2.TerminateInstancesRequest

	UnassignIpv6AddressesRequest(*ec2.UnassignIpv6AddressesInput) ec2.UnassignIpv6AddressesRequest

	UnassignPrivateIpAddressesRequest(*ec2.UnassignPrivateIpAddressesInput) ec2.UnassignPrivateIpAddressesRequest

	UnmonitorInstancesRequest(*ec2.UnmonitorInstancesInput) ec2.UnmonitorInstancesRequest

	UpdateSecurityGroupRuleDescriptionsEgressRequest(*ec2.UpdateSecurityGroupRuleDescriptionsEgressInput) ec2.UpdateSecurityGroupRuleDescriptionsEgressRequest

	UpdateSecurityGroupRuleDescriptionsIngressRequest(*ec2.UpdateSecurityGroupRuleDescriptionsIngressInput) ec2.UpdateSecurityGroupRuleDescriptionsIngressRequest

	WithdrawByoipCidrRequest(*ec2.WithdrawByoipCidrInput) ec2.WithdrawByoipCidrRequest

	WaitUntilBundleTaskComplete(context.Context, *ec2.DescribeBundleTasksInput, ...aws.WaiterOption) error

	WaitUntilConversionTaskCancelled(context.Context, *ec2.DescribeConversionTasksInput, ...aws.WaiterOption) error

	WaitUntilConversionTaskCompleted(context.Context, *ec2.DescribeConversionTasksInput, ...aws.WaiterOption) error

	WaitUntilConversionTaskDeleted(context.Context, *ec2.DescribeConversionTasksInput, ...aws.WaiterOption) error

	WaitUntilCustomerGatewayAvailable(context.Context, *ec2.DescribeCustomerGatewaysInput, ...aws.WaiterOption) error

	WaitUntilExportTaskCancelled(context.Context, *ec2.DescribeExportTasksInput, ...aws.WaiterOption) error

	WaitUntilExportTaskCompleted(context.Context, *ec2.DescribeExportTasksInput, ...aws.WaiterOption) error

	WaitUntilImageAvailable(context.Context, *ec2.DescribeImagesInput, ...aws.WaiterOption) error

	WaitUntilImageExists(context.Context, *ec2.DescribeImagesInput, ...aws.WaiterOption) error

	WaitUntilInstanceExists(context.Context, *ec2.DescribeInstancesInput, ...aws.WaiterOption) error

	WaitUntilInstanceRunning(context.Context, *ec2.DescribeInstancesInput, ...aws.WaiterOption) error

	WaitUntilInstanceStatusOk(context.Context, *ec2.DescribeInstanceStatusInput, ...aws.WaiterOption) error

	WaitUntilInstanceStopped(context.Context, *ec2.DescribeInstancesInput, ...aws.WaiterOption) error

	WaitUntilInstanceTerminated(context.Context, *ec2.DescribeInstancesInput, ...aws.WaiterOption) error

	WaitUntilKeyPairExists(context.Context, *ec2.DescribeKeyPairsInput, ...aws.WaiterOption) error

	WaitUntilNatGatewayAvailable(context.Context, *ec2.DescribeNatGatewaysInput, ...aws.WaiterOption) error

	WaitUntilNetworkInterfaceAvailable(context.Context, *ec2.DescribeNetworkInterfacesInput, ...aws.WaiterOption) error

	WaitUntilPasswordDataAvailable(context.Context, *ec2.GetPasswordDataInput, ...aws.WaiterOption) error

	WaitUntilSnapshotCompleted(context.Context, *ec2.DescribeSnapshotsInput, ...aws.WaiterOption) error

	WaitUntilSpotInstanceRequestFulfilled(context.Context, *ec2.DescribeSpotInstanceRequestsInput, ...aws.WaiterOption) error

	WaitUntilSubnetAvailable(context.Context, *ec2.DescribeSubnetsInput, ...aws.WaiterOption) error

	WaitUntilSystemStatusOk(context.Context, *ec2.DescribeInstanceStatusInput, ...aws.WaiterOption) error

	WaitUntilVolumeAvailable(context.Context, *ec2.DescribeVolumesInput, ...aws.WaiterOption) error

	WaitUntilVolumeDeleted(context.Context, *ec2.DescribeVolumesInput, ...aws.WaiterOption) error

	WaitUntilVolumeInUse(context.Context, *ec2.DescribeVolumesInput, ...aws.WaiterOption) error

	WaitUntilVpcAvailable(context.Context, *ec2.DescribeVpcsInput, ...aws.WaiterOption) error

	WaitUntilVpcExists(context.Context, *ec2.DescribeVpcsInput, ...aws.WaiterOption) error

	WaitUntilVpcPeeringConnectionDeleted(context.Context, *ec2.DescribeVpcPeeringConnectionsInput, ...aws.WaiterOption) error

	WaitUntilVpcPeeringConnectionExists(context.Context, *ec2.DescribeVpcPeeringConnectionsInput, ...aws.WaiterOption) error

	WaitUntilVpnConnectionAvailable(context.Context, *ec2.DescribeVpnConnectionsInput, ...aws.WaiterOption) error

	WaitUntilVpnConnectionDeleted(context.Context, *ec2.DescribeVpnConnectionsInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*ec2.Client)(nil)
