// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// An object representing authorization data for an Amazon ECR registry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/AuthorizationData
type AuthorizationData struct {
	_ struct{} `type:"structure"`

	// A base64-encoded string that contains authorization data for the specified
	// Amazon ECR registry. When the string is decoded, it is presented in the format
	// user:password for private registry authentication using docker login.
	AuthorizationToken *string `locationName:"authorizationToken" type:"string"`

	// The Unix time in seconds and milliseconds when the authorization token expires.
	// Authorization tokens are valid for 12 hours.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp" timestampFormat:"unix"`

	// The registry URL to use for this authorization token in a docker login command.
	// The Amazon ECR registry URL format is https://aws_account_id.dkr.ecr.region.amazonaws.com.
	// For example, https://012345678910.dkr.ecr.us-east-1.amazonaws.com..
	ProxyEndpoint *string `locationName:"proxyEndpoint" type:"string"`
}

// String returns the string representation
func (s AuthorizationData) String() string {
	return awsutil.Prettify(s)
}

// An object representing a filter on a DescribeImages operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImagesFilter
type DescribeImagesFilter struct {
	_ struct{} `type:"structure"`

	// The tag status with which to filter your DescribeImages results. You can
	// filter results based on whether they are TAGGED or UNTAGGED.
	TagStatus TagStatus `locationName:"tagStatus" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeImagesFilter) String() string {
	return awsutil.Prettify(s)
}

// An object representing an Amazon ECR image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/Image
type Image struct {
	_ struct{} `type:"structure"`

	// An object containing the image tag and image digest associated with an image.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`

	// The image manifest associated with the image.
	ImageManifest *string `locationName:"imageManifest" type:"string"`

	// The AWS account ID associated with the registry containing the image.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository associated with the image.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// An object that describes an image returned by a DescribeImages operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ImageDetail
type ImageDetail struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The date and time, expressed in standard JavaScript date format, at which
	// the current image was pushed to the repository.
	ImagePushedAt *time.Time `locationName:"imagePushedAt" type:"timestamp" timestampFormat:"unix"`

	// The size, in bytes, of the image in the repository.
	//
	// Beginning with Docker version 1.9, the Docker client compresses image layers
	// before pushing them to a V2 Docker registry. The output of the docker images
	// command shows the uncompressed image size, so it may return a larger image
	// size than the image sizes returned by DescribeImages.
	ImageSizeInBytes *int64 `locationName:"imageSizeInBytes" type:"long"`

	// The list of tags associated with this image.
	ImageTags []string `locationName:"imageTags" type:"list"`

	// The AWS account ID associated with the registry to which this image belongs.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to which this image belongs.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s ImageDetail) String() string {
	return awsutil.Prettify(s)
}

// An object representing an Amazon ECR image failure.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ImageFailure
type ImageFailure struct {
	_ struct{} `type:"structure"`

	// The code associated with the failure.
	FailureCode ImageFailureCode `locationName:"failureCode" type:"string" enum:"true"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The image ID associated with the failure.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`
}

// String returns the string representation
func (s ImageFailure) String() string {
	return awsutil.Prettify(s)
}

// An object with identifying information for an Amazon ECR image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ImageIdentifier
type ImageIdentifier struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The tag used for the image.
	ImageTag *string `locationName:"imageTag" type:"string"`
}

// String returns the string representation
func (s ImageIdentifier) String() string {
	return awsutil.Prettify(s)
}

// An object representing an Amazon ECR image layer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/Layer
type Layer struct {
	_ struct{} `type:"structure"`

	// The availability status of the image layer.
	LayerAvailability LayerAvailability `locationName:"layerAvailability" type:"string" enum:"true"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The size, in bytes, of the image layer.
	LayerSize *int64 `locationName:"layerSize" type:"long"`

	// The media type of the layer, such as application/vnd.docker.image.rootfs.diff.tar.gzip
	// or application/vnd.oci.image.layer.v1.tar+gzip.
	MediaType *string `locationName:"mediaType" type:"string"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// An object representing an Amazon ECR image layer failure.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/LayerFailure
type LayerFailure struct {
	_ struct{} `type:"structure"`

	// The failure code associated with the failure.
	FailureCode LayerFailureCode `locationName:"failureCode" type:"string" enum:"true"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The layer digest associated with the failure.
	LayerDigest *string `locationName:"layerDigest" type:"string"`
}

// String returns the string representation
func (s LayerFailure) String() string {
	return awsutil.Prettify(s)
}

// The filter for the lifecycle policy preview.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/LifecyclePolicyPreviewFilter
type LifecyclePolicyPreviewFilter struct {
	_ struct{} `type:"structure"`

	// The tag status of the image.
	TagStatus TagStatus `locationName:"tagStatus" type:"string" enum:"true"`
}

// String returns the string representation
func (s LifecyclePolicyPreviewFilter) String() string {
	return awsutil.Prettify(s)
}

// The result of the lifecycle policy preview.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/LifecyclePolicyPreviewResult
type LifecyclePolicyPreviewResult struct {
	_ struct{} `type:"structure"`

	// The type of action to be taken.
	Action *LifecyclePolicyRuleAction `locationName:"action" type:"structure"`

	// The priority of the applied rule.
	AppliedRulePriority *int64 `locationName:"appliedRulePriority" min:"1" type:"integer"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The date and time, expressed in standard JavaScript date format, at which
	// the current image was pushed to the repository.
	ImagePushedAt *time.Time `locationName:"imagePushedAt" type:"timestamp" timestampFormat:"unix"`

	// The list of tags associated with this image.
	ImageTags []string `locationName:"imageTags" type:"list"`
}

// String returns the string representation
func (s LifecyclePolicyPreviewResult) String() string {
	return awsutil.Prettify(s)
}

// The summary of the lifecycle policy preview request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/LifecyclePolicyPreviewSummary
type LifecyclePolicyPreviewSummary struct {
	_ struct{} `type:"structure"`

	// The number of expiring images.
	ExpiringImageTotalCount *int64 `locationName:"expiringImageTotalCount" type:"integer"`
}

// String returns the string representation
func (s LifecyclePolicyPreviewSummary) String() string {
	return awsutil.Prettify(s)
}

// The type of action to be taken.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/LifecyclePolicyRuleAction
type LifecyclePolicyRuleAction struct {
	_ struct{} `type:"structure"`

	// The type of action to be taken.
	Type ImageActionType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s LifecyclePolicyRuleAction) String() string {
	return awsutil.Prettify(s)
}

// An object representing a filter on a ListImages operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImagesFilter
type ListImagesFilter struct {
	_ struct{} `type:"structure"`

	// The tag status with which to filter your ListImages results. You can filter
	// results based on whether they are TAGGED or UNTAGGED.
	TagStatus TagStatus `locationName:"tagStatus" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListImagesFilter) String() string {
	return awsutil.Prettify(s)
}

// An object representing a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/Repository
type Repository struct {
	_ struct{} `type:"structure"`

	// The date and time, in JavaScript date format, when the repository was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The AWS account ID associated with the registry that contains the repository.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the repository. The ARN contains
	// the arn:aws:ecr namespace, followed by the region of the repository, AWS
	// account ID of the repository owner, repository namespace, and repository
	// name. For example, arn:aws:ecr:region:012345678910:repository/test.
	RepositoryArn *string `locationName:"repositoryArn" type:"string"`

	// The name of the repository.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The URI for the repository. You can use this URI for Docker push or pull
	// operations.
	RepositoryUri *string `locationName:"repositoryUri" type:"string"`
}

// String returns the string representation
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// The metadata that you apply to a resource to help you categorize and organize
// them. Each tag consists of a key and an optional value, both of which you
// define. Tag keys can have a maximum character length of 128 characters, and
// tag values can have a maximum length of 256 characters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}
