// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRuleInput
type ModifyRuleInput struct {
	_ struct{} `type:"structure"`

	// The actions.
	//
	// If the action type is forward, you specify a target group. The protocol of
	// the target group must be HTTP or HTTPS for an Application Load Balancer.
	// The protocol of the target group must be TCP or TLS for a Network Load Balancer.
	//
	// [HTTPS listeners] If the action type is authenticate-oidc, you authenticate
	// users through an identity provider that is OpenID Connect (OIDC) compliant.
	//
	// [HTTPS listeners] If the action type is authenticate-cognito, you authenticate
	// users through the user pools supported by Amazon Cognito.
	//
	// [Application Load Balancer] If the action type is redirect, you redirect
	// specified client requests from one URL to another.
	//
	// [Application Load Balancer] If the action type is fixed-response, you drop
	// specified client requests and return a custom HTTP response.
	Actions []Action `type:"list"`

	// The conditions. Each condition specifies a field name and a single value.
	//
	// If the field name is host-header, you can specify a single host name (for
	// example, my.example.com). A host name is case insensitive, can be up to 128
	// characters in length, and can contain any of the following characters. You
	// can include up to three wildcard characters.
	//
	//    * A-Z, a-z, 0-9
	//
	//    * - .
	//
	//    * * (matches 0 or more characters)
	//
	//    * ? (matches exactly 1 character)
	//
	// If the field name is path-pattern, you can specify a single path pattern.
	// A path pattern is case-sensitive, can be up to 128 characters in length,
	// and can contain any of the following characters. You can include up to three
	// wildcard characters.
	//
	//    * A-Z, a-z, 0-9
	//
	//    * _ - . $ / ~ " ' @ : +
	//
	//    * & (using &)
	//
	//    * * (matches 0 or more characters)
	//
	//    * ? (matches exactly 1 character)
	Conditions []RuleCondition `type:"list"`

	// The Amazon Resource Name (ARN) of the rule.
	//
	// RuleArn is a required field
	RuleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyRuleInput"}

	if s.RuleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleArn"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRuleOutput
type ModifyRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the modified rule.
	Rules []Rule `type:"list"`
}

// String returns the string representation
func (s ModifyRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyRule = "ModifyRule"

// ModifyRuleRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Modifies the specified rule.
//
// Any existing properties that you do not modify retain their current values.
//
// To modify the actions for the default rule, use ModifyListener.
//
//    // Example sending a request using ModifyRuleRequest.
//    req := client.ModifyRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule
func (c *Client) ModifyRuleRequest(input *ModifyRuleInput) ModifyRuleRequest {
	op := &aws.Operation{
		Name:       opModifyRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyRuleInput{}
	}

	req := c.newRequest(op, input, &ModifyRuleOutput{})
	return ModifyRuleRequest{Request: req, Input: input, Copy: c.ModifyRuleRequest}
}

// ModifyRuleRequest is the request type for the
// ModifyRule API operation.
type ModifyRuleRequest struct {
	*aws.Request
	Input *ModifyRuleInput
	Copy  func(*ModifyRuleInput) ModifyRuleRequest
}

// Send marshals and sends the ModifyRule API request.
func (r ModifyRuleRequest) Send(ctx context.Context) (*ModifyRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyRuleResponse{
		ModifyRuleOutput: r.Request.Data.(*ModifyRuleOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyRuleResponse is the response type for the
// ModifyRule API operation.
type ModifyRuleResponse struct {
	*ModifyRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyRule request.
func (r *ModifyRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
