// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnectionInput
type DeleteVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet. This value must match the fleet ID referenced
	// in the VPC peering connection record.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for a VPC peering connection. This value is included in
	// the VpcPeeringConnection object, which can be retrieved by calling DescribeVpcPeeringConnections.
	//
	// VpcPeeringConnectionId is a required field
	VpcPeeringConnectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcPeeringConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVpcPeeringConnectionInput"}

	if s.FleetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetId"))
	}

	if s.VpcPeeringConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcPeeringConnectionId"))
	}
	if s.VpcPeeringConnectionId != nil && len(*s.VpcPeeringConnectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VpcPeeringConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnectionOutput
type DeleteVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Removes a VPC peering connection. To delete the connection, you must have
// a valid authorization for the VPC peering connection that you want to delete.
// You can check for an authorization by calling DescribeVpcPeeringAuthorizations
// or request a new one using CreateVpcPeeringAuthorization.
//
// Once a valid authorization exists, call this operation from the AWS account
// that is used to manage the Amazon GameLift fleets. Identify the connection
// to delete by the connection ID and fleet ID. If successful, the connection
// is removed.
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
//    // Example sending a request using DeleteVpcPeeringConnectionRequest.
//    req := client.DeleteVpcPeeringConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection
func (c *Client) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) DeleteVpcPeeringConnectionRequest {
	op := &aws.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	req := c.newRequest(op, input, &DeleteVpcPeeringConnectionOutput{})
	return DeleteVpcPeeringConnectionRequest{Request: req, Input: input, Copy: c.DeleteVpcPeeringConnectionRequest}
}

// DeleteVpcPeeringConnectionRequest is the request type for the
// DeleteVpcPeeringConnection API operation.
type DeleteVpcPeeringConnectionRequest struct {
	*aws.Request
	Input *DeleteVpcPeeringConnectionInput
	Copy  func(*DeleteVpcPeeringConnectionInput) DeleteVpcPeeringConnectionRequest
}

// Send marshals and sends the DeleteVpcPeeringConnection API request.
func (r DeleteVpcPeeringConnectionRequest) Send(ctx context.Context) (*DeleteVpcPeeringConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVpcPeeringConnectionResponse{
		DeleteVpcPeeringConnectionOutput: r.Request.Data.(*DeleteVpcPeeringConnectionOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVpcPeeringConnectionResponse is the response type for the
// DeleteVpcPeeringConnection API operation.
type DeleteVpcPeeringConnectionResponse struct {
	*DeleteVpcPeeringConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVpcPeeringConnection request.
func (r *DeleteVpcPeeringConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
