// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifierRequest
type GetClassifierInput struct {
	_ struct{} `type:"structure"`

	// Name of the classifier to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClassifierInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetClassifierInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifierResponse
type GetClassifierOutput struct {
	_ struct{} `type:"structure"`

	// The requested classifier.
	Classifier *Classifier `type:"structure"`
}

// String returns the string representation
func (s GetClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetClassifier = "GetClassifier"

// GetClassifierRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieve a classifier by name.
//
//    // Example sending a request using GetClassifierRequest.
//    req := client.GetClassifierRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier
func (c *Client) GetClassifierRequest(input *GetClassifierInput) GetClassifierRequest {
	op := &aws.Operation{
		Name:       opGetClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetClassifierInput{}
	}

	req := c.newRequest(op, input, &GetClassifierOutput{})
	return GetClassifierRequest{Request: req, Input: input, Copy: c.GetClassifierRequest}
}

// GetClassifierRequest is the request type for the
// GetClassifier API operation.
type GetClassifierRequest struct {
	*aws.Request
	Input *GetClassifierInput
	Copy  func(*GetClassifierInput) GetClassifierRequest
}

// Send marshals and sends the GetClassifier API request.
func (r GetClassifierRequest) Send(ctx context.Context) (*GetClassifierResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetClassifierResponse{
		GetClassifierOutput: r.Request.Data.(*GetClassifierOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetClassifierResponse is the response type for the
// GetClassifier API operation.
type GetClassifierResponse struct {
	*GetClassifierOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetClassifier request.
func (r *GetClassifierResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
