// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProviderRequest
type AddClientIDToOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The client ID (also known as audience) to add to the IAM OpenID Connect provider
	// resource.
	//
	// ClientID is a required field
	ClientID *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
	// resource to add the client ID to. You can get a list of OIDC provider ARNs
	// by using the ListOpenIDConnectProviders operation.
	//
	// OpenIDConnectProviderArn is a required field
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AddClientIDToOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddClientIDToOpenIDConnectProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddClientIDToOpenIDConnectProviderInput"}

	if s.ClientID == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientID"))
	}
	if s.ClientID != nil && len(*s.ClientID) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientID", 1))
	}

	if s.OpenIDConnectProviderArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("OpenIDConnectProviderArn"))
	}
	if s.OpenIDConnectProviderArn != nil && len(*s.OpenIDConnectProviderArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("OpenIDConnectProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProviderOutput
type AddClientIDToOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddClientIDToOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddClientIDToOpenIDConnectProvider = "AddClientIDToOpenIDConnectProvider"

// AddClientIDToOpenIDConnectProviderRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Adds a new client ID (also known as audience) to the list of client IDs already
// registered for the specified IAM OpenID Connect (OIDC) provider resource.
//
// This operation is idempotent; it does not fail or return an error if you
// add an existing client ID to the provider.
//
//    // Example sending a request using AddClientIDToOpenIDConnectProviderRequest.
//    req := client.AddClientIDToOpenIDConnectProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider
func (c *Client) AddClientIDToOpenIDConnectProviderRequest(input *AddClientIDToOpenIDConnectProviderInput) AddClientIDToOpenIDConnectProviderRequest {
	op := &aws.Operation{
		Name:       opAddClientIDToOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddClientIDToOpenIDConnectProviderInput{}
	}

	req := c.newRequest(op, input, &AddClientIDToOpenIDConnectProviderOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AddClientIDToOpenIDConnectProviderRequest{Request: req, Input: input, Copy: c.AddClientIDToOpenIDConnectProviderRequest}
}

// AddClientIDToOpenIDConnectProviderRequest is the request type for the
// AddClientIDToOpenIDConnectProvider API operation.
type AddClientIDToOpenIDConnectProviderRequest struct {
	*aws.Request
	Input *AddClientIDToOpenIDConnectProviderInput
	Copy  func(*AddClientIDToOpenIDConnectProviderInput) AddClientIDToOpenIDConnectProviderRequest
}

// Send marshals and sends the AddClientIDToOpenIDConnectProvider API request.
func (r AddClientIDToOpenIDConnectProviderRequest) Send(ctx context.Context) (*AddClientIDToOpenIDConnectProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddClientIDToOpenIDConnectProviderResponse{
		AddClientIDToOpenIDConnectProviderOutput: r.Request.Data.(*AddClientIDToOpenIDConnectProviderOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddClientIDToOpenIDConnectProviderResponse is the response type for the
// AddClientIDToOpenIDConnectProvider API operation.
type AddClientIDToOpenIDConnectProviderResponse struct {
	*AddClientIDToOpenIDConnectProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddClientIDToOpenIDConnectProvider request.
func (r *AddClientIDToOpenIDConnectProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
