// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicyRequest
type GetRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy document to get.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the role associated with the policy.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRolePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRolePolicyInput"}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if s.RoleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful GetRolePolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicyResponse
type GetRolePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	//
	// IAM stores policies in JSON format. However, resources that were created
	// using AWS CloudFormation templates can be formatted in YAML. AWS CloudFormation
	// always converts a YAML policy to JSON format before submitting it to IAM.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The role the policy is associated with.
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRolePolicy = "GetRolePolicy"

// GetRolePolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves the specified inline policy document that is embedded with the
// specified IAM role.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// An IAM role can also have managed policies attached to it. To retrieve a
// managed policy document that is attached to a role, use GetPolicy to determine
// the policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, see Managed Policies and Inline Policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For more information about roles, see Using Roles to Delegate Permissions
// and Federate Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
//
//    // Example sending a request using GetRolePolicyRequest.
//    req := client.GetRolePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy
func (c *Client) GetRolePolicyRequest(input *GetRolePolicyInput) GetRolePolicyRequest {
	op := &aws.Operation{
		Name:       opGetRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRolePolicyInput{}
	}

	req := c.newRequest(op, input, &GetRolePolicyOutput{})
	return GetRolePolicyRequest{Request: req, Input: input, Copy: c.GetRolePolicyRequest}
}

// GetRolePolicyRequest is the request type for the
// GetRolePolicy API operation.
type GetRolePolicyRequest struct {
	*aws.Request
	Input *GetRolePolicyInput
	Copy  func(*GetRolePolicyInput) GetRolePolicyRequest
}

// Send marshals and sends the GetRolePolicy API request.
func (r GetRolePolicyRequest) Send(ctx context.Context) (*GetRolePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRolePolicyResponse{
		GetRolePolicyOutput: r.Request.Data.(*GetRolePolicyOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRolePolicyResponse is the response type for the
// GetRolePolicy API operation.
type GetRolePolicyResponse struct {
	*GetRolePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRolePolicy request.
func (r *GetRolePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
