// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListAuditTasksInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The maximum number of results to return at one time. The default is 25.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The beginning of the time period. Note that audit information is retained
	// for a limited time (180 days). Requesting a start time prior to what is retained
	// results in an "InvalidRequestException".
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// A filter to limit the output to audits with the specified completion status:
	// can be one of "IN_PROGRESS", "COMPLETED", "FAILED" or "CANCELED".
	TaskStatus AuditTaskStatus `location:"querystring" locationName:"taskStatus" type:"string" enum:"true"`

	// A filter to limit the output to the specified type of audit: can be one of
	// "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".
	TaskType AuditTaskType `location:"querystring" locationName:"taskType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListAuditTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAuditTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAuditTasksInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAuditTasksInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endTime", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startTime", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if len(s.TaskStatus) > 0 {
		v := s.TaskStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "taskStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TaskType) > 0 {
		v := s.TaskType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "taskType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListAuditTasksOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The audits that were performed during the specified time period.
	Tasks []AuditTaskMetadata `locationName:"tasks" type:"list"`
}

// String returns the string representation
func (s ListAuditTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAuditTasksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Tasks) > 0 {
		v := s.Tasks

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tasks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListAuditTasks = "ListAuditTasks"

// ListAuditTasksRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the Device Defender audits that have been performed during a given
// time period.
//
//    // Example sending a request using ListAuditTasksRequest.
//    req := client.ListAuditTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListAuditTasksRequest(input *ListAuditTasksInput) ListAuditTasksRequest {
	op := &aws.Operation{
		Name:       opListAuditTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/tasks",
	}

	if input == nil {
		input = &ListAuditTasksInput{}
	}

	req := c.newRequest(op, input, &ListAuditTasksOutput{})
	return ListAuditTasksRequest{Request: req, Input: input, Copy: c.ListAuditTasksRequest}
}

// ListAuditTasksRequest is the request type for the
// ListAuditTasks API operation.
type ListAuditTasksRequest struct {
	*aws.Request
	Input *ListAuditTasksInput
	Copy  func(*ListAuditTasksInput) ListAuditTasksRequest
}

// Send marshals and sends the ListAuditTasks API request.
func (r ListAuditTasksRequest) Send(ctx context.Context) (*ListAuditTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAuditTasksResponse{
		ListAuditTasksOutput: r.Request.Data.(*ListAuditTasksOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAuditTasksResponse is the response type for the
// ListAuditTasks API operation.
type ListAuditTasksResponse struct {
	*ListAuditTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAuditTasks request.
func (r *ListAuditTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
