// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrencyRequest
type PutFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The number of simultaneous executions to reserve for the function.
	//
	// ReservedConcurrentExecutions is a required field
	ReservedConcurrentExecutions *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PutFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFunctionConcurrencyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutFunctionConcurrencyInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.ReservedConcurrentExecutions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReservedConcurrentExecutions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutFunctionConcurrencyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ReservedConcurrentExecutions != nil {
		v := *s.ReservedConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Concurrency
type PutFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`

	// The number of concurrent executions that are reserved for this function.
	// For more information, see Managing Concurrency (https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	ReservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s PutFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutFunctionConcurrencyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ReservedConcurrentExecutions != nil {
		v := *s.ReservedConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opPutFunctionConcurrency = "PutFunctionConcurrency"

// PutFunctionConcurrencyRequest returns a request value for making API operation for
// AWS Lambda.
//
// Sets the maximum number of simultaneous executions for a function, and reserves
// capacity for that concurrency level.
//
// Concurrency settings apply to the function as a whole, including all published
// versions and the unpublished version. Reserving concurrency both ensures
// that your function has capacity to process the specified number of events
// simultaneously, and prevents it from scaling beyond that level. Use GetFunction
// to see the current setting for a function.
//
// Use GetAccountSettings to see your regional concurrency limit. You can reserve
// concurrency for as many functions as you like, as long as you leave at least
// 100 simultaneous executions unreserved for functions that aren't configured
// with a per-function limit. For more information, see Managing Concurrency
// (https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
//
//    // Example sending a request using PutFunctionConcurrencyRequest.
//    req := client.PutFunctionConcurrencyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency
func (c *Client) PutFunctionConcurrencyRequest(input *PutFunctionConcurrencyInput) PutFunctionConcurrencyRequest {
	op := &aws.Operation{
		Name:       opPutFunctionConcurrency,
		HTTPMethod: "PUT",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &PutFunctionConcurrencyInput{}
	}

	req := c.newRequest(op, input, &PutFunctionConcurrencyOutput{})
	return PutFunctionConcurrencyRequest{Request: req, Input: input, Copy: c.PutFunctionConcurrencyRequest}
}

// PutFunctionConcurrencyRequest is the request type for the
// PutFunctionConcurrency API operation.
type PutFunctionConcurrencyRequest struct {
	*aws.Request
	Input *PutFunctionConcurrencyInput
	Copy  func(*PutFunctionConcurrencyInput) PutFunctionConcurrencyRequest
}

// Send marshals and sends the PutFunctionConcurrency API request.
func (r PutFunctionConcurrencyRequest) Send(ctx context.Context) (*PutFunctionConcurrencyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutFunctionConcurrencyResponse{
		PutFunctionConcurrencyOutput: r.Request.Data.(*PutFunctionConcurrencyOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutFunctionConcurrencyResponse is the response type for the
// PutFunctionConcurrency API operation.
type PutFunctionConcurrencyResponse struct {
	*PutFunctionConcurrencyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutFunctionConcurrency request.
func (r *PutFunctionConcurrencyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
