// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesViewRequest
type GetUtterancesViewInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot for which utterance information should be returned.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botname" min:"2" type:"string" required:"true"`

	// An array of bot versions for which utterance information should be returned.
	// The limit is 5 versions per request.
	//
	// BotVersions is a required field
	BotVersions []string `location:"querystring" locationName:"bot_versions" min:"1" type:"list" required:"true"`

	// To return utterances that were recognized and handled, useDetected. To return
	// utterances that were not recognized, use Missed.
	//
	// StatusType is a required field
	StatusType StatusType `location:"querystring" locationName:"status_type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetUtterancesViewInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUtterancesViewInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetUtterancesViewInput"}

	if s.BotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("BotName", 2))
	}

	if s.BotVersions == nil {
		invalidParams.Add(aws.NewErrParamRequired("BotVersions"))
	}
	if s.BotVersions != nil && len(s.BotVersions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BotVersions", 1))
	}
	if len(s.StatusType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("StatusType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUtterancesViewInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.BotName != nil {
		v := *s.BotName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "botname", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.BotVersions) > 0 {
		v := s.BotVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "bot_versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.StatusType) > 0 {
		v := s.StatusType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "status_type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesViewResponse
type GetUtterancesViewOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bot for which utterance information was returned.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// An array of UtteranceList objects, each containing a list of UtteranceData
	// objects describing the utterances that were processed by your bot. The response
	// contains a maximum of 100 UtteranceData objects for each version.
	Utterances []UtteranceList `locationName:"utterances" type:"list"`
}

// String returns the string representation
func (s GetUtterancesViewOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUtterancesViewOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BotName != nil {
		v := *s.BotName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "botName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Utterances) > 0 {
		v := s.Utterances

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "utterances", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetUtterancesView = "GetUtterancesView"

// GetUtterancesViewRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Use the GetUtterancesView operation to get information about the utterances
// that your users have made to your bot. You can use this list to tune the
// utterances that your bot responds to.
//
// For example, say that you have created a bot to order flowers. After your
// users have used your bot for a while, use the GetUtterancesView operation
// to see the requests that they have made and whether they have been successful.
// You might find that the utterance "I want flowers" is not being recognized.
// You could add this utterance to the OrderFlowers intent so that your bot
// recognizes that utterance.
//
// After you publish a new version of a bot, you can get information about the
// old version and the new so that you can compare the performance across the
// two versions.
//
// Utterance statistics are generated once a day. Data is available for the
// last 15 days. You can request information for up to 5 versions in each request.
// The response contains information about a maximum of 100 utterances for each
// version.
//
// This operation requires permissions for the lex:GetUtterancesView action.
//
//    // Example sending a request using GetUtterancesViewRequest.
//    req := client.GetUtterancesViewRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesView
func (c *Client) GetUtterancesViewRequest(input *GetUtterancesViewInput) GetUtterancesViewRequest {
	op := &aws.Operation{
		Name:       opGetUtterancesView,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botname}/utterances?view=aggregation",
	}

	if input == nil {
		input = &GetUtterancesViewInput{}
	}

	req := c.newRequest(op, input, &GetUtterancesViewOutput{})
	return GetUtterancesViewRequest{Request: req, Input: input, Copy: c.GetUtterancesViewRequest}
}

// GetUtterancesViewRequest is the request type for the
// GetUtterancesView API operation.
type GetUtterancesViewRequest struct {
	*aws.Request
	Input *GetUtterancesViewInput
	Copy  func(*GetUtterancesViewInput) GetUtterancesViewRequest
}

// Send marshals and sends the GetUtterancesView API request.
func (r GetUtterancesViewRequest) Send(ctx context.Context) (*GetUtterancesViewResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUtterancesViewResponse{
		GetUtterancesViewOutput: r.Request.Data.(*GetUtterancesViewOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetUtterancesViewResponse is the response type for the
// GetUtterancesView API operation.
type GetUtterancesViewResponse struct {
	*GetUtterancesViewOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUtterancesView request.
func (r *GetUtterancesViewResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
