// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Provides information about a bot alias.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/BotAliasMetadata
type BotAliasMetadata struct {
	_ struct{} `type:"structure"`

	// The name of the bot to which the alias points.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// The version of the Amazon Lex bot to which the alias points.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Checksum of the bot alias.
	Checksum *string `locationName:"checksum" type:"string"`

	// The date that the bot alias was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// A description of the bot alias.
	Description *string `locationName:"description" type:"string"`

	// The date that the bot alias was updated. When you create a resource, the
	// creation date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// The name of the bot alias.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s BotAliasMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BotAliasMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.BotName != nil {
		v := *s.BotName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "botName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BotVersion != nil {
		v := *s.BotVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "botVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Checksum != nil {
		v := *s.Checksum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "checksum", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an association between an Amazon Lex bot and an external messaging
// platform.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/BotChannelAssociation
type BotChannelAssociation struct {
	_ struct{} `type:"structure"`

	// An alias pointing to the specific version of the Amazon Lex bot to which
	// this association is being made.
	BotAlias *string `locationName:"botAlias" min:"1" type:"string"`

	// Provides information necessary to communicate with the messaging platform.
	BotConfiguration map[string]string `locationName:"botConfiguration" min:"1" type:"map"`

	// The name of the Amazon Lex bot to which this association is being made.
	//
	// Currently, Amazon Lex supports associations with Facebook and Slack, and
	// Twilio.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// The date that the association between the Amazon Lex bot and the channel
	// was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// A text description of the association you are creating.
	Description *string `locationName:"description" type:"string"`

	// If status is FAILED, Amazon Lex provides the reason that it failed to create
	// the association.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the association between the bot and the channel.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the bot channel.
	//
	//    * CREATED - The channel has been created and is ready for use.
	//
	//    * IN_PROGRESS - Channel creation is in progress.
	//
	//    * FAILED - There was an error creating the channel. For information about
	//    the reason for the failure, see the failureReason field.
	Status ChannelStatus `locationName:"status" type:"string" enum:"true"`

	// Specifies the type of association by indicating the type of channel being
	// established between the Amazon Lex bot and the external messaging platform.
	Type ChannelType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s BotChannelAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BotChannelAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.BotAlias != nil {
		v := *s.BotAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "botAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.BotConfiguration) > 0 {
		v := s.BotConfiguration

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "botConfiguration", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.BotName != nil {
		v := *s.BotName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "botName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about a bot. .
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/BotMetadata
type BotMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the bot was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// A description of the bot.
	Description *string `locationName:"description" type:"string"`

	// The date that the bot was updated. When you create a bot, the creation date
	// and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// The name of the bot.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The status of the bot.
	Status Status `locationName:"status" type:"string" enum:"true"`

	// The version of the bot. For a new bot, the version is always $LATEST.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s BotMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BotMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides metadata for a built-in intent.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/BuiltinIntentMetadata
type BuiltinIntentMetadata struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the built-in intent. To find the signature for an
	// intent, see Standard Built-in Intents (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
	// in the Alexa Skills Kit.
	Signature *string `locationName:"signature" type:"string"`

	// A list of identifiers for the locales that the intent supports.
	SupportedLocales []Locale `locationName:"supportedLocales" type:"list"`
}

// String returns the string representation
func (s BuiltinIntentMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BuiltinIntentMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.Signature != nil {
		v := *s.Signature

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "signature", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SupportedLocales) > 0 {
		v := s.SupportedLocales

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "supportedLocales", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Provides information about a slot used in a built-in intent.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/BuiltinIntentSlot
type BuiltinIntentSlot struct {
	_ struct{} `type:"structure"`

	// A list of the slots defined for the intent.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BuiltinIntentSlot) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BuiltinIntentSlot) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about a built in slot type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/BuiltinSlotTypeMetadata
type BuiltinSlotTypeMetadata struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the built-in slot type. To find the signature for
	// a slot type, see Slot Type Reference (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference)
	// in the Alexa Skills Kit.
	Signature *string `locationName:"signature" type:"string"`

	// A list of target locales for the slot.
	SupportedLocales []Locale `locationName:"supportedLocales" type:"list"`
}

// String returns the string representation
func (s BuiltinSlotTypeMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BuiltinSlotTypeMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.Signature != nil {
		v := *s.Signature

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "signature", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SupportedLocales) > 0 {
		v := s.SupportedLocales

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "supportedLocales", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies a Lambda function that verifies requests to a bot or fulfills the
// user's request to a bot..
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CodeHook
type CodeHook struct {
	_ struct{} `type:"structure"`

	// The version of the request-response that you want Amazon Lex to use to invoke
	// your Lambda function. For more information, see using-lambda.
	//
	// MessageVersion is a required field
	MessageVersion *string `locationName:"messageVersion" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// Uri is a required field
	Uri *string `locationName:"uri" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeHook) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeHook) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeHook"}

	if s.MessageVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageVersion"))
	}
	if s.MessageVersion != nil && len(*s.MessageVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MessageVersion", 1))
	}

	if s.Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("Uri", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeHook) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageVersion != nil {
		v := *s.MessageVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Uri != nil {
		v := *s.Uri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "uri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Each slot type can have a set of values. Each enumeration value represents
// a value the slot type can take.
//
// For example, a pizza ordering bot could have a slot type that specifies the
// type of crust that the pizza should have. The slot type could include the
// values
//
//    * thick
//
//    * thin
//
//    * stuffed
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/EnumerationValue
type EnumerationValue struct {
	_ struct{} `type:"structure"`

	// Additional values related to the slot type value.
	Synonyms []string `locationName:"synonyms" type:"list"`

	// The value of the slot type.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnumerationValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnumerationValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnumerationValue"}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnumerationValue) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Synonyms) > 0 {
		v := s.Synonyms

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "synonyms", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A prompt for additional activity after an intent is fulfilled. For example,
// after the OrderPizza intent is fulfilled, you might prompt the user to find
// out whether the user wants to order drinks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/FollowUpPrompt
type FollowUpPrompt struct {
	_ struct{} `type:"structure"`

	// Prompts for information from the user.
	//
	// Prompt is a required field
	Prompt *Prompt `locationName:"prompt" type:"structure" required:"true"`

	// If the user answers "no" to the question defined in the prompt field, Amazon
	// Lex responds with this statement to acknowledge that the intent was canceled.
	//
	// RejectionStatement is a required field
	RejectionStatement *Statement `locationName:"rejectionStatement" type:"structure" required:"true"`
}

// String returns the string representation
func (s FollowUpPrompt) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FollowUpPrompt) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FollowUpPrompt"}

	if s.Prompt == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prompt"))
	}

	if s.RejectionStatement == nil {
		invalidParams.Add(aws.NewErrParamRequired("RejectionStatement"))
	}
	if s.Prompt != nil {
		if err := s.Prompt.Validate(); err != nil {
			invalidParams.AddNested("Prompt", err.(aws.ErrInvalidParams))
		}
	}
	if s.RejectionStatement != nil {
		if err := s.RejectionStatement.Validate(); err != nil {
			invalidParams.AddNested("RejectionStatement", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FollowUpPrompt) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prompt != nil {
		v := s.Prompt

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "prompt", v, metadata)
	}
	if s.RejectionStatement != nil {
		v := s.RejectionStatement

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "rejectionStatement", v, metadata)
	}
	return nil
}

// Describes how the intent is fulfilled after the user provides all of the
// information required for the intent. You can provide a Lambda function to
// process the intent, or you can return the intent information to the client
// application. We recommend that you use a Lambda function so that the relevant
// logic lives in the Cloud and limit the client-side code primarily to presentation.
// If you need to update the logic, you only update the Lambda function; you
// don't need to upgrade your client application.
//
// Consider the following examples:
//
//    * In a pizza ordering application, after the user provides all of the
//    information for placing an order, you use a Lambda function to place an
//    order with a pizzeria.
//
//    * In a gaming application, when a user says "pick up a rock," this information
//    must go back to the client application so that it can perform the operation
//    and update the graphics. In this case, you want Amazon Lex to return the
//    intent data to the client.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/FulfillmentActivity
type FulfillmentActivity struct {
	_ struct{} `type:"structure"`

	// A description of the Lambda function that is run to fulfill the intent.
	CodeHook *CodeHook `locationName:"codeHook" type:"structure"`

	// How the intent should be fulfilled, either by running a Lambda function or
	// by returning the slot data to the client application.
	//
	// Type is a required field
	Type FulfillmentActivityType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FulfillmentActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FulfillmentActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FulfillmentActivity"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.CodeHook != nil {
		if err := s.CodeHook.Validate(); err != nil {
			invalidParams.AddNested("CodeHook", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FulfillmentActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeHook != nil {
		v := s.CodeHook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "codeHook", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Identifies the specific version of an intent.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/Intent
type Intent struct {
	_ struct{} `type:"structure"`

	// The name of the intent.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// The version of the intent.
	//
	// IntentVersion is a required field
	IntentVersion *string `locationName:"intentVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Intent) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Intent) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Intent"}

	if s.IntentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IntentName"))
	}
	if s.IntentName != nil && len(*s.IntentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IntentName", 1))
	}

	if s.IntentVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("IntentVersion"))
	}
	if s.IntentVersion != nil && len(*s.IntentVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IntentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Intent) MarshalFields(e protocol.FieldEncoder) error {
	if s.IntentName != nil {
		v := *s.IntentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "intentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntentVersion != nil {
		v := *s.IntentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "intentVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an intent.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/IntentMetadata
type IntentMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the intent was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// A description of the intent.
	Description *string `locationName:"description" type:"string"`

	// The date that the intent was updated. When you create an intent, the creation
	// date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// The name of the intent.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The version of the intent.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s IntentMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IntentMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The message object that provides the message text and its type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/Message
type Message struct {
	_ struct{} `type:"structure"`

	// The text of the message.
	//
	// Content is a required field
	Content *string `locationName:"content" min:"1" type:"string" required:"true"`

	// The content type of the message string.
	//
	// ContentType is a required field
	ContentType ContentType `locationName:"contentType" type:"string" required:"true" enum:"true"`

	// Identifies the message group that the message belongs to. When a group is
	// assigned to a message, Amazon Lex returns one message from each group in
	// the response.
	GroupNumber *int64 `locationName:"groupNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Message"}

	if s.Content == nil {
		invalidParams.Add(aws.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}
	if len(s.ContentType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ContentType"))
	}
	if s.GroupNumber != nil && *s.GroupNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("GroupNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Message) MarshalFields(e protocol.FieldEncoder) error {
	if s.Content != nil {
		v := *s.Content

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "content", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ContentType) > 0 {
		v := s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.GroupNumber != nil {
		v := *s.GroupNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Obtains information from the user. To define a prompt, provide one or more
// messages and specify the number of attempts to get information from the user.
// If you provide more than one message, Amazon Lex chooses one of the messages
// to use to prompt the user. For more information, see how-it-works.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/Prompt
type Prompt struct {
	_ struct{} `type:"structure"`

	// The number of times to prompt the user for information.
	//
	// MaxAttempts is a required field
	MaxAttempts *int64 `locationName:"maxAttempts" min:"1" type:"integer" required:"true"`

	// An array of objects, each of which provides a message string and its type.
	// You can specify the message string in plain text or in Speech Synthesis Markup
	// Language (SSML).
	//
	// Messages is a required field
	Messages []Message `locationName:"messages" min:"1" type:"list" required:"true"`

	// A response card. Amazon Lex uses this prompt at runtime, in the PostText
	// API response. It substitutes session attributes and slot values for placeholders
	// in the response card. For more information, see ex-resp-card.
	ResponseCard *string `locationName:"responseCard" min:"1" type:"string"`
}

// String returns the string representation
func (s Prompt) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Prompt) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Prompt"}

	if s.MaxAttempts == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxAttempts"))
	}
	if s.MaxAttempts != nil && *s.MaxAttempts < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxAttempts", 1))
	}

	if s.Messages == nil {
		invalidParams.Add(aws.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Messages", 1))
	}
	if s.ResponseCard != nil && len(*s.ResponseCard) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResponseCard", 1))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Prompt) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxAttempts != nil {
		v := *s.MaxAttempts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxAttempts", protocol.Int64Value(v), metadata)
	}
	if len(s.Messages) > 0 {
		v := s.Messages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "messages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResponseCard != nil {
		v := *s.ResponseCard

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "responseCard", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the resource that refers to the resource that you are attempting
// to delete. This object is returned as part of the ResourceInUseException
// exception.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/ResourceReference
type ResourceReference struct {
	_ struct{} `type:"structure"`

	// The name of the resource that is using the resource that you are trying to
	// delete.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The version of the resource that is using the resource that you are trying
	// to delete.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceReference) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Identifies the version of a specific slot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/Slot
type Slot struct {
	_ struct{} `type:"structure"`

	// A description of the slot.
	Description *string `locationName:"description" type:"string"`

	// The name of the slot.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Directs Lex the order in which to elicit this slot value from the user. For
	// example, if the intent has two slots with priorities 1 and 2, AWS Lex first
	// elicits a value for the slot with priority 1.
	//
	// If multiple slots share the same priority, the order in which Lex elicits
	// values is arbitrary.
	Priority *int64 `locationName:"priority" type:"integer"`

	// A set of possible responses for the slot type used by text-based clients.
	// A user chooses an option from the response card, instead of using text to
	// reply.
	ResponseCard *string `locationName:"responseCard" min:"1" type:"string"`

	// If you know a specific pattern with which users might respond to an Amazon
	// Lex request for a slot value, you can provide those utterances to improve
	// accuracy. This is optional. In most cases, Amazon Lex is capable of understanding
	// user utterances.
	SampleUtterances []string `locationName:"sampleUtterances" type:"list"`

	// Specifies whether the slot is required or optional.
	//
	// SlotConstraint is a required field
	SlotConstraint SlotConstraint `locationName:"slotConstraint" type:"string" required:"true" enum:"true"`

	// The type of the slot, either a custom slot type that you defined or one of
	// the built-in slot types.
	SlotType *string `locationName:"slotType" min:"1" type:"string"`

	// The version of the slot type.
	SlotTypeVersion *string `locationName:"slotTypeVersion" min:"1" type:"string"`

	// The prompt that Amazon Lex uses to elicit the slot value from the user.
	ValueElicitationPrompt *Prompt `locationName:"valueElicitationPrompt" type:"structure"`
}

// String returns the string representation
func (s Slot) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Slot) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Slot"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.ResponseCard != nil && len(*s.ResponseCard) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResponseCard", 1))
	}
	if len(s.SlotConstraint) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SlotConstraint"))
	}
	if s.SlotType != nil && len(*s.SlotType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SlotType", 1))
	}
	if s.SlotTypeVersion != nil && len(*s.SlotTypeVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SlotTypeVersion", 1))
	}
	if s.ValueElicitationPrompt != nil {
		if err := s.ValueElicitationPrompt.Validate(); err != nil {
			invalidParams.AddNested("ValueElicitationPrompt", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Slot) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "priority", protocol.Int64Value(v), metadata)
	}
	if s.ResponseCard != nil {
		v := *s.ResponseCard

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "responseCard", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SampleUtterances) > 0 {
		v := s.SampleUtterances

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sampleUtterances", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.SlotConstraint) > 0 {
		v := s.SlotConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "slotConstraint", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SlotType != nil {
		v := *s.SlotType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "slotType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SlotTypeVersion != nil {
		v := *s.SlotTypeVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "slotTypeVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ValueElicitationPrompt != nil {
		v := s.ValueElicitationPrompt

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "valueElicitationPrompt", v, metadata)
	}
	return nil
}

// Provides information about a slot type..
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/SlotTypeMetadata
type SlotTypeMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the slot type was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// A description of the slot type.
	Description *string `locationName:"description" type:"string"`

	// The date that the slot type was updated. When you create a resource, the
	// creation date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// The name of the slot type.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The version of the slot type.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s SlotTypeMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SlotTypeMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A collection of messages that convey information to the user. At runtime,
// Amazon Lex selects the message to convey.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/Statement
type Statement struct {
	_ struct{} `type:"structure"`

	// A collection of message objects.
	//
	// Messages is a required field
	Messages []Message `locationName:"messages" min:"1" type:"list" required:"true"`

	// At runtime, if the client is using the PostText (http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html)
	// API, Amazon Lex includes the response card in the response. It substitutes
	// all of the session attributes and slot values for placeholders in the response
	// card.
	ResponseCard *string `locationName:"responseCard" min:"1" type:"string"`
}

// String returns the string representation
func (s Statement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Statement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Statement"}

	if s.Messages == nil {
		invalidParams.Add(aws.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Messages", 1))
	}
	if s.ResponseCard != nil && len(*s.ResponseCard) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResponseCard", 1))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Statement) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Messages) > 0 {
		v := s.Messages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "messages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResponseCard != nil {
		v := *s.ResponseCard

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "responseCard", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about a single utterance that was made to your bot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/UtteranceData
type UtteranceData struct {
	_ struct{} `type:"structure"`

	// The number of times that the utterance was processed.
	Count *int64 `locationName:"count" type:"integer"`

	// The total number of individuals that used the utterance.
	DistinctUsers *int64 `locationName:"distinctUsers" type:"integer"`

	// The date that the utterance was first recorded.
	FirstUtteredDate *time.Time `locationName:"firstUtteredDate" type:"timestamp" timestampFormat:"unix"`

	// The date that the utterance was last recorded.
	LastUtteredDate *time.Time `locationName:"lastUtteredDate" type:"timestamp" timestampFormat:"unix"`

	// The text that was entered by the user or the text representation of an audio
	// clip.
	UtteranceString *string `locationName:"utteranceString" min:"1" type:"string"`
}

// String returns the string representation
func (s UtteranceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UtteranceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.DistinctUsers != nil {
		v := *s.DistinctUsers

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "distinctUsers", protocol.Int64Value(v), metadata)
	}
	if s.FirstUtteredDate != nil {
		v := *s.FirstUtteredDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "firstUtteredDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastUtteredDate != nil {
		v := *s.LastUtteredDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUtteredDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.UtteranceString != nil {
		v := *s.UtteranceString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "utteranceString", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides a list of utterances that have been made to a specific version of
// your bot. The list contains a maximum of 100 utterances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/UtteranceList
type UtteranceList struct {
	_ struct{} `type:"structure"`

	// The version of the bot that processed the list.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// One or more UtteranceData objects that contain information about the utterances
	// that have been made to a bot. The maximum number of object is 100.
	Utterances []UtteranceData `locationName:"utterances" type:"list"`
}

// String returns the string representation
func (s UtteranceList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UtteranceList) MarshalFields(e protocol.FieldEncoder) error {
	if s.BotVersion != nil {
		v := *s.BotVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "botVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Utterances) > 0 {
		v := s.Utterances

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "utterances", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}
