// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreamsRequest
type GetRelationalDatabaseLogStreamsInput struct {
	_ struct{} `type:"structure"`

	// The name of your database for which to get log streams.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseLogStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseLogStreamsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRelationalDatabaseLogStreamsInput"}

	if s.RelationalDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreamsResult
type GetRelationalDatabaseLogStreamsOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your get relational database log streams
	// request.
	LogStreams []string `locationName:"logStreams" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabaseLogStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRelationalDatabaseLogStreams = "GetRelationalDatabaseLogStreams"

// GetRelationalDatabaseLogStreamsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns a list of available log streams for a specific database in Amazon
// Lightsail.
//
//    // Example sending a request using GetRelationalDatabaseLogStreamsRequest.
//    req := client.GetRelationalDatabaseLogStreamsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams
func (c *Client) GetRelationalDatabaseLogStreamsRequest(input *GetRelationalDatabaseLogStreamsInput) GetRelationalDatabaseLogStreamsRequest {
	op := &aws.Operation{
		Name:       opGetRelationalDatabaseLogStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseLogStreamsInput{}
	}

	req := c.newRequest(op, input, &GetRelationalDatabaseLogStreamsOutput{})
	return GetRelationalDatabaseLogStreamsRequest{Request: req, Input: input, Copy: c.GetRelationalDatabaseLogStreamsRequest}
}

// GetRelationalDatabaseLogStreamsRequest is the request type for the
// GetRelationalDatabaseLogStreams API operation.
type GetRelationalDatabaseLogStreamsRequest struct {
	*aws.Request
	Input *GetRelationalDatabaseLogStreamsInput
	Copy  func(*GetRelationalDatabaseLogStreamsInput) GetRelationalDatabaseLogStreamsRequest
}

// Send marshals and sends the GetRelationalDatabaseLogStreams API request.
func (r GetRelationalDatabaseLogStreamsRequest) Send(ctx context.Context) (*GetRelationalDatabaseLogStreamsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRelationalDatabaseLogStreamsResponse{
		GetRelationalDatabaseLogStreamsOutput: r.Request.Data.(*GetRelationalDatabaseLogStreamsOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRelationalDatabaseLogStreamsResponse is the response type for the
// GetRelationalDatabaseLogStreams API operation.
type GetRelationalDatabaseLogStreamsResponse struct {
	*GetRelationalDatabaseLogStreamsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRelationalDatabaseLogStreams request.
func (r *GetRelationalDatabaseLogStreamsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
