// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstanceRequest
type RebootInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to reboot.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RebootInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebootInstanceInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstanceResult
type RebootInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operations.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s RebootInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opRebootInstance = "RebootInstance"

// RebootInstanceRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Restarts a specific instance.
//
// The reboot instance operation supports tag-based access control via resource
// tags applied to the resource identified by instanceName. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using RebootInstanceRequest.
//    req := client.RebootInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance
func (c *Client) RebootInstanceRequest(input *RebootInstanceInput) RebootInstanceRequest {
	op := &aws.Operation{
		Name:       opRebootInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstanceInput{}
	}

	req := c.newRequest(op, input, &RebootInstanceOutput{})
	return RebootInstanceRequest{Request: req, Input: input, Copy: c.RebootInstanceRequest}
}

// RebootInstanceRequest is the request type for the
// RebootInstance API operation.
type RebootInstanceRequest struct {
	*aws.Request
	Input *RebootInstanceInput
	Copy  func(*RebootInstanceInput) RebootInstanceRequest
}

// Send marshals and sends the RebootInstance API request.
func (r RebootInstanceRequest) Send(ctx context.Context) (*RebootInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RebootInstanceResponse{
		RebootInstanceOutput: r.Request.Data.(*RebootInstanceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RebootInstanceResponse is the response type for the
// RebootInstance API operation.
type RebootInstanceResponse struct {
	*RebootInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RebootInstance request.
func (r *RebootInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
