// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhub

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyMigrationTaskStateRequest
type NotifyMigrationTaskStateInput struct {
	_ struct{} `type:"structure"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// Unique identifier that references the migration task.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// Number of seconds after the UpdateDateTime within which the Migration Hub
	// can expect an update. If Migration Hub does not receive an update within
	// the specified interval, then the migration task will be considered stale.
	//
	// NextUpdateSeconds is a required field
	NextUpdateSeconds *int64 `type:"integer" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`

	// Information about the task's progress and status.
	//
	// Task is a required field
	Task *Task `type:"structure" required:"true"`

	// The timestamp when the task was gathered.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s NotifyMigrationTaskStateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyMigrationTaskStateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotifyMigrationTaskStateInput"}

	if s.MigrationTaskName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MigrationTaskName", 1))
	}

	if s.NextUpdateSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("NextUpdateSeconds"))
	}

	if s.ProgressUpdateStream == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if s.Task == nil {
		invalidParams.Add(aws.NewErrParamRequired("Task"))
	}

	if s.UpdateDateTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdateDateTime"))
	}
	if s.Task != nil {
		if err := s.Task.Validate(); err != nil {
			invalidParams.AddNested("Task", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyMigrationTaskStateResult
type NotifyMigrationTaskStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s NotifyMigrationTaskStateOutput) String() string {
	return awsutil.Prettify(s)
}

const opNotifyMigrationTaskState = "NotifyMigrationTaskState"

// NotifyMigrationTaskStateRequest returns a request value for making API operation for
// AWS Migration Hub.
//
// Notifies Migration Hub of the current status, progress, or other detail regarding
// a migration task. This API has the following traits:
//
//    * Migration tools will call the NotifyMigrationTaskState API to share
//    the latest progress and status.
//
//    * MigrationTaskName is used for addressing updates to the correct target.
//
//    * ProgressUpdateStream is used for access control and to provide a namespace
//    for each migration tool.
//
//    // Example sending a request using NotifyMigrationTaskStateRequest.
//    req := client.NotifyMigrationTaskStateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyMigrationTaskState
func (c *Client) NotifyMigrationTaskStateRequest(input *NotifyMigrationTaskStateInput) NotifyMigrationTaskStateRequest {
	op := &aws.Operation{
		Name:       opNotifyMigrationTaskState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NotifyMigrationTaskStateInput{}
	}

	req := c.newRequest(op, input, &NotifyMigrationTaskStateOutput{})
	return NotifyMigrationTaskStateRequest{Request: req, Input: input, Copy: c.NotifyMigrationTaskStateRequest}
}

// NotifyMigrationTaskStateRequest is the request type for the
// NotifyMigrationTaskState API operation.
type NotifyMigrationTaskStateRequest struct {
	*aws.Request
	Input *NotifyMigrationTaskStateInput
	Copy  func(*NotifyMigrationTaskStateInput) NotifyMigrationTaskStateRequest
}

// Send marshals and sends the NotifyMigrationTaskState API request.
func (r NotifyMigrationTaskStateRequest) Send(ctx context.Context) (*NotifyMigrationTaskStateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &NotifyMigrationTaskStateResponse{
		NotifyMigrationTaskStateOutput: r.Request.Data.(*NotifyMigrationTaskStateOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NotifyMigrationTaskStateResponse is the response type for the
// NotifyMigrationTaskState API operation.
type NotifyMigrationTaskStateResponse struct {
	*NotifyMigrationTaskStateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// NotifyMigrationTaskState request.
func (r *NotifyMigrationTaskStateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
