// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mq

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisionsRequest
type ListConfigurationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// ConfigurationId is a required field
	ConfigurationId *string `location:"uri" locationName:"configuration-id" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationRevisionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListConfigurationRevisionsInput"}

	if s.ConfigurationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConfigurationRevisionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ConfigurationId != nil {
		v := *s.ConfigurationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "configuration-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisionsResponse
type ListConfigurationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	ConfigurationId *string `locationName:"configurationId" type:"string"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Revisions []ConfigurationRevision `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s ListConfigurationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConfigurationRevisionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigurationId != nil {
		v := *s.ConfigurationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configurationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Revisions) > 0 {
		v := s.Revisions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "revisions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListConfigurationRevisions = "ListConfigurationRevisions"

// ListConfigurationRevisionsRequest returns a request value for making API operation for
// AmazonMQ.
//
// Returns a list of all revisions for the specified configuration.
//
//    // Example sending a request using ListConfigurationRevisionsRequest.
//    req := client.ListConfigurationRevisionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisions
func (c *Client) ListConfigurationRevisionsRequest(input *ListConfigurationRevisionsInput) ListConfigurationRevisionsRequest {
	op := &aws.Operation{
		Name:       opListConfigurationRevisions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{configuration-id}/revisions",
	}

	if input == nil {
		input = &ListConfigurationRevisionsInput{}
	}

	req := c.newRequest(op, input, &ListConfigurationRevisionsOutput{})
	return ListConfigurationRevisionsRequest{Request: req, Input: input, Copy: c.ListConfigurationRevisionsRequest}
}

// ListConfigurationRevisionsRequest is the request type for the
// ListConfigurationRevisions API operation.
type ListConfigurationRevisionsRequest struct {
	*aws.Request
	Input *ListConfigurationRevisionsInput
	Copy  func(*ListConfigurationRevisionsInput) ListConfigurationRevisionsRequest
}

// Send marshals and sends the ListConfigurationRevisions API request.
func (r ListConfigurationRevisionsRequest) Send(ctx context.Context) (*ListConfigurationRevisionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListConfigurationRevisionsResponse{
		ListConfigurationRevisionsOutput: r.Request.Data.(*ListConfigurationRevisionsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListConfigurationRevisionsResponse is the response type for the
// ListConfigurationRevisions API operation.
type ListConfigurationRevisionsResponse struct {
	*ListConfigurationRevisionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListConfigurationRevisions request.
func (r *ListConfigurationRevisionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
