// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteWorkerBlockRequest
type DeleteWorkerBlockInput struct {
	_ struct{} `type:"structure"`

	// A message that explains the reason for unblocking the Worker. The Worker
	// does not see this message.
	Reason *string `type:"string"`

	// The ID of the Worker to unblock.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkerBlockInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkerBlockInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteWorkerBlockInput"}

	if s.WorkerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteWorkerBlockResponse
type DeleteWorkerBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWorkerBlockOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteWorkerBlock = "DeleteWorkerBlock"

// DeleteWorkerBlockRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The DeleteWorkerBlock operation allows you to reinstate a blocked Worker
// to work on your HITs. This operation reverses the effects of the CreateWorkerBlock
// operation. You need the Worker ID to use this operation. If the Worker ID
// is missing or invalid, this operation fails and returns the message “WorkerId
// is invalid.” If the specified Worker is not blocked, this operation returns
// successfully.
//
//    // Example sending a request using DeleteWorkerBlockRequest.
//    req := client.DeleteWorkerBlockRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteWorkerBlock
func (c *Client) DeleteWorkerBlockRequest(input *DeleteWorkerBlockInput) DeleteWorkerBlockRequest {
	op := &aws.Operation{
		Name:       opDeleteWorkerBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkerBlockInput{}
	}

	req := c.newRequest(op, input, &DeleteWorkerBlockOutput{})
	return DeleteWorkerBlockRequest{Request: req, Input: input, Copy: c.DeleteWorkerBlockRequest}
}

// DeleteWorkerBlockRequest is the request type for the
// DeleteWorkerBlock API operation.
type DeleteWorkerBlockRequest struct {
	*aws.Request
	Input *DeleteWorkerBlockInput
	Copy  func(*DeleteWorkerBlockInput) DeleteWorkerBlockRequest
}

// Send marshals and sends the DeleteWorkerBlock API request.
func (r DeleteWorkerBlockRequest) Send(ctx context.Context) (*DeleteWorkerBlockResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteWorkerBlockResponse{
		DeleteWorkerBlockOutput: r.Request.Data.(*DeleteWorkerBlockOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteWorkerBlockResponse is the response type for the
// DeleteWorkerBlock API operation.
type DeleteWorkerBlockResponse struct {
	*DeleteWorkerBlockOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteWorkerBlock request.
func (r *DeleteWorkerBlockResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
