// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package polly

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexiconInput
type DeleteLexiconInput struct {
	_ struct{} `type:"structure"`

	// The name of the lexicon to delete. Must be an existing lexicon in the region.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"LexiconName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLexiconInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLexiconInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLexiconInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteLexiconInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "LexiconName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexiconOutput
type DeleteLexiconOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLexiconOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteLexiconOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteLexicon = "DeleteLexicon"

// DeleteLexiconRequest returns a request value for making API operation for
// Amazon Polly.
//
// Deletes the specified pronunciation lexicon stored in an AWS Region. A lexicon
// which has been deleted is not available for speech synthesis, nor is it possible
// to retrieve it using either the GetLexicon or ListLexicon APIs.
//
// For more information, see Managing Lexicons (http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
//    // Example sending a request using DeleteLexiconRequest.
//    req := client.DeleteLexiconRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexicon
func (c *Client) DeleteLexiconRequest(input *DeleteLexiconInput) DeleteLexiconRequest {
	op := &aws.Operation{
		Name:       opDeleteLexicon,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/lexicons/{LexiconName}",
	}

	if input == nil {
		input = &DeleteLexiconInput{}
	}

	req := c.newRequest(op, input, &DeleteLexiconOutput{})
	return DeleteLexiconRequest{Request: req, Input: input, Copy: c.DeleteLexiconRequest}
}

// DeleteLexiconRequest is the request type for the
// DeleteLexicon API operation.
type DeleteLexiconRequest struct {
	*aws.Request
	Input *DeleteLexiconInput
	Copy  func(*DeleteLexiconInput) DeleteLexiconRequest
}

// Send marshals and sends the DeleteLexicon API request.
func (r DeleteLexiconRequest) Send(ctx context.Context) (*DeleteLexiconResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLexiconResponse{
		DeleteLexiconOutput: r.Request.Data.(*DeleteLexiconOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLexiconResponse is the response type for the
// DeleteLexicon API operation.
type DeleteLexiconResponse struct {
	*DeleteLexiconOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLexicon request.
func (r *DeleteLexiconResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
