// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsiteRequest
type PutBucketWebsiteInput struct {
	_ struct{} `type:"structure" payload:"WebsiteConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// WebsiteConfiguration is a required field
	WebsiteConfiguration *WebsiteConfiguration `locationName:"WebsiteConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketWebsiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketWebsiteInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.WebsiteConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebsiteConfiguration"))
	}
	if s.WebsiteConfiguration != nil {
		if err := s.WebsiteConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WebsiteConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketWebsiteInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.WebsiteConfiguration != nil {
		v := s.WebsiteConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "WebsiteConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsiteOutput
type PutBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketWebsiteOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketWebsite = "PutBucketWebsite"

// PutBucketWebsiteRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Set the website configuration for a bucket.
//
//    // Example sending a request using PutBucketWebsiteRequest.
//    req := client.PutBucketWebsiteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *Client) PutBucketWebsiteRequest(input *PutBucketWebsiteInput) PutBucketWebsiteRequest {
	op := &aws.Operation{
		Name:       opPutBucketWebsite,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &PutBucketWebsiteInput{}
	}

	req := c.newRequest(op, input, &PutBucketWebsiteOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketWebsiteRequest{Request: req, Input: input, Copy: c.PutBucketWebsiteRequest}
}

// PutBucketWebsiteRequest is the request type for the
// PutBucketWebsite API operation.
type PutBucketWebsiteRequest struct {
	*aws.Request
	Input *PutBucketWebsiteInput
	Copy  func(*PutBucketWebsiteInput) PutBucketWebsiteRequest
}

// Send marshals and sends the PutBucketWebsite API request.
func (r PutBucketWebsiteRequest) Send(ctx context.Context) (*PutBucketWebsiteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketWebsiteResponse{
		PutBucketWebsiteOutput: r.Request.Data.(*PutBucketWebsiteOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketWebsiteResponse is the response type for the
// PutBucketWebsite API operation.
type PutBucketWebsiteResponse struct {
	*PutBucketWebsiteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketWebsite request.
func (r *PutBucketWebsiteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
