// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/AddPermissionRequest
type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS account number of the principal (http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P)
	// who is given permission. The principal must have an AWS account, but does
	// not need to be signed up for Amazon SQS. For information about locating the
	// AWS account identification, see Your AWS Identifiers (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication)
	// in the Amazon Simple Queue Service Developer Guide.
	//
	// AWSAccountIds is a required field
	AWSAccountIds []string `locationNameList:"AWSAccountId" type:"list" flattened:"true" required:"true"`

	// The action the client wants to allow for the specified principal. Valid values:
	// the name of any action or *.
	//
	// For more information about these actions, see Overview of Managing Access
	// Permissions to Your Amazon Simple Queue Service Resource (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html)
	// in the Amazon Simple Queue Service Developer Guide.
	//
	// Specifying SendMessage, DeleteMessage, or ChangeMessageVisibility for ActionName.n
	// also grants permissions for the corresponding batch versions of those actions:
	// SendMessageBatch, DeleteMessageBatch, and ChangeMessageVisibilityBatch.
	//
	// Actions is a required field
	Actions []string `locationNameList:"ActionName" type:"list" flattened:"true" required:"true"`

	// The unique identification of the permission you're setting (for example,
	// AliceSendMessage). Maximum 80 characters. Allowed characters include alphanumeric
	// characters, hyphens (-), and underscores (_).
	//
	// Label is a required field
	Label *string `type:"string" required:"true"`

	// The URL of the Amazon SQS queue to which permissions are added.
	//
	// Queue URLs and names are case-sensitive.
	//
	// QueueUrl is a required field
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddPermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddPermissionInput"}

	if s.AWSAccountIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AWSAccountIds"))
	}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}

	if s.Label == nil {
		invalidParams.Add(aws.NewErrParamRequired("Label"))
	}

	if s.QueueUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/AddPermissionOutput
type AddPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddPermission = "AddPermission"

// AddPermissionRequest returns a request value for making API operation for
// Amazon Simple Queue Service.
//
// Adds a permission to a queue for a specific principal (http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P).
// This allows sharing access to the queue.
//
// When you create a queue, you have full control access rights for the queue.
// Only you, the owner of the queue, can grant or deny permissions to the queue.
// For more information about these permissions, see Allow Developers to Write
// Messages to a Shared Queue (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue)
// in the Amazon Simple Queue Service Developer Guide.
//
// AddPermission writes an Amazon-SQS-generated policy. If you want to write
// your own policy, use SetQueueAttributes to upload your policy. For more information
// about writing your own policy, see Using Custom Policies with the Amazon
// SQS Access Policy Language (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-creating-custom-policies.html)
// in the Amazon Simple Queue Service Developer Guide.
//
// An Amazon SQS policy can have a maximum of 7 actions.
//
// Some actions take lists of parameters. These lists are specified using the
// param.n notation. Values of n are integers starting from 1. For example,
// a parameter list with two elements looks like this:
//
// &Attribute.1=first
//
// &Attribute.2=second
//
// Cross-account permissions don't apply to this action. For more information,
// see see Grant Cross-Account Permissions to a Role and a User Name (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
// in the Amazon Simple Queue Service Developer Guide.
//
//    // Example sending a request using AddPermissionRequest.
//    req := client.AddPermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/AddPermission
func (c *Client) AddPermissionRequest(input *AddPermissionInput) AddPermissionRequest {
	op := &aws.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	req := c.newRequest(op, input, &AddPermissionOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AddPermissionRequest{Request: req, Input: input, Copy: c.AddPermissionRequest}
}

// AddPermissionRequest is the request type for the
// AddPermission API operation.
type AddPermissionRequest struct {
	*aws.Request
	Input *AddPermissionInput
	Copy  func(*AddPermissionInput) AddPermissionRequest
}

// Send marshals and sends the AddPermission API request.
func (r AddPermissionRequest) Send(ctx context.Context) (*AddPermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddPermissionResponse{
		AddPermissionOutput: r.Request.Data.(*AddPermissionOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddPermissionResponse is the response type for the
// AddPermission API operation.
type AddPermissionResponse struct {
	*AddPermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddPermission request.
func (r *AddPermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
