// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServerRequest
type StartServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server that you start.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartServerInput"}

	if s.ServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServerOutput
type StartServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartServer = "StartServer"

// StartServerRequest returns a request value for making API operation for
// AWS Transfer for SFTP.
//
// Changes the state of a Secure File Transfer Protocol (SFTP) server from OFFLINE
// to ONLINE. It has no impact on an SFTP server that is already ONLINE. An
// ONLINE server can accept and process file transfer jobs.
//
// The state of STARTING indicates that the server is in an intermediate state,
// either not fully able to respond, or not fully online. The values of START_FAILED
// can indicate an error condition.
//
// No response is returned from this call.
//
//    // Example sending a request using StartServerRequest.
//    req := client.StartServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer
func (c *Client) StartServerRequest(input *StartServerInput) StartServerRequest {
	op := &aws.Operation{
		Name:       opStartServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartServerInput{}
	}

	req := c.newRequest(op, input, &StartServerOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StartServerRequest{Request: req, Input: input, Copy: c.StartServerRequest}
}

// StartServerRequest is the request type for the
// StartServer API operation.
type StartServerRequest struct {
	*aws.Request
	Input *StartServerInput
	Copy  func(*StartServerInput) StartServerRequest
}

// Send marshals and sends the StartServer API request.
func (r StartServerRequest) Send(ctx context.Context) (*StartServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartServerResponse{
		StartServerOutput: r.Request.Data.(*StartServerOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartServerResponse is the response type for the
// StartServer API operation.
type StartServerResponse struct {
	*StartServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartServer request.
func (r *StartServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
