// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package compute provides access to the Compute Engine API.
//
// For product documentation, see: https://cloud.google.com/compute/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/compute/v0.alpha"
//	...
//	ctx := context.Background()
//	computeService, err := compute.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//	computeService, err := compute.NewService(ctx, option.WithScopes(compute.DevstorageReadWriteScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	computeService, err := compute.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	computeService, err := compute.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package compute // import "google.golang.org/api/compute/v0.alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "compute:alpha"
const apiName = "compute"
const apiVersion = "alpha"
const basePath = "https://compute.googleapis.com/compute/alpha/"
const mtlsBasePath = "https://compute.mtls.googleapis.com/compute/alpha/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View and manage your Google Compute Engine resources
	ComputeScope = "https://www.googleapis.com/auth/compute"

	// View your Google Compute Engine resources
	ComputeReadonlyScope = "https://www.googleapis.com/auth/compute.readonly"

	// Manage your data and permissions in Cloud Storage and see the email
	// address for your Google Account
	DevstorageFullControlScope = "https://www.googleapis.com/auth/devstorage.full_control"

	// View your data in Google Cloud Storage
	DevstorageReadOnlyScope = "https://www.googleapis.com/auth/devstorage.read_only"

	// Manage your data in Cloud Storage and see the email address of your
	// Google Account
	DevstorageReadWriteScope = "https://www.googleapis.com/auth/devstorage.read_write"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/compute",
		"https://www.googleapis.com/auth/compute.readonly",
		"https://www.googleapis.com/auth/devstorage.full_control",
		"https://www.googleapis.com/auth/devstorage.read_only",
		"https://www.googleapis.com/auth/devstorage.read_write",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.AcceleratorTypes = NewAcceleratorTypesService(s)
	s.Addresses = NewAddressesService(s)
	s.Autoscalers = NewAutoscalersService(s)
	s.BackendBuckets = NewBackendBucketsService(s)
	s.BackendServices = NewBackendServicesService(s)
	s.DiskTypes = NewDiskTypesService(s)
	s.Disks = NewDisksService(s)
	s.ExternalVpnGateways = NewExternalVpnGatewaysService(s)
	s.FirewallPolicies = NewFirewallPoliciesService(s)
	s.Firewalls = NewFirewallsService(s)
	s.ForwardingRules = NewForwardingRulesService(s)
	s.FutureReservations = NewFutureReservationsService(s)
	s.GlobalAddresses = NewGlobalAddressesService(s)
	s.GlobalForwardingRules = NewGlobalForwardingRulesService(s)
	s.GlobalNetworkEndpointGroups = NewGlobalNetworkEndpointGroupsService(s)
	s.GlobalOperations = NewGlobalOperationsService(s)
	s.GlobalOrganizationOperations = NewGlobalOrganizationOperationsService(s)
	s.GlobalPublicDelegatedPrefixes = NewGlobalPublicDelegatedPrefixesService(s)
	s.HealthChecks = NewHealthChecksService(s)
	s.HttpHealthChecks = NewHttpHealthChecksService(s)
	s.HttpsHealthChecks = NewHttpsHealthChecksService(s)
	s.ImageFamilyViews = NewImageFamilyViewsService(s)
	s.Images = NewImagesService(s)
	s.InstanceGroupManagerResizeRequests = NewInstanceGroupManagerResizeRequestsService(s)
	s.InstanceGroupManagers = NewInstanceGroupManagersService(s)
	s.InstanceGroups = NewInstanceGroupsService(s)
	s.InstanceSettings = NewInstanceSettingsService(s)
	s.InstanceTemplates = NewInstanceTemplatesService(s)
	s.Instances = NewInstancesService(s)
	s.InstantSnapshots = NewInstantSnapshotsService(s)
	s.InterconnectAttachments = NewInterconnectAttachmentsService(s)
	s.InterconnectLocations = NewInterconnectLocationsService(s)
	s.InterconnectRemoteLocations = NewInterconnectRemoteLocationsService(s)
	s.Interconnects = NewInterconnectsService(s)
	s.LicenseCodes = NewLicenseCodesService(s)
	s.Licenses = NewLicensesService(s)
	s.MachineImages = NewMachineImagesService(s)
	s.MachineTypes = NewMachineTypesService(s)
	s.NetworkAttachments = NewNetworkAttachmentsService(s)
	s.NetworkEdgeSecurityServices = NewNetworkEdgeSecurityServicesService(s)
	s.NetworkEndpointGroups = NewNetworkEndpointGroupsService(s)
	s.NetworkFirewallPolicies = NewNetworkFirewallPoliciesService(s)
	s.Networks = NewNetworksService(s)
	s.NodeGroups = NewNodeGroupsService(s)
	s.NodeTemplates = NewNodeTemplatesService(s)
	s.NodeTypes = NewNodeTypesService(s)
	s.OrganizationSecurityPolicies = NewOrganizationSecurityPoliciesService(s)
	s.PacketMirrorings = NewPacketMirroringsService(s)
	s.Projects = NewProjectsService(s)
	s.PublicAdvertisedPrefixes = NewPublicAdvertisedPrefixesService(s)
	s.PublicDelegatedPrefixes = NewPublicDelegatedPrefixesService(s)
	s.RegionAutoscalers = NewRegionAutoscalersService(s)
	s.RegionBackendServices = NewRegionBackendServicesService(s)
	s.RegionCommitments = NewRegionCommitmentsService(s)
	s.RegionDiskTypes = NewRegionDiskTypesService(s)
	s.RegionDisks = NewRegionDisksService(s)
	s.RegionHealthCheckServices = NewRegionHealthCheckServicesService(s)
	s.RegionHealthChecks = NewRegionHealthChecksService(s)
	s.RegionInstanceGroupManagers = NewRegionInstanceGroupManagersService(s)
	s.RegionInstanceGroups = NewRegionInstanceGroupsService(s)
	s.RegionInstanceTemplates = NewRegionInstanceTemplatesService(s)
	s.RegionInstances = NewRegionInstancesService(s)
	s.RegionInstantSnapshots = NewRegionInstantSnapshotsService(s)
	s.RegionNetworkEndpointGroups = NewRegionNetworkEndpointGroupsService(s)
	s.RegionNetworkFirewallPolicies = NewRegionNetworkFirewallPoliciesService(s)
	s.RegionNotificationEndpoints = NewRegionNotificationEndpointsService(s)
	s.RegionOperations = NewRegionOperationsService(s)
	s.RegionSecurityPolicies = NewRegionSecurityPoliciesService(s)
	s.RegionSslCertificates = NewRegionSslCertificatesService(s)
	s.RegionSslPolicies = NewRegionSslPoliciesService(s)
	s.RegionTargetHttpProxies = NewRegionTargetHttpProxiesService(s)
	s.RegionTargetHttpsProxies = NewRegionTargetHttpsProxiesService(s)
	s.RegionTargetTcpProxies = NewRegionTargetTcpProxiesService(s)
	s.RegionUrlMaps = NewRegionUrlMapsService(s)
	s.Regions = NewRegionsService(s)
	s.Reservations = NewReservationsService(s)
	s.ResourcePolicies = NewResourcePoliciesService(s)
	s.Routers = NewRoutersService(s)
	s.Routes = NewRoutesService(s)
	s.SecurityPolicies = NewSecurityPoliciesService(s)
	s.ServiceAttachments = NewServiceAttachmentsService(s)
	s.Snapshots = NewSnapshotsService(s)
	s.SslCertificates = NewSslCertificatesService(s)
	s.SslPolicies = NewSslPoliciesService(s)
	s.StoragePools = NewStoragePoolsService(s)
	s.Subnetworks = NewSubnetworksService(s)
	s.TargetGrpcProxies = NewTargetGrpcProxiesService(s)
	s.TargetHttpProxies = NewTargetHttpProxiesService(s)
	s.TargetHttpsProxies = NewTargetHttpsProxiesService(s)
	s.TargetInstances = NewTargetInstancesService(s)
	s.TargetPools = NewTargetPoolsService(s)
	s.TargetSslProxies = NewTargetSslProxiesService(s)
	s.TargetTcpProxies = NewTargetTcpProxiesService(s)
	s.TargetVpnGateways = NewTargetVpnGatewaysService(s)
	s.UrlMaps = NewUrlMapsService(s)
	s.VpnGateways = NewVpnGatewaysService(s)
	s.VpnTunnels = NewVpnTunnelsService(s)
	s.ZoneOperations = NewZoneOperationsService(s)
	s.ZoneQueuedResources = NewZoneQueuedResourcesService(s)
	s.Zones = NewZonesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AcceleratorTypes *AcceleratorTypesService

	Addresses *AddressesService

	Autoscalers *AutoscalersService

	BackendBuckets *BackendBucketsService

	BackendServices *BackendServicesService

	DiskTypes *DiskTypesService

	Disks *DisksService

	ExternalVpnGateways *ExternalVpnGatewaysService

	FirewallPolicies *FirewallPoliciesService

	Firewalls *FirewallsService

	ForwardingRules *ForwardingRulesService

	FutureReservations *FutureReservationsService

	GlobalAddresses *GlobalAddressesService

	GlobalForwardingRules *GlobalForwardingRulesService

	GlobalNetworkEndpointGroups *GlobalNetworkEndpointGroupsService

	GlobalOperations *GlobalOperationsService

	GlobalOrganizationOperations *GlobalOrganizationOperationsService

	GlobalPublicDelegatedPrefixes *GlobalPublicDelegatedPrefixesService

	HealthChecks *HealthChecksService

	HttpHealthChecks *HttpHealthChecksService

	HttpsHealthChecks *HttpsHealthChecksService

	ImageFamilyViews *ImageFamilyViewsService

	Images *ImagesService

	InstanceGroupManagerResizeRequests *InstanceGroupManagerResizeRequestsService

	InstanceGroupManagers *InstanceGroupManagersService

	InstanceGroups *InstanceGroupsService

	InstanceSettings *InstanceSettingsService

	InstanceTemplates *InstanceTemplatesService

	Instances *InstancesService

	InstantSnapshots *InstantSnapshotsService

	InterconnectAttachments *InterconnectAttachmentsService

	InterconnectLocations *InterconnectLocationsService

	InterconnectRemoteLocations *InterconnectRemoteLocationsService

	Interconnects *InterconnectsService

	LicenseCodes *LicenseCodesService

	Licenses *LicensesService

	MachineImages *MachineImagesService

	MachineTypes *MachineTypesService

	NetworkAttachments *NetworkAttachmentsService

	NetworkEdgeSecurityServices *NetworkEdgeSecurityServicesService

	NetworkEndpointGroups *NetworkEndpointGroupsService

	NetworkFirewallPolicies *NetworkFirewallPoliciesService

	Networks *NetworksService

	NodeGroups *NodeGroupsService

	NodeTemplates *NodeTemplatesService

	NodeTypes *NodeTypesService

	OrganizationSecurityPolicies *OrganizationSecurityPoliciesService

	PacketMirrorings *PacketMirroringsService

	Projects *ProjectsService

	PublicAdvertisedPrefixes *PublicAdvertisedPrefixesService

	PublicDelegatedPrefixes *PublicDelegatedPrefixesService

	RegionAutoscalers *RegionAutoscalersService

	RegionBackendServices *RegionBackendServicesService

	RegionCommitments *RegionCommitmentsService

	RegionDiskTypes *RegionDiskTypesService

	RegionDisks *RegionDisksService

	RegionHealthCheckServices *RegionHealthCheckServicesService

	RegionHealthChecks *RegionHealthChecksService

	RegionInstanceGroupManagers *RegionInstanceGroupManagersService

	RegionInstanceGroups *RegionInstanceGroupsService

	RegionInstanceTemplates *RegionInstanceTemplatesService

	RegionInstances *RegionInstancesService

	RegionInstantSnapshots *RegionInstantSnapshotsService

	RegionNetworkEndpointGroups *RegionNetworkEndpointGroupsService

	RegionNetworkFirewallPolicies *RegionNetworkFirewallPoliciesService

	RegionNotificationEndpoints *RegionNotificationEndpointsService

	RegionOperations *RegionOperationsService

	RegionSecurityPolicies *RegionSecurityPoliciesService

	RegionSslCertificates *RegionSslCertificatesService

	RegionSslPolicies *RegionSslPoliciesService

	RegionTargetHttpProxies *RegionTargetHttpProxiesService

	RegionTargetHttpsProxies *RegionTargetHttpsProxiesService

	RegionTargetTcpProxies *RegionTargetTcpProxiesService

	RegionUrlMaps *RegionUrlMapsService

	Regions *RegionsService

	Reservations *ReservationsService

	ResourcePolicies *ResourcePoliciesService

	Routers *RoutersService

	Routes *RoutesService

	SecurityPolicies *SecurityPoliciesService

	ServiceAttachments *ServiceAttachmentsService

	Snapshots *SnapshotsService

	SslCertificates *SslCertificatesService

	SslPolicies *SslPoliciesService

	StoragePools *StoragePoolsService

	Subnetworks *SubnetworksService

	TargetGrpcProxies *TargetGrpcProxiesService

	TargetHttpProxies *TargetHttpProxiesService

	TargetHttpsProxies *TargetHttpsProxiesService

	TargetInstances *TargetInstancesService

	TargetPools *TargetPoolsService

	TargetSslProxies *TargetSslProxiesService

	TargetTcpProxies *TargetTcpProxiesService

	TargetVpnGateways *TargetVpnGatewaysService

	UrlMaps *UrlMapsService

	VpnGateways *VpnGatewaysService

	VpnTunnels *VpnTunnelsService

	ZoneOperations *ZoneOperationsService

	ZoneQueuedResources *ZoneQueuedResourcesService

	Zones *ZonesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAcceleratorTypesService(s *Service) *AcceleratorTypesService {
	rs := &AcceleratorTypesService{s: s}
	return rs
}

type AcceleratorTypesService struct {
	s *Service
}

func NewAddressesService(s *Service) *AddressesService {
	rs := &AddressesService{s: s}
	return rs
}

type AddressesService struct {
	s *Service
}

func NewAutoscalersService(s *Service) *AutoscalersService {
	rs := &AutoscalersService{s: s}
	return rs
}

type AutoscalersService struct {
	s *Service
}

func NewBackendBucketsService(s *Service) *BackendBucketsService {
	rs := &BackendBucketsService{s: s}
	return rs
}

type BackendBucketsService struct {
	s *Service
}

func NewBackendServicesService(s *Service) *BackendServicesService {
	rs := &BackendServicesService{s: s}
	return rs
}

type BackendServicesService struct {
	s *Service
}

func NewDiskTypesService(s *Service) *DiskTypesService {
	rs := &DiskTypesService{s: s}
	return rs
}

type DiskTypesService struct {
	s *Service
}

func NewDisksService(s *Service) *DisksService {
	rs := &DisksService{s: s}
	return rs
}

type DisksService struct {
	s *Service
}

func NewExternalVpnGatewaysService(s *Service) *ExternalVpnGatewaysService {
	rs := &ExternalVpnGatewaysService{s: s}
	return rs
}

type ExternalVpnGatewaysService struct {
	s *Service
}

func NewFirewallPoliciesService(s *Service) *FirewallPoliciesService {
	rs := &FirewallPoliciesService{s: s}
	return rs
}

type FirewallPoliciesService struct {
	s *Service
}

func NewFirewallsService(s *Service) *FirewallsService {
	rs := &FirewallsService{s: s}
	return rs
}

type FirewallsService struct {
	s *Service
}

func NewForwardingRulesService(s *Service) *ForwardingRulesService {
	rs := &ForwardingRulesService{s: s}
	return rs
}

type ForwardingRulesService struct {
	s *Service
}

func NewFutureReservationsService(s *Service) *FutureReservationsService {
	rs := &FutureReservationsService{s: s}
	return rs
}

type FutureReservationsService struct {
	s *Service
}

func NewGlobalAddressesService(s *Service) *GlobalAddressesService {
	rs := &GlobalAddressesService{s: s}
	return rs
}

type GlobalAddressesService struct {
	s *Service
}

func NewGlobalForwardingRulesService(s *Service) *GlobalForwardingRulesService {
	rs := &GlobalForwardingRulesService{s: s}
	return rs
}

type GlobalForwardingRulesService struct {
	s *Service
}

func NewGlobalNetworkEndpointGroupsService(s *Service) *GlobalNetworkEndpointGroupsService {
	rs := &GlobalNetworkEndpointGroupsService{s: s}
	return rs
}

type GlobalNetworkEndpointGroupsService struct {
	s *Service
}

func NewGlobalOperationsService(s *Service) *GlobalOperationsService {
	rs := &GlobalOperationsService{s: s}
	return rs
}

type GlobalOperationsService struct {
	s *Service
}

func NewGlobalOrganizationOperationsService(s *Service) *GlobalOrganizationOperationsService {
	rs := &GlobalOrganizationOperationsService{s: s}
	return rs
}

type GlobalOrganizationOperationsService struct {
	s *Service
}

func NewGlobalPublicDelegatedPrefixesService(s *Service) *GlobalPublicDelegatedPrefixesService {
	rs := &GlobalPublicDelegatedPrefixesService{s: s}
	return rs
}

type GlobalPublicDelegatedPrefixesService struct {
	s *Service
}

func NewHealthChecksService(s *Service) *HealthChecksService {
	rs := &HealthChecksService{s: s}
	return rs
}

type HealthChecksService struct {
	s *Service
}

func NewHttpHealthChecksService(s *Service) *HttpHealthChecksService {
	rs := &HttpHealthChecksService{s: s}
	return rs
}

type HttpHealthChecksService struct {
	s *Service
}

func NewHttpsHealthChecksService(s *Service) *HttpsHealthChecksService {
	rs := &HttpsHealthChecksService{s: s}
	return rs
}

type HttpsHealthChecksService struct {
	s *Service
}

func NewImageFamilyViewsService(s *Service) *ImageFamilyViewsService {
	rs := &ImageFamilyViewsService{s: s}
	return rs
}

type ImageFamilyViewsService struct {
	s *Service
}

func NewImagesService(s *Service) *ImagesService {
	rs := &ImagesService{s: s}
	return rs
}

type ImagesService struct {
	s *Service
}

func NewInstanceGroupManagerResizeRequestsService(s *Service) *InstanceGroupManagerResizeRequestsService {
	rs := &InstanceGroupManagerResizeRequestsService{s: s}
	return rs
}

type InstanceGroupManagerResizeRequestsService struct {
	s *Service
}

func NewInstanceGroupManagersService(s *Service) *InstanceGroupManagersService {
	rs := &InstanceGroupManagersService{s: s}
	return rs
}

type InstanceGroupManagersService struct {
	s *Service
}

func NewInstanceGroupsService(s *Service) *InstanceGroupsService {
	rs := &InstanceGroupsService{s: s}
	return rs
}

type InstanceGroupsService struct {
	s *Service
}

func NewInstanceSettingsService(s *Service) *InstanceSettingsService {
	rs := &InstanceSettingsService{s: s}
	return rs
}

type InstanceSettingsService struct {
	s *Service
}

func NewInstanceTemplatesService(s *Service) *InstanceTemplatesService {
	rs := &InstanceTemplatesService{s: s}
	return rs
}

type InstanceTemplatesService struct {
	s *Service
}

func NewInstancesService(s *Service) *InstancesService {
	rs := &InstancesService{s: s}
	return rs
}

type InstancesService struct {
	s *Service
}

func NewInstantSnapshotsService(s *Service) *InstantSnapshotsService {
	rs := &InstantSnapshotsService{s: s}
	return rs
}

type InstantSnapshotsService struct {
	s *Service
}

func NewInterconnectAttachmentsService(s *Service) *InterconnectAttachmentsService {
	rs := &InterconnectAttachmentsService{s: s}
	return rs
}

type InterconnectAttachmentsService struct {
	s *Service
}

func NewInterconnectLocationsService(s *Service) *InterconnectLocationsService {
	rs := &InterconnectLocationsService{s: s}
	return rs
}

type InterconnectLocationsService struct {
	s *Service
}

func NewInterconnectRemoteLocationsService(s *Service) *InterconnectRemoteLocationsService {
	rs := &InterconnectRemoteLocationsService{s: s}
	return rs
}

type InterconnectRemoteLocationsService struct {
	s *Service
}

func NewInterconnectsService(s *Service) *InterconnectsService {
	rs := &InterconnectsService{s: s}
	return rs
}

type InterconnectsService struct {
	s *Service
}

func NewLicenseCodesService(s *Service) *LicenseCodesService {
	rs := &LicenseCodesService{s: s}
	return rs
}

type LicenseCodesService struct {
	s *Service
}

func NewLicensesService(s *Service) *LicensesService {
	rs := &LicensesService{s: s}
	return rs
}

type LicensesService struct {
	s *Service
}

func NewMachineImagesService(s *Service) *MachineImagesService {
	rs := &MachineImagesService{s: s}
	return rs
}

type MachineImagesService struct {
	s *Service
}

func NewMachineTypesService(s *Service) *MachineTypesService {
	rs := &MachineTypesService{s: s}
	return rs
}

type MachineTypesService struct {
	s *Service
}

func NewNetworkAttachmentsService(s *Service) *NetworkAttachmentsService {
	rs := &NetworkAttachmentsService{s: s}
	return rs
}

type NetworkAttachmentsService struct {
	s *Service
}

func NewNetworkEdgeSecurityServicesService(s *Service) *NetworkEdgeSecurityServicesService {
	rs := &NetworkEdgeSecurityServicesService{s: s}
	return rs
}

type NetworkEdgeSecurityServicesService struct {
	s *Service
}

func NewNetworkEndpointGroupsService(s *Service) *NetworkEndpointGroupsService {
	rs := &NetworkEndpointGroupsService{s: s}
	return rs
}

type NetworkEndpointGroupsService struct {
	s *Service
}

func NewNetworkFirewallPoliciesService(s *Service) *NetworkFirewallPoliciesService {
	rs := &NetworkFirewallPoliciesService{s: s}
	return rs
}

type NetworkFirewallPoliciesService struct {
	s *Service
}

func NewNetworksService(s *Service) *NetworksService {
	rs := &NetworksService{s: s}
	return rs
}

type NetworksService struct {
	s *Service
}

func NewNodeGroupsService(s *Service) *NodeGroupsService {
	rs := &NodeGroupsService{s: s}
	return rs
}

type NodeGroupsService struct {
	s *Service
}

func NewNodeTemplatesService(s *Service) *NodeTemplatesService {
	rs := &NodeTemplatesService{s: s}
	return rs
}

type NodeTemplatesService struct {
	s *Service
}

func NewNodeTypesService(s *Service) *NodeTypesService {
	rs := &NodeTypesService{s: s}
	return rs
}

type NodeTypesService struct {
	s *Service
}

func NewOrganizationSecurityPoliciesService(s *Service) *OrganizationSecurityPoliciesService {
	rs := &OrganizationSecurityPoliciesService{s: s}
	return rs
}

type OrganizationSecurityPoliciesService struct {
	s *Service
}

func NewPacketMirroringsService(s *Service) *PacketMirroringsService {
	rs := &PacketMirroringsService{s: s}
	return rs
}

type PacketMirroringsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	return rs
}

type ProjectsService struct {
	s *Service
}

func NewPublicAdvertisedPrefixesService(s *Service) *PublicAdvertisedPrefixesService {
	rs := &PublicAdvertisedPrefixesService{s: s}
	return rs
}

type PublicAdvertisedPrefixesService struct {
	s *Service
}

func NewPublicDelegatedPrefixesService(s *Service) *PublicDelegatedPrefixesService {
	rs := &PublicDelegatedPrefixesService{s: s}
	return rs
}

type PublicDelegatedPrefixesService struct {
	s *Service
}

func NewRegionAutoscalersService(s *Service) *RegionAutoscalersService {
	rs := &RegionAutoscalersService{s: s}
	return rs
}

type RegionAutoscalersService struct {
	s *Service
}

func NewRegionBackendServicesService(s *Service) *RegionBackendServicesService {
	rs := &RegionBackendServicesService{s: s}
	return rs
}

type RegionBackendServicesService struct {
	s *Service
}

func NewRegionCommitmentsService(s *Service) *RegionCommitmentsService {
	rs := &RegionCommitmentsService{s: s}
	return rs
}

type RegionCommitmentsService struct {
	s *Service
}

func NewRegionDiskTypesService(s *Service) *RegionDiskTypesService {
	rs := &RegionDiskTypesService{s: s}
	return rs
}

type RegionDiskTypesService struct {
	s *Service
}

func NewRegionDisksService(s *Service) *RegionDisksService {
	rs := &RegionDisksService{s: s}
	return rs
}

type RegionDisksService struct {
	s *Service
}

func NewRegionHealthCheckServicesService(s *Service) *RegionHealthCheckServicesService {
	rs := &RegionHealthCheckServicesService{s: s}
	return rs
}

type RegionHealthCheckServicesService struct {
	s *Service
}

func NewRegionHealthChecksService(s *Service) *RegionHealthChecksService {
	rs := &RegionHealthChecksService{s: s}
	return rs
}

type RegionHealthChecksService struct {
	s *Service
}

func NewRegionInstanceGroupManagersService(s *Service) *RegionInstanceGroupManagersService {
	rs := &RegionInstanceGroupManagersService{s: s}
	return rs
}

type RegionInstanceGroupManagersService struct {
	s *Service
}

func NewRegionInstanceGroupsService(s *Service) *RegionInstanceGroupsService {
	rs := &RegionInstanceGroupsService{s: s}
	return rs
}

type RegionInstanceGroupsService struct {
	s *Service
}

func NewRegionInstanceTemplatesService(s *Service) *RegionInstanceTemplatesService {
	rs := &RegionInstanceTemplatesService{s: s}
	return rs
}

type RegionInstanceTemplatesService struct {
	s *Service
}

func NewRegionInstancesService(s *Service) *RegionInstancesService {
	rs := &RegionInstancesService{s: s}
	return rs
}

type RegionInstancesService struct {
	s *Service
}

func NewRegionInstantSnapshotsService(s *Service) *RegionInstantSnapshotsService {
	rs := &RegionInstantSnapshotsService{s: s}
	return rs
}

type RegionInstantSnapshotsService struct {
	s *Service
}

func NewRegionNetworkEndpointGroupsService(s *Service) *RegionNetworkEndpointGroupsService {
	rs := &RegionNetworkEndpointGroupsService{s: s}
	return rs
}

type RegionNetworkEndpointGroupsService struct {
	s *Service
}

func NewRegionNetworkFirewallPoliciesService(s *Service) *RegionNetworkFirewallPoliciesService {
	rs := &RegionNetworkFirewallPoliciesService{s: s}
	return rs
}

type RegionNetworkFirewallPoliciesService struct {
	s *Service
}

func NewRegionNotificationEndpointsService(s *Service) *RegionNotificationEndpointsService {
	rs := &RegionNotificationEndpointsService{s: s}
	return rs
}

type RegionNotificationEndpointsService struct {
	s *Service
}

func NewRegionOperationsService(s *Service) *RegionOperationsService {
	rs := &RegionOperationsService{s: s}
	return rs
}

type RegionOperationsService struct {
	s *Service
}

func NewRegionSecurityPoliciesService(s *Service) *RegionSecurityPoliciesService {
	rs := &RegionSecurityPoliciesService{s: s}
	return rs
}

type RegionSecurityPoliciesService struct {
	s *Service
}

func NewRegionSslCertificatesService(s *Service) *RegionSslCertificatesService {
	rs := &RegionSslCertificatesService{s: s}
	return rs
}

type RegionSslCertificatesService struct {
	s *Service
}

func NewRegionSslPoliciesService(s *Service) *RegionSslPoliciesService {
	rs := &RegionSslPoliciesService{s: s}
	return rs
}

type RegionSslPoliciesService struct {
	s *Service
}

func NewRegionTargetHttpProxiesService(s *Service) *RegionTargetHttpProxiesService {
	rs := &RegionTargetHttpProxiesService{s: s}
	return rs
}

type RegionTargetHttpProxiesService struct {
	s *Service
}

func NewRegionTargetHttpsProxiesService(s *Service) *RegionTargetHttpsProxiesService {
	rs := &RegionTargetHttpsProxiesService{s: s}
	return rs
}

type RegionTargetHttpsProxiesService struct {
	s *Service
}

func NewRegionTargetTcpProxiesService(s *Service) *RegionTargetTcpProxiesService {
	rs := &RegionTargetTcpProxiesService{s: s}
	return rs
}

type RegionTargetTcpProxiesService struct {
	s *Service
}

func NewRegionUrlMapsService(s *Service) *RegionUrlMapsService {
	rs := &RegionUrlMapsService{s: s}
	return rs
}

type RegionUrlMapsService struct {
	s *Service
}

func NewRegionsService(s *Service) *RegionsService {
	rs := &RegionsService{s: s}
	return rs
}

type RegionsService struct {
	s *Service
}

func NewReservationsService(s *Service) *ReservationsService {
	rs := &ReservationsService{s: s}
	return rs
}

type ReservationsService struct {
	s *Service
}

func NewResourcePoliciesService(s *Service) *ResourcePoliciesService {
	rs := &ResourcePoliciesService{s: s}
	return rs
}

type ResourcePoliciesService struct {
	s *Service
}

func NewRoutersService(s *Service) *RoutersService {
	rs := &RoutersService{s: s}
	return rs
}

type RoutersService struct {
	s *Service
}

func NewRoutesService(s *Service) *RoutesService {
	rs := &RoutesService{s: s}
	return rs
}

type RoutesService struct {
	s *Service
}

func NewSecurityPoliciesService(s *Service) *SecurityPoliciesService {
	rs := &SecurityPoliciesService{s: s}
	return rs
}

type SecurityPoliciesService struct {
	s *Service
}

func NewServiceAttachmentsService(s *Service) *ServiceAttachmentsService {
	rs := &ServiceAttachmentsService{s: s}
	return rs
}

type ServiceAttachmentsService struct {
	s *Service
}

func NewSnapshotsService(s *Service) *SnapshotsService {
	rs := &SnapshotsService{s: s}
	return rs
}

type SnapshotsService struct {
	s *Service
}

func NewSslCertificatesService(s *Service) *SslCertificatesService {
	rs := &SslCertificatesService{s: s}
	return rs
}

type SslCertificatesService struct {
	s *Service
}

func NewSslPoliciesService(s *Service) *SslPoliciesService {
	rs := &SslPoliciesService{s: s}
	return rs
}

type SslPoliciesService struct {
	s *Service
}

func NewStoragePoolsService(s *Service) *StoragePoolsService {
	rs := &StoragePoolsService{s: s}
	return rs
}

type StoragePoolsService struct {
	s *Service
}

func NewSubnetworksService(s *Service) *SubnetworksService {
	rs := &SubnetworksService{s: s}
	return rs
}

type SubnetworksService struct {
	s *Service
}

func NewTargetGrpcProxiesService(s *Service) *TargetGrpcProxiesService {
	rs := &TargetGrpcProxiesService{s: s}
	return rs
}

type TargetGrpcProxiesService struct {
	s *Service
}

func NewTargetHttpProxiesService(s *Service) *TargetHttpProxiesService {
	rs := &TargetHttpProxiesService{s: s}
	return rs
}

type TargetHttpProxiesService struct {
	s *Service
}

func NewTargetHttpsProxiesService(s *Service) *TargetHttpsProxiesService {
	rs := &TargetHttpsProxiesService{s: s}
	return rs
}

type TargetHttpsProxiesService struct {
	s *Service
}

func NewTargetInstancesService(s *Service) *TargetInstancesService {
	rs := &TargetInstancesService{s: s}
	return rs
}

type TargetInstancesService struct {
	s *Service
}

func NewTargetPoolsService(s *Service) *TargetPoolsService {
	rs := &TargetPoolsService{s: s}
	return rs
}

type TargetPoolsService struct {
	s *Service
}

func NewTargetSslProxiesService(s *Service) *TargetSslProxiesService {
	rs := &TargetSslProxiesService{s: s}
	return rs
}

type TargetSslProxiesService struct {
	s *Service
}

func NewTargetTcpProxiesService(s *Service) *TargetTcpProxiesService {
	rs := &TargetTcpProxiesService{s: s}
	return rs
}

type TargetTcpProxiesService struct {
	s *Service
}

func NewTargetVpnGatewaysService(s *Service) *TargetVpnGatewaysService {
	rs := &TargetVpnGatewaysService{s: s}
	return rs
}

type TargetVpnGatewaysService struct {
	s *Service
}

func NewUrlMapsService(s *Service) *UrlMapsService {
	rs := &UrlMapsService{s: s}
	return rs
}

type UrlMapsService struct {
	s *Service
}

func NewVpnGatewaysService(s *Service) *VpnGatewaysService {
	rs := &VpnGatewaysService{s: s}
	return rs
}

type VpnGatewaysService struct {
	s *Service
}

func NewVpnTunnelsService(s *Service) *VpnTunnelsService {
	rs := &VpnTunnelsService{s: s}
	return rs
}

type VpnTunnelsService struct {
	s *Service
}

func NewZoneOperationsService(s *Service) *ZoneOperationsService {
	rs := &ZoneOperationsService{s: s}
	return rs
}

type ZoneOperationsService struct {
	s *Service
}

func NewZoneQueuedResourcesService(s *Service) *ZoneQueuedResourcesService {
	rs := &ZoneQueuedResourcesService{s: s}
	return rs
}

type ZoneQueuedResourcesService struct {
	s *Service
}

func NewZonesService(s *Service) *ZonesService {
	rs := &ZonesService{s: s}
	return rs
}

type ZonesService struct {
	s *Service
}

// AWSV4Signature: Contains the configurations necessary to generate a
// signature for access to private storage buckets that support
// Signature Version 4 for authentication. The service name for
// generating the authentication header will always default to 's3'.
type AWSV4Signature struct {
	// AccessKey: The access key used for s3 bucket authentication. Required
	// for updating or creating a backend that uses AWS v4 signature
	// authentication, but will not be returned as part of the configuration
	// when queried with a REST API GET request. @InputOnly
	AccessKey string `json:"accessKey,omitempty"`

	// AccessKeyId: The identifier of an access key used for s3 bucket
	// authentication.
	AccessKeyId string `json:"accessKeyId,omitempty"`

	// AccessKeyVersion: The optional version identifier for the access key.
	// You can use this to keep track of different iterations of your access
	// key.
	AccessKeyVersion string `json:"accessKeyVersion,omitempty"`

	// OriginRegion: The name of the cloud region of your origin. This is a
	// free-form field with the name of the region your cloud uses to host
	// your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for
	// OCI.
	OriginRegion string `json:"originRegion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessKey") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AWSV4Signature) MarshalJSON() ([]byte, error) {
	type NoMethod AWSV4Signature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorConfig: A specification of the type and number of
// accelerator cards attached to the instance.
type AcceleratorConfig struct {
	// AcceleratorCount: The number of the guest accelerator cards exposed
	// to this instance.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty"`

	// AcceleratorType: Full or partial URL of the accelerator type resource
	// to attach to this instance. For example:
	// projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-
	// p100 If you are creating an instance template, specify only the
	// accelerator name. See GPUs on Compute Engine for a full list of
	// accelerator types.
	AcceleratorType string `json:"acceleratorType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceleratorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorType: Represents an Accelerator Type resource. Google
// Cloud Platform provides graphics processing units (accelerators) that
// you can add to VM instances to improve or accelerate performance when
// working with intensive workloads. For more information, read GPUs on
// Compute Engine.
type AcceleratorType struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Deprecated -- [Output Only] The deprecation status associated with
	// this accelerator type.
	Deprecated *DeprecationStatus `json:"deprecated,omitempty"`

	// Description: [Output Only] An optional textual description of the
	// resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] The type of the resource. Always
	// compute#acceleratorType for accelerator types.
	Kind string `json:"kind,omitempty"`

	// MaximumCardsPerInstance: [Output Only] Maximum number of accelerator
	// cards allowed per instance.
	MaximumCardsPerInstance int64 `json:"maximumCardsPerInstance,omitempty"`

	// Name: [Output Only] Name of the resource.
	Name string `json:"name,omitempty"`

	// SelfLink: [Output Only] Server-defined, fully qualified URL for this
	// resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Zone: [Output Only] The name of the zone where the accelerator type
	// resides, such as us-central1-a. You must specify this field as part
	// of the HTTP request URL. It is not settable as a field in the request
	// body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorType) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypeAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AcceleratorTypesScopedList resources.
	Items map[string]AcceleratorTypesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#acceleratorTypeAggregatedList for aggregated lists of
	// accelerator types.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AcceleratorTypeAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypeAggregatedListWarning: [Output Only] Informational
// warning message.
type AcceleratorTypeAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AcceleratorTypeAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypeAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypeList: Contains a list of accelerator types.
type AcceleratorTypeList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AcceleratorType resources.
	Items []*AcceleratorType `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#acceleratorTypeList for lists of accelerator types.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AcceleratorTypeListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeList) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypeListWarning: [Output Only] Informational warning
// message.
type AcceleratorTypeListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AcceleratorTypeListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypeListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypesScopedList struct {
	// AcceleratorTypes: [Output Only] A list of accelerator types contained
	// in this scope.
	AcceleratorTypes []*AcceleratorType `json:"acceleratorTypes,omitempty"`

	// Warning: [Output Only] An informational warning that appears when the
	// accelerator types list is empty.
	Warning *AcceleratorTypesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceleratorTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceleratorTypes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypesScopedListWarning: [Output Only] An informational
// warning that appears when the accelerator types list is empty.
type AcceleratorTypesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AcceleratorTypesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccessConfig: An access configuration attached to an instance's
// network interface. Only one access config per instance is supported.
type AccessConfig struct {
	// ExternalIpv6: Applies to ipv6AccessConfigs only. The first IPv6
	// address of the external IPv6 range associated with this instance,
	// prefix length is stored in externalIpv6PrefixLength in
	// ipv6AccessConfig. To use a static external IP address, it must be
	// unused and in the same region as the instance's zone. If not
	// specified, Google Cloud will automatically assign an external IPv6
	// address from the instance's subnetwork.
	ExternalIpv6 string `json:"externalIpv6,omitempty"`

	// ExternalIpv6PrefixLength: Applies to ipv6AccessConfigs only. The
	// prefix length of the external IPv6 range.
	ExternalIpv6PrefixLength int64 `json:"externalIpv6PrefixLength,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#accessConfig
	// for access configs.
	Kind string `json:"kind,omitempty"`

	// Name: The name of this access configuration. In accessConfigs (IPv4),
	// the default and recommended name is External NAT, but you can use any
	// arbitrary string, such as My external IP or Network Access. In
	// ipv6AccessConfigs, the recommend name is External IPv6.
	Name string `json:"name,omitempty"`

	// NatIP: Applies to accessConfigs (IPv4) only. An external IP address
	// associated with this instance. Specify an unused static external IP
	// address available to the project or leave this field undefined to use
	// an IP from a shared ephemeral IP address pool. If you specify a
	// static external IP address, it must live in the same region as the
	// zone of the instance.
	NatIP string `json:"natIP,omitempty"`

	// NetworkTier: This signifies the networking tier used for configuring
	// this access configuration and can only take the following values:
	// PREMIUM, STANDARD. If an AccessConfig is specified without a valid
	// external IP address, an ephemeral IP will be created with this
	// networkTier. If an AccessConfig with a valid external IP address is
	// specified, it must match that of the networkTier associated with the
	// Address resource owning that IP.
	//
	// Possible values:
	//   "FIXED_STANDARD" - Public internet quality with fixed bandwidth.
	//   "PREMIUM" - High quality, Google-grade network tier, support for
	// all networking products.
	//   "SELECT" - Price competitive network tier, support for all
	// networking products.
	//   "STANDARD" - Public internet quality, only limited support for
	// other networking products.
	//   "STANDARD_OVERRIDES_FIXED_STANDARD" - (Output only) Temporary tier
	// for FIXED_STANDARD when fixed standard tier is expired or not
	// configured.
	NetworkTier string `json:"networkTier,omitempty"`

	// PublicDnsName: [Output Only] The public DNS domain name for the
	// instance.
	PublicDnsName string `json:"publicDnsName,omitempty"`

	// PublicPtrDomainName: The DNS domain name for the public PTR record.
	// You can set this field only if the `setPublicPtr` field is enabled in
	// accessConfig. If this field is unspecified in ipv6AccessConfig, a
	// default PTR record will be createc for first IP in associated
	// external IPv6 range.
	PublicPtrDomainName string `json:"publicPtrDomainName,omitempty"`

	// SecurityPolicy: [Output Only] The resource URL for the security
	// policy associated with this access config.
	SecurityPolicy string `json:"securityPolicy,omitempty"`

	// SetPublicDns: Specifies whether a public DNS 'A' record should be
	// created for the external IP address of this access configuration.
	SetPublicDns bool `json:"setPublicDns,omitempty"`

	// SetPublicPtr: Specifies whether a public DNS 'PTR' record should be
	// created to map the external IP address of the instance to a DNS
	// domain name. This field is not used in ipv6AccessConfig. A default
	// PTR record will be created if the VM has external IPv6 range
	// associated.
	SetPublicPtr bool `json:"setPublicPtr,omitempty"`

	// Type: The type of configuration. In accessConfigs (IPv4), the default
	// and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default
	// and only option is DIRECT_IPV6.
	//
	// Possible values:
	//   "DIRECT_IPV6"
	//   "ONE_TO_ONE_NAT"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExternalIpv6") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalIpv6") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AccessConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Address: Represents an IP Address resource. Google Compute Engine has
// two IP Address resources: * Global (external and internal)
// (https://cloud.google.com/compute/docs/reference/rest/alpha/globalAddresses)
// * Regional (external and internal)
// (https://cloud.google.com/compute/docs/reference/rest/alpha/addresses)
// For more information, see Reserving a static external IP address.
type Address struct {
	// Address: The static IP address represented by this resource.
	Address string `json:"address,omitempty"`

	// AddressType: The type of address to reserve, either INTERNAL or
	// EXTERNAL. If unspecified, defaults to EXTERNAL.
	//
	// Possible values:
	//   "DNS_FORWARDING" - DNS resolver address in the subnetwork.
	//   "EXTERNAL" - A publicly visible external IP address.
	//   "INTERNAL" - A private network IP address, for use with an Instance
	// or Internal Load Balancer forwarding rule.
	//   "UNSPECIFIED_TYPE"
	AddressType string `json:"addressType,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// field when you create the resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// IpVersion: The IP version that will be used by this address. Valid
	// options are IPV4 or IPV6. This can only be specified for a global
	// address.
	//
	// Possible values:
	//   "IPV4"
	//   "IPV6"
	//   "UNSPECIFIED_VERSION"
	IpVersion string `json:"ipVersion,omitempty"`

	// Ipv6EndpointType: The endpoint type of this address, which should be
	// VM or NETLB. This is used for deciding which type of endpoint this
	// address can be used after the external IPv6 address reservation.
	//
	// Possible values:
	//   "NETLB" - Reserved IPv6 address can be used on network load
	// balancer.
	//   "VM" - Reserved IPv6 address can be used on VM.
	Ipv6EndpointType string `json:"ipv6EndpointType,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#address for
	// addresses.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// Address, which is essentially a hash of the labels set used for
	// optimistic locking. The fingerprint is initially generated by Compute
	// Engine and changes after every request to modify or update labels.
	// You must always provide an up-to-date fingerprint hash in order to
	// update or change labels, otherwise the request will fail with error
	// 412 conditionNotMet. To see the latest fingerprint, make a get()
	// request to retrieve an Address.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first
	// character must be a lowercase letter, and all following characters
	// (except for the last character) must be a dash, lowercase letter, or
	// digit. The last character must be a lowercase letter or digit.
	Name string `json:"name,omitempty"`

	// Network: The URL of the network in which to reserve the address. This
	// field can only be used with INTERNAL type with the VPC_PEERING
	// purpose.
	Network string `json:"network,omitempty"`

	// NetworkTier: This signifies the networking tier used for configuring
	// this address and can only take the following values: PREMIUM or
	// STANDARD. Internal IP addresses are always Premium Tier; global
	// external IP addresses are always Premium Tier; regional external IP
	// addresses can be either Standard or Premium Tier. If this field is
	// not specified, it is assumed to be PREMIUM.
	//
	// Possible values:
	//   "FIXED_STANDARD" - Public internet quality with fixed bandwidth.
	//   "PREMIUM" - High quality, Google-grade network tier, support for
	// all networking products.
	//   "SELECT" - Price competitive network tier, support for all
	// networking products.
	//   "STANDARD" - Public internet quality, only limited support for
	// other networking products.
	//   "STANDARD_OVERRIDES_FIXED_STANDARD" - (Output only) Temporary tier
	// for FIXED_STANDARD when fixed standard tier is expired or not
	// configured.
	NetworkTier string `json:"networkTier,omitempty"`

	// PrefixLength: The prefix length if the resource represents an IP
	// range.
	PrefixLength int64 `json:"prefixLength,omitempty"`

	// Purpose: The purpose of this resource, which can be one of the
	// following values: - GCE_ENDPOINT for addresses that are used by VM
	// instances, alias IP ranges, load balancers, and similar resources. -
	// DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud
	// DNS inbound forwarder IP addresses (regional internal IP address in a
	// subnet of a VPC network) - VPC_PEERING for global internal IP
	// addresses used for private services access allocated ranges. -
	// NAT_AUTO for the regional external IP addresses used by Cloud NAT
	// when allocating addresses using automatic NAT IP address allocation.
	// - IPSEC_INTERCONNECT for addresses created from a private IP range
	// that are reserved for a VLAN attachment in an *HA VPN over Cloud
	// Interconnect* configuration. These addresses are regional resources.
	// - `SHARED_LOADBALANCER_VIP` for an internal IP address that is
	// assigned to multiple internal forwarding rules. -
	// `PRIVATE_SERVICE_CONNECT` for a private network address that is used
	// to configure Private Service Connect. Only global internal addresses
	// can use this purpose.
	//
	// Possible values:
	//   "DNS_RESOLVER" - DNS resolver address in the subnetwork.
	//   "GCE_ENDPOINT" - VM internal/alias IP, Internal LB service IP, etc.
	//   "IPSEC_INTERCONNECT" - A regional internal IP address range
	// reserved for the VLAN attachment that is used in HA VPN over Cloud
	// Interconnect. This regional internal IP address range must not
	// overlap with any IP address range of subnet/route in the VPC network
	// and its peering networks. After the VLAN attachment is created with
	// the reserved IP address range, when creating a new VPN gateway, its
	// interface IP address is allocated from the associated VLAN
	// attachment’s IP address range.
	//   "NAT_AUTO" - External IP automatically reserved for Cloud NAT.
	//   "PRIVATE_SERVICE_CONNECT" - A private network IP address that can
	// be used to configure Private Service Connect. This purpose can be
	// specified only for GLOBAL addresses of Type INTERNAL
	//   "SERVERLESS" - A regional internal IP address range reserved for
	// Serverless.
	//   "SHARED_LOADBALANCER_VIP" - A private network IP address that can
	// be shared by multiple Internal Load Balancer forwarding rules.
	//   "VPC_PEERING" - IP range for peer networks.
	Purpose string `json:"purpose,omitempty"`

	// Region: [Output Only] The URL of the region where a regional address
	// resides. For regional addresses, you must specify the region as a
	// path parameter in the HTTP request URL. *This field is not applicable
	// to global addresses.*
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Status: [Output Only] The status of the address, which can be one of
	// RESERVING, RESERVED, or IN_USE. An address that is RESERVING is
	// currently in the process of being reserved. A RESERVED address is
	// currently reserved and available to use. An IN_USE address is
	// currently being used by another resource and is not available.
	//
	// Possible values:
	//   "IN_USE" - Address is being used by another resource and is not
	// available.
	//   "RESERVED" - Address is reserved and available to use.
	//   "RESERVING" - Address is being reserved.
	Status string `json:"status,omitempty"`

	// Subnetwork: The URL of the subnetwork in which to reserve the
	// address. If an IP address is specified, it must be within the
	// subnetwork's IP range. This field can only be used with INTERNAL type
	// with a GCE_ENDPOINT or DNS_RESOLVER purpose.
	Subnetwork string `json:"subnetwork,omitempty"`

	// Users: [Output Only] The URLs of the resources that are using this
	// address.
	Users []string `json:"users,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Address) MarshalJSON() ([]byte, error) {
	type NoMethod Address
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AddressesScopedList resources.
	Items map[string]AddressesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#addressAggregatedList for aggregated lists of addresses.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AddressAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod AddressAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressAggregatedListWarning: [Output Only] Informational warning
// message.
type AddressAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AddressAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AddressAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AddressAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressList: Contains a list of addresses.
type AddressList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Address resources.
	Items []*Address `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#addressList for
	// lists of addresses.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AddressListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressList) MarshalJSON() ([]byte, error) {
	type NoMethod AddressList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressListWarning: [Output Only] Informational warning message.
type AddressListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AddressListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AddressListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AddressListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressesScopedList struct {
	// Addresses: [Output Only] A list of addresses contained in this scope.
	Addresses []*Address `json:"addresses,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of addresses when the list is empty.
	Warning *AddressesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Addresses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Addresses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod AddressesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressesScopedListWarning: [Output Only] Informational warning which
// replaces the list of addresses when the list is empty.
type AddressesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AddressesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AddressesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AddressesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AdvancedMachineFeatures: Specifies options for controlling advanced
// machine features. Options that would traditionally be configured in a
// BIOS belong here. Features that require operating system support may
// have corresponding entries in the GuestOsFeatures of an Image (e.g.,
// whether or not the OS in the Image supports nested virtualization
// being enabled or disabled).
type AdvancedMachineFeatures struct {
	// EnableNestedVirtualization: Whether to enable nested virtualization
	// or not (default is false).
	EnableNestedVirtualization bool `json:"enableNestedVirtualization,omitempty"`

	// EnableUefiNetworking: Whether to enable UEFI networking for instance
	// creation.
	EnableUefiNetworking bool `json:"enableUefiNetworking,omitempty"`

	// NumaNodeCount: The number of vNUMA nodes.
	NumaNodeCount int64 `json:"numaNodeCount,omitempty"`

	// PerformanceMonitoringUnit: Type of Performance Monitoring Unit
	// requested on instance.
	//
	// Possible values:
	//   "ARCHITECTURAL" - Architecturally defined non-LLC events.
	//   "ENHANCED" - Most documented core/L2 and LLC events.
	//   "PERFORMANCE_MONITORING_UNIT_UNSPECIFIED"
	//   "STANDARD" - Most documented core/L2 events.
	PerformanceMonitoringUnit string `json:"performanceMonitoringUnit,omitempty"`

	// ThreadsPerCore: The number of threads per physical core. To disable
	// simultaneous multithreading (SMT) set this to 1. If unset, the
	// maximum number of threads supported per core by the underlying
	// processor is assumed.
	ThreadsPerCore int64 `json:"threadsPerCore,omitempty"`

	// VisibleCoreCount: The number of physical cores to expose to an
	// instance. Multiply by the number of threads per core to compute the
	// total number of virtual CPUs to expose to the instance. If unset, the
	// number of cores is inferred from the instance's nominal CPU count and
	// the underlying platform's SMT width.
	VisibleCoreCount int64 `json:"visibleCoreCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableNestedVirtualization") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EnableNestedVirtualization") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AdvancedMachineFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod AdvancedMachineFeatures
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AliasIpRange: An alias IP range attached to an instance's network
// interface.
type AliasIpRange struct {
	// IpCidrRange: The IP alias ranges to allocate for this interface. This
	// IP CIDR range must belong to the specified subnetwork and cannot
	// contain IP addresses reserved by system or used by other network
	// interfaces. This range may be a single IP address (such as 10.2.3.4),
	// a netmask (such as /24) or a CIDR-formatted string (such as
	// 10.1.2.0/24).
	IpCidrRange string `json:"ipCidrRange,omitempty"`

	// SubnetworkRangeName: The name of a subnetwork secondary IP range from
	// which to allocate an IP alias range. If not specified, the primary
	// range of the subnetwork is used.
	SubnetworkRangeName string `json:"subnetworkRangeName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IpCidrRange") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IpCidrRange") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AliasIpRange) MarshalJSON() ([]byte, error) {
	type NoMethod AliasIpRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllocationAggregateReservation: This reservation type is specified by
// total resource amounts (e.g. total count of CPUs) and can account for
// multiple instance SKUs. In other words, one can create instances of
// varying shapes against this reservation.
type AllocationAggregateReservation struct {
	// InUseResources: [Output only] List of resources currently in use.
	InUseResources []*AllocationAggregateReservationReservedResourceInfo `json:"inUseResources,omitempty"`

	// ReservedResources: List of reserved resources (CPUs, memory,
	// accelerators).
	ReservedResources []*AllocationAggregateReservationReservedResourceInfo `json:"reservedResources,omitempty"`

	// VmFamily: The VM family that all instances scheduled against this
	// reservation must belong to.
	//
	// Possible values:
	//   "VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P"
	//   "VM_FAMILY_COMPUTE_OPTIMIZED_C3"
	//   "VM_FAMILY_GENERAL_PURPOSE_T2D"
	//   "VM_FAMILY_MEMORY_OPTIMIZED_M3"
	VmFamily string `json:"vmFamily,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InUseResources") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InUseResources") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AllocationAggregateReservation) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationAggregateReservation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AllocationAggregateReservationReservedResourceInfo struct {
	// Accelerator: Properties of accelerator resources in this reservation.
	Accelerator *AllocationAggregateReservationReservedResourceInfoAccelerator `json:"accelerator,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Accelerator") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accelerator") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AllocationAggregateReservationReservedResourceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationAggregateReservationReservedResourceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AllocationAggregateReservationReservedResourceInfoAccelerator struct {
	// AcceleratorCount: Number of accelerators of specified type.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty"`

	// AcceleratorType: Full or partial URL to accelerator type. e.g.
	// "projects/{PROJECT}/zones/{ZONE}/acceleratorTypes/ct4l"
	AcceleratorType string `json:"acceleratorType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceleratorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AllocationAggregateReservationReservedResourceInfoAccelerator) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationAggregateReservationReservedResourceInfoAccelerator
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllocationResourceStatus: [Output Only] Contains output only fields.
type AllocationResourceStatus struct {
	// SpecificSkuAllocation: Allocation Properties of this reservation.
	SpecificSkuAllocation *AllocationResourceStatusSpecificSKUAllocation `json:"specificSkuAllocation,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SpecificSkuAllocation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SpecificSkuAllocation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AllocationResourceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationResourceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllocationResourceStatusSpecificSKUAllocation: Contains Properties
// set for the reservation.
type AllocationResourceStatusSpecificSKUAllocation struct {
	// SourceInstanceTemplateId: ID of the instance template used to
	// populate reservation properties.
	SourceInstanceTemplateId string `json:"sourceInstanceTemplateId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SourceInstanceTemplateId") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceInstanceTemplateId")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AllocationResourceStatusSpecificSKUAllocation) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationResourceStatusSpecificSKUAllocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk struct {
	// DiskSizeGb: Specifies the size of the disk in base-2 GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// Interface: Specifies the disk interface to use for attaching this
	// disk, which is either SCSI or NVME. The default is SCSI. For
	// performance characteristics of SCSI over NVMe, see Local SSD
	// performance.
	//
	// Possible values:
	//   "NVDIMM"
	//   "NVME"
	//   "SCSI"
	Interface string `json:"interface,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskSizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskSizeGb") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllocationSpecificSKUAllocationReservedInstanceProperties: Properties
// of the SKU instances being reserved. Next ID: 9
type AllocationSpecificSKUAllocationReservedInstanceProperties struct {
	// GuestAccelerators: Specifies accelerator type and count.
	GuestAccelerators []*AcceleratorConfig `json:"guestAccelerators,omitempty"`

	// LocalSsds: Specifies amount of local ssd to reserve with each
	// instance. The type of disk is local-ssd.
	LocalSsds []*AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk `json:"localSsds,omitempty"`

	// LocationHint: An opaque location hint used to place the allocation
	// close to other resources. This field is for use by internal tools
	// that use the public API.
	LocationHint string `json:"locationHint,omitempty"`

	// MachineType: Specifies type of machine (name only) which has fixed
	// number of vCPUs and fixed amount of memory. This also includes
	// specifying custom machine type following
	// custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
	MachineType string `json:"machineType,omitempty"`

	// MaintenanceFreezeDurationHours: Specifies the number of hours after
	// reservation creation where instances using the reservation won't be
	// scheduled for maintenance.
	MaintenanceFreezeDurationHours int64 `json:"maintenanceFreezeDurationHours,omitempty"`

	// MaintenanceInterval: Specifies the frequency of planned maintenance
	// events. The accepted values are: `PERIODIC`.
	//
	// Possible values:
	//   "AS_NEEDED" - VMs are eligible to receive infrastructure and
	// hypervisor updates as they become available. This may result in more
	// maintenance operations (live migrations or terminations) for the VM
	// than the PERIODIC and RECURRENT options.
	//   "PERIODIC" - VMs receive infrastructure and hypervisor updates on a
	// periodic basis, minimizing the number of maintenance operations (live
	// migrations or terminations) on an individual VM. This may mean a VM
	// will take longer to receive an update than if it was configured for
	// AS_NEEDED. Security updates will still be applied as soon as they are
	// available.
	//   "RECURRENT" - VMs receive infrastructure and hypervisor updates on
	// a periodic basis, minimizing the number of maintenance operations
	// (live migrations or terminations) on an individual VM. This may mean
	// a VM will take longer to receive an update than if it was configured
	// for AS_NEEDED. Security updates will still be applied as soon as they
	// are available. RECURRENT is used for GEN3 and Slice of Hardware VMs.
	MaintenanceInterval string `json:"maintenanceInterval,omitempty"`

	// MinCpuPlatform: Minimum cpu platform the reservation.
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GuestAccelerators")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GuestAccelerators") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AllocationSpecificSKUAllocationReservedInstanceProperties) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationSpecificSKUAllocationReservedInstanceProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllocationSpecificSKUReservation: This reservation type allows to pre
// allocate specific instance configuration. Next ID: 6
type AllocationSpecificSKUReservation struct {
	// AssuredCount: [Output Only] Indicates how many instances are actually
	// usable currently.
	AssuredCount int64 `json:"assuredCount,omitempty,string"`

	// Count: Specifies the number of resources that are allocated.
	Count int64 `json:"count,omitempty,string"`

	// InUseCount: [Output Only] Indicates how many instances are in use.
	InUseCount int64 `json:"inUseCount,omitempty,string"`

	// InstanceProperties: The instance properties for the reservation.
	InstanceProperties *AllocationSpecificSKUAllocationReservedInstanceProperties `json:"instanceProperties,omitempty"`

	// SourceInstanceTemplate: Specifies the instance template to create the
	// reservation. If you use this field, you must exclude the
	// instanceProperties field. This field is optional, and it can be a
	// full or partial URL. For example, the following are all valid URLs to
	// an instance template: -
	// https://www.googleapis.com/compute/v1/projects/project
	// /global/instanceTemplates/instanceTemplate -
	// projects/project/global/instanceTemplates/instanceTemplate -
	// global/instanceTemplates/instanceTemplate
	SourceInstanceTemplate string `json:"sourceInstanceTemplate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssuredCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssuredCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AllocationSpecificSKUReservation) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationSpecificSKUReservation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttachedDisk: An instance-attached disk resource.
type AttachedDisk struct {
	// Architecture: [Output Only] The architecture of the attached disk.
	// Valid values are ARM64 or X86_64.
	//
	// Possible values:
	//   "ARCHITECTURE_UNSPECIFIED" - Default value indicating Architecture
	// is not set.
	//   "ARM64" - Machines with architecture ARM64
	//   "X86_64" - Machines with architecture X86_64
	Architecture string `json:"architecture,omitempty"`

	// AutoDelete: Specifies whether the disk will be auto-deleted when the
	// instance is deleted (but not when the disk is detached from the
	// instance).
	AutoDelete bool `json:"autoDelete,omitempty"`

	// Boot: Indicates that this is a boot disk. The virtual machine will
	// use the first partition of the disk for its root filesystem.
	Boot bool `json:"boot,omitempty"`

	// DeviceName: Specifies a unique device name of your choice that is
	// reflected into the /dev/disk/by-id/google-* tree of a Linux operating
	// system running within the instance. This name can be used to
	// reference the device for mounting, resizing, and so on, from within
	// the instance. If not specified, the server chooses a default device
	// name to apply to this disk, in the form persistent-disk-x, where x is
	// a number assigned by Google Compute Engine. This field is only
	// applicable for persistent disks.
	DeviceName string `json:"deviceName,omitempty"`

	// DiskEncryptionKey: Encrypts or decrypts a disk using a
	// customer-supplied encryption key. If you are creating a new disk,
	// this field encrypts the new disk using an encryption key that you
	// provide. If you are attaching an existing disk that is already
	// encrypted, this field decrypts the disk using the customer-supplied
	// encryption key. If you encrypt a disk using a customer-supplied key,
	// you must provide the same key again when you attempt to use this
	// resource at a later time. For example, you must provide the key when
	// you create a snapshot or an image from the disk or when you attach
	// the disk to a virtual machine instance. If you do not provide an
	// encryption key, then the disk will be encrypted using an
	// automatically generated key and you do not need to provide a key to
	// use the disk later. Instance templates do not store customer-supplied
	// encryption keys, so you cannot use your own keys to encrypt disks in
	// a managed instance group.
	DiskEncryptionKey *CustomerEncryptionKey `json:"diskEncryptionKey,omitempty"`

	// DiskSizeGb: The size of the disk in GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// ForceAttach: [Input Only] Whether to force attach the regional disk
	// even if it's currently attached to another instance. If you try to
	// force attach a zonal disk to an instance, you will receive an error.
	ForceAttach bool `json:"forceAttach,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. Read Enabling guest
	// operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Index: [Output Only] A zero-based index to this disk, where 0 is
	// reserved for the boot disk. If you have many disks attached to an
	// instance, each disk would have a unique index number.
	Index int64 `json:"index,omitempty"`

	// InitializeParams: [Input Only] Specifies the parameters for a new
	// disk that will be created alongside the new instance. Use
	// initialization parameters to create boot disks or local SSDs attached
	// to the new instance. This property is mutually exclusive with the
	// source property; you can only define one or the other, but not both.
	InitializeParams *AttachedDiskInitializeParams `json:"initializeParams,omitempty"`

	// Interface: Specifies the disk interface to use for attaching this
	// disk, which is either SCSI or NVME. For most machine types, the
	// default is SCSI. Local SSDs can use either NVME or SCSI. In certain
	// configurations, persistent disks can use NVMe. For more information,
	// see About persistent disks.
	//
	// Possible values:
	//   "NVDIMM"
	//   "NVME"
	//   "SCSI"
	Interface string `json:"interface,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#attachedDisk
	// for attached disks.
	Kind string `json:"kind,omitempty"`

	// Licenses: [Output Only] Any valid publicly visible licenses.
	Licenses []string `json:"licenses,omitempty"`

	// Locked: [Output Only] Whether to indicate the attached disk is
	// locked. The locked disk is not allowed to be detached from the
	// instance, or to be used as the source of the snapshot creation, and
	// the image creation. The instance with at least one locked attached
	// disk is not allow to be used as source of machine image creation,
	// instant snapshot creation, and not allowed to be deleted with
	// --keep-disk parameter set to true for locked disks.
	Locked bool `json:"locked,omitempty"`

	// Mode: The mode in which to attach this disk, either READ_WRITE or
	// READ_ONLY. If not specified, the default is to attach the disk in
	// READ_WRITE mode.
	//
	// Possible values:
	//   "READ_ONLY" - Attaches this disk in read-only mode. Multiple
	// virtual machines can use a disk in read-only mode at a time.
	//   "READ_WRITE" - *[Default]* Attaches this disk in read-write mode.
	// Only one virtual machine at a time can be attached to a disk in
	// read-write mode.
	Mode string `json:"mode,omitempty"`

	// SavedState: For LocalSSD disks on VM Instances in STOPPED or
	// SUSPENDED state, this field is set to PRESERVED if the LocalSSD data
	// has been saved to a persistent location by customer request. (see the
	// discard_local_ssd option on Stop/Suspend). Read-only in the api.
	//
	// Possible values:
	//   "DISK_SAVED_STATE_UNSPECIFIED" - *[Default]* Disk state has not
	// been preserved.
	//   "PRESERVED" - Disk state has been preserved.
	SavedState string `json:"savedState,omitempty"`

	// ShieldedInstanceInitialState: [Output Only] shielded vm initial state
	// stored on disk
	ShieldedInstanceInitialState *InitialStateConfig `json:"shieldedInstanceInitialState,omitempty"`

	// Source: Specifies a valid partial or full URL to an existing
	// Persistent Disk resource. When creating a new instance, one of
	// initializeParams.sourceImage or initializeParams.sourceSnapshot or
	// disks.source is required except for local SSD. If desired, you can
	// also attach existing non-root persistent disks using this property.
	// This field is only applicable for persistent disks. Note that for
	// InstanceTemplate, specify the disk name for zonal disk, and the URL
	// for regional disk.
	Source string `json:"source,omitempty"`

	// Type: Specifies the type of the disk, either SCRATCH or PERSISTENT.
	// If not specified, the default is PERSISTENT.
	//
	// Possible values:
	//   "PERSISTENT"
	//   "SCRATCH"
	Type string `json:"type,omitempty"`

	// UserLicenses: [Output Only] A list of user provided licenses. It
	// represents a list of URLs to the license resource. Unlike regular
	// licenses, user provided licenses can be modified after the disk is
	// created.
	UserLicenses []string `json:"userLicenses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Architecture") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttachedDisk) MarshalJSON() ([]byte, error) {
	type NoMethod AttachedDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttachedDiskInitializeParams: [Input Only] Specifies the parameters
// for a new disk that will be created alongside the new instance. Use
// initialization parameters to create boot disks or local SSDs attached
// to the new instance. This field is persisted and returned for
// instanceTemplate and not returned in the context of instance. This
// property is mutually exclusive with the source property; you can only
// define one or the other, but not both.
type AttachedDiskInitializeParams struct {
	// Architecture: The architecture of the attached disk. Valid values are
	// arm64 or x86_64.
	//
	// Possible values:
	//   "ARCHITECTURE_UNSPECIFIED" - Default value indicating Architecture
	// is not set.
	//   "ARM64" - Machines with architecture ARM64
	//   "X86_64" - Machines with architecture X86_64
	Architecture string `json:"architecture,omitempty"`

	// Description: An optional description. Provide this property when
	// creating the disk.
	Description string `json:"description,omitempty"`

	// DiskName: Specifies the disk name. If not specified, the default is
	// to use the name of the instance. If a disk with the same name already
	// exists in the given region, the existing disk is attached to the new
	// instance and the new disk is not created.
	DiskName string `json:"diskName,omitempty"`

	// DiskSizeGb: Specifies the size of the disk in base-2 GB. The size
	// must be at least 10 GB. If you specify a sourceImage, which is
	// required for boot disks, the default size is the size of the
	// sourceImage. If you do not specify a sourceImage, the default disk
	// size is 500 GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// DiskType: Specifies the disk type to use to create the instance. If
	// not specified, the default is pd-standard, specified using the full
	// URL. For example:
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /diskTypes/pd-standard For a full list of acceptable values, see
	// Persistent disk types. If you specify this field when creating a VM,
	// you can provide either the full or partial URL. For example, the
	// following values are valid: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType
	// - zones/zone/diskTypes/diskType If you specify this field when
	// creating or updating an instance template or all-instances
	// configuration, specify the type of the disk, not the URL. For
	// example: pd-standard.
	DiskType string `json:"diskType,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. Read Enabling guest
	// operating system features to see a list of available options. Guest
	// OS features are applied by merging initializeParams.guestOsFeatures
	// and disks.guestOsFeatures
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Interface: [Deprecated] Specifies the disk interface to use for
	// attaching this disk, which is either SCSI or NVME. The default is
	// SCSI.
	//
	// Possible values:
	//   "NVME"
	//   "SCSI"
	//   "UNSPECIFIED"
	Interface string `json:"interface,omitempty"`

	// Labels: Labels to apply to this disk. These can be later modified by
	// the disks.setLabels method. This field is only applicable for
	// persistent disks.
	Labels map[string]string `json:"labels,omitempty"`

	// LicenseCodes: Integer license codes indicating which licenses are
	// attached to this disk.
	LicenseCodes googleapi.Int64s `json:"licenseCodes,omitempty"`

	// Licenses: A list of publicly visible licenses. Reserved for Google's
	// use.
	Licenses []string `json:"licenses,omitempty"`

	// MultiWriter: Indicates whether or not the disk can be read/write
	// attached to more than one instance.
	MultiWriter bool `json:"multiWriter,omitempty"`

	// OnUpdateAction: Specifies which action to take on instance update
	// with this disk. Default is to use the existing disk.
	//
	// Possible values:
	//   "RECREATE_DISK" - Always recreate the disk.
	//   "RECREATE_DISK_IF_SOURCE_CHANGED" - Recreate the disk if source
	// (image, snapshot) of this disk is different from source of existing
	// disk.
	//   "USE_EXISTING_DISK" - Use the existing disk, this is the default
	// behaviour.
	OnUpdateAction string `json:"onUpdateAction,omitempty"`

	// ProvisionedIops: Indicates how many IOPS to provision for the disk.
	// This sets the number of I/O operations per second that the disk can
	// handle. Values must be between 10,000 and 120,000. For more details,
	// see the Extreme persistent disk documentation.
	ProvisionedIops int64 `json:"provisionedIops,omitempty,string"`

	// ProvisionedThroughput: Indicates how much throughput to provision for
	// the disk. This sets the number of throughput mb per second that the
	// disk can handle. Values must be between 1 and 7,124.
	ProvisionedThroughput int64 `json:"provisionedThroughput,omitempty,string"`

	// ReplicaZones: Required for each regional disk associated with the
	// instance. Specify the URLs of the zones where the disk should be
	// replicated to. You must provide exactly two replica zones, and one
	// zone must be the same as the instance zone. You can't use this option
	// with boot disks.
	ReplicaZones []string `json:"replicaZones,omitempty"`

	// ResourceManagerTags: Resource manager tags to be bound to the disk.
	// Tag keys and values have the same definition as resource manager
	// tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values
	// are in the format `tagValues/456`. The field is ignored (both PUT &
	// PATCH) when empty.
	ResourceManagerTags map[string]string `json:"resourceManagerTags,omitempty"`

	// ResourcePolicies: Resource policies applied to this disk for
	// automatic snapshot creations. Specified using the full or partial
	// URL. For instance template, specify only the resource policy name.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// SourceImage: The source image to create this disk. When creating a
	// new instance, one of initializeParams.sourceImage or
	// initializeParams.sourceSnapshot or disks.source is required except
	// for local SSD. To create a disk with one of the public operating
	// system images, specify the image by its family name. For example,
	// specify family/debian-9 to use the latest Debian 9 image:
	// projects/debian-cloud/global/images/family/debian-9 Alternatively,
	// use a specific version of a public operating system image:
	// projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To
	// create a disk with a custom image that you created, specify the image
	// name in the following format: global/images/my-custom-image You can
	// also specify a custom image by its image family, which returns the
	// latest version of the image in that family. Replace the image name
	// with family/family-name: global/images/family/my-image-family If the
	// source image is deleted later, this field will not be set.
	SourceImage string `json:"sourceImage,omitempty"`

	// SourceImageEncryptionKey: The customer-supplied encryption key of the
	// source image. Required if the source image is protected by a
	// customer-supplied encryption key. InstanceTemplate and
	// InstancePropertiesPatch do not store customer-supplied encryption
	// keys, so you cannot create disks for instances in a managed instance
	// group if the source images are encrypted with your own keys.
	SourceImageEncryptionKey *CustomerEncryptionKey `json:"sourceImageEncryptionKey,omitempty"`

	// SourceInstantSnapshot: The source instant-snapshot to create this
	// disk. When creating a new instance, one of
	// initializeParams.sourceSnapshot or
	// initializeParams.sourceInstantSnapshot initializeParams.sourceImage
	// or disks.source is required except for local SSD. To create a disk
	// with a snapshot that you created, specify the snapshot name in the
	// following format: us-central1-a/instantSnapshots/my-backup If the
	// source instant-snapshot is deleted later, this field will not be set.
	SourceInstantSnapshot string `json:"sourceInstantSnapshot,omitempty"`

	// SourceSnapshot: The source snapshot to create this disk. When
	// creating a new instance, one of initializeParams.sourceSnapshot or
	// initializeParams.sourceImage or disks.source is required except for
	// local SSD. To create a disk with a snapshot that you created, specify
	// the snapshot name in the following format: global/snapshots/my-backup
	// If the source snapshot is deleted later, this field will not be set.
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`

	// SourceSnapshotEncryptionKey: The customer-supplied encryption key of
	// the source snapshot.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `json:"sourceSnapshotEncryptionKey,omitempty"`

	// StoragePool: The storage pool in which the new disk is created. You
	// can provide this as a partial or full URL to the resource. For
	// example, the following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /storagePools/storagePool -
	// projects/project/zones/zone/storagePools/storagePool -
	// zones/zone/storagePools/storagePool
	StoragePool string `json:"storagePool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Architecture") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttachedDiskInitializeParams) MarshalJSON() ([]byte, error) {
	type NoMethod AttachedDiskInitializeParams
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must
// have one or more AuditLogConfigs. If there are AuditConfigs for both
// `allServices` and a specific service, the union of the two
// AuditConfigs is used for that service: the log_types specified in
// each AuditConfig are enabled, and the exempted_members in each
// AuditLogConfig are exempted. Example Policy with multiple
// AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members":
// [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
// enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts
// jose@example.com from DATA_READ logging, and aliya@example.com from
// DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// ExemptedMembers: This is deprecated and has no effect. Do not use.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type":
// "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, {
// "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and
// 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ
// logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// IgnoreChildExemptions: This is deprecated and has no effect. Do not
	// use.
	IgnoreChildExemptions bool `json:"ignoreChildExemptions,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthenticationPolicy: [Deprecated] The authentication settings for
// the backend service. The authentication settings for the backend
// service.
type AuthenticationPolicy struct {
	// Origins: List of authentication methods that can be used for origin
	// authentication. Similar to peers, these will be evaluated in order
	// the first valid one will be used to set origin identity. If none of
	// these methods pass, the request will be rejected with authentication
	// failed error (401). Leave the list empty if origin authentication is
	// not required.
	Origins []*OriginAuthenticationMethod `json:"origins,omitempty"`

	// Peers: List of authentication methods that can be used for peer
	// authentication. They will be evaluated in order the first valid one
	// will be used to set peer identity. If none of these methods pass, the
	// request will be rejected with authentication failed error (401).
	// Leave the list empty if peer authentication is not required.
	Peers []*PeerAuthenticationMethod `json:"peers,omitempty"`

	// PrincipalBinding: Define whether peer or origin identity should be
	// used for principal. Default value is USE_PEER. If peer (or origin)
	// identity is not available, either because peer/origin authentication
	// is not defined, or failed, principal will be left unset. In other
	// words, binding rule does not affect the decision to accept or reject
	// request. This field can be set to one of the following: USE_PEER:
	// Principal will be set to the identity from peer authentication.
	// USE_ORIGIN: Principal will be set to the identity from origin
	// authentication.
	//
	// Possible values:
	//   "INVALID"
	//   "USE_ORIGIN" - Principal will be set to the identity from origin
	// authentication.
	//   "USE_PEER" - Principal will be set to the identity from peer
	// authentication.
	PrincipalBinding string `json:"principalBinding,omitempty"`

	// ServerTlsContext: Configures the mechanism to obtain server-side
	// security certificates and identity information.
	ServerTlsContext *TlsContext `json:"serverTlsContext,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Origins") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Origins") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AuthenticationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AuthenticationPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthorizationConfig: [Deprecated] Authorization configuration
// provides service-level and method-level access control for a service.
// control for a service.
type AuthorizationConfig struct {
	// Policies: List of RbacPolicies.
	Policies []*RbacPolicy `json:"policies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policies") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AuthorizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuthorizationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthorizationLoggingOptions: This is deprecated and has no effect. Do
// not use.
type AuthorizationLoggingOptions struct {
	// PermissionType: This is deprecated and has no effect. Do not use.
	//
	// Possible values:
	//   "ADMIN_READ" - This is deprecated and has no effect. Do not use.
	//   "ADMIN_WRITE" - This is deprecated and has no effect. Do not use.
	//   "DATA_READ" - This is deprecated and has no effect. Do not use.
	//   "DATA_WRITE" - This is deprecated and has no effect. Do not use.
	//   "PERMISSION_TYPE_UNSPECIFIED" - This is deprecated and has no
	// effect. Do not use.
	PermissionType string `json:"permissionType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PermissionType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PermissionType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuthorizationLoggingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod AuthorizationLoggingOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Autoscaler: Represents an Autoscaler resource. Google Compute Engine
// has two Autoscaler resources: * Zonal
// (/compute/docs/reference/rest/alpha/autoscalers) * Regional
// (/compute/docs/reference/rest/alpha/regionAutoscalers) Use
// autoscalers to automatically add or delete instances from a managed
// instance group according to your defined autoscaling policy. For more
// information, read Autoscaling Groups of Instances. For zonal managed
// instance groups resource, use the autoscaler resource. For regional
// managed instance groups, use the regionAutoscalers resource.
type Autoscaler struct {
	// AutoscalingPolicy: The configuration parameters for the autoscaling
	// algorithm. You can define one or more signals for an autoscaler:
	// cpuUtilization, customMetricUtilizations, and
	// loadBalancingUtilization. If none of these are specified, the default
	// will be to autoscale based on cpuUtilization to 0.6 or 60%.
	AutoscalingPolicy *AutoscalingPolicy `json:"autoscalingPolicy,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#autoscaler
	// for autoscalers.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// RecommendedSize: [Output Only] Target recommended MIG size (number of
	// instances) computed by autoscaler. Autoscaler calculates the
	// recommended MIG size even when the autoscaling policy mode is
	// different from ON. This field is empty when autoscaler is not
	// connected to an existing managed instance group or autoscaler did not
	// generate its prediction.
	RecommendedSize int64 `json:"recommendedSize,omitempty"`

	// Region: [Output Only] URL of the region where the instance group
	// resides (for autoscalers living in regional scope).
	Region string `json:"region,omitempty"`

	// ScalingScheduleStatus: [Output Only] Status information of existing
	// scaling schedules.
	ScalingScheduleStatus map[string]ScalingScheduleStatus `json:"scalingScheduleStatus,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Status: [Output Only] The status of the autoscaler configuration.
	// Current set of possible values: - PENDING: Autoscaler backend hasn't
	// read new/updated configuration. - DELETING: Configuration is being
	// deleted. - ACTIVE: Configuration is acknowledged to be effective.
	// Some warnings might be present in the statusDetails field. - ERROR:
	// Configuration has errors. Actionable for users. Details are present
	// in the statusDetails field. New values might be added in the future.
	//
	// Possible values:
	//   "ACTIVE" - Configuration is acknowledged to be effective
	//   "DELETING" - Configuration is being deleted
	//   "ERROR" - Configuration has errors. Actionable for users.
	//   "PENDING" - Autoscaler backend hasn't read new/updated
	// configuration
	Status string `json:"status,omitempty"`

	// StatusDetails: [Output Only] Human-readable details about the current
	// state of the autoscaler. Read the documentation for Commonly returned
	// status messages for examples of status messages you might encounter.
	StatusDetails []*AutoscalerStatusDetails `json:"statusDetails,omitempty"`

	// Target: URL of the managed instance group that this autoscaler will
	// scale. This field is required when creating an autoscaler.
	Target string `json:"target,omitempty"`

	// Zone: [Output Only] URL of the zone where the instance group resides
	// (for autoscalers living in zonal scope).
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AutoscalingPolicy")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoscalingPolicy") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Autoscaler) MarshalJSON() ([]byte, error) {
	type NoMethod Autoscaler
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AutoscalersScopedList resources.
	Items map[string]AutoscalersScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#autoscalerAggregatedList for aggregated lists of autoscalers.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources. end_interface:
	// MixerListResponseWithEtagBuilder
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AutoscalerAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalerAggregatedListWarning: [Output Only] Informational warning
// message.
type AutoscalerAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AutoscalerAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalerList: Contains a list of Autoscaler resources.
type AutoscalerList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Autoscaler resources.
	Items []*Autoscaler `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#autoscalerList
	// for lists of autoscalers.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AutoscalerListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerList) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalerListWarning: [Output Only] Informational warning message.
type AutoscalerListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AutoscalerListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerStatusDetails struct {
	// Message: The status message.
	Message string `json:"message,omitempty"`

	// Type: The type of error, warning, or notice returned. Current set of
	// possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances
	// in the instance group are unhealthy (not in RUNNING state). -
	// BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service
	// attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS
	// (WARNING): Autoscaler recommends a size greater than maxNumReplicas.
	// - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric
	// samples are not exported often enough to be a credible base for
	// autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that
	// was specified does not exist or does not have the necessary labels. -
	// MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to
	// maxNumReplicas. This means the autoscaler cannot add or remove
	// instances from the instance group. -
	// MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not
	// receive any data from the custom metric configured for autoscaling. -
	// MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is
	// configured to scale based on a load balancing signal but the instance
	// group has not received any requests from the load balancer. -
	// MODE_OFF (WARNING): Autoscaling is turned off. The number of
	// instances in the group won't change automatically. The autoscaling
	// configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is
	// in the "Autoscale only out" mode. The autoscaler can add instances
	// but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The
	// instance group cannot be autoscaled because it has more than one
	// backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR):
	// There is insufficient quota for the necessary resources, such as CPU
	// or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown
	// only for regional autoscalers: there is a resource stockout in the
	// chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to
	// be scaled does not exist. -
	// UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
	// Autoscaling does not work with an HTTP/S load balancer that has been
	// configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal
	// autoscalers: there is a resource stockout in the chosen zone. For
	// regional autoscalers: in at least one of the zones you're using there
	// is a resource stockout. New values might be added in the future. Some
	// of the values might not be available in all API versions.
	//
	// Possible values:
	//   "ALL_INSTANCES_UNHEALTHY" - All instances in the instance group are
	// unhealthy (not in RUNNING state).
	//   "BACKEND_SERVICE_DOES_NOT_EXIST" - There is no backend service
	// attached to the instance group.
	//   "CAPPED_AT_MAX_NUM_REPLICAS" - Autoscaler recommends a size greater
	// than maxNumReplicas.
	//   "CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE" - The custom metric samples
	// are not exported often enough to be a credible base for autoscaling.
	//   "CUSTOM_METRIC_INVALID" - The custom metric that was specified does
	// not exist or does not have the necessary labels.
	//   "MIN_EQUALS_MAX" - The minNumReplicas is equal to maxNumReplicas.
	// This means the autoscaler cannot add or remove instances from the
	// instance group.
	//   "MISSING_CUSTOM_METRIC_DATA_POINTS" - The autoscaler did not
	// receive any data from the custom metric configured for autoscaling.
	//   "MISSING_LOAD_BALANCING_DATA_POINTS" - The autoscaler is configured
	// to scale based on a load balancing signal but the instance group has
	// not received any requests from the load balancer.
	//   "MODE_OFF" - Autoscaling is turned off. The number of instances in
	// the group won't change automatically. The autoscaling configuration
	// is preserved.
	//   "MODE_ONLY_SCALE_OUT" - Autoscaling is in the "Autoscale only scale
	// out" mode. Instances in the group will be only added.
	//   "MODE_ONLY_UP" - Autoscaling is in the "Autoscale only out" mode.
	// Instances in the group will be only added.
	//   "MORE_THAN_ONE_BACKEND_SERVICE" - The instance group cannot be
	// autoscaled because it has more than one backend service attached to
	// it.
	//   "NOT_ENOUGH_QUOTA_AVAILABLE" - There is insufficient quota for the
	// necessary resources, such as CPU or number of instances.
	//   "REGION_RESOURCE_STOCKOUT" - Showed only for regional autoscalers:
	// there is a resource stockout in the chosen region.
	//   "SCALING_TARGET_DOES_NOT_EXIST" - The target to be scaled does not
	// exist.
	//   "SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX" - For some
	// scaling schedules minRequiredReplicas is greater than maxNumReplicas.
	// Autoscaler always recommends at most maxNumReplicas instances.
	//   "SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN" - For some scaling
	// schedules minRequiredReplicas is less than minNumReplicas. Autoscaler
	// always recommends at least minNumReplicas instances.
	//   "UNKNOWN"
	//   "UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION" - Autoscaling
	// does not work with an HTTP/S load balancer that has been configured
	// for maxRate.
	//   "ZONE_RESOURCE_STOCKOUT" - For zonal autoscalers: there is a
	// resource stockout in the chosen zone. For regional autoscalers: in at
	// least one of the zones you're using there is a resource stockout.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerStatusDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerStatusDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalersScopedList struct {
	// Autoscalers: [Output Only] A list of autoscalers contained in this
	// scope.
	Autoscalers []*Autoscaler `json:"autoscalers,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of autoscalers when the list is empty.
	Warning *AutoscalersScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Autoscalers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Autoscalers") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalersScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalersScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalersScopedListWarning: [Output Only] Informational warning
// which replaces the list of autoscalers when the list is empty.
type AutoscalersScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*AutoscalersScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalersScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalersScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalersScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalersScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalersScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicy: Cloud Autoscaler policy.
type AutoscalingPolicy struct {
	// CoolDownPeriodSec: The number of seconds that the autoscaler waits
	// before it starts collecting information from a new instance. This
	// prevents the autoscaler from collecting information when the instance
	// is initializing, during which the collected usage would not be
	// reliable. The default time autoscaler waits is 60 seconds. Virtual
	// machine initialization times might vary because of numerous factors.
	// We recommend that you test how long an instance may take to
	// initialize. To do this, create an instance and time the startup
	// process.
	CoolDownPeriodSec int64 `json:"coolDownPeriodSec,omitempty"`

	// CpuUtilization: Defines the CPU utilization policy that allows the
	// autoscaler to scale based on the average CPU utilization of a managed
	// instance group.
	CpuUtilization *AutoscalingPolicyCpuUtilization `json:"cpuUtilization,omitempty"`

	// CustomMetricUtilizations: Configuration parameters of autoscaling
	// based on a custom metric.
	CustomMetricUtilizations []*AutoscalingPolicyCustomMetricUtilization `json:"customMetricUtilizations,omitempty"`

	// LoadBalancingUtilization: Configuration parameters of autoscaling
	// based on load balancer.
	LoadBalancingUtilization *AutoscalingPolicyLoadBalancingUtilization `json:"loadBalancingUtilization,omitempty"`

	// MaxNumReplicas: The maximum number of instances that the autoscaler
	// can scale out to. This is required when creating or updating an
	// autoscaler. The maximum number of replicas must not be lower than
	// minimal number of replicas.
	MaxNumReplicas int64 `json:"maxNumReplicas,omitempty"`

	// MinNumReplicas: The minimum number of replicas that the autoscaler
	// can scale in to. This cannot be less than 0. If not provided,
	// autoscaler chooses a default value depending on maximum number of
	// instances allowed.
	MinNumReplicas int64 `json:"minNumReplicas,omitempty"`

	// Mode: Defines operating mode for this policy.
	//
	// Possible values:
	//   "OFF" - Do not automatically scale the MIG in or out. The
	// recommended_size field contains the size of MIG that would be set if
	// the actuation mode was enabled.
	//   "ON" - Automatically scale the MIG in and out according to the
	// policy.
	//   "ONLY_SCALE_OUT" - Automatically create VMs according to the
	// policy, but do not scale the MIG in.
	//   "ONLY_UP" - Automatically create VMs according to the policy, but
	// do not scale the MIG in.
	Mode string `json:"mode,omitempty"`

	ScaleDownControl *AutoscalingPolicyScaleDownControl `json:"scaleDownControl,omitempty"`

	ScaleInControl *AutoscalingPolicyScaleInControl `json:"scaleInControl,omitempty"`

	// ScalingSchedules: Scaling schedules defined for an autoscaler.
	// Multiple schedules can be set on an autoscaler, and they can overlap.
	// During overlapping periods the greatest min_required_replicas of all
	// scaling schedules is applied. Up to 128 scaling schedules are
	// allowed.
	ScalingSchedules map[string]AutoscalingPolicyScalingSchedule `json:"scalingSchedules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoolDownPeriodSec")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoolDownPeriodSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicyCpuUtilization: CPU utilization policy.
type AutoscalingPolicyCpuUtilization struct {
	// PredictiveMethod: Indicates whether predictive autoscaling based on
	// CPU metric is enabled. Valid values are: * NONE (default). No
	// predictive method is used. The autoscaler scales the group to meet
	// current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY.
	// Predictive autoscaling improves availability by monitoring daily and
	// weekly load patterns and scaling out ahead of anticipated demand.
	//
	// Possible values:
	//   "NONE" - No predictive method is used. The autoscaler scales the
	// group to meet current demand based on real-time metrics
	//   "OPTIMIZE_AVAILABILITY" - Predictive autoscaling improves
	// availability by monitoring daily and weekly load patterns and scaling
	// out ahead of anticipated demand.
	//   "PREDICTIVE_METHOD_UNSPECIFIED"
	//   "STANDARD" - Predictive autoscaling improves availability by
	// monitoring daily and weekly load patterns and scaling out ahead of
	// anticipated demand. This value is being DEPRECATED - it won't be
	// promoted to beta and v1. Use OPTIMIZE_AVAILABILITY instead.
	PredictiveMethod string `json:"predictiveMethod,omitempty"`

	// UtilizationTarget: The target CPU utilization that the autoscaler
	// maintains. Must be a float value in the range (0, 1]. If not
	// specified, the default is 0.6. If the CPU level is below the target
	// utilization, the autoscaler scales in the number of instances until
	// it reaches the minimum number of instances you specified or until the
	// average CPU of your instances reaches the target utilization. If the
	// average CPU is above the target utilization, the autoscaler scales
	// out until it reaches the maximum number of instances you specified or
	// until the average utilization reaches the target utilization.
	UtilizationTarget float64 `json:"utilizationTarget,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PredictiveMethod") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PredictiveMethod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyCpuUtilization) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyCpuUtilization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AutoscalingPolicyCpuUtilization) UnmarshalJSON(data []byte) error {
	type NoMethod AutoscalingPolicyCpuUtilization
	var s1 struct {
		UtilizationTarget gensupport.JSONFloat64 `json:"utilizationTarget"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UtilizationTarget = float64(s1.UtilizationTarget)
	return nil
}

// AutoscalingPolicyCustomMetricUtilization: Custom utilization metric
// policy.
type AutoscalingPolicyCustomMetricUtilization struct {
	// Filter: A filter string, compatible with a Stackdriver Monitoring
	// filter string for TimeSeries.list API call. This filter is used to
	// select a specific TimeSeries for the purpose of autoscaling and to
	// determine whether the metric is exporting per-instance or per-group
	// data. For the filter to be valid for autoscaling purposes, the
	// following rules apply: - You can only use the AND operator for
	// joining selectors. - You can only use direct equality comparison
	// operator (=) without any functions for each selector. - You can
	// specify the metric in both the filter string and in the metric field.
	// However, if specified in both places, the metric must be identical. -
	// The monitored resource type determines what kind of values are
	// expected for the metric. If it is a gce_instance, the autoscaler
	// expects the metric to include a separate TimeSeries for each instance
	// in a group. In such a case, you cannot filter on resource labels. If
	// the resource type is any other value, the autoscaler expects this
	// metric to contain values that apply to the entire autoscaled instance
	// group and resource label filtering can be performed to point
	// autoscaler at the correct TimeSeries to scale upon. This is called a
	// *per-group metric* for the purpose of autoscaling. If not specified,
	// the type defaults to gce_instance. Try to provide a filter that is
	// selective enough to pick just one TimeSeries for the autoscaled group
	// or for each of the instances (if you are using gce_instance resource
	// type). If multiple TimeSeries are returned upon the query execution,
	// the autoscaler will sum their respective values to obtain its scaling
	// value.
	Filter string `json:"filter,omitempty"`

	// Metric: The identifier (type) of the Stackdriver Monitoring metric.
	// The metric cannot have negative values. The metric must have a value
	// type of INT64 or DOUBLE.
	Metric string `json:"metric,omitempty"`

	// SingleInstanceAssignment: If scaling is based on a per-group metric
	// value that represents the total amount of work to be done or resource
	// usage, set this value to an amount assigned for a single instance of
	// the scaled group. Autoscaler keeps the number of instances
	// proportional to the value of this metric. The metric itself does not
	// change value due to group resizing. A good metric to use with the
	// target is for example
	// pubsub.googleapis.com/subscription/num_undelivered_messages or a
	// custom metric exporting the total number of requests coming to your
	// instances. A bad example would be a metric exporting an average or
	// median latency, since this value can't include a chunk assignable to
	// a single instance, it could be better used with utilization_target
	// instead.
	SingleInstanceAssignment float64 `json:"singleInstanceAssignment,omitempty"`

	// UtilizationTarget: The target value of the metric that autoscaler
	// maintains. This must be a positive value. A utilization metric scales
	// number of virtual machines handling requests to increase or decrease
	// proportionally to the metric. For example, a good metric to use as a
	// utilization_target is
	// https://www.googleapis.com/compute/v1/instance/network/received_bytes_count.
	// The autoscaler works to keep this value constant for each of the
	// instances.
	UtilizationTarget float64 `json:"utilizationTarget,omitempty"`

	// UtilizationTargetType: Defines how target utilization value is
	// expressed for a Stackdriver Monitoring metric. Either GAUGE,
	// DELTA_PER_SECOND, or DELTA_PER_MINUTE.
	//
	// Possible values:
	//   "DELTA_PER_MINUTE" - Sets the utilization target value for a
	// cumulative or delta metric, expressed as the rate of growth per
	// minute.
	//   "DELTA_PER_SECOND" - Sets the utilization target value for a
	// cumulative or delta metric, expressed as the rate of growth per
	// second.
	//   "GAUGE" - Sets the utilization target value for a gauge metric. The
	// autoscaler will collect the average utilization of the virtual
	// machines from the last couple of minutes, and compare the value to
	// the utilization target value to perform autoscaling.
	UtilizationTargetType string `json:"utilizationTargetType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyCustomMetricUtilization) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyCustomMetricUtilization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AutoscalingPolicyCustomMetricUtilization) UnmarshalJSON(data []byte) error {
	type NoMethod AutoscalingPolicyCustomMetricUtilization
	var s1 struct {
		SingleInstanceAssignment gensupport.JSONFloat64 `json:"singleInstanceAssignment"`
		UtilizationTarget        gensupport.JSONFloat64 `json:"utilizationTarget"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SingleInstanceAssignment = float64(s1.SingleInstanceAssignment)
	s.UtilizationTarget = float64(s1.UtilizationTarget)
	return nil
}

// AutoscalingPolicyLoadBalancingUtilization: Configuration parameters
// of autoscaling based on load balancing.
type AutoscalingPolicyLoadBalancingUtilization struct {
	// UtilizationTarget: Fraction of backend capacity utilization (set in
	// HTTP(S) load balancing configuration) that the autoscaler maintains.
	// Must be a positive float value. If not defined, the default is 0.8.
	UtilizationTarget float64 `json:"utilizationTarget,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UtilizationTarget")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UtilizationTarget") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyLoadBalancingUtilization) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyLoadBalancingUtilization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AutoscalingPolicyLoadBalancingUtilization) UnmarshalJSON(data []byte) error {
	type NoMethod AutoscalingPolicyLoadBalancingUtilization
	var s1 struct {
		UtilizationTarget gensupport.JSONFloat64 `json:"utilizationTarget"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UtilizationTarget = float64(s1.UtilizationTarget)
	return nil
}

// AutoscalingPolicyScaleDownControl: Configuration that allows for
// slower scale in so that even if Autoscaler recommends an abrupt scale
// in of a MIG, it will be throttled as specified by the parameters
// below.
type AutoscalingPolicyScaleDownControl struct {
	// MaxScaledDownReplicas: Maximum allowed number (or %) of VMs that can
	// be deducted from the peak recommendation during the window autoscaler
	// looks at when computing recommendations. Possibly all these VMs can
	// be deleted at once so user service needs to be prepared to lose that
	// many VMs in one step.
	MaxScaledDownReplicas *FixedOrPercent `json:"maxScaledDownReplicas,omitempty"`

	// TimeWindowSec: How far back autoscaling looks when computing
	// recommendations to include directives regarding slower scale in, as
	// described above.
	TimeWindowSec int64 `json:"timeWindowSec,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MaxScaledDownReplicas") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxScaledDownReplicas") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyScaleDownControl) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyScaleDownControl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicyScaleInControl: Configuration that allows for slower
// scale in so that even if Autoscaler recommends an abrupt scale in of
// a MIG, it will be throttled as specified by the parameters below.
type AutoscalingPolicyScaleInControl struct {
	// MaxScaledInReplicas: Maximum allowed number (or %) of VMs that can be
	// deducted from the peak recommendation during the window autoscaler
	// looks at when computing recommendations. Possibly all these VMs can
	// be deleted at once so user service needs to be prepared to lose that
	// many VMs in one step.
	MaxScaledInReplicas *FixedOrPercent `json:"maxScaledInReplicas,omitempty"`

	// TimeWindowSec: How far back autoscaling looks when computing
	// recommendations to include directives regarding slower scale in, as
	// described above.
	TimeWindowSec int64 `json:"timeWindowSec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxScaledInReplicas")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxScaledInReplicas") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyScaleInControl) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyScaleInControl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicyScalingSchedule: Scaling based on user-defined
// schedule. The message describes a single scaling schedule. A scaling
// schedule changes the minimum number of VM instances an autoscaler can
// recommend, which can trigger scaling out.
type AutoscalingPolicyScalingSchedule struct {
	// Description: A description of a scaling schedule.
	Description string `json:"description,omitempty"`

	// Disabled: A boolean value that specifies whether a scaling schedule
	// can influence autoscaler recommendations. If set to true, then a
	// scaling schedule has no effect. This field is optional, and its value
	// is false by default.
	Disabled bool `json:"disabled,omitempty"`

	// DurationSec: The duration of time intervals, in seconds, for which
	// this scaling schedule is to run. The minimum allowed value is 300.
	// This field is required.
	DurationSec int64 `json:"durationSec,omitempty"`

	// MinRequiredReplicas: The minimum number of VM instances that the
	// autoscaler will recommend in time intervals starting according to
	// schedule. This field is required.
	MinRequiredReplicas int64 `json:"minRequiredReplicas,omitempty"`

	// Schedule: The start timestamps of time intervals when this scaling
	// schedule is to provide a scaling signal. This field uses the extended
	// cron format (with an optional year field). The expression can
	// describe a single timestamp if the optional year is set, in which
	// case the scaling schedule runs once. The schedule is interpreted with
	// respect to time_zone. This field is required. Note: These timestamps
	// only describe when autoscaler starts providing the scaling signal.
	// The VMs need additional time to become serving.
	Schedule string `json:"schedule,omitempty"`

	// TimeZone: The time zone to use when interpreting the schedule. The
	// value of this field must be a time zone name from the tz database:
	// http://en.wikipedia.org/wiki/Tz_database. This field is assigned a
	// default value of “UTC” if left empty.
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyScalingSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyScalingSchedule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Backend: Message containing information of one individual backend.
type Backend struct {
	// BalancingMode: Specifies how to determine whether the backend of a
	// load balancer can handle additional traffic or is fully loaded. For
	// usage guidelines, see Connection balancing mode. Backends must use
	// compatible balancing modes. For more information, see Supported
	// balancing modes and target capacity settings and Restrictions and
	// guidance for instance groups. Note: Currently, if you use the API to
	// configure incompatible balancing modes, the configuration might be
	// accepted even though it has no impact and is ignored. Specifically,
	// Backend.maxUtilization is ignored when Backend.balancingMode is RATE.
	// In the future, this incompatible combination will be rejected.
	//
	// Possible values:
	//   "CONNECTION" - Balance based on the number of simultaneous
	// connections.
	//   "RATE" - Balance based on requests per second (RPS).
	//   "UTILIZATION" - Balance based on the backend utilization.
	BalancingMode string `json:"balancingMode,omitempty"`

	// CapacityScaler: A multiplier applied to the backend's target capacity
	// of its balancing mode. The default value is 1, which means the group
	// serves up to 100% of its configured capacity (depending on
	// balancingMode). A setting of 0 means the group is completely drained,
	// offering 0% of its available capacity. The valid ranges are 0.0 and
	// [0.1,1.0]. You cannot configure a setting larger than 0 and smaller
	// than 0.1. You cannot configure a setting of 0 when there is only one
	// backend attached to the backend service. Not available with backends
	// that don't support using a balancingMode. This includes backends such
	// as global internet NEGs, regional serverless NEGs, and PSC NEGs.
	CapacityScaler float64 `json:"capacityScaler,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Failover: This field designates whether this is a failover backend.
	// More than one failover backend can be configured for a given
	// BackendService.
	Failover bool `json:"failover,omitempty"`

	// Group: The fully-qualified URL of an instance group or network
	// endpoint group (NEG) resource. To determine what types of backends a
	// load balancer supports, see the Backend services overview
	// (https://cloud.google.com/load-balancing/docs/backend-service#backends).
	// You must use the *fully-qualified* URL (starting with
	// https://www.googleapis.com/) to specify the instance group or NEG.
	// Partial URLs are not supported.
	Group string `json:"group,omitempty"`

	// MaxConnections: Defines a target maximum number of simultaneous
	// connections. For usage guidelines, see Connection balancing mode and
	// Utilization balancing mode. Not available if the backend's
	// balancingMode is RATE.
	MaxConnections int64 `json:"maxConnections,omitempty"`

	// MaxConnectionsPerEndpoint: Defines a target maximum number of
	// simultaneous connections. For usage guidelines, see Connection
	// balancing mode and Utilization balancing mode. Not available if the
	// backend's balancingMode is RATE.
	MaxConnectionsPerEndpoint int64 `json:"maxConnectionsPerEndpoint,omitempty"`

	// MaxConnectionsPerInstance: Defines a target maximum number of
	// simultaneous connections. For usage guidelines, see Connection
	// balancing mode and Utilization balancing mode. Not available if the
	// backend's balancingMode is RATE.
	MaxConnectionsPerInstance int64 `json:"maxConnectionsPerInstance,omitempty"`

	// MaxRate: Defines a maximum number of HTTP requests per second (RPS).
	// For usage guidelines, see Rate balancing mode and Utilization
	// balancing mode. Not available if the backend's balancingMode is
	// CONNECTION.
	MaxRate int64 `json:"maxRate,omitempty"`

	// MaxRatePerEndpoint: Defines a maximum target for requests per second
	// (RPS). For usage guidelines, see Rate balancing mode and Utilization
	// balancing mode. Not available if the backend's balancingMode is
	// CONNECTION.
	MaxRatePerEndpoint float64 `json:"maxRatePerEndpoint,omitempty"`

	// MaxRatePerInstance: Defines a maximum target for requests per second
	// (RPS). For usage guidelines, see Rate balancing mode and Utilization
	// balancing mode. Not available if the backend's balancingMode is
	// CONNECTION.
	MaxRatePerInstance float64 `json:"maxRatePerInstance,omitempty"`

	// MaxUtilization: Optional parameter to define a target capacity for
	// the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For
	// usage guidelines, see Utilization balancing mode.
	MaxUtilization float64 `json:"maxUtilization,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BalancingMode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BalancingMode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Backend) MarshalJSON() ([]byte, error) {
	type NoMethod Backend
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Backend) UnmarshalJSON(data []byte) error {
	type NoMethod Backend
	var s1 struct {
		CapacityScaler     gensupport.JSONFloat64 `json:"capacityScaler"`
		MaxRatePerEndpoint gensupport.JSONFloat64 `json:"maxRatePerEndpoint"`
		MaxRatePerInstance gensupport.JSONFloat64 `json:"maxRatePerInstance"`
		MaxUtilization     gensupport.JSONFloat64 `json:"maxUtilization"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CapacityScaler = float64(s1.CapacityScaler)
	s.MaxRatePerEndpoint = float64(s1.MaxRatePerEndpoint)
	s.MaxRatePerInstance = float64(s1.MaxRatePerInstance)
	s.MaxUtilization = float64(s1.MaxUtilization)
	return nil
}

// BackendBucket: Represents a Cloud Storage Bucket resource. This Cloud
// Storage bucket resource is referenced by a URL map of a load
// balancer. For more information, read Backend Buckets.
type BackendBucket struct {
	// BucketName: Cloud Storage bucket name.
	BucketName string `json:"bucketName,omitempty"`

	// CdnPolicy: Cloud CDN configuration for this BackendBucket.
	CdnPolicy *BackendBucketCdnPolicy `json:"cdnPolicy,omitempty"`

	// CompressionMode: Compress text responses using Brotli or gzip
	// compression, based on the client's Accept-Encoding header.
	//
	// Possible values:
	//   "AUTOMATIC" - Automatically uses the best compression based on the
	// Accept-Encoding header sent by the client.
	//   "DISABLED" - Disables compression. Existing compressed responses
	// cached by Cloud CDN will not be served to clients.
	CompressionMode string `json:"compressionMode,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// CustomResponseHeaders: Headers that the HTTP/S load balancer should
	// add to proxied responses.
	CustomResponseHeaders []string `json:"customResponseHeaders,omitempty"`

	// Description: An optional textual description of the resource;
	// provided by the client when the resource is created.
	Description string `json:"description,omitempty"`

	// EdgeSecurityPolicy: [Output Only] The resource URL for the edge
	// security policy associated with this backend bucket.
	EdgeSecurityPolicy string `json:"edgeSecurityPolicy,omitempty"`

	// EnableCdn: If true, enable Cloud CDN for this BackendBucket.
	EnableCdn bool `json:"enableCdn,omitempty"`

	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: Type of the resource.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BucketName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucket) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucket
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketCdnPolicy: Message containing Cloud CDN configuration
// for a backend bucket.
type BackendBucketCdnPolicy struct {
	// BypassCacheOnRequestHeaders: Bypass the cache when the specified
	// request headers are matched - e.g. Pragma or Authorization headers.
	// Up to 5 headers can be specified. The cache is bypassed for all
	// cdnPolicy.cacheMode settings.
	BypassCacheOnRequestHeaders []*BackendBucketCdnPolicyBypassCacheOnRequestHeader `json:"bypassCacheOnRequestHeaders,omitempty"`

	// CacheKeyPolicy: The CacheKeyPolicy for this CdnPolicy.
	CacheKeyPolicy *BackendBucketCdnPolicyCacheKeyPolicy `json:"cacheKeyPolicy,omitempty"`

	// CacheMode: Specifies the cache setting for all responses from this
	// backend. The possible values are: USE_ORIGIN_HEADERS Requires the
	// origin to set valid caching headers to cache content. Responses
	// without these headers will not be cached at Google's edge, and will
	// require a full trip to the origin on every request, potentially
	// impacting performance and increasing load on the origin server.
	// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store"
	// or "no-cache" directives in Cache-Control response headers. Warning:
	// this may result in Cloud CDN caching private, per-user (user
	// identifiable) content. CACHE_ALL_STATIC Automatically cache static
	// content, including common image formats, media (video and audio), and
	// web assets (JavaScript and CSS). Requests and responses that are
	// marked as uncacheable, as well as dynamic content (including HTML),
	// will not be cached.
	//
	// Possible values:
	//   "CACHE_ALL_STATIC" - Automatically cache static content, including
	// common image formats, media (video and audio), and web assets
	// (JavaScript and CSS). Requests and responses that are marked as
	// uncacheable, as well as dynamic content (including HTML), will not be
	// cached.
	//   "FORCE_CACHE_ALL" - Cache all content, ignoring any "private",
	// "no-store" or "no-cache" directives in Cache-Control response
	// headers. Warning: this may result in Cloud CDN caching private,
	// per-user (user identifiable) content.
	//   "INVALID_CACHE_MODE"
	//   "USE_ORIGIN_HEADERS" - Requires the origin to set valid caching
	// headers to cache content. Responses without these headers will not be
	// cached at Google's edge, and will require a full trip to the origin
	// on every request, potentially impacting performance and increasing
	// load on the origin server.
	CacheMode string `json:"cacheMode,omitempty"`

	// ClientTtl: Specifies a separate client (e.g. browser client) maximum
	// TTL. This is used to clamp the max-age (or Expires) value sent to the
	// client. With FORCE_CACHE_ALL, the lesser of client_ttl and
	// default_ttl is used for the response max-age directive, along with a
	// "public" directive. For cacheable content in CACHE_ALL_STATIC mode,
	// client_ttl clamps the max-age from the origin (if specified), or else
	// sets the response max-age directive to the lesser of the client_ttl
	// and default_ttl, and also ensures a "public" cache-control directive
	// is present. If a client TTL is not specified, a default value (1
	// hour) will be used. The maximum allowed value is 31,622,400s (1
	// year).
	ClientTtl int64 `json:"clientTtl,omitempty"`

	// DefaultTtl: Specifies the default TTL for cached content served by
	// this origin for responses that do not have an existing valid TTL
	// (max-age or s-max-age). Setting a TTL of "0" means "always
	// revalidate". The value of defaultTTL cannot be set to a value greater
	// than that of maxTTL, but can be equal. When the cacheMode is set to
	// FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all
	// responses. The maximum allowed value is 31,622,400s (1 year), noting
	// that infrequently accessed objects may be evicted from the cache
	// before the defined TTL.
	DefaultTtl int64 `json:"defaultTtl,omitempty"`

	// MaxTtl: Specifies the maximum allowed TTL for cached content served
	// by this origin. Cache directives that attempt to set a max-age or
	// s-maxage higher than this, or an Expires header more than maxTTL
	// seconds in the future will be capped at the value of maxTTL, as if it
	// were the value of an s-maxage Cache-Control directive. Headers sent
	// to the client will not be modified. Setting a TTL of "0" means
	// "always revalidate". The maximum allowed value is 31,622,400s (1
	// year), noting that infrequently accessed objects may be evicted from
	// the cache before the defined TTL.
	MaxTtl int64 `json:"maxTtl,omitempty"`

	// NegativeCaching: Negative caching allows per-status code TTLs to be
	// set, in order to apply fine-grained caching for common errors or
	// redirects. This can reduce the load on your origin and improve
	// end-user experience by reducing response latency. When the cache mode
	// is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching
	// applies to responses with the specified response code that lack any
	// Cache-Control, Expires, or Pragma: no-cache directives. When the
	// cache mode is set to FORCE_CACHE_ALL, negative caching applies to all
	// responses with the specified response code, and override any caching
	// headers. By default, Cloud CDN will apply the following default TTLs
	// to these status codes: HTTP 300 (Multiple Choice), 301, 308
	// (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451
	// (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found),
	// 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults
	// can be overridden in negative_caching_policy.
	NegativeCaching bool `json:"negativeCaching,omitempty"`

	// NegativeCachingPolicy: Sets a cache TTL for the specified HTTP status
	// code. negative_caching must be enabled to configure
	// negative_caching_policy. Omitting the policy and leaving
	// negative_caching enabled will use Cloud CDN's default cache TTLs.
	// Note that when specifying an explicit negative_caching_policy, you
	// should take care to specify a cache TTL for all response codes that
	// you wish to cache. Cloud CDN will not apply any default negative
	// caching when a policy exists.
	NegativeCachingPolicy []*BackendBucketCdnPolicyNegativeCachingPolicy `json:"negativeCachingPolicy,omitempty"`

	// RequestCoalescing: If true then Cloud CDN will combine multiple
	// concurrent cache fill requests into a small number of requests to the
	// origin.
	RequestCoalescing bool `json:"requestCoalescing,omitempty"`

	// ServeWhileStale: Serve existing content from the cache (if available)
	// when revalidating content with the origin, or when an error is
	// encountered when refreshing the cache. This setting defines the
	// default "max-stale" duration for any cached responses that do not
	// specify a max-stale directive. Stale responses that exceed the TTL
	// configured here will not be served. The default limit (max-stale) is
	// 86400s (1 day), which will allow stale content to be served up to
	// this limit beyond the max-age (or s-max-age) of a cached response.
	// The maximum allowed value is 604800 (1 week). Set this to zero (0) to
	// disable serve-while-stale.
	ServeWhileStale int64 `json:"serveWhileStale,omitempty"`

	// SignedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
	// signed URL request will be considered fresh. After this time period,
	// the response will be revalidated before being served. Defaults to 1hr
	// (3600s). When serving responses to signed URL requests, Cloud CDN
	// will internally behave as though all responses from this backend had
	// a "Cache-Control: public, max-age=[TTL]" header, regardless of any
	// existing Cache-Control header. The actual headers served in responses
	// will not be altered.
	SignedUrlCacheMaxAgeSec int64 `json:"signedUrlCacheMaxAgeSec,omitempty,string"`

	// SignedUrlKeyNames: [Output Only] Names of the keys for signing
	// request URLs.
	SignedUrlKeyNames []string `json:"signedUrlKeyNames,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketCdnPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketCdnPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketCdnPolicyBypassCacheOnRequestHeader: Bypass the cache
// when the specified request headers are present, e.g. Pragma or
// Authorization headers. Values are case insensitive. The presence of
// such a header overrides the cache_mode setting.
type BackendBucketCdnPolicyBypassCacheOnRequestHeader struct {
	// HeaderName: The header field name to match on when bypassing cache.
	// Values are case-insensitive.
	HeaderName string `json:"headerName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HeaderName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HeaderName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketCdnPolicyBypassCacheOnRequestHeader) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketCdnPolicyBypassCacheOnRequestHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketCdnPolicyCacheKeyPolicy: Message containing what to
// include in the cache key for a request for Cloud CDN.
type BackendBucketCdnPolicyCacheKeyPolicy struct {
	// IncludeHttpHeaders: Allows HTTP request headers (by name) to be used
	// in the cache key.
	IncludeHttpHeaders []string `json:"includeHttpHeaders,omitempty"`

	// QueryStringWhitelist: Names of query string parameters to include in
	// cache keys. Default parameters are always included. '&' and '=' will
	// be percent encoded and not treated as delimiters.
	QueryStringWhitelist []string `json:"queryStringWhitelist,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludeHttpHeaders")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeHttpHeaders") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketCdnPolicyCacheKeyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketCdnPolicyCacheKeyPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketCdnPolicyNegativeCachingPolicy: Specify CDN TTLs for
// response error codes.
type BackendBucketCdnPolicyNegativeCachingPolicy struct {
	// Code: The HTTP status code to define a TTL against. Only HTTP status
	// codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are
	// can be specified as values, and you cannot specify a status code more
	// than once.
	Code int64 `json:"code,omitempty"`

	// Ttl: The TTL (in seconds) for which to cache responses with the
	// corresponding status code. The maximum allowed value is 1800s (30
	// minutes), noting that infrequently accessed objects may be evicted
	// from the cache before the defined TTL.
	Ttl int64 `json:"ttl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketCdnPolicyNegativeCachingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketCdnPolicyNegativeCachingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketList: Contains a list of BackendBucket resources.
type BackendBucketList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of BackendBucket resources.
	Items []*BackendBucket `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *BackendBucketListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketListWarning: [Output Only] Informational warning
// message.
type BackendBucketListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*BackendBucketListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendBucketListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendService: Represents a Backend Service resource. A backend
// service defines how Google Cloud load balancers distribute traffic.
// The backend service configuration contains a set of values, such as
// the protocol used to connect to backends, various distribution and
// session settings, health checks, and timeouts. These settings provide
// fine-grained control over how your load balancer behaves. Most of the
// settings have default values that allow for easy configuration if you
// need to get started quickly. Backend services in Google Compute
// Engine can be either regionally or globally scoped. * Global
// (https://cloud.google.com/compute/docs/reference/rest/alpha/backendServices)
// * Regional
// (https://cloud.google.com/compute/docs/reference/rest/alpha/regionBackendServices)
// For more information, see Backend Services.
type BackendService struct {
	// AffinityCookieTtlSec: Lifetime of cookies in seconds. This setting is
	// applicable to external and internal HTTP(S) load balancers and
	// Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session
	// affinity. If set to 0, the cookie is non-persistent and lasts only
	// until the end of the browser session (or equivalent). The maximum
	// allowed value is two weeks (1,209,600). Not supported when the
	// backend service is referenced by a URL map that is bound to target
	// gRPC proxy that has validateForProxyless field set to true.
	AffinityCookieTtlSec int64 `json:"affinityCookieTtlSec,omitempty"`

	// Backends: The list of backends that serve this BackendService.
	Backends []*Backend `json:"backends,omitempty"`

	// CdnPolicy: Cloud CDN configuration for this BackendService. Only
	// available for specified load balancer types.
	CdnPolicy *BackendServiceCdnPolicy `json:"cdnPolicy,omitempty"`

	CircuitBreakers *CircuitBreakers `json:"circuitBreakers,omitempty"`

	// CompressionMode: Compress text responses using Brotli or gzip
	// compression, based on the client's Accept-Encoding header.
	//
	// Possible values:
	//   "AUTOMATIC" - Automatically uses the best compression based on the
	// Accept-Encoding header sent by the client.
	//   "DISABLED" - Disables compression. Existing compressed responses
	// cached by Cloud CDN will not be served to clients.
	CompressionMode string `json:"compressionMode,omitempty"`

	ConnectionDraining *ConnectionDraining `json:"connectionDraining,omitempty"`

	// ConnectionTrackingPolicy: Connection Tracking configuration for this
	// BackendService. Connection tracking policy settings are only
	// available for Network Load Balancing and Internal TCP/UDP Load
	// Balancing.
	ConnectionTrackingPolicy *BackendServiceConnectionTrackingPolicy `json:"connectionTrackingPolicy,omitempty"`

	// ConsistentHash: Consistent Hash-based load balancing can be used to
	// provide soft session affinity based on HTTP headers, cookies or other
	// properties. This load balancing policy is applicable only for HTTP
	// connections. The affinity to a particular destination host will be
	// lost when one or more hosts are added/removed from the destination
	// service. This field specifies parameters that control consistent
	// hashing. This field is only applicable when localityLbPolicy is set
	// to MAGLEV or RING_HASH. This field is applicable to either: - A
	// regional backend service with the service_protocol set to HTTP,
	// HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. -
	// A global backend service with the load_balancing_scheme set to
	// INTERNAL_SELF_MANAGED.
	ConsistentHash *ConsistentHashLoadBalancerSettings `json:"consistentHash,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// CustomRequestHeaders: Headers that the load balancer adds to proxied
	// requests. See Creating custom headers
	// (https://cloud.google.com/load-balancing/docs/custom-headers).
	CustomRequestHeaders []string `json:"customRequestHeaders,omitempty"`

	// CustomResponseHeaders: Headers that the load balancer adds to proxied
	// responses. See Creating custom headers
	// (https://cloud.google.com/load-balancing/docs/custom-headers).
	CustomResponseHeaders []string `json:"customResponseHeaders,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// EdgeSecurityPolicy: [Output Only] The resource URL for the edge
	// security policy associated with this backend service.
	EdgeSecurityPolicy string `json:"edgeSecurityPolicy,omitempty"`

	// EnableCDN: If true, enables Cloud CDN for the backend service of an
	// external HTTP(S) load balancer.
	EnableCDN bool `json:"enableCDN,omitempty"`

	// FailoverPolicy: Requires at least one backend instance group to be
	// defined as a backup (failover) backend. For load balancers that have
	// configurable failover: Internal TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/internal/failover-overview)
	// and external TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
	FailoverPolicy *BackendServiceFailoverPolicy `json:"failoverPolicy,omitempty"`

	// Fingerprint: Fingerprint of this resource. A hash of the contents
	// stored in this object. This field is used in optimistic locking. This
	// field will be ignored when inserting a BackendService. An up-to-date
	// fingerprint must be provided in order to update the BackendService,
	// otherwise the request will fail with error 412 conditionNotMet. To
	// see the latest fingerprint, make a get() request to retrieve a
	// BackendService.
	Fingerprint string `json:"fingerprint,omitempty"`

	// HealthChecks: The list of URLs to the healthChecks, httpHealthChecks
	// (legacy), or httpsHealthChecks (legacy) resource for health checking
	// this backend service. Not all backend services support legacy health
	// checks. See Load balancer guide. Currently, at most one health check
	// can be specified for each backend service. Backend services with
	// instance group or zonal NEG backends must have a health check.
	// Backend services with internet or serverless NEG backends must not
	// have a health check.
	HealthChecks []string `json:"healthChecks,omitempty"`

	// Iap: The configurations for Identity-Aware Proxy on this resource.
	// Not available for Internal TCP/UDP Load Balancing and Network Load
	// Balancing.
	Iap *BackendServiceIAP `json:"iap,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// IpAddressSelectionPolicy: Specifies preference of traffic to the
	// backend (from the proxy and from the client for proxyless gRPC). The
	// possible values are: - IPV4_ONLY: Only send IPv4 traffic to the
	// backends of the Backend Service (Instance Group, Managed Instance
	// Group, Network Endpoint Group) regardless of traffic from the client
	// to the proxy. Only IPv4 health-checks are used to check the health of
	// the backends. This is the default setting. - PREFER_IPV6: Prioritize
	// the connection to the endpoints IPv6 address over its IPv4 address
	// (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send
	// IPv6 traffic to the backends of the Backend Service (Instance Group,
	// Managed Instance Group, Network Endpoint Group) regardless of traffic
	// from the client to the proxy. Only IPv6 health-checks are used to
	// check the health of the backends. This field is applicable to either:
	// - Advanced Global External HTTPS Load Balancing (load balancing
	// scheme EXTERNAL_MANAGED), - Regional External HTTPS Load Balancing, -
	// Internal TCP Proxy (load balancing scheme INTERNAL_MANAGED), -
	// Regional Internal HTTPS Load Balancing (load balancing scheme
	// INTERNAL_MANAGED), - Traffic Director with Envoy proxies and
	// proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
	//
	// Possible values:
	//   "IPV4_ONLY" - Only send IPv4 traffic to the backends of the Backend
	// Service (Instance Group, Managed Instance Group, Network Endpoint
	// Group) regardless of traffic from the client to the proxy. Only IPv4
	// health-checks are used to check the health of the backends. This is
	// the default setting.
	//   "IPV6_ONLY" - Only send IPv6 traffic to the backends of the Backend
	// Service (Instance Group, Managed Instance Group, Network Endpoint
	// Group) regardless of traffic from the client to the proxy. Only IPv6
	// health-checks are used to check the health of the backends.
	//   "IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED" - Unspecified IP address
	// selection policy.
	//   "PREFER_IPV6" - Prioritize the connection to the endpoints IPv6
	// address over its IPv4 address (provided there is a healthy IPv6
	// address).
	IpAddressSelectionPolicy string `json:"ipAddressSelectionPolicy,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#backendService
	// for backend services.
	Kind string `json:"kind,omitempty"`

	// LoadBalancingScheme: Specifies the load balancer type. A backend
	// service created for one type of load balancer cannot be used with
	// another. For more information, refer to Choosing a load balancer.
	//
	// Possible values:
	//   "EXTERNAL" - Signifies that this will be used for external HTTP(S),
	// SSL Proxy, TCP Proxy, or Network Load Balancing
	//   "EXTERNAL_MANAGED" - Signifies that this will be used for External
	// Managed HTTP(S) Load Balancing.
	//   "INTERNAL" - Signifies that this will be used for Internal TCP/UDP
	// Load Balancing.
	//   "INTERNAL_MANAGED" - Signifies that this will be used for Internal
	// HTTP(S) Load Balancing.
	//   "INTERNAL_SELF_MANAGED" - Signifies that this will be used by
	// Traffic Director.
	//   "INVALID_LOAD_BALANCING_SCHEME"
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`

	// LocalityLbPolicies: A list of locality load-balancing policies to be
	// used in order of preference. When you use localityLbPolicies, you
	// must set at least one value for either the
	// localityLbPolicies[].policy or the localityLbPolicies[].customPolicy
	// field. localityLbPolicies overrides any value set in the
	// localityLbPolicy field. For an example of how to use this field, see
	// Define a list of preferred policies. Caution: This field and its
	// children are intended for use in a service mesh that includes gRPC
	// clients only. Envoy proxies can't use backend services that have this
	// configuration.
	LocalityLbPolicies []*BackendServiceLocalityLoadBalancingPolicyConfig `json:"localityLbPolicies,omitempty"`

	// LocalityLbPolicy: The load balancing algorithm used within the scope
	// of the locality. The possible values are: - ROUND_ROBIN: This is a
	// simple policy in which each healthy backend is selected in round
	// robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm
	// which selects two random healthy hosts and picks the host which has
	// fewer active requests. - RING_HASH: The ring/modulo hash load
	// balancer implements consistent hashing to backends. The algorithm has
	// the property that the addition/removal of a host from a set of N
	// hosts only affects 1/N of the requests. - RANDOM: The load balancer
	// selects a random healthy host. - ORIGINAL_DESTINATION: Backend host
	// is selected based on the client connection metadata, i.e.,
	// connections are opened to the same address as the destination address
	// of the incoming connection before the connection was redirected to
	// the load balancer. - MAGLEV: used as a drop in replacement for the
	// ring hash load balancer. Maglev is not as stable as ring hash but has
	// faster table lookup build times and host selection times. For more
	// information about Maglev, see
	// https://ai.google/research/pubs/pub44824 This field is applicable to
	// either: - A regional backend service with the service_protocol set to
	// HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
	// INTERNAL_MANAGED. - A global backend service with the
	// load_balancing_scheme set to INTERNAL_SELF_MANAGED. If
	// sessionAffinity is not NONE, and this field is not set to MAGLEV or
	// RING_HASH, session affinity settings will not take effect. Only
	// ROUND_ROBIN and RING_HASH are supported when the backend service is
	// referenced by a URL map that is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	//
	// Possible values:
	//   "INVALID_LB_POLICY"
	//   "LEAST_REQUEST" - An O(1) algorithm which selects two random
	// healthy hosts and picks the host which has fewer active requests.
	//   "MAGLEV" - This algorithm implements consistent hashing to
	// backends. Maglev can be used as a drop in replacement for the ring
	// hash load balancer. Maglev is not as stable as ring hash but has
	// faster table lookup build times and host selection times. For more
	// information about Maglev, see
	// https://ai.google/research/pubs/pub44824
	//   "ORIGINAL_DESTINATION" - Backend host is selected based on the
	// client connection metadata, i.e., connections are opened to the same
	// address as the destination address of the incoming connection before
	// the connection was redirected to the load balancer.
	//   "RANDOM" - The load balancer selects a random healthy host.
	//   "RING_HASH" - The ring/modulo hash load balancer implements
	// consistent hashing to backends. The algorithm has the property that
	// the addition/removal of a host from a set of N hosts only affects 1/N
	// of the requests.
	//   "ROUND_ROBIN" - This is a simple policy in which each healthy
	// backend is selected in round robin order. This is the default.
	//   "WEIGHTED_MAGLEV" - Per-instance weighted Load Balancing via health
	// check reported weights. If set, the Backend Service must configure a
	// non legacy HTTP-based Health Check, and health check replies are
	// expected to contain non-standard HTTP response header field
	// X-Load-Balancing-Endpoint-Weight to specify the per-instance weights.
	// If set, Load Balancing is weighted based on the per-instance weights
	// reported in the last processed health check replies, as long as every
	// instance either reported a valid weight or had UNAVAILABLE_WEIGHT.
	// Otherwise, Load Balancing remains equal-weight. This option is only
	// supported in Network Load Balancing.
	LocalityLbPolicy string `json:"localityLbPolicy,omitempty"`

	// LogConfig: This field denotes the logging options for the load
	// balancer traffic served by this backend service. If logging is
	// enabled, logs will be exported to Stackdriver.
	LogConfig *BackendServiceLogConfig `json:"logConfig,omitempty"`

	// MaxStreamDuration: Specifies the default maximum duration (timeout)
	// for streams to this service. Duration is computed from the beginning
	// of the stream until the response has been completely processed,
	// including all retries. A stream that does not complete in this
	// duration is closed. If not specified, there will be no timeout limit,
	// i.e. the maximum duration is infinite. This value can be overridden
	// in the PathMatcher configuration of the UrlMap that references this
	// backend service. This field is only allowed when the
	// loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
	MaxStreamDuration *Duration `json:"maxStreamDuration,omitempty"`

	// Metadatas: Deployment metadata associated with the resource to be set
	// by a GKE hub controller and read by the backend RCTH
	Metadatas map[string]string `json:"metadatas,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Network: The URL of the network to which this backend service
	// belongs. This field can only be specified when the load balancing
	// scheme is set to INTERNAL.
	Network string `json:"network,omitempty"`

	// OutlierDetection: Settings controlling the eviction of unhealthy
	// hosts from the load balancing pool for the backend service. If not
	// set, this feature is considered disabled. This field is applicable to
	// either: - A regional backend service with the service_protocol set to
	// HTTP, HTTPS, HTTP2, or GRPC, and load_balancing_scheme set to
	// INTERNAL_MANAGED. - A global backend service with the
	// load_balancing_scheme set to INTERNAL_SELF_MANAGED.
	OutlierDetection *OutlierDetection `json:"outlierDetection,omitempty"`

	// Port: Deprecated in favor of portName. The TCP port to connect on the
	// backend. The default value is 80. For Internal TCP/UDP Load Balancing
	// and Network Load Balancing, omit port.
	Port int64 `json:"port,omitempty"`

	// PortName: A named port on a backend instance group representing the
	// port for communication to the backend VMs in that group. The named
	// port must be defined on each backend instance group
	// (https://cloud.google.com/load-balancing/docs/backend-service#named_ports).
	// This parameter has no meaning if the backends are NEGs. For Internal
	// TCP/UDP Load Balancing and Network Load Balancing, omit port_name.
	PortName string `json:"portName,omitempty"`

	// Protocol: The protocol this BackendService uses to communicate with
	// backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or
	// GRPC. depending on the chosen load balancer or Traffic Director
	// configuration. Refer to the documentation for the load balancers or
	// for Traffic Director for more information. Must be set to GRPC when
	// the backend service is referenced by a URL map that is bound to
	// target gRPC proxy.
	//
	// Possible values:
	//   "ALL" - ALL includes TCP, UDP, ICMP, ESP, AH and SCTP. Note that
	// this should never be used together with target_xx_proxies.
	//   "GRPC" - gRPC (available for Traffic Director).
	//   "HTTP"
	//   "HTTP2" - HTTP/2 with SSL.
	//   "HTTPS"
	//   "SSL" - TCP proxying with SSL.
	//   "TCP" - TCP proxying or TCP pass-through.
	//   "UDP" - UDP.
	//   "UNSPECIFIED" - If a Backend Service has UNSPECIFIED as its
	// protocol, it can be used with any L3/L4 Forwarding Rules.
	Protocol string `json:"protocol,omitempty"`

	// Region: [Output Only] URL of the region where the regional backend
	// service resides. This field is not applicable to global backend
	// services. You must specify this field as part of the HTTP request
	// URL. It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SecurityPolicy: [Output Only] The resource URL for the security
	// policy associated with this backend service.
	SecurityPolicy string `json:"securityPolicy,omitempty"`

	// SecuritySettings: This field specifies the security settings that
	// apply to this backend service. This field is applicable to a global
	// backend service with the load_balancing_scheme set to
	// INTERNAL_SELF_MANAGED.
	SecuritySettings *SecuritySettings `json:"securitySettings,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServiceBindings: URLs of networkservices.ServiceBinding resources.
	// Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If
	// set, lists of backends and health checks must be both empty.
	ServiceBindings []string `json:"serviceBindings,omitempty"`

	// ServiceLbPolicy: URL to networkservices.ServiceLbPolicy resource. Can
	// only be set if load balancing scheme is EXTERNAL, INTERNAL_MANAGED or
	// INTERNAL_SELF_MANAGED. If used with a backend service, must reference
	// a global policy. If used with a regional backend service, must
	// reference a regional policy.
	ServiceLbPolicy string `json:"serviceLbPolicy,omitempty"`

	// SessionAffinity: Type of session affinity to use. The default is
	// NONE. Only NONE and HEADER_FIELD are supported when the backend
	// service is referenced by a URL map that is bound to target gRPC proxy
	// that has validateForProxyless field set to true. For more details,
	// see: Session Affinity
	// (https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
	//
	// Possible values:
	//   "CLIENT_IP" - 2-tuple hash on packet's source and destination IP
	// addresses. Connections from the same source IP address to the same
	// destination IP address will be served by the same backend VM while
	// that VM remains healthy.
	//   "CLIENT_IP_NO_DESTINATION" - 1-tuple hash only on packet's source
	// IP address. Connections from the same source IP address will be
	// served by the same backend VM while that VM remains healthy. This
	// option can only be used for Internal TCP/UDP Load Balancing.
	//   "CLIENT_IP_PORT_PROTO" - 5-tuple hash on packet's source and
	// destination IP addresses, IP protocol, and source and destination
	// ports. Connections for the same IP protocol from the same source IP
	// address and port to the same destination IP address and port will be
	// served by the same backend VM while that VM remains healthy. This
	// option cannot be used for HTTP(S) load balancing.
	//   "CLIENT_IP_PROTO" - 3-tuple hash on packet's source and destination
	// IP addresses, and IP protocol. Connections for the same IP protocol
	// from the same source IP address to the same destination IP address
	// will be served by the same backend VM while that VM remains healthy.
	// This option cannot be used for HTTP(S) load balancing.
	//   "GENERATED_COOKIE" - Hash based on a cookie generated by the L7
	// loadbalancer. Only valid for HTTP(S) load balancing.
	//   "HEADER_FIELD" - The hash is based on a user specified header
	// field.
	//   "HTTP_COOKIE" - The hash is based on a user provided cookie.
	//   "NONE" - No session affinity. Connections from the same client IP
	// may go to any instance in the pool.
	SessionAffinity string `json:"sessionAffinity,omitempty"`

	Subsetting *Subsetting `json:"subsetting,omitempty"`

	// TimeoutSec: The backend service timeout has a different meaning
	// depending on the type of load balancer. For more information see,
	// Backend service settings. The default is 30 seconds. The full range
	// of timeout values allowed goes from 1 through 2,147,483,647 seconds.
	// This value can be overridden in the PathMatcher configuration of the
	// UrlMap that references this backend service. Not supported when the
	// backend service is referenced by a URL map that is bound to target
	// gRPC proxy that has validateForProxyless field set to true. Instead,
	// use maxStreamDuration.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// VpcNetworkScope: The network scope of the backends that can be added
	// to the backend service. This field can be either GLOBAL_VPC_NETWORK
	// or REGIONAL_VPC_NETWORK. A backend service with the VPC scope set to
	// GLOBAL_VPC_NETWORK is only allowed to have backends in global VPC
	// networks. When the VPC scope is set to REGIONAL_VPC_NETWORK the
	// backend service is only allowed to have backends in regional networks
	// in the same scope as the backend service. Note: if not specified then
	// GLOBAL_VPC_NETWORK will be used.
	//
	// Possible values:
	//   "GLOBAL_VPC_NETWORK" - The backend service can only have backends
	// in global VPCs
	//   "REGIONAL_VPC_NETWORK" - The backend service can only have backends
	// in regional VPCs
	VpcNetworkScope string `json:"vpcNetworkScope,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AffinityCookieTtlSec") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AffinityCookieTtlSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendService) MarshalJSON() ([]byte, error) {
	type NoMethod BackendService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceAggregatedList: Contains a list of
// BackendServicesScopedList.
type BackendServiceAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of BackendServicesScopedList resources.
	Items map[string]BackendServicesScopedList `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *BackendServiceAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceAggregatedListWarning: [Output Only] Informational
// warning message.
type BackendServiceAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*BackendServiceAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServiceAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceCdnPolicy: Message containing Cloud CDN configuration
// for a backend service.
type BackendServiceCdnPolicy struct {
	// BypassCacheOnRequestHeaders: Bypass the cache when the specified
	// request headers are matched - e.g. Pragma or Authorization headers.
	// Up to 5 headers can be specified. The cache is bypassed for all
	// cdnPolicy.cacheMode settings.
	BypassCacheOnRequestHeaders []*BackendServiceCdnPolicyBypassCacheOnRequestHeader `json:"bypassCacheOnRequestHeaders,omitempty"`

	// CacheKeyPolicy: The CacheKeyPolicy for this CdnPolicy.
	CacheKeyPolicy *CacheKeyPolicy `json:"cacheKeyPolicy,omitempty"`

	// CacheMode: Specifies the cache setting for all responses from this
	// backend. The possible values are: USE_ORIGIN_HEADERS Requires the
	// origin to set valid caching headers to cache content. Responses
	// without these headers will not be cached at Google's edge, and will
	// require a full trip to the origin on every request, potentially
	// impacting performance and increasing load on the origin server.
	// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store"
	// or "no-cache" directives in Cache-Control response headers. Warning:
	// this may result in Cloud CDN caching private, per-user (user
	// identifiable) content. CACHE_ALL_STATIC Automatically cache static
	// content, including common image formats, media (video and audio), and
	// web assets (JavaScript and CSS). Requests and responses that are
	// marked as uncacheable, as well as dynamic content (including HTML),
	// will not be cached.
	//
	// Possible values:
	//   "CACHE_ALL_STATIC" - Automatically cache static content, including
	// common image formats, media (video and audio), and web assets
	// (JavaScript and CSS). Requests and responses that are marked as
	// uncacheable, as well as dynamic content (including HTML), will not be
	// cached.
	//   "FORCE_CACHE_ALL" - Cache all content, ignoring any "private",
	// "no-store" or "no-cache" directives in Cache-Control response
	// headers. Warning: this may result in Cloud CDN caching private,
	// per-user (user identifiable) content.
	//   "INVALID_CACHE_MODE"
	//   "USE_ORIGIN_HEADERS" - Requires the origin to set valid caching
	// headers to cache content. Responses without these headers will not be
	// cached at Google's edge, and will require a full trip to the origin
	// on every request, potentially impacting performance and increasing
	// load on the origin server.
	CacheMode string `json:"cacheMode,omitempty"`

	// ClientTtl: Specifies a separate client (e.g. browser client) maximum
	// TTL. This is used to clamp the max-age (or Expires) value sent to the
	// client. With FORCE_CACHE_ALL, the lesser of client_ttl and
	// default_ttl is used for the response max-age directive, along with a
	// "public" directive. For cacheable content in CACHE_ALL_STATIC mode,
	// client_ttl clamps the max-age from the origin (if specified), or else
	// sets the response max-age directive to the lesser of the client_ttl
	// and default_ttl, and also ensures a "public" cache-control directive
	// is present. If a client TTL is not specified, a default value (1
	// hour) will be used. The maximum allowed value is 31,622,400s (1
	// year).
	ClientTtl int64 `json:"clientTtl,omitempty"`

	// DefaultTtl: Specifies the default TTL for cached content served by
	// this origin for responses that do not have an existing valid TTL
	// (max-age or s-max-age). Setting a TTL of "0" means "always
	// revalidate". The value of defaultTTL cannot be set to a value greater
	// than that of maxTTL, but can be equal. When the cacheMode is set to
	// FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all
	// responses. The maximum allowed value is 31,622,400s (1 year), noting
	// that infrequently accessed objects may be evicted from the cache
	// before the defined TTL.
	DefaultTtl int64 `json:"defaultTtl,omitempty"`

	// MaxTtl: Specifies the maximum allowed TTL for cached content served
	// by this origin. Cache directives that attempt to set a max-age or
	// s-maxage higher than this, or an Expires header more than maxTTL
	// seconds in the future will be capped at the value of maxTTL, as if it
	// were the value of an s-maxage Cache-Control directive. Headers sent
	// to the client will not be modified. Setting a TTL of "0" means
	// "always revalidate". The maximum allowed value is 31,622,400s (1
	// year), noting that infrequently accessed objects may be evicted from
	// the cache before the defined TTL.
	MaxTtl int64 `json:"maxTtl,omitempty"`

	// NegativeCaching: Negative caching allows per-status code TTLs to be
	// set, in order to apply fine-grained caching for common errors or
	// redirects. This can reduce the load on your origin and improve
	// end-user experience by reducing response latency. When the cache mode
	// is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching
	// applies to responses with the specified response code that lack any
	// Cache-Control, Expires, or Pragma: no-cache directives. When the
	// cache mode is set to FORCE_CACHE_ALL, negative caching applies to all
	// responses with the specified response code, and override any caching
	// headers. By default, Cloud CDN will apply the following default TTLs
	// to these status codes: HTTP 300 (Multiple Choice), 301, 308
	// (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451
	// (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found),
	// 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults
	// can be overridden in negative_caching_policy.
	NegativeCaching bool `json:"negativeCaching,omitempty"`

	// NegativeCachingPolicy: Sets a cache TTL for the specified HTTP status
	// code. negative_caching must be enabled to configure
	// negative_caching_policy. Omitting the policy and leaving
	// negative_caching enabled will use Cloud CDN's default cache TTLs.
	// Note that when specifying an explicit negative_caching_policy, you
	// should take care to specify a cache TTL for all response codes that
	// you wish to cache. Cloud CDN will not apply any default negative
	// caching when a policy exists.
	NegativeCachingPolicy []*BackendServiceCdnPolicyNegativeCachingPolicy `json:"negativeCachingPolicy,omitempty"`

	// RequestCoalescing: If true then Cloud CDN will combine multiple
	// concurrent cache fill requests into a small number of requests to the
	// origin.
	RequestCoalescing bool `json:"requestCoalescing,omitempty"`

	// ServeWhileStale: Serve existing content from the cache (if available)
	// when revalidating content with the origin, or when an error is
	// encountered when refreshing the cache. This setting defines the
	// default "max-stale" duration for any cached responses that do not
	// specify a max-stale directive. Stale responses that exceed the TTL
	// configured here will not be served. The default limit (max-stale) is
	// 86400s (1 day), which will allow stale content to be served up to
	// this limit beyond the max-age (or s-max-age) of a cached response.
	// The maximum allowed value is 604800 (1 week). Set this to zero (0) to
	// disable serve-while-stale.
	ServeWhileStale int64 `json:"serveWhileStale,omitempty"`

	// SignedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
	// signed URL request will be considered fresh. After this time period,
	// the response will be revalidated before being served. Defaults to 1hr
	// (3600s). When serving responses to signed URL requests, Cloud CDN
	// will internally behave as though all responses from this backend had
	// a "Cache-Control: public, max-age=[TTL]" header, regardless of any
	// existing Cache-Control header. The actual headers served in responses
	// will not be altered.
	SignedUrlCacheMaxAgeSec int64 `json:"signedUrlCacheMaxAgeSec,omitempty,string"`

	// SignedUrlKeyNames: [Output Only] Names of the keys for signing
	// request URLs.
	SignedUrlKeyNames []string `json:"signedUrlKeyNames,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceCdnPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceCdnPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceCdnPolicyBypassCacheOnRequestHeader: Bypass the cache
// when the specified request headers are present, e.g. Pragma or
// Authorization headers. Values are case insensitive. The presence of
// such a header overrides the cache_mode setting.
type BackendServiceCdnPolicyBypassCacheOnRequestHeader struct {
	// HeaderName: The header field name to match on when bypassing cache.
	// Values are case-insensitive.
	HeaderName string `json:"headerName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HeaderName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HeaderName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceCdnPolicyBypassCacheOnRequestHeader) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceCdnPolicyBypassCacheOnRequestHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceCdnPolicyNegativeCachingPolicy: Specify CDN TTLs for
// response error codes.
type BackendServiceCdnPolicyNegativeCachingPolicy struct {
	// Code: The HTTP status code to define a TTL against. Only HTTP status
	// codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are
	// can be specified as values, and you cannot specify a status code more
	// than once.
	Code int64 `json:"code,omitempty"`

	// Ttl: The TTL (in seconds) for which to cache responses with the
	// corresponding status code. The maximum allowed value is 1800s (30
	// minutes), noting that infrequently accessed objects may be evicted
	// from the cache before the defined TTL.
	Ttl int64 `json:"ttl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceCdnPolicyNegativeCachingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceCdnPolicyNegativeCachingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceConnectionTrackingPolicy: Connection Tracking
// configuration for this BackendService.
type BackendServiceConnectionTrackingPolicy struct {
	// ConnectionPersistenceOnUnhealthyBackends: Specifies connection
	// persistence when backends are unhealthy. The default value is
	// DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing
	// connections persist on unhealthy backends only for
	// connection-oriented protocols (TCP and SCTP) and only if the Tracking
	// Mode is PER_CONNECTION (default tracking mode) or the Session
	// Affinity is configured for 5-tuple. They do not persist for UDP. If
	// set to NEVER_PERSIST, after a backend becomes unhealthy, the existing
	// connections on the unhealthy backend are never persisted on the
	// unhealthy backend. They are always diverted to newly selected healthy
	// backends (unless all backends are unhealthy). If set to
	// ALWAYS_PERSIST, existing connections always persist on unhealthy
	// backends regardless of protocol and session affinity. It is generally
	// not recommended to use this mode overriding the default. For more
	// details, see Connection Persistence for Network Load Balancing
	// (https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence)
	// and Connection Persistence for Internal TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
	//
	// Possible values:
	//   "ALWAYS_PERSIST"
	//   "DEFAULT_FOR_PROTOCOL"
	//   "NEVER_PERSIST"
	ConnectionPersistenceOnUnhealthyBackends string `json:"connectionPersistenceOnUnhealthyBackends,omitempty"`

	// EnableStrongAffinity: Enable Strong Session Affinity for Network Load
	// Balancing. This option is not available publicly.
	EnableStrongAffinity bool `json:"enableStrongAffinity,omitempty"`

	// IdleTimeoutSec: Specifies how long to keep a Connection Tracking
	// entry while there is no matching traffic (in seconds). For Internal
	// TCP/UDP Load Balancing: - The minimum (default) is 10 minutes and the
	// maximum is 16 hours. - It can be set only if Connection Tracking is
	// less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION,
	// CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For
	// Network Load Balancer the default is 60 seconds. This option is not
	// available publicly.
	IdleTimeoutSec int64 `json:"idleTimeoutSec,omitempty"`

	// TrackingMode: Specifies the key used for connection tracking. There
	// are two options: - PER_CONNECTION: This is the default mode. The
	// Connection Tracking is performed as per the Connection Key (default
	// Hash Method) for the specific protocol. - PER_SESSION: The Connection
	// Tracking is performed as per the configured Session Affinity. It
	// matches the configured Session Affinity. For more details, see
	// Tracking Mode for Network Load Balancing
	// (https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode)
	// and Tracking Mode for Internal TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
	//
	// Possible values:
	//   "INVALID_TRACKING_MODE"
	//   "PER_CONNECTION"
	//   "PER_SESSION"
	TrackingMode string `json:"trackingMode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConnectionPersistenceOnUnhealthyBackends") to unconditionally
	// include in API requests. By default, fields with empty or default
	// values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ConnectionPersistenceOnUnhealthyBackends") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceConnectionTrackingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceConnectionTrackingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceFailoverPolicy: For load balancers that have
// configurable failover: Internal TCP/UDP Load Balancing
// (https://cloud.google.com/load-balancing/docs/internal/failover-overview)
// and external TCP/UDP Load Balancing
// (https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
// On failover or failback, this field indicates whether connection
// draining will be honored. Google Cloud has a fixed connection
// draining timeout of 10 minutes. A setting of true terminates existing
// TCP connections to the active pool during failover and failback,
// immediately draining traffic. A setting of false allows existing TCP
// connections to persist, even on VMs no longer in the active pool, for
// up to the duration of the connection draining timeout (10 minutes).
type BackendServiceFailoverPolicy struct {
	// DisableConnectionDrainOnFailover: This can be set to true only if the
	// protocol is TCP. The default is false.
	DisableConnectionDrainOnFailover bool `json:"disableConnectionDrainOnFailover,omitempty"`

	// DropTrafficIfUnhealthy: If set to true, connections to the load
	// balancer are dropped when all primary and all backup backend VMs are
	// unhealthy.If set to false, connections are distributed among all
	// primary VMs when all primary and all backup backend VMs are
	// unhealthy. For load balancers that have configurable failover:
	// Internal TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/internal/failover-overview)
	// and external TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
	// The default is false.
	DropTrafficIfUnhealthy bool `json:"dropTrafficIfUnhealthy,omitempty"`

	// FailoverRatio: The value of the field must be in the range [0, 1]. If
	// the value is 0, the load balancer performs a failover when the number
	// of healthy primary VMs equals zero. For all other values, the load
	// balancer performs a failover when the total number of healthy primary
	// VMs is less than this ratio. For load balancers that have
	// configurable failover: Internal TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/internal/failover-overview)
	// and external TCP/UDP Load Balancing
	// (https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
	FailoverRatio float64 `json:"failoverRatio,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DisableConnectionDrainOnFailover") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DisableConnectionDrainOnFailover") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceFailoverPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceFailoverPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *BackendServiceFailoverPolicy) UnmarshalJSON(data []byte) error {
	type NoMethod BackendServiceFailoverPolicy
	var s1 struct {
		FailoverRatio gensupport.JSONFloat64 `json:"failoverRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FailoverRatio = float64(s1.FailoverRatio)
	return nil
}

type BackendServiceGroupHealth struct {
	// Annotations: Metadata defined as annotations on the network endpoint
	// group.
	Annotations map[string]string `json:"annotations,omitempty"`

	// HealthStatus: Health state of the backend instances or endpoints in
	// requested instance or network endpoint group, determined based on
	// configured health checks.
	HealthStatus []*HealthStatus `json:"healthStatus,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#backendServiceGroupHealth for the health of backend services.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceGroupHealth) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceGroupHealth
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceIAP: Identity-Aware Proxy
type BackendServiceIAP struct {
	// Enabled: Whether the serving infrastructure will authenticate and
	// authorize all incoming requests. If true, the oauth2ClientId and
	// oauth2ClientSecret fields must be non-empty.
	Enabled bool `json:"enabled,omitempty"`

	// Oauth2ClientId: OAuth2 client ID to use for the authentication flow.
	Oauth2ClientId string `json:"oauth2ClientId,omitempty"`

	// Oauth2ClientInfo: [Input Only] OAuth client info required to generate
	// client id to be used for IAP.
	Oauth2ClientInfo *BackendServiceIAPOAuth2ClientInfo `json:"oauth2ClientInfo,omitempty"`

	// Oauth2ClientSecret: OAuth2 client secret to use for the
	// authentication flow. For security reasons, this value cannot be
	// retrieved via the API. Instead, the SHA-256 hash of the value is
	// returned in the oauth2ClientSecretSha256 field. @InputOnly
	Oauth2ClientSecret string `json:"oauth2ClientSecret,omitempty"`

	// Oauth2ClientSecretSha256: [Output Only] SHA256 hash value for the
	// field oauth2_client_secret above.
	Oauth2ClientSecretSha256 string `json:"oauth2ClientSecretSha256,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceIAP) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceIAP
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServiceIAPOAuth2ClientInfo struct {
	// ApplicationName: Application name to be used in OAuth consent screen.
	ApplicationName string `json:"applicationName,omitempty"`

	// ClientName: Name of the client to be generated. Optional - If not
	// provided, the name will be autogenerated by the backend.
	ClientName string `json:"clientName,omitempty"`

	// DeveloperEmailAddress: Developer's information to be used in OAuth
	// consent screen.
	DeveloperEmailAddress string `json:"developerEmailAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicationName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicationName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceIAPOAuth2ClientInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceIAPOAuth2ClientInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceList: Contains a list of BackendService resources.
type BackendServiceList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of BackendService resources.
	Items []*BackendService `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#backendServiceList for lists of backend services.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *BackendServiceListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceListWarning: [Output Only] Informational warning
// message.
type BackendServiceListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*BackendServiceListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServiceListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceLocalityLoadBalancingPolicyConfig: Container for either
// a built-in LB policy supported by gRPC or Envoy or a custom one
// implemented by the end user.
type BackendServiceLocalityLoadBalancingPolicyConfig struct {
	CustomPolicy *BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy `json:"customPolicy,omitempty"`

	Policy *BackendServiceLocalityLoadBalancingPolicyConfigPolicy `json:"policy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomPolicy") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceLocalityLoadBalancingPolicyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceLocalityLoadBalancingPolicyConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy: The
// configuration for a custom policy implemented by the user and
// deployed with the client.
type BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy struct {
	// Data: An optional, arbitrary JSON object with configuration data,
	// understood by a locally installed custom policy implementation.
	Data string `json:"data,omitempty"`

	// Name: Identifies the custom policy. The value should match the name
	// of a custom implementation registered on the gRPC clients. It should
	// follow protocol buffer message naming conventions and include the
	// full path (for example, myorg.CustomLbPolicy). The maximum length is
	// 256 characters. Do not specify the same custom policy more than once
	// for a backend. If you do, the configuration is rejected. For an
	// example of how to use this field, see Use a custom policy.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceLocalityLoadBalancingPolicyConfigPolicy: The
// configuration for a built-in load balancing policy.
type BackendServiceLocalityLoadBalancingPolicyConfigPolicy struct {
	// Name: The name of a locality load-balancing policy. Valid values
	// include ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For
	// information about these values, see the description of
	// localityLbPolicy. Do not specify the same policy more than once for a
	// backend. If you do, the configuration is rejected.
	//
	// Possible values:
	//   "INVALID_LB_POLICY"
	//   "LEAST_REQUEST" - An O(1) algorithm which selects two random
	// healthy hosts and picks the host which has fewer active requests.
	//   "MAGLEV" - This algorithm implements consistent hashing to
	// backends. Maglev can be used as a drop in replacement for the ring
	// hash load balancer. Maglev is not as stable as ring hash but has
	// faster table lookup build times and host selection times. For more
	// information about Maglev, see
	// https://ai.google/research/pubs/pub44824
	//   "ORIGINAL_DESTINATION" - Backend host is selected based on the
	// client connection metadata, i.e., connections are opened to the same
	// address as the destination address of the incoming connection before
	// the connection was redirected to the load balancer.
	//   "RANDOM" - The load balancer selects a random healthy host.
	//   "RING_HASH" - The ring/modulo hash load balancer implements
	// consistent hashing to backends. The algorithm has the property that
	// the addition/removal of a host from a set of N hosts only affects 1/N
	// of the requests.
	//   "ROUND_ROBIN" - This is a simple policy in which each healthy
	// backend is selected in round robin order. This is the default.
	//   "WEIGHTED_MAGLEV" - Per-instance weighted Load Balancing via health
	// check reported weights. If set, the Backend Service must configure a
	// non legacy HTTP-based Health Check, and health check replies are
	// expected to contain non-standard HTTP response header field
	// X-Load-Balancing-Endpoint-Weight to specify the per-instance weights.
	// If set, Load Balancing is weighted based on the per-instance weights
	// reported in the last processed health check replies, as long as every
	// instance either reported a valid weight or had UNAVAILABLE_WEIGHT.
	// Otherwise, Load Balancing remains equal-weight. This option is only
	// supported in Network Load Balancing.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceLocalityLoadBalancingPolicyConfigPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceLocalityLoadBalancingPolicyConfigPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceLogConfig: The available logging options for the load
// balancer traffic served by this backend service.
type BackendServiceLogConfig struct {
	// Enable: Denotes whether to enable logging for the load balancer
	// traffic served by this backend service. The default value is false.
	Enable bool `json:"enable,omitempty"`

	// Optional: Deprecated in favor of optionalMode. This field can only be
	// specified if logging is enabled for this backend service. Configures
	// whether all, none or a subset of optional fields should be added to
	// the reported logs. One of [INCLUDE_ALL_OPTIONAL,
	// EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
	//
	// Possible values:
	//   "CUSTOM" - A subset of optional fields.
	//   "EXCLUDE_ALL_OPTIONAL" - None optional fields.
	//   "INCLUDE_ALL_OPTIONAL" - All optional fields.
	//   "UNSPECIFIED_OPTIONAL_MODE"
	Optional string `json:"optional,omitempty"`

	// OptionalFields: This field can only be specified if logging is
	// enabled for this backend service and "logConfig.optionalMode" was set
	// to CUSTOM. Contains a list of optional fields you want to include in
	// the logs. For example: serverInstance, serverGkeDetails.cluster,
	// serverGkeDetails.pod.podNamespace
	OptionalFields []string `json:"optionalFields,omitempty"`

	// OptionalMode: This field can only be specified if logging is enabled
	// for this backend service. Configures whether all, none or a subset of
	// optional fields should be added to the reported logs. One of
	// [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is
	// EXCLUDE_ALL_OPTIONAL.
	//
	// Possible values:
	//   "CUSTOM" - A subset of optional fields.
	//   "EXCLUDE_ALL_OPTIONAL" - None optional fields.
	//   "INCLUDE_ALL_OPTIONAL" - All optional fields.
	//   "UNSPECIFIED_OPTIONAL_MODE"
	OptionalMode string `json:"optionalMode,omitempty"`

	// SampleRate: This field can only be specified if logging is enabled
	// for this backend service. The value of the field must be in [0, 1].
	// This configures the sampling rate of requests to the load balancer
	// where 1.0 means all logged requests are reported and 0.0 means no
	// logged requests are reported. The default value is 1.0.
	SampleRate float64 `json:"sampleRate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *BackendServiceLogConfig) UnmarshalJSON(data []byte) error {
	type NoMethod BackendServiceLogConfig
	var s1 struct {
		SampleRate gensupport.JSONFloat64 `json:"sampleRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SampleRate = float64(s1.SampleRate)
	return nil
}

type BackendServiceReference struct {
	BackendService string `json:"backendService,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackendService") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackendService") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceReference) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServicesScopedList struct {
	// BackendServices: A list of BackendServices contained in this scope.
	BackendServices []*BackendService `json:"backendServices,omitempty"`

	// Warning: Informational warning which replaces the list of backend
	// services when the list is empty.
	Warning *BackendServicesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackendServices") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackendServices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendServicesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServicesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServicesScopedListWarning: Informational warning which
// replaces the list of backend services when the list is empty.
type BackendServicesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*BackendServicesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServicesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServicesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServicesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServicesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServicesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BfdPacket struct {
	// AuthenticationPresent: The Authentication Present bit of the BFD
	// packet. This is specified in section 4.1 of RFC5880
	AuthenticationPresent bool `json:"authenticationPresent,omitempty"`

	// ControlPlaneIndependent: The Control Plane Independent bit of the BFD
	// packet. This is specified in section 4.1 of RFC5880
	ControlPlaneIndependent bool `json:"controlPlaneIndependent,omitempty"`

	// Demand: The demand bit of the BFD packet. This is specified in
	// section 4.1 of RFC5880
	Demand bool `json:"demand,omitempty"`

	// Diagnostic: The diagnostic code specifies the local system's reason
	// for the last change in session state. This allows remote systems to
	// determine the reason that the previous session failed, for example.
	// These diagnostic codes are specified in section 4.1 of RFC5880
	//
	// Possible values:
	//   "ADMINISTRATIVELY_DOWN"
	//   "CONCATENATED_PATH_DOWN"
	//   "CONTROL_DETECTION_TIME_EXPIRED"
	//   "DIAGNOSTIC_UNSPECIFIED"
	//   "ECHO_FUNCTION_FAILED"
	//   "FORWARDING_PLANE_RESET"
	//   "NEIGHBOR_SIGNALED_SESSION_DOWN"
	//   "NO_DIAGNOSTIC"
	//   "PATH_DOWN"
	//   "REVERSE_CONCATENATED_PATH_DOWN"
	Diagnostic string `json:"diagnostic,omitempty"`

	// Final: The Final bit of the BFD packet. This is specified in section
	// 4.1 of RFC5880
	Final bool `json:"final,omitempty"`

	// Length: The length of the BFD Control packet in bytes. This is
	// specified in section 4.1 of RFC5880
	Length int64 `json:"length,omitempty"`

	// MinEchoRxIntervalMs: The Required Min Echo RX Interval value in the
	// BFD packet. This is specified in section 4.1 of RFC5880
	MinEchoRxIntervalMs int64 `json:"minEchoRxIntervalMs,omitempty"`

	// MinRxIntervalMs: The Required Min RX Interval value in the BFD
	// packet. This is specified in section 4.1 of RFC5880
	MinRxIntervalMs int64 `json:"minRxIntervalMs,omitempty"`

	// MinTxIntervalMs: The Desired Min TX Interval value in the BFD packet.
	// This is specified in section 4.1 of RFC5880
	MinTxIntervalMs int64 `json:"minTxIntervalMs,omitempty"`

	// Multiplier: The detection time multiplier of the BFD packet. This is
	// specified in section 4.1 of RFC5880
	Multiplier int64 `json:"multiplier,omitempty"`

	// Multipoint: The multipoint bit of the BFD packet. This is specified
	// in section 4.1 of RFC5880
	Multipoint bool `json:"multipoint,omitempty"`

	// MyDiscriminator: The My Discriminator value in the BFD packet. This
	// is specified in section 4.1 of RFC5880
	MyDiscriminator int64 `json:"myDiscriminator,omitempty"`

	// Poll: The Poll bit of the BFD packet. This is specified in section
	// 4.1 of RFC5880
	Poll bool `json:"poll,omitempty"`

	// State: The current BFD session state as seen by the transmitting
	// system. These states are specified in section 4.1 of RFC5880
	//
	// Possible values:
	//   "ADMIN_DOWN"
	//   "DOWN"
	//   "INIT"
	//   "STATE_UNSPECIFIED"
	//   "UP"
	State string `json:"state,omitempty"`

	// Version: The version number of the BFD protocol, as specified in
	// section 4.1 of RFC5880.
	Version int64 `json:"version,omitempty"`

	// YourDiscriminator: The Your Discriminator value in the BFD packet.
	// This is specified in section 4.1 of RFC5880
	YourDiscriminator int64 `json:"yourDiscriminator,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AuthenticationPresent") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthenticationPresent") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BfdPacket) MarshalJSON() ([]byte, error) {
	type NoMethod BfdPacket
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BfdStatus: Next free: 15
type BfdStatus struct {
	// BfdSessionInitializationMode: The BFD session initialization mode for
	// this BGP peer. If set to ACTIVE, the Cloud Router will initiate the
	// BFD session for this BGP peer. If set to PASSIVE, the Cloud Router
	// will wait for the peer router to initiate the BFD session for this
	// BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
	//
	// Possible values:
	//   "ACTIVE"
	//   "DISABLED"
	//   "PASSIVE"
	BfdSessionInitializationMode string `json:"bfdSessionInitializationMode,omitempty"`

	// ConfigUpdateTimestampMicros: Unix timestamp of the most recent config
	// update.
	ConfigUpdateTimestampMicros int64 `json:"configUpdateTimestampMicros,omitempty,string"`

	// ControlPacketCounts: Control packet counts for the current BFD
	// session.
	ControlPacketCounts *BfdStatusPacketCounts `json:"controlPacketCounts,omitempty"`

	// ControlPacketIntervals: Inter-packet time interval statistics for
	// control packets.
	ControlPacketIntervals []*PacketIntervals `json:"controlPacketIntervals,omitempty"`

	// EchoPacketCounts: Echo packet counts for the current BFD session.
	EchoPacketCounts *BfdStatusPacketCounts `json:"echoPacketCounts,omitempty"`

	// EchoPacketIntervals: Inter-packet time interval statistics for echo
	// packets.
	EchoPacketIntervals []*PacketIntervals `json:"echoPacketIntervals,omitempty"`

	// LocalDiagnostic: The diagnostic code specifies the local system's
	// reason for the last change in session state. This allows remote
	// systems to determine the reason that the previous session failed, for
	// example. These diagnostic codes are specified in section 4.1 of
	// RFC5880
	//
	// Possible values:
	//   "ADMINISTRATIVELY_DOWN"
	//   "CONCATENATED_PATH_DOWN"
	//   "CONTROL_DETECTION_TIME_EXPIRED"
	//   "DIAGNOSTIC_UNSPECIFIED"
	//   "ECHO_FUNCTION_FAILED"
	//   "FORWARDING_PLANE_RESET"
	//   "NEIGHBOR_SIGNALED_SESSION_DOWN"
	//   "NO_DIAGNOSTIC"
	//   "PATH_DOWN"
	//   "REVERSE_CONCATENATED_PATH_DOWN"
	LocalDiagnostic string `json:"localDiagnostic,omitempty"`

	// LocalState: The current BFD session state as seen by the transmitting
	// system. These states are specified in section 4.1 of RFC5880
	//
	// Possible values:
	//   "ADMIN_DOWN"
	//   "DOWN"
	//   "INIT"
	//   "STATE_UNSPECIFIED"
	//   "UP"
	LocalState string `json:"localState,omitempty"`

	// NegotiatedLocalControlTxIntervalMs: Negotiated transmit interval for
	// control packets.
	NegotiatedLocalControlTxIntervalMs int64 `json:"negotiatedLocalControlTxIntervalMs,omitempty"`

	// NegotiatedLocalEchoTxIntervalMs: Negotiated transmit interval for
	// echo packets.
	NegotiatedLocalEchoTxIntervalMs int64 `json:"negotiatedLocalEchoTxIntervalMs,omitempty"`

	// RxPacket: The most recent Rx control packet for this BFD session.
	RxPacket *BfdPacket `json:"rxPacket,omitempty"`

	// TxPacket: The most recent Tx control packet for this BFD session.
	TxPacket *BfdPacket `json:"txPacket,omitempty"`

	// UptimeMs: Session uptime in milliseconds. Value will be 0 if session
	// is not up.
	UptimeMs int64 `json:"uptimeMs,omitempty,string"`

	// UsingEchoMode: Indicates if echo mode is currently being used.
	UsingEchoMode bool `json:"usingEchoMode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BfdSessionInitializationMode") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "BfdSessionInitializationMode") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BfdStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BfdStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BfdStatusPacketCounts struct {
	// NumRx: Number of packets received since the beginning of the current
	// BFD session.
	NumRx int64 `json:"numRx,omitempty"`

	// NumRxRejected: Number of packets received that were rejected because
	// of errors since the beginning of the current BFD session.
	NumRxRejected int64 `json:"numRxRejected,omitempty"`

	// NumRxSuccessful: Number of packets received that were successfully
	// processed since the beginning of the current BFD session.
	NumRxSuccessful int64 `json:"numRxSuccessful,omitempty"`

	// NumTx: Number of packets transmitted since the beginning of the
	// current BFD session.
	NumTx int64 `json:"numTx,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NumRx") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NumRx") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BfdStatusPacketCounts) MarshalJSON() ([]byte, error) {
	type NoMethod BfdStatusPacketCounts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// BindingId: This is deprecated and has no effect. Do not use.
	BindingId string `json:"bindingId,omitempty"`

	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers
	// (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address
	// that represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
	//  An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`. * `domain:{domain}`: The G Suite
	// domain (primary) that represents all the users of that domain. For
	// example, `google.com` or `example.com`. *
	// `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently
	// deleted. For example, `alice@example.com?uid=123456789012345678901`.
	// If the user is recovered, this value reverts to `user:{emailid}` and
	// the recovered user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BindingId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BindingId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BulkInsertDiskResource: A transient resource used in
// compute.disks.bulkInsert and compute.regionDisks.bulkInsert. It is
// only used to process requests and is not persisted.
type BulkInsertDiskResource struct {
	// SourceConsistencyGroupPolicy: The URL of the
	// DiskConsistencyGroupPolicy for the group of disks to clone. This may
	// be a full or partial URL, such as: -
	// https://www.googleapis.com/compute/v1/projects/project/regions/region
	// /resourcePolicies/resourcePolicy -
	// projects/project/regions/region/resourcePolicies/resourcePolicy -
	// regions/region/resourcePolicies/resourcePolicy
	SourceConsistencyGroupPolicy string `json:"sourceConsistencyGroupPolicy,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SourceConsistencyGroupPolicy") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SourceConsistencyGroupPolicy") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BulkInsertDiskResource) MarshalJSON() ([]byte, error) {
	type NoMethod BulkInsertDiskResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BulkInsertInstanceResource: A transient resource used in
// compute.instances.bulkInsert and compute.regionInstances.bulkInsert .
// This resource is not persisted anywhere, it is used only for
// processing the requests.
type BulkInsertInstanceResource struct {
	// Count: The maximum number of instances to create.
	Count int64 `json:"count,omitempty,string"`

	// InstanceProperties: The instance properties defining the VM instances
	// to be created. Required if sourceInstanceTemplate is not provided.
	InstanceProperties *InstanceProperties `json:"instanceProperties,omitempty"`

	// LocationPolicy: Policy for chosing target zone. For more information,
	// see Create VMs in bulk .
	LocationPolicy *LocationPolicy `json:"locationPolicy,omitempty"`

	// MinCount: The minimum number of instances to create. If no min_count
	// is specified then count is used as the default value. If min_count
	// instances cannot be created, then no instances will be created and
	// instances already created will be deleted.
	MinCount int64 `json:"minCount,omitempty,string"`

	// NamePattern: The string pattern used for the names of the VMs. Either
	// name_pattern or per_instance_properties must be set. The pattern must
	// contain one continuous sequence of placeholder hash characters (#)
	// with each character corresponding to one digit of the generated
	// instance name. Example: a name_pattern of inst-#### generates
	// instance names such as inst-0001 and inst-0002. If existing instances
	// in the same project and zone have names that match the name pattern
	// then the generated instance numbers start after the biggest existing
	// number. For example, if there exists an instance with name inst-0050,
	// then instance names generated using the pattern inst-#### begin with
	// inst-0051. The name pattern placeholder #...# can contain up to 18
	// characters.
	NamePattern string `json:"namePattern,omitempty"`

	// PerInstanceProperties: Per-instance properties to be set on
	// individual instances. Keys of this map specify requested instance
	// names. Can be empty if name_pattern is used.
	PerInstanceProperties map[string]BulkInsertInstanceResourcePerInstanceProperties `json:"perInstanceProperties,omitempty"`

	// SourceInstanceTemplate: Specifies the instance template from which to
	// create instances. You may combine sourceInstanceTemplate with
	// instanceProperties to override specific values from an existing
	// instance template. Bulk API follows the semantics of JSON Merge Patch
	// described by RFC 7396. It can be a full or partial URL. For example,
	// the following are all valid URLs to an instance template: -
	// https://www.googleapis.com/compute/v1/projects/project
	// /global/instanceTemplates/instanceTemplate -
	// projects/project/global/instanceTemplates/instanceTemplate -
	// global/instanceTemplates/instanceTemplate This field is optional.
	SourceInstanceTemplate string `json:"sourceInstanceTemplate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BulkInsertInstanceResource) MarshalJSON() ([]byte, error) {
	type NoMethod BulkInsertInstanceResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BulkInsertInstanceResourcePerInstanceProperties: Per-instance
// properties to be set on individual instances. To be extended in the
// future.
type BulkInsertInstanceResourcePerInstanceProperties struct {
	// Hostname: Specifies the hostname of the instance. More details in:
	// https://cloud.google.com/compute/docs/instances/custom-hostname-vm#naming_convention
	Hostname string `json:"hostname,omitempty"`

	// Name: This field is only temporary. It will be removed. Do not use
	// it.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Hostname") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Hostname") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BulkInsertInstanceResourcePerInstanceProperties) MarshalJSON() ([]byte, error) {
	type NoMethod BulkInsertInstanceResourcePerInstanceProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BulkInsertOperationStatus struct {
	// CreatedVmCount: [Output Only] Count of VMs successfully created so
	// far.
	CreatedVmCount int64 `json:"createdVmCount,omitempty"`

	// DeletedVmCount: [Output Only] Count of VMs that got deleted during
	// rollback.
	DeletedVmCount int64 `json:"deletedVmCount,omitempty"`

	// FailedToCreateVmCount: [Output Only] Count of VMs that started
	// creating but encountered an error.
	FailedToCreateVmCount int64 `json:"failedToCreateVmCount,omitempty"`

	// Status: [Output Only] Creation status of BulkInsert operation -
	// information if the flow is rolling forward or rolling back.
	//
	// Possible values:
	//   "CREATING" - Rolling forward - creating VMs.
	//   "DONE" - Done
	//   "ROLLING_BACK" - Rolling back - cleaning up after an error.
	//   "STATUS_UNSPECIFIED"
	Status string `json:"status,omitempty"`

	// TargetVmCount: [Output Only] Count of VMs originally planned to be
	// created.
	TargetVmCount int64 `json:"targetVmCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreatedVmCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatedVmCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BulkInsertOperationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BulkInsertOperationStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BundledLocalSsds struct {
	// DefaultInterface: The default disk interface if the interface is not
	// specified.
	DefaultInterface string `json:"defaultInterface,omitempty"`

	// PartitionCount: The number of partitions.
	PartitionCount int64 `json:"partitionCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultInterface") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultInterface") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BundledLocalSsds) MarshalJSON() ([]byte, error) {
	type NoMethod BundledLocalSsds
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CacheInvalidationRule struct {
	// Host: If set, this invalidation rule will only apply to requests with
	// a Host header matching host.
	Host string `json:"host,omitempty"`

	Path string `json:"path,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CacheInvalidationRule) MarshalJSON() ([]byte, error) {
	type NoMethod CacheInvalidationRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CacheKeyPolicy: Message containing what to include in the cache key
// for a request for Cloud CDN.
type CacheKeyPolicy struct {
	// IncludeHost: If true, requests to different hosts will be cached
	// separately.
	IncludeHost bool `json:"includeHost,omitempty"`

	// IncludeHttpHeaders: Allows HTTP request headers (by name) to be used
	// in the cache key.
	IncludeHttpHeaders []string `json:"includeHttpHeaders,omitempty"`

	// IncludeNamedCookies: Allows HTTP cookies (by name) to be used in the
	// cache key. The name=value pair will be used in the cache key Cloud
	// CDN generates.
	IncludeNamedCookies []string `json:"includeNamedCookies,omitempty"`

	// IncludeProtocol: If true, http and https requests will be cached
	// separately.
	IncludeProtocol bool `json:"includeProtocol,omitempty"`

	// IncludeQueryString: If true, include query string parameters in the
	// cache key according to query_string_whitelist and
	// query_string_blacklist. If neither is set, the entire query string
	// will be included. If false, the query string will be excluded from
	// the cache key entirely.
	IncludeQueryString bool `json:"includeQueryString,omitempty"`

	// QueryStringBlacklist: Names of query string parameters to exclude in
	// cache keys. All other parameters will be included. Either specify
	// query_string_whitelist or query_string_blacklist, not both. '&' and
	// '=' will be percent encoded and not treated as delimiters.
	QueryStringBlacklist []string `json:"queryStringBlacklist,omitempty"`

	// QueryStringWhitelist: Names of query string parameters to include in
	// cache keys. All other parameters will be excluded. Either specify
	// query_string_whitelist or query_string_blacklist, not both. '&' and
	// '=' will be percent encoded and not treated as delimiters.
	QueryStringWhitelist []string `json:"queryStringWhitelist,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludeHost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeHost") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CacheKeyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod CacheKeyPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CallCredentials: [Deprecated] gRPC call credentials to access the SDS
// server. gRPC call credentials to access the SDS server.
type CallCredentials struct {
	// CallCredentialType: The type of call credentials to use for GRPC
	// requests to the SDS server. This field can be set to one of the
	// following: - GCE_VM: The local GCE VM service account credentials are
	// used to access the SDS server. - FROM_PLUGIN: Custom authenticator
	// credentials are used to access the SDS server.
	//
	// Possible values:
	//   "FROM_PLUGIN" - Custom authenticator credentials are used to access
	// the SDS server.
	//   "GCE_VM" - The local GCE VM service account credentials are used to
	// access the SDS server.
	//   "INVALID"
	CallCredentialType string `json:"callCredentialType,omitempty"`

	// FromPlugin: Custom authenticator credentials. Valid if
	// callCredentialType is FROM_PLUGIN.
	FromPlugin *MetadataCredentialsFromPlugin `json:"fromPlugin,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallCredentialType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallCredentialType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CallCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod CallCredentials
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChannelCredentials: [Deprecated] gRPC channel credentials to access
// the SDS server. gRPC channel credentials to access the SDS server.
type ChannelCredentials struct {
	// Certificates: The call credentials to access the SDS server.
	Certificates *TlsCertificatePaths `json:"certificates,omitempty"`

	// ChannelCredentialType: The channel credentials to access the SDS
	// server. This field can be set to one of the following: CERTIFICATES:
	// Use TLS certificates to access the SDS server. GCE_VM: Use local GCE
	// VM credentials to access the SDS server.
	//
	// Possible values:
	//   "CERTIFICATES" - Use TLS certificates to access the SDS server.
	//   "GCE_VM" - Use local GCE VM credentials to access the SDS server.
	//   "INVALID"
	ChannelCredentialType string `json:"channelCredentialType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Certificates") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Certificates") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChannelCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod ChannelCredentials
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CircuitBreakers: Settings controlling the volume of requests,
// connections and retries to this backend service.
type CircuitBreakers struct {
	// ConnectTimeout: The timeout for new network connections to hosts.
	ConnectTimeout *Duration `json:"connectTimeout,omitempty"`

	// MaxConnections: The maximum number of connections to the backend
	// service. If not specified, there is no limit. Not supported when the
	// backend service is referenced by a URL map that is bound to target
	// gRPC proxy that has validateForProxyless field set to true.
	MaxConnections int64 `json:"maxConnections,omitempty"`

	// MaxPendingRequests: The maximum number of pending requests allowed to
	// the backend service. If not specified, there is no limit. Not
	// supported when the backend service is referenced by a URL map that is
	// bound to target gRPC proxy that has validateForProxyless field set to
	// true.
	MaxPendingRequests int64 `json:"maxPendingRequests,omitempty"`

	// MaxRequests: The maximum number of parallel requests that allowed to
	// the backend service. If not specified, there is no limit.
	MaxRequests int64 `json:"maxRequests,omitempty"`

	// MaxRequestsPerConnection: Maximum requests for a single connection to
	// the backend service. This parameter is respected by both the HTTP/1.1
	// and HTTP/2 implementations. If not specified, there is no limit.
	// Setting this parameter to 1 will effectively disable keep alive. Not
	// supported when the backend service is referenced by a URL map that is
	// bound to target gRPC proxy that has validateForProxyless field set to
	// true.
	MaxRequestsPerConnection int64 `json:"maxRequestsPerConnection,omitempty"`

	// MaxRetries: The maximum number of parallel retries allowed to the
	// backend cluster. If not specified, the default is 1. Not supported
	// when the backend service is referenced by a URL map that is bound to
	// target gRPC proxy that has validateForProxyless field set to true.
	MaxRetries int64 `json:"maxRetries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectTimeout") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectTimeout") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CircuitBreakers) MarshalJSON() ([]byte, error) {
	type NoMethod CircuitBreakers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ClientTlsSettings: [Deprecated] The client side authentication
// settings for connection originating from the backend service. the
// backend service.
type ClientTlsSettings struct {
	// ClientTlsContext: Configures the mechanism to obtain client-side
	// security certificates and identity information. This field is only
	// applicable when mode is set to MUTUAL.
	ClientTlsContext *TlsContext `json:"clientTlsContext,omitempty"`

	// Mode: Indicates whether connections to this port should be secured
	// using TLS. The value of this field determines how TLS is enforced.
	// This can be set to one of the following values: DISABLE: Do not setup
	// a TLS connection to the backends. SIMPLE: Originate a TLS connection
	// to the backends. MUTUAL: Secure connections to the backends using
	// mutual TLS by presenting client certificates for authentication.
	//
	// Possible values:
	//   "DISABLE" - Do not setup a TLS connection to the backends.
	//   "INVALID"
	//   "MUTUAL" - Secure connections to the backends using mutual TLS by
	// presenting client certificates for authentication.
	//   "SIMPLE" - Originate a TLS connection to the backends.
	Mode string `json:"mode,omitempty"`

	// Sni: SNI string to present to the server during TLS handshake. This
	// field is applicable only when mode is SIMPLE or MUTUAL.
	Sni string `json:"sni,omitempty"`

	// SubjectAltNames: A list of alternate names to verify the subject
	// identity in the certificate.If specified, the proxy will verify that
	// the server certificate's subject alt name matches one of the
	// specified values. This field is applicable only when mode is SIMPLE
	// or MUTUAL.
	SubjectAltNames []string `json:"subjectAltNames,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientTlsContext") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientTlsContext") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ClientTlsSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ClientTlsSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Commitment: Represents a regional Commitment resource. Creating a
// commitment resource means that you are purchasing a committed use
// contract with an explicit start and end time. You can create
// commitments based on vCPUs and memory usage and receive discounted
// rates. For full details, read Signing Up for Committed Use Discounts.
type Commitment struct {
	// AutoRenew: Specifies whether to enable automatic renewal for the
	// commitment. The default value is false if not specified. The field
	// can be updated until the day of the commitment expiration at 12:00am
	// PST. If the field is set to true, the commitment will be
	// automatically renewed for either one or three years according to the
	// terms of the existing commitment.
	AutoRenew bool `json:"autoRenew,omitempty"`

	// Category: The category of the commitment. Category MACHINE specifies
	// commitments composed of machine resources such as VCPU or MEMORY,
	// listed in resources. Category LICENSE specifies commitments composed
	// of software licenses, listed in licenseResources. Note that only
	// MACHINE commitments should have a Type specified.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED"
	//   "LICENSE"
	//   "MACHINE"
	Category string `json:"category,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// EndTimestamp: [Output Only] Commitment end time in RFC3339 text
	// format.
	EndTimestamp string `json:"endTimestamp,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#commitment
	// for commitments.
	Kind string `json:"kind,omitempty"`

	// LicenseResource: The license specification required as part of a
	// license commitment.
	LicenseResource *LicenseResourceCommitment `json:"licenseResource,omitempty"`

	// MergeSourceCommitments: List of source commitments to be merged into
	// a new commitment.
	MergeSourceCommitments []string `json:"mergeSourceCommitments,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Plan: The plan for this commitment, which determines duration and
	// discount rate. The currently supported plans are TWELVE_MONTH (1
	// year), and THIRTY_SIX_MONTH (3 years).
	//
	// Possible values:
	//   "INVALID"
	//   "THIRTY_SIX_MONTH"
	//   "TWELVE_MONTH"
	Plan string `json:"plan,omitempty"`

	// Region: [Output Only] URL of the region where this commitment may be
	// used.
	Region string `json:"region,omitempty"`

	// Reservations: List of reservations in this commitment.
	Reservations []*Reservation `json:"reservations,omitempty"`

	// Resources: A list of commitment amounts for particular resources.
	// Note that VCPU and MEMORY resource commitments must occur together.
	Resources []*ResourceCommitment `json:"resources,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SplitSourceCommitment: Source commitment to be split into a new
	// commitment.
	SplitSourceCommitment string `json:"splitSourceCommitment,omitempty"`

	// StartTimestamp: [Output Only] Commitment start time in RFC3339 text
	// format.
	StartTimestamp string `json:"startTimestamp,omitempty"`

	// Status: [Output Only] Status of the commitment with regards to
	// eventual expiration (each commitment has an end date defined). One of
	// the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
	//
	// Possible values:
	//   "ACTIVE"
	//   "CANCELLED" - Deprecate CANCELED status. Will use separate status
	// to differentiate cancel by mergeCud or manual cancellation.
	//   "CREATING"
	//   "EXPIRED"
	//   "NOT_YET_ACTIVE"
	Status string `json:"status,omitempty"`

	// StatusMessage: [Output Only] An optional, human-readable explanation
	// of the status.
	StatusMessage string `json:"statusMessage,omitempty"`

	// Type: The type of commitment, which affects the discount rate and the
	// eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that
	// will only apply to memory optimized machines. Type
	// ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to
	// accelerator optimized machines.
	//
	// Possible values:
	//   "ACCELERATOR_OPTIMIZED"
	//   "COMPUTE_OPTIMIZED"
	//   "COMPUTE_OPTIMIZED_C2D"
	//   "COMPUTE_OPTIMIZED_C3"
	//   "COMPUTE_OPTIMIZED_C3D"
	//   "GENERAL_PURPOSE"
	//   "GENERAL_PURPOSE_E2"
	//   "GENERAL_PURPOSE_N2"
	//   "GENERAL_PURPOSE_N2D"
	//   "GENERAL_PURPOSE_T2D"
	//   "GRAPHICS_OPTIMIZED"
	//   "MEMORY_OPTIMIZED"
	//   "MEMORY_OPTIMIZED_M3"
	//   "TYPE_UNSPECIFIED"
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AutoRenew") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoRenew") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Commitment) MarshalJSON() ([]byte, error) {
	type NoMethod Commitment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of CommitmentsScopedList resources.
	Items map[string]CommitmentsScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#commitmentAggregatedList for aggregated lists of commitments.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *CommitmentAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentAggregatedListWarning: [Output Only] Informational warning
// message.
type CommitmentAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*CommitmentAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentList: Contains a list of Commitment resources.
type CommitmentList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Commitment resources.
	Items []*Commitment `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#commitmentList
	// for lists of commitments.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *CommitmentListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentList) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentListWarning: [Output Only] Informational warning message.
type CommitmentListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*CommitmentListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentsScopedList struct {
	// Commitments: [Output Only] A list of commitments contained in this
	// scope.
	Commitments []*Commitment `json:"commitments,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of commitments when the list is empty.
	Warning *CommitmentsScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Commitments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Commitments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentsScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentsScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentsScopedListWarning: [Output Only] Informational warning
// which replaces the list of commitments when the list is empty.
type CommitmentsScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*CommitmentsScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentsScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentsScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentsScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentsScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentsScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Condition: This is deprecated and has no effect. Do not use.
type Condition struct {
	// Iam: This is deprecated and has no effect. Do not use.
	//
	// Possible values:
	//   "APPROVER" - This is deprecated and has no effect. Do not use.
	//   "ATTRIBUTION" - This is deprecated and has no effect. Do not use.
	//   "AUTHORITY" - This is deprecated and has no effect. Do not use.
	//   "CREDENTIALS_TYPE" - This is deprecated and has no effect. Do not
	// use.
	//   "CREDS_ASSERTION" - This is deprecated and has no effect. Do not
	// use.
	//   "JUSTIFICATION_TYPE" - This is deprecated and has no effect. Do not
	// use.
	//   "NO_ATTR" - This is deprecated and has no effect. Do not use.
	//   "SECURITY_REALM" - This is deprecated and has no effect. Do not
	// use.
	Iam string `json:"iam,omitempty"`

	// Op: This is deprecated and has no effect. Do not use.
	//
	// Possible values:
	//   "DISCHARGED" - This is deprecated and has no effect. Do not use.
	//   "EQUALS" - This is deprecated and has no effect. Do not use.
	//   "IN" - This is deprecated and has no effect. Do not use.
	//   "NOT_EQUALS" - This is deprecated and has no effect. Do not use.
	//   "NOT_IN" - This is deprecated and has no effect. Do not use.
	//   "NO_OP" - This is deprecated and has no effect. Do not use.
	Op string `json:"op,omitempty"`

	// Svc: This is deprecated and has no effect. Do not use.
	Svc string `json:"svc,omitempty"`

	// Sys: This is deprecated and has no effect. Do not use.
	//
	// Possible values:
	//   "IP" - This is deprecated and has no effect. Do not use.
	//   "NAME" - This is deprecated and has no effect. Do not use.
	//   "NO_ATTR" - This is deprecated and has no effect. Do not use.
	//   "REGION" - This is deprecated and has no effect. Do not use.
	//   "SERVICE" - This is deprecated and has no effect. Do not use.
	Sys string `json:"sys,omitempty"`

	// Values: This is deprecated and has no effect. Do not use.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Iam") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Iam") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Condition) MarshalJSON() ([]byte, error) {
	type NoMethod Condition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConfidentialInstanceConfig: A set of Confidential Instance options.
type ConfidentialInstanceConfig struct {
	// ConfidentialInstanceType: Defines the type of technology used by the
	// confidential instance.
	//
	// Possible values:
	//   "CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED" - No type specified. Do
	// not use this value.
	//   "SEV" - AMD Secure Encrypted Virtualization.
	//   "SEV_SNP" - AMD Secure Encrypted Virtualization - Secure Nested
	// Paging.
	//   "TDX" - Intel Trust Domain eXtension.
	ConfidentialInstanceType string `json:"confidentialInstanceType,omitempty"`

	// EnableConfidentialCompute: Defines whether the instance should have
	// confidential compute enabled.
	EnableConfidentialCompute bool `json:"enableConfidentialCompute,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConfidentialInstanceType") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidentialInstanceType")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ConfidentialInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfidentialInstanceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConnectionDraining: Message containing connection draining
// configuration.
type ConnectionDraining struct {
	// DrainingTimeoutSec: Configures a duration timeout for existing
	// requests on a removed backend instance. For supported load balancers
	// and protocols, as described in Enabling connection draining.
	DrainingTimeoutSec int64 `json:"drainingTimeoutSec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DrainingTimeoutSec")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DrainingTimeoutSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ConnectionDraining) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectionDraining
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConsistentHashLoadBalancerSettings: This message defines settings for
// a consistent hash style load balancer.
type ConsistentHashLoadBalancerSettings struct {
	// HttpCookie: Hash is based on HTTP Cookie. This field describes a HTTP
	// cookie that will be used as the hash key for the consistent hash load
	// balancer. If the cookie is not present, it will be generated. This
	// field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not
	// supported when the backend service is referenced by a URL map that is
	// bound to target gRPC proxy that has validateForProxyless field set to
	// true.
	HttpCookie *ConsistentHashLoadBalancerSettingsHttpCookie `json:"httpCookie,omitempty"`

	// HttpHeaderName: The hash based on the value of the specified header
	// field. This field is applicable if the sessionAffinity is set to
	// HEADER_FIELD.
	HttpHeaderName string `json:"httpHeaderName,omitempty"`

	// MinimumRingSize: The minimum number of virtual nodes to use for the
	// hash ring. Defaults to 1024. Larger ring sizes result in more
	// granular load distributions. If the number of hosts in the load
	// balancing pool is larger than the ring size, each host will be
	// assigned a single virtual node.
	MinimumRingSize int64 `json:"minimumRingSize,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "HttpCookie") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpCookie") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConsistentHashLoadBalancerSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ConsistentHashLoadBalancerSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConsistentHashLoadBalancerSettingsHttpCookie: The information about
// the HTTP Cookie on which the hash function is based for load
// balancing policies that use a consistent hash.
type ConsistentHashLoadBalancerSettingsHttpCookie struct {
	// Name: Name of the cookie.
	Name string `json:"name,omitempty"`

	// Path: Path to set for the cookie.
	Path string `json:"path,omitempty"`

	// Ttl: Lifetime of the cookie.
	Ttl *Duration `json:"ttl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConsistentHashLoadBalancerSettingsHttpCookie) MarshalJSON() ([]byte, error) {
	type NoMethod ConsistentHashLoadBalancerSettingsHttpCookie
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CorsPolicy: The specification for allowing client-side cross-origin
// requests. For more information about the W3C recommendation for
// cross-origin resource sharing (CORS), see Fetch API Living Standard.
type CorsPolicy struct {
	// AllowCredentials: In response to a preflight request, setting this to
	// true indicates that the actual request can include user credentials.
	// This field translates to the Access-Control-Allow-Credentials header.
	// Default is false.
	AllowCredentials bool `json:"allowCredentials,omitempty"`

	// AllowHeaders: Specifies the content for the
	// Access-Control-Allow-Headers header.
	AllowHeaders []string `json:"allowHeaders,omitempty"`

	// AllowMethods: Specifies the content for the
	// Access-Control-Allow-Methods header.
	AllowMethods []string `json:"allowMethods,omitempty"`

	// AllowOriginRegexes: Specifies a regular expression that matches
	// allowed origins. For more information about the regular expression
	// syntax, see Syntax. An origin is allowed if it matches either an item
	// in allowOrigins or an item in allowOriginRegexes. Regular expressions
	// can only be used when the loadBalancingScheme is set to
	// INTERNAL_SELF_MANAGED.
	AllowOriginRegexes []string `json:"allowOriginRegexes,omitempty"`

	// AllowOrigins: Specifies the list of origins that is allowed to do
	// CORS requests. An origin is allowed if it matches either an item in
	// allowOrigins or an item in allowOriginRegexes.
	AllowOrigins []string `json:"allowOrigins,omitempty"`

	// Disabled: If true, the setting specifies the CORS policy is disabled.
	// The default value of false, which indicates that the CORS policy is
	// in effect.
	Disabled bool `json:"disabled,omitempty"`

	// ExposeHeaders: Specifies the content for the
	// Access-Control-Expose-Headers header.
	ExposeHeaders []string `json:"exposeHeaders,omitempty"`

	// MaxAge: Specifies how long results of a preflight request can be
	// cached in seconds. This field translates to the
	// Access-Control-Max-Age header.
	MaxAge int64 `json:"maxAge,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowCredentials") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowCredentials") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CorsPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod CorsPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomErrorResponsePolicy: Specifies the custom error response policy
// that must be applied when the backend service or backend bucket
// responds with an error.
type CustomErrorResponsePolicy struct {
	// ErrorResponseRules: Specifies rules for returning error responses. In
	// a given policy, if you specify rules for both a range of error codes
	// as well as rules for specific error codes then rules with specific
	// error codes have a higher priority. For example, assume that you
	// configure a rule for 401 (Un-authorized) code, and another for all 4
	// series error codes (4XX). If the backend service returns a 401, then
	// the rule for 401 will be applied. However if the backend service
	// returns a 403, the rule for 4xx takes effect.
	ErrorResponseRules []*CustomErrorResponsePolicyCustomErrorResponseRule `json:"errorResponseRules,omitempty"`

	// ErrorService: The full or partial URL to the BackendBucket resource
	// that contains the custom error content. Examples are: -
	// https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket
	// - compute/v1/projects/project/global/backendBuckets/myBackendBucket -
	// global/backendBuckets/myBackendBucket If errorService is not
	// specified at lower levels like pathMatcher, pathRule and routeRule,
	// an errorService specified at a higher level in the UrlMap will be
	// used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more
	// errorResponseRules[], it must specify errorService. If load balancer
	// cannot reach the backendBucket, a simple Not Found Error will be
	// returned, with the original response code (or overrideResponseCode if
	// configured). errorService is not supported for internal or regional
	// HTTP/HTTPS load balancers.
	ErrorService string `json:"errorService,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorResponseRules")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorResponseRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CustomErrorResponsePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod CustomErrorResponsePolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomErrorResponsePolicyCustomErrorResponseRule: Specifies the
// mapping between the response code that will be returned along with
// the custom error content and the response code returned by the
// backend service.
type CustomErrorResponsePolicyCustomErrorResponseRule struct {
	// MatchResponseCodes: Valid values include: - A number between 400 and
	// 599: For example 401 or 503, in which case the load balancer applies
	// the policy if the error code exactly matches this value. - 5xx: Load
	// Balancer will apply the policy if the backend service responds with
	// any response code in the range of 500 to 599. - 4xx: Load Balancer
	// will apply the policy if the backend service responds with any
	// response code in the range of 400 to 499. Values must be unique
	// within matchResponseCodes and across all errorResponseRules of
	// CustomErrorResponsePolicy.
	MatchResponseCodes []string `json:"matchResponseCodes,omitempty"`

	// OverrideResponseCode: The HTTP status code returned with the response
	// containing the custom error content. If overrideResponseCode is not
	// supplied, the same response code returned by the original backend
	// bucket or backend service is returned to the client.
	OverrideResponseCode int64 `json:"overrideResponseCode,omitempty"`

	// Path: The full path to a file within backendBucket . For example:
	// /errors/defaultError.html path must start with a leading slash. path
	// cannot have trailing slashes. If the file is not available in
	// backendBucket or the load balancer cannot reach the BackendBucket, a
	// simple Not Found Error is returned to the client. The value must be
	// from 1 to 1024 characters
	Path string `json:"path,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchResponseCodes")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchResponseCodes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CustomErrorResponsePolicyCustomErrorResponseRule) MarshalJSON() ([]byte, error) {
	type NoMethod CustomErrorResponsePolicyCustomErrorResponseRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerEncryptionKey struct {
	// KmsKeyName: The name of the encryption key that is stored in Google
	// Cloud KMS. For example: "kmsKeyName":
	// "projects/kms_project_id/locations/region/keyRings/
	// key_region/cryptoKeys/key
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// KmsKeyServiceAccount: The service account being used for the
	// encryption request for the given KMS key. If absent, the Compute
	// Engine default service account is used. For example:
	// "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/
	KmsKeyServiceAccount string `json:"kmsKeyServiceAccount,omitempty"`

	// RawKey: Specifies a 256-bit customer-supplied encryption key, encoded
	// in RFC 4648 base64 to either encrypt or decrypt this resource. You
	// can provide either the rawKey or the rsaEncryptedKey. For example:
	// "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
	RawKey string `json:"rawKey,omitempty"`

	// RsaEncryptedKey: Specifies an RFC 4648 base64 encoded, RSA-wrapped
	// 2048-bit customer-supplied encryption key to either encrypt or
	// decrypt this resource. You can provide either the rawKey or the
	// rsaEncryptedKey. For example: "rsaEncryptedKey":
	// "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JF
	// H
	// z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUi
	// FoD
	// D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe=
	// =" The key must meet the following requirements before you can
	// provide it to Compute Engine: 1. The key is wrapped using a RSA
	// public key certificate provided by Google. 2. After being wrapped,
	// the key must be encoded in RFC 4648 base64 encoding. Gets the RSA
	// public key certificate provided by Google at:
	// https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
	RsaEncryptedKey string `json:"rsaEncryptedKey,omitempty"`

	// Sha256: [Output only] The RFC 4648 base64 encoded SHA-256 hash of the
	// customer-supplied encryption key that protects this resource.
	Sha256 string `json:"sha256,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KmsKeyName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerEncryptionKey) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerEncryptionKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerEncryptionKeyProtectedDisk struct {
	// DiskEncryptionKey: Decrypts data associated with the disk with a
	// customer-supplied encryption key.
	DiskEncryptionKey *CustomerEncryptionKey `json:"diskEncryptionKey,omitempty"`

	// Source: Specifies a valid partial or full URL to an existing
	// Persistent Disk resource. This field is only applicable for
	// persistent disks. For example: "source":
	// "/compute/v1/projects/project_id/zones/zone/disks/ disk_name
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskEncryptionKey")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskEncryptionKey") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CustomerEncryptionKeyProtectedDisk) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerEncryptionKeyProtectedDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeprecationStatus: Deprecation status for a public resource.
type DeprecationStatus struct {
	// Deleted: An optional RFC3339 timestamp on or after which the state of
	// this resource is intended to change to DELETED. This is only
	// informational and the status will not change unless the client
	// explicitly changes it.
	Deleted string `json:"deleted,omitempty"`

	// Deprecated -- An optional RFC3339 timestamp on or after which the
	// state of this resource is intended to change to DEPRECATED. This is
	// only informational and the status will not change unless the client
	// explicitly changes it.
	Deprecated string `json:"deprecated,omitempty"`

	// Obsolete: An optional RFC3339 timestamp on or after which the state
	// of this resource is intended to change to OBSOLETE. This is only
	// informational and the status will not change unless the client
	// explicitly changes it.
	Obsolete string `json:"obsolete,omitempty"`

	// Replacement: The URL of the suggested replacement for a deprecated
	// resource. The suggested replacement resource must be the same kind of
	// resource as the deprecated resource.
	Replacement string `json:"replacement,omitempty"`

	// State: The deprecation state of this resource. This can be ACTIVE,
	// DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the
	// end of life date for an image, can use ACTIVE. Operations which
	// create a new resource using a DEPRECATED resource will return
	// successfully, but with a warning indicating the deprecated resource
	// and recommending its replacement. Operations which use OBSOLETE or
	// DELETED resources will be rejected and result in an error.
	//
	// Possible values:
	//   "ACTIVE"
	//   "DELETED"
	//   "DEPRECATED"
	//   "OBSOLETE"
	State string `json:"state,omitempty"`

	// StateOverride: The rollout policy for this deprecation. This policy
	// is only enforced by image family views. The rollout policy restricts
	// the zones where the associated resource is considered in a deprecated
	// state. When the rollout policy does not include the user specified
	// zone, or if the zone is rolled out, the associated resource is
	// considered in a deprecated state. The rollout policy for this
	// deprecation is read-only, except for allowlisted users. This field
	// might not be configured. To view the latest non-deprecated image in a
	// specific zone, use the imageFamilyViews.get method.
	StateOverride *RolloutPolicy `json:"stateOverride,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Deleted") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deleted") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeprecationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DeprecationStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Disk: Represents a Persistent Disk resource. Google Compute Engine
// has two Disk resources: * Zonal
// (/compute/docs/reference/rest/alpha/disks) * Regional
// (/compute/docs/reference/rest/alpha/regionDisks) Persistent disks are
// required for running your VM instances. Create both boot and non-boot
// (data) persistent disks. For more information, read Persistent Disks.
// For more storage options, read Storage options. The disks resource
// represents a zonal persistent disk. For more information, read Zonal
// persistent disks. The regionDisks resource represents a regional
// persistent disk. For more information, read Regional resources.
type Disk struct {
	// Architecture: The architecture of the disk. Valid values are ARM64 or
	// X86_64.
	//
	// Possible values:
	//   "ARCHITECTURE_UNSPECIFIED" - Default value indicating Architecture
	// is not set.
	//   "ARM64" - Machines with architecture ARM64
	//   "X86_64" - Machines with architecture X86_64
	Architecture string `json:"architecture,omitempty"`

	// AsyncPrimaryDisk: Disk asynchronously replicated into this disk.
	AsyncPrimaryDisk *DiskAsyncReplication `json:"asyncPrimaryDisk,omitempty"`

	// AsyncSecondaryDisks: [Output Only] A list of disks this disk is
	// asynchronously replicated to.
	AsyncSecondaryDisks map[string]DiskAsyncReplicationList `json:"asyncSecondaryDisks,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DiskEncryptionKey: Encrypts the disk using a customer-supplied
	// encryption key or a customer-managed encryption key. Encryption keys
	// do not protect access to metadata of the disk. After you encrypt a
	// disk with a customer-supplied key, you must provide the same key if
	// you use the disk later. For example, to create a disk snapshot, to
	// create a disk image, to create a machine image, or to attach the disk
	// to a virtual machine. After you encrypt a disk with a
	// customer-managed key, the diskEncryptionKey.kmsKeyName is set to a
	// key *version* name once the disk is created. The disk is encrypted
	// with this version of the key. In the response,
	// diskEncryptionKey.kmsKeyName appears in the following format:
	// "diskEncryptionKey.kmsKeyName":
	// "projects/kms_project_id/locations/region/keyRings/
	// key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not
	// provide an encryption key when creating the disk, then the disk is
	// encrypted using an automatically generated key and you don't need to
	// provide a key to use the disk later.
	DiskEncryptionKey *CustomerEncryptionKey `json:"diskEncryptionKey,omitempty"`

	// EnableConfidentialCompute: Whether this disk is using confidential
	// compute mode. see go/confidential-mode-in-arcus for details.
	EnableConfidentialCompute bool `json:"enableConfidentialCompute,omitempty"`

	// EraseWindowsVssSignature: Specifies whether the disk restored from a
	// source snapshot should erase Windows specific VSS signature.
	EraseWindowsVssSignature bool `json:"eraseWindowsVssSignature,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. Read Enabling guest
	// operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Interface: [Deprecated] Specifies the disk interface to use for
	// attaching this disk, which is either SCSI or NVME. The default is
	// SCSI.
	//
	// Possible values:
	//   "NVME"
	//   "SCSI"
	//   "UNSPECIFIED"
	Interface string `json:"interface,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#disk for
	// disks.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// disk, which is essentially a hash of the labels set used for
	// optimistic locking. The fingerprint is initially generated by Compute
	// Engine and changes after every request to modify or update labels.
	// You must always provide an up-to-date fingerprint hash in order to
	// update or change labels, otherwise the request will fail with error
	// 412 conditionNotMet. To see the latest fingerprint, make a get()
	// request to retrieve a disk.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this disk. These can be later modified by
	// the setLabels method.
	Labels map[string]string `json:"labels,omitempty"`

	// LastAttachTimestamp: [Output Only] Last attach timestamp in RFC3339
	// text format.
	LastAttachTimestamp string `json:"lastAttachTimestamp,omitempty"`

	// LastDetachTimestamp: [Output Only] Last detach timestamp in RFC3339
	// text format.
	LastDetachTimestamp string `json:"lastDetachTimestamp,omitempty"`

	// LicenseCodes: Integer license codes indicating which licenses are
	// attached to this disk.
	LicenseCodes googleapi.Int64s `json:"licenseCodes,omitempty"`

	// Licenses: A list of publicly visible licenses. Reserved for Google's
	// use.
	Licenses []string `json:"licenses,omitempty"`

	// LocationHint: An opaque location hint used to place the disk close to
	// other resources. This field is for use by internal tools that use the
	// public API.
	LocationHint string `json:"locationHint,omitempty"`

	// Locked: [Output Only] The field indicates if the disk is created from
	// a locked source image. Attachment of a disk created from a locked
	// source image will cause the following operations to become
	// irreversibly prohibited: - R/W or R/O disk attachment to any other
	// instance - Disk detachment. And the disk can only be deleted when the
	// instance is deleted - Creation of images or snapshots - Disk cloning
	// Furthermore, the instance with at least one disk with locked flag set
	// to true will be prohibited from performing the operations below: -
	// Further attachment of secondary disks. - Detachment of any disks -
	// Create machine images - Create instance template - Delete the
	// instance with --keep-disk parameter set to true for locked disks -
	// Attach a locked disk with --auto-delete parameter set to false
	Locked bool `json:"locked,omitempty"`

	// MultiWriter: Indicates whether or not the disk can be read/write
	// attached to more than one instance.
	MultiWriter bool `json:"multiWriter,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Options: Internal use only.
	Options string `json:"options,omitempty"`

	// Params: Input only. [Input Only] Additional params passed with the
	// request, but not persisted as part of resource payload.
	Params *DiskParams `json:"params,omitempty"`

	// PhysicalBlockSizeBytes: Physical block size of the persistent disk,
	// in bytes. If not present in a request, a default value is used. The
	// currently supported size is 4096, other sizes may be added in the
	// future. If an unsupported value is requested, the error message will
	// list the supported values for the caller's project.
	PhysicalBlockSizeBytes int64 `json:"physicalBlockSizeBytes,omitempty,string"`

	// ProvisionedIops: Indicates how many IOPS to provision for the disk.
	// This sets the number of I/O operations per second that the disk can
	// handle. Values must be between 10,000 and 120,000. For more details,
	// see the Extreme persistent disk documentation.
	ProvisionedIops int64 `json:"provisionedIops,omitempty,string"`

	// ProvisionedThroughput: Indicates how much throughput to provision for
	// the disk. This sets the number of throughput mb per second that the
	// disk can handle. Values must be between 1 and 7,124.
	ProvisionedThroughput int64 `json:"provisionedThroughput,omitempty,string"`

	// Region: [Output Only] URL of the region where the disk resides. Only
	// applicable for regional resources. You must specify this field as
	// part of the HTTP request URL. It is not settable as a field in the
	// request body.
	Region string `json:"region,omitempty"`

	// ReplicaZones: URLs of the zones where the disk should be replicated
	// to. Only applicable for regional resources.
	ReplicaZones []string `json:"replicaZones,omitempty"`

	// ResourcePolicies: Resource policies applied to this disk for
	// automatic snapshot creations.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ResourceStatus: [Output Only] Status information for the disk
	// resource.
	ResourceStatus *DiskResourceStatus `json:"resourceStatus,omitempty"`

	// SatisfiesPzs: [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`

	// SelfLink: [Output Only] Server-defined fully-qualified URL for this
	// resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SizeGb: Size, in GB, of the persistent disk. You can specify this
	// field when creating a persistent disk using the sourceImage,
	// sourceSnapshot, or sourceDisk parameter, or specify it alone to
	// create an empty persistent disk. If you specify this field along with
	// a source, the value of sizeGb must not be less than the size of the
	// source. Acceptable values are 1 to 65536, inclusive.
	SizeGb int64 `json:"sizeGb,omitempty,string"`

	// SourceConsistencyGroupPolicy: [Output Only] URL of the
	// DiskConsistencyGroupPolicy for a secondary disk that was created
	// using a consistency group.
	SourceConsistencyGroupPolicy string `json:"sourceConsistencyGroupPolicy,omitempty"`

	// SourceConsistencyGroupPolicyId: [Output Only] ID of the
	// DiskConsistencyGroupPolicy for a secondary disk that was created
	// using a consistency group.
	SourceConsistencyGroupPolicyId string `json:"sourceConsistencyGroupPolicyId,omitempty"`

	// SourceDisk: The source disk used to create this disk. You can provide
	// this as a partial or full URL to the resource. For example, the
	// following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /disks/disk -
	// https://www.googleapis.com/compute/v1/projects/project/regions/region
	// /disks/disk - projects/project/zones/zone/disks/disk -
	// projects/project/regions/region/disks/disk - zones/zone/disks/disk -
	// regions/region/disks/disk
	SourceDisk string `json:"sourceDisk,omitempty"`

	// SourceDiskId: [Output Only] The unique ID of the disk used to create
	// this disk. This value identifies the exact disk that was used to
	// create this persistent disk. For example, if you created the
	// persistent disk from a disk that was later deleted and recreated
	// under the same name, the source disk ID would identify the exact
	// version of the disk that was used.
	SourceDiskId string `json:"sourceDiskId,omitempty"`

	// SourceImage: The source image used to create this disk. If the source
	// image is deleted, this field will not be set. To create a disk with
	// one of the public operating system images, specify the image by its
	// family name. For example, specify family/debian-9 to use the latest
	// Debian 9 image: projects/debian-cloud/global/images/family/debian-9
	// Alternatively, use a specific version of a public operating system
	// image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
	// To create a disk with a custom image that you created, specify the
	// image name in the following format: global/images/my-custom-image You
	// can also specify a custom image by its image family, which returns
	// the latest version of the image in that family. Replace the image
	// name with family/family-name: global/images/family/my-image-family
	SourceImage string `json:"sourceImage,omitempty"`

	// SourceImageEncryptionKey: The customer-supplied encryption key of the
	// source image. Required if the source image is protected by a
	// customer-supplied encryption key.
	SourceImageEncryptionKey *CustomerEncryptionKey `json:"sourceImageEncryptionKey,omitempty"`

	// SourceImageId: [Output Only] The ID value of the image used to create
	// this disk. This value identifies the exact image that was used to
	// create this persistent disk. For example, if you created the
	// persistent disk from an image that was later deleted and recreated
	// under the same name, the source image ID would identify the exact
	// version of the image that was used.
	SourceImageId string `json:"sourceImageId,omitempty"`

	// SourceInstantSnapshot: The source instant snapshot used to create
	// this disk. You can provide this as a partial or full URL to the
	// resource. For example, the following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /instantSnapshots/instantSnapshot -
	// projects/project/zones/zone/instantSnapshots/instantSnapshot -
	// zones/zone/instantSnapshots/instantSnapshot
	SourceInstantSnapshot string `json:"sourceInstantSnapshot,omitempty"`

	// SourceInstantSnapshotId: [Output Only] The unique ID of the instant
	// snapshot used to create this disk. This value identifies the exact
	// instant snapshot that was used to create this persistent disk. For
	// example, if you created the persistent disk from an instant snapshot
	// that was later deleted and recreated under the same name, the source
	// instant snapshot ID would identify the exact version of the instant
	// snapshot that was used.
	SourceInstantSnapshotId string `json:"sourceInstantSnapshotId,omitempty"`

	// SourceSnapshot: The source snapshot used to create this disk. You can
	// provide this as a partial or full URL to the resource. For example,
	// the following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project
	// /global/snapshots/snapshot -
	// projects/project/global/snapshots/snapshot -
	// global/snapshots/snapshot
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`

	// SourceSnapshotEncryptionKey: The customer-supplied encryption key of
	// the source snapshot. Required if the source snapshot is protected by
	// a customer-supplied encryption key.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `json:"sourceSnapshotEncryptionKey,omitempty"`

	// SourceSnapshotId: [Output Only] The unique ID of the snapshot used to
	// create this disk. This value identifies the exact snapshot that was
	// used to create this persistent disk. For example, if you created the
	// persistent disk from a snapshot that was later deleted and recreated
	// under the same name, the source snapshot ID would identify the exact
	// version of the snapshot that was used.
	SourceSnapshotId string `json:"sourceSnapshotId,omitempty"`

	// SourceStorageObject: The full Google Cloud Storage URI where the disk
	// image is stored. This file must be a gzip-compressed tarball whose
	// name ends in .tar.gz or virtual machine disk whose name ends in vmdk.
	// Valid URIs may start with gs:// or https://storage.googleapis.com/.
	// This flag is not optimized for creating multiple disks from a source
	// storage object. To create many disks from a source storage object,
	// use gcloud compute images import instead.
	SourceStorageObject string `json:"sourceStorageObject,omitempty"`

	// Status: [Output Only] The status of disk creation. - CREATING: Disk
	// is provisioning. - RESTORING: Source data is being copied into the
	// disk. - FAILED: Disk creation failed. - READY: Disk is ready for use.
	// - DELETING: Disk is deleting.
	//
	// Possible values:
	//   "CREATING" - Disk is provisioning
	//   "DELETING" - Disk is deleting.
	//   "FAILED" - Disk creation failed.
	//   "READY" - Disk is ready for use.
	//   "RESTORING" - Source data is being copied into the disk.
	Status string `json:"status,omitempty"`

	// StoragePool: The storage pool in which the new disk is created. You
	// can provide this as a partial or full URL to the resource. For
	// example, the following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /storagePools/storagePool -
	// projects/project/zones/zone/storagePools/storagePool -
	// zones/zone/storagePools/storagePool
	StoragePool string `json:"storagePool,omitempty"`

	// StorageType: [Deprecated] Storage type of the persistent disk.
	//
	// Possible values:
	//   "HDD"
	//   "SSD"
	StorageType string `json:"storageType,omitempty"`

	// Type: URL of the disk type resource describing which disk type to use
	// to create the disk. Provide this when creating the disk. For example:
	// projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk
	// types.
	Type string `json:"type,omitempty"`

	// UserLicenses: A list of publicly visible user-licenses. Unlike
	// regular licenses, user provided licenses can be modified after the
	// disk is created. This includes a list of URLs to the license
	// resource. For example, to provide a debian license:
	// https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch
	UserLicenses []string `json:"userLicenses,omitempty"`

	// Users: [Output Only] Links to the users of the disk (attached
	// instances) in form: projects/project/zones/zone/instances/instance
	Users []string `json:"users,omitempty"`

	// Zone: [Output Only] URL of the zone where the disk resides. You must
	// specify this field as part of the HTTP request URL. It is not
	// settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Architecture") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Disk) MarshalJSON() ([]byte, error) {
	type NoMethod Disk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of DisksScopedList resources.
	Items map[string]DisksScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#diskAggregatedList for aggregated lists of persistent disks.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskAggregatedListWarning: [Output Only] Informational warning
// message.
type DiskAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*DiskAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskAsyncReplication struct {
	// ConsistencyGroupPolicy: [Output Only] URL of the
	// DiskConsistencyGroupPolicy if replication was started on the disk as
	// a member of a group.
	ConsistencyGroupPolicy string `json:"consistencyGroupPolicy,omitempty"`

	// ConsistencyGroupPolicyId: [Output Only] ID of the
	// DiskConsistencyGroupPolicy if replication was started on the disk as
	// a member of a group.
	ConsistencyGroupPolicyId string `json:"consistencyGroupPolicyId,omitempty"`

	// Disk: The other disk asynchronously replicated to or from the current
	// disk. You can provide this as a partial or full URL to the resource.
	// For example, the following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /disks/disk - projects/project/zones/zone/disks/disk -
	// zones/zone/disks/disk
	Disk string `json:"disk,omitempty"`

	// DiskId: [Output Only] The unique ID of the other disk asynchronously
	// replicated to or from the current disk. This value identifies the
	// exact disk that was used to create this replication. For example, if
	// you started replicating the persistent disk from a disk that was
	// later deleted and recreated under the same name, the disk ID would
	// identify the exact version of the disk that was used.
	DiskId string `json:"diskId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConsistencyGroupPolicy") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsistencyGroupPolicy")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskAsyncReplication) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAsyncReplication
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskAsyncReplicationList struct {
	AsyncReplicationDisk *DiskAsyncReplication `json:"asyncReplicationDisk,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AsyncReplicationDisk") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AsyncReplicationDisk") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskAsyncReplicationList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAsyncReplicationList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskInstantiationConfig: A specification of the desired way to
// instantiate a disk in the instance template when its created from a
// source instance.
type DiskInstantiationConfig struct {
	// AutoDelete: Specifies whether the disk will be auto-deleted when the
	// instance is deleted (but not when the disk is detached from the
	// instance).
	AutoDelete bool `json:"autoDelete,omitempty"`

	// CustomImage: The custom source image to be used to restore this disk
	// when instantiating this instance template.
	CustomImage string `json:"customImage,omitempty"`

	// DeviceName: Specifies the device name of the disk to which the
	// configurations apply to.
	DeviceName string `json:"deviceName,omitempty"`

	// InstantiateFrom: Specifies whether to include the disk and what image
	// to use. Possible values are: - source-image: to use the same image
	// that was used to create the source instance's corresponding disk.
	// Applicable to the boot disk and additional read-write disks. -
	// source-image-family: to use the same image family that was used to
	// create the source instance's corresponding disk. Applicable to the
	// boot disk and additional read-write disks. - custom-image: to use a
	// user-provided image url for disk creation. Applicable to the boot
	// disk and additional read-write disks. - attach-read-only: to attach a
	// read-only disk. Applicable to read-only disks. - do-not-include: to
	// exclude a disk from the template. Applicable to additional read-write
	// disks, local SSDs, and read-only disks.
	//
	// Possible values:
	//   "ATTACH_READ_ONLY" - Attach the existing disk in read-only mode.
	// The request will fail if the disk was attached in read-write mode on
	// the source instance. Applicable to: read-only disks.
	//   "BLANK" - Create a blank disk. The disk will be created
	// unformatted. Applicable to: additional read-write disks, local SSDs.
	//   "CUSTOM_IMAGE" - Use the custom image specified in the custom_image
	// field. Applicable to: boot disk, additional read-write disks.
	//   "DEFAULT" - Use the default instantiation option for the
	// corresponding type of disk. For boot disk and any other R/W disks,
	// new custom images will be created from each disk. For read-only
	// disks, they will be attached in read-only mode. Local SSD disks will
	// be created as blank volumes.
	//   "DO_NOT_INCLUDE" - Do not include the disk in the instance
	// template. Applicable to: additional read-write disks, local SSDs,
	// read-only disks.
	//   "SOURCE_IMAGE" - Use the same source image used for creation of the
	// source instance's corresponding disk. The request will fail if the
	// source VM's disk was created from a snapshot. Applicable to: boot
	// disk, additional read-write disks.
	//   "SOURCE_IMAGE_FAMILY" - Use the same source image family used for
	// creation of the source instance's corresponding disk. The request
	// will fail if the source image of the source disk does not belong to
	// any image family. Applicable to: boot disk, additional read-write
	// disks.
	InstantiateFrom string `json:"instantiateFrom,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoDelete") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoDelete") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskInstantiationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DiskInstantiationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskList: A list of Disk resources.
type DiskList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Disk resources.
	Items []*Disk `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#diskList for
	// lists of disks.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskListWarning: [Output Only] Informational warning message.
type DiskListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*DiskListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskMoveRequest struct {
	// DestinationZone: The URL of the destination zone to move the disk.
	// This can be a full or partial URL. For example, the following are all
	// valid URLs to a zone: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone -
	// projects/project/zones/zone - zones/zone
	DestinationZone string `json:"destinationZone,omitempty"`

	// TargetDisk: The URL of the target disk to move. This can be a full or
	// partial URL. For example, the following are all valid URLs to a disk:
	// - https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /disks/disk - projects/project/zones/zone/disks/disk -
	// zones/zone/disks/disk
	TargetDisk string `json:"targetDisk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationZone") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationZone") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskMoveRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DiskMoveRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskParams: Additional disk params.
type DiskParams struct {
	// ResourceManagerTags: Resource manager tags to be bound to the disk.
	// Tag keys and values have the same definition as resource manager
	// tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values
	// are in the format `tagValues/456`. The field is ignored (both PUT &
	// PATCH) when empty.
	ResourceManagerTags map[string]string `json:"resourceManagerTags,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceManagerTags")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceManagerTags") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskParams) MarshalJSON() ([]byte, error) {
	type NoMethod DiskParams
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskResourceStatus struct {
	AsyncPrimaryDisk *DiskResourceStatusAsyncReplicationStatus `json:"asyncPrimaryDisk,omitempty"`

	// AsyncSecondaryDisks: Key: disk, value: AsyncReplicationStatus message
	AsyncSecondaryDisks map[string]DiskResourceStatusAsyncReplicationStatus `json:"asyncSecondaryDisks,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AsyncPrimaryDisk") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AsyncPrimaryDisk") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskResourceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DiskResourceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskResourceStatusAsyncReplicationStatus struct {
	// Possible values:
	//   "ACTIVE" - Replication is active.
	//   "CREATED" - Secondary disk is created and is waiting for
	// replication to start.
	//   "STARTING" - Replication is starting.
	//   "STATE_UNSPECIFIED"
	//   "STOPPED" - Replication is stopped.
	//   "STOPPING" - Replication is stopping.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskResourceStatusAsyncReplicationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DiskResourceStatusAsyncReplicationStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskType: Represents a Disk Type resource. Google Compute Engine has
// two Disk Type resources: * Regional
// (/compute/docs/reference/rest/alpha/regionDiskTypes) * Zonal
// (/compute/docs/reference/rest/alpha/diskTypes) You can choose from a
// variety of disk types based on your needs. For more information, read
// Storage options. The diskTypes resource represents disk types for a
// zonal persistent disk. For more information, read Zonal persistent
// disks. The regionDiskTypes resource represents disk types for a
// regional persistent disk. For more information, read Regional
// persistent disks.
type DiskType struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// DefaultDiskSizeGb: [Output Only] Server-defined default disk size in
	// GB.
	DefaultDiskSizeGb int64 `json:"defaultDiskSizeGb,omitempty,string"`

	// Deprecated -- [Output Only] The deprecation status associated with
	// this disk type.
	Deprecated *DeprecationStatus `json:"deprecated,omitempty"`

	// Description: [Output Only] An optional description of this resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#diskType for
	// disk types.
	Kind string `json:"kind,omitempty"`

	// Name: [Output Only] Name of the resource.
	Name string `json:"name,omitempty"`

	// Region: [Output Only] URL of the region where the disk type resides.
	// Only applicable for regional resources. You must specify this field
	// as part of the HTTP request URL. It is not settable as a field in the
	// request body.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ValidDiskSize: [Output Only] An optional textual description of the
	// valid disk size, such as "10GB-10TB".
	ValidDiskSize string `json:"validDiskSize,omitempty"`

	// Zone: [Output Only] URL of the zone where the disk type resides. You
	// must specify this field as part of the HTTP request URL. It is not
	// settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskType) MarshalJSON() ([]byte, error) {
	type NoMethod DiskType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypeAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of DiskTypesScopedList resources.
	Items map[string]DiskTypesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#diskTypeAggregatedList.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskTypeAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypeAggregatedListWarning: [Output Only] Informational warning
// message.
type DiskTypeAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*DiskTypeAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypeAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypeList: Contains a list of disk types.
type DiskTypeList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of DiskType resources.
	Items []*DiskType `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#diskTypeList for
	// disk types.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskTypeListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypeListWarning: [Output Only] Informational warning message.
type DiskTypeListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*DiskTypeListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypeListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypesScopedList struct {
	// DiskTypes: [Output Only] A list of disk types contained in this
	// scope.
	DiskTypes []*DiskType `json:"diskTypes,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of disk types when the list is empty.
	Warning *DiskTypesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskTypes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypesScopedListWarning: [Output Only] Informational warning which
// replaces the list of disk types when the list is empty.
type DiskTypesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*DiskTypesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksAddResourcePoliciesRequest struct {
	// ResourcePolicies: Full or relative path to the resource policy to be
	// added to this disk. You can only specify one resource policy.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourcePolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourcePolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DisksAddResourcePoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksAddResourcePoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksRemoveResourcePoliciesRequest struct {
	// ResourcePolicies: Resource policies to be removed from this disk.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourcePolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourcePolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DisksRemoveResourcePoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksRemoveResourcePoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksResizeRequest struct {
	// SizeGb: The new size of the persistent disk, which is specified in
	// GB.
	SizeGb int64 `json:"sizeGb,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "SizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SizeGb") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksResizeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksResizeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksScopedList struct {
	// Disks: [Output Only] A list of disks contained in this scope.
	Disks []*Disk `json:"disks,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of disks when the list is empty.
	Warning *DisksScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod DisksScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DisksScopedListWarning: [Output Only] Informational warning which
// replaces the list of disks when the list is empty.
type DisksScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*DisksScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DisksScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DisksScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksStartAsyncReplicationRequest struct {
	// AsyncSecondaryDisk: The secondary disk to start asynchronous
	// replication to. You can provide this as a partial or full URL to the
	// resource. For example, the following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /disks/disk -
	// https://www.googleapis.com/compute/v1/projects/project/regions/region
	// /disks/disk - projects/project/zones/zone/disks/disk -
	// projects/project/regions/region/disks/disk - zones/zone/disks/disk -
	// regions/region/disks/disk
	AsyncSecondaryDisk string `json:"asyncSecondaryDisk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AsyncSecondaryDisk")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AsyncSecondaryDisk") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DisksStartAsyncReplicationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksStartAsyncReplicationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksStopAsyncReplicationRequest struct {
	// AsyncSecondaryDisk: [Deprecated] The secondary disk to stop
	// asynchronous replication to. This field will not be included in the
	// beta or v1 APIs and will be removed from the alpha API in the near
	// future.
	AsyncSecondaryDisk string `json:"asyncSecondaryDisk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AsyncSecondaryDisk")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AsyncSecondaryDisk") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DisksStopAsyncReplicationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksStopAsyncReplicationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DisksStopGroupAsyncReplicationResource: A transient resource used in
// compute.disks.stopGroupAsyncReplication and
// compute.regionDisks.stopGroupAsyncReplication. It is only used to
// process requests and is not persisted.
type DisksStopGroupAsyncReplicationResource struct {
	// ResourcePolicy: The URL of the DiskConsistencyGroupPolicy for the
	// group of disks to stop. This may be a full or partial URL, such as: -
	// https://www.googleapis.com/compute/v1/projects/project/regions/region
	// /resourcePolicies/resourcePolicy -
	// projects/project/regions/region/resourcePolicies/resourcePolicy -
	// regions/region/resourcePolicies/resourcePolicy
	ResourcePolicy string `json:"resourcePolicy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourcePolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourcePolicy") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DisksStopGroupAsyncReplicationResource) MarshalJSON() ([]byte, error) {
	type NoMethod DisksStopGroupAsyncReplicationResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DisplayDevice: A set of Display Device options
type DisplayDevice struct {
	// EnableDisplay: Defines whether the instance has Display enabled.
	EnableDisplay bool `json:"enableDisplay,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnableDisplay") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableDisplay") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisplayDevice) MarshalJSON() ([]byte, error) {
	type NoMethod DisplayDevice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DistributionPolicy struct {
	// TargetShape: The distribution shape to which the group converges
	// either proactively or on resize events (depending on the value set in
	// updatePolicy.instanceRedistributionType).
	//
	// Possible values:
	//   "ANY" - The group picks zones for creating VM instances to fulfill
	// the requested number of VMs within present resource constraints and
	// to maximize utilization of unused zonal reservations. Recommended for
	// batch workloads that do not require high availability.
	//   "ANY_SINGLE_ZONE" - The group creates all VM instances within a
	// single zone. The zone is selected based on the present resource
	// constraints and to maximize utilization of unused zonal reservations.
	// Recommended for batch workloads with heavy interprocess
	// communication.
	//   "BALANCED" - The group prioritizes acquisition of resources,
	// scheduling VMs in zones where resources are available while
	// distributing VMs as evenly as possible across selected zones to
	// minimize the impact of zonal failure. Recommended for highly
	// available serving workloads.
	//   "EVEN" - The group schedules VM instance creation and deletion to
	// achieve and maintain an even number of managed instances across the
	// selected zones. The distribution is even when the number of managed
	// instances does not differ by more than 1 between any two zones.
	// Recommended for highly available serving workloads.
	TargetShape string `json:"targetShape,omitempty"`

	// Zones: Zones where the regional managed instance group will create
	// and manage its instances.
	Zones []*DistributionPolicyZoneConfiguration `json:"zones,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetShape") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetShape") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DistributionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod DistributionPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DistributionPolicyZoneConfiguration struct {
	// Zone: The URL of the zone. The zone must exist in the region where
	// the managed instance group is located.
	Zone string `json:"zone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Zone") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Zone") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DistributionPolicyZoneConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod DistributionPolicyZoneConfiguration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Duration: A Duration represents a fixed-length span of time
// represented as a count of seconds and fractions of seconds at
// nanosecond resolution. It is independent of any calendar and concepts
// like "day" or "month". Range is approximately 10,000 years.
type Duration struct {
	// Nanos: Span of time that's a fraction of a second at nanosecond
	// resolution. Durations less than one second are represented with a 0
	// `seconds` field and a positive `nanos` field. Must be from 0 to
	// 999,999,999 inclusive.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Span of time at a resolution of a second. Must be from 0 to
	// 315,576,000,000 inclusive. Note: these bounds are computed from: 60
	// sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
	Seconds int64 `json:"seconds,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Nanos") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Nanos") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Duration) MarshalJSON() ([]byte, error) {
	type NoMethod Duration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ErrorInfo: Describes the cause of the error with structured details.
// Example of an error when contacting the "pubsub.googleapis.com" API
// when it is not enabled: { "reason": "API_DISABLED" "domain":
// "googleapis.com" "metadata": { "resource": "projects/123", "service":
// "pubsub.googleapis.com" } } This response indicates that the
// pubsub.googleapis.com API is not enabled. Example of an error that is
// returned when attempting to create a Spanner instance in a region
// that is out of stock: { "reason": "STOCKOUT" "domain":
// "spanner.googleapis.com", "metadata": { "availableRegions":
// "us-central1,us-east2" } }
type ErrorInfo struct {
	// Domain: The logical grouping to which the "reason" belongs. The error
	// domain is typically the registered service name of the tool or
	// product that generates the error. Example: "pubsub.googleapis.com".
	// If the error is generated by some common infrastructure, the error
	// domain must be a globally unique value that identifies the
	// infrastructure. For Google API infrastructure, the error domain is
	// "googleapis.com".
	Domain string `json:"domain,omitempty"`

	// Metadatas: Additional structured details about this error. Keys
	// should match /[a-zA-Z0-9-_]/ and be limited to 64 characters in
	// length. When identifying the current value of an exceeded limit, the
	// units should be contained in the key, not the value. For example,
	// rather than {"instanceLimit": "100/request"}, should be returned as,
	// {"instanceLimitPerRequest": "100"}, if the client exceeds the number
	// of instances that can be created in a single (batch) request.
	Metadatas map[string]string `json:"metadatas,omitempty"`

	// Reason: The reason of the error. This is a constant value that
	// identifies the proximate cause of the error. Error reasons are unique
	// within a particular domain of errors. This should be at most 63
	// characters and match a regular expression of `A-Z+[A-Z0-9]`, which
	// represents UPPER_SNAKE_CASE.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ErrorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ErrorInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExchangedPeeringRoute struct {
	// DestRange: The destination range of the route.
	DestRange string `json:"destRange,omitempty"`

	// Imported: True if the peering route has been imported from a peer.
	// The actual import happens if the field
	// networkPeering.importCustomRoutes is true for this network, and
	// networkPeering.exportCustomRoutes is true for the peer network, and
	// the import does not result in a route conflict.
	Imported bool `json:"imported,omitempty"`

	// NextHopRegion: The region of peering route next hop, only applies to
	// dynamic routes.
	NextHopRegion string `json:"nextHopRegion,omitempty"`

	// Priority: The priority of the peering route.
	Priority int64 `json:"priority,omitempty"`

	// Type: The type of the peering route.
	//
	// Possible values:
	//   "DYNAMIC_PEERING_ROUTE" - For routes exported from local network.
	//   "STATIC_PEERING_ROUTE" - The peering route.
	//   "SUBNET_PEERING_ROUTE" - The peering route corresponding to
	// subnetwork range.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestRange") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestRange") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoute) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExchangedPeeringRoutesList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ExchangedPeeringRoute resources.
	Items []*ExchangedPeeringRoute `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#exchangedPeeringRoutesList for exchanged peering routes
	// lists.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ExchangedPeeringRoutesListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoutesList) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoutesList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExchangedPeeringRoutesListWarning: [Output Only] Informational
// warning message.
type ExchangedPeeringRoutesListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*ExchangedPeeringRoutesListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoutesListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoutesListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExchangedPeeringRoutesListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoutesListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoutesListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The
// syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGateway: Represents an external VPN gateway. External VPN
// gateway is the on-premises VPN gateway(s) or another cloud provider's
// VPN gateway that connects to your Google Cloud VPN gateway. To create
// a highly available VPN from Google Cloud Platform to your VPN gateway
// or another cloud provider's VPN gateway, you must create a external
// VPN gateway resource with information about the other gateway. For
// more information about using external VPN gateways, see Creating an
// HA VPN gateway and tunnel pair to a peer VPN.
type ExternalVpnGateway struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id *uint64 `json:"id,omitempty,string"`

	// Interfaces: A list of interfaces for this external VPN gateway. If
	// your peer-side gateway is an on-premises gateway and non-AWS cloud
	// providers' gateway, at most two interfaces can be provided for an
	// external VPN gateway. If your peer side is an AWS virtual private
	// gateway, four interfaces should be provided for an external VPN
	// gateway.
	Interfaces []*ExternalVpnGatewayInterface `json:"interfaces,omitempty"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#externalVpnGateway for externalVpnGateways.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// ExternalVpnGateway, which is essentially a hash of the labels set
	// used for optimistic locking. The fingerprint is initially generated
	// by Compute Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash in
	// order to update or change labels, otherwise the request will fail
	// with error 412 conditionNotMet. To see the latest fingerprint, make a
	// get() request to retrieve an ExternalVpnGateway.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// RedundancyType: Indicates the user-supplied redundancy type of this
	// external VPN gateway.
	//
	// Possible values:
	//   "FOUR_IPS_REDUNDANCY" - The external VPN gateway has four public IP
	// addresses; at the time of writing this API, the AWS virtual private
	// gateway is an example which has four public IP addresses for high
	// availability connections; there should be two VPN connections in the
	// AWS virtual private gateway , each AWS VPN connection has two public
	// IP addresses; please make sure to put two public IP addresses from
	// one AWS VPN connection into interfaces 0 and 1 of this external VPN
	// gateway, and put the other two public IP addresses from another AWS
	// VPN connection into interfaces 2 and 3 of this external VPN gateway.
	// When displaying highly available configuration status for the VPN
	// tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google
	// will always detect whether interfaces 0 and 1 are connected on one
	// interface of HA Cloud VPN gateway, and detect whether interfaces 2
	// and 3 are connected to another interface of the HA Cloud VPN gateway.
	//   "SINGLE_IP_INTERNALLY_REDUNDANT" - The external VPN gateway has
	// only one public IP address which internally provide redundancy or
	// failover.
	//   "TWO_IPS_REDUNDANCY" - The external VPN gateway has two public IP
	// addresses which are redundant with each other, the following two
	// types of setup on your on-premises side would have this type of
	// redundancy: (1) Two separate on-premises gateways, each with one
	// public IP address, the two on-premises gateways are redundant with
	// each other. (2) A single on-premise gateway with two public IP
	// addresses that are redundant with eatch other.
	RedundancyType string `json:"redundancyType,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGateway) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGateway
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGatewayInterface: The interface for the external VPN
// gateway.
type ExternalVpnGatewayInterface struct {
	// Id: The numeric ID of this interface. The allowed input values for
	// this id for different redundancy types of external VPN gateway: -
	// SINGLE_IP_INTERNALLY_REDUNDANT - 0 - TWO_IPS_REDUNDANCY - 0, 1 -
	// FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
	Id int64 `json:"id,omitempty"`

	// IpAddress: IP address of the interface in the external VPN gateway.
	// Only IPv4 is supported. This IP address can be either from your
	// on-premise gateway or another Cloud provider's VPN gateway, it cannot
	// be an IP address from Google Compute Engine.
	IpAddress string `json:"ipAddress,omitempty"`

	// Ipv6Address: IPv6 address of the interface in the external VPN
	// gateway. This IPv6 address can be either from your on-premise gateway
	// or another Cloud provider's VPN gateway, it cannot be an IP address
	// from Google Compute Engine. Must specify an IPv6 address (not
	// IPV4-mapped) using any format described in RFC 4291 (e.g.
	// 2001:db8:0:0:2d9:51:0:0). The output format is RFC 5952 format (e.g.
	// 2001:db8::2d9:51:0:0).
	Ipv6Address string `json:"ipv6Address,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayInterface) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayInterface
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGatewayList: Response to the list request, and contains a
// list of externalVpnGateways.
type ExternalVpnGatewayList struct {
	Etag string `json:"etag,omitempty"`

	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ExternalVpnGateway resources.
	Items []*ExternalVpnGateway `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#externalVpnGatewayList for lists of externalVpnGateways.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ExternalVpnGatewayListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayList) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGatewayListWarning: [Output Only] Informational warning
// message.
type ExternalVpnGatewayListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*ExternalVpnGatewayListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExternalVpnGatewayListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FileContentBuffer struct {
	// Content: The raw content in the secure keys file.
	Content string `json:"content,omitempty"`

	// FileType: The file type of source file.
	//
	// Possible values:
	//   "BIN"
	//   "UNDEFINED"
	//   "X509"
	FileType string `json:"fileType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FileContentBuffer) MarshalJSON() ([]byte, error) {
	type NoMethod FileContentBuffer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Firewall: Represents a Firewall Rule resource. Firewall rules allow
// or deny ingress traffic to, and egress traffic from your instances.
// For more information, read Firewall rules.
type Firewall struct {
	// Allowed: The list of ALLOW rules specified by this firewall. Each
	// rule specifies a protocol and port-range tuple that describes a
	// permitted connection.
	Allowed []*FirewallAllowed `json:"allowed,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Denied: The list of DENY rules specified by this firewall. Each rule
	// specifies a protocol and port-range tuple that describes a denied
	// connection.
	Denied []*FirewallDenied `json:"denied,omitempty"`

	// Description: An optional description of this resource. Provide this
	// field when you create the resource.
	Description string `json:"description,omitempty"`

	// DestinationRanges: If destination ranges are specified, the firewall
	// rule applies only to traffic that has destination IP address in these
	// ranges. These ranges must be expressed in CIDR format. Both IPv4 and
	// IPv6 are supported.
	DestinationRanges []string `json:"destinationRanges,omitempty"`

	// Direction: Direction of traffic to which this firewall applies,
	// either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS`
	// traffic, you cannot specify the sourceTags fields.
	//
	// Possible values:
	//   "EGRESS" - Indicates that firewall should apply to outgoing
	// traffic.
	//   "INGRESS" - Indicates that firewall should apply to incoming
	// traffic.
	Direction string `json:"direction,omitempty"`

	// Disabled: Denotes whether the firewall rule is disabled. When set to
	// true, the firewall rule is not enforced and the network behaves as if
	// it did not exist. If this is unspecified, the firewall rule will be
	// enabled.
	Disabled bool `json:"disabled,omitempty"`

	// EnableLogging: Deprecated in favor of enable in LogConfig. This field
	// denotes whether to enable logging for a particular firewall rule. If
	// logging is enabled, logs will be exported t Cloud Logging.
	EnableLogging bool `json:"enableLogging,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#firewall for
	// firewall rules.
	Kind string `json:"kind,omitempty"`

	// LogConfig: This field denotes the logging options for a particular
	// firewall rule. If logging is enabled, logs will be exported to Cloud
	// Logging.
	LogConfig *FirewallLogConfig `json:"logConfig,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first
	// character must be a lowercase letter, and all following characters
	// (except for the last character) must be a dash, lowercase letter, or
	// digit. The last character must be a lowercase letter or digit.
	Name string `json:"name,omitempty"`

	// Network: URL of the network resource for this firewall rule. If not
	// specified when creating a firewall rule, the default network is used:
	// global/networks/default If you choose to specify this field, you can
	// specify the network as a full or partial URL. For example, the
	// following are all valid URLs: -
	// https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network
	// - projects/myproject/global/networks/my-network -
	// global/networks/default
	Network string `json:"network,omitempty"`

	// Priority: Priority for this rule. This is an integer between `0` and
	// `65535`, both inclusive. The default value is `1000`. Relative
	// priorities determine which rule takes effect if multiple rules apply.
	// Lower values indicate higher priority. For example, a rule with
	// priority `0` has higher precedence than a rule with priority `1`.
	// DENY rules take precedence over ALLOW rules if they have equal
	// priority. Note that VPC networks have implied rules with a priority
	// of `65535`. To avoid conflicts with the implied rules, use a priority
	// number less than `65535`.
	Priority int64 `json:"priority,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SourceRanges: If source ranges are specified, the firewall rule
	// applies only to traffic that has a source IP address in these ranges.
	// These ranges must be expressed in CIDR format. One or both of
	// sourceRanges and sourceTags may be set. If both fields are set, the
	// rule applies to traffic that has a source IP address within
	// sourceRanges OR a source IP from a resource with a matching tag
	// listed in the sourceTags field. The connection does not need to match
	// both fields for the rule to apply. Both IPv4 and IPv6 are supported.
	SourceRanges []string `json:"sourceRanges,omitempty"`

	// SourceServiceAccounts: If source service accounts are specified, the
	// firewall rules apply only to traffic originating from an instance
	// with a service account in this list. Source service accounts cannot
	// be used to control traffic to an instance's external IP address
	// because service accounts are associated with an instance, not an IP
	// address. sourceRanges can be set at the same time as
	// sourceServiceAccounts. If both are set, the firewall applies to
	// traffic that has a source IP address within the sourceRanges OR a
	// source IP that belongs to an instance with service account listed in
	// sourceServiceAccount. The connection does not need to match both
	// fields for the firewall to apply. sourceServiceAccounts cannot be
	// used at the same time as sourceTags or targetTags.
	SourceServiceAccounts []string `json:"sourceServiceAccounts,omitempty"`

	// SourceTags: If source tags are specified, the firewall rule applies
	// only to traffic with source IPs that match the primary network
	// interfaces of VM instances that have the tag and are in the same VPC
	// network. Source tags cannot be used to control traffic to an
	// instance's external IP address, it only applies to traffic between
	// instances in the same virtual network. Because tags are associated
	// with instances, not IP addresses. One or both of sourceRanges and
	// sourceTags may be set. If both fields are set, the firewall applies
	// to traffic that has a source IP address within sourceRanges OR a
	// source IP from a resource with a matching tag listed in the
	// sourceTags field. The connection does not need to match both fields
	// for the firewall to apply.
	SourceTags []string `json:"sourceTags,omitempty"`

	// TargetServiceAccounts: A list of service accounts indicating sets of
	// instances located in the network that may make network connections as
	// specified in allowed[]. targetServiceAccounts cannot be used at the
	// same time as targetTags or sourceTags. If neither
	// targetServiceAccounts nor targetTags are specified, the firewall rule
	// applies to all instances on the specified network.
	TargetServiceAccounts []string `json:"targetServiceAccounts,omitempty"`

	// TargetTags: A list of tags that controls which instances the firewall
	// rule applies to. If targetTags are specified, then the firewall rule
	// applies only to instances in the VPC network that have one of those
	// tags. If no targetTags are specified, the firewall rule applies to
	// all instances on the specified network.
	TargetTags []string `json:"targetTags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Allowed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Allowed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Firewall) MarshalJSON() ([]byte, error) {
	type NoMethod Firewall
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallAllowed struct {
	// IPProtocol: The IP protocol to which this rule applies. The protocol
	// type is required when creating a firewall rule. This value can either
	// be one of the following well known protocol strings (tcp, udp, icmp,
	// esp, ah, ipip, sctp) or the IP protocol number.
	IPProtocol string `json:"IPProtocol,omitempty"`

	// Ports: An optional list of ports to which this rule applies. This
	// field is only applicable for the UDP or TCP protocol. Each entry must
	// be either an integer or a range. If not specified, this rule applies
	// to connections through any port. Example inputs include: ["22"],
	// ["80","443"], and ["12345-12349"].
	Ports []string `json:"ports,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IPProtocol") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IPProtocol") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallAllowed) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallAllowed
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallDenied struct {
	// IPProtocol: The IP protocol to which this rule applies. The protocol
	// type is required when creating a firewall rule. This value can either
	// be one of the following well known protocol strings (tcp, udp, icmp,
	// esp, ah, ipip, sctp) or the IP protocol number.
	IPProtocol string `json:"IPProtocol,omitempty"`

	// Ports: An optional list of ports to which this rule applies. This
	// field is only applicable for the UDP or TCP protocol. Each entry must
	// be either an integer or a range. If not specified, this rule applies
	// to connections through any port. Example inputs include: ["22"],
	// ["80","443"], and ["12345-12349"].
	Ports []string `json:"ports,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IPProtocol") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IPProtocol") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallDenied) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallDenied
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallList: Contains a list of firewalls.
type FirewallList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Firewall resources.
	Items []*Firewall `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#firewallList for
	// lists of firewalls.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *FirewallListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallList) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallListWarning: [Output Only] Informational warning message.
type FirewallListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*FirewallListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallLogConfig: The available logging options for a firewall rule.
type FirewallLogConfig struct {
	// Enable: This field denotes whether to enable logging for a particular
	// firewall rule.
	Enable bool `json:"enable,omitempty"`

	// Metadata: This field can only be specified for a particular firewall
	// rule if logging is enabled for that rule. This field denotes whether
	// to include or exclude metadata for firewall logs.
	//
	// Possible values:
	//   "EXCLUDE_ALL_METADATA"
	//   "INCLUDE_ALL_METADATA"
	Metadata string `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPoliciesListAssociationsResponse struct {
	// Associations: A list of associations.
	Associations []*FirewallPolicyAssociation `json:"associations,omitempty"`

	// Kind: [Output Only] Type of firewallPolicy associations. Always
	// compute#FirewallPoliciesListAssociations for lists of firewallPolicy
	// associations.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Associations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Associations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPoliciesListAssociationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPoliciesListAssociationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicy: Represents a Firewall Policy resource.
type FirewallPolicy struct {
	// Associations: A list of associations that belong to this firewall
	// policy.
	Associations []*FirewallPolicyAssociation `json:"associations,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DisplayName: Deprecated, please use short name instead. User-provided
	// name of the Organization firewall policy. The name should be unique
	// in the organization in which the firewall policy is created. This
	// field is not applicable to network firewall policies. This name must
	// be set on creation and cannot be changed. The name must be 1-63
	// characters long, and comply with RFC1035. Specifically, the name must
	// be 1-63 characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	DisplayName string `json:"displayName,omitempty"`

	// Fingerprint: Specifies a fingerprint for this resource, which is
	// essentially a hash of the metadata's contents and used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update metadata. You must
	// always provide an up-to-date fingerprint hash in order to update or
	// change metadata, otherwise the request will fail with error 412
	// conditionNotMet. To see the latest fingerprint, make get() request to
	// the firewall policy.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output only] Type of the resource. Always
	// compute#firewallPolicyfor firewall policies
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. For Organization Firewall Policies it's a
	// [Output Only] numeric ID allocated by Google Cloud which uniquely
	// identifies the Organization Firewall Policy.
	Name string `json:"name,omitempty"`

	// Parent: [Output Only] The parent of the firewall policy. This field
	// is not applicable to network firewall policies.
	Parent string `json:"parent,omitempty"`

	// Region: [Output Only] URL of the region where the regional firewall
	// policy resides. This field is not applicable to global firewall
	// policies. You must specify this field as part of the HTTP request
	// URL. It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// RuleTupleCount: [Output Only] Total count of all firewall policy rule
	// tuples. A firewall policy can not exceed a set number of tuples.
	RuleTupleCount int64 `json:"ruleTupleCount,omitempty"`

	// Rules: A list of rules that belong to this policy. There must always
	// be a default rule (rule with priority 2147483647 and match "*"). If
	// no rules are provided when creating a firewall policy, a default rule
	// with action "allow" will be added.
	Rules []*FirewallPolicyRule `json:"rules,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ShortName: User-provided name of the Organization firewall policy.
	// The name should be unique in the organization in which the firewall
	// policy is created. This field is not applicable to network firewall
	// policies. This name must be set on creation and cannot be changed.
	// The name must be 1-63 characters long, and comply with RFC1035.
	// Specifically, the name must be 1-63 characters long and match the
	// regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters
	// must be a dash, lowercase letter, or digit, except the last
	// character, which cannot be a dash.
	ShortName string `json:"shortName,omitempty"`

	// VpcNetworkScope: The scope of networks allowed to be associated with
	// the firewall policy. This field can be either GLOBAL_VPC_NETWORK or
	// REGIONAL_VPC_NETWORK. A firewall policy with the VPC scope set to
	// GLOBAL_VPC_NETWORK is allowed to be attached only to global networks.
	// When the VPC scope is set to REGIONAL_VPC_NETWORK the firewall policy
	// is allowed to be attached only to regional networks in the same scope
	// as the firewall policy. Note: if not specified then
	// GLOBAL_VPC_NETWORK will be used.
	//
	// Possible values:
	//   "GLOBAL_VPC_NETWORK" - The firewall policy is allowed to be
	// attached only to global networks.
	//   "REGIONAL_VPC_NETWORK" - The firewall policy is allowed to be
	// attached only to regional networks in the same scope as the firewall
	// policy. This option is applicable only to regional firewall policies.
	VpcNetworkScope string `json:"vpcNetworkScope,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Associations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Associations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyAssociation struct {
	// AttachmentTarget: The target that the firewall policy is attached to.
	AttachmentTarget string `json:"attachmentTarget,omitempty"`

	// DisplayName: [Output Only] Deprecated, please use short name instead.
	// The display name of the firewall policy of the association.
	DisplayName string `json:"displayName,omitempty"`

	// FirewallPolicyId: [Output Only] The firewall policy ID of the
	// association.
	FirewallPolicyId string `json:"firewallPolicyId,omitempty"`

	// Name: The name for an association.
	Name string `json:"name,omitempty"`

	// Priority: An integer indicating the priority of an association. The
	// priority must be a positive value between 1 and 2147483647. Firewall
	// Policies are evaluated from highest to lowest priority where 1 is the
	// highest priority and 2147483647 is the lowest priority. The default
	// value is `1000`. If two associations have the same priority then
	// lexicographical order on association names is applied.
	Priority int64 `json:"priority,omitempty"`

	// ShortName: [Output Only] The short name of the firewall policy of the
	// association.
	ShortName string `json:"shortName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttachmentTarget") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachmentTarget") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyAssociation) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyAssociation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of FirewallPolicy resources.
	Items []*FirewallPolicy `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#firewallPolicyList for listsof FirewallPolicies
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *FirewallPolicyListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyList) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicyListWarning: [Output Only] Informational warning
// message.
type FirewallPolicyListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*FirewallPolicyListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicyRule: Represents a rule that describes one or more
// match conditions along with the action to be taken when traffic
// matches this condition (allow or deny).
type FirewallPolicyRule struct {
	// Action: The Action to perform when the client connection triggers the
	// rule. Valid actions are "allow", "deny" and "goto_next".
	Action string `json:"action,omitempty"`

	// Description: An optional description for this resource.
	Description string `json:"description,omitempty"`

	// Direction: The direction in which this rule applies.
	//
	// Possible values:
	//   "EGRESS"
	//   "INGRESS"
	Direction string `json:"direction,omitempty"`

	// Disabled: Denotes whether the firewall policy rule is disabled. When
	// set to true, the firewall policy rule is not enforced and traffic
	// behaves as if it did not exist. If this is unspecified, the firewall
	// policy rule will be enabled.
	Disabled bool `json:"disabled,omitempty"`

	// EnableLogging: Denotes whether to enable logging for a particular
	// rule. If logging is enabled, logs will be exported to the configured
	// export destination in Stackdriver. Logs may be exported to BigQuery
	// or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
	EnableLogging bool `json:"enableLogging,omitempty"`

	// Kind: [Output only] Type of the resource. Always
	// compute#firewallPolicyRule for firewall policy rules
	Kind string `json:"kind,omitempty"`

	// Match: A match condition that incoming traffic is evaluated against.
	// If it evaluates to true, the corresponding 'action' is enforced.
	Match *FirewallPolicyRuleMatcher `json:"match,omitempty"`

	// Priority: An integer indicating the priority of a rule in the list.
	// The priority must be a positive value between 0 and 2147483647. Rules
	// are evaluated from highest to lowest priority where 0 is the highest
	// priority and 2147483647 is the lowest prority.
	Priority int64 `json:"priority,omitempty"`

	// RuleName: An optional name for the rule. This field is not a unique
	// identifier and can be updated.
	RuleName string `json:"ruleName,omitempty"`

	// RuleTupleCount: [Output Only] Calculation of the complexity of a
	// single firewall policy rule.
	RuleTupleCount int64 `json:"ruleTupleCount,omitempty"`

	// SecurityProfileGroup: A fully-qualified URL of a SecurityProfile
	// resource instance. Example:
	// https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
	// Must be specified if action = 'apply_security_profile_group' and
	// cannot be specified for other actions.
	SecurityProfileGroup string `json:"securityProfileGroup,omitempty"`

	// TargetResources: A list of network resource URLs to which this rule
	// applies. This field allows you to control which network's VMs get
	// this rule. If this field is left blank, all VMs within the
	// organization will receive the rule.
	TargetResources []string `json:"targetResources,omitempty"`

	// TargetSecureTags: A list of secure tags that controls which instances
	// the firewall rule applies to. If targetSecureTag are specified, then
	// the firewall rule applies only to instances in the VPC network that
	// have one of those EFFECTIVE secure tags, if all the target_secure_tag
	// are in INEFFECTIVE state, then this rule will be ignored.
	// targetSecureTag may not be set at the same time as
	// targetServiceAccounts. If neither targetServiceAccounts nor
	// targetSecureTag are specified, the firewall rule applies to all
	// instances on the specified network. Maximum number of target label
	// tags allowed is 256.
	TargetSecureTags []*FirewallPolicyRuleSecureTag `json:"targetSecureTags,omitempty"`

	// TargetServiceAccounts: A list of service accounts indicating the sets
	// of instances that are applied with this rule.
	TargetServiceAccounts []string `json:"targetServiceAccounts,omitempty"`

	// TlsInspect: Boolean flag indicating if the traffic should be TLS
	// decrypted. Can be set only if action = 'apply_security_profile_group'
	// and cannot be set for other actions.
	TlsInspect bool `json:"tlsInspect,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicyRuleMatcher: Represents a match condition that incoming
// traffic is evaluated against. Exactly one field must be specified.
type FirewallPolicyRuleMatcher struct {
	// DestAddressGroups: Address groups which should be matched against the
	// traffic destination. Maximum number of destination address groups is
	// 10.
	DestAddressGroups []string `json:"destAddressGroups,omitempty"`

	// DestFqdns: Fully Qualified Domain Name (FQDN) which should be matched
	// against traffic destination. Maximum number of destination fqdn
	// allowed is 100.
	DestFqdns []string `json:"destFqdns,omitempty"`

	// DestIpRanges: CIDR IP address range. Maximum number of destination
	// CIDR IP ranges allowed is 5000.
	DestIpRanges []string `json:"destIpRanges,omitempty"`

	// DestRegionCodes: Region codes whose IP addresses will be used to
	// match for destination of traffic. Should be specified as 2 letter
	// country code defined as per ISO 3166 alpha-2 country codes. ex."US"
	// Maximum number of dest region codes allowed is 5000.
	DestRegionCodes []string `json:"destRegionCodes,omitempty"`

	// DestThreatIntelligences: Names of Network Threat Intelligence lists.
	// The IPs in these lists will be matched against traffic destination.
	DestThreatIntelligences []string `json:"destThreatIntelligences,omitempty"`

	// Layer4Configs: Pairs of IP protocols and ports that the rule should
	// match.
	Layer4Configs []*FirewallPolicyRuleMatcherLayer4Config `json:"layer4Configs,omitempty"`

	// SrcAddressGroups: Address groups which should be matched against the
	// traffic source. Maximum number of source address groups is 10.
	SrcAddressGroups []string `json:"srcAddressGroups,omitempty"`

	// SrcFqdns: Fully Qualified Domain Name (FQDN) which should be matched
	// against traffic source. Maximum number of source fqdn allowed is 100.
	SrcFqdns []string `json:"srcFqdns,omitempty"`

	// SrcIpRanges: CIDR IP address range. Maximum number of source CIDR IP
	// ranges allowed is 5000.
	SrcIpRanges []string `json:"srcIpRanges,omitempty"`

	// SrcRegionCodes: Region codes whose IP addresses will be used to match
	// for source of traffic. Should be specified as 2 letter country code
	// defined as per ISO 3166 alpha-2 country codes. ex."US" Maximum number
	// of source region codes allowed is 5000.
	SrcRegionCodes []string `json:"srcRegionCodes,omitempty"`

	// SrcSecureTags: List of secure tag values, which should be matched at
	// the source of the traffic. For INGRESS rule, if all the srcSecureTag
	// are INEFFECTIVE, and there is no srcIpRange, this rule will be
	// ignored. Maximum number of source tag values allowed is 256.
	SrcSecureTags []*FirewallPolicyRuleSecureTag `json:"srcSecureTags,omitempty"`

	// SrcThreatIntelligences: Names of Network Threat Intelligence lists.
	// The IPs in these lists will be matched against traffic source.
	SrcThreatIntelligences []string `json:"srcThreatIntelligences,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestAddressGroups")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestAddressGroups") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRuleMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRuleMatcher
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyRuleMatcherLayer4Config struct {
	// IpProtocol: The IP protocol to which this rule applies. The protocol
	// type is required when creating a firewall rule. This value can either
	// be one of the following well known protocol strings (tcp, udp, icmp,
	// esp, ah, ipip, sctp), or the IP protocol number.
	IpProtocol string `json:"ipProtocol,omitempty"`

	// Ports: An optional list of ports to which this rule applies. This
	// field is only applicable for UDP or TCP protocol. Each entry must be
	// either an integer or a range. If not specified, this rule applies to
	// connections through any port. Example inputs include: ["22"],
	// ["80","443"], and ["12345-12349"].
	Ports []string `json:"ports,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IpProtocol") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IpProtocol") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRuleMatcherLayer4Config) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRuleMatcherLayer4Config
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyRuleSecureTag struct {
	// Name: Name of the secure tag, created with TagManager's TagValue API.
	Name string `json:"name,omitempty"`

	// State: [Output Only] State of the secure tag, either `EFFECTIVE` or
	// `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or
	// its network is deleted.
	//
	// Possible values:
	//   "EFFECTIVE"
	//   "INEFFECTIVE"
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRuleSecureTag) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRuleSecureTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FixedOrPercent: Encapsulates numeric value that can be either
// absolute or relative.
type FixedOrPercent struct {
	// Calculated: [Output Only] Absolute value of VM instances calculated
	// based on the specific mode. - If the value is fixed, then the
	// calculated value is equal to the fixed value. - If the value is a
	// percent, then the calculated value is percent/100 * targetSize. For
	// example, the calculated value of a 80% of a managed instance group
	// with 150 instances would be (80/100 * 150) = 120 VM instances. If
	// there is a remainder, the number is rounded.
	Calculated int64 `json:"calculated,omitempty"`

	// Fixed: Specifies a fixed number of VM instances. This must be a
	// positive integer.
	Fixed int64 `json:"fixed,omitempty"`

	// Percent: Specifies a percentage of instances between 0 to 100%,
	// inclusive. For example, specify 80 for 80%.
	Percent int64 `json:"percent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Calculated") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Calculated") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FixedOrPercent) MarshalJSON() ([]byte, error) {
	type NoMethod FixedOrPercent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRule: Represents a Forwarding Rule resource. Forwarding
// rule resources in Google Cloud can be either regional or global in
// scope: * Global
// (https://cloud.google.com/compute/docs/reference/rest/alpha/globalForwardingRules)
// * Regional
// (https://cloud.google.com/compute/docs/reference/rest/alpha/forwardingRules)
// A forwarding rule and its corresponding IP address represent the
// frontend configuration of a Google Cloud Platform load balancer.
// Forwarding rules can also reference target instances and Cloud VPN
// Classic gateways (targetVpnGateway). For more information, read
// Forwarding rule concepts and Using protocol forwarding.
type ForwardingRule struct {
	// IPAddress: IP address for which this forwarding rule accepts traffic.
	// When a client sends traffic to this IP address, the forwarding rule
	// directs the traffic to the referenced target or backendService. While
	// creating a forwarding rule, specifying an IPAddress is required under
	// the following circumstances: - When the target is set to
	// targetGrpcProxy and validateForProxyless is set to true, the
	// IPAddress should be set to 0.0.0.0. - When the target is a Private
	// Service Connect Google APIs bundle, you must specify an IPAddress.
	// Otherwise, you can optionally specify an IP address that references
	// an existing static (reserved) IP address resource. When omitted,
	// Google Cloud assigns an ephemeral IP address. Use one of the
	// following formats to specify an IP address while creating a
	// forwarding rule: * IP address number, as in `100.1.2.3` * IPv6
	// address range, as in `2600:1234::/96` * Full resource URL, as in
	// https://www.googleapis.com/compute/v1/projects/
	// project_id/regions/region/addresses/address-name * Partial URL or by
	// name, as in: -
	// projects/project_id/regions/region/addresses/address-name -
	// regions/region/addresses/address-name - global/addresses/address-name
	// - address-name The forwarding rule's target or backendService, and in
	// most cases, also the loadBalancingScheme, determine the type of IP
	// address that you can use. For detailed information, see IP address
	// specifications
	// (https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
	// When reading an IPAddress, the API always returns the IP address
	// number.
	IPAddress string `json:"IPAddress,omitempty"`

	// IPProtocol: The IP protocol to which this rule applies. For protocol
	// forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and
	// L3_DEFAULT. The valid IP protocols are different for different load
	// balancing products as described in Load balancing features
	// (https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
	//
	// Possible values:
	//   "AH"
	//   "ALL"
	//   "ESP"
	//   "ICMP"
	//   "L3_DEFAULT"
	//   "SCTP"
	//   "TCP"
	//   "UDP"
	IPProtocol string `json:"IPProtocol,omitempty"`

	// AllPorts: This field can only be used: - If IPProtocol is one of TCP,
	// UDP, or SCTP. - By internal TCP/UDP load balancers, backend
	// service-based network load balancers, and internal and external
	// protocol forwarding. Set this field to true to allow packets
	// addressed to any port or packets lacking destination port information
	// (for example, UDP fragments after the first fragment) to be forwarded
	// to the backends configured with this forwarding rule. The ports,
	// port_range, and allPorts fields are mutually exclusive.
	AllPorts bool `json:"allPorts,omitempty"`

	// AllowGlobalAccess: This field is used along with the backend_service
	// field for internal load balancing or with the target field for
	// internal TargetInstance. If the field is set to TRUE, clients can
	// access ILB from all regions. Otherwise only allows access from
	// clients in the same region as the internal load balancer.
	AllowGlobalAccess bool `json:"allowGlobalAccess,omitempty"`

	// AllowPscGlobalAccess: This is used in PSC consumer ForwardingRule to
	// control whether the PSC endpoint can be accessed from another region.
	AllowPscGlobalAccess bool `json:"allowPscGlobalAccess,omitempty"`

	// BackendService: Identifies the backend service to which the
	// forwarding rule sends traffic. Required for Internal TCP/UDP Load
	// Balancing and Network Load Balancing; must be omitted for all other
	// load balancer types.
	BackendService string `json:"backendService,omitempty"`

	// BaseForwardingRule: [Output Only] The URL for the corresponding base
	// Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule
	// that has the same IP address, protocol, and port settings with the
	// current Forwarding Rule, but without sourceIPRanges specified. Always
	// empty if the current Forwarding Rule does not have sourceIPRanges
	// specified.
	BaseForwardingRule string `json:"baseForwardingRule,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Fingerprint: Fingerprint of this resource. A hash of the contents
	// stored in this object. This field is used in optimistic locking. This
	// field will be ignored when inserting a ForwardingRule. Include the
	// fingerprint in patch request to ensure that you do not overwrite
	// changes that were applied from another concurrent request. To see the
	// latest fingerprint, make a get() request to retrieve a
	// ForwardingRule.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// IpVersion: The IP Version that will be used by this forwarding rule.
	// Valid options are IPV4 or IPV6.
	//
	// Possible values:
	//   "IPV4"
	//   "IPV6"
	//   "UNSPECIFIED_VERSION"
	IpVersion string `json:"ipVersion,omitempty"`

	// IsMirroringCollector: Indicates whether or not this load balancer can
	// be used as a collector for packet mirroring. To prevent mirroring
	// loops, instances behind this load balancer will not have their
	// traffic mirrored even if a PacketMirroring rule applies to them. This
	// can only be set to true for load balancers that have their
	// loadBalancingScheme set to INTERNAL.
	IsMirroringCollector bool `json:"isMirroringCollector,omitempty"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#forwardingRule for Forwarding Rule resources.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// resource, which is essentially a hash of the labels set used for
	// optimistic locking. The fingerprint is initially generated by Compute
	// Engine and changes after every request to modify or update labels.
	// You must always provide an up-to-date fingerprint hash in order to
	// update or change labels, otherwise the request will fail with error
	// 412 conditionNotMet. To see the latest fingerprint, make a get()
	// request to retrieve a ForwardingRule.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// LoadBalancingScheme: Specifies the forwarding rule type. For more
	// information about forwarding rules, refer to Forwarding rule
	// concepts.
	//
	// Possible values:
	//   "EXTERNAL"
	//   "EXTERNAL_MANAGED"
	//   "INTERNAL"
	//   "INTERNAL_MANAGED"
	//   "INTERNAL_SELF_MANAGED"
	//   "INVALID"
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`

	// MetadataFilters: Opaque filter criteria used by load balancer to
	// restrict routing configuration to a limited set of xDS compliant
	// clients. In their xDS requests to load balancer, xDS clients present
	// node metadata. When there is a match, the relevant configuration is
	// made available to those proxies. Otherwise, all the resources (e.g.
	// TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not
	// visible to those proxies. For each metadataFilter in this list, if
	// its filterMatchCriteria is set to MATCH_ANY, at least one of the
	// filterLabels must match the corresponding label provided in the
	// metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of
	// its filterLabels must match with corresponding labels provided in the
	// metadata. If multiple metadataFilters are specified, all of them need
	// to be satisfied in order to be considered a match. metadataFilters
	// specified here will be applifed before those specified in the UrlMap
	// that this ForwardingRule references. metadataFilters only applies to
	// Loadbalancers that have their loadBalancingScheme set to
	// INTERNAL_SELF_MANAGED.
	MetadataFilters []*MetadataFilter `json:"metadataFilters,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash. For Private Service Connect
	// forwarding rules that forward traffic to Google APIs, the forwarding
	// rule name must be a 1-20 characters string with lowercase letters and
	// numbers and must start with a letter.
	Name string `json:"name,omitempty"`

	// Network: This field is not used for external load balancing. For
	// Internal TCP/UDP Load Balancing, this field identifies the network
	// that the load balanced IP should belong to for this Forwarding Rule.
	// If the subnetwork is specified, the network of the subnetwork will be
	// used. If neither subnetwork nor this field is specified, the default
	// network will be used. For Private Service Connect forwarding rules
	// that forward traffic to Google APIs, a network must be provided.
	Network string `json:"network,omitempty"`

	// NetworkTier: This signifies the networking tier used for configuring
	// this load balancer and can only take the following values: PREMIUM,
	// STANDARD. For regional ForwardingRule, the valid values are PREMIUM
	// and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
	// If this field is not specified, it is assumed to be PREMIUM. If
	// IPAddress is specified, this value must be equal to the networkTier
	// of the Address.
	//
	// Possible values:
	//   "FIXED_STANDARD" - Public internet quality with fixed bandwidth.
	//   "PREMIUM" - High quality, Google-grade network tier, support for
	// all networking products.
	//   "SELECT" - Price competitive network tier, support for all
	// networking products.
	//   "STANDARD" - Public internet quality, only limited support for
	// other networking products.
	//   "STANDARD_OVERRIDES_FIXED_STANDARD" - (Output only) Temporary tier
	// for FIXED_STANDARD when fixed standard tier is expired or not
	// configured.
	NetworkTier string `json:"networkTier,omitempty"`

	// NoAutomateDnsZone: This is used in PSC consumer ForwardingRule to
	// control whether it should try to auto-generate a DNS zone or not.
	// Non-PSC forwarding rules do not use this field.
	NoAutomateDnsZone bool `json:"noAutomateDnsZone,omitempty"`

	// PortRange: This field can only be used: - If IPProtocol is one of
	// TCP, UDP, or SCTP. - By backend service-based network load balancers,
	// target pool-based network load balancers, internal proxy load
	// balancers, external proxy load balancers, Traffic Director, external
	// protocol forwarding, and Classic VPN. Some products have restrictions
	// on what ports can be used. See port specifications for details. Only
	// packets addressed to ports in the specified range will be forwarded
	// to the backends configured with this forwarding rule. The ports,
	// port_range, and allPorts fields are mutually exclusive. For external
	// forwarding rules, two or more forwarding rules cannot use the same
	// [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges.
	// For internal forwarding rules within the same VPC network, two or
	// more forwarding rules cannot use the same [IPAddress, IPProtocol]
	// pair, and cannot have overlapping portRanges. @pattern:
	// \\d+(?:-\\d+)?
	PortRange string `json:"portRange,omitempty"`

	// Ports: This field can only be used: - If IPProtocol is one of TCP,
	// UDP, or SCTP. - By internal TCP/UDP load balancers, backend
	// service-based network load balancers, and internal protocol
	// forwarding. You can specify a list of up to five ports by number,
	// separated by commas. The ports can be contiguous or discontiguous.
	// Only packets addressed to these ports will be forwarded to the
	// backends configured with this forwarding rule. For external
	// forwarding rules, two or more forwarding rules cannot use the same
	// [IPAddress, IPProtocol] pair, and cannot share any values defined in
	// ports. For internal forwarding rules within the same VPC network, two
	// or more forwarding rules cannot use the same [IPAddress, IPProtocol]
	// pair, and cannot share any values defined in ports. The ports,
	// port_range, and allPorts fields are mutually exclusive. @pattern:
	// \\d+(?:-\\d+)?
	Ports []string `json:"ports,omitempty"`

	// PscConnectionId: [Output Only] The PSC connection id of the PSC
	// Forwarding Rule.
	PscConnectionId uint64 `json:"pscConnectionId,omitempty,string"`

	// Possible values:
	//   "ACCEPTED" - The connection has been accepted by the producer.
	//   "CLOSED" - The connection has been closed by the producer and will
	// not serve traffic going forward.
	//   "NEEDS_ATTENTION" - The connection has been accepted by the
	// producer, but the producer needs to take further action before the
	// forwarding rule can serve traffic.
	//   "PENDING" - The connection is pending acceptance by the producer.
	//   "REJECTED" - The connection has been rejected by the producer.
	//   "STATUS_UNSPECIFIED"
	PscConnectionStatus string `json:"pscConnectionStatus,omitempty"`

	// Region: [Output Only] URL of the region where the regional forwarding
	// rule resides. This field is not applicable to global forwarding
	// rules. You must specify this field as part of the HTTP request URL.
	// It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServiceDirectoryRegistrations: Service Directory resources to
	// register this forwarding rule with. Currently, only supports a single
	// Service Directory resource.
	ServiceDirectoryRegistrations []*ForwardingRuleServiceDirectoryRegistration `json:"serviceDirectoryRegistrations,omitempty"`

	// ServiceLabel: An optional prefix to the service name for this
	// Forwarding Rule. If specified, the prefix is the first label of the
	// fully qualified service name. The label must be 1-63 characters long,
	// and comply with RFC1035. Specifically, the label must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash. This field is only used for internal load balancing.
	ServiceLabel string `json:"serviceLabel,omitempty"`

	// ServiceName: [Output Only] The internal fully qualified service name
	// for this Forwarding Rule. This field is only used for internal load
	// balancing.
	ServiceName string `json:"serviceName,omitempty"`

	// SourceIpRanges: If not empty, this Forwarding Rule will only forward
	// the traffic when the source IP address matches one of the IP
	// addresses or CIDR ranges set here. Note that a Forwarding Rule can
	// only have up to 64 source IP ranges, and this field can only be used
	// with a regional Forwarding Rule whose scheme is EXTERNAL. Each
	// source_ip_range entry should be either an IP address (for example,
	// 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
	SourceIpRanges []string `json:"sourceIpRanges,omitempty"`

	// Subnetwork: This field identifies the subnetwork that the load
	// balanced IP should belong to for this Forwarding Rule, used in
	// internal load balancing and network load balancing with IPv6. If the
	// network specified is in auto subnet mode, this field is optional.
	// However, a subnetwork must be specified if the network is in custom
	// subnet mode or when creating external forwarding rule with IPv6.
	Subnetwork string `json:"subnetwork,omitempty"`

	// Target: The URL of the target resource to receive the matched
	// traffic. For regional forwarding rules, this target must be in the
	// same region as the forwarding rule. For global forwarding rules, this
	// target must be a global load balancing resource. The forwarded
	// traffic must be of a type appropriate to the target object. - For
	// load balancers, see the "Target" column in Port specifications
	// (https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
	// - For Private Service Connect forwarding rules that forward traffic
	// to Google APIs, provide the name of a supported Google API bundle: -
	// vpc-sc - APIs that support VPC Service Controls. - all-apis - All
	// supported Google APIs. - For Private Service Connect forwarding rules
	// that forward traffic to managed services, the target must be a
	// service attachment.
	Target string `json:"target,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IPAddress") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IPAddress") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRule) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ForwardingRulesScopedList resources.
	Items map[string]ForwardingRulesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#forwardingRuleAggregatedList for lists of forwarding rules.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ForwardingRuleAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleAggregatedListWarning: [Output Only] Informational
// warning message.
type ForwardingRuleAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*ForwardingRuleAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleList: Contains a list of ForwardingRule resources.
type ForwardingRuleList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ForwardingRule resources.
	Items []*ForwardingRule `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ForwardingRuleListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleList) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleListWarning: [Output Only] Informational warning
// message.
type ForwardingRuleListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*ForwardingRuleListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleReference struct {
	ForwardingRule string `json:"forwardingRule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ForwardingRule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ForwardingRule") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleReference) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleServiceDirectoryRegistration: Describes the
// auto-registration of the Forwarding Rule to Service Directory. The
// region and project of the Service Directory resource generated from
// this registration will be the same as this Forwarding Rule.
type ForwardingRuleServiceDirectoryRegistration struct {
	// Namespace: Service Directory namespace to register the forwarding
	// rule under.
	Namespace string `json:"namespace,omitempty"`

	// Service: Service Directory service to register the forwarding rule
	// under.
	Service string `json:"service,omitempty"`

	// ServiceDirectoryRegion: [Optional] Service Directory region to
	// register this global forwarding rule under. Default to "us-central1".
	// Only used for PSC for Google APIs. All PSC for Google APIs Forwarding
	// Rules on the same network should use the same Service Directory
	// region.
	ServiceDirectoryRegion string `json:"serviceDirectoryRegion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Namespace") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Namespace") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleServiceDirectoryRegistration) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleServiceDirectoryRegistration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRulesScopedList struct {
	// ForwardingRules: A list of forwarding rules contained in this scope.
	ForwardingRules []*ForwardingRule `json:"forwardingRules,omitempty"`

	// Warning: Informational warning which replaces the list of forwarding
	// rules when the list is empty.
	Warning *ForwardingRulesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ForwardingRules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ForwardingRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRulesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRulesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRulesScopedListWarning: Informational warning which
// replaces the list of forwarding rules when the list is empty.
type ForwardingRulesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*ForwardingRulesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRulesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRulesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRulesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRulesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRulesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservation struct {
	// CreationTimestamp: [Output Only] The creation timestamp for this
	// future reservation in RFC3339 text format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the future reservation.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] A unique identifier for this future reservation.
	// The server defines this identifier.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#futureReservation for future reservations.
	Kind string `json:"kind,omitempty"`

	// Name: The name of the resource, provided by the client when initially
	// creating the resource. The resource name must be 1-63 characters
	// long, and comply with RFC1035. Specifically, the name must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	Name string `json:"name,omitempty"`

	// NamePrefix: Name prefix for the reservations to be created at the
	// time of delivery. The name prefix must comply with RFC1035. Maximum
	// allowed length for name prefix is 20. Automatically created
	// reservations name format will be -date-####.
	NamePrefix string `json:"namePrefix,omitempty"`

	// PlanningStatus: Planning state before being submitted for evaluation
	//
	// Possible values:
	//   "DRAFT" - Future Reservation is being drafted.
	//   "PLANNING_STATUS_UNSPECIFIED"
	//   "SUBMITTED" - Future Reservation has been submitted for evaluation
	// by GCP.
	PlanningStatus string `json:"planningStatus,omitempty"`

	// SelfLink: [Output Only] Server-defined fully-qualified URL for this
	// resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ShareSettings: List of Projects/Folders to share with.
	ShareSettings *ShareSettings `json:"shareSettings,omitempty"`

	// SpecificSkuProperties: Future Reservation configuration to indicate
	// instance properties and total count.
	SpecificSkuProperties *FutureReservationSpecificSKUProperties `json:"specificSkuProperties,omitempty"`

	// Status: [Output only] Status of the Future Reservation
	Status *FutureReservationStatus `json:"status,omitempty"`

	// TimeWindow: Time window for this Future Reservation.
	TimeWindow *FutureReservationTimeWindow `json:"timeWindow,omitempty"`

	// Zone: [Output Only] URL of the Zone where this future reservation
	// resides.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservation) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservationSpecificSKUProperties struct {
	// InstanceProperties: Properties of the SKU instances being reserved.
	InstanceProperties *AllocationSpecificSKUAllocationReservedInstanceProperties `json:"instanceProperties,omitempty"`

	// SourceInstanceTemplate: The instance template that will be used to
	// populate the ReservedInstanceProperties of the future reservation
	SourceInstanceTemplate string `json:"sourceInstanceTemplate,omitempty"`

	// TotalCount: Total number of instances for which capacity assurance is
	// requested at a future time period.
	TotalCount int64 `json:"totalCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "InstanceProperties")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstanceProperties") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationSpecificSKUProperties) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationSpecificSKUProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FutureReservationStatus: [Output only] Represents status related to
// the future reservation.
type FutureReservationStatus struct {
	// AutoCreatedReservations: Fully qualified urls of the automatically
	// created reservations at start_time.
	AutoCreatedReservations []string `json:"autoCreatedReservations,omitempty"`

	// FulfilledCount: This count indicates the fulfilled capacity so far.
	// This is set during "PROVISIONING" state. This count also includes
	// capacity delivered as part of existing matching reservations.
	FulfilledCount int64 `json:"fulfilledCount,omitempty,string"`

	// LockTime: Time when Future Reservation would become LOCKED, after
	// which no modifications to Future Reservation will be allowed.
	// Applicable only after the Future Reservation is in the APPROVED
	// state. The lock_time is an RFC3339 string. The procurement_status
	// will transition to PROCURING state at this time.
	LockTime string `json:"lockTime,omitempty"`

	// ProcurementStatus: Current state of this Future Reservation
	//
	// Possible values:
	//   "APPROVED" - Future reservation is approved by GCP.
	//   "CANCELLED" - Future reservation is cancelled by the customer.
	//   "COMMITTED" - Future reservation is committed by the customer.
	//   "DECLINED" - Future reservation is rejected by GCP.
	//   "DRAFTING" - Related status for PlanningStatus.Draft. Transitions
	// to PENDING_APPROVAL upon user submitting FR.
	//   "FAILED" - Future reservation failed. No additional reservations
	// were provided.
	//   "FAILED_PARTIALLY_FULFILLED" - Future reservation is partially
	// fulfilled. Additional reservations were provided but did not reach
	// total_count reserved instance slots.
	//   "FULFILLED" - Future reservation is fulfilled completely.
	//   "PENDING_APPROVAL" - Future reservation is pending approval by GCP.
	//   "PROCUREMENT_STATUS_UNSPECIFIED"
	//   "PROCURING" - Future reservation is being procured by GCP. Beyond
	// this point, Future reservation is locked and no further modifications
	// are allowed.
	//   "PROVISIONING" - Future reservation capacity is being provisioned.
	// This state will be entered after start_time, while reservations are
	// being created to provide total_count reserved instance slots. This
	// state will not persist past start_time + 24h.
	ProcurementStatus string `json:"procurementStatus,omitempty"`

	SpecificSkuProperties *FutureReservationStatusSpecificSKUProperties `json:"specificSkuProperties,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AutoCreatedReservations") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoCreatedReservations")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FutureReservationStatusSpecificSKUProperties: Properties to be set
// for the Future Reservation.
type FutureReservationStatusSpecificSKUProperties struct {
	// SourceInstanceTemplateId: ID of the instance template used to
	// populate the Future Reservation properties.
	SourceInstanceTemplateId string `json:"sourceInstanceTemplateId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SourceInstanceTemplateId") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceInstanceTemplateId")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationStatusSpecificSKUProperties) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationStatusSpecificSKUProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservationTimeWindow struct {
	Duration *Duration `json:"duration,omitempty"`

	EndTime string `json:"endTime,omitempty"`

	// StartTime: Start time of the Future Reservation. The start_time is an
	// RFC3339 string.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationTimeWindow) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationTimeWindow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FutureReservationsAggregatedListResponse: Contains a list of future
// reservations.
type FutureReservationsAggregatedListResponse struct {
	Etag string `json:"etag,omitempty"`

	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Future reservation resources.
	Items map[string]FutureReservationsScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#futureReservationsAggregatedListResponse for future
	// resevation aggregated list response.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *FutureReservationsAggregatedListResponseWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsAggregatedListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsAggregatedListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FutureReservationsAggregatedListResponseWarning: [Output Only]
// Informational warning message.
type FutureReservationsAggregatedListResponseWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*FutureReservationsAggregatedListResponseWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsAggregatedListResponseWarning) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsAggregatedListResponseWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservationsAggregatedListResponseWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsAggregatedListResponseWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsAggregatedListResponseWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservationsListResponse struct {
	Etag string `json:"etag,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id string `json:"id,omitempty"`

	// Items: [Output Only] A list of future reservation resources.
	Items []*FutureReservation `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource.Always
	// compute#FutureReservationsListResponse for lists of reservations
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *FutureReservationsListResponseWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FutureReservationsListResponseWarning: [Output Only] Informational
// warning message.
type FutureReservationsListResponseWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*FutureReservationsListResponseWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsListResponseWarning) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsListResponseWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservationsListResponseWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsListResponseWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsListResponseWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservationsScopedList struct {
	// FutureReservations: A list of future reservations contained in this
	// scope.
	FutureReservations []*FutureReservation `json:"futureReservations,omitempty"`

	// Warning: Informational warning which replaces the list of future
	// reservations when the list is empty.
	Warning *FutureReservationsScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FutureReservations")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FutureReservations") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FutureReservationsScopedListWarning: Informational warning which
// replaces the list of future reservations when the list is empty.
type FutureReservationsScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*FutureReservationsScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FutureReservationsScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FutureReservationsScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod FutureReservationsScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GRPCHealthCheck struct {
	// GrpcServiceName: The gRPC service name for the health check. This
	// field is optional. The value of grpc_service_name has the following
	// meanings by convention: - Empty service_name means the overall status
	// of all services at the backend. - Non-empty service_name means the
	// health of that gRPC service, as defined by the owner of the service.
	// The grpc_service_name can only be ASCII.
	GrpcServiceName string `json:"grpcServiceName,omitempty"`

	// Port: The TCP port number to which the health check prober sends
	// packets. Valid values are 1 through 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Not supported.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how a port is selected for health
	// checking. Can be one of the following values: USE_FIXED_PORT:
	// Specifies a port number explicitly using the port field in the health
	// check. Supported by backend services for pass-through load balancers
	// and backend services for proxy load balancers. Not supported by
	// target pools. The health check supports all backends supported by the
	// backend service provided the backend can be health checked. For
	// example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network
	// endpoint groups, and instance group backends. USE_NAMED_PORT: Not
	// supported. USE_SERVING_PORT: Provides an indirect method of
	// specifying the health check port by referring to the backend service.
	// Only supported by backend services for proxy load balancers. Not
	// supported by target pools. Not supported by backend services for
	// pass-through load balancers. Supports all backends that can be health
	// checked; for example, GCE_VM_IP_PORT network endpoint groups and
	// instance group backends. For GCE_VM_IP_PORT network endpoint group
	// backends, the health check uses the port number specified for each
	// endpoint in the network endpoint group. For instance group backends,
	// the health check uses the port number determined by looking up the
	// backend service's named port in the instance group's list of named
	// ports.
	//
	// Possible values:
	//   "USE_FIXED_PORT" - The port number in the health check's port is
	// used for health checking. Applies to network endpoint group and
	// instance group backends.
	//   "USE_NAMED_PORT" - Not supported.
	//   "USE_SERVING_PORT" - For network endpoint group backends, the
	// health check uses the port number specified on each endpoint in the
	// network endpoint group. For instance group backends, the health check
	// uses the port number specified for the backend service's named port
	// defined in the instance group's named ports.
	PortSpecification string `json:"portSpecification,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GrpcServiceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GrpcServiceName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GRPCHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod GRPCHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetOwnerInstanceResponse struct {
	// Instance: Full instance resource URL.
	Instance string `json:"instance,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetOwnerInstanceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetOwnerInstanceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalAddressesMoveRequest struct {
	// Description: An optional destination address description if intended
	// to be different from the source.
	Description string `json:"description,omitempty"`

	// DestinationAddress: The URL of the destination address to move to.
	// This can be a full or partial URL. For example, the following are all
	// valid URLs to a address: -
	// https://www.googleapis.com/compute/v1/projects/project
	// /global/addresses/address - projects/project/global/addresses/address
	// Note that destination project must be different from the source
	// project. So /global/addresses/address is not valid partial url.
	DestinationAddress string `json:"destinationAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GlobalAddressesMoveRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalAddressesMoveRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalNetworkEndpointGroupsAttachEndpointsRequest struct {
	// NetworkEndpoints: The list of network endpoints to be attached.
	NetworkEndpoints []*NetworkEndpoint `json:"networkEndpoints,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NetworkEndpoints") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NetworkEndpoints") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GlobalNetworkEndpointGroupsAttachEndpointsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalNetworkEndpointGroupsAttachEndpointsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalNetworkEndpointGroupsDetachEndpointsRequest struct {
	// NetworkEndpoints: The list of network endpoints to be detached.
	NetworkEndpoints []*NetworkEndpoint `json:"networkEndpoints,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NetworkEndpoints") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NetworkEndpoints") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GlobalNetworkEndpointGroupsDetachEndpointsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalNetworkEndpointGroupsDetachEndpointsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalOrganizationSetPolicyRequest struct {
	// Bindings: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify bindings.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify the etag.
	Etag string `json:"etag,omitempty"`

	// Policy: REQUIRED: The complete policy to be applied to the
	// 'resource'. The size of the policy is limited to a few 10s of KB. An
	// empty policy is in general a valid policy but certain services (like
	// Projects) might reject them.
	Policy *Policy `json:"policy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bindings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GlobalOrganizationSetPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalOrganizationSetPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalSetLabelsRequest struct {
	// LabelFingerprint: The fingerprint of the previous set of labels for
	// this resource, used to detect conflicts. The fingerprint is initially
	// generated by Compute Engine and changes after every request to modify
	// or update labels. You must always provide an up-to-date fingerprint
	// hash when updating or changing labels, otherwise the request will
	// fail with error 412 conditionNotMet. Make a get() request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: A list of labels to apply for this resource. Each label must
	// comply with the requirements for labels. For example,
	// "webserver-frontend": "images". A label value can also be empty (e.g.
	// "my-label": "").
	Labels map[string]string `json:"labels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelFingerprint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelFingerprint") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GlobalSetLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalSetLabelsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalSetPolicyRequest struct {
	// Bindings: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify bindings.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify the etag.
	Etag string `json:"etag,omitempty"`

	// Policy: REQUIRED: The complete policy to be applied to the
	// 'resource'. The size of the policy is limited to a few 10s of KB. An
	// empty policy is in general a valid policy but certain services (like
	// Projects) might reject them.
	Policy *Policy `json:"policy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bindings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GlobalSetPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalSetPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GrpcServiceConfig: [Deprecated] gRPC config to access the SDS server.
// gRPC config to access the SDS server.
type GrpcServiceConfig struct {
	// CallCredentials: The call credentials to access the SDS server.
	CallCredentials *CallCredentials `json:"callCredentials,omitempty"`

	// ChannelCredentials: The channel credentials to access the SDS server.
	ChannelCredentials *ChannelCredentials `json:"channelCredentials,omitempty"`

	// TargetUri: The target URI of the SDS server.
	TargetUri string `json:"targetUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallCredentials") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallCredentials") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GrpcServiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcServiceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestAttributes: A guest attributes entry.
type GuestAttributes struct {
	// Kind: [Output Only] Type of the resource. Always
	// compute#guestAttributes for guest attributes entry.
	Kind string `json:"kind,omitempty"`

	// QueryPath: The path to be queried. This can be the default namespace
	// ('') or a nested namespace ('\/') or a specified key ('\/\').
	QueryPath string `json:"queryPath,omitempty"`

	// QueryValue: [Output Only] The value of the requested queried path.
	QueryValue *GuestAttributesValue `json:"queryValue,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// VariableKey: The key to search for.
	VariableKey string `json:"variableKey,omitempty"`

	// VariableValue: [Output Only] The value found for the requested key.
	VariableValue string `json:"variableValue,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GuestAttributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestAttributesEntry: A guest attributes namespace/key/value entry.
type GuestAttributesEntry struct {
	// Key: Key for the guest attribute entry.
	Key string `json:"key,omitempty"`

	// Namespace: Namespace for the guest attribute entry.
	Namespace string `json:"namespace,omitempty"`

	// Value: Value for the guest attribute entry.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestAttributesEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GuestAttributesEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestAttributesValue: Array of guest attribute namespace/key/value
// tuples.
type GuestAttributesValue struct {
	Items []*GuestAttributesEntry `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestAttributesValue) MarshalJSON() ([]byte, error) {
	type NoMethod GuestAttributesValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestOsFeature: Guest OS features.
type GuestOsFeature struct {
	// Type: The ID of a supported feature. To add multiple values, use
	// commas to separate values. Set to one or more of the following
	// values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET -
	// UEFI_COMPATIBLE - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE -
	// SEV_LIVE_MIGRATABLE - SEV_SNP_CAPABLE - TDX_CAPABLE For more
	// information, see Enabling guest operating system features.
	//
	// Possible values:
	//   "BARE_METAL_LINUX_COMPATIBLE"
	//   "FEATURE_TYPE_UNSPECIFIED"
	//   "GVNIC"
	//   "MULTI_IP_SUBNET"
	//   "SECURE_BOOT"
	//   "SEV_CAPABLE"
	//   "SEV_LIVE_MIGRATABLE"
	//   "SEV_SNP_CAPABLE"
	//   "TDX_CAPABLE"
	//   "UEFI_COMPATIBLE"
	//   "VIRTIO_SCSI_MULTIQUEUE"
	//   "WINDOWS"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestOsFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GuestOsFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HTTP2HealthCheck struct {
	// Host: The value of the host header in the HTTP/2 health check
	// request. If left empty (default value), the host header is set to the
	// destination IP address to which health check packets are sent. The
	// destination IP address depends on the type of load balancer. For
	// details, see:
	// https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
	Host string `json:"host,omitempty"`

	// Port: The TCP port number to which the health check prober sends
	// packets. The default value is 443. Valid values are 1 through 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Not supported.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how a port is selected for health
	// checking. Can be one of the following values: USE_FIXED_PORT:
	// Specifies a port number explicitly using the port field in the health
	// check. Supported by backend services for pass-through load balancers
	// and backend services for proxy load balancers. Not supported by
	// target pools. The health check supports all backends supported by the
	// backend service provided the backend can be health checked. For
	// example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network
	// endpoint groups, and instance group backends. USE_NAMED_PORT: Not
	// supported. USE_SERVING_PORT: Provides an indirect method of
	// specifying the health check port by referring to the backend service.
	// Only supported by backend services for proxy load balancers. Not
	// supported by target pools. Not supported by backend services for
	// pass-through load balancers. Supports all backends that can be health
	// checked; for example, GCE_VM_IP_PORT network endpoint groups and
	// instance group backends. For GCE_VM_IP_PORT network endpoint group
	// backends, the health check uses the port number specified for each
	// endpoint in the network endpoint group. For instance group backends,
	// the health check uses the port number determined by looking up the
	// backend service's named port in the instance group's list of named
	// ports.
	//
	// Possible values:
	//   "USE_FIXED_PORT" - The port number in the health check's port is
	// used for health checking. Applies to network endpoint group and
	// instance group backends.
	//   "USE_NAMED_PORT" - Not supported.
	//   "USE_SERVING_PORT" - For network endpoint group backends, the
	// health check uses the port number specified on each endpoint in the
	// network endpoint group. For instance group backends, the health check
	// uses the port number specified for the backend service's named port
	// defined in the instance group's named ports.
	PortSpecification string `json:"portSpecification,omitempty"`

	// ProxyHeader: Specifies the type of proxy header to append before
	// sending data to the backend, either NONE or PROXY_V1. The default is
	// NONE.
	//
	// Possible values:
	//   "NONE"
	//   "PROXY_V1"
	ProxyHeader string `json:"proxyHeader,omitempty"`

	// RequestPath: The request path of the HTTP/2 health check request. The
	// default value is /.
	RequestPath string `json:"requestPath,omitempty"`

	// Response: Creates a content-based HTTP/2 health check. In addition to
	// the required HTTP 200 (OK) status code, you can configure the health
	// check to pass only when the backend sends this specific ASCII
	// response string within the first 1024 bytes of the HTTP response
	// body. For details, see:
	// https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
	Response string `json:"response,omitempty"`

	// WeightReportMode: Weight report mode. used for weighted Load
	// Balancing.
	//
	// Possible values:
	//   "DISABLE" - Health Checker will not parse the header field.
	//   "DRY_RUN" - Health Checker will parse and report the weight in the
	// header field, but load balancing will not be based on the weights and
	// will use equal weights.
	//   "ENABLE" - Health Checker will try to parse and report the weight
	// in the header field, and load balancing will be based on the weights
	// as long as all backends have a valid weight or only a subset of
	// backends has the UNAVAILABLE_WEIGHT WeightError. The latter case is
	// to continue the weighted load balancing while some backends are in
	// TIMEOUT or UNKNOWN health status.
	WeightReportMode string `json:"weightReportMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTP2HealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HTTP2HealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HTTPHealthCheck struct {
	// Host: The value of the host header in the HTTP health check request.
	// If left empty (default value), the host header is set to the
	// destination IP address to which health check packets are sent. The
	// destination IP address depends on the type of load balancer. For
	// details, see:
	// https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
	Host string `json:"host,omitempty"`

	// Port: The TCP port number to which the health check prober sends
	// packets. The default value is 80. Valid values are 1 through 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Not supported.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how a port is selected for health
	// checking. Can be one of the following values: USE_FIXED_PORT:
	// Specifies a port number explicitly using the port field in the health
	// check. Supported by backend services for pass-through load balancers
	// and backend services for proxy load balancers. Also supported in
	// legacy HTTP health checks for target pools. The health check supports
	// all backends supported by the backend service provided the backend
	// can be health checked. For example, GCE_VM_IP network endpoint
	// groups, GCE_VM_IP_PORT network endpoint groups, and instance group
	// backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides
	// an indirect method of specifying the health check port by referring
	// to the backend service. Only supported by backend services for proxy
	// load balancers. Not supported by target pools. Not supported by
	// backend services for pass-through load balancers. Supports all
	// backends that can be health checked; for example, GCE_VM_IP_PORT
	// network endpoint groups and instance group backends. For
	// GCE_VM_IP_PORT network endpoint group backends, the health check uses
	// the port number specified for each endpoint in the network endpoint
	// group. For instance group backends, the health check uses the port
	// number determined by looking up the backend service's named port in
	// the instance group's list of named ports.
	//
	// Possible values:
	//   "USE_FIXED_PORT" - The port number in the health check's port is
	// used for health checking. Applies to network endpoint group and
	// instance group backends.
	//   "USE_NAMED_PORT" - Not supported.
	//   "USE_SERVING_PORT" - For network endpoint group backends, the
	// health check uses the port number specified on each endpoint in the
	// network endpoint group. For instance group backends, the health check
	// uses the port number specified for the backend service's named port
	// defined in the instance group's named ports.
	PortSpecification string `json:"portSpecification,omitempty"`

	// ProxyHeader: Specifies the type of proxy header to append before
	// sending data to the backend, either NONE or PROXY_V1. The default is
	// NONE.
	//
	// Possible values:
	//   "NONE"
	//   "PROXY_V1"
	ProxyHeader string `json:"proxyHeader,omitempty"`

	// RequestPath: The request path of the HTTP health check request. The
	// default value is /.
	RequestPath string `json:"requestPath,omitempty"`

	// Response: Creates a content-based HTTP health check. In addition to
	// the required HTTP 200 (OK) status code, you can configure the health
	// check to pass only when the backend sends this specific ASCII
	// response string within the first 1024 bytes of the HTTP response
	// body. For details, see:
	// https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
	Response string `json:"response,omitempty"`

	// WeightReportMode: Weight report mode. used for weighted Load
	// Balancing.
	//
	// Possible values:
	//   "DISABLE" - Health Checker will not parse the header field.
	//   "DRY_RUN" - Health Checker will parse and report the weight in the
	// header field, but load balancing will not be based on the weights and
	// will use equal weights.
	//   "ENABLE" - Health Checker will try to parse and report the weight
	// in the header field, and load balancing will be based on the weights
	// as long as all backends have a valid weight or only a subset of
	// backends has the UNAVAILABLE_WEIGHT WeightError. The latter case is
	// to continue the weighted load balancing while some backends are in
	// TIMEOUT or UNKNOWN health status.
	WeightReportMode string `json:"weightReportMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HTTPSHealthCheck struct {
	// Host: The value of the host header in the HTTPS health check request.
	// If left empty (default value), the host header is set to the
	// destination IP address to which health check packets are sent. The
	// destination IP address depends on the type of load balancer. For
	// details, see:
	// https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
	Host string `json:"host,omitempty"`

	// Port: The TCP port number to which the health check prober sends
	// packets. The default value is 443. Valid values are 1 through 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Not supported.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how a port is selected for health
	// checking. Can be one of the following values: USE_FIXED_PORT:
	// Specifies a port number explicitly using the port field in the health
	// check. Supported by backend services for pass-through load balancers
	// and backend services for proxy load balancers. Not supported by
	// target pools. The health check supports all backends supported by the
	// backend service provided the backend can be health checked. For
	// example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network
	// endpoint groups, and instance group backends. USE_NAMED_PORT: Not
	// supported. USE_SERVING_PORT: Provides an indirect method of
	// specifying the health check port by referring to the backend service.
	// Only supported by backend services for proxy load balancers. Not
	// supported by target pools. Not supported by backend services for
	// pass-through load balancers. Supports all backends that can be health
	// checked; for example, GCE_VM_IP_PORT network endpoint groups and
	// instance group backends. For GCE_VM_IP_PORT network endpoint group
	// backends, the health check uses the port number specified for each
	// endpoint in the network endpoint group. For instance group backends,
	// the health check uses the port number determined by looking up the
	// backend service's named port in the instance group's list of named
	// ports.
	//
	// Possible values:
	//   "USE_FIXED_PORT" - The port number in the health check's port is
	// used for health checking. Applies to network endpoint group and
	// instance group backends.
	//   "USE_NAMED_PORT" - Not supported.
	//   "USE_SERVING_PORT" - For network endpoint group backends, the
	// health check uses the port number specified on each endpoint in the
	// network endpoint group. For instance group backends, the health check
	// uses the port number specified for the backend service's named port
	// defined in the instance group's named ports.
	PortSpecification string `json:"portSpecification,omitempty"`

	// ProxyHeader: Specifies the type of proxy header to append before
	// sending data to the backend, either NONE or PROXY_V1. The default is
	// NONE.
	//
	// Possible values:
	//   "NONE"
	//   "PROXY_V1"
	ProxyHeader string `json:"proxyHeader,omitempty"`

	// RequestPath: The request path of the HTTPS health check request. The
	// default value is /.
	RequestPath string `json:"requestPath,omitempty"`

	// Response: Creates a content-based HTTPS health check. In addition to
	// the required HTTP 200 (OK) status code, you can configure the health
	// check to pass only when the backend sends this specific ASCII
	// response string within the first 1024 bytes of the HTTP response
	// body. For details, see:
	// https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
	Response string `json:"response,omitempty"`

	// WeightReportMode: Weight report mode. used for weighted Load
	// Balancing.
	//
	// Possible values:
	//   "DISABLE" - Health Checker will not parse the header field.
	//   "DRY_RUN" - Health Checker will parse and report the weight in the
	// header field, but load balancing will not be based on the weights and
	// will use equal weights.
	//   "ENABLE" - Health Checker will try to parse and report the weight
	// in the header field, and load balancing will be based on the weights
	// as long as all backends have a valid weight or only a subset of
	// backends has the UNAVAILABLE_WEIGHT WeightError. The latter case is
	// to continue the weighted load balancing while some backends are in
	// TIMEOUT or UNKNOWN health status.
	WeightReportMode string `json:"weightReportMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPSHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPSHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheck: Represents a Health Check resource. Google Compute
// Engine has two Health Check resources: * Global
// (/compute/docs/reference/rest/alpha/healthChecks) * Regional
// (/compute/docs/reference/rest/alpha/regionHealthChecks) Internal
// HTTP(S) load balancers must use regional health checks
// (`compute.v1.regionHealthChecks`). Traffic Director must use global
// health checks (`compute.v1.healthChecks`). Internal TCP/UDP load
// balancers can use either regional or global health checks
// (`compute.v1.regionHealthChecks` or `compute.v1.healthChecks`).
// External HTTP(S), TCP proxy, and SSL proxy load balancers as well as
// managed instance group auto-healing must use global health checks
// (`compute.v1.healthChecks`). Backend service-based network load
// balancers must use regional health checks
// (`compute.v1.regionHealthChecks`). Target pool-based network load
// balancers must use legacy HTTP health checks
// (`compute.v1.httpHealthChecks`). For more information, see Health
// checks overview.
type HealthCheck struct {
	// CheckIntervalSec: How often (in seconds) to send a health check. The
	// default value is 5 seconds.
	CheckIntervalSec int64 `json:"checkIntervalSec,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in 3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	GrpcHealthCheck *GRPCHealthCheck `json:"grpcHealthCheck,omitempty"`

	// HealthyThreshold: A so-far unhealthy instance will be marked healthy
	// after this many consecutive successes. The default value is 2.
	HealthyThreshold int64 `json:"healthyThreshold,omitempty"`

	Http2HealthCheck *HTTP2HealthCheck `json:"http2HealthCheck,omitempty"`

	HttpHealthCheck *HTTPHealthCheck `json:"httpHealthCheck,omitempty"`

	HttpsHealthCheck *HTTPSHealthCheck `json:"httpsHealthCheck,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: Type of the resource.
	Kind string `json:"kind,omitempty"`

	// LogConfig: Configure logging on this health check.
	LogConfig *HealthCheckLogConfig `json:"logConfig,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. For example, a name that is 1-63 characters long, matches
	// the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise
	// complies with RFC1035. This regular expression describes a name where
	// the first character is a lowercase letter, and all following
	// characters are a dash, lowercase letter, or digit, except the last
	// character, which isn't a dash.
	Name string `json:"name,omitempty"`

	// Region: [Output Only] Region where the health check resides. Not
	// applicable to global health checks.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SourceRegions: The list of cloud regions from which health checks are
	// performed. If any regions are specified, then exactly 3 regions
	// should be specified. The region names must be valid names of GCP
	// regions. This can only be set for global health check. If this list
	// is non-empty, then there are restrictions on what other health check
	// fields are supported and what other resources can use this health
	// check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP
	// request field is not supported. - The proxyHeader field for HTTP,
	// HTTPS, and TCP is not supported. - The checkIntervalSec field must be
	// at least 30. - The health check cannot be used with BackendService
	// nor with managed instance group auto-healing.
	SourceRegions []string `json:"sourceRegions,omitempty"`

	SslHealthCheck *SSLHealthCheck `json:"sslHealthCheck,omitempty"`

	TcpHealthCheck *TCPHealthCheck `json:"tcpHealthCheck,omitempty"`

	// TimeoutSec: How long (in seconds) to wait before claiming failure.
	// The default value is 5 seconds. It is invalid for timeoutSec to have
	// greater value than checkIntervalSec.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// Type: Specifies the type of the healthCheck, either TCP, SSL, HTTP,
	// HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health
	// check fields must be specified, which must match type field.
	//
	// Possible values:
	//   "GRPC"
	//   "HTTP"
	//   "HTTP2"
	//   "HTTPS"
	//   "INVALID"
	//   "SSL"
	//   "TCP"
	//   "UDP"
	Type string `json:"type,omitempty"`

	UdpHealthCheck *UDPHealthCheck `json:"udpHealthCheck,omitempty"`

	// UnhealthyThreshold: A so-far healthy instance will be marked
	// unhealthy after this many consecutive failures. The default value is
	// 2.
	UnhealthyThreshold int64 `json:"unhealthyThreshold,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CheckIntervalSec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CheckIntervalSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckList: Contains a list of HealthCheck resources.
type HealthCheckList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthCheck resources.
	Items []*HealthCheck `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthCheckListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckListWarning: [Output Only] Informational warning message.
type HealthCheckListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HealthCheckListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckLogConfig: Configuration of logging on a health check. If
// logging is enabled, logs will be exported to Stackdriver.
type HealthCheckLogConfig struct {
	// Enable: Indicates whether or not to export logs. This is false by
	// default, which means no health check logging will be done.
	Enable bool `json:"enable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckReference: A full or valid partial URL to a health check.
// For example, the following are valid URLs: -
// https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check
// - projects/project-id/global/httpHealthChecks/health-check -
// global/httpHealthChecks/health-check
type HealthCheckReference struct {
	HealthCheck string `json:"healthCheck,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HealthCheck") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HealthCheck") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckReference) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckService: Represents a Health-Check as a Service resource.
type HealthCheckService struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Fingerprint: Fingerprint of this resource. A hash of the contents
	// stored in this object. This field is used in optimistic locking. This
	// field will be ignored when inserting a HealthCheckService. An
	// up-to-date fingerprint must be provided in order to patch/update the
	// HealthCheckService; Otherwise, the request will fail with error 412
	// conditionNotMet. To see the latest fingerprint, make a get() request
	// to retrieve the HealthCheckService.
	Fingerprint string `json:"fingerprint,omitempty"`

	// HealthChecks: A list of URLs to the HealthCheck resources. Must have
	// at least one HealthCheck, and not more than 10 for regional
	// HealthCheckService, and not more than 1 for global
	// HealthCheckService. HealthCheck resources must have
	// portSpecification=USE_SERVING_PORT or
	// portSpecification=USE_FIXED_PORT. For regional HealthCheckService,
	// the HealthCheck must be regional and in the same region. For global
	// HealthCheckService, HealthCheck must be global. Mix of regional and
	// global HealthChecks is not supported. Multiple regional HealthChecks
	// must belong to the same region. Regional HealthChecks must belong to
	// the same region as zones of NetworkEndpointGroups. For global
	// HealthCheckService using global INTERNET_IP_PORT
	// NetworkEndpointGroups, the global HealthChecks must specify
	// sourceRegions, and HealthChecks that specify sourceRegions can only
	// be used with global INTERNET_IP_PORT NetworkEndpointGroups.
	HealthChecks []string `json:"healthChecks,omitempty"`

	// HealthStatusAggregationPolicy: Optional. Policy for how the results
	// from multiple health checks for the same endpoint are aggregated.
	// Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An
	// EndpointHealth message is returned for each pair in the health check
	// service. - AND. If any health check of an endpoint reports UNHEALTHY,
	// then UNHEALTHY is the HealthState of the endpoint. If all health
	// checks report HEALTHY, the HealthState of the endpoint is HEALTHY. .
	// This is only allowed with regional HealthCheckService.
	//
	// Possible values:
	//   "AND" - If any backend's health check reports UNHEALTHY, then
	// UNHEALTHY is the HealthState of the entire health check service. If
	// all backend's are healthy, the HealthState of the health check
	// service is HEALTHY.
	//   "NO_AGGREGATION" - An EndpointHealth message is returned for each
	// backend in the health check service.
	HealthStatusAggregationPolicy string `json:"healthStatusAggregationPolicy,omitempty"`

	// HealthStatusAggregationStrategy: This field is deprecated. Use
	// health_status_aggregation_policy instead. Policy for how the results
	// from multiple health checks for the same endpoint are aggregated. -
	// NO_AGGREGATION. An EndpointHealth message is returned for each
	// backend in the health check service. - AND. If any backend's health
	// check reports UNHEALTHY, then UNHEALTHY is the HealthState of the
	// entire health check service. If all backend's are healthy, the
	// HealthState of the health check service is HEALTHY. .
	//
	// Possible values:
	//   "AND" - This is deprecated. Use health_status_aggregation_policy
	// instead. If any backend's health check reports UNHEALTHY, then
	// UNHEALTHY is the HealthState of the entire health check service. If
	// all backend's are healthy, the HealthState of the health check
	// service is HEALTHY.
	//   "NO_AGGREGATION" - This is deprecated. Use
	// health_status_aggregation_policy instead. An EndpointHealth message
	// is returned for each backend in the health check service.
	HealthStatusAggregationStrategy string `json:"healthStatusAggregationStrategy,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output only] Type of the resource. Always
	// compute#healthCheckServicefor health check services.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. The name must be 1-63 characters long,
	// and comply with RFC1035. Specifically, the name must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	Name string `json:"name,omitempty"`

	// NetworkEndpointGroups: A list of URLs to the NetworkEndpointGroup
	// resources. Must not have more than 100. For regional
	// HealthCheckService, NEGs must be in zones in the region of the
	// HealthCheckService. For global HealthCheckServices, the
	// NetworkEndpointGroups must be global INTERNET_IP_PORT.
	NetworkEndpointGroups []string `json:"networkEndpointGroups,omitempty"`

	// NotificationEndpoints: A list of URLs to the NotificationEndpoint
	// resources. Must not have more than 10. A list of endpoints for
	// receiving notifications of change in health status. For regional
	// HealthCheckService, NotificationEndpoint must be regional and in the
	// same region. For global HealthCheckService, NotificationEndpoint must
	// be global.
	NotificationEndpoints []string `json:"notificationEndpoints,omitempty"`

	// Region: [Output Only] URL of the region where the health check
	// service resides. This field is not applicable to global health check
	// services. You must specify this field as part of the HTTP request
	// URL. It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL with id for the
	// resource.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckService) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServiceAggregatedList: Contains a list of
// HealthCheckServicesScopedList.
type HealthCheckServiceAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthCheckServicesScopedList resources.
	Items map[string]HealthCheckServicesScopedList `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthCheckServiceAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServiceAggregatedListWarning: [Output Only] Informational
// warning message.
type HealthCheckServiceAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HealthCheckServiceAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServiceAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServiceReference: A full or valid partial URL to a health
// check service. For example, the following are valid URLs: -
// https://www.googleapis.com/compute/beta/projects/project-id/regions/us-west1/healthCheckServices/health-check-service
// -
// projects/project-id/regions/us-west1/healthCheckServices/health-check-
// service - regions/us-west1/healthCheckServices/health-check-service
type HealthCheckServiceReference struct {
	HealthCheckService string `json:"healthCheckService,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HealthCheckService")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HealthCheckService") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceReference) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthCheckService resources.
	Items []*HealthCheckService `json:"items,omitempty"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#healthCheckServicesList for lists of HealthCheckServices.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthCheckServicesListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServicesListWarning: [Output Only] Informational warning
// message.
type HealthCheckServicesListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HealthCheckServicesListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesScopedList struct {
	// Resources: A list of HealthCheckServices contained in this scope.
	Resources []*HealthCheckService `json:"resources,omitempty"`

	// Warning: Informational warning which replaces the list of backend
	// services when the list is empty.
	Warning *HealthCheckServicesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Resources") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServicesScopedListWarning: Informational warning which
// replaces the list of backend services when the list is empty.
type HealthCheckServicesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HealthCheckServicesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthChecksScopedList resources.
	Items map[string]HealthChecksScopedList `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthChecksAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthChecksAggregatedListWarning: [Output Only] Informational
// warning message.
type HealthChecksAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HealthChecksAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksScopedList struct {
	// HealthChecks: A list of HealthChecks contained in this scope.
	HealthChecks []*HealthCheck `json:"healthChecks,omitempty"`

	// Warning: Informational warning which replaces the list of backend
	// services when the list is empty.
	Warning *HealthChecksScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HealthChecks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HealthChecks") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthChecksScopedListWarning: Informational warning which replaces
// the list of backend services when the list is empty.
type HealthChecksScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HealthChecksScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthStatus struct {
	// Annotations: Metadata defined as annotations for network endpoint.
	Annotations map[string]string `json:"annotations,omitempty"`

	// ForwardingRule: URL of the forwarding rule associated with the health
	// status of the instance.
	ForwardingRule string `json:"forwardingRule,omitempty"`

	// ForwardingRuleIp: A forwarding rule IP address assigned to this
	// instance.
	ForwardingRuleIp string `json:"forwardingRuleIp,omitempty"`

	// HealthState: Health state of the IPv4 address of the instance.
	//
	// Possible values:
	//   "HEALTHY"
	//   "UNHEALTHY"
	HealthState string `json:"healthState,omitempty"`

	// Instance: URL of the instance resource.
	Instance string `json:"instance,omitempty"`

	// IpAddress: For target pool based Network Load Balancing, it indicates
	// the forwarding rule's IP address assigned to this instance. For other
	// types of load balancing, the field indicates VM internal ip.
	IpAddress string `json:"ipAddress,omitempty"`

	// Port: The named port of the instance group, not necessarily the port
	// that is health-checked.
	Port int64 `json:"port,omitempty"`

	Weight string `json:"weight,omitempty"`

	// Possible values:
	//   "INVALID_WEIGHT" - The response to a Health Check probe had the
	// HTTP response header field X-Load-Balancing-Endpoint-Weight, but its
	// content was invalid (i.e., not a non-negative single-precision
	// floating-point number in decimal string representation).
	//   "MISSING_WEIGHT" - The response to a Health Check probe did not
	// have the HTTP response header field X-Load-Balancing-Endpoint-Weight.
	//   "UNAVAILABLE_WEIGHT" - This is the value when the accompanied
	// health status is either TIMEOUT (i.e.,the Health Check probe was not
	// able to get a response in time) or UNKNOWN. For the latter, it should
	// be typically because there has not been sufficient time to parse and
	// report the weight for a new backend (which is with 0.0.0.0 ip
	// address). However, it can be also due to an outage case for which the
	// health status is explicitly reset to UNKNOWN.
	//   "WEIGHT_NONE" - This is the default value when WeightReportMode is
	// DISABLE, and is also the initial value when WeightReportMode has just
	// updated to ENABLE or DRY_RUN and there has not been sufficient time
	// to parse and report the backend weight.
	WeightError string `json:"weightError,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthStatus) MarshalJSON() ([]byte, error) {
	type NoMethod HealthStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthStatusForNetworkEndpoint struct {
	// BackendService: URL of the backend service associated with the health
	// state of the network endpoint.
	BackendService *BackendServiceReference `json:"backendService,omitempty"`

	// ForwardingRule: URL of the forwarding rule associated with the health
	// state of the network endpoint.
	ForwardingRule *ForwardingRuleReference `json:"forwardingRule,omitempty"`

	// HealthCheck: URL of the health check associated with the health state
	// of the network endpoint.
	HealthCheck *HealthCheckReference `json:"healthCheck,omitempty"`

	// HealthCheckService: URL of the health check service associated with
	// the health state of the network endpoint.
	HealthCheckService *HealthCheckServiceReference `json:"healthCheckService,omitempty"`

	// HealthState: Health state of the network endpoint determined based on
	// the health checks configured.
	//
	// Possible values:
	//   "DRAINING" - Endpoint is being drained.
	//   "HEALTHY" - Endpoint is healthy.
	//   "UNHEALTHY" - Endpoint is unhealthy.
	//   "UNKNOWN" - Health status of the endpoint is unknown.
	HealthState string `json:"healthState,omitempty"`

	// Ipv6HealthState: Health state of the ipv6 network endpoint determined
	// based on the health checks configured.
	//
	// Possible values:
	//   "DRAINING" - Endpoint is being drained.
	//   "HEALTHY" - Endpoint is healthy.
	//   "UNHEALTHY" - Endpoint is unhealthy.
	//   "UNKNOWN" - Health status of the endpoint is unknown.
	Ipv6HealthState string `json:"ipv6HealthState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackendService") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackendService") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthStatusForNetworkEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod HealthStatusForNetworkEndpoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Help: Provides links to documentation or for performing an out of
// band action. For example, if a quota check failed with an error
// indicating the calling project hasn't enabled the accessed service,
// this can contain a URL pointing directly to the right place in the
// developer console to flip the bit.
type Help struct {
	// Links: URL(s) pointing to additional information on handling the
	// current error.
	Links []*HelpLink `json:"links,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Links") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Links") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Help) MarshalJSON() ([]byte, error) {
	type NoMethod Help
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HelpLink: Describes a URL link.
type HelpLink struct {
	// Description: Describes what the link offers.
	Description string `json:"description,omitempty"`

	// Url: The URL of the link.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HelpLink) MarshalJSON() ([]byte, error) {
	type NoMethod HelpLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HostRule: UrlMaps A host-matching rule for a URL. If matched, will
// use the named PathMatcher to select the BackendService.
type HostRule struct {
	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Hosts: The list of host patterns to match. They must be valid
	// hostnames with optional port numbers in the format host:port. *
	// matches any string of ([a-z0-9-.]*). In that case, * must be the
	// first character, and if followed by anything, the immediate following
	// character must be either - or .. * based matching is not supported
	// when the URL map is bound to a target gRPC proxy that has the
	// validateForProxyless field set to true.
	Hosts []string `json:"hosts,omitempty"`

	// PathMatcher: The name of the PathMatcher to use to match the path
	// portion of the URL if the hostRule matches the URL's host portion.
	PathMatcher string `json:"pathMatcher,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HostRule) MarshalJSON() ([]byte, error) {
	type NoMethod HostRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpFaultAbort: Specification for how requests are aborted as part of
// fault injection.
type HttpFaultAbort struct {
	// HttpStatus: The HTTP status code used to abort the request. The value
	// must be from 200 to 599 inclusive. For gRPC protocol, the gRPC status
	// code is mapped to HTTP status code according to this mapping table.
	// HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK
	// status is currently not supported by Traffic Director.
	HttpStatus int64 `json:"httpStatus,omitempty"`

	// Percentage: The percentage of traffic for connections, operations, or
	// requests that is aborted as part of fault injection. The value must
	// be from 0.0 to 100.0 inclusive.
	Percentage float64 `json:"percentage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HttpStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpStatus") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFaultAbort) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFaultAbort
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *HttpFaultAbort) UnmarshalJSON(data []byte) error {
	type NoMethod HttpFaultAbort
	var s1 struct {
		Percentage gensupport.JSONFloat64 `json:"percentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Percentage = float64(s1.Percentage)
	return nil
}

// HttpFaultDelay: Specifies the delay introduced by the load balancer
// before forwarding the request to the backend service as part of fault
// injection.
type HttpFaultDelay struct {
	// FixedDelay: Specifies the value of the fixed delay interval.
	FixedDelay *Duration `json:"fixedDelay,omitempty"`

	// Percentage: The percentage of traffic for connections, operations, or
	// requests for which a delay is introduced as part of fault injection.
	// The value must be from 0.0 to 100.0 inclusive.
	Percentage float64 `json:"percentage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FixedDelay") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FixedDelay") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFaultDelay) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFaultDelay
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *HttpFaultDelay) UnmarshalJSON(data []byte) error {
	type NoMethod HttpFaultDelay
	var s1 struct {
		Percentage gensupport.JSONFloat64 `json:"percentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Percentage = float64(s1.Percentage)
	return nil
}

// HttpFaultInjection: The specification for fault injection introduced
// into traffic to test the resiliency of clients to backend service
// failure. As part of fault injection, when clients send requests to a
// backend service, delays can be introduced by the load balancer on a
// percentage of requests before sending those request to the backend
// service. Similarly requests from clients can be aborted by the load
// balancer for a percentage of requests.
type HttpFaultInjection struct {
	// Abort: The specification for how client requests are aborted as part
	// of fault injection.
	Abort *HttpFaultAbort `json:"abort,omitempty"`

	// Delay: The specification for how client requests are delayed as part
	// of fault injection, before being sent to a backend service.
	Delay *HttpFaultDelay `json:"delay,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Abort") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Abort") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFaultInjection) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFaultInjection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpFilterConfig: HttpFilterConfiguration supplies additional
// contextual settings for networkservices.HttpFilter resources enabled
// by Traffic Director.
type HttpFilterConfig struct {
	// Config: The configuration needed to enable the
	// networkservices.HttpFilter resource. The configuration must be YAML
	// formatted and only contain fields defined in the protobuf identified
	// in configTypeUrl
	Config string `json:"config,omitempty"`

	// ConfigTypeUrl: The fully qualified versioned proto3 type url of the
	// protobuf that the filter expects for its contextual settings, for
	// example: type.googleapis.com/google.protobuf.Struct
	ConfigTypeUrl string `json:"configTypeUrl,omitempty"`

	// FilterName: Name of the networkservices.HttpFilter resource this
	// configuration belongs to. This name must be known to the xDS client.
	// Example: envoy.wasm
	FilterName string `json:"filterName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFilterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFilterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHeaderAction: The request and response header transformations
// that take effect before the request is passed along to the selected
// backendService.
type HttpHeaderAction struct {
	// RequestHeadersToAdd: Headers to add to a matching request before
	// forwarding the request to the backendService.
	RequestHeadersToAdd []*HttpHeaderOption `json:"requestHeadersToAdd,omitempty"`

	// RequestHeadersToRemove: A list of header names for headers that need
	// to be removed from the request before forwarding the request to the
	// backendService.
	RequestHeadersToRemove []string `json:"requestHeadersToRemove,omitempty"`

	// ResponseHeadersToAdd: Headers to add the response before sending the
	// response back to the client.
	ResponseHeadersToAdd []*HttpHeaderOption `json:"responseHeadersToAdd,omitempty"`

	// ResponseHeadersToRemove: A list of header names for headers that need
	// to be removed from the response before sending the response back to
	// the client.
	ResponseHeadersToRemove []string `json:"responseHeadersToRemove,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestHeadersToAdd")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestHeadersToAdd") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HttpHeaderAction) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHeaderAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHeaderMatch: matchRule criteria for request header matches.
type HttpHeaderMatch struct {
	// ExactMatch: The value should exactly match contents of exactMatch.
	// Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	ExactMatch string `json:"exactMatch,omitempty"`

	// HeaderName: The name of the HTTP header to match. For matching
	// against the HTTP request's authority, use a headerMatch with the
	// header name ":authority". For matching a request's method, use the
	// headerName ":method". When the URL map is bound to a target gRPC
	// proxy that has the validateForProxyless field set to true, only
	// non-binary user-specified custom metadata and the `content-type`
	// header are supported. The following transport-level headers cannot be
	// used in header matching rules: `:authority`, `:method`, `:path`,
	// `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`,
	// `grpc-accept-encoding`, `grpc-encoding`,
	// `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and
	// `grpc-trace-bin`.
	HeaderName string `json:"headerName,omitempty"`

	// InvertMatch: If set to false, the headerMatch is considered a match
	// if the preceding match criteria are met. If set to true, the
	// headerMatch is considered a match if the preceding match criteria are
	// NOT met. The default setting is false.
	InvertMatch bool `json:"invertMatch,omitempty"`

	// PrefixMatch: The value of the header must start with the contents of
	// prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch,
	// regexMatch, presentMatch or rangeMatch must be set.
	PrefixMatch string `json:"prefixMatch,omitempty"`

	// PresentMatch: A header with the contents of headerName must exist.
	// The match takes place whether or not the request's header has a
	// value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	PresentMatch bool `json:"presentMatch,omitempty"`

	// RangeMatch: The header value must be an integer and its value must be
	// in the range specified in rangeMatch. If the header does not contain
	// an integer, number or is empty, the match fails. For example for a
	// range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not
	// match. - -3someString will not match. Only one of exactMatch,
	// prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must
	// be set. rangeMatch is not supported for load balancers that have
	// loadBalancingScheme set to EXTERNAL.
	RangeMatch *Int64RangeMatch `json:"rangeMatch,omitempty"`

	// RegexMatch: The value of the header must match the regular expression
	// specified in regexMatch. For more information about regular
	// expression syntax, see Syntax. For matching against a port specified
	// in the HTTP request, use a headerMatch with headerName set to PORT
	// and a regular expression that satisfies the RFC2616 Host header's
	// port specifier. Only one of exactMatch, prefixMatch, suffixMatch,
	// regexMatch, presentMatch or rangeMatch must be set. Regular
	// expressions can only be used when the loadBalancingScheme is set to
	// INTERNAL_SELF_MANAGED.
	RegexMatch string `json:"regexMatch,omitempty"`

	// SuffixMatch: The value of the header must end with the contents of
	// suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch,
	// regexMatch, presentMatch or rangeMatch must be set.
	SuffixMatch string `json:"suffixMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHeaderMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHeaderMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHeaderOption: Specification determining how headers are added to
// requests or responses.
type HttpHeaderOption struct {
	// HeaderName: The name of the header.
	HeaderName string `json:"headerName,omitempty"`

	// HeaderValue: The value of the header to add.
	HeaderValue string `json:"headerValue,omitempty"`

	// Replace: If false, headerValue is appended to any values that already
	// exist for the header. If true, headerValue is set for the header,
	// discarding any values that were set for that header. The default
	// value is false.
	Replace bool `json:"replace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HeaderName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HeaderName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHeaderOption) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHeaderOption
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHealthCheck: Represents a legacy HTTP Health Check resource.
// Legacy HTTP health checks are now only required by target pool-based
// network load balancers. For all other load balancers, including
// backend service-based network load balancers, and for managed
// instance group auto-healing, you must use modern (non-legacy) health
// checks. For more information, see Health checks overview .
type HttpHealthCheck struct {
	// CheckIntervalSec: How often (in seconds) to send a health check. The
	// default value is 5 seconds.
	CheckIntervalSec int64 `json:"checkIntervalSec,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// HealthyThreshold: A so-far unhealthy instance will be marked healthy
	// after this many consecutive successes. The default value is 2.
	HealthyThreshold int64 `json:"healthyThreshold,omitempty"`

	// Host: The value of the host header in the HTTP health check request.
	// If left empty (default value), the public IP on behalf of which this
	// health check is performed will be used.
	Host string `json:"host,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#httpHealthCheck for HTTP health checks.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Port: The TCP port number for the HTTP health check request. The
	// default value is 80.
	Port int64 `json:"port,omitempty"`

	// RequestPath: The request path of the HTTP health check request. The
	// default value is /. This field does not support query parameters.
	// Must comply with RFC3986.
	RequestPath string `json:"requestPath,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// TimeoutSec: How long (in seconds) to wait before claiming failure.
	// The default value is 5 seconds. It is invalid for timeoutSec to have
	// greater value than checkIntervalSec.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// UnhealthyThreshold: A so-far healthy instance will be marked
	// unhealthy after this many consecutive failures. The default value is
	// 2.
	UnhealthyThreshold int64 `json:"unhealthyThreshold,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CheckIntervalSec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CheckIntervalSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHealthCheckList: Contains a list of HttpHealthCheck resources.
type HttpHealthCheckList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HttpHealthCheck resources.
	Items []*HttpHealthCheck `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HttpHealthCheckListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheckList) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheckList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHealthCheckListWarning: [Output Only] Informational warning
// message.
type HttpHealthCheckListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HttpHealthCheckListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheckListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheckListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HttpHealthCheckListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheckListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheckListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpQueryParameterMatch: HttpRouteRuleMatch criteria for a request's
// query parameter.
type HttpQueryParameterMatch struct {
	// ExactMatch: The queryParameterMatch matches if the value of the
	// parameter exactly matches the contents of exactMatch. Only one of
	// presentMatch, exactMatch, or regexMatch must be set.
	ExactMatch string `json:"exactMatch,omitempty"`

	// Name: The name of the query parameter to match. The query parameter
	// must exist in the request, in the absence of which the request match
	// fails.
	Name string `json:"name,omitempty"`

	// PresentMatch: Specifies that the queryParameterMatch matches if the
	// request contains the query parameter, irrespective of whether the
	// parameter has a value or not. Only one of presentMatch, exactMatch,
	// or regexMatch must be set.
	PresentMatch bool `json:"presentMatch,omitempty"`

	// RegexMatch: The queryParameterMatch matches if the value of the
	// parameter matches the regular expression specified by regexMatch. For
	// more information about regular expression syntax, see Syntax. Only
	// one of presentMatch, exactMatch, or regexMatch must be set. Regular
	// expressions can only be used when the loadBalancingScheme is set to
	// INTERNAL_SELF_MANAGED.
	RegexMatch string `json:"regexMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpQueryParameterMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpQueryParameterMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRedirectAction: Specifies settings for an HTTP redirect.
type HttpRedirectAction struct {
	// HostRedirect: The host that is used in the redirect response instead
	// of the one that was supplied in the request. The value must be from 1
	// to 255 characters.
	HostRedirect string `json:"hostRedirect,omitempty"`

	// HttpsRedirect: If set to true, the URL scheme in the redirected
	// request is set to HTTPS. If set to false, the URL scheme of the
	// redirected request remains the same as that of the request. This must
	// only be set for URL maps used in TargetHttpProxys. Setting this true
	// for TargetHttpsProxy is not permitted. The default is set to false.
	HttpsRedirect bool `json:"httpsRedirect,omitempty"`

	// PathRedirect: The path that is used in the redirect response instead
	// of the one that was supplied in the request. pathRedirect cannot be
	// supplied together with prefixRedirect. Supply one alone or neither.
	// If neither is supplied, the path of the original request is used for
	// the redirect. The value must be from 1 to 1024 characters.
	PathRedirect string `json:"pathRedirect,omitempty"`

	// PrefixRedirect: The prefix that replaces the prefixMatch specified in
	// the HttpRouteRuleMatch, retaining the remaining portion of the URL
	// before redirecting the request. prefixRedirect cannot be supplied
	// together with pathRedirect. Supply one alone or neither. If neither
	// is supplied, the path of the original request is used for the
	// redirect. The value must be from 1 to 1024 characters.
	PrefixRedirect string `json:"prefixRedirect,omitempty"`

	// RedirectResponseCode: The HTTP Status code to use for this
	// RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT,
	// which is the default value and corresponds to 301. - FOUND, which
	// corresponds to 302. - SEE_OTHER which corresponds to 303. -
	// TEMPORARY_REDIRECT, which corresponds to 307. In this case, the
	// request method is retained. - PERMANENT_REDIRECT, which corresponds
	// to 308. In this case, the request method is retained.
	//
	// Possible values:
	//   "FOUND" - Http Status Code 302 - Found.
	//   "MOVED_PERMANENTLY_DEFAULT" - Http Status Code 301 - Moved
	// Permanently.
	//   "PERMANENT_REDIRECT" - Http Status Code 308 - Permanent Redirect
	// maintaining HTTP method.
	//   "SEE_OTHER" - Http Status Code 303 - See Other.
	//   "TEMPORARY_REDIRECT" - Http Status Code 307 - Temporary Redirect
	// maintaining HTTP method.
	RedirectResponseCode string `json:"redirectResponseCode,omitempty"`

	// StripQuery: If set to true, any accompanying query portion of the
	// original URL is removed before redirecting the request. If set to
	// false, the query portion of the original URL is retained. The default
	// is set to false.
	StripQuery bool `json:"stripQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HostRedirect") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HostRedirect") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRedirectAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRetryPolicy: The retry policy associates with HttpRouteRule
type HttpRetryPolicy struct {
	// NumRetries: Specifies the allowed number retries. This number must be
	// > 0. If not specified, defaults to 1.
	NumRetries int64 `json:"numRetries,omitempty"`

	// PerTryTimeout: Specifies a non-zero timeout per retry attempt. If not
	// specified, will use the timeout set in the HttpRouteAction field. If
	// timeout in the HttpRouteAction field is not set, this field uses the
	// largest timeout among all backend services associated with the route.
	// Not supported when the URL map is bound to a target gRPC proxy that
	// has the validateForProxyless field set to true.
	PerTryTimeout *Duration `json:"perTryTimeout,omitempty"`

	// RetryConditions: Specifies one or more conditions when this retry
	// policy applies. Valid values are: - 5xx: retry is attempted if the
	// instance or endpoint responds with any 5xx response code, or if the
	// instance or endpoint does not respond at all. For example,
	// disconnects, reset, read timeout, connection failure, and refused
	// streams. - gateway-error: Similar to 5xx, but only applies to
	// response codes 502, 503 or 504. - connect-failure: a retry is
	// attempted on failures connecting to the instance or endpoint. For
	// example, connection timeouts. - retriable-4xx: a retry is attempted
	// if the instance or endpoint responds with a 4xx response code. The
	// only error that you can retry is error code 409. - refused-stream: a
	// retry is attempted if the instance or endpoint resets the stream with
	// a REFUSED_STREAM error code. This reset type indicates that it is
	// safe to retry. - cancelled: a retry is attempted if the gRPC status
	// code in the response header is set to cancelled. - deadline-exceeded:
	// a retry is attempted if the gRPC status code in the response header
	// is set to deadline-exceeded. - internal: a retry is attempted if the
	// gRPC status code in the response header is set to internal. -
	// resource-exhausted: a retry is attempted if the gRPC status code in
	// the response header is set to resource-exhausted. - unavailable: a
	// retry is attempted if the gRPC status code in the response header is
	// set to unavailable. Only the following codes are supported when the
	// URL map is bound to target gRPC proxy that has validateForProxyless
	// field set to true. - cancelled - deadline-exceeded - internal -
	// resource-exhausted - unavailable
	RetryConditions []string `json:"retryConditions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NumRetries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NumRetries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRetryPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRetryPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HttpRouteAction struct {
	// CorsPolicy: The specification for allowing client-side cross-origin
	// requests. For more information about the W3C recommendation for
	// cross-origin resource sharing (CORS), see Fetch API Living Standard.
	// Not supported when the URL map is bound to a target gRPC proxy.
	CorsPolicy *CorsPolicy `json:"corsPolicy,omitempty"`

	// FaultInjectionPolicy: The specification for fault injection
	// introduced into traffic to test the resiliency of clients to backend
	// service failure. As part of fault injection, when clients send
	// requests to a backend service, delays can be introduced by a load
	// balancer on a percentage of requests before sending those requests to
	// the backend service. Similarly requests from clients can be aborted
	// by the load balancer for a percentage of requests. timeout and
	// retry_policy is ignored by clients that are configured with a
	// fault_injection_policy if: 1. The traffic is generated by fault
	// injection AND 2. The fault injection is not a delay fault injection.
	// Fault injection is not supported with the global external HTTP(S)
	// load balancer (classic). To see which load balancers support fault
	// injection, see Load balancing: Routing and traffic management
	// features.
	FaultInjectionPolicy *HttpFaultInjection `json:"faultInjectionPolicy,omitempty"`

	// MaxStreamDuration: Specifies the maximum duration (timeout) for
	// streams on the selected route. Unlike the timeout field where the
	// timeout duration starts from the time the request has been fully
	// processed (known as *end-of-stream*), the duration in this field is
	// computed from the beginning of the stream until the response has been
	// processed, including all retries. A stream that does not complete in
	// this duration is closed. If not specified, this field uses the
	// maximum maxStreamDuration value among all backend services associated
	// with the route. This field is only allowed if the Url map is used
	// with backend services with loadBalancingScheme set to
	// INTERNAL_SELF_MANAGED.
	MaxStreamDuration *Duration `json:"maxStreamDuration,omitempty"`

	// RequestMirrorPolicy: Specifies the policy on how requests intended
	// for the route's backends are shadowed to a separate mirrored backend
	// service. The load balancer does not wait for responses from the
	// shadow service. Before sending traffic to the shadow service, the
	// host / authority header is suffixed with -shadow. Not supported when
	// the URL map is bound to a target gRPC proxy that has the
	// validateForProxyless field set to true.
	RequestMirrorPolicy *RequestMirrorPolicy `json:"requestMirrorPolicy,omitempty"`

	// RetryPolicy: Specifies the retry policy associated with this route.
	RetryPolicy *HttpRetryPolicy `json:"retryPolicy,omitempty"`

	// Timeout: Specifies the timeout for the selected route. Timeout is
	// computed from the time the request has been fully processed (known as
	// *end-of-stream*) up until the response has been processed. Timeout
	// includes all retries. If not specified, this field uses the largest
	// timeout among all backend services associated with the route. Not
	// supported when the URL map is bound to a target gRPC proxy that has
	// validateForProxyless field set to true.
	Timeout *Duration `json:"timeout,omitempty"`

	// UrlRewrite: The spec to modify the URL of the request, before
	// forwarding the request to the matched service. urlRewrite is the only
	// action supported in UrlMaps for external HTTP(S) load balancers. Not
	// supported when the URL map is bound to a target gRPC proxy that has
	// the validateForProxyless field set to true.
	UrlRewrite *UrlRewrite `json:"urlRewrite,omitempty"`

	// WeightedBackendServices: A list of weighted backend services to send
	// traffic to when a route match occurs. The weights determine the
	// fraction of traffic that flows to their corresponding backend
	// service. If all traffic needs to go to a single backend service,
	// there must be one weightedBackendService with weight set to a
	// non-zero number. After a backend service is identified and before
	// forwarding the request to the backend service, advanced routing
	// actions such as URL rewrites and header transformations are applied
	// depending on additional settings specified in this HttpRouteAction.
	WeightedBackendServices []*WeightedBackendService `json:"weightedBackendServices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CorsPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CorsPolicy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRouteAction) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRouteRule: The HttpRouteRule setting specifies how to match an
// HTTP request and the corresponding routing action that load balancing
// proxies perform.
type HttpRouteRule struct {
	// CustomErrorResponsePolicy: customErrorResponsePolicy specifies how
	// the Load Balancer returns error responses when BackendServiceor
	// BackendBucket responds with an error. If a policy for an error code
	// is not configured for the RouteRule, a policy for the error code
	// configured in pathMatcher.defaultCustomErrorResponsePolicy is
	// applied. If one is not specified in
	// pathMatcher.defaultCustomErrorResponsePolicy, the policy configured
	// in UrlMap.defaultCustomErrorResponsePolicy takes effect. For example,
	// consider a UrlMap with the following configuration: -
	// UrlMap.defaultCustomErrorResponsePolicy are configured with policies
	// for 5xx and 4xx errors - A RouteRule for /coming_soon/ is configured
	// for the error code 404. If the request is for www.myotherdomain.com
	// and a 404 is encountered, the policy under
	// UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404
	// response is encountered for the request
	// www.example.com/current_events/, the pathMatcher's policy takes
	// effect. If however, the request for www.example.com/coming_soon/
	// encounters a 404, the policy in RouteRule.customErrorResponsePolicy
	// takes effect. If any of the requests in this example encounter a 500
	// error code, the policy at UrlMap.defaultCustomErrorResponsePolicy
	// takes effect. When used in conjunction with
	// routeRules.routeAction.retryPolicy, retries take precedence. Only
	// once all retries are exhausted, the customErrorResponsePolicy is
	// applied. While attempting a retry, if load balancer is successful in
	// reaching the service, the customErrorResponsePolicy is ignored and
	// the response from the service is returned to the client.
	// customErrorResponsePolicy is supported only for Global External
	// HTTP(S) load balancing.
	CustomErrorResponsePolicy *CustomErrorResponsePolicy `json:"customErrorResponsePolicy,omitempty"`

	// Description: The short description conveying the intent of this
	// routeRule. The description can have a maximum length of 1024
	// characters.
	Description string `json:"description,omitempty"`

	// HeaderAction: Specifies changes to request and response headers that
	// need to take effect for the selected backendService. The headerAction
	// value specified here is applied before the matching
	// pathMatchers[].headerAction and after
	// pathMatchers[].routeRules[].routeAction.weightedBackendService.backend
	// ServiceWeightAction[].headerAction HeaderAction is not supported for
	// load balancers that have their loadBalancingScheme set to EXTERNAL.
	// Not supported when the URL map is bound to a target gRPC proxy that
	// has validateForProxyless field set to true.
	HeaderAction *HttpHeaderAction `json:"headerAction,omitempty"`

	// HttpFilterConfigs: Outbound route specific configuration for
	// networkservices.HttpFilter resources enabled by Traffic Director.
	// httpFilterConfigs only applies for load balancers with
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule
	// for more details. Not supported when the URL map is bound to a target
	// gRPC proxy that has validateForProxyless field set to true.
	HttpFilterConfigs []*HttpFilterConfig `json:"httpFilterConfigs,omitempty"`

	// HttpFilterMetadata: Outbound route specific metadata supplied to
	// networkservices.HttpFilter resources enabled by Traffic Director.
	// httpFilterMetadata only applies for load balancers with
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule
	// for more details. The only configTypeUrl supported is
	// type.googleapis.com/google.protobuf.Struct Not supported when the URL
	// map is bound to a target gRPC proxy that has validateForProxyless
	// field set to true.
	HttpFilterMetadata []*HttpFilterConfig `json:"httpFilterMetadata,omitempty"`

	// MatchRules: The list of criteria for matching attributes of a request
	// to this routeRule. This list has OR semantics: the request matches
	// this routeRule when any of the matchRules are satisfied. However
	// predicates within a given matchRule have AND semantics. All
	// predicates within a matchRule must match for the request to match the
	// rule.
	MatchRules []*HttpRouteRuleMatch `json:"matchRules,omitempty"`

	// Priority: For routeRules within a given pathMatcher, priority
	// determines the order in which a load balancer interprets routeRules.
	// RouteRules are evaluated in order of priority, from the lowest to
	// highest number. The priority of a rule decreases as its number
	// increases (1, 2, 3, N+1). The first rule that matches the request is
	// applied. You cannot configure two or more routeRules with the same
	// priority. Priority for each rule must be set to a number from 0 to
	// 2147483647 inclusive. Priority numbers can have gaps, which enable
	// you to add or remove rules in the future without affecting the rest
	// of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series
	// of priority numbers to which you could add rules numbered from 6 to
	// 8, 10 to 11, and 13 to 15 in the future without any impact on
	// existing rules.
	Priority int64 `json:"priority,omitempty"`

	// RouteAction: In response to a matching matchRule, the load balancer
	// performs advanced routing actions, such as URL rewrites and header
	// transformations, before forwarding the request to the selected
	// backend. If routeAction specifies any weightedBackendServices,
	// service must not be set. Conversely if service is set, routeAction
	// cannot contain any weightedBackendServices. Only one of urlRedirect,
	// service or routeAction.weightedBackendService must be set. URL maps
	// for Classic external HTTP(S) load balancers only support the
	// urlRewrite action within a route rule's routeAction.
	RouteAction *HttpRouteAction `json:"routeAction,omitempty"`

	// Service: The full or partial URL of the backend service resource to
	// which traffic is directed if this rule is matched. If routeAction is
	// also specified, advanced routing actions, such as URL rewrites, take
	// effect before sending the request to the backend. However, if service
	// is specified, routeAction cannot contain any weightedBackendServices.
	// Conversely, if routeAction specifies any weightedBackendServices,
	// service must not be specified. Only one of urlRedirect, service or
	// routeAction.weightedBackendService must be set.
	Service string `json:"service,omitempty"`

	// UrlRedirect: When this rule is matched, the request is redirected to
	// a URL specified by urlRedirect. If urlRedirect is specified, service
	// or routeAction must not be set. Not supported when the URL map is
	// bound to a target gRPC proxy.
	UrlRedirect *HttpRedirectAction `json:"urlRedirect,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CustomErrorResponsePolicy") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CustomErrorResponsePolicy") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRouteRule) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRouteRuleMatch: HttpRouteRuleMatch specifies a set of criteria
// for matching requests to an HttpRouteRule. All specified criteria
// must be satisfied for a match to occur.
type HttpRouteRuleMatch struct {
	// FullPathMatch: For satisfying the matchRule condition, the path of
	// the request must exactly match the value specified in fullPathMatch
	// after removing any query parameters and anchor that may be part of
	// the original URL. fullPathMatch must be from 1 to 1024 characters.
	// Only one of prefixMatch, fullPathMatch or regexMatch must be
	// specified.
	FullPathMatch string `json:"fullPathMatch,omitempty"`

	// HeaderMatches: Specifies a list of header match criteria, all of
	// which must match corresponding headers in the request.
	HeaderMatches []*HttpHeaderMatch `json:"headerMatches,omitempty"`

	// IgnoreCase: Specifies that prefixMatch and fullPathMatch matches are
	// case sensitive. The default value is false. ignoreCase must not be
	// used with regexMatch. Not supported when the URL map is bound to a
	// target gRPC proxy.
	IgnoreCase bool `json:"ignoreCase,omitempty"`

	// MetadataFilters: Opaque filter criteria used by the load balancer to
	// restrict routing configuration to a limited set of xDS compliant
	// clients. In their xDS requests to the load balancer, xDS clients
	// present node metadata. When there is a match, the relevant routing
	// configuration is made available to those proxies. For each
	// metadataFilter in this list, if its filterMatchCriteria is set to
	// MATCH_ANY, at least one of the filterLabels must match the
	// corresponding label provided in the metadata. If its
	// filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels
	// must match with corresponding labels provided in the metadata. If
	// multiple metadata filters are specified, all of them need to be
	// satisfied in order to be considered a match. metadataFilters
	// specified here is applied after those specified in ForwardingRule
	// that refers to the UrlMap this HttpRouteRuleMatch belongs to.
	// metadataFilters only applies to load balancers that have
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when
	// the URL map is bound to a target gRPC proxy that has
	// validateForProxyless field set to true.
	MetadataFilters []*MetadataFilter `json:"metadataFilters,omitempty"`

	// PathTemplateMatch: If specified, the route is a pattern match
	// expression that must match the :path header once the query string is
	// removed. A pattern match allows you to match - The value must be
	// between 1 and 1024 characters - The pattern must start with a leading
	// slash ("/") - There may be no more than 5 operators in pattern
	// Precisely one of prefix_match, full_path_match, regex_match or
	// path_template_match must be set.
	PathTemplateMatch string `json:"pathTemplateMatch,omitempty"`

	// PrefixMatch: For satisfying the matchRule condition, the request's
	// path must begin with the specified prefixMatch. prefixMatch must
	// begin with a /. The value must be from 1 to 1024 characters. Only one
	// of prefixMatch, fullPathMatch or regexMatch must be specified.
	PrefixMatch string `json:"prefixMatch,omitempty"`

	// QueryParameterMatches: Specifies a list of query parameter match
	// criteria, all of which must match corresponding query parameters in
	// the request. Not supported when the URL map is bound to a target gRPC
	// proxy.
	QueryParameterMatches []*HttpQueryParameterMatch `json:"queryParameterMatches,omitempty"`

	// RegexMatch: For satisfying the matchRule condition, the path of the
	// request must satisfy the regular expression specified in regexMatch
	// after removing any query parameters and anchor supplied with the
	// original URL. For more information about regular expression syntax,
	// see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must
	// be specified. Regular expressions can only be used when the
	// loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
	RegexMatch string `json:"regexMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullPathMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullPathMatch") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRouteRuleMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRuleMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpsHealthCheck: Represents a legacy HTTPS Health Check resource.
// Legacy HTTPS health checks have been deprecated. If you are using a
// target pool-based network load balancer, you must use a legacy HTTP
// (not HTTPS) health check. For all other load balancers, including
// backend service-based network load balancers, and for managed
// instance group auto-healing, you must use modern (non-legacy) health
// checks. For more information, see Health checks overview .
type HttpsHealthCheck struct {
	// CheckIntervalSec: How often (in seconds) to send a health check. The
	// default value is 5 seconds.
	CheckIntervalSec int64 `json:"checkIntervalSec,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// HealthyThreshold: A so-far unhealthy instance will be marked healthy
	// after this many consecutive successes. The default value is 2.
	HealthyThreshold int64 `json:"healthyThreshold,omitempty"`

	// Host: The value of the host header in the HTTPS health check request.
	// If left empty (default value), the public IP on behalf of which this
	// health check is performed will be used.
	Host string `json:"host,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: Type of the resource.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Port: The TCP port number for the HTTPS health check request. The
	// default value is 443.
	Port int64 `json:"port,omitempty"`

	// RequestPath: The request path of the HTTPS health check request. The
	// default value is "/". Must comply with RFC3986.
	RequestPath string `json:"requestPath,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// TimeoutSec: How long (in seconds) to wait before claiming failure.
	// The default value is 5 seconds. It is invalid for timeoutSec to have
	// a greater value than checkIntervalSec.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// UnhealthyThreshold: A so-far healthy instance will be marked
	// unhealthy after this many consecutive failures. The default value is
	// 2.
	UnhealthyThreshold int64 `json:"unhealthyThreshold,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CheckIntervalSec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CheckIntervalSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpsHealthCheckList: Contains a list of HttpsHealthCheck resources.
type HttpsHealthCheckList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HttpsHealthCheck resources.
	Items []*HttpsHealthCheck `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HttpsHealthCheckListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheckList) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheckList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpsHealthCheckListWarning: [Output Only] Informational warning
// message.
type HttpsHealthCheckListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*HttpsHealthCheckListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheckListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheckListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HttpsHealthCheckListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheckListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheckListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Image: Represents an Image resource. You can use images to create
// boot disks for your VM instances. For more information, read Images.
type Image struct {
	// Architecture: The architecture of the image. Valid values are ARM64
	// or X86_64.
	//
	// Possible values:
	//   "ARCHITECTURE_UNSPECIFIED" - Default value indicating Architecture
	// is not set.
	//   "ARM64" - Machines with architecture ARM64
	//   "X86_64" - Machines with architecture X86_64
	Architecture string `json:"architecture,omitempty"`

	// ArchiveSizeBytes: Size of the image tar.gz archive stored in Google
	// Cloud Storage (in bytes).
	ArchiveSizeBytes int64 `json:"archiveSizeBytes,omitempty,string"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Deprecated -- The deprecation status associated with this image.
	Deprecated *DeprecationStatus `json:"deprecated,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DiskSizeGb: Size of the image when restored onto a persistent disk
	// (in GB).
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// Family: The name of the image family to which this image belongs. The
	// image family name can be from a publicly managed image family
	// provided by Compute Engine, or from a custom image family you create.
	// For example, centos-stream-9 is a publicly available image family.
	// For more information, see Image family best practices. When creating
	// disks, you can specify an image family instead of a specific image
	// name. The image family always returns its latest image that is not
	// deprecated. The name of the image family must comply with RFC1035.
	Family string `json:"family,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. To see a list of
	// available options, see the guestOSfeatures[].type parameter.
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// ImageEncryptionKey: Encrypts the image using a customer-supplied
	// encryption key. After you encrypt an image with a customer-supplied
	// key, you must provide the same key if you use the image later (e.g.
	// to create a disk from the image). Customer-supplied encryption keys
	// do not protect access to metadata of the disk. If you do not provide
	// an encryption key when creating the image, then the disk will be
	// encrypted using an automatically generated key and you do not need to
	// provide a key to use the image later.
	ImageEncryptionKey *CustomerEncryptionKey `json:"imageEncryptionKey,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#image for
	// images.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// image, which is essentially a hash of the labels used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update labels. You must
	// always provide an up-to-date fingerprint hash in order to update or
	// change labels, otherwise the request will fail with error 412
	// conditionNotMet. To see the latest fingerprint, make a get() request
	// to retrieve an image.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this image. These can be later modified by
	// the setLabels method.
	Labels map[string]string `json:"labels,omitempty"`

	// LicenseCodes: Integer license codes indicating which licenses are
	// attached to this image.
	LicenseCodes googleapi.Int64s `json:"licenseCodes,omitempty"`

	// Licenses: Any applicable license URI.
	Licenses []string `json:"licenses,omitempty"`

	// Locked: A flag for marketplace VM disk created from the image, which
	// is designed for marketplace VM disk to prevent the proprietary data
	// on the disk from being accessed unwantedly. The flag will be
	// inherited by the disk created from the image. The disk with locked
	// flag set to true will be prohibited from performing the operations
	// below: - R/W or R/O disk attach - Disk detach, if disk is created via
	// create-on-create - Create images - Create snapshots - Create disk
	// clone (create disk from the current disk) The image with the locked
	// field set to true will be prohibited from performing the operations
	// below: - Create images from the current image - Update the locked
	// field for the current image The instance with at least one disk with
	// locked flag set to true will be prohibited from performing the
	// operations below: - Secondary disk attach - Create instant snapshot -
	// Create machine images - Create instance template - Delete the
	// instance with --keep-disk parameter set to true
	Locked bool `json:"locked,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// RawDisk: The parameters of the raw disk image.
	RawDisk *ImageRawDisk `json:"rawDisk,omitempty"`

	// RolloutOverride: A rollout policy to apply to this image. When
	// specified, the rollout policy overrides per-zone references to the
	// image via the associated image family. The rollout policy restricts
	// the zones where this image is accessible when using a zonal image
	// family reference. When the rollout policy does not include the user
	// specified zone, or if the zone is rolled out, this image is
	// accessible. The rollout policy for this image is read-only, except
	// for allowlisted users. This field might not be configured. To view
	// the latest non-deprecated image in a specific zone, use the
	// imageFamilyViews.get method.
	RolloutOverride *RolloutPolicy `json:"rolloutOverride,omitempty"`

	// SatisfiesPzs: [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ShieldedInstanceInitialState: Set the secure boot keys of shielded
	// instance.
	ShieldedInstanceInitialState *InitialStateConfig `json:"shieldedInstanceInitialState,omitempty"`

	// SourceDisk: URL of the source disk used to create this image. For
	// example, the following are valid values: -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// /disks/disk - projects/project/zones/zone/disks/disk -
	// zones/zone/disks/disk In order to create an image, you must provide
	// the full or partial URL of one of the following: - The rawDisk.source
	// URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot
	// URL
	SourceDisk string `json:"sourceDisk,omitempty"`

	// SourceDiskEncryptionKey: The customer-supplied encryption key of the
	// source disk. Required if the source disk is protected by a
	// customer-supplied encryption key.
	SourceDiskEncryptionKey *CustomerEncryptionKey `json:"sourceDiskEncryptionKey,omitempty"`

	// SourceDiskId: [Output Only] The ID value of the disk used to create
	// this image. This value may be used to determine whether the image was
	// taken from the current or a previous instance of a given disk name.
	SourceDiskId string `json:"sourceDiskId,omitempty"`

	// SourceImage: URL of the source image used to create this image. The
	// following are valid formats for the URL: -
	// https://www.googleapis.com/compute/v1/projects/project_id/global/
	// images/image_name - projects/project_id/global/images/image_name In
	// order to create an image, you must provide the full or partial URL of
	// one of the following: - The rawDisk.source URL - The sourceDisk URL -
	// The sourceImage URL - The sourceSnapshot URL
	SourceImage string `json:"sourceImage,omitempty"`

	// SourceImageEncryptionKey: The customer-supplied encryption key of the
	// source image. Required if the source image is protected by a
	// customer-supplied encryption key.
	SourceImageEncryptionKey *CustomerEncryptionKey `json:"sourceImageEncryptionKey,omitempty"`

	// SourceImageId: [Output Only] The ID value of the image used to create
	// this image. This value may be used to determine whether the image was
	// taken from the current or a previous instance of a given image name.
	SourceImageId string `json:"sourceImageId,omitempty"`

	// SourceSnapshot: URL of the source snapshot used to create this image.
	// The following are valid formats for the URL: -
	// https://www.googleapis.com/compute/v1/projects/project_id/global/
	// snapshots/snapshot_name -
	// projects/project_id/global/snapshots/snapshot_name In order to create
	// an image, you must provide the full or partial URL of one of the
	// following: - The rawDisk.source URL - The sourceDisk URL - The
	// sourceImage URL - The sourceSnapshot URL
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`

	// SourceSnapshotEncryptionKey: The customer-supplied encryption key of
	// the source snapshot. Required if the source snapshot is protected by
	// a customer-supplied encryption key.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `json:"sourceSnapshotEncryptionKey,omitempty"`

	// SourceSnapshotId: [Output Only] The ID value of the snapshot used to
	// create this image. This value may be used to determine whether the
	// snapshot was taken from the current or a previous instance of a given
	// snapshot name.
	SourceSnapshotId string `json:"sourceSnapshotId,omitempty"`

	// SourceType: The type of the image used to create this disk. The
	// default and only valid value is RAW.
	//
	// Possible values:
	//   "RAW" (default)
	SourceType string `json:"sourceType,omitempty"`

	// Status: [Output Only] The status of the image. An image can be used
	// to create other resources, such as instances, only after the image
	// has been successfully created and the status is set to READY.
	// Possible values are FAILED, PENDING, or READY.
	//
	// Possible values:
	//   "DELETING" - Image is deleting.
	//   "FAILED" - Image creation failed due to an error.
	//   "PENDING" - Image hasn't been created as yet.
	//   "READY" - Image has been successfully created.
	Status string `json:"status,omitempty"`

	// StorageLocations: Cloud Storage bucket storage location of the image
	// (regional or multi-regional).
	StorageLocations []string `json:"storageLocations,omitempty"`

	// UserLicenses: A list of publicly visible user-licenses. Unlike
	// regular licenses, user provided licenses can be modified after the
	// disk is created. This includes a list of URLs to the license
	// resource. For example, to provide a debian license:
	// https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch
	UserLicenses []string `json:"userLicenses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Architecture") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageRawDisk: The parameters of the raw disk image.
type ImageRawDisk struct {
	// ContainerType: The format used to encode and transmit the block
	// device, which should be TAR. This is just a container and
	// transmission format and not a runtime format. Provided by the client
	// when the disk image is created.
	//
	// Possible values:
	//   "TAR"
	ContainerType string `json:"containerType,omitempty"`

	// Sha1Checksum: [Deprecated] This field is deprecated. An optional SHA1
	// checksum of the disk image before unpackaging provided by the client
	// when the disk image is created.
	Sha1Checksum string `json:"sha1Checksum,omitempty"`

	// Source: The full Google Cloud Storage URL where the raw disk image
	// archive is stored. The following are valid formats for the URL: -
	// https://storage.googleapis.com/bucket_name/image_archive_name -
	// https://storage.googleapis.com/bucket_name/folder_name/
	// image_archive_name In order to create an image, you must provide the
	// full or partial URL of one of the following: - The rawDisk.source URL
	// - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageRawDisk) MarshalJSON() ([]byte, error) {
	type NoMethod ImageRawDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImageFamilyView struct {
	// Image: The latest image that is part of the specified image family in
	// the requested location, and that is not deprecated.
	Image *Image `json:"image,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Image") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageFamilyView) MarshalJSON() ([]byte, error) {
	type NoMethod ImageFamilyView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageList: Contains a list of images.
type ImageList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Image resources.
	Items []*Image `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ImageListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageList) MarshalJSON() ([]byte, error) {
	type NoMethod ImageList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageListWarning: [Output Only] Informational warning message.
type ImageListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*ImageListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ImageListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImageListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ImageListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InitialStateConfig: Initial State for shielded instance, these are
// public keys which are safe to store in public
type InitialStateConfig struct {
	// Dbs: The Key Database (db).
	Dbs []*FileContentBuffer `json:"dbs,omitempty"`

	// Dbxs: The forbidden key database (dbx).
	Dbxs []*FileContentBuffer `json:"dbxs,omitempty"`

	// Keks: The Key Exchange Key (KEK).
	Keks []*FileContentBuffer `json:"keks,omitempty"`

	// Pk: The Platform Key (PK).
	Pk *FileContentBuffer `json:"pk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dbs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dbs") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InitialStateConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InitialStateConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Instance: Represents an Instance resource. An instance is a virtual
// machine that is hosted on Google Cloud Platform. For more
// information, read Virtual Machine Instances.
type Instance struct {
	// AdvancedMachineFeatures: Controls for advanced machine-related
	// behavior features.
	AdvancedMachineFeatures *AdvancedMachineFeatures `json:"advancedMachineFeatures,omitempty"`

	// CanIpForward: Allows this instance to send and receive packets with
	// non-matching destination or source IPs. This is required if you plan
	// to use this instance to forward routes. For more information, see
	// Enabling IP Forwarding .
	CanIpForward bool `json:"canIpForward,omitempty"`

	ConfidentialInstanceConfig *ConfidentialInstanceConfig `json:"confidentialInstanceConfig,omitempty"`

	// CpuPlatform: [Output Only] The CPU platform used by this instance.
	CpuPlatform string `json:"cpuPlatform,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// DeletionProtection: Whether the resource should be protected against
	// deletion.
	DeletionProtection bool `json:"deletionProtection,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Disks: Array of disks associated with this instance. Persistent disks
	// must be created before you can assign them.
	Disks []*AttachedDisk `json:"disks,omitempty"`

	// DisplayDevice: Enables display device for the instance.
	DisplayDevice *DisplayDevice `json:"displayDevice,omitempty"`

	// EraseWindowsVssSignature: Specifies whether the disks restored from
	// source snapshots or source machine image should erase Windows
	// specific VSS signature.
	EraseWindowsVssSignature bool `json:"eraseWindowsVssSignature,omitempty"`

	// Fingerprint: Specifies a fingerprint for this resource, which is
	// essentially a hash of the instance's contents and used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update the instance. You
	// must always provide an up-to-date fingerprint hash in order to update
	// the instance. To see the latest fingerprint, make get() request to
	// the instance.
	Fingerprint string `json:"fingerprint,omitempty"`

	// GuestAccelerators: A list of the type and count of accelerator cards
	// attached to the instance.
	GuestAccelerators []*AcceleratorConfig `json:"guestAccelerators,omitempty"`

	// Hostname: Specifies the hostname of the instance. The specified
	// hostname must be RFC1035 compliant. If hostname is not specified, the
	// default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when
	// using the global DNS, and
	// [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
	Hostname string `json:"hostname,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// InstanceEncryptionKey: Encrypts suspended data for an instance with a
	// customer-managed encryption key. If you are creating a new instance,
	// this field will encrypt the local SSD and in-memory contents of the
	// instance during the suspend operation. If you do not provide an
	// encryption key when creating the instance, then the local SSD and
	// in-memory contents will be encrypted using an automatically generated
	// key during the suspend operation.
	InstanceEncryptionKey *CustomerEncryptionKey `json:"instanceEncryptionKey,omitempty"`

	// KeyRevocationActionType: KeyRevocationActionType of the instance.
	// Supported options are "STOP" and "NONE". The default value is "NONE"
	// if it is not specified.
	//
	// Possible values:
	//   "KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED" - Default value. This
	// value is unused.
	//   "NONE" - Indicates user chose no operation.
	//   "STOP" - Indicates user chose to opt for VM shutdown on key
	// revocation.
	KeyRevocationActionType string `json:"keyRevocationActionType,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#instance for
	// instances.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for this request, which is
	// essentially a hash of the label's contents and used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update labels. You must
	// always provide an up-to-date fingerprint hash in order to update or
	// change labels. To see the latest fingerprint, make get() request to
	// the instance.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this instance. These can be later modified
	// by the setLabels method.
	Labels map[string]string `json:"labels,omitempty"`

	// LastStartTimestamp: [Output Only] Last start timestamp in RFC3339
	// text format.
	LastStartTimestamp string `json:"lastStartTimestamp,omitempty"`

	// LastStopTimestamp: [Output Only] Last stop timestamp in RFC3339 text
	// format.
	LastStopTimestamp string `json:"lastStopTimestamp,omitempty"`

	// LastSuspendedTimestamp: [Output Only] Last suspended timestamp in
	// RFC3339 text format.
	LastSuspendedTimestamp string `json:"lastSuspendedTimestamp,omitempty"`

	// MachineType: Full or partial URL of the machine type resource to use
	// for this instance, in the format:
	// zones/zone/machineTypes/machine-type. This is provided by the client
	// when the instance is created. For example, the following is a valid
	// partial url to a predefined machine type:
	// zones/us-central1-f/machineTypes/n1-standard-1 To create a custom
	// machine type, provide a URL to a machine type in the following
	// format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24,
	// etc), and MEMORY is the total memory for this instance. Memory must
	// be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of
	// memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For
	// example: zones/us-central1-f/machineTypes/custom-4-5120 For a full
	// list of restrictions, read the Specifications for custom machine
	// types.
	MachineType string `json:"machineType,omitempty"`

	// Metadata: The metadata key/value pairs assigned to this instance.
	// This includes custom metadata and predefined keys.
	Metadata *Metadata `json:"metadata,omitempty"`

	// MinCpuPlatform: Specifies a minimum CPU platform for the VM instance.
	// Applicable values are the friendly names of CPU platforms, such as
	// minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy
	// Bridge".
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`

	// Name: The name of the resource, provided by the client when initially
	// creating the resource. The resource name must be 1-63 characters
	// long, and comply with RFC1035. Specifically, the name must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	Name string `json:"name,omitempty"`

	// NetworkInterfaces: An array of network configurations for this
	// instance. These specify how interfaces are configured to interact
	// with other network services, such as connecting to the internet.
	// Multiple interfaces are supported per instance.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`

	NetworkPerformanceConfig *NetworkPerformanceConfig `json:"networkPerformanceConfig,omitempty"`

	// Params: Input only. [Input Only] Additional params passed with the
	// request, but not persisted as part of resource payload.
	Params *InstanceParams `json:"params,omitempty"`

	// PostKeyRevocationActionType: PostKeyRevocationActionType of the
	// instance.
	//
	// Possible values:
	//   "NOOP" - Indicates user chose no operation.
	//   "POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED" - Default value. This
	// value is unused.
	//   "SHUTDOWN" - Indicates user chose to opt for VM shutdown on key
	// revocation.
	PostKeyRevocationActionType string `json:"postKeyRevocationActionType,omitempty"`

	// PreservedStateSizeGb: Total amount of preserved state for SUSPENDED
	// instances. Read-only in the api.
	PreservedStateSizeGb int64 `json:"preservedStateSizeGb,omitempty,string"`

	// PrivateIpv6GoogleAccess: The private IPv6 google access type for the
	// VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
	//
	// Possible values:
	//   "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE" - Bidirectional private
	// IPv6 access to/from Google services. If specified, the subnetwork who
	// is attached to the instance's default network interface will be
	// assigned an internal IPv6 prefix if it doesn't have before.
	//   "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE" - Outbound private IPv6
	// access from VMs in this subnet to Google services. If specified, the
	// subnetwork who is attached to the instance's default network
	// interface will be assigned an internal IPv6 prefix if it doesn't have
	// before.
	//   "INHERIT_FROM_SUBNETWORK" - Each network interface inherits
	// PrivateIpv6GoogleAccess from its subnetwork.
	PrivateIpv6GoogleAccess string `json:"privateIpv6GoogleAccess,omitempty"`

	// ReservationAffinity: Specifies the reservations that this instance
	// can consume from.
	ReservationAffinity *ReservationAffinity `json:"reservationAffinity,omitempty"`

	// ResourcePolicies: Resource policies applied to this instance.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ResourceStatus: [Output Only] Specifies values set for instance
	// attributes as compared to the values requested by user in the
	// corresponding input only field.
	ResourceStatus *ResourceStatus `json:"resourceStatus,omitempty"`

	// SatisfiesPzs: [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`

	// Scheduling: Sets the scheduling options for this instance.
	Scheduling *Scheduling `json:"scheduling,omitempty"`

	// SecureTags: [Input Only] Secure tags to apply to this instance. These
	// can be later modified by the update method. Maximum number of secure
	// tags allowed is 50.
	SecureTags []string `json:"secureTags,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServiceAccounts: A list of service accounts, with their specified
	// scopes, authorized for this instance. Only one service account per VM
	// instance is supported. Service accounts generate access tokens that
	// can be accessed through the metadata server and used to authenticate
	// applications on the instance. See Service Accounts for more
	// information.
	ServiceAccounts []*ServiceAccount `json:"serviceAccounts,omitempty"`

	// ServiceIntegrationSpecs: Mapping of user-defined keys to
	// specifications for service integrations. Currently only a single
	// key-value pair is supported.
	ServiceIntegrationSpecs map[string]ServiceIntegrationSpec `json:"serviceIntegrationSpecs,omitempty"`

	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`

	ShieldedInstanceIntegrityPolicy *ShieldedInstanceIntegrityPolicy `json:"shieldedInstanceIntegrityPolicy,omitempty"`

	// ShieldedVmConfig: Deprecating, please use shielded_instance_config.
	ShieldedVmConfig *ShieldedVmConfig `json:"shieldedVmConfig,omitempty"`

	// ShieldedVmIntegrityPolicy: Deprecating, please use
	// shielded_instance_integrity_policy.
	ShieldedVmIntegrityPolicy *ShieldedVmIntegrityPolicy `json:"shieldedVmIntegrityPolicy,omitempty"`

	// SourceMachineImage: Source machine image
	SourceMachineImage string `json:"sourceMachineImage,omitempty"`

	// SourceMachineImageEncryptionKey: Source machine image encryption key
	// when creating an instance from a machine image.
	SourceMachineImageEncryptionKey *CustomerEncryptionKey `json:"sourceMachineImageEncryptionKey,omitempty"`

	// StartRestricted: [Output Only] Whether a VM has been restricted for
	// start because Compute Engine has detected suspicious activity.
	StartRestricted bool `json:"startRestricted,omitempty"`

	// Status: [Output Only] The status of the instance. One of the
	// following values: PROVISIONING, STAGING, RUNNING, STOPPING,
	// SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more
	// information about the status of the instance, see Instance life
	// cycle.
	//
	// Possible values:
	//   "DEPROVISIONING" - The instance is halted and we are performing
	// tear down tasks like network deprogramming, releasing quota, IP,
	// tearing down disks etc.
	//   "PROVISIONING" - Resources are being allocated for the instance.
	//   "REPAIRING" - The instance is in repair.
	//   "RUNNING" - The instance is running.
	//   "STAGING" - All required resources have been allocated and the
	// instance is being started.
	//   "STOPPED" - The instance has stopped successfully.
	//   "STOPPING" - The instance is currently stopping (either being
	// deleted or killed).
	//   "SUSPENDED" - The instance has suspended.
	//   "SUSPENDING" - The instance is suspending.
	//   "TERMINATED" - The instance has stopped (either by explicit action
	// or underlying failure).
	Status string `json:"status,omitempty"`

	// StatusMessage: [Output Only] An optional, human-readable explanation
	// of the status.
	StatusMessage string `json:"statusMessage,omitempty"`

	// Tags: Tags to apply to this instance. Tags are used to identify valid
	// sources or targets for network firewalls and are specified by the
	// client during instance creation. The tags can be later modified by
	// the setTags method. Each tag within the list must comply with
	// RFC1035. Multiple tags can be specified via the 'tags.items' field.
	Tags *Tags `json:"tags,omitempty"`

	// UpcomingMaintenance: [Output Only] Specifies upcoming maintenance for
	// the instance.
	UpcomingMaintenance *UpcomingMaintenance `json:"upcomingMaintenance,omitempty"`

	// Zone: [Output Only] URL of the zone where the instance resides. You
	// must specify this field as part of the HTTP request URL. It is not
	// settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdvancedMachineFeatures") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedMachineFeatures")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Instance) MarshalJSON() ([]byte, error) {
	type NoMethod Instance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: An object that contains a list of instances scoped by zone.
	Items map[string]InstancesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#instanceAggregatedList for aggregated lists of Instance
	// resources.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceAggregatedListWarning: [Output Only] Informational warning
// message.
type InstanceAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*InstanceAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceConsumptionData struct {
	// ConsumptionInfo: Resources consumed by the instance.
	ConsumptionInfo *InstanceConsumptionInfo `json:"consumptionInfo,omitempty"`

	// Instance: Server-defined URL for the instance.
	Instance string `json:"instance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConsumptionInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumptionInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceConsumptionData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceConsumptionData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceConsumptionInfo struct {
	// GuestCpus: The number of virtual CPUs that are available to the
	// instance.
	GuestCpus int64 `json:"guestCpus,omitempty"`

	// LocalSsdGb: The amount of local SSD storage available to the
	// instance, defined in GiB.
	LocalSsdGb int64 `json:"localSsdGb,omitempty"`

	// MemoryMb: The amount of physical memory available to the instance,
	// defined in MiB.
	MemoryMb int64 `json:"memoryMb,omitempty"`

	// MinNodeCpus: The minimal guaranteed number of virtual CPUs that are
	// reserved.
	MinNodeCpus int64 `json:"minNodeCpus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GuestCpus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GuestCpus") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceConsumptionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceConsumptionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroup: Represents an Instance Group resource. Instance Groups
// can be used to configure a target for load balancing. Instance groups
// can either be managed or unmanaged. To create managed instance
// groups, use the instanceGroupManager or regionInstanceGroupManager
// resource instead. Use zonal unmanaged instance groups if you need to
// apply load balancing to groups of heterogeneous instances or if you
// need to manage the instances yourself. You cannot create regional
// unmanaged instance groups. For more information, read Instance
// groups.
type InstanceGroup struct {
	// CreationTimestamp: [Output Only] The creation timestamp for this
	// instance group in RFC3339 text format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Fingerprint: [Output Only] The fingerprint of the named ports. The
	// system uses this fingerprint to detect conflicts when multiple users
	// change the named ports concurrently.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Id: [Output Only] A unique identifier for this instance group,
	// generated by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroup for instance groups.
	Kind string `json:"kind,omitempty"`

	// Name: The name of the instance group. The name must be 1-63
	// characters long, and comply with RFC1035.
	Name string `json:"name,omitempty"`

	// NamedPorts:  Assigns a name to a port number. For example: {name:
	// "http", port: 80} This allows the system to reference ports by the
	// assigned name instead of a port number. Named ports can also contain
	// multiple ports. For example: [{name: "app1", port: 8080}, {name:
	// "app1", port: 8081}, {name: "app2", port: 8082}] Named ports apply to
	// all instances in this instance group.
	NamedPorts []*NamedPort `json:"namedPorts,omitempty"`

	// Network: [Output Only] The URL of the network to which all instances
	// in the instance group belong. If your instance has multiple network
	// interfaces, then the network and subnetwork fields only refer to the
	// network and subnet used by your primary interface (nic0).
	Network string `json:"network,omitempty"`

	// Region: [Output Only] The URL of the region where the instance group
	// is located (for regional resources).
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] The URL for this instance group. The server
	// generates this URL.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Size: [Output Only] The total number of instances in the instance
	// group.
	Size int64 `json:"size,omitempty"`

	// Subnetwork: [Output Only] The URL of the subnetwork to which all
	// instances in the instance group belong. If your instance has multiple
	// network interfaces, then the network and subnetwork fields only refer
	// to the network and subnet used by your primary interface (nic0).
	Subnetwork string `json:"subnetwork,omitempty"`

	// Zone: [Output Only] The URL of the zone where the instance group is
	// located (for zonal resources).
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroup) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstanceGroupsScopedList resources.
	Items map[string]InstanceGroupsScopedList `json:"items,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroupAggregatedList for aggregated lists of instance
	// groups.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceGroupAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupAggregatedListWarning: [Output Only] Informational
// warning message.
type InstanceGroupAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient
	// changes made by a failed operation.
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was
	// created.
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as deprecated
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk
	// that is larger than image size.
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api
	// call
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an
	// injected kernel, which is deprecated.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV
	// backend service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is
	// not assigned to an instance on the network.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot
	// ip forward.
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's
	// nextHopInstance URL refers to an instance that does not have an ipv6
	// interface on the same network as the route.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL
	// refers to an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance
	// URL refers to an instance that is not on the same network as the
	// route.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not
	// have a status of RUNNING.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to
	// continue the process despite the mentioned error.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list
	// page.
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be
	// missing due to errors
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource
	// that requires a TOS they have not accepted.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a
	// resource is in use.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to
	// auto-delete could not be deleted because they were in use.
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in
	// instance group manager is valid as such, but its application does not
	// make a lot of sense, because it allows only single instance in
	// instance group.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema
	// are present
	//   "UNREACHABLE" - A given scope cannot be reached.
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example: "data": [ { "key": "scope", "value": "zones/us-east1-d"
	// }
	Data []*InstanceGroupAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupList: A list of InstanceGroup resources.
type InstanceGroupList struct {
	// Id: [Outp