// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestExtractDecompoundedAttributes(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.DecompoundedAttributesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.DecompoundedAttributes(map[string][]string{}),
		},
		{
			opts:     []interface{}{opt.DecompoundedAttributes(map[string][]string{})},
			expected: opt.DecompoundedAttributes(map[string][]string{}),
		},
		{
			opts:     []interface{}{opt.DecompoundedAttributes(map[string][]string{"k1": {"v1", "v2"}, "k2": {"v3", "v4"}})},
			expected: opt.DecompoundedAttributes(map[string][]string{"k1": {"v1", "v2"}, "k2": {"v3", "v4"}}),
		},
	} {
		var (
			in  = ExtractDecompoundedAttributes(c.opts...)
			out opt.DecompoundedAttributesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.Equal(t, *c.expected, out)
	}
}
