// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/resourcemanager/v3/tag_keys.proto

package resourcemanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A purpose for each policy engine requiring such an integration. A single
// policy engine may have multiple purposes defined, however a TagKey may only
// specify a single purpose.
type Purpose int32

const (
	// Unspecified purpose.
	Purpose_PURPOSE_UNSPECIFIED Purpose = 0
	// Purpose for Compute Engine firewalls.
	// A corresponding `purpose_data` should be set for the network the tag is
	// intended for. The key should be `network` and the value should be in
	// either of these two formats:
	//
	// -
	// `https://www.googleapis.com/compute/{compute_version}/projects/{project_id}/global/networks/{network_id}`
	// - `{project_id}/{network_name}`
	//
	// Examples:
	//
	// -
	// `https://www.googleapis.com/compute/staging_v1/projects/fail-closed-load-testing/global/networks/6992953698831725600`
	// - `fail-closed-load-testing/load-testing-network`
	Purpose_GCE_FIREWALL Purpose = 1
)

// Enum value maps for Purpose.
var (
	Purpose_name = map[int32]string{
		0: "PURPOSE_UNSPECIFIED",
		1: "GCE_FIREWALL",
	}
	Purpose_value = map[string]int32{
		"PURPOSE_UNSPECIFIED": 0,
		"GCE_FIREWALL":        1,
	}
)

func (x Purpose) Enum() *Purpose {
	p := new(Purpose)
	*p = x
	return p
}

func (x Purpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Purpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_enumTypes[0].Descriptor()
}

func (Purpose) Type() protoreflect.EnumType {
	return &file_google_cloud_resourcemanager_v3_tag_keys_proto_enumTypes[0]
}

func (x Purpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Purpose.Descriptor instead.
func (Purpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{0}
}

// A TagKey, used to group a set of TagValues.
type TagKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name for a TagKey. Must be in the format
	// `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
	// the TagKey.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The resource name of the TagKey's parent. A TagKey can be
	// parented by an Organization or a Project. For a TagKey parented by an
	// Organization, its parent must be in the form `organizations/{org_id}`. For
	// a TagKey parented by a Project, its parent can be in the form
	// `projects/{project_id}` or `projects/{project_number}`.
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Immutable. The user friendly name for a TagKey. The short name
	// should be unique for TagKeys within the same tag namespace.
	//
	// The short name must be 1-63 characters, beginning and ending with
	// an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
	// dots (.), and alphanumerics between.
	ShortName string `protobuf:"bytes,3,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// Output only. Immutable. Namespaced name of the TagKey.
	NamespacedName string `protobuf:"bytes,4,opt,name=namespaced_name,json=namespacedName,proto3" json:"namespaced_name,omitempty"`
	// Optional. User-assigned description of the TagKey. Must not exceed 256
	// characters.
	//
	// Read-write.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Entity tag which users can pass to prevent race conditions. This
	// field is always set in server responses. See UpdateTagKeyRequest for
	// details.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. A purpose denotes that this Tag is intended for use in policies
	// of a specific policy engine, and will involve that policy engine in
	// management operations involving this Tag. A purpose does not grant a
	// policy engine exclusive rights to the Tag, and it may be referenced by
	// other policy engines.
	//
	// A purpose cannot be changed once set.
	Purpose Purpose `protobuf:"varint,11,opt,name=purpose,proto3,enum=google.cloud.resourcemanager.v3.Purpose" json:"purpose,omitempty"`
	// Optional. Purpose data corresponds to the policy system that the tag is
	// intended for. See documentation for `Purpose` for formatting of this field.
	//
	// Purpose data cannot be changed once set.
	PurposeData map[string]string `protobuf:"bytes,12,rep,name=purpose_data,json=purposeData,proto3" json:"purpose_data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TagKey) Reset() {
	*x = TagKey{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TagKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TagKey) ProtoMessage() {}

func (x *TagKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TagKey.ProtoReflect.Descriptor instead.
func (*TagKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{0}
}

func (x *TagKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TagKey) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TagKey) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *TagKey) GetNamespacedName() string {
	if x != nil {
		return x.NamespacedName
	}
	return ""
}

func (x *TagKey) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TagKey) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TagKey) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TagKey) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *TagKey) GetPurpose() Purpose {
	if x != nil {
		return x.Purpose
	}
	return Purpose_PURPOSE_UNSPECIFIED
}

func (x *TagKey) GetPurposeData() map[string]string {
	if x != nil {
		return x.PurposeData
	}
	return nil
}

// The request message for listing all TagKeys under a parent resource.
type ListTagKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TagKey's parent.
	// Must be of the form `organizations/{org_id}` or `projects/{project_id}` or
	// `projects/{project_number}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of TagKeys to return in the response. The
	// server allows a maximum of 300 TagKeys to return. If unspecified, the
	// server will use 100 as the default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A pagination token returned from a previous call to `ListTagKey`
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTagKeysRequest) Reset() {
	*x = ListTagKeysRequest{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTagKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagKeysRequest) ProtoMessage() {}

func (x *ListTagKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagKeysRequest.ProtoReflect.Descriptor instead.
func (*ListTagKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{1}
}

func (x *ListTagKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTagKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTagKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The ListTagKeys response message.
type ListTagKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of TagKeys that live under the specified parent in the request.
	TagKeys []*TagKey `protobuf:"bytes,1,rep,name=tag_keys,json=tagKeys,proto3" json:"tag_keys,omitempty"`
	// A pagination token returned from a previous call to `ListTagKeys`
	// that indicates from where listing should continue.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTagKeysResponse) Reset() {
	*x = ListTagKeysResponse{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTagKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagKeysResponse) ProtoMessage() {}

func (x *ListTagKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagKeysResponse.ProtoReflect.Descriptor instead.
func (*ListTagKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{2}
}

func (x *ListTagKeysResponse) GetTagKeys() []*TagKey {
	if x != nil {
		return x.TagKeys
	}
	return nil
}

func (x *ListTagKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for getting a TagKey.
type GetTagKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A resource name in the format `tagKeys/{id}`, such as
	// `tagKeys/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTagKeyRequest) Reset() {
	*x = GetTagKeyRequest{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTagKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTagKeyRequest) ProtoMessage() {}

func (x *GetTagKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTagKeyRequest.ProtoReflect.Descriptor instead.
func (*GetTagKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{3}
}

func (x *GetTagKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for getting a TagKey by its namespaced name.
type GetNamespacedTagKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A namespaced tag key name in the format
	// `{parentId}/{tagKeyShort}`, such as `42/foo` for a key with short name
	// "foo" under the organization with ID 42 or `r2-d2/bar` for a key with short
	// name "bar" under the project `r2-d2`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNamespacedTagKeyRequest) Reset() {
	*x = GetNamespacedTagKeyRequest{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNamespacedTagKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNamespacedTagKeyRequest) ProtoMessage() {}

func (x *GetNamespacedTagKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNamespacedTagKeyRequest.ProtoReflect.Descriptor instead.
func (*GetNamespacedTagKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{4}
}

func (x *GetNamespacedTagKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for creating a TagKey.
type CreateTagKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The TagKey to be created. Only fields `short_name`,
	// `description`, and `parent` are considered during the creation request.
	TagKey *TagKey `protobuf:"bytes,1,opt,name=tag_key,json=tagKey,proto3" json:"tag_key,omitempty"`
	// Optional. Set to true to perform validations necessary for creating the
	// resource, but not actually perform the action.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateTagKeyRequest) Reset() {
	*x = CreateTagKeyRequest{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTagKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagKeyRequest) ProtoMessage() {}

func (x *CreateTagKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateTagKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{5}
}

func (x *CreateTagKeyRequest) GetTagKey() *TagKey {
	if x != nil {
		return x.TagKey
	}
	return nil
}

func (x *CreateTagKeyRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Runtime operation information for creating a TagKey.
type CreateTagKeyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateTagKeyMetadata) Reset() {
	*x = CreateTagKeyMetadata{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTagKeyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagKeyMetadata) ProtoMessage() {}

func (x *CreateTagKeyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagKeyMetadata.ProtoReflect.Descriptor instead.
func (*CreateTagKeyMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{6}
}

// The request message for updating a TagKey.
type UpdateTagKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new definition of the TagKey. Only the `description` and
	// `etag` fields can be updated by this request. If the `etag` field is not
	// empty, it must match the `etag` field of the existing tag key. Otherwise,
	// `ABORTED` will be returned.
	TagKey *TagKey `protobuf:"bytes,1,opt,name=tag_key,json=tagKey,proto3" json:"tag_key,omitempty"`
	// Fields to be updated. The mask may only contain `description` or
	// `etag`. If omitted entirely, both `description` and `etag` are assumed to
	// be significant.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Set as true to perform validations necessary for updating the resource, but
	// not actually perform the action.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateTagKeyRequest) Reset() {
	*x = UpdateTagKeyRequest{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTagKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagKeyRequest) ProtoMessage() {}

func (x *UpdateTagKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateTagKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateTagKeyRequest) GetTagKey() *TagKey {
	if x != nil {
		return x.TagKey
	}
	return nil
}

func (x *UpdateTagKeyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTagKeyRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Runtime operation information for updating a TagKey.
type UpdateTagKeyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateTagKeyMetadata) Reset() {
	*x = UpdateTagKeyMetadata{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTagKeyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagKeyMetadata) ProtoMessage() {}

func (x *UpdateTagKeyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagKeyMetadata.ProtoReflect.Descriptor instead.
func (*UpdateTagKeyMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{8}
}

// The request message for deleting a TagKey.
type DeleteTagKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of a TagKey to be deleted in the format
	// `tagKeys/123`. The TagKey cannot be a parent of any existing TagValues or
	// it will not be deleted successfully.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Set as true to perform validations necessary for deletion, but
	// not actually perform the action.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. The etag known to the client for the expected state of the
	// TagKey. This is to be used for optimistic concurrency.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteTagKeyRequest) Reset() {
	*x = DeleteTagKeyRequest{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTagKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagKeyRequest) ProtoMessage() {}

func (x *DeleteTagKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteTagKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTagKeyRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteTagKeyRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Runtime operation information for deleting a TagKey.
type DeleteTagKeyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteTagKeyMetadata) Reset() {
	*x = DeleteTagKeyMetadata{}
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTagKeyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagKeyMetadata) ProtoMessage() {}

func (x *DeleteTagKeyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagKeyMetadata.ProtoReflect.Descriptor instead.
func (*DeleteTagKeyMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP(), []int{10}
}

var File_google_cloud_resourcemanager_v3_tag_keys_proto protoreflect.FileDescriptor

var file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76,
	0x33, 0x2f, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8c, 0x05, 0x0a, 0x06, 0x54, 0x61, 0x67,
	0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0a, 0x73, 0x68, 0x6f,
	0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2f, 0x0a, 0x0f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x0e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x47, 0x0a, 0x07, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x60,
	0x0a, 0x0c, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x2e, 0x50, 0x75,
	0x72, 0x70, 0x6f, 0x73, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x1a, 0x3e, 0x0a, 0x10, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x45, 0xea, 0x41, 0x42, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x4b, 0x65,
	0x79, 0x12, 0x11, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x5f,
	0x6b, 0x65, 0x79, 0x7d, 0x52, 0x01, 0x01, 0x22, 0x7d, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x03, 0x12, 0x01, 0x2a, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42,
	0x0a, 0x08, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x33, 0x2e, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x07, 0x74, 0x61, 0x67, 0x4b, 0x65,
	0x79, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5a, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x86, 0x01, 0x0a,
	0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x16, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xbe, 0x01,
	0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x16,
	0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa0, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x16, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2a, 0x34, 0x0a, 0x07, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x13,
	0x50, 0x55, 0x52, 0x50, 0x4f, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x43, 0x45, 0x5f, 0x46, 0x49, 0x52,
	0x45, 0x57, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x32, 0xe4, 0x0c, 0x0a, 0x07, 0x54, 0x61, 0x67, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0x96, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1c,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0d, 0x12,
	0x0b, 0x2f, 0x76, 0x33, 0x2f, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x8c, 0x01, 0x0a,
	0x09, 0x47, 0x65, 0x74, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74,
	0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x22, 0x23, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x16, 0x12, 0x14, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa2, 0x01, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x54, 0x61, 0x67,
	0x4b, 0x65, 0x79, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x64, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x33, 0x2e, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x22, 0x25, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12, 0x16, 0x2f, 0x76, 0x33, 0x2f, 0x74, 0x61,
	0x67, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64,
	0x12, 0xac, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65,
	0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0xca, 0x41, 0x1e, 0x0a, 0x06, 0x54, 0x61, 0x67,
	0x4b, 0x65, 0x79, 0x12, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65,
	0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x07, 0x74, 0x61, 0x67, 0x5f,
	0x6b, 0x65, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x16, 0x3a, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x6b,
	0x65, 0x79, 0x22, 0x0b, 0x2f, 0x76, 0x33, 0x2f, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x12,
	0xc9, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x64, 0xca, 0x41, 0x1e, 0x0a, 0x06, 0x54, 0x61, 0x67, 0x4b,
	0x65, 0x79, 0x12, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x74, 0x61, 0x67, 0x5f, 0x6b,
	0x65, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x27, 0x3a, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x32, 0x1c, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa9, 0x01, 0x0a, 0x0c,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x44, 0xca, 0x41, 0x1e, 0x0a, 0x06, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x14,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x16, 0x2a, 0x14, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x61, 0x67,
	0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0x3b, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x3a, 0x01, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x33, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x8d, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x42, 0xda, 0x41,
	0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x3a, 0x01, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x33, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0xb8, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41,
	0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x3a, 0x01, 0x2a, 0x22, 0x2b,
	0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x74, 0x61,
	0x67, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x90, 0x01, 0xca, 0x41,
	0x23, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x67, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0xed,
	0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x42, 0x0c, 0x54, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x33, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x56, 0x33, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5c, 0x56, 0x33, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescOnce sync.Once
	file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescData = file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDesc
)

func file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescGZIP() []byte {
	file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescOnce.Do(func() {
		file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescData)
	})
	return file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDescData
}

var file_google_cloud_resourcemanager_v3_tag_keys_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_resourcemanager_v3_tag_keys_proto_goTypes = []any{
	(Purpose)(0),                             // 0: google.cloud.resourcemanager.v3.Purpose
	(*TagKey)(nil),                           // 1: google.cloud.resourcemanager.v3.TagKey
	(*ListTagKeysRequest)(nil),               // 2: google.cloud.resourcemanager.v3.ListTagKeysRequest
	(*ListTagKeysResponse)(nil),              // 3: google.cloud.resourcemanager.v3.ListTagKeysResponse
	(*GetTagKeyRequest)(nil),                 // 4: google.cloud.resourcemanager.v3.GetTagKeyRequest
	(*GetNamespacedTagKeyRequest)(nil),       // 5: google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
	(*CreateTagKeyRequest)(nil),              // 6: google.cloud.resourcemanager.v3.CreateTagKeyRequest
	(*CreateTagKeyMetadata)(nil),             // 7: google.cloud.resourcemanager.v3.CreateTagKeyMetadata
	(*UpdateTagKeyRequest)(nil),              // 8: google.cloud.resourcemanager.v3.UpdateTagKeyRequest
	(*UpdateTagKeyMetadata)(nil),             // 9: google.cloud.resourcemanager.v3.UpdateTagKeyMetadata
	(*DeleteTagKeyRequest)(nil),              // 10: google.cloud.resourcemanager.v3.DeleteTagKeyRequest
	(*DeleteTagKeyMetadata)(nil),             // 11: google.cloud.resourcemanager.v3.DeleteTagKeyMetadata
	nil,                                      // 12: google.cloud.resourcemanager.v3.TagKey.PurposeDataEntry
	(*timestamppb.Timestamp)(nil),            // 13: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),            // 14: google.protobuf.FieldMask
	(*iampb.GetIamPolicyRequest)(nil),        // 15: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),        // 16: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),  // 17: google.iam.v1.TestIamPermissionsRequest
	(*longrunningpb.Operation)(nil),          // 18: google.longrunning.Operation
	(*iampb.Policy)(nil),                     // 19: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil), // 20: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_resourcemanager_v3_tag_keys_proto_depIdxs = []int32{
	13, // 0: google.cloud.resourcemanager.v3.TagKey.create_time:type_name -> google.protobuf.Timestamp
	13, // 1: google.cloud.resourcemanager.v3.TagKey.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.cloud.resourcemanager.v3.TagKey.purpose:type_name -> google.cloud.resourcemanager.v3.Purpose
	12, // 3: google.cloud.resourcemanager.v3.TagKey.purpose_data:type_name -> google.cloud.resourcemanager.v3.TagKey.PurposeDataEntry
	1,  // 4: google.cloud.resourcemanager.v3.ListTagKeysResponse.tag_keys:type_name -> google.cloud.resourcemanager.v3.TagKey
	1,  // 5: google.cloud.resourcemanager.v3.CreateTagKeyRequest.tag_key:type_name -> google.cloud.resourcemanager.v3.TagKey
	1,  // 6: google.cloud.resourcemanager.v3.UpdateTagKeyRequest.tag_key:type_name -> google.cloud.resourcemanager.v3.TagKey
	14, // 7: google.cloud.resourcemanager.v3.UpdateTagKeyRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 8: google.cloud.resourcemanager.v3.TagKeys.ListTagKeys:input_type -> google.cloud.resourcemanager.v3.ListTagKeysRequest
	4,  // 9: google.cloud.resourcemanager.v3.TagKeys.GetTagKey:input_type -> google.cloud.resourcemanager.v3.GetTagKeyRequest
	5,  // 10: google.cloud.resourcemanager.v3.TagKeys.GetNamespacedTagKey:input_type -> google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
	6,  // 11: google.cloud.resourcemanager.v3.TagKeys.CreateTagKey:input_type -> google.cloud.resourcemanager.v3.CreateTagKeyRequest
	8,  // 12: google.cloud.resourcemanager.v3.TagKeys.UpdateTagKey:input_type -> google.cloud.resourcemanager.v3.UpdateTagKeyRequest
	10, // 13: google.cloud.resourcemanager.v3.TagKeys.DeleteTagKey:input_type -> google.cloud.resourcemanager.v3.DeleteTagKeyRequest
	15, // 14: google.cloud.resourcemanager.v3.TagKeys.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	16, // 15: google.cloud.resourcemanager.v3.TagKeys.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	17, // 16: google.cloud.resourcemanager.v3.TagKeys.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	3,  // 17: google.cloud.resourcemanager.v3.TagKeys.ListTagKeys:output_type -> google.cloud.resourcemanager.v3.ListTagKeysResponse
	1,  // 18: google.cloud.resourcemanager.v3.TagKeys.GetTagKey:output_type -> google.cloud.resourcemanager.v3.TagKey
	1,  // 19: google.cloud.resourcemanager.v3.TagKeys.GetNamespacedTagKey:output_type -> google.cloud.resourcemanager.v3.TagKey
	18, // 20: google.cloud.resourcemanager.v3.TagKeys.CreateTagKey:output_type -> google.longrunning.Operation
	18, // 21: google.cloud.resourcemanager.v3.TagKeys.UpdateTagKey:output_type -> google.longrunning.Operation
	18, // 22: google.cloud.resourcemanager.v3.TagKeys.DeleteTagKey:output_type -> google.longrunning.Operation
	19, // 23: google.cloud.resourcemanager.v3.TagKeys.GetIamPolicy:output_type -> google.iam.v1.Policy
	19, // 24: google.cloud.resourcemanager.v3.TagKeys.SetIamPolicy:output_type -> google.iam.v1.Policy
	20, // 25: google.cloud.resourcemanager.v3.TagKeys.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	17, // [17:26] is the sub-list for method output_type
	8,  // [8:17] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_resourcemanager_v3_tag_keys_proto_init() }
func file_google_cloud_resourcemanager_v3_tag_keys_proto_init() {
	if File_google_cloud_resourcemanager_v3_tag_keys_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_resourcemanager_v3_tag_keys_proto_goTypes,
		DependencyIndexes: file_google_cloud_resourcemanager_v3_tag_keys_proto_depIdxs,
		EnumInfos:         file_google_cloud_resourcemanager_v3_tag_keys_proto_enumTypes,
		MessageInfos:      file_google_cloud_resourcemanager_v3_tag_keys_proto_msgTypes,
	}.Build()
	File_google_cloud_resourcemanager_v3_tag_keys_proto = out.File
	file_google_cloud_resourcemanager_v3_tag_keys_proto_rawDesc = nil
	file_google_cloud_resourcemanager_v3_tag_keys_proto_goTypes = nil
	file_google_cloud_resourcemanager_v3_tag_keys_proto_depIdxs = nil
}
