""" Test oleform basic functionality """

import unittest
from os.path import join
import sys

# Directory with test data, independent of current working directory
from tests.test_utils import DATA_BASE_DIR

from oletools.olevba import VBA_Parser

# TODO: obviously those results are slightly wrong, there is a bug in the oleform parser
# but for now we'll accept those as test results until oleform is fixed (see issue #568)
SAMPLES = [('oleform-PR314.docm',
            [('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 21,
               'caption': 'Label1-test',
               'control_tip_text': None,
               'id': 1,
               'name': 'Label1',
               'tabindex': 0,
               'tag': 'l\x18sdf',
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 23,
               'caption': '',
               'control_tip_text': None,
               'group_name': '',
               'id': 2,
               'name': 'TextBox1',
               'tabindex': 1,
               'tag': None,
               'value': 'heyhey'}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 25,
               'caption': '',
               'control_tip_text': None,
               'group_name': '',
               'id': 3,
               'name': 'ComboBox1',
               'tabindex': 2,
               'tag': None,
               'value': 'none dd'}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 26,
               'caption': '\xba\xa5\x18mouah',
               'control_tip_text': None,
               'group_name': '',
               'id': 5,
               'name': 'CheckBox1',
               'tabindex': 4,
               'tag': None,
               'value': '1'}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 27,
               'caption': '\xba\xa5\x18OptionButt',
               'control_tip_text': None,
               'group_name': '',
               'id': 6,
               'name': 'OptionButton1',
               'tabindex': 5,
               'tag': None,
               'value': '0'}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 28,
               'caption': '\xba\xa5\x18ToggleButt',
               'control_tip_text': None,
               'group_name': '',
               'id': 7,
               'name': 'ToggleButton1',
               'tabindex': 6,
               'tag': None,
               'value': '0'}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 14,
               'caption': None,
               'control_tip_text': None,
               'id': 8,
               'name': 'Frame1',
               'tabindex': 7,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 18,
               'caption': None,
               'control_tip_text': None,
               'id': 10,
               'name': 'TabStrip1',
               'tabindex': 8,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 17,
               'caption': None,
               'control_tip_text': None,
               'id': 9,
               'name': 'CommandButton1',
               'tabindex': 9,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 57,
               'caption': None,
               'control_tip_text': None,
               'id': 12,
               'name': 'MultiPage1',
               'tabindex': 10,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 47,
               'caption': None,
               'control_tip_text': None,
               'id': 16,
               'name': 'ScrollBar1',
               'tabindex': 11,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 16,
               'caption': None,
               'control_tip_text': None,
               'id': 17,
               'name': 'SpinButton1',
               'tabindex': 12,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 12,
               'caption': None,
               'control_tip_text': None,
               'id': 18,
               'name': 'Image1',
               'tabindex': 13,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1',
              {'ClsidCacheIndex': 24,
               'caption': '',
               'control_tip_text': None,
               'group_name': '',
               'id': 4,
               'name': 'ListBox1',
               'tabindex': 3,
               'tag': None,
               'value': ''}),
             ('word/vbaProject.bin',
              u'UserFormTEST1/i08',
              {'ClsidCacheIndex': 23,
               'caption': '',
               'control_tip_text': None,
               'group_name': '',
               'id': 20,
               'name': 'TextBox2',
               'tabindex': 0,
               'tag': None,
               'value': 'abcd'}),
             ('word/vbaProject.bin',
              u'UserFormTEST1/i12',
              {'ClsidCacheIndex': 18,
               'caption': None,
               'control_tip_text': None,
               'id': 13,
               'name': None,
               'tabindex': 2,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1/i12',
              {'ClsidCacheIndex': 7,
               'caption': None,
               'control_tip_text': None,
               'id': 14,
               'name': 'Page1',
               'tabindex': 0,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1/i12',
              {'ClsidCacheIndex': 7,
               'caption': None,
               'control_tip_text': None,
               'id': 15,
               'name': 'Page2',
               'tabindex': 1,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTEST1/i12/i14',
              {'ClsidCacheIndex': 23,
               'caption': '',
               'control_tip_text': None,
               'group_name': '',
               'id': 24,
               'name': 'TextBox3',
               'tabindex': 0,
               'tag': None,
               'value': 'last one'}),
             ('word/vbaProject.bin',
              u'UserFormTest2',
              {'ClsidCacheIndex': 21,
               'caption': 'Label1',
               'control_tip_text': None,
               'id': 1,
               'name': 'Label1',
               'tabindex': 0,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTest2',
              {'ClsidCacheIndex': 21,
               'caption': 'Label2',
               'control_tip_text': None,
               'id': 2,
               'name': 'Label2',
               'tabindex': 1,
               'tag': None,
               'value': None}),
             ('word/vbaProject.bin',
              u'UserFormTest2',
              {'ClsidCacheIndex': 23,
               'caption': '',
               'control_tip_text': None,
               'group_name': '',
               'id': 3,
               'name': 'TextBox1',
               'tabindex': 2,
               'tag': None,
               'value': '&\xe9"\''})]
            )]

class TestOleForm(unittest.TestCase):

    def test_samples(self):
        if sys.version_info[0] > 2:
             # Unfortunately, olevba3 doesn't have extract_form_strings_extended
             return
        for sample, expected_result in SAMPLES:
            full_name = join(DATA_BASE_DIR, 'oleform', sample)
            parser = VBA_Parser(full_name)
            variables = list(parser.extract_form_strings_extended())
            self.assertEqual(variables, expected_result)


# just in case somebody calls this file as a script
if __name__ == '__main__':
    unittest.main()

