// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/model_garden_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ModelGardenService_GetPublisherModel_FullMethodName                 = "/google.cloud.aiplatform.v1beta1.ModelGardenService/GetPublisherModel"
	ModelGardenService_ListPublisherModels_FullMethodName               = "/google.cloud.aiplatform.v1beta1.ModelGardenService/ListPublisherModels"
	ModelGardenService_Deploy_FullMethodName                            = "/google.cloud.aiplatform.v1beta1.ModelGardenService/Deploy"
	ModelGardenService_DeployPublisherModel_FullMethodName              = "/google.cloud.aiplatform.v1beta1.ModelGardenService/DeployPublisherModel"
	ModelGardenService_ExportPublisherModel_FullMethodName              = "/google.cloud.aiplatform.v1beta1.ModelGardenService/ExportPublisherModel"
	ModelGardenService_CheckPublisherModelEulaAcceptance_FullMethodName = "/google.cloud.aiplatform.v1beta1.ModelGardenService/CheckPublisherModelEulaAcceptance"
	ModelGardenService_AcceptPublisherModelEula_FullMethodName          = "/google.cloud.aiplatform.v1beta1.ModelGardenService/AcceptPublisherModelEula"
)

// ModelGardenServiceClient is the client API for ModelGardenService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ModelGardenServiceClient interface {
	// Gets a Model Garden publisher model.
	GetPublisherModel(ctx context.Context, in *GetPublisherModelRequest, opts ...grpc.CallOption) (*PublisherModel, error)
	// Lists publisher models in Model Garden.
	ListPublisherModels(ctx context.Context, in *ListPublisherModelsRequest, opts ...grpc.CallOption) (*ListPublisherModelsResponse, error)
	// Deploys a model to a new endpoint.
	Deploy(ctx context.Context, in *DeployRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deploys publisher models.
	DeployPublisherModel(ctx context.Context, in *DeployPublisherModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports a publisher model to a user provided Google Cloud Storage bucket.
	ExportPublisherModel(ctx context.Context, in *ExportPublisherModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Checks the EULA acceptance status of a publisher model.
	CheckPublisherModelEulaAcceptance(ctx context.Context, in *CheckPublisherModelEulaAcceptanceRequest, opts ...grpc.CallOption) (*PublisherModelEulaAcceptance, error)
	// Accepts the EULA acceptance status of a publisher model.
	AcceptPublisherModelEula(ctx context.Context, in *AcceptPublisherModelEulaRequest, opts ...grpc.CallOption) (*PublisherModelEulaAcceptance, error)
}

type modelGardenServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelGardenServiceClient(cc grpc.ClientConnInterface) ModelGardenServiceClient {
	return &modelGardenServiceClient{cc}
}

func (c *modelGardenServiceClient) GetPublisherModel(ctx context.Context, in *GetPublisherModelRequest, opts ...grpc.CallOption) (*PublisherModel, error) {
	out := new(PublisherModel)
	err := c.cc.Invoke(ctx, ModelGardenService_GetPublisherModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelGardenServiceClient) ListPublisherModels(ctx context.Context, in *ListPublisherModelsRequest, opts ...grpc.CallOption) (*ListPublisherModelsResponse, error) {
	out := new(ListPublisherModelsResponse)
	err := c.cc.Invoke(ctx, ModelGardenService_ListPublisherModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelGardenServiceClient) Deploy(ctx context.Context, in *DeployRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelGardenService_Deploy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *modelGardenServiceClient) DeployPublisherModel(ctx context.Context, in *DeployPublisherModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelGardenService_DeployPublisherModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelGardenServiceClient) ExportPublisherModel(ctx context.Context, in *ExportPublisherModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelGardenService_ExportPublisherModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelGardenServiceClient) CheckPublisherModelEulaAcceptance(ctx context.Context, in *CheckPublisherModelEulaAcceptanceRequest, opts ...grpc.CallOption) (*PublisherModelEulaAcceptance, error) {
	out := new(PublisherModelEulaAcceptance)
	err := c.cc.Invoke(ctx, ModelGardenService_CheckPublisherModelEulaAcceptance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelGardenServiceClient) AcceptPublisherModelEula(ctx context.Context, in *AcceptPublisherModelEulaRequest, opts ...grpc.CallOption) (*PublisherModelEulaAcceptance, error) {
	out := new(PublisherModelEulaAcceptance)
	err := c.cc.Invoke(ctx, ModelGardenService_AcceptPublisherModelEula_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelGardenServiceServer is the server API for ModelGardenService service.
// All implementations should embed UnimplementedModelGardenServiceServer
// for forward compatibility
type ModelGardenServiceServer interface {
	// Gets a Model Garden publisher model.
	GetPublisherModel(context.Context, *GetPublisherModelRequest) (*PublisherModel, error)
	// Lists publisher models in Model Garden.
	ListPublisherModels(context.Context, *ListPublisherModelsRequest) (*ListPublisherModelsResponse, error)
	// Deploys a model to a new endpoint.
	Deploy(context.Context, *DeployRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deploys publisher models.
	DeployPublisherModel(context.Context, *DeployPublisherModelRequest) (*longrunningpb.Operation, error)
	// Exports a publisher model to a user provided Google Cloud Storage bucket.
	ExportPublisherModel(context.Context, *ExportPublisherModelRequest) (*longrunningpb.Operation, error)
	// Checks the EULA acceptance status of a publisher model.
	CheckPublisherModelEulaAcceptance(context.Context, *CheckPublisherModelEulaAcceptanceRequest) (*PublisherModelEulaAcceptance, error)
	// Accepts the EULA acceptance status of a publisher model.
	AcceptPublisherModelEula(context.Context, *AcceptPublisherModelEulaRequest) (*PublisherModelEulaAcceptance, error)
}

// UnimplementedModelGardenServiceServer should be embedded to have forward compatible implementations.
type UnimplementedModelGardenServiceServer struct {
}

func (UnimplementedModelGardenServiceServer) GetPublisherModel(context.Context, *GetPublisherModelRequest) (*PublisherModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublisherModel not implemented")
}
func (UnimplementedModelGardenServiceServer) ListPublisherModels(context.Context, *ListPublisherModelsRequest) (*ListPublisherModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPublisherModels not implemented")
}
func (UnimplementedModelGardenServiceServer) Deploy(context.Context, *DeployRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Deploy not implemented")
}
func (UnimplementedModelGardenServiceServer) DeployPublisherModel(context.Context, *DeployPublisherModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployPublisherModel not implemented")
}
func (UnimplementedModelGardenServiceServer) ExportPublisherModel(context.Context, *ExportPublisherModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportPublisherModel not implemented")
}
func (UnimplementedModelGardenServiceServer) CheckPublisherModelEulaAcceptance(context.Context, *CheckPublisherModelEulaAcceptanceRequest) (*PublisherModelEulaAcceptance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckPublisherModelEulaAcceptance not implemented")
}
func (UnimplementedModelGardenServiceServer) AcceptPublisherModelEula(context.Context, *AcceptPublisherModelEulaRequest) (*PublisherModelEulaAcceptance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcceptPublisherModelEula not implemented")
}

// UnsafeModelGardenServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ModelGardenServiceServer will
// result in compilation errors.
type UnsafeModelGardenServiceServer interface {
	mustEmbedUnimplementedModelGardenServiceServer()
}

func RegisterModelGardenServiceServer(s grpc.ServiceRegistrar, srv ModelGardenServiceServer) {
	s.RegisterService(&ModelGardenService_ServiceDesc, srv)
}

func _ModelGardenService_GetPublisherModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublisherModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).GetPublisherModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_GetPublisherModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).GetPublisherModel(ctx, req.(*GetPublisherModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelGardenService_ListPublisherModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPublisherModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).ListPublisherModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_ListPublisherModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).ListPublisherModels(ctx, req.(*ListPublisherModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelGardenService_Deploy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).Deploy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_Deploy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).Deploy(ctx, req.(*DeployRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelGardenService_DeployPublisherModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployPublisherModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).DeployPublisherModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_DeployPublisherModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).DeployPublisherModel(ctx, req.(*DeployPublisherModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelGardenService_ExportPublisherModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportPublisherModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).ExportPublisherModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_ExportPublisherModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).ExportPublisherModel(ctx, req.(*ExportPublisherModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelGardenService_CheckPublisherModelEulaAcceptance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckPublisherModelEulaAcceptanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).CheckPublisherModelEulaAcceptance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_CheckPublisherModelEulaAcceptance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).CheckPublisherModelEulaAcceptance(ctx, req.(*CheckPublisherModelEulaAcceptanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelGardenService_AcceptPublisherModelEula_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcceptPublisherModelEulaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).AcceptPublisherModelEula(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_AcceptPublisherModelEula_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).AcceptPublisherModelEula(ctx, req.(*AcceptPublisherModelEulaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ModelGardenService_ServiceDesc is the grpc.ServiceDesc for ModelGardenService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ModelGardenService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.ModelGardenService",
	HandlerType: (*ModelGardenServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPublisherModel",
			Handler:    _ModelGardenService_GetPublisherModel_Handler,
		},
		{
			MethodName: "ListPublisherModels",
			Handler:    _ModelGardenService_ListPublisherModels_Handler,
		},
		{
			MethodName: "Deploy",
			Handler:    _ModelGardenService_Deploy_Handler,
		},
		{
			MethodName: "DeployPublisherModel",
			Handler:    _ModelGardenService_DeployPublisherModel_Handler,
		},
		{
			MethodName: "ExportPublisherModel",
			Handler:    _ModelGardenService_ExportPublisherModel_Handler,
		},
		{
			MethodName: "CheckPublisherModelEulaAcceptance",
			Handler:    _ModelGardenService_CheckPublisherModelEulaAcceptance_Handler,
		},
		{
			MethodName: "AcceptPublisherModelEula",
			Handler:    _ModelGardenService_AcceptPublisherModelEula_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/model_garden_service.proto",
}
