%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/overriding-articulations-by-type.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from `Documentation/snippets/new/`.
%%
%% Make any changes in `Documentation/snippets/new/`,
%% then run `scripts/auxiliar/makelsr.pl --new`.
%%
%% This file is in the public domain.
%%
%% Note: this file works from version 2.23.6.

\version "2.23.13"

\header {
%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
On peut parfois vouloir modifier un seul type d'articulation. Bien que
ce soit tout à fait faisable avec un @code{\\tweak}, cela devient vite
fastidieux d'affiner chaque occurrence d'un même signe dans toute une
partition. Le code ci-dessous illustre la manière de modifier des
articulations grâce à une liste de réglages personnalisés. Ceci peut
servir à créer des feuilles de style.

La fonction @code{\\customScripts} ici proposée peut se placer, depuis
la version 2.16.2, dans un bloc @code{\\layout}.
"

  doctitlefr = "Personnalisation de certains types d'articulation"

%% Translation of GIT committish: 98ac53591234404cd70c5eebd370a598ec74095b
  texidocca = "
A vegades volem modificar un sol temps d'articulació.  Tot i que
sempre és possible usar l'ordre @code{\\tweak}, podria fer-se tediós
fer-lo per a tots i cada un dels símbols d'una partitura completa.
L'exemple mostra com ajustar articulacions amb una llista
d'ajustaments personalitzats.  Un cas seria la creació d'un full d'estils.

Amb 2.16.2 és possible introduir la funció proposada,
@code{\\customScripts}, en un bloc @code{\\layout}.

"
  doctitleca = "Modificació d'articulacions de diversos tipus"

  lsrtags = "scheme-language, tweaks-and-overrides"

  texidoc = "
Sometimes you may want to affect a single articulation-type. Although
it is always possible to use @code{\\tweak}, it might become tedious to
do so for every single sign of a whole score. The following shows how
to tweak articulations with a list of custom settings. One use-case
might be to create a style sheet.

With 2.16.2 and above it is possible to put the proposed function,
@code{\\customScripts}, into a @code{\\layout}-block.
"

  doctitle = "Overriding articulations by type"
} % begin verbatim


% Code by David Nalesnik and Thomas Morley

#(define (custom-script-tweaks ls)
  (lambda (grob)
    (let* ((type (ly:event-property
                    (ly:grob-property grob 'cause)
                    'articulation-type))
           (tweaks (assoc-ref ls type)))
      (if tweaks
          (for-each
            (lambda (x) (ly:grob-set-property! grob (car x) (cdr x)))
            tweaks)))))

customScripts =
#(define-music-function (settings) (list?)
#{
  \override Script.before-line-breaking =
    #(custom-script-tweaks settings)
#})

revertCustomScripts = \revert Script.before-line-breaking

%%%%%%%%%%%%%
% Example:
%%%%%%%%%%%%%

% Predefine a list of desired tweaks.
#(define my-settings-1
  '(
    (staccato . ((color . (1 0 0))
                 (padding . 0.5)))
    (accent . ((font-size . 0)
               (color . (1 0 0))))
    (tenuto . ((rotation . (45 0 0))
               (padding . 2)
               (font-size . 10)))
    (staccatissimo . ((padding . 1)
                      (color . (1 0 0))))
    (segno . ((font-size . 0)
              (color . (1 0 0))))
    ))

#(define my-settings-2
  '(
    (staccato . ((color . (0 1 0))))
    (accent . ((font-size . 4)
               (color . (0 1 0))
               (padding . 1.5)))
    (tenuto . ((font-size . 10)))
    (staccatissimo . ((padding . 2)
                      (color . (0 1 0))))
    (coda . ((color . (0 1 0))
             (padding . 1)))
    ))

one =
\relative c'' {
  f1--
  \customScripts #my-settings-1
  f-. f-! f-> f-- f-!\segno
  \revertCustomScripts
  f-> f-.
}

two =
\relative c' {
  f1--
  \customScripts #my-settings-2
  f-. f-! f-> f---> f-!
  f-> f-.\coda
}

\new Staff <<
   \new Voice { \voiceOne \one }
   \new Voice { \voiceTwo \two }
   >>



% ****************************************************************
% end ly snippet
% ****************************************************************
